/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class PropertyNameSearchRequestor {
    public static final int PROPERTY_RELEVANCE = 10;
    protected JavaElementImageProvider imageProvider;
    protected Map<String, IMethod> methods;
    protected ContentAssistRequest request;
    private String prefix;
    private boolean attrAtLocationHasValue;
    private String namespacePrefix = "";

    public PropertyNameSearchRequestor(ContentAssistRequest request, String prefix, boolean attrAtLocationHasValue, String nameSpacePrefix) {
        this.request = request;
        this.methods = new HashMap<String, IMethod>();
        this.imageProvider = new JavaElementImageProvider();
        this.prefix = prefix;
        this.attrAtLocationHasValue = attrAtLocationHasValue;
        if (nameSpacePrefix != null) {
            this.namespacePrefix = String.valueOf(nameSpacePrefix) + ":";
        }
    }

    public void acceptSearchMatch(IMethod method, boolean external) throws CoreException {
        int parameterCount = method.getNumberOfParameters();
        String returnType = method.getReturnType();
        if (Flags.isPublic((int)method.getFlags()) && !Flags.isInterface((int)method.getFlags()) && parameterCount == 1 && "V".equals(returnType) && method.exists() && ((IType)method.getParent()).isClass() && !method.isConstructor()) {
            this.createMethodProposal(method, external);
        }
    }

    protected void createMethodProposal(IMethod method, boolean external) {
        try {
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString((IMethod)method);
            String key = String.valueOf(method.getElementName()) + method.getSignature();
            if (!this.methods.containsKey(key)) {
                String propertyName = JdtUtils.getPropertyNameFromMethodName((IMethod)method);
                String replaceText = String.valueOf(this.namespacePrefix) + this.prefix + propertyName;
                StringBuffer buf = new StringBuffer();
                buf.append(" - ");
                buf.append(method.getParent().getElementName());
                buf.append('.');
                buf.append(method.getElementName());
                buf.append('(');
                buf.append(parameterTypes[0]);
                buf.append(' ');
                buf.append(parameterNames[0]);
                buf.append(')');
                String displayText = buf.toString();
                Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
                int cursor = replaceText.length();
                String refReplaceText = String.valueOf(replaceText) + "-ref";
                if (!this.attrAtLocationHasValue) {
                    replaceText = String.valueOf(replaceText) + "=\"\"";
                    cursor = replaceText.length() - 1;
                } else {
                    cursor = replaceText.length() + 2;
                }
                CustomCompletionProposal proposal1 = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition(), this.request.getReplacementLength(), cursor, image, String.valueOf(this.namespacePrefix) + propertyName + displayText, null, null, 10);
                if (!this.attrAtLocationHasValue) {
                    refReplaceText = String.valueOf(refReplaceText) + "=\"\"";
                    cursor = refReplaceText.length() - 1;
                } else {
                    cursor = refReplaceText.length() + 2;
                }
                image = BeansModelImages.getDecoratedImage((Image)image, (int)8);
                CustomCompletionProposal proposal2 = new CustomCompletionProposal(refReplaceText, this.request.getReplacementBeginPosition(), this.request.getReplacementLength(), cursor, image, String.valueOf(this.namespacePrefix) + propertyName + "-ref" + displayText, null, null, 10);
                this.request.addProposal((ICompletionProposal)proposal1);
                this.request.addProposal((ICompletionProposal)proposal2);
                this.methods.put(key, method);
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

