/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.contentassist;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.JavaCompatibleBuffer;
import org.eclipse.ajdt.core.model.AJWorldFacade;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;

public class ProposalRequestorWrapper
extends CompletionRequestor {
    CompletionRequestor wrapped;
    ArrayList insertionTable;
    private AJWorldFacade world;
    private ICompilationUnit unit;
    private final String contextSwitchIdentifier;

    public ProposalRequestorWrapper(CompletionRequestor wrapped, ICompilationUnit unit, JavaCompatibleBuffer buffer, String contextSwitchIdentifier) {
        this.wrapped = wrapped;
        this.unit = unit;
        this.insertionTable = buffer.getInsertionTable();
        this.contextSwitchIdentifier = contextSwitchIdentifier == null || contextSwitchIdentifier.length() == 0 ? null : contextSwitchIdentifier;
    }

    public ProposalRequestorWrapper(CompletionRequestor wrapped, ICompilationUnit unit, ArrayList insertionTable) {
        this.wrapped = wrapped;
        this.unit = unit;
        this.insertionTable = insertionTable;
        this.contextSwitchIdentifier = null;
    }

    public void accept(CompletionProposal proposal) {
        if (!this.shouldAccept(proposal)) {
            return;
        }
        if (this.insertionTable.size() > 0) {
            this.translateReplaceRange(proposal);
        }
        this.wrapped.accept(proposal);
    }

    private void translateReplaceRange(CompletionProposal proposal) {
        InternalCompletionProposal internalProposal;
        int s = proposal.getReplaceStart();
        int e = proposal.getReplaceEnd();
        proposal.setReplaceRange(this.trans(s), this.trans(e));
        if (proposal instanceof InternalCompletionProposal && (internalProposal = (InternalCompletionProposal)proposal).getRequiredProposals() != null) {
            int i = 0;
            while (i < internalProposal.getRequiredProposals().length) {
                this.translateReplaceRange(internalProposal.getRequiredProposals()[i]);
                ++i;
            }
        }
    }

    protected boolean shouldAccept(CompletionProposal proposal) {
        char[] typeName;
        if (proposal.getKind() == 2 || proposal.getKind() == 6) {
            AJWorldFacade.ITDInfo info;
            if (this.world == null) {
                this.world = new AJWorldFacade(this.unit.getJavaProject().getProject());
            }
            if ((info = this.world.findITDInfoFromTargetType(proposal.getDeclarationSignature(), proposal.getName())) != null) {
                if (info.accessibility == IProgramElement.Accessibility.PUBLIC) {
                    return true;
                }
                if (info.accessibility == IProgramElement.Accessibility.PACKAGE) {
                    if (((IPackageFragment)this.unit.getParent()).getElementName().equals(info.packageDeclaredIn)) {
                        int oldFlags = proposal.getFlags();
                        oldFlags |= 0;
                        proposal.setFlags(oldFlags &= 0xFFFFFFFE);
                        return true;
                    }
                } else if (info.accessibility == IProgramElement.Accessibility.PRIVATE && this.unit.getElementName().startsWith(String.valueOf(info.topLevelAspectName) + ".") && ((IPackageFragment)this.unit.getParent()).getElementName().equals(info.packageDeclaredIn)) {
                    int oldFlags = proposal.getFlags();
                    oldFlags |= 2;
                    proposal.setFlags(oldFlags &= 0xFFFFFFFE);
                    return true;
                }
                return false;
            }
            return true;
        }
        return !(proposal.getKind() == 5 ? this.contextSwitchIgnore(proposal) : proposal.getKind() == 9 && (typeName = (char[])ReflectionUtils.getPrivateField(InternalCompletionProposal.class, "typeName", (InternalCompletionProposal)proposal)) != null && CharOperation.contains((char)'$', (char[])typeName));
    }

    private boolean contextSwitchIgnore(CompletionProposal proposal) {
        return this.contextSwitchIdentifier != null && new String(proposal.getCompletion()).startsWith(this.contextSwitchIdentifier);
    }

    private int trans(int pos) {
        return AspectsConvertingParser.translatePositionToBeforeChanges(pos, this.insertionTable);
    }

    public void acceptContext(CompletionContext context) {
        this.wrapped.acceptContext(context);
    }

    public void endReporting() {
        this.wrapped.endReporting();
    }

    public void beginReporting() {
        this.wrapped.beginReporting();
    }

    public void completionFailure(IProblem problem) {
        this.wrapped.completionFailure(problem);
    }

    public String[] getFavoriteReferences() {
        return this.wrapped.getFavoriteReferences();
    }

    public boolean isAllowingRequiredProposals(int proposalKind, int requiredProposalKind) {
        return this.wrapped.isAllowingRequiredProposals(proposalKind, requiredProposalKind);
    }

    public boolean isExtendedContextRequired() {
        return this.wrapped.isExtendedContextRequired();
    }

    public boolean isIgnored(int completionProposalKind) {
        return this.wrapped.isIgnored(completionProposalKind);
    }

    public void setAllowsRequiredProposals(int proposalKind, int requiredProposalKind, boolean allow) {
        this.wrapped.setAllowsRequiredProposals(proposalKind, requiredProposalKind, allow);
    }

    public void setFavoriteReferences(String[] favoriteImports) {
        this.wrapped.setFavoriteReferences(favoriteImports);
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        this.wrapped.setIgnored(completionProposalKind, ignore);
    }

    public void setRequireExtendedContext(boolean require) {
        this.wrapped.setRequireExtendedContext(require);
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

