/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf.core;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.event.ValueChangeListener;

public final class ValueChangeListenerHandler
extends TagHandler {
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");

    public ValueChangeListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof EditableValueHolder) {
            if (parent.getParent() == null) {
                EditableValueHolder evh = (EditableValueHolder)parent;
                ValueChangeListener listener = null;
                ValueExpression ve = null;
                if (this.binding != null) {
                    ve = this.binding.getValueExpression(ctx, ValueChangeListener.class);
                    listener = (ValueChangeListener)ve.getValue((ELContext)ctx);
                }
                if (listener == null && this.listenerType != null) {
                    try {
                        listener = (ValueChangeListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, (Throwable)e);
                    }
                    if (ve != null) {
                        ve.setValue((ELContext)ctx, (Object)ve);
                    }
                } else {
                    throw new TagAttributeException(this.tag, this.binding, "Binding evaluated to null, and there wasn't a 'type' Attribute Specified");
                }
                evh.addValueChangeListener(listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type EditableValueHolder, type is: " + parent);
        }
    }
}

