/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.commons.bamboo.PlanState;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BambooBuildInfo
implements BambooBuild {
    private final Date pollingTime;
    private final ConnectionCfg server;
    @Nullable
    private final String projectName;
    @Nullable
    private final String projectKey;
    private final String planName;
    @NotNull
    private final String planKey;
    @Nullable
    private final String masterPlanKey;
    private final boolean enabled;
    @NotNull
    private final BuildStatus status;
    @Nullable
    private final Integer number;
    @Nullable
    private final String reason;
    private final String relativeBuildDate;
    @Nullable
    private final String durationDescription;
    private final String testSummary;
    private final String commitComment;
    private final int testsPassedCount;
    private final int testsFailedCount;
    private final Throwable exception;
    private final String errorMessage;
    @Nullable
    private final Date startDate;
    private final Date completionDate;
    private final Set<String> commiters;
    @Nullable
    private final PlanState planState;

    public BambooBuildInfo(@NotNull String planKey, @Nullable String planName, @Nullable String masterPlanKey, @NotNull ConnectionCfg serverData, @NotNull Date pollingTime, @Nullable String projectName, boolean isEnabled, @Nullable Integer number, @NotNull BuildStatus status, @Nullable PlanState planState, @Nullable String reason, @Nullable Date startDate, @Nullable String testSummary, @Nullable String commitComment, int testsPassedCount, int testsFailedCount, @Nullable Date completionDate, @Nullable String errorMessage, Throwable exception, @Nullable String relativeBuildDate, @Nullable String durationDescription, @Nullable Collection<String> commiters) {
        this.masterPlanKey = masterPlanKey;
        String[] split = planKey.split("-");
        this.projectKey = split.length > 0 ? split[0] : null;
        this.exception = exception;
        this.pollingTime = new Date(pollingTime.getTime());
        this.planKey = planKey;
        this.planName = planName;
        this.planState = planState;
        this.server = serverData;
        this.projectName = projectName;
        this.enabled = isEnabled;
        this.number = number;
        this.status = status;
        this.reason = reason;
        this.testSummary = testSummary;
        this.commitComment = commitComment;
        this.testsPassedCount = testsPassedCount;
        this.testsFailedCount = testsFailedCount;
        this.errorMessage = errorMessage;
        this.relativeBuildDate = relativeBuildDate;
        this.durationDescription = durationDescription;
        this.startDate = startDate != null ? new Date(startDate.getTime()) : null;
        this.completionDate = completionDate != null ? new Date(completionDate.getTime()) : null;
        this.commiters = commiters != null ? new TreeSet<String>(commiters) : new HashSet<String>();
    }

    @Override
    public ConnectionCfg getServer() {
        return this.server;
    }

    @Override
    @Nullable
    public Date getCompletionDate() {
        return this.completionDate == null ? null : new Date(this.completionDate.getTime());
    }

    @Override
    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    @Nullable
    public String getMasterPlanKey() {
        return this.masterPlanKey;
    }

    @Override
    public String getServerUrl() {
        return this.server.getUrl();
    }

    @Override
    public String getBuildUrl() {
        return String.valueOf(this.getServerUrl()) + "/browse/" + this.planKey;
    }

    @Override
    public String getResultUrl() {
        String url = String.valueOf(this.getServerUrl()) + "/browse/" + this.planKey;
        if (this.getStatus() != BuildStatus.UNKNOWN && this.number != null) {
            url = String.valueOf(url) + "-" + this.number;
        }
        return url;
    }

    @Override
    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getPlanName() {
        return this.planName;
    }

    @Override
    @NotNull
    public String getPlanKey() {
        return this.planKey;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isValid() {
        return this.number != null;
    }

    @Override
    public int getNumber() throws UnsupportedOperationException {
        if (this.number == null) {
            throw new UnsupportedOperationException("This build has no number information");
        }
        return this.number;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getRelativeBuildDate() {
        return this.relativeBuildDate;
    }

    @Override
    @Nullable
    public String getDurationDescription() {
        return this.durationDescription;
    }

    @Override
    public String getTestSummary() {
        return this.testSummary;
    }

    public String getCommitComment() {
        return this.commitComment;
    }

    @Override
    @NotNull
    public BuildStatus getStatus() {
        return this.status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public int getTestsPassed() {
        return this.testsPassedCount;
    }

    @Override
    public int getTestsFailed() {
        return this.testsFailedCount;
    }

    @Override
    @Nullable
    public Date getStartDate() {
        return this.startDate != null ? new Date(this.startDate.getTime()) : null;
    }

    public String toString() {
        return String.valueOf(this.projectName) + " " + this.planName + " " + this.planKey + " " + (Object)((Object)this.status) + " " + this.reason + " " + this.startDate + " " + this.durationDescription + " " + this.testSummary + " " + this.commitComment;
    }

    @Override
    public boolean isMyBuild() {
        return this.commiters.contains(this.server.getUsername());
    }

    @Override
    public Set<String> getCommiters() {
        return this.commiters;
    }

    @Override
    @NotNull
    public Date getPollingTime() {
        return new Date(this.pollingTime.getTime());
    }

    @Override
    @Nullable
    public PlanState getPlanState() {
        return this.planState;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + this.planKey.hashCode();
        result = 31 * result + (this.planName == null ? 0 : this.planName.hashCode());
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BambooBuildInfo other = (BambooBuildInfo)obj;
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        if (!this.planKey.equals(other.planKey)) {
            return false;
        }
        if (this.planName == null ? other.planName != null : !this.planName.equals(other.planName)) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        return !(this.server == null ? other.server != null : !this.server.equals(other.server));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final String planKey;
        private final String planName;
        @Nullable
        private String masterPlanKey;
        private final ConnectionCfg serverData;
        private final String projectName;
        private final Integer buildNumber;
        @NotNull
        private final BuildStatus buildState;
        private boolean isEnabled = true;
        private String message;
        private Date startTime;
        private Collection<String> commiters;
        @NotNull
        private Date pollingTime = new Date();
        private String buildReason;
        @Nullable
        private String testSummary;
        @Nullable
        private String commitComment;
        private int testsPassedCount;
        private int testsFailedCount;
        private Date completionTime;
        @Nullable
        private String relativeBuildDate;
        @Nullable
        private String durationDescription;
        private Throwable exception;
        @Nullable
        private PlanState planState;

        public Builder(@NotNull String planKey, @NotNull ConnectionCfg serverData, @NotNull BuildStatus state) {
            this.planKey = planKey;
            this.serverData = serverData;
            this.buildState = state;
            this.planName = null;
            this.projectName = null;
            this.buildNumber = null;
        }

        public Builder(@NotNull String planKey, @Nullable String planName, @NotNull ConnectionCfg serverData, @Nullable String projectName, @Nullable Integer buildNumber, @NotNull BuildStatus state) {
            this.planKey = planKey;
            this.planName = planName;
            this.serverData = serverData;
            this.projectName = projectName;
            this.buildNumber = buildNumber;
            this.buildState = state;
        }

        public Builder masterPlanKey(String aMasterPlanKey) {
            this.masterPlanKey = aMasterPlanKey;
            return this;
        }

        public Builder enabled(boolean aIsEnabled) {
            this.isEnabled = aIsEnabled;
            return this;
        }

        public Builder reason(String aReason) {
            this.buildReason = aReason;
            return this;
        }

        public Builder errorMessage(String aMessage) {
            this.message = aMessage;
            return this;
        }

        public Builder errorMessage(String aMessage, Throwable aException) {
            this.message = aMessage;
            this.exception = aException;
            return this;
        }

        public Builder startTime(Date aStartTime) {
            this.startTime = aStartTime;
            return this;
        }

        public Builder completionTime(Date aCompletionTime) {
            this.completionTime = aCompletionTime;
            return this;
        }

        public Builder commiters(Collection<String> aCommiters) {
            this.commiters = aCommiters;
            return this;
        }

        public Builder testSummary(@Nullable String aTestSummary) {
            this.testSummary = aTestSummary;
            return this;
        }

        public Builder commitComment(@Nullable String aCommitComment) {
            this.commitComment = aCommitComment;
            return this;
        }

        public Builder pollingTime(@NotNull Date aPollingTime) {
            this.pollingTime = aPollingTime;
            return this;
        }

        public Builder testsPassedCount(int aTestsPassedCount) {
            this.testsPassedCount = aTestsPassedCount;
            return this;
        }

        public Builder testsFailedCount(int aTestsFailedCount) {
            this.testsFailedCount = aTestsFailedCount;
            return this;
        }

        public Builder relativeBuildDate(@Nullable String aRelativeBuildDate) {
            this.relativeBuildDate = aRelativeBuildDate;
            return this;
        }

        public Builder durationDescription(@Nullable String aDurationDescription) {
            this.durationDescription = aDurationDescription;
            return this;
        }

        public Builder planState(PlanState aPlanState) {
            this.planState = aPlanState;
            return this;
        }

        public BambooBuildInfo build() {
            return new BambooBuildInfo(this.planKey, this.planName, this.masterPlanKey, this.serverData, this.pollingTime, this.projectName, this.isEnabled, this.buildNumber, this.buildState, this.planState, this.buildReason, this.startTime, this.testSummary, this.commitComment, this.testsPassedCount, this.testsFailedCount, this.completionTime, this.message, this.exception, this.relativeBuildDate, this.durationDescription, this.commiters);
        }
    }
}

