/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.TreeConflictsView;

public class SVNMarkerListener
implements IResourceStateChangeListener {
    private boolean treeConflictsViewRefreshed;

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        int i = 0;
        while (i < changedResources.length) {
            try {
                if (changedResources[i].exists()) {
                    changedResources[i].deleteMarkers("org.tigris.subversion.subclipse.ui.conflictMarker", true, 0);
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)changedResources[i]);
                    LocalResourceStatus status = svnResource.getStatus();
                    if (status.isTextConflicted() || status.isPropConflicted() || status.hasTreeConflict()) {
                        try {
                            IMarker marker = changedResources[i].createMarker("org.tigris.subversion.subclipse.ui.conflictMarker");
                            this.setMessage(status, marker);
                            marker.setAttribute("severity", 1);
                            marker.setAttribute("textConflict", status.isTextConflicted());
                            marker.setAttribute("propertyConflict", status.isPropConflicted());
                            marker.setAttribute("treeConflict", status.hasTreeConflict());
                        }
                        catch (Exception e) {
                            SVNUIPlugin.log(e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                SVNUIPlugin.log(e.getMessage());
            }
            ++i;
        }
        if (!this.treeConflictsViewRefreshed) {
            this.treeConflictsViewRefreshed = TreeConflictsView.refresh(changedResources);
        }
    }

    private void setMessage(LocalResourceStatus status, IMarker marker) throws CoreException {
        int count = 0;
        if (status.isTextConflicted()) {
            ++count;
        }
        if (status.isPropConflicted()) {
            ++count;
        }
        if (status.hasTreeConflict()) {
            ++count;
        }
        StringBuffer message = new StringBuffer(String.valueOf(Policy.bind("SVNConflicts")) + " (");
        if (status.isTextConflicted()) {
            message.append("Text");
            if (count == 2) {
                message.append(" and ");
            }
            if (count == 3) {
                message.append(", ");
            }
        }
        if (status.isPropConflicted()) {
            message.append("Property");
            if (count == 3) {
                message.append(" and ");
            }
        }
        if (status.hasTreeConflict()) {
            message.append("Tree");
        }
        if (count == 1) {
            message.append(" Conflict");
        } else {
            message.append(" Conflicts");
        }
        message.append(")");
        marker.setAttribute("message", (Object)message.toString());
    }

    public void resourceModified(IResource[] changedResources) {
    }

    public void projectConfigured(IProject project) {
    }

    public void projectDeconfigured(IProject project) {
    }

    public void initialize() {
        this.treeConflictsViewRefreshed = false;
    }
}

