/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph;

import java.util.List;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.commands.FixedConnectionCreateCommand;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.IntegrationDiagram;
import org.w3c.dom.Node;

public class FixedConnectionChannelCreateCommand
extends FixedConnectionCreateCommand {
    private final ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    private IDOMElement parentElement;
    private String inputName;

    public FixedConnectionChannelCreateCommand(ITextEditor textEditor, int lineStyle) {
        super(textEditor, lineStyle);
    }

    protected void createNewElement() {
        if (this.parentElement != null) {
            IDOMDocument document = (IDOMDocument)this.parentElement.getOwnerDocument();
            IDOMElement childElement = (IDOMElement)document.createElement(this.inputName);
            IDOMModel model = document.getModel();
            if (model != null) {
                model.beginRecording((Object)this);
                this.parentElement.appendChild((Node)childElement);
                this.processor.insertDefaultAttributes(childElement);
                this.id = String.valueOf(IntegrationSchemaConstants.ELEM_CHANNEL) + ((IntegrationDiagram)this.source.getDiagram()).getNewChannelId();
                childElement.setAttribute(IntegrationSchemaConstants.ATTR_ID, this.id);
                this.formatter.formatNode((Node)childElement);
                this.formatter.formatNode(childElement.getParentNode());
                this.sourceElement.setAttribute(this.sourceAnchor.getConnectionLabel(), this.id);
                this.targetElement.setAttribute(this.targetAnchor.getConnectionLabel(), this.id);
                model.endRecording((Object)this);
            }
        }
    }

    protected boolean doesCreateNewElement() {
        Node parent = this.sourceElement.getParentNode();
        if (parent instanceof IDOMElement) {
            List children;
            this.parentElement = (IDOMElement)parent;
            this.inputName = IntegrationSchemaConstants.ELEM_CHANNEL;
            String uri = this.source.getDiagram().getNamespaceUri();
            String prefix = ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)((IDOMDocument)this.sourceElement.getOwnerDocument()), (String)uri);
            if (prefix != null && prefix.length() > 0) {
                this.inputName = String.valueOf(prefix) + ":" + this.inputName;
            }
            if ((children = this.processor.getChildNames(this.parentElement)).contains(this.inputName)) {
                return true;
            }
        }
        return false;
    }
}

