/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.model;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;

class WebflowModelImageDescriptor
extends CompositeImageDescriptor {
    public static final int FLAG_STARTSTATE = 4;
    public static final int FLAG_ERROR = 8;
    public static final int FLAG_INPUT = 16;
    public static final int FLAG_OUTPUT = 32;
    private Image baseImage;
    private Point size;
    private int flags;

    public WebflowModelImageDescriptor(Image baseImage, IWebflowModelElement state) {
        this.baseImage = baseImage;
        this.flags = this.getFlags(state);
        this.size = this.getSize();
    }

    protected Point getSize() {
        if (this.size == null) {
            ImageData data = this.baseImage.getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData background = this.baseImage.getImageData();
        if (background == null) {
            background = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(background, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((this.flags & 0x10) != 0) {
            data = WebflowUIImages.DESC_OVR_INPUT.getImageData();
            this.drawImage(data, x, y);
        }
        if ((this.flags & 0x20) != 0) {
            data = WebflowUIImages.DESC_OVR_OUTPUT.getImageData();
            this.drawImage(data, x, y);
        }
        if ((this.flags & 4) != 0) {
            data = WebflowUIImages.DESC_OVR_START_STATE.getImageData();
            this.drawImage(data, x, y);
        }
        if ((this.flags & 8) != 0) {
            data = WebflowUIImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(data, x, y);
        }
    }

    protected void setSize(Point size) {
        this.size = size;
    }

    private int getFlags(IWebflowModelElement element) {
        int flags = 0;
        if (element.getElementParent() != null && element.getElementParent() instanceof IWebflowState && element.equals(((IWebflowState)element.getElementParent()).getStartState())) {
            flags |= 4;
        }
        if (element != null && element instanceof IActionElement) {
            IWebflowModelElement parent = (IWebflowModelElement)element.getElementParent();
            if (parent instanceof IEntryActions) {
                flags |= 0x10;
            } else if (parent instanceof IExitActions) {
                flags |= 0x20;
            }
        }
        if (element instanceof IState && !WebflowUtils.isValid(element)) {
            flags |= 8;
        } else if ((element instanceof IActionElement || element instanceof IExceptionHandler || element instanceof IIf || element instanceof IAttributeMapper) && !WebflowUtils.isValid(element)) {
            flags |= 8;
        }
        return flags;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.flags | this.size.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !WebflowModelImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        WebflowModelImageDescriptor other = (WebflowModelImageDescriptor)((Object)object);
        return this.baseImage.equals((Object)other.baseImage) && this.flags == other.flags && this.size.equals((Object)other.size);
    }

    public String toString() {
        return this.baseImage.toString();
    }
}

