/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ImportCommand
implements ISVNCommand {
    private ISVNRemoteFolder folder;
    private File dir;
    String comment;
    boolean recurse;

    public ImportCommand(ISVNRemoteFolder folder, File dir, String comment, boolean recurse) {
        this.folder = folder;
        this.dir = dir;
        this.comment = comment;
        this.recurse = recurse;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        IProgressMonitor subPm = Policy.infiniteSubMonitorFor(monitor, 100);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                subPm.beginTask(null, 100);
                svnClient = this.folder.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(subPm, svnClient));
                svnClient.doImport(this.dir, this.folder.getUrl(), this.comment, this.recurse);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            this.folder.getRepository().returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
            subPm.done();
            throw throwable;
        }
        this.folder.getRepository().returnSVNClient(svnClient);
        OperationManager.getInstance().endOperation();
        subPm.done();
    }
}

