/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.CompareResultsAction;
import org.testng.eclipse.ui.MessageCopyAction;
import org.testng.eclipse.ui.OpenEditorAtLineAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.TestRunnerViewPart;
import org.testng.eclipse.ui.TraceCopyAction;
import org.testng.eclipse.util.PreferenceStoreUtil;

class FailureTrace
implements IMenuListener {
    private static final String FRAME_PREFIX = "at ";
    private final Image m_stackIcon = TestNGPlugin.getImageDescriptor("obj16/stkfrm_obj.gif").createImage();
    private final Image m_exceptionIcon = TestNGPlugin.getImageDescriptor("obj16/exc_catch.gif").createImage();
    private final Clipboard fClipboard;
    private Table fTable;
    private TestRunnerViewPart fTestRunner;
    private String fInputTrace;
    private RunInfo fFailure;
    private CompareResultsAction fCompareAction;
    private String fMessage;

    public FailureTrace(Composite parent, TestRunnerViewPart testRunner, ToolBar toolBar) {
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        this.fCompareAction = new CompareResultsAction(this);
        this.fCompareAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fCompareAction);
        failureToolBarmanager.update(true);
        this.fTable = new Table(parent, 772);
        this.fTestRunner = testRunner;
        this.fClipboard = new Clipboard(parent.getDisplay());
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Action a;
                if (FailureTrace.this.fTable.getSelectionIndex() == 0) {
                    new CompareResultsAction(FailureTrace.this).run();
                    return;
                }
                if (FailureTrace.this.fTable.getSelection().length != 0 && (a = FailureTrace.this.createOpenEditorAction(FailureTrace.this.getSelectedText())) != null) {
                    a.run();
                }
            }
        });
        this.initMenu();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTrace.this.disposeIcons();
                if (FailureTrace.this.fClipboard != null && FailureTrace.this.fClipboard.isDisposed()) {
                    FailureTrace.this.fClipboard.dispose();
                }
            }
        });
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            Action action = this.createOpenEditorAction(this.getSelectedText());
            manager.add((IAction)new TraceCopyAction(this, this.fClipboard));
            manager.add((IAction)new MessageCopyAction(this, this.fClipboard));
        }
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private Action createOpenEditorAction(String traceLine) {
        try {
            String testName = traceLine;
            testName = testName.substring(testName.indexOf(FRAME_PREFIX));
            testName = testName.substring(FRAME_PREFIX.length(), testName.lastIndexOf(40)).trim();
            testName = testName.substring(0, testName.lastIndexOf(46));
            int innerSeparatorIndex = testName.indexOf(36);
            if (innerSeparatorIndex != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.valueOf(lineNumber);
            String cuName = traceLine.substring(traceLine.lastIndexOf(40) + 1, traceLine.lastIndexOf(58));
            return new OpenEditorAtLineAction(this.fTestRunner, cuName, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    private void disposeIcons() {
        this.m_exceptionIcon.dispose();
        this.m_stackIcon.dispose();
    }

    Composite getComposite() {
        return this.fTable;
    }

    public void showFailure(RunInfo failure) {
        if (failure == null || failure.getStackTrace() == null) {
            this.fCompareAction.setEnabled(false);
            this.clear();
            return;
        }
        this.fFailure = failure;
        this.fCompareAction.setEnabled(true);
        String trace = failure.getStackTrace();
        if (this.fInputTrace == trace) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().equals("")) {
            this.clear();
            return;
        }
        trace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        this.fillTable(trace);
        this.fTable.setRedraw(true);
    }

    private void fillTable(String trace) {
        StringReader stringReader = new StringReader(trace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return;
            }
            boolean stackFound = false;
            TableItem tableItem = new TableItem(this.fTable, 0);
            String itemLabel = line.replace('\t', ' ');
            tableItem.setText(itemLabel);
            tableItem.setImage(this.m_exceptionIcon);
            while ((line = bufferedReader.readLine()) != null) {
                if (this.isExcluded(line)) continue;
                itemLabel = line.replace('\t', ' ');
                tableItem = new TableItem(this.fTable, 0);
                if (itemLabel.indexOf(" at ") >= 0) {
                    tableItem.setImage(this.m_stackIcon);
                    if (!stackFound) {
                        String messagebase = trace.replace('\t', ' ');
                        this.fMessage = messagebase.substring(0, messagebase.indexOf(" at "));
                        stackFound = true;
                    }
                }
                tableItem.setText(itemLabel);
            }
            if (!stackFound) {
                this.fMessage = trace;
            }
        }
        catch (IOException iOException) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(trace);
        }
    }

    private boolean isExcluded(String line) {
        String projectName;
        PreferenceStoreUtil storage = new PreferenceStoreUtil(TestNGPlugin.getDefault().getPreferenceStore());
        String excludedStackTraces = storage.getExcludedStackTraces(projectName = this.fTestRunner.getLaunchedProject().getProject().getName());
        if (excludedStackTraces.trim().length() > 0) {
            String[] excluded;
            String[] stringArray = excluded = excludedStackTraces.split(" ");
            int n = excluded.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (Pattern.matches(".*" + e + ".*", line)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    public RunInfo getFailedTest() {
        return this.fFailure;
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }

    public String getMessage() {
        return this.fMessage;
    }
}

