/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.ui.navigator.actions.ValidationAction;
import org.springframework.ide.eclipse.webflow.ui.navigator.actions.OpenActionWrapperAction;
import org.springframework.ide.eclipse.webflow.ui.navigator.actions.OpenConfigFileAction;
import org.springframework.ide.eclipse.webflow.ui.navigator.actions.OpenPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.navigator.actions.OpenWebflowGraphAction;

public class WebflowNavigatorActionProvider
extends CommonActionProvider {
    private OpenConfigFileAction openConfigAction;
    private OpenPropertiesAction openPropertiesAction;
    private OpenWebflowGraphAction openGraphAction;
    private OpenActionWrapperAction openActionWrapperAction;
    private ValidationAction validationAction;

    public void init(ICommonActionExtensionSite site) {
        this.openConfigAction = new OpenConfigFileAction(site);
        this.openPropertiesAction = new OpenPropertiesAction(site);
        this.openGraphAction = new OpenWebflowGraphAction(site);
        this.openActionWrapperAction = new OpenActionWrapperAction(site, this.openConfigAction, this.openGraphAction);
        this.validationAction = new ValidationAction(site);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openConfigAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openConfigAction);
        }
        if (this.openGraphAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openGraphAction);
        }
        if (this.validationAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.validationAction);
        }
        if (this.openPropertiesAction.isEnabled()) {
            menu.appendToGroup("group.properties", (IAction)this.openPropertiesAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openActionWrapperAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openActionWrapperAction);
        }
        if (this.openPropertiesAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.openPropertiesAction);
        }
    }
}

