/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.hooks.ISvnFileListHook;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnGetStatus
extends SvnReceivingOperation<SvnStatus> {
    private boolean remote;
    private boolean depthAsSticky;
    private boolean reportIgnored;
    private boolean reportAll;
    private boolean reportExternals;
    private ISvnFileListHook fileListHook;
    private boolean collectParentExternals;
    private long remoteRevision;

    protected SvnGetStatus(SvnOperationFactory factory) {
        super(factory);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isDepthAsSticky() {
        return this.depthAsSticky;
    }

    public boolean isReportIgnored() {
        return this.reportIgnored;
    }

    public boolean isReportAll() {
        return this.reportAll;
    }

    public boolean isReportExternals() {
        return this.reportExternals;
    }

    public ISvnFileListHook getFileListHook() {
        return this.fileListHook;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setDepthAsSticky(boolean depthAsSticky) {
        this.depthAsSticky = depthAsSticky;
    }

    public void setReportIgnored(boolean reportIgnored) {
        this.reportIgnored = reportIgnored;
    }

    public void setReportAll(boolean reportAll) {
        this.reportAll = reportAll;
    }

    public void setReportExternals(boolean reportExternals) {
        this.reportExternals = reportExternals;
    }

    public void setFileListHook(ISvnFileListHook fileListHook) {
        this.fileListHook = fileListHook;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        super.ensureArgumentsAreValid();
        this.setRemoteRevision(-1L);
        if (this.hasRemoteTargets()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)this.getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setRevision(SVNRevision.HEAD);
        this.setReportAll(true);
        this.setReportIgnored(true);
        this.setReportExternals(true);
        this.setRemoteRevision(-1L);
    }

    public boolean isCollectParentExternals() {
        return this.collectParentExternals;
    }

    public void setCollectParentExternals(boolean collect) {
        this.collectParentExternals = collect;
    }

    public void setRemoteRevision(long revision) {
        this.remoteRevision = revision;
    }

    public long getRemoteRevision() {
        return this.remoteRevision;
    }

    @Override
    public boolean isUseParentWcFormat() {
        return true;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

