/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.context.annotation.Configuration;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.metadata.core.StereotypeAnnotationMetadata;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class StereotypeAnnotationMetadataProvider
implements IAnnotationBeanMetadataProvider {
    private static final List<String> SUPPORTED_STEREOTYPE_ANNOTATIONS = Arrays.asList(Repository.class.getName(), Service.class.getName(), Component.class.getName(), Controller.class.getName());

    public Set<IBeanMetadata> provideBeanMetadata(IBean bean, IType type, IAnnotationMetadata visitor) {
        LinkedHashSet<IBeanMetadata> beanMetaDataSet = new LinkedHashSet<IBeanMetadata>();
        for (String annotationTypeName : visitor.getTypeLevelAnnotationClasses()) {
            if (annotationTypeName.equals(Configuration.class.getName()) || this.processStereoTypeAnnotation(bean, type, type, visitor, beanMetaDataSet, annotationTypeName, annotationTypeName)) continue;
            try {
                IType annotationType = type.getJavaProject().findType(annotationTypeName);
                if (annotationType == null || !Flags.isAnnotation((int)annotationType.getFlags())) continue;
                IAnnotation[] iAnnotationArray = annotationType.getAnnotations();
                int n = iAnnotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    String className = JdtUtils.resolveClassName((String)annotation.getElementName(), (IType)annotationType);
                    this.processStereoTypeAnnotation(bean, type, annotationType, visitor, beanMetaDataSet, annotationTypeName, className);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return beanMetaDataSet;
    }

    protected boolean processStereoTypeAnnotation(IBean bean, IType beanType, IType type, IAnnotationMetadata visitor, Set<IBeanMetadata> beanMetaDataSet, String annotationTypeName, String annotationTypeNameToCheck) {
        if (SUPPORTED_STEREOTYPE_ANNOTATIONS.contains(annotationTypeNameToCheck)) {
            try {
                beanMetaDataSet.add((IBeanMetadata)new StereotypeAnnotationMetadata(bean, annotationTypeName, visitor.getTypeLevelAnnotation(annotationTypeName).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)beanType)));
            }
            catch (JavaModelException javaModelException) {}
            return true;
        }
        return false;
    }
}

