/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractActionElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderActions
extends AbstractModelElement
implements IRenderActions {
    private List<IActionElement> renderActions = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.renderActions = new ArrayList<IActionElement>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                AbstractActionElement action;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("action".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                } else if ("render".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                } else if ("bean-action".equals(child.getLocalName())) {
                    action = new BeanAction();
                    ((BeanAction)action).init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                } else if ("evaluate-action".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                } else if ("evaluate".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                } else if ("set".equals(child.getLocalName())) {
                    action = new Set();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.RENDER_ACTION);
                    this.renderActions.add(action);
                }
                ++i;
            }
        }
    }

    @Override
    public void addRenderAction(IActionElement action) {
        if (!this.renderActions.contains(action)) {
            this.renderActions.add(action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            super.firePropertyChange("add_children", new Integer(this.renderActions.indexOf(action)), action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public void addRenderAction(IActionElement action, int i) {
        if (!this.renderActions.contains(action)) {
            if (this.renderActions.size() > i) {
                IActionElement ref = this.renderActions.get(i);
                WebflowModelXmlUtils.insertBefore((Node)action.getNode(), (Node)ref.getNode());
            } else {
                WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            }
            this.renderActions.add(i, action);
            super.firePropertyChange("add_children", new Integer(i), action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public List<IActionElement> getRenderActions() {
        return this.renderActions;
    }

    @Override
    public void removeRenderAction(IActionElement action) {
        if (this.renderActions.contains(action)) {
            this.renderActions.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = null;
        node = WebflowModelXmlUtils.isVersion1Flow(this) ? (IDOMNode)parent.getNode().getOwnerDocument().createElement("render-actions") : (IDOMNode)parent.getNode().getOwnerDocument().createElement("on-render");
        this.init(node, parent);
    }

    @Override
    public void removeAll() {
        for (IActionElement action : this.renderActions) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.renderActions = new ArrayList<IActionElement>();
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IActionElement state : this.getRenderActions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                state.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IActionElement> children = new ArrayList<IActionElement>();
        children.addAll(this.getRenderActions());
        return children.toArray(new IModelElement[children.size()]);
    }
}

