/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IGlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalTransitions
extends AbstractModelElement
implements IGlobalTransitions {
    private List<IStateTransition> globalTransition = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.globalTransition = new ArrayList<IStateTransition>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("transition".equals(child.getLocalName())) {
                    StateTransition trans = new StateTransition();
                    trans.init(child, this);
                    this.globalTransition.add(trans);
                }
                ++i;
            }
        }
    }

    @Override
    public void addGlobalTransition(IStateTransition action) {
        if (!this.globalTransition.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.globalTransition.add(action);
            super.firePropertyChange("add_children", new Integer(this.globalTransition.indexOf(action)), action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public void removeGlobalTransition(IStateTransition action) {
        if (this.globalTransition.contains(action)) {
            this.globalTransition.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public void addGlobalTransition(IStateTransition action, int i) {
        if (!this.globalTransition.contains(action)) {
            if (this.globalTransition.size() > i) {
                IStateTransition ref = this.globalTransition.get(i);
                WebflowModelXmlUtils.insertBefore((Node)action.getNode(), (Node)ref.getNode());
            } else {
                WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            }
            this.globalTransition.add(i, action);
            super.firePropertyChange("add_children", new Integer(i), action);
            this.parent.fireStructureChange("move_children", this);
        }
    }

    @Override
    public List<IStateTransition> getGlobalTransitions() {
        return this.globalTransition;
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("global-transitions");
        this.init(node, parent);
    }

    @Override
    public void removeAll() {
        for (IStateTransition action : this.globalTransition) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.globalTransition = new ArrayList<IStateTransition>();
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IStateTransition state : this.getGlobalTransitions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                state.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IStateTransition> children = new ArrayList<IStateTransition>();
        children.addAll(this.getGlobalTransitions());
        return children.toArray(new IModelElement[children.size()]);
    }
}

