/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.util.AbstractCellPainterBuilder;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TextAsColourShapeBuilder
extends AbstractCellPainterBuilder {
    private final int width;
    private final int height;
    private final Shape shapeId;

    public TextAsColourShapeBuilder(int theWidth, int theHeight, Shape theShapeId) {
        this.width = theWidth;
        this.height = theHeight;
        this.shapeId = theShapeId;
    }

    private String getterTextIn(TreeItem tItem, RuleFieldAccessor getter) {
        String text = (String)this.valueFor(tItem, getter);
        return StringUtil.isEmpty((String)text) ? null : text;
    }

    @Override
    public void addPainterFor(Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> listenersByEventCode) {
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != columnIndex) {
                    return;
                }
                String text = TextAsColourShapeBuilder.this.getterTextIn((TreeItem)event.item, getter);
                if (text == null) {
                    return;
                }
                Color original = event.gc.getBackground();
                Color clr = TextAsColourShapeBuilder.colorManager().colourFor(text);
                event.gc.setBackground(clr);
                ShapePainter.drawShape(TextAsColourShapeBuilder.this.width, TextAsColourShapeBuilder.this.height, TextAsColourShapeBuilder.this.shapeId, event.gc, event.x, event.y, null);
                event.gc.setBackground(original);
            }
        };
        Listener measureListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.index != columnIndex) {
                    return;
                }
                e.width = TextAsColourShapeBuilder.this.width + 2;
                e.height = TextAsColourShapeBuilder.this.height + 2;
            }
        };
        TextAsColourShapeBuilder.addListener((Control)tree, 42, paintListener, listenersByEventCode);
        TextAsColourShapeBuilder.addListener((Control)tree, 41, measureListener, listenersByEventCode);
    }
}

