/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.AbstractResourceView;
import net.sourceforge.pmd.eclipse.ui.views.AbstractStructureInspectorPage;
import net.sourceforge.pmd.eclipse.ui.views.actions.CollapseAllAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ExpandAllAction;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTViewPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBookView;

public class ASTView
extends AbstractResourceView {
    private ASTViewPage page;
    private Action toggleShowImportsAction;
    private Action toggleShowCommentsAction;
    private static final String ShowImports = "ASTView.showImports";
    private static final String ShowComments = "ASTView.showComments";

    static boolean showImports() {
        return ASTView.getBoolUIPref(ShowImports);
    }

    static boolean showComments() {
        return ASTView.getBoolUIPref(ShowComments);
    }

    @Override
    protected String pageMessageId() {
        return "view.ast.default_text";
    }

    @Override
    protected String mementoFileId() {
        return "/astView_memento.xml";
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        FileRecord resourceRecord = this.getFileRecordFromWorkbenchPart(part);
        if (resourceRecord != null) {
            this.setupListener(resourceRecord);
            this.page = new ASTViewPage(part, resourceRecord);
            this.initPage((IPageBookViewPage)this.page);
            this.page.createControl((Composite)this.getPageBook());
            this.makeActions();
            this.addToolbarControls();
            return new PageBookView.PageRec(part, (IPage)this.page);
        }
        return null;
    }

    @Override
    protected AbstractStructureInspectorPage getCurrentViewPage() {
        return this.getCurrentASTViewPage();
    }

    public void showImports(boolean flag) {
        this.setUIPref(ShowImports, flag);
        this.page.showImports(flag);
    }

    public void showComments(boolean flag) {
        this.setUIPref(ShowComments, flag);
        this.page.showComments(flag);
    }

    private ASTViewPage getCurrentASTViewPage() {
        IPage page = super.getCurrentPage();
        if (!(page instanceof ASTViewPage)) {
            return null;
        }
        return (ASTViewPage)page;
    }

    private void makeActions() {
        this.toggleShowImportsAction = new Action(){

            public void run() {
                boolean show = !ASTView.showImports();
                this.setChecked(show);
                ASTView.this.showImports(show);
            }
        };
        this.toggleShowImportsAction.setText("Show imports");
        this.toggleShowImportsAction.setChecked(ASTView.showImports());
        this.toggleShowCommentsAction = new Action(){

            public void run() {
                boolean show = !ASTView.showComments();
                this.setChecked(show);
                ASTView.this.showComments(show);
            }
        };
        this.toggleShowCommentsAction.setText("Show comments");
        this.toggleShowCommentsAction.setChecked(ASTView.showComments());
    }

    private void addToolbarControls() {
        IActionBars aBars = this.getViewSite().getActionBars();
        IToolBarManager manager = aBars.getToolBarManager();
        manager.add((IAction)new ExpandAllAction(this.page.astViewer()));
        manager.add((IAction)new CollapseAllAction(this.page.astViewer()));
        this.addViewFilterOptions(aBars);
    }

    private void addViewFilterOptions(IActionBars aBars) {
        IMenuManager mmgr = aBars.getMenuManager();
        mmgr.add((IAction)this.toggleShowImportsAction);
        mmgr.add((IAction)this.toggleShowCommentsAction);
    }
}

