/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.core.model.AbstractResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringModel;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.util.ObjectUtils;

public class SpringProject
extends AbstractResourceModelElement
implements ISpringProject {
    private IProject project;

    public SpringProject(ISpringModel model, IProject project) {
        super(model, project.getName());
        this.project = project;
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    public IResource getElementResource() {
        return this.project;
    }

    @Override
    public boolean isElementArchived() {
        return false;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpringProject)) {
            return false;
        }
        SpringProject that = (SpringProject)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.project, (Object)that.project)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.project);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        return "Project=" + this.getElementName();
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

