/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.project.IBeansProjectDescriptionConstants;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansProjectDescriptionHandler
extends DefaultHandler
implements IBeansProjectDescriptionConstants {
    protected BeansProject project;
    protected MultiStatus problems;
    protected State state;
    protected BeansConfigSet configSet;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Locator locator;

    public BeansProjectDescriptionHandler(BeansProject project) {
        this.project = project;
        this.problems = new MultiStatus("org.springframework.ide.eclipse.beans.core", 567, "Error reading Spring project description", null);
        this.state = State.INITIAL;
    }

    public IStatus getStatus() {
        return this.problems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        if (this.state == State.INITIAL) {
            if (!elementName.equals("beansProjectDescription")) throw new SAXParseException("No Spring project description", this.locator);
            this.state = State.PROJECT_DESC;
            return;
        } else if (this.state == State.PROJECT_DESC) {
            if (elementName.equals("configExtensions")) {
                this.state = State.CONFIG_EXTENSIONS;
                return;
            } else if (elementName.equals("configSuffixes")) {
                this.state = State.CONFIG_SUFFIXES;
                return;
            } else if (elementName.equals("configs")) {
                this.state = State.CONFIGS;
                return;
            } else if (elementName.equals("autoconfigs")) {
                this.state = State.AUTOCONFIGS;
                this.project.setAutoConfigStatePersisted(true);
                return;
            } else if (elementName.equals("configSets")) {
                this.state = State.CONFIG_SETS;
                return;
            } else if (elementName.equals("enableImports")) {
                this.state = State.ENABLE_IMPORTS;
                return;
            } else {
                if (!elementName.equals("pluginVersion")) return;
                this.state = State.PLUGIN_VERSION;
            }
            return;
        } else if (this.state == State.CONFIG_EXTENSIONS) {
            if (!elementName.equals("configExtension")) return;
            this.state = State.CONFIG_EXTENSION;
            return;
        } else if (this.state == State.CONFIG_SUFFIXES) {
            if (!elementName.equals("configSuffix")) return;
            this.state = State.CONFIG_SUFFIX;
            return;
        } else if (this.state == State.ENABLE_IMPORTS) {
            if (!elementName.equals("enableImports")) return;
            this.state = State.ENABLE_IMPORTS;
            return;
        } else if (this.state == State.CONFIGS) {
            if (!elementName.equals("config")) return;
            this.state = State.CONFIG;
            return;
        } else if (this.state == State.AUTOCONFIGS) {
            if (!elementName.equals("autoconfig")) return;
            this.state = State.AUTOCONFIG;
            return;
        } else if (this.state == State.CONFIG_SETS) {
            if (!elementName.equals("configSet")) return;
            this.state = State.CONFIG_SET;
            return;
        } else if (this.state == State.CONFIG_SET) {
            if (elementName.equals("name")) {
                this.state = State.CONFIG_SET_NAME;
                return;
            } else if (elementName.equals("allowBeanDefinitionOverriding")) {
                this.state = State.CONFIG_SET_OVERRIDING;
                return;
            } else if (elementName.equals("incomplete")) {
                this.state = State.CONFIG_SET_INCOMPLETE;
                return;
            } else if (elementName.equals("configs")) {
                this.state = State.CONFIG_SET_CONFIGS;
                return;
            } else {
                if (!elementName.equals("profiles")) return;
                this.state = State.PROFILES;
            }
            return;
        } else if (this.state == State.CONFIG_SET_CONFIGS) {
            if (!elementName.equals("config")) return;
            this.state = State.CONFIG_SET_CONFIG;
            return;
        } else {
            if (this.state != State.PROFILES || !elementName.equals("profile")) return;
            this.state = State.PROFILE;
        }
    }

    @Override
    public void endElement(String uri, String elementName, String qname) throws SAXException {
        if (this.state == State.PROJECT_DESC) {
            if (this.project.getConfigSuffixes().isEmpty()) {
                this.project.addConfigSuffix("xml");
            }
        } else if (this.state == State.CONFIG_EXTENSIONS) {
            if (elementName.equals("configExtensions")) {
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.ENABLE_IMPORTS) {
            if (elementName.equals("enableImports")) {
                boolean isImportEnabled = Boolean.valueOf(this.charBuffer.toString().trim());
                this.project.setImportsEnabled(isImportEnabled);
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.PLUGIN_VERSION) {
            if (elementName.equals("pluginVersion")) {
                String version = this.charBuffer.toString().trim();
                this.project.setVersion(version);
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.CONFIG_SUFFIXES) {
            if (elementName.equals("configSuffixes")) {
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.CONFIG_EXTENSION) {
            if (elementName.equals("configExtension")) {
                String extension = this.charBuffer.toString().trim();
                this.project.addConfigSuffix(extension);
                this.state = State.CONFIG_EXTENSIONS;
            }
        } else if (this.state == State.CONFIG_SUFFIX) {
            if (elementName.equals("configSuffix")) {
                String extension = this.charBuffer.toString().trim();
                this.project.addConfigSuffix(extension);
                this.state = State.CONFIG_SUFFIXES;
            }
        } else if (this.state == State.CONFIGS) {
            if (elementName.equals("configs")) {
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.AUTOCONFIGS) {
            if (elementName.equals("autoconfigs")) {
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.CONFIG) {
            if (elementName.equals("config")) {
                String projectPath;
                String config = this.charBuffer.toString().trim();
                if (config.length() > 0 && config.charAt(0) == '/' && config.startsWith(projectPath = String.valueOf('/') + this.project.getElementName() + '/')) {
                    config = config.substring(projectPath.length());
                }
                this.project.addConfig(config, IBeansConfig.Type.MANUAL);
                this.state = State.CONFIGS;
            }
        } else if (this.state == State.AUTOCONFIG) {
            if (elementName.equals("autoconfig")) {
                this.state = State.AUTOCONFIGS;
            }
        } else if (this.state == State.CONFIG_SETS) {
            if (elementName.equals("configSets")) {
                this.state = State.PROJECT_DESC;
            }
        } else if (this.state == State.CONFIG_SET) {
            if (elementName.equals("configSet")) {
                this.project.addConfigSet(this.configSet);
                this.state = State.CONFIG_SETS;
            }
        } else if (this.state == State.PROFILES) {
            if (elementName.equals("profiles")) {
                this.state = State.CONFIG_SET;
            }
        } else if (this.state == State.PROFILE) {
            if (elementName.equals("profile")) {
                String profile = this.charBuffer.toString().trim();
                this.configSet.addProfile(profile);
                this.state = State.PROFILES;
            }
        } else if (this.state == State.CONFIG_SET_NAME) {
            if (elementName.equals("name")) {
                String name = this.charBuffer.toString().trim();
                this.configSet = new BeansConfigSet(this.project, name, IBeansConfigSet.Type.MANUAL);
                this.state = State.CONFIG_SET;
            }
        } else if (this.state == State.CONFIG_SET_OVERRIDING) {
            if (elementName.equals("allowBeanDefinitionOverriding")) {
                boolean override = Boolean.valueOf(this.charBuffer.toString().trim());
                this.configSet.setAllowBeanDefinitionOverriding(override);
                this.state = State.CONFIG_SET;
            }
        } else if (this.state == State.CONFIG_SET_INCOMPLETE) {
            if (elementName.equals("incomplete")) {
                boolean incomplete = Boolean.valueOf(this.charBuffer.toString().trim());
                this.configSet.setIncomplete(incomplete);
                this.state = State.CONFIG_SET;
            }
        } else if (this.state == State.CONFIG_SET_CONFIGS) {
            if (elementName.equals("configs")) {
                this.state = State.CONFIG_SET;
            }
        } else if (this.state == State.CONFIG_SET_CONFIG && elementName.equals("config")) {
            String projectPath;
            String config = this.charBuffer.toString().trim();
            if (config.length() > 0 && config.charAt(0) == '/' && config.startsWith(projectPath = String.valueOf('/') + this.project.getElementName() + '/')) {
                config = config.substring(projectPath.length());
            }
            this.configSet.addConfig(config);
            this.state = State.CONFIG_SET_CONFIGS;
        }
        this.charBuffer.setLength(0);
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.charBuffer.append(chars, offset, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void error(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    @Override
    public void warning(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    public void log(int code, Throwable error) {
        this.log(code, error.getMessage(), error);
    }

    public void log(int code, String errorMessage, Throwable error) {
        this.problems.add((IStatus)new Status(code, "org.springframework.ide.eclipse.beans.core", 567, errorMessage, error));
    }

    protected static enum State {
        INITIAL,
        PROJECT_DESC,
        CONFIG_EXTENSIONS,
        CONFIG_EXTENSION,
        CONFIG_SUFFIXES,
        CONFIG_SUFFIX,
        CONFIGS,
        AUTOCONFIGS,
        CONFIG,
        AUTOCONFIG,
        CONFIG_SETS,
        CONFIG_SET,
        CONFIG_SET_NAME,
        CONFIG_SET_OVERRIDING,
        CONFIG_SET_INCOMPLETE,
        CONFIG_SET_CONFIGS,
        CONFIG_SET_CONFIG,
        VERSION,
        PLUGIN_VERSION,
        ENABLE_IMPORTS,
        PROFILES,
        PROFILE;

    }
}

