/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.richfaces.model.TreeRowKey;

public class ListRowKey
extends TreeRowKey {
    private ArrayList path;
    private static final long serialVersionUID = 7718335783201397177L;

    public String toString() {
        return this.getPath();
    }

    public ListRowKey() {
        this.path = new ArrayList();
    }

    public ListRowKey(ListRowKey parentRowKey) {
        this.path = parentRowKey != null ? (ArrayList)parentRowKey.path.clone() : new ArrayList();
    }

    public ListRowKey(ListRowKey parentRowKey, Object pathElement) {
        this(parentRowKey);
        this.path.add(pathElement);
    }

    private static ArrayList parsePath(String path) {
        ArrayList<String> result = new ArrayList<String>();
        String trimmedPath = path.trim();
        StringBuffer sb = new StringBuffer();
        boolean escapedState = false;
        int pathLength = trimmedPath.length();
        for (int i = 0; i < pathLength; ++i) {
            char c = trimmedPath.charAt(i);
            if ('_' == c) {
                if (escapedState) {
                    sb.append(c);
                }
                escapedState = !escapedState;
                continue;
            }
            if (c == ':') {
                if (escapedState) {
                    sb.append(c);
                } else {
                    result.add(sb.toString());
                    sb = new StringBuffer();
                }
            } else {
                sb.append(c);
            }
            escapedState = false;
        }
        if (sb.length() != 0) {
            result.add(sb.toString());
        }
        return result;
    }

    public ListRowKey(List list) {
        this.path = new ArrayList(list);
    }

    public ListRowKey(Object path) {
        this.path = new ArrayList(1);
        this.path.add(path);
    }

    public ListRowKey(String path) {
        this.path = ListRowKey.parsePath(path);
    }

    public int depth() {
        return this.path.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.path).iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : ((AbstractList)this.path).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRowKey other = (ListRowKey)obj;
        return !(this.path == null ? other.path != null : !((AbstractList)this.path).equals(other.path));
    }

    public Iterator getSubPathIterator(int fromIndex) {
        return ((AbstractList)this.path).listIterator(fromIndex);
    }

    public ListRowKey getSubKey(int fromIndex) {
        return new ListRowKey(((AbstractList)this.path).subList(fromIndex, this.path.size()));
    }

    public boolean isSubKey(TreeRowKey rowKey) {
        if (rowKey instanceof ListRowKey) {
            ListRowKey listRowKey = (ListRowKey)rowKey;
            return this.depth() == this.getCommonPathLength(listRowKey);
        }
        return super.isSubKey(rowKey);
    }

    public String getPath() {
        StringBuffer result = new StringBuffer();
        Iterator iterator = ((AbstractList)this.path).iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            String pathSegment = iterator.next().toString();
            StringBuffer escapedSubPath = new StringBuffer();
            for (int i = 0; i < pathSegment.length(); ++i) {
                char ch = pathSegment.charAt(i);
                if (':' == ch || '_' == ch) {
                    escapedSubPath.append('_');
                }
                escapedSubPath.append(ch);
            }
            result.append(escapedSubPath.toString());
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            result.append(':');
        }
        return result.toString();
    }

    public int getCommonPathLength(TreeRowKey otherRowKey) {
        if (otherRowKey == null) {
            return 0;
        }
        Iterator iterator = this.iterator();
        Iterator otherIterator = otherRowKey.iterator();
        int length = 0;
        while (iterator.hasNext() && otherIterator.hasNext() && iterator.next().equals(otherIterator.next())) {
            ++length;
        }
        return length;
    }

    public Object get(int i) {
        return this.path.get(i);
    }
}

