/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.hibernate.reflection.Filter;
import org.hibernate.reflection.XProperty;
import org.hibernate.reflection.java.JavaXFactory;
import org.hibernate.reflection.java.JavaXMember;
import org.hibernate.reflection.java.JavaXType;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeUtils;

class JavaXProperty
extends JavaXMember
implements XProperty {
    static boolean isProperty(Field f, Type boundType, Filter filter) {
        return !(!filter.returnStatic() && Modifier.isStatic(f.getModifiers()) || !filter.returnTransient() && Modifier.isTransient(f.getModifiers()) || f.isSynthetic() || !JavaXProperty.isPropertyType(boundType));
    }

    private static boolean isPropertyType(Type type) {
        return !TypeUtils.isVoid(type);
    }

    static boolean isProperty(Method m, Type boundType, Filter filter) {
        return !(!JavaXProperty.isPropertyType(boundType) || m.isSynthetic() || m.isBridge() || !filter.returnStatic() && Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || !m.getName().startsWith("get") && !m.getName().startsWith("is"));
    }

    static JavaXProperty create(Member member, TypeEnvironment context, JavaXFactory factory) {
        Type propType = JavaXProperty.typeOf(member, context);
        JavaXType xType = factory.toXType(context, propType);
        return new JavaXProperty(member, propType, context, factory, xType);
    }

    private JavaXProperty(Member member, Type type, TypeEnvironment env, JavaXFactory factory, JavaXType xType) {
        super(member, type, env, factory, xType);
        assert (member instanceof Field || member instanceof Method);
    }

    public String getName() {
        String fullName = this.getMember().getName();
        if (this.getMember() instanceof Method) {
            if (fullName.startsWith("get")) {
                return Introspector.decapitalize(fullName.substring("get".length()));
            }
            if (fullName.startsWith("is")) {
                return Introspector.decapitalize(fullName.substring("is".length()));
            }
            throw new RuntimeException("Method " + fullName + " is not a property getter");
        }
        return fullName;
    }

    public Object invoke(Object target, Object ... parameters) {
        if (parameters.length != 0) {
            throw new IllegalArgumentException("An XProperty cannot have invoke parameters");
        }
        try {
            if (this.getMember() instanceof Method) {
                return ((Method)this.getMember()).invoke(target, new Object[0]);
            }
            return ((Field)this.getMember()).get(target);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " on a  null object", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " with wrong parameters", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke " + this.getName(), e);
        }
    }

    public String toString() {
        return this.getName();
    }
}

