/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.refactoring;

import org.apache.maven.model.Dependency;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.arquillian.editor.internal.refactoring.AddDependenciesRefactoring;

public class AddDependenciesWizardPage
extends UserInputWizardPage {
    private AddDependenciesRefactoring refactoring;

    public AddDependenciesWizardPage(AddDependenciesRefactoring refactoring) {
        super(refactoring.getName());
        this.refactoring = refactoring;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (this.refactoring != null && this.refactoring.getDependencies() != null && this.refactoring.getDependencies().size() > 0) {
            if (this.refactoring.getDependencies().size() == 1) {
                new Label(composite, 0).setText("The following dependency will be added:");
            } else {
                new Label(composite, 0).setText("The following dependencies will be added:");
            }
            new Label(composite, 0);
            for (Dependency dependency : this.refactoring.getDependencies()) {
                StringBuilder builder = new StringBuilder();
                builder.append(dependency.getGroupId() == null ? "" : dependency.getGroupId());
                builder.append(":");
                builder.append(dependency.getArtifactId() == null ? "" : dependency.getArtifactId());
                if (dependency.getVersion() != null) {
                    builder.append(":");
                    builder.append(dependency.getVersion());
                }
                new Label(composite, 0).setText(builder.toString());
            }
        }
        this.setControl((Control)composite);
    }
}

