(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("extjs5.0.0", function(server, options) {
    server._extjs = {};
    return {
      defs : defs
    };
  });

  var defs = {"!name":"extjs","!define":{},"Ext":{"Action":{"!doc":"<p>An Action is a piece of reusable functionality that can be abstracted out of any particular component so that it\ncan be usefully shared among multiple components.  Actions let you share handlers, configuration options and UI\nupdates across any components that support the Action interface (primarily <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a>,\n<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a> and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a> components).</p>\n\n<p>Use a single Action instance as the config object for any number of UI Components which share the same configuration. The\nAction not only supplies the configuration, but allows all Components based upon it to have a common set of methods\ncalled at once through a single call to the Action.</p>\n\n<p>Any Component that is to be configured with an Action must also support\nthe following methods:</p>\n\n<ul>\n<li>setText(string)</li>\n<li>setIconCls(string)</li>\n<li>setDisabled(boolean)</li>\n<li>setVisible(boolean)</li>\n<li>setHandler(function)</li>\n</ul>\n\n\n<p>This allows the Action to control its associated Components.</p>\n\n<p>Example usage:</p>\n\n<pre><code>// Define the shared Action.  Each Component below will have the same\n// display text and icon, and will display the same message on click.\nvar action = new <a href=\"#!/api/Ext.Action\" rel=\"Ext.Action\" class=\"docClass\">Ext.Action</a>({\n    <a href=\"#!/api/Ext.Action-cfg-text\" rel=\"Ext.Action-cfg-text\" class=\"docClass\">text</a>: 'Do something',\n    <a href=\"#!/api/Ext.Action-cfg-handler\" rel=\"Ext.Action-cfg-handler\" class=\"docClass\">handler</a>: function(){\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Click', 'You did something.');\n    },\n    <a href=\"#!/api/Ext.Action-cfg-iconCls\" rel=\"Ext.Action-cfg-iconCls\" class=\"docClass\">iconCls</a>: 'do-something',\n    <a href=\"#!/api/Ext.Action-cfg-itemId\" rel=\"Ext.Action-cfg-itemId\" class=\"docClass\">itemId</a>: 'myAction'\n});\n\nvar panel = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Actions',\n    width: 500,\n    height: 300,\n    tbar: [\n        // Add the Action directly to a toolbar as a menu button\n        action,\n        {\n            text: 'Action Menu',\n            // Add the Action to a menu as a text item\n            menu: [action]\n        }\n    ],\n    items: [\n        // Add the Action to the panel body as a standard button\n        new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>(action)\n    ],\n    renderTo: Ext.getBody()\n});\n\n// Change the text for all components using the Action\naction.setText('Something else');\n\n// Reference an Action through a container using the itemId\nvar btn = panel.getComponent('myAction');\nvar aRef = btn.baseAction;\naRef.setText('New text');\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"disabled":{"!type":"bool","!doc":"<p>True to disable all components configured by this Action, false to enable them.</p>\n"},"handler":{"!doc":"<p>The function that will be invoked by each component tied to this Action\nwhen the component's primary event is triggered.</p>\n"},"hidden":{"!type":"bool","!doc":"<p>True to hide all components configured by this Action, false to show them.</p>\n"},"iconCls":{"!type":"string","!doc":"<p>The CSS class selector that specifies a background image to be used as the header icon for\nall components configured by this Action.</p>\n\n<p>An example of specifying a custom icon class would be something like:</p>\n\n<pre><code>// specify the property in the config for the class:\n     ...\n     iconCls: 'do-something'\n\n// css class that specifies background image to be used as the icon image:\n.do-something { background-image: url(../images/my-icon.gif) 0 6px no-repeat !important; }\n</code></pre>\n\n<p>There are no default icon classes that come with Ext JS.</p>\n"},"itemId":{"!type":"string","!doc":"<p>See <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.<a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"scope":{"!doc":"<p>The scope (this reference) in which the <a href=\"#!/api/Ext.Action-cfg-handler\" rel=\"Ext.Action-cfg-handler\" class=\"docClass\">handler</a> is executed.\nDefaults to the browser window.</p>\n"},"text":{"!type":"string","!doc":"<p>The text to set for all components configured by this Action.</p>\n"},"isAction":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Action, or subclass thereof.</p>\n"},"addComponent":{"!type":"fn(comp: ?) -> !this"},"callEach":{"!type":"fn(fnName: ?, args: ?) -> !this"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disables all components configured by this Action.</p>\n"},"each":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Executes the specified function once for each Component currently tied to this Action.  The function passed\nin should accept a single argument that will be an object that supports the basic Action config/method interface.</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables all components configured by this Action.</p>\n"},"execute":{"!type":"fn(args: ?) -> !this","!doc":"<p>Executes this Action manually using the handler function specified in the original config object\nor the handler function set with <a href=\"#!/api/Ext.Action-method-setHandler\" rel=\"Ext.Action-method-setHandler\" class=\"docClass\">setHandler</a>.  Any arguments passed to this\nfunction will be passed on to the handler function.</p>\n"},"getIconCls":{"!type":"fn() -> !this","!doc":"<p>Gets the icon CSS class currently used by all components configured by this Action.</p>\n"},"getText":{"!type":"fn() -> !this","!doc":"<p>Gets the text currently displayed by all components configured by this Action.</p>\n"},"hide":{"!type":"fn() -> !this","!doc":"<p>Hides all components configured by this Action.</p>\n"},"isDisabled":{"!type":"fn() -> !this","!doc":"<p>Returns true if the components using this Action are currently disabled, else returns false.</p>\n"},"isHidden":{"!type":"fn() -> !this","!doc":"<p>Returns true if the components configured by this Action are currently hidden, else returns false.</p>\n"},"removeComponent":{"!type":"fn(comp: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Sets the disabled state of all components configured by this Action.  Shortcut method\nfor <a href=\"#!/api/Ext.Action-method-enable\" rel=\"Ext.Action-method-enable\" class=\"docClass\">enable</a> and <a href=\"#!/api/Ext.Action-method-disable\" rel=\"Ext.Action-method-disable\" class=\"docClass\">disable</a>.</p>\n"},"setHandler":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Sets the function that will be called by each Component using this action when its primary event is triggered.</p>\n"},"setHidden":{"!type":"fn(hidden: ?) -> !this","!doc":"<p>Sets the hidden state of all components configured by this Action.  Shortcut method\nfor <code><a href=\"#!/api/Ext.Action-method-hide\" rel=\"Ext.Action-method-hide\" class=\"docClass\">hide</a></code> and <code><a href=\"#!/api/Ext.Action-method-show\" rel=\"Ext.Action-method-show\" class=\"docClass\">show</a></code>.</p>\n"},"setIconCls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Sets the icon CSS class for all components configured by this Action.  The class should supply\na background image that will be used as the icon image.</p>\n"},"setText":{"!type":"fn(text: ?) -> !this","!doc":"<p>Sets the text to be displayed by all components configured by this Action.</p>\n"},"show":{"!type":"fn() -> !this","!doc":"<p>Shows all components configured by this Action.</p>\n"}}},"app":{"Application":{"!doc":"<p>Represents an Ext JS application, which is typically a single page app using a\n<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Viewport</a>.</p>\n\n<p>An application consists of one or more Views. The behavior of a View is managed by its\ncorresponding <a href=\"#!/api/Ext.app.ViewController\" rel=\"Ext.app.ViewController\" class=\"docClass\">ViewController</a> and ViewModel.</p>\n\n<p>Global activities are coordinated by <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controllers</a> which are\nultimately instantiated by an instance of this (or a derived) class.</p>\n\n<pre><code>Ext.application({\n    name: 'MyApp',\n\n    // An instance of this view is created and set as the Viewport:\n    autoCreateViewport: 'MyApp.view.Main'\n});\n</code></pre>\n\n<p>This does several things. First it creates a global variable called 'MyApp' - all of\nyour Application's classes (such as its Models, Views and Controllers) will reside under\nthis single namespace, which drastically lowers the chances of colliding global variables.</p>\n\n<p>The MyApp global will also have a getApplication method to get a reference to the current\napplication:</p>\n\n<pre><code>var app = MyApp.getApplication();\n</code></pre>\n\n<h1>Telling Application about the rest of the app</h1>\n\n<p>Because an <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> represents an entire app, we should tell it about the other\nparts of the app - namely the Models, Views and Controllers that are bundled with the application. Let's say we have a blog management app; we\nmight have Models and Controllers for Posts and Comments, and Views for listing, adding and editing Posts and Comments.\nHere's how we'd tell our Application about all these things:</p>\n\n<pre><code>Ext.application({\n    name: 'Blog',\n\n    models: ['Post', 'Comment'],\n\n    controllers: ['Posts', 'Comments'],\n\n    launch: function() {\n        ...\n    }\n});\n</code></pre>\n\n<p>Note that we didn't actually list the Views directly in the Application itself. This is because Views are managed by\nControllers, so it makes sense to keep those dependencies there. The Application will load each of the specified\nControllers using the pathing conventions laid out in the <a href=\"#/guide/application_architecture\">application architecture guide</a> - in this case\nexpecting the controllers to reside in app/controller/Posts.js and app/controller/Comments.js. In turn, each\nController simply needs to list the Views it uses and they will be automatically loaded. Here's how our Posts\ncontroller like be defined:</p>\n\n<pre><code>Ext.define('MyApp.controller.Posts', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n    views: ['posts.List', 'posts.Edit'],\n\n    //the rest of the Controller here\n});\n</code></pre>\n\n<p>Because we told our Application about our Models and Controllers, and our Controllers about their Views, Ext JS will\nautomatically load all of our app files for us. This means we don't have to manually add script tags into our html\nfiles whenever we add a new class, but more importantly it enables us to create a minimized build of our entire\napplication using Sencha Cmd.</p>\n\n<h1>Deriving from <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></h1>\n\n<p>Typically, applications do not derive directly from <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>. Rather, the\nconfiguration passed to <code>Ext.application</code> mimics what you might do in a derived class.\nIn some cases, however, it can be desirable to share logic by using a derived class\nfrom <code><a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></code>.</p>\n\n<p>Derivation works as you would expect, but using the derived class should still be the\njob of the <code>Ext.application</code> method.</p>\n\n<pre><code>Ext.define('MyApp.app.Application', {\n    extend: '<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>',\n    name: 'MyApp',\n    ...\n});\n\nExt.application('MyApp.app.Application');\n</code></pre>\n\n<p>For more information about writing Ext JS applications, please see the <a href=\"#/guide/application_architecture\">application architecture guide</a>.</p>\n","!type":"fn(config?: ?)","prototype":{"appFolder":{"!type":"string","!doc":"<p>The path to the directory which contains all application's classes.\nThis path will be registered via Ext.Loader.setPath for the namespace specified\nin the <a href=\"#!/api/Ext.app.Application-cfg-name\" rel=\"Ext.app.Application-cfg-name\" class=\"docClass\">name</a> config.</p>\n"},"appProperty":{"!type":"string","!doc":"<p>The name of a property to be assigned to the main namespace to gain a reference to\nthis application. Can be set to an empty value to prevent the reference from\nbeing created</p>\n\n<pre><code>Ext.application({\n    name: 'MyApp',\n    appProperty: 'myProp',\n\n    launch: function() {\n        console.log(MyApp.myProp === this);\n    }\n});\n</code></pre>\n"},"autoCreateViewport":{"!doc":"<p>Set to <code>true</code> to automatically load and instantiate <code>AppName.view.Viewport</code>\nbefore firing the launch function. Otherwise this is the name of the view to\ncreate and apply the <code>viewport</code> plugin.</p>\n\n<p>@cmd-auto-dependency {aliasPrefix: \"view.\", mvc: true, requires: [\"<a href=\"#!/api/Ext.plugin.Viewport\" rel=\"Ext.plugin.Viewport\" class=\"docClass\">Ext.plugin.Viewport</a>\"]}</p>\n"},"controllers":{"!doc":"<p>Names of controllers that the app uses.</p>\n"},"defaultToken":{"!type":"string","!doc":"<p>The default token to be used at application launch\nif one is not present. Often this is set to something like <code>'home'</code>.</p>\n"},"enableQuickTips":{"!type":"bool","!doc":"<p>True to automatically set up <a href=\"#!/api/Ext.tip.QuickTip\" rel=\"Ext.tip.QuickTip\" class=\"docClass\">Ext.tip.QuickTip</a> support.</p>\n"},"extend":{"!type":"string","!doc":"<p>A class name to use with the <code>Ext.application</code> call. The class must also extend <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>.</p>\n\n<pre><code>Ext.define('MyApp.Application', {\n    extend : '<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>',\n\n    launch : function() {\n        Ext.direct.Manager.addProvider(Ext.app.REMOTING_API);\n    }\n});\n\nExt.application({\n    extend : 'MyApp.Application'\n});\n</code></pre>\n"},"glyphFontFamily":{"!type":"string","!doc":"<p>The glyphFontFamily to use for this application.  Used as the default font-family\nfor all components that support a <code>glyph</code> config.</p>\n"},"name":{"!type":"string","!doc":"<p>The name of your application. This will also be the namespace for your views, controllers\nmodels and stores. Don't use spaces or special characters in the name. <strong>Application name\nis mandatory</strong>.</p>\n"},"namespaces":{"!doc":"<p>The list of namespace prefixes used in the application to resolve dependencies\nlike Views and Stores:</p>\n\n<pre><code> Ext.application({\n     name: 'MyApp',\n\n     namespaces: ['Common.code'],\n\n     controllers: [ 'Common.code.controller.Foo', 'Bar' ]\n });\n\n Ext.define('Common.code.controller.Foo', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['Foo'],    // Loads Common.code.model.Foo\n     views:  ['Bar']     // Loads Common.code.view.Bar\n });\n\n Ext.define('MyApp.controller.Bar', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['Foo'],    // Loads MyApp.model.Foo\n     views:  ['Bar']     // Loads MyApp.view.Bar\n });\n</code></pre>\n\n<p>You don't need to include main namespace (MyApp), it will be added to the list\nautomatically.</p>\n"},"paths":{"!doc":"<p>Additional load paths to add to Ext.Loader.\nSee Ext.Loader.paths config for more details.</p>\n"},"scope":{"!doc":"<p>The scope to execute the <a href=\"#!/api/Ext.app.Application-method-launch\" rel=\"Ext.app.Application-method-launch\" class=\"docClass\">launch</a> function in. Defaults to the Application instance.</p>\n"},"isApplication":{"!type":"bool"},"createController":{"!type":"fn(name: ?) -> ?","!doc":"<p>Create an instance of a controller by name.</p>\n"},"destroy":{"!type":"fn(destroyRefs: ?) -> !this","!doc":"<p>Inherit docs</p>\n"},"destroyController":{"!type":"fn(controller: ?) -> !this","!doc":"<p>Destroys a controller, any listeners are unbound.</p>\n"},"finishInitControllers":{"!type":"fn() -> !this"},"getAppProperty":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-appProperty\" rel=\"Ext.app.Application-cfg-appProperty\" class=\"docClass\">appProperty</a>.</p>\n"},"getApplication":{"!type":"fn() -> ?","!doc":"<p>Inherit docs</p>\n"},"getAutoCreateViewport":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-autoCreateViewport\" rel=\"Ext.app.Application-cfg-autoCreateViewport\" class=\"docClass\">autoCreateViewport</a>.</p>\n"},"getController":{"!type":"fn(name: ?, preventCreate: ?) -> ?","!doc":"<p>Returns instance of a <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller</a> with the given id.\nWhen controller doesn't exist yet, it's created. Note that this method depends\non Application instance and will return undefined when Application is not\naccessible. The only exception is when this Controller instance's id is requested;\nin that case we always return the instance even if Application is no available.</p>\n"},"getDefaultToken":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-defaultToken\" rel=\"Ext.app.Application-cfg-defaultToken\" class=\"docClass\">defaultToken</a>.</p>\n"},"getEnableQuickTips":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-enableQuickTips\" rel=\"Ext.app.Application-cfg-enableQuickTips\" class=\"docClass\">enableQuickTips</a>.</p>\n"},"getGlyphFontFamily":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-glyphFontFamily\" rel=\"Ext.app.Application-cfg-glyphFontFamily\" class=\"docClass\">glyphFontFamily</a>.</p>\n"},"getModuleClassName":{"!type":"fn(name: ?, kind: ?) -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-moduleClassName\" rel=\"Ext.app.Application-cfg-moduleClassName\" class=\"docClass\">moduleClassName</a>.</p>\n"},"getName":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Application-cfg-name\" rel=\"Ext.app.Application-cfg-name\" class=\"docClass\">name</a>.</p>\n"},"getViewportName":{"!type":"fn() -> !this"},"initControllers":{"!type":"fn() -> !this"},"initNamespace":{"!type":"fn() -> !this"},"initQuickTips":{"!type":"fn() -> !this"},"initViewport":{"!type":"fn() -> !this"},"launch":{"!type":"fn(profile: ?) -> bool","!doc":"<p>Called automatically when the page has completely loaded. This is an empty function that should be\noverridden by each application that needs to take action on page load.</p>\n"},"onBeforeLaunch":{"!type":"fn() -> !this"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this"},"setAppProperty":{"!type":"fn(appProperty: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-appProperty\" rel=\"Ext.app.Application-cfg-appProperty\" class=\"docClass\">appProperty</a>.</p>\n"},"setAutoCreateViewport":{"!type":"fn(autoCreateViewport: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-autoCreateViewport\" rel=\"Ext.app.Application-cfg-autoCreateViewport\" class=\"docClass\">autoCreateViewport</a>.</p>\n"},"setDefaultToken":{"!type":"fn(defaultToken: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-defaultToken\" rel=\"Ext.app.Application-cfg-defaultToken\" class=\"docClass\">defaultToken</a>.</p>\n"},"setEnableQuickTips":{"!type":"fn(enableQuickTips: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-enableQuickTips\" rel=\"Ext.app.Application-cfg-enableQuickTips\" class=\"docClass\">enableQuickTips</a>.</p>\n"},"setGlyphFontFamily":{"!type":"fn(glyphFontFamily: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-glyphFontFamily\" rel=\"Ext.app.Application-cfg-glyphFontFamily\" class=\"docClass\">glyphFontFamily</a>.</p>\n"},"setName":{"!type":"fn(name: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Application-cfg-name\" rel=\"Ext.app.Application-cfg-name\" class=\"docClass\">name</a>.</p>\n"},"unregister":{"!type":"fn(controller: ?) -> !this","!doc":"<p>Unregister a controller from the application.</p>\n"},"updateGlyphFontFamily":{"!type":"fn(fontFamily: ?) -> !this"}}},"Controller":{"prototype":{"active":{"!type":"bool"},"application":{"!doc":"<p>The <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> for this controller accessible via the getApplication method.</p>\n"},"models":{"!doc":"<p>Array of models to require from AppName.model namespace. For example:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     models: ['User', 'Vehicle']\n });\n</code></pre>\n\n<p>This is equivalent of:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     requires: ['MyApp.model.User', 'MyApp.model.Vehicle'],\n\n     getUserModel: function() {\n         return this.getModel(\"User\");\n     },\n\n     getVehicleModel: function() {\n         return this.getModel(\"Vehicle\");\n     }\n });\n</code></pre>\n"},"moduleClassName":{"!doc":"<p>private</p>\n"},"refs":{"!doc":"<p>You can specify refs with either an Object or an Array:</p>\n\n<pre><code> Ext.define('MyApp.controller.Foo', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         refs: {\n             list: 'grid',\n             user: {\n                 autoCreate: true,\n                 selector: 'form',\n                 xtype: 'form'\n             }\n         }\n     }\n });\n</code></pre>\n\n<p>This will add the <code>getList</code> and <code>getUser</code> methods to the controller which will internally use\nExt.ComponentQuery to reference the resolved component.</p>\n\n<pre><code> Ext.define('MyApp.controller.Foo', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config : {\n         refs: [{\n             ref: 'list',\n             selector: 'grid'\n         }]\n     }\n });\n</code></pre>\n\n<p>This will add method <code>getList</code> to the controller which will internally use\nExt.ComponentQuery to reference the grid component on page.</p>\n\n<p>The recommended way to use refs is within the config object but legacy means of specifying\nrefs as a sibling of the config object is still supported.</p>\n\n<p>The following fields can be used in ref definition:</p>\n\n<ul>\n<li><code>ref</code> - name of the reference.</li>\n<li><code>selector</code> - Ext.ComponentQuery selector to access the component.</li>\n<li><code>autoCreate</code> - True to create the component automatically if not found on page.</li>\n<li><code>forceCreate</code> - Forces the creation of the component every time reference is accessed\n(when <code>get&lt;REFNAME&gt;</code> is called).</li>\n<li><code>xtype</code> - Used to create component by its xtype with autoCreate or forceCreate. If\nyou don't provide xtype, an <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> instance will be created.</li>\n</ul>\n\n"},"stores":{"!doc":"<p>Array of stores to require from AppName.store namespace and to generate getter methods for.\nFor example:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     stores: ['Users', 'Vehicles']\n });\n</code></pre>\n\n<p>This is equivalent to:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n\n     requires: [\n         'MyApp.store.Users',\n         'MyApp.store.Vehicles'\n     ]\n\n     getUsersStore: function() {\n         return this.getStore(\"Users\");\n     },\n\n     getVehiclesStore: function() {\n         return this.getStore(\"Vehicles\");\n     }\n });\n</code></pre>\n"},"views":{"!doc":"<p>Array of views to require from AppName.view namespace and to generate getter methods for.\nFor example:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     views: ['List', 'Detail']\n });\n</code></pre>\n\n<p>This is equivalent of:</p>\n\n<pre><code> Ext.define(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     requires: ['MyApp.view.List', 'MyApp.view.Detail'],\n\n     getListView: function() {\n         return this.getView(\"List\");\n     },\n\n     getDetailView: function() {\n         return this.getView(\"Detail\");\n     }\n });\n</code></pre>\n"},"activate":{"!type":"fn() -> !this","!doc":"<p>Allow the controller to resume receiving events from the event bus.\nRoutes will also be able to begin firing on this controller.\nAlso see <a href=\"#!/api/Ext.app.Controller-method-deactivate\" rel=\"Ext.app.Controller-method-deactivate\" class=\"docClass\">deactivate</a>.</p>\n"},"addRef":{"!type":"fn(refs: ?) -> !this","!doc":"<p>Registers one or more <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">references</a>.</p>\n"},"applyRefs":{"!type":"fn(refs: ?) -> !this"},"deactivate":{"!type":"fn() -> !this","!doc":"<p>Prevent this controller from receiving events from the event bus.\nRoutes will also not be triggered on inactive controllers unless\nthe <a href=\"#!/api/Ext.app.route.Route-cfg-allowInactive\" rel=\"Ext.app.route.Route-cfg-allowInactive\" class=\"docClass\">Ext.app.route.Route.allowInactive</a> flag is set.\nAlso see <a href=\"#!/api/Ext.app.Controller-method-activate\" rel=\"Ext.app.Controller-method-activate\" class=\"docClass\">activate</a>.</p>\n"},"doInit":{"!type":"fn(app: ?) -> !this"},"ensureId":{"!type":"fn() -> !this"},"finishInit":{"!type":"fn(app: ?) -> !this"},"getActive":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-active\" rel=\"Ext.app.Controller-cfg-active\" class=\"docClass\">active</a>.</p>\n"},"getModel":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns a Model class with the given name.</p>\n"},"getRef":{"!type":"fn(ref: ?, info: ?, config: ?) -> !this"},"getRefs":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a>.</p>\n"},"getStore":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns instance of a Store with the given name.\nWhen store doesn't exist yet, it's created.</p>\n"},"getView":{"!type":"fn(view: ?) -> ?","!doc":"<p>Returns a View class with the given name.  To create an instance of the view,\nyou can use it like it's used by Application to create the Viewport:</p>\n\n<pre><code>this.getView('Viewport').create();\n</code></pre>\n"},"hasRef":{"!type":"fn(ref: ?) -> bool","!doc":"<p>Returns <code>true</code> if a <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">reference</a> is registered.</p>\n"},"init":{"!type":"fn(application: ?) -> !this","!doc":"<p>A template method that is called when your application boots. It is called before the\n<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a>'s launch function is executed so gives a hook point\nto run any code before your Viewport is created.</p>\n"},"initAutoGetters":{"!type":"fn() -> !this"},"isActive":{"!type":"fn() -> bool","!doc":"<p>Checks if this controller is active. See <a href=\"#!/api/Ext.app.Controller-method-activate\" rel=\"Ext.app.Controller-method-activate\" class=\"docClass\">activate</a> &amp;\n<a href=\"#!/api/Ext.app.Controller-method-deactivate\" rel=\"Ext.app.Controller-method-deactivate\" class=\"docClass\">deactivate</a>.</p>\n"},"normalizeRefs":{"!type":"fn(refs: ?, newRefs: ?) -> ?","!doc":"<p>Takes either an object and transforms it into an array. The following are valid refs values:</p>\n\n<pre><code>refs: {\n    myComponent: 'container'\n}\n\nrefs: {\n    myComponent: {\n        selector: 'container'\n    }\n}\n\nrefs: [\n    {\n        ref: 'myComponent',\n        selector: 'container'\n    }\n]\n</code></pre>\n"},"onLaunch":{"!type":"fn(application: ?) -> !this","!doc":"<p>A template method like <a href=\"#!/api/Ext.app.Controller-method-init\" rel=\"Ext.app.Controller-method-init\" class=\"docClass\">init</a>, but called after the viewport is created.\nThis is called after the <a href=\"#!/api/Ext.app.Application-method-launch\" rel=\"Ext.app.Application-method-launch\" class=\"docClass\">launch</a> method of Application\nis executed.</p>\n"},"ref":{"!type":"fn(refs: ?) -> !this"},"setActive":{"!type":"fn(active: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-active\" rel=\"Ext.app.Controller-cfg-active\" class=\"docClass\">active</a>.</p>\n"},"setApplication":{"!type":"fn(application: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a>.</p>\n"},"setModuleClassName":{"!type":"fn(moduleClassName: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-moduleClassName\" rel=\"Ext.app.Controller-cfg-moduleClassName\" class=\"docClass\">moduleClassName</a>.</p>\n"},"setRefs":{"!type":"fn(refs: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a>.</p>\n"},"updateRefs":{"!type":"fn(refs: ?) -> !this"},"controllerRegex":{},"strings":{},"destroy":{"!type":"fn(destroyRefs: ?, fromApp: ?) -> !this"},"getApplication":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a>.</p>\n"},"getController":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns instance of a <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller</a> with the given id.\nWhen controller doesn't exist yet, it's created. Note that this method depends\non Application instance and will return undefined when Application is not\naccessible. The only exception is when this Controller instance's id is requested;\nin that case we always return the instance even if Application is no available.</p>\n"},"getModuleClassName":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-moduleClassName\" rel=\"Ext.app.Controller-cfg-moduleClassName\" class=\"docClass\">moduleClassName</a>.</p>\n"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this"},"createGetter":{"!type":"fn(baseGetter: ?, name: ?) -> !this"},"getFullName":{"!type":"fn(name: ?, kind: ?, namespace: ?) -> !this"},"getGetterName":{"!type":"fn(name: ?, kindUpper: ?) -> !this"},"hasRegisteredPrefix":{"!type":"fn(className: ?) -> !this"},"processDependencies":{"!type":"fn(cls: ?, requires: ?, namespace: ?, kind: ?, names: ?) -> !this","!doc":"<p>This method is called like so:</p>\n\n<pre><code> <a href=\"#!/api/Ext.app.Controller-static-method-processDependencies\" rel=\"Ext.app.Controller-static-method-processDependencies\" class=\"docClass\">Ext.app.Controller.processDependencies</a>(proto, requiresArray, 'MyApp', 'model', [\n     'User',\n     'Item',\n     'Foo@Common.model',\n     'Bar.Baz@Common.model'\n ]);\n</code></pre>\n\n<p>Required dependencies are added to requiresArray.</p>\n"}},"!doc":"<p>Controllers are the glue that binds an application together. All they really do is listen for events (usually from\nviews) and take some action. Here's how we might create a Controller to manage Users:</p>\n\n<pre><code> Ext.define('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     init: function() {\n         console.log('Initialized Users! This happens before ' +\n                     'the Application launch() function is called');\n     }\n });\n</code></pre>\n\n<p>The init function is a special method that is called when your application boots. It is called before the\n<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a>'s launch function is executed so gives a hook point to run any code before\nyour Viewport is created.</p>\n\n<p>The init function is a great place to set up how your controller interacts with the view, and is usually used in\nconjunction with another Controller function - <a href=\"#!/api/Ext.app.BaseController-method-control\" rel=\"Ext.app.BaseController-method-control\" class=\"docClass\">control</a>. The control function\nmakes it easy to listen to events on your view classes and take some action with a handler function. Let's update\nour Users controller to tell us when the panel is rendered:</p>\n\n<pre><code> Ext.define('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     init: function() {\n         this.control({\n             'viewport &gt; panel': {\n                 render: this.onPanelRendered\n             }\n         });\n     },\n\n     onPanelRendered: function() {\n         console.log('The panel was rendered');\n     }\n });\n</code></pre>\n\n<p>We've updated the init function to use <a href=\"#!/api/Ext.app.BaseController-method-control\" rel=\"Ext.app.BaseController-method-control\" class=\"docClass\">control method</a> to set up listeners on views\nin our application. The control method uses the ComponentQuery engine to quickly and easily get references to components\non the page. If you are not familiar with ComponentQuery yet, be sure to check out the\ndocumentation. In brief though, it allows us to pass a CSS-like selector that will find\nevery matching component on the page.</p>\n\n<p>In our init function above we supplied 'viewport > panel', which translates to \"find me every Panel that is a direct\nchild of a Viewport\". We then supplied an object that maps event names (just 'render' in this case) to handler\nfunctions. The overall effect is that whenever any component that matches our selector fires a 'render' event, our\nonPanelRendered function is called.</p>\n\n<h2>Event domains</h2>\n\n<p>In Ext JS 4.2, we introduced the concept of event domains. In terms of MVC, an event domain\nis one or more base classes that fire events to which a Controller wants to listen. Besides\nComponent event domain that encompass <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>-descended Views, Controllers now\ncan listen to events from data Stores, Ext.Direct Providers, other Controllers, and Ext.GlobalEvents.\nThis feature provides a way to communicate between parts of the whole application without the need\nto bind controllers together tightly, and allows to develop and test application parts in isolation.</p>\n\n<p>See usage examples in <a href=\"#!/api/Ext.app.BaseController-method-listen\" rel=\"Ext.app.BaseController-method-listen\" class=\"docClass\">listen</a> method documentation.</p>\n\n<h2>Using refs</h2>\n\n<p>One of the most useful parts of Controllers is the ref system. These use the Ext.ComponentQuery to\nmake it really easy to get references to Views on your page. Let's look at an example of this now:</p>\n\n<pre><code> Ext.define('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     refs: [{\n         ref: 'list',\n         selector: 'grid'\n     }],\n\n     init: function() {\n         this.control({\n             'button': {\n                 click: this.refreshGrid\n             }\n         });\n     },\n\n     refreshGrid: function() {\n         this.getList().store.load();\n     }\n });\n</code></pre>\n\n<p>This example assumes the existence of a <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Grid</a> on the page, which contains a single button to\nrefresh the Grid when clicked. In our refs array, we set up a reference to the grid. There are two parts to this -\nthe 'selector', which is a ComponentQuery selector which finds any grid on the page and\nassigns it to the reference 'list'.</p>\n\n<p>By giving the reference a name, we get a number of things for free. The first is the getList function that we use in\nthe refreshGrid method above. This is generated automatically by the Controller based on the name of our ref, which\nwas capitalized and prepended with get to go from 'list' to 'getList'.</p>\n\n<p>The way this works is that the first time getList is called by your code, the ComponentQuery selector is run and the\nfirst component that matches the selector ('grid' in this case) will be returned. All future calls to getList will\nuse a cached reference to that grid. Usually it is advised to use a specific ComponentQuery selector that will only\nmatch a single View in your application (in the case above our selector will match any grid on the page).</p>\n\n<p>Bringing it all together, our init function is called when the application boots, at which time we call this.control\nto listen to any click on a <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> and call our refreshGrid function (again, this will\nmatch any button on the page so we advise a more specific selector than just 'button', but have left it this way for\nsimplicity). When the button is clicked we use out getList function to refresh the grid.</p>\n\n<p>You can create any number of refs and control any number of components this way, simply adding more functions to\nyour Controller as you go. For an example of real-world usage of Controllers see the Feed Viewer example in the\nexamples/app/feed-viewer folder in the SDK download.</p>\n\n<h2>Generated getter methods</h2>\n\n<p>Refs aren't the only thing that generate convenient getter methods. Controllers often have to deal with Models and\nStores so the framework offers a couple of easy ways to get access to those too. Let's look at another example:</p>\n\n<pre><code> Ext.define('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['User'],\n     stores: ['AllUsers', 'AdminUsers'],\n\n     init: function() {\n         var User, allUsers, ed;\n\n         User = this.getUserModel();\n         allUsers = this.getAllUsersStore();\n\n         ed = new User({ name: 'Ed' });\n         allUsers.add(ed);\n     }\n });\n</code></pre>\n\n<p>By specifying Models and Stores that the Controller cares about, it again dynamically loads them from the appropriate\nlocations (app/model/User.js, app/store/AllUsers.js and app/store/AdminUsers.js in this case) and creates getter\nfunctions for them all. The example above will create a new User model instance and add it to the AllUsers Store.\nOf course, you could do anything in this function but in this case we just did something simple to demonstrate the\nfunctionality.</p>\n\n<h2>Further Reading</h2>\n\n<p>For more information about writing Ext JS 4 applications, please see the\n<a href=\"#/guide/application_architecture\">application architecture guide</a>. Also see the <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>\ndocumentation.</p>\n","!type":"fn(config?: ?)"},"BaseController":{"prototype":{"before":{},"control":{"!doc":"<p>Adds listeners to components selected via Ext.ComponentQuery. Accepts an\nobject containing component paths mapped to a hash of listener functions.</p>\n\n<p>In the following example the <code>updateUser</code> function is mapped to to the <code>click</code>\nevent on a button component, which is a child of the <code>useredit</code> component.</p>\n\n<pre><code> Ext.define('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         control: {\n             'useredit button[action=save]': {\n                 click: 'updateUser'\n             }\n          }\n     },\n\n     updateUser: function(button) {\n         console.log('clicked the Save button');\n     }\n });\n</code></pre>\n\n<p>The method you pass to the listener will automatically be resolved on the controller.\nIn this case, the <code>updateUser</code> method that will get executed on the <code>button</code> <code>click</code>\nevent will resolve to the <code>updateUser</code> method on the controller,</p>\n\n<p>See Ext.ComponentQuery for more information on component selectors.</p>\n"},"id":{"!type":"string","!doc":"<p>The id of this controller. You can use this id when dispatching.</p>\n"},"listen":{"!doc":"<p>Adds listeners to different event sources (also called \"event domains\"). The\nprimary event domain is that of components, but there are also other event domains:\n<a href=\"#!/api/Ext.app.domain.Global\" rel=\"Ext.app.domain.Global\" class=\"docClass\">Global</a> domain that intercepts events fired from\nExt.GlobalEvents Observable instance, <a href=\"#!/api/Ext.app.domain.Controller\" rel=\"Ext.app.domain.Controller\" class=\"docClass\">Controller</a>\ndomain can be used to listen to events fired by other Controllers,\n<a href=\"#!/api/Ext.app.domain.Store\" rel=\"Ext.app.domain.Store\" class=\"docClass\">Store</a> domain gives access to Store events, and\n<a href=\"#!/api/Ext.app.domain.Direct\" rel=\"Ext.app.domain.Direct\" class=\"docClass\">Direct</a> domain can be used with Ext.Direct Providers\nto listen to their events.</p>\n\n<p>To listen to \"bar\" events fired by a controller with id=\"foo\":</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         listen: {\n             controller: {\n                 '#foo': {\n                    bar: 'onFooBar'\n                 }\n             }\n         }\n     }\n });\n</code></pre>\n\n<p>To listen to \"bar\" events fired by any controller, and \"baz\" events\nfired by Store with storeId=\"baz\":</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         listen: {\n             controller: {\n                 '*': {\n                    bar: 'onAnyControllerBar'\n                 }\n             },\n             store: {\n                 '#baz': {\n                     baz: 'onStoreBaz'\n                 }\n             }\n         }\n     }\n });\n</code></pre>\n\n<p>To listen to \"idle\" events fired by Ext.GlobalEvents when other event\nprocessing is complete and Ext JS is about to return control to the browser:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         listen: {\n             global: {            // Global events are always fired\n                 idle: 'onIdle'   // from the same object, so there\n             }                    // are no selectors\n         }\n     }\n });\n</code></pre>\n\n<p>As this relates to components, the following example:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         listen: {\n             component: {\n                 'useredit button[action=save]': {\n                    click: 'updateUser'\n                 }\n             }\n         }\n     }\n });\n</code></pre>\n\n<p>Is equivalent to:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         control: {\n             'useredit button[action=save]': {\n                click: 'updateUser'\n             }\n         }\n     }\n });\n</code></pre>\n\n<p>Of course, these can all be combined in a single call and used instead of\n<code>control</code>, like so:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     config: {\n         listen: {\n             global: {\n                 idle: 'onIdle'\n             },\n             controller: {\n                 '*': {\n                    foobar: 'onAnyFooBar'\n                 },\n                 '#foo': {\n                    bar: 'onFooBar'\n                 }\n             },\n             component: {\n                 'useredit button[action=save]': {\n                    click: 'updateUser'\n                 }\n             },\n             store: {\n                 '#qux': {\n                     load: 'onQuxLoad'\n                 }\n             }\n         }\n     }\n });\n</code></pre>\n"},"routes":{"!doc":"<p>An object of routes to handle hash changes. A route can be defined in a simple way:</p>\n\n<pre><code>routes : {\n    'foo/bar'  : 'handleFoo',\n    'user/:id' : 'showUser'\n}\n</code></pre>\n\n<p>Where the property is the hash (which can accept a parameter defined by a colon) and the value\nis the method on the controller to execute. The parameters will get sent in the action method.</p>\n\n<p>At the application level, you can define a event that will be executed when no matching\nroutes are found.</p>\n\n<pre><code>Ext.application({\n    name: 'MyApp',\n    listen: {\n        controller: {\n            '#': {\n                unmatchedroute: 'onUnmatchedRoute'\n            }\n        }\n    },\n\n    onUnmatchedRoute: function(hash) {\n        console.log('Unmatched', hash);\n        // Do something...\n    }\n});\n</code></pre>\n\n<p>There is also a complex means of defining a route where you can use a before action and even\nspecify your own RegEx for the parameter:</p>\n\n<pre><code>routes : {\n    'foo/bar'  : {\n        action  : 'handleFoo',\n        before  : 'beforeHandleFoo'\n    },\n    'user/:id' : {\n        action     : 'showUser',\n        before     : 'beforeShowUser',\n        conditions : {\n            ':id' : '([0-9]+)'\n        }\n    }\n}\n</code></pre>\n\n<p>This will only match if the <code>id</code> parameter is a number.</p>\n\n<p>The before action allows you to cancel an action. Every before action will get passed an <code>action</code> argument with\na <code>resume</code> and <code>stop</code> methods as the last argument of the method and you <em>MUST</em> execute either method:</p>\n\n<pre><code>beforeHandleFoo : function(action) {\n    //some logic here\n\n    //this will allow the handleFoo action to be executed\n    action.resume();\n},\nhandleFoo : function() {\n    //will get executed due to true being passed in callback in beforeHandleFoo\n},\nbeforeShowUser : function(id, action) {\n    //allows for async process like an Ajax\n    Ext.Ajax.request({\n        url     : 'foo.php',\n        success : function() {\n            //will not allow the showUser method to be executed but will continue other queued actions.\n            action.stop();\n        },\n        failure : function() {\n            //will not allow the showUser method to be executed and will not allow other queued actions to be executed.\n            action.stop(true);\n        }\n    });\n},\nshowUser : function(id) {\n    //will not get executed due to false being passed in callback in beforeShowUser\n}\n</code></pre>\n\n<p>You <em>MUST</em> execute the <code>resume</code> or <code>stop</code> method on the <code>action</code> argument. Executing <code>action.resume();</code> will continue\nthe action, <code>action.stop();</code> will not allow the action to resume but will allow other queued actions to resume,\n<code>action.stop(true);</code> will not allow the action and any other queued actions to resume.</p>\n\n<p>The default RegEx that will be used is <code>([%a-zA-Z0-9\\\\-\\\\_\\\\s,]+)</code> but you can specify any\nthat may suit what you need to accomplish. An example of an advanced condition may be to make\na parameter optional and case-insensitive:</p>\n\n<pre><code>routes : {\n    'user:id' : {\n        action     : 'showUser',\n        before     : 'beforeShowUser',\n        conditions : {\n            ':id' : '(?:(?:\\/){1}([%a-z0-9_,\\s\\-]+))?'\n        }\n    }\n}\n</code></pre>\n"},"isController":{"!type":"bool"},"applyControl":{"!type":"fn(control: ?) -> !this"},"applyListen":{"!type":"fn(listen: ?) -> !this"},"getBefore":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.BaseController-cfg-before\" rel=\"Ext.app.BaseController-cfg-before\" class=\"docClass\">before</a>.</p>\n"},"getControl":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.BaseController-cfg-control\" rel=\"Ext.app.BaseController-cfg-control\" class=\"docClass\">control</a>.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.BaseController-cfg-id\" rel=\"Ext.app.BaseController-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getListen":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.BaseController-cfg-listen\" rel=\"Ext.app.BaseController-cfg-listen\" class=\"docClass\">listen</a>.</p>\n"},"getRoutes":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.BaseController-cfg-routes\" rel=\"Ext.app.BaseController-cfg-routes\" class=\"docClass\">routes</a>.</p>\n"},"redirectTo":{"!type":"fn(token: ?, force: ?) -> bool","!doc":"<p>Update the hash. By default, it will not execute the routes if the current token and the\ntoken passed are the same.</p>\n"},"setBefore":{"!type":"fn(before: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.BaseController-cfg-before\" rel=\"Ext.app.BaseController-cfg-before\" class=\"docClass\">before</a>.</p>\n"},"setControl":{"!type":"fn(control: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.BaseController-cfg-control\" rel=\"Ext.app.BaseController-cfg-control\" class=\"docClass\">control</a>.</p>\n"},"setId":{"!type":"fn(id: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.BaseController-cfg-id\" rel=\"Ext.app.BaseController-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"setListen":{"!type":"fn(listen: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.BaseController-cfg-listen\" rel=\"Ext.app.BaseController-cfg-listen\" class=\"docClass\">listen</a>.</p>\n"},"setRoutes":{"!type":"fn(routes: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.BaseController-cfg-routes\" rel=\"Ext.app.BaseController-cfg-routes\" class=\"docClass\">routes</a>.</p>\n"},"updateControl":{"!type":"fn(control: ?) -> !this"},"updateListen":{"!type":"fn(listen: ?) -> !this"},"updateRoutes":{"!type":"fn(routes: ?) -> !this"},"destroy":{"!type":"fn() -> !this"},"isActive":{"!type":"fn() -> !this"}},"!doc":"<p>Base class for Controllers.</p>\n","!type":"fn(config?: ?)"},"bindinspector":{"Environment":{"prototype":{"buildBind":{"!type":"fn(bind: ?) -> !this"},"buildComponent":{"!type":"fn(comp: ?) -> !this"},"buildStub":{"!type":"fn(stub: ?, isLinkChild: ?) -> !this"},"buildStubName":{"!type":"fn(stub: ?) -> !this"},"buildViewModel":{"!type":"fn(vm: ?, comp: ?) -> !this"},"captureSnapshot":{"!type":"fn() -> !this","!doc":"<ul>\n<li>Capture methods</li>\n</ul>\n\n"},"createModel":{"!type":"fn(entityName: ?, data: ?) -> !this"},"deserializeStub":{"!type":"fn(stub: ?) -> !this"},"deserializeValue":{"!type":"fn(info: ?) -> !this"},"getCmp":{"!type":"fn(id: ?) -> !this","!doc":"<ul>\n<li>Utility methods</li>\n</ul>\n\n"},"getInheritedVM":{"!type":"fn(comp: ?) -> !this"},"getVM":{"!type":"fn(id: ?) -> !this"},"isRootComponent":{"!type":"fn(c: ?) -> !this"},"serializeModel":{"!type":"fn(Model: ?) -> !this"},"serializeValue":{"!type":"fn(value: ?, checkHasOwn: ?) -> !this"},"unpackComponent":{"!type":"fn(comp: ?, allComponents: ?, allViewModels: ?) -> !this"},"unpackSnapshot":{"!type":"fn(data: ?) -> !this"}}},"Util":{"buildBindData":{"!type":"fn(bind: ?) -> !this"},"getChildStub":{"!type":"fn(name: ?, parent: ?) -> !this"},"valueRenderer":{"!type":"fn(v: ?) -> !this"}}},"domain":{"Component":{"!doc":"<p>This class implements the component event domain. All classes extending from\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> are included in this domain. The matching criteria uses\nExt.ComponentQuery.</p>\n","!type":"fn()","type":{"!type":"string"},"dispatch":{"!type":"fn(target: ?, ev: ?, args: ?) -> bool","!doc":"<p>This method dispatches an event fired by an object monitored by this domain. This\nis not called directly but is called by interceptors injected by the <code>monitor</code> method.</p>\n"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.domain.Component-cfg-idProperty\" rel=\"Ext.app.domain.Component-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}},"Controller":{"!doc":"<p>This class implements the controller event domain. All classes extending from\n<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a> are included in this domain. The selectors are simply id's or the\nwildcard \"*\" to match any controller.</p>\n","!type":"fn()","idMatchRe":{},"prefix":{"!type":"string"},"type":{"!type":"string"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.domain.Controller-cfg-idProperty\" rel=\"Ext.app.domain.Controller-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}},"Direct":{"!doc":"<p>This class implements the Ext.Direct event domain. All classes extending from\nExt.direct.Provider are included in this domain. The selectors are simply provider\nid's or the wildcard \"*\" to match any provider.</p>\n","!type":"fn()","idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"type":{"!type":"string"}},"Global":{"!doc":"<p>This class implements the global event domain. This domain represents event fired from\nExt.GlobalEvents Observable instance. No selectors are supported for this domain.</p>\n","!type":"fn()","match":{},"type":{"!type":"string"},"listen":{"!type":"fn(listeners: ?, controller: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. Since Global domain does not\nsupport selectors, we skip this layer and just accept an object keyed by events.\nFor example:</p>\n\n<pre><code> domain.listen({\n     idle: function() { ... },\n     afterlayout: {\n         fn: function() { ... },\n         delay: 10\n     }\n });\n</code></pre>\n"}},"Store":{"!doc":"<p>This class implements the data store event domain. All classes extending from\nExt.data.AbstractStore are included in this domain. The selectors are simply\nstore id's or the wildcard \"*\" to match any store.</p>\n","!type":"fn()","idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"type":{"!type":"string"}},"View":{"!type":"fn(controller: ?)","prototype":{"isInstance":{"!type":"bool"},"destroy":{"!type":"fn() -> !this"},"match":{"!type":"fn(target: ?, selector: ?, controller: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.domain.View-cfg-idProperty\" rel=\"Ext.app.domain.View-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}}}},"EventDomain":{"idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"isInstance":{"!type":"bool"},"destroy":{"!type":"fn() -> !this"},"listen":{"!type":"fn(selectors: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. This method is passed an\nobject that is keyed by selectors. The value of these is also an object but now\nkeyed by event name. For example:</p>\n\n<pre><code> domain.listen({\n     'some[selector]': {\n         click: function() { ... }\n     },\n\n     'other selector': {\n         change: {\n             fn: function() { ... },\n             delay: 10\n         }\n     }\n\n }, controller);\n</code></pre>\n"},"monitor":{"!type":"fn(observable: ?) -> !this","!doc":"<p>This method is called by the derived class to monitor <code>fireEvent</code> calls. Any call\nto <code>fireEvent</code> on the target Observable will be intercepted and dispatched to any\nlistening Controllers. Assuming the original <code>fireEvent</code> method does not return\n<code>false</code>, the event is passed to the <code>dispatch</code> method of this object.</p>\n\n<p>This is typically called in the <code>constructor</code> of derived classes.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"},"dispatch":{"!type":"fn(target: ?, ev: ?, args: ?) -> bool","!doc":"<p>This method dispatches an event fired by an object monitored by this domain. This\nis not called directly but is called by interceptors injected by the <code>monitor</code> method.</p>\n"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.EventDomain-cfg-idProperty\" rel=\"Ext.app.EventDomain-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"},"prototype":{"idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"dispatch":{"!type":"fn(target: ?, ev: ?, args: ?) -> bool","!doc":"<p>This method dispatches an event fired by an object monitored by this domain. This\nis not called directly but is called by interceptors injected by the <code>monitor</code> method.</p>\n"},"listen":{"!type":"fn(selectors: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. This method is passed an\nobject that is keyed by selectors. The value of these is also an object but now\nkeyed by event name. For example:</p>\n\n<pre><code> domain.listen({\n     'some[selector]': {\n         click: function() { ... }\n     },\n\n     'other selector': {\n         change: {\n             fn: function() { ... },\n             delay: 10\n         }\n     }\n\n }, controller);\n</code></pre>\n"},"monitor":{"!type":"fn(observable: ?) -> !this","!doc":"<p>This method is called by the derived class to monitor <code>fireEvent</code> calls. Any call\nto <code>fireEvent</code> on the target Observable will be intercepted and dispatched to any\nlistening Controllers. Assuming the original <code>fireEvent</code> method does not return\n<code>false</code>, the event is passed to the <code>dispatch</code> method of this object.</p>\n\n<p>This is typically called in the <code>constructor</code> of derived classes.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"},"isInstance":{"!type":"bool"},"instances":{"!doc":"<p>An object map containing <code><a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a></code> instances keyed by the value\nof their <code>type</code> property.</p>\n"},"destroy":{"!type":"fn() -> !this"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.EventDomain-cfg-idProperty\" rel=\"Ext.app.EventDomain-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}},"!doc":"<p>This class is a base class for an event domain. In the context of MVC, an \"event domain\"\nis one or more base classes that fire events to which a Controller wants to listen. A\ncontroller listens to events by describing the selectors for events of interest to it.</p>\n\n<p>Matching selectors to the firer of an event is one key aspect that defines an event\ndomain. All event domain instances must provide a <code>match</code> method that tests selectors\nagainst the event firer.</p>\n\n<p>When an event domain instance is created (typically as a <code>singleton</code>), its <code>type</code>\nproperty is used to catalog the domain in the\n<a href=\"#!/api/Ext.app.EventDomain-static-property-instances\" rel=\"Ext.app.EventDomain-static-property-instances\" class=\"docClass\">Ext.app.EventDomain.instances</a> map.</p>\n\n<p>There are five event domains provided by default:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.app.domain.Component\" rel=\"Ext.app.domain.Component\" class=\"docClass\">Component domain</a>. This is the primary event domain that\nhas been available since Ext JS MVC was introduced. This domain is defined as any class that\nextends <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, where the selectors use\nExt.ComponentQuery.</li>\n<li><a href=\"#!/api/Ext.app.domain.Global\" rel=\"Ext.app.domain.Global\" class=\"docClass\">Global domain</a>. This domain provides Controllers with access\nto events fired from Ext.GlobalEvents Observable instance. These events represent\nthe state of the application as a whole, and are always anonymous. Because of this, Global\ndomain does not provide selectors at all.</li>\n<li><a href=\"#!/api/Ext.app.domain.Controller\" rel=\"Ext.app.domain.Controller\" class=\"docClass\">Controller domain</a>. This domain includes all classes\nthat extend <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>. Events fired by Controllers will be available\nwithin this domain; selectors are either Controller's <a href=\"#!/api/Ext.app.Controller-cfg-id\" rel=\"Ext.app.Controller-cfg-id\" class=\"docClass\">id</a> or\n'*' wildcard for any Controller.</li>\n<li><a href=\"#!/api/Ext.app.domain.Store\" rel=\"Ext.app.domain.Store\" class=\"docClass\">Store domain</a>. This domain is for classes extending\nExt.data.AbstractStore. Selectors are either Store's\nstoreId or '*' wildcard for any Store.</li>\n<li><a href=\"#!/api/Ext.app.domain.Direct\" rel=\"Ext.app.domain.Direct\" class=\"docClass\">Direct domain</a>. This domain includes all classes that extend\nExt.direct.Provider. Selectors are either Provider's id\nor '*' wildcard for any Provider. This domain is optional and will be loaded only if\nExt.direct.Manager singleton is required in your application.</li>\n</ul>\n\n","!type":"fn()"},"EventBus":{"!doc":"<p>This class manages event dispatching for Controllers. The details of connecting classes\nto this dispatching mechanism is delegated to <a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a> instances.</p>\n","!type":"fn()","control":{"!type":"fn(selectors: ?, controller: ?) -> !this","!doc":"<p>Adds a set of component event listeners for a controller. To work with event domains\nother than component, see <a href=\"#!/api/Ext.app.EventBus-method-listen\" rel=\"Ext.app.EventBus-method-listen\" class=\"docClass\">listen</a>.</p>\n"},"listen":{"!type":"fn(to: ?, controller: ?) -> !this","!doc":"<p>Adds a set of event domain listeners for a controller. For more information on event\ndomains, see <a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a> and <a href=\"#!/api/Ext.app.BaseController\" rel=\"Ext.app.BaseController\" class=\"docClass\">Ext.app.BaseController</a>.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"}},"route":{"Queue":{"!doc":"<p>A Queue is a queue of <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> instances managed by the\n<a href=\"#!/api/Ext.app.route.Router\" rel=\"Ext.app.route.Router\" class=\"docClass\">Ext.app.route.Router</a> singleton if queueActions is set to <code>true</code>.</p>\n\n<p>A developer shouldn't need to use this class as <a href=\"#!/api/Ext.app.route.Router\" rel=\"Ext.app.route.Router\" class=\"docClass\">Ext.app.route.Router</a> should\nmanage this class. When a <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> is executed,it will automatically\nkeep running the queue until the queue is empty.</p>\n","!type":"fn(config: ?)","prototype":{"queue":{"!doc":"<p>The Ext.util.MixedCollection that will hold the queued\n<a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> and recognized arguments.</p>\n"},"token":{"!doc":"<p>The token from the <a href=\"#!/api/Ext.app.route.Router\" rel=\"Ext.app.route.Router\" class=\"docClass\">Ext.app.route.Router</a> that is being enacted on.</p>\n"},"clearQueue":{"!type":"fn() -> !this","!doc":"<p>Clear all queued actions.</p>\n"},"onActionExecute":{"!type":"fn(clearQueue: ?) -> !this","!doc":"<p>Handle the execution of a queued action and optionally clear all queued actions.</p>\n"},"queueAction":{"!type":"fn(route: ?, args: ?) -> !this","!doc":"<p>Add a <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> to the queue.</p>\n"},"runQueue":{"!type":"fn() -> !this","!doc":"<p>Run the queue one by one.</p>\n"}}},"Route":{"!doc":"<p>Represents a mapping between a url and a controller/action pair. May also contain\nadditional params.</p>\n\n<p>This is a private internal class that should not need to be used by end-developer code.\nIts API and existence are subject to change so use at your own risk.</p>\n","!type":"fn(config: ?)","prototype":{"action":{"!type":"string","!doc":"<p>The name of the action that will be called on the\n<a href=\"#!/api/Ext.app.route.Route-cfg-controller\" rel=\"Ext.app.route.Route-cfg-controller\" class=\"docClass\">controller</a> if this route is matched.</p>\n"},"allowInactive":{"!type":"bool","!doc":"<p><code>true</code> to allow this route to be triggered on\na controller that is not active.</p>\n"},"before":{"!doc":"<p>An optional function to use to intercept the <a href=\"#!/api/Ext.app.route.Route-cfg-action\" rel=\"Ext.app.route.Route-cfg-action\" class=\"docClass\">action</a>\nto do extra means and possibly stop the execution. An example is if the route is\nfor editing a user and you need to verify the current user has permission you can\nsend an Ext.Ajax request to a server or some arbitrary code.</p>\n"},"caseInsensitive":{"!type":"bool","!doc":"<p><code>true</code> to allow the tokens to be matched with\ncase-insensitive. Defaults to <code>false</code> which will force case matching.</p>\n"},"conditions":{"!doc":"<p>Optional set of conditions for each token in the url\nstring. Each key should be one of the tokens, each value should be a regex that the\ntoken should accept. For example, if you have a Route with a url like\n<code>\"files/:fileName\"</code> and you want it to match urls like \"files/someImage.jpg\" then\nyou can set these conditions to allow the :fileName token to accept strings\ncontaining a period (\".\"):</p>\n\n<pre><code>conditions: {\n    ':fileName': \"[0-9a-zA-Z\\.]+\"\n}\n</code></pre>\n"},"controller":{"!type":"string","!doc":"<p>The name of the Controller whose <a href=\"#!/api/Ext.app.route.Route-cfg-action\" rel=\"Ext.app.route.Route-cfg-action\" class=\"docClass\">action</a> will be\ncalled if this route is matched.</p>\n"},"url":{"!type":"string","!doc":"<p>The url regex to match against.</p>\n"},"matcherRegex":{"!doc":"<p>A regular expression to match the token to the configured <a href=\"#!/api/Ext.app.route.Route-cfg-url\" rel=\"Ext.app.route.Route-cfg-url\" class=\"docClass\">url</a>.</p>\n"},"paramMatchingRegex":{"!doc":"<p>A regular expression to check if there are parameters in the configured <a href=\"#!/api/Ext.app.route.Route-cfg-url\" rel=\"Ext.app.route.Route-cfg-url\" class=\"docClass\">url</a>.</p>\n"},"paramsInMatchString":{"!doc":"<p>An array of parameters in the configured <a href=\"#!/api/Ext.app.route.Route-cfg-url\" rel=\"Ext.app.route.Route-cfg-url\" class=\"docClass\">url</a>.</p>\n"},"createCallback":{"!type":"fn(args: ?, callback: ?, scope: ?) -> ?","!doc":"<p>Creates the callback function to execute in the configured <a href=\"#!/api/Ext.app.route.Route-cfg-before\" rel=\"Ext.app.route.Route-cfg-before\" class=\"docClass\">before</a> function.</p>\n"},"createMatcherRegex":{"!type":"fn(url: ?) -> ?","!doc":"<p>Takes the configured url string including wildcards and returns a regex that can be\nused to match against a url.</p>\n"},"execute":{"!type":"fn(token: ?, argConfig: ?, callback: ?, scope: ?) -> !this","!doc":"<p>The method to execute the action using the configured before function which will\nkick off the actual <a href=\"#!/api/Ext.app.route.Route-cfg-action\" rel=\"Ext.app.route.Route-cfg-action\" class=\"docClass\">action</a> on the <a href=\"#!/api/Ext.app.route.Route-cfg-controller\" rel=\"Ext.app.route.Route-cfg-controller\" class=\"docClass\">controller</a>.</p>\n"},"matchesFor":{"!type":"fn(url: ?) -> ?","!doc":"<p>Returns a hash of matching url segments for the given url.</p>\n"},"recognize":{"!type":"fn(url: ?) -> ?","!doc":"<p>Attempts to recognize a given url string and return controller/action pair for it.</p>\n"},"recognizes":{"!type":"fn(url: ?) -> bool","!doc":"<p>Returns true if this <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> matches the given url string.</p>\n"}}},"Router":{"!doc":"<p>The Router is an ordered set of <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> definitions that decode a\nurl into a controller function to execute. Each <code>route</code> defines a type of url to match,\nalong with the controller function to call if it is matched. The Router uses the\n<a href=\"#!/api/Ext.util.History\" rel=\"Ext.util.History\" class=\"docClass\">Ext.util.History</a> singleton to find out when the browser's url has changed.</p>\n\n<p>Routes are almost always defined inside a <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller</a>, as\nopposed to on the Router itself. End-developers should not usually need to interact\ndirectly with the Router as the Controllers manage everything automatically. See the\n<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller documentation</a> for more information on specifying\nroutes.</p>\n","multipleToken":{"!type":"string","!doc":"<p>The token to split the routes to support multiple routes.</p>\n"},"queueRoutes":{"!type":"bool","!doc":"<p>True to queue routes to be executed one after the\nother, false to execute routes immediately.</p>\n"},"routes":{"!doc":"<p>The connected <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a>\ninstances.</p>\n"},"clear":{"!type":"fn() -> !this","!doc":"<p>Clear all the recognized routes.</p>\n"},"connect":{"!type":"fn(url: ?, action: ?, controller: ?) -> !this","!doc":"<p>Create the <a href=\"#!/api/Ext.app.route.Route\" rel=\"Ext.app.route.Route\" class=\"docClass\">Ext.app.route.Route</a> instance and connect to the\n<a href=\"#!/api/Ext.app.route.Router\" rel=\"Ext.app.route.Router\" class=\"docClass\">Ext.app.route.Router</a> singleton.</p>\n"},"disconnectAll":{"!type":"fn(controller: ?) -> !this","!doc":"<p>Disconnects all routes for a controller.</p>\n"},"draw":{"!type":"fn(fn: ?) -> !this","!doc":"<p>Convenience method which just calls the supplied function with the\n<a href=\"#!/api/Ext.app.route.Router\" rel=\"Ext.app.route.Router\" class=\"docClass\">Ext.app.route.Router</a> singleton. Example usage:</p>\n\n<pre><code><a href=\"#!/api/Ext.app.route.Router-method-draw\" rel=\"Ext.app.route.Router-method-draw\" class=\"docClass\">Ext.app.route.Router.draw</a>(function(map) {\n    map.connect('activate/:token', {controller: 'users', action: 'activate'});\n    map.connect('home',            {controller: 'index', action: 'home'});\n});\n</code></pre>\n"},"onStateChange":{"!type":"fn(token: ?) -> !this","!doc":"<p>React to a token</p>\n"},"recognize":{"!type":"fn(url: ?) -> ?","!doc":"<p>Recognizes a url string connected to the Router, return the controller/action pair\nplus any additional config associated with it.</p>\n"}}},"Util":{"prototype":{"addNamespaces":{"!type":"fn(namespace: ?) -> !this","!doc":"<p>Adds namespace(s) to known list.</p>\n"},"clearNamespaces":{"!type":"fn() -> !this","!doc":"<p>Clear all namespaces from known list.</p>\n"},"getNamespace":{"!type":"fn(className: ?) -> string","!doc":"<p>Get namespace prefix for a class name.</p>\n"}}},"ViewController":{"!doc":"<p>A view controller is a controller that can be attached to a specific view\ninstance so it can manage the view and it's child components. Each instance of the view\nwill have a new view controller, so the instances are isolated.</p>\n\n<p>When a controller is specified on a view, the view automatically becomes a <a href=\"#!/api/Ext.container.Container-cfg-referenceHolder\" rel=\"Ext.container.Container-cfg-referenceHolder\" class=\"docClass\">Ext.container.Container.referenceHolder</a>,\nso it will receive inline events declared on the view. Sample usage:</p>\n\n<pre class='inline-example '><code>Ext.define('User', {\n   extend: 'Ext.data.Model',\n   fields: ['name', 'phone']    \n});\n\nExt.define('UserListController', {\n    extend : '<a href=\"#!/api/Ext.app.ViewController\" rel=\"Ext.app.ViewController\" class=\"docClass\">Ext.app.ViewController</a>',\n    alias: 'controller.userlist',\n\n    init: function() {\n        this.userCount = 0;\n        var users = [],\n            i;\n\n        for (i = 0; i &lt; 5; ++i) {\n            users.push(this.getUser());\n        }  \n        this.getView().getStore().add(users);\n    },\n\n    onAddClick: function() {\n        this.addUser();\n    },\n\n    onDeleteClick: function() {\n        var view = this.getView(),\n            selected = view.getSelectionModel().getSelection()[0],\n            store = view.getStore();\n\n        store.remove(selected);\n    },\n\n    onSelectionChange: function(selModel, selections) {\n        this.lookupReference('delete').setDisabled(selections.length === 0);\n    },\n\n    getUser: function() {\n        ++this.userCount;\n        return {\n            name: 'User ' + this.userCount,\n            phone: this.generatePhone()\n        };\n    },\n\n    addUser: function() {\n        this.getView().getStore().add(this.getUser());    \n    },\n\n    generatePhone: function() {\n        var num = '',\n            i;\n\n        for (i = 0; i &lt; 7; ++i) {\n            num += Ext.Number.randomInt(0, 9);\n            if (num.length === 3) {\n                num += '-';\n            }\n        }    \n        return num;\n    }\n});\n\nExt.define('UserList', {\n    extend: '<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>',\n    controller: 'userlist',\n\n    tbar: [{\n        text: 'Add',\n        listeners: {\n            click: 'onAddClick'\n        }    \n    }, {\n        text: 'Delete',\n        reference: 'delete',\n        listeners: {\n            click: 'onDeleteClick'\n        }\n    }],\n    store: {\n        model: 'User'\n    },\n    selModel: {\n        type: 'rowmodel',\n        listeners: {\n            selectionchange: 'onSelectionChange'\n        }    \n    },\n    columns: [{\n        flex: 1,\n        dataIndex: 'name',\n        text: 'Name'\n    }, {\n        flex: 1,\n        dataIndex: 'phone',\n        text: 'Phone'\n    }]\n});\n\nExt.onReady(function() {\n    new UserList({\n        renderTo: Ext.getBody(),\n        width: 400,\n        height: 200\n    });\n});\n</code></pre>\n","!type":"fn()","prototype":{"closeViewAction":{"!type":"string"},"factoryConfig":{},"isViewController":{"!type":"bool"},"privates":{"!doc":"<hr />\n"},"attachReference":{"!type":"fn(component: ?) -> !this","!doc":"<p>Set a reference to a component.</p>\n"},"beforeInit":{"!type":"fn(view: ?) -> !this","!doc":"<p>Called before the view initializes. This is called before the view's\ninitComponent method has been called.</p>\n"},"clearReference":{"!type":"fn(ref: ?) -> !this","!doc":"<p>Clear a reference to a component</p>\n"},"clearReferences":{"!type":"fn() -> !this","!doc":"<p>Invalidates the references collection. Typically called when\nremoving a container from this container, since it's difficult\nto know what references got removed.</p>\n"},"closeView":{"!type":"fn() -> !this","!doc":"<p>This method closes the associated view. The manner in which this is done (that is,\nthe method called to close the view) is specified by <code>closeViewAction</code>.</p>\n\n<p>It is common for views to map one or more events to this method to allow the view\nto be closed.</p>\n"},"control":{"!type":"fn(selectors: ?, listeners: ?) -> !this","!doc":"<p>Adds listeners to components selected via Ext.ComponentQuery. Accepts an\nobject containing component paths mapped to a hash of listener functions.</p>\n\n<p>In the following example the <code>updateUser</code> function is mapped to to the <code>click</code>\nevent on a button component, which is a child of the <code>useredit</code> component.</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.control({\n             'useredit button[action=save]': {\n                 click: this.updateUser\n             }\n         });\n     },\n\n     updateUser: function(button) {\n         console.log('clicked the Save button');\n     }\n });\n</code></pre>\n\n<p>Or alternatively one call <code>control</code> with two arguments:</p>\n\n<pre><code> this.control('useredit button[action=save]', {\n     click: this.updateUser\n });\n</code></pre>\n\n<p>See Ext.ComponentQuery for more information on component selectors.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy the view controller.</p>\n"},"fireViewEvent":{"!type":"fn(eventName: ?, args: ?) -> bool","!doc":"<p>Fires an event on the view. See Ext.Component.fireEvent.</p>\n"},"getCloseViewAction":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.app.ViewController-cfg-closeViewAction\" rel=\"Ext.app.ViewController-cfg-closeViewAction\" class=\"docClass\">closeViewAction</a>.</p>\n"},"getReferences":{"!type":"fn() -> ?","!doc":"<p>Returns an object holding the descendants of this view keyed by their\n<code>reference</code>. This object should not be held\npast the scope of the function calling this method. It will not be valid if items\nare added or removed from this or any sub-container.</p>\n\n<p>The intended usage is shown here (assume there are 3 components with reference\nvalues of \"foo\", \"bar\" and \"baz\" at some level below this container):</p>\n\n<pre><code> onClick: function () {\n     var refs = this.getReferences();\n\n     // using \"refs\" we can access any descendant by its \"reference\"\n\n     refs.foo.getValue() + refs.bar.getValue() + refs.baz.getValue();\n }\n</code></pre>\n\n<p>If <code>this</code> component has a <code>reference</code> assigned\nto it, that is <strong>not</strong> included in this object. That reference is understood to\nbelong to the ancestor container configured as the <code>referenceHolder</code>.</p>\n"},"getSession":{"!type":"fn() -> !this"},"getStore":{"!type":"fn(name: ?) -> !this"},"getView":{"!type":"fn() -> ?","!doc":"<p>Get the view for this controller.</p>\n"},"getViewModel":{"!type":"fn() -> !this"},"init":{"!type":"fn(view: ?) -> !this","!doc":"<p>Called when the view initializes. This is called after the view's initComponent\nmethod has been called.</p>\n"},"initViewModel":{"!type":"fn(viewModel: ?) -> !this","!doc":"<p>Called when the view model instance for an attached view is first created.</p>\n"},"listen":{"!type":"fn(to: ?, controller: ?) -> !this","!doc":"<p>Adds listeners to different event sources (also called \"event domains\"). The\nprimary event domain is that of components, but there are also other event domains:\n<a href=\"#!/api/Ext.app.domain.Global\" rel=\"Ext.app.domain.Global\" class=\"docClass\">Global</a> domain that intercepts events fired from\nExt.GlobalEvents Observable instance, <a href=\"#!/api/Ext.app.domain.Controller\" rel=\"Ext.app.domain.Controller\" class=\"docClass\">Controller</a>\ndomain can be used to listen to events fired by other Controllers,\n<a href=\"#!/api/Ext.app.domain.Store\" rel=\"Ext.app.domain.Store\" class=\"docClass\">Store</a> domain gives access to Store events, and\n<a href=\"#!/api/Ext.app.domain.Direct\" rel=\"Ext.app.domain.Direct\" class=\"docClass\">Direct</a> domain can be used with Ext.Direct Providers\nto listen to their events.</p>\n\n<p>To listen to \"bar\" events fired by a controller with id=\"foo\":</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             controller: {\n                 '#foo': {\n                    bar: this.onFooBar\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>To listen to \"bar\" events fired by any controller, and \"baz\" events\nfired by Store with storeId=\"baz\":</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             controller: {\n                 '*': {\n                    bar: this.onAnyControllerBar\n                 }\n             },\n             store: {\n                 '#baz': {\n                     baz: this.onStoreBaz\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>To listen to \"idle\" events fired by Ext.GlobalEvents when other event\nprocessing is complete and Ext JS is about to return control to the browser:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             global: {               // Global events are always fired\n                 idle: this.onIdle   // from the same object, so there\n             }                       // are no selectors\n         });\n     }\n });\n</code></pre>\n\n<p>As this relates to components, the following example:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             component: {\n                 'useredit button[action=save]': {\n                    click: this.updateUser\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>Is equivalent to:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.control({\n             'useredit button[action=save]': {\n                click: this.updateUser\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>Of course, these can all be combined in a single call and used instead of\n<code>control</code>, like so:</p>\n\n<pre><code> Ext.define('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             global: {\n                 idle: this.onIdle\n             },\n             controller: {\n                 '*': {\n                    foobar: this.onAnyFooBar\n                 },\n                 '#foo': {\n                    bar: this.onFooBar\n                 }\n             },\n             component: {\n                 'useredit button[action=save]': {\n                    click: this.updateUser\n                 }\n             },\n             store: {\n                 '#qux': {\n                     load: this.onQuxLoad\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n"},"lookupReference":{"!type":"fn(key: ?) -> ?","!doc":"<p>Get a reference to a component set with the Ext.Component.reference\nconfiguration.</p>\n"},"lookupReferenceHolder":{"!type":"fn() -> !this"},"setCloseViewAction":{"!type":"fn(closeViewAction: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.app.ViewController-cfg-closeViewAction\" rel=\"Ext.app.ViewController-cfg-closeViewAction\" class=\"docClass\">closeViewAction</a>.</p>\n"},"setView":{"!type":"fn(view: ?) -> !this","!doc":"<p>Sets the view for this controller. To be called by the view\nwhen it initializes.</p>\n"}}}},"button":{"Button":{"!doc":"<p>Create simple buttons with this component. Customisations include <a href=\"#!/api/Ext.button.Button-cfg-iconAlign\" rel=\"Ext.button.Button-cfg-iconAlign\" class=\"docClass\">aligned</a>\n<a href=\"#!/api/Ext.button.Button-cfg-iconCls\" rel=\"Ext.button.Button-cfg-iconCls\" class=\"docClass\">icons</a>, <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">dropdown menus</a>, <a href=\"#!/api/Ext.button.Button-cfg-tooltip\" rel=\"Ext.button.Button-cfg-tooltip\" class=\"docClass\">tooltips</a>\nand <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">sizing options</a>. Specify a <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> to run code when\na user clicks the button, or use listeners for other events such as\n<a href=\"#!/api/Ext.button.Button-event-mouseover\" rel=\"Ext.button.Button-event-mouseover\" class=\"docClass\">mouseover</a>. Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text: 'Click me',\n    renderTo: Ext.getBody(),\n    handler: function() {\n        alert('You clicked the button!');\n    }\n});\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> configuration can also be updated dynamically using the <a href=\"#!/api/Ext.button.Button-method-setHandler\" rel=\"Ext.button.Button-method-setHandler\" class=\"docClass\">setHandler</a>\nmethod.  Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text    : 'Dynamic Handler Button',\n    renderTo: Ext.getBody(),\n    handler : function() {\n        // this button will spit out a different number every time you click it.\n        // so firstly we must check if that number is already set:\n        if (this.clickCount) {\n            // looks like the property is already set, so lets just add 1 to that number and alert the user\n            this.clickCount++;\n            alert('You have clicked the button \"' + this.clickCount + '\" times.\\n\\nTry clicking it again..');\n        } else {\n            // if the clickCount property is not set, we will set it and alert the user\n            this.clickCount = 1;\n            alert('You just clicked the button for the first time!\\n\\nTry pressing it again..');\n        }\n    }\n});\n</code></pre>\n\n<p>A button within a container:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a>', {\n    renderTo: Ext.getBody(),\n    items   : [\n        {\n            xtype: 'button',\n            text : 'My Button'\n        }\n    ]\n});\n</code></pre>\n\n<p>A useful option of Button is the <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">scale</a> configuration. This configuration has three different options:</p>\n\n<ul>\n<li><code>'small'</code></li>\n<li><code>'medium'</code></li>\n<li><code>'large'</code></li>\n</ul>\n\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    renderTo: document.body,\n    text    : 'Click me',\n    scale   : 'large'\n});\n</code></pre>\n\n<p>Buttons can also be toggled. To enable this, you simple set the <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> property to <code>true</code>.\nExample usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    renderTo: Ext.getBody(),\n    text: 'Click Me',\n    enableToggle: true\n});\n</code></pre>\n\n<p>You can assign a menu to a button by using the <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> configuration. This standard configuration\ncan either be a reference to a <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> object, a <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> id or a\n<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> config blob. When assigning a menu to a button, an arrow is automatically\nadded to the button.  You can change the alignment of the arrow using the <a href=\"#!/api/Ext.button.Button-cfg-arrowAlign\" rel=\"Ext.button.Button-cfg-arrowAlign\" class=\"docClass\">arrowAlign</a> configuration\non button.  Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text      : 'Menu button',\n    renderTo  : Ext.getBody(),\n    arrowAlign: 'bottom',\n    menu      : [\n        {text: 'Item 1'},\n        {text: 'Item 2'},\n        {text: 'Item 3'},\n        {text: 'Item 4'}\n    ]\n});\n</code></pre>\n\n<p>Using listeners, you can easily listen to events fired by any component, using the listeners\nconfiguration or using the <a href=\"#!/api/Ext.button.Button-method-addListener\" rel=\"Ext.button.Button-method-addListener\" class=\"docClass\">addListener</a> method.  Button has a variety of different listeners:</p>\n\n<ul>\n<li><code>click</code></li>\n<li><code>toggle</code></li>\n<li><code>mouseover</code></li>\n<li><code>mouseout</code></li>\n<li><code>mouseshow</code></li>\n<li><code>menuhide</code></li>\n<li><code>menutriggerover</code></li>\n<li><code>menutriggerout</code></li>\n</ul>\n\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text     : 'Button',\n    renderTo : Ext.getBody(),\n    listeners: {\n        click: function() {\n            // this == the button, as we are in the local scope\n            this.setText('I was clicked!');\n        },\n        mouseover: function() {\n            // set a new config which says we moused over, if not already set\n            if (!this.mousedOver) {\n                this.mousedOver = true;\n                alert('You moused over a button!\\n\\nI wont do this again.');\n            }\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"allowDepress":{"!type":"bool","!doc":"<p>False to not allow a pressed Button to be depressed. Only valid when <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> is true.</p>\n"},"arrowAlign":{"!type":"string","!doc":"<p>The side of the Button box to render the arrow if the button has an associated <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>. Two\nvalues are allowed:</p>\n\n<ul>\n<li>'right'</li>\n<li>'bottom'</li>\n</ul>\n\n"},"arrowCls":{"!type":"string","!doc":"<p>The className used for the inner arrow element if the button has a menu.</p>\n"},"arrowVisible":{"!type":"bool","!doc":"<p><code>false</code> to hide the button arrow.  Only applicable for <a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Split Buttons</a> and buttons configured with a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>.</p>\n"},"autoEl":{"!doc":"<p>A tag name or DomHelper spec used to create the <a href=\"#!/api/Ext.button.Button-method-getEl\" rel=\"Ext.button.Button-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.button.Button-cfg-renderTpl\" rel=\"Ext.button.Button-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to add to all buttons.</p>\n"},"baseParams":{"!doc":"<p>An object literal of parameters to pass to the url when the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a> property is specified.</p>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"clickEvent":{"!type":"string","!doc":"<p>The DOM event that will fire the handler of the button. This can be any valid event name (dblclick, contextmenu).</p>\n"},"cls":{"!type":"string","!doc":"<p>A CSS class string to apply to the button's main element.</p>\n"},"destroyMenu":{"!type":"bool","!doc":"<p>Whether or not to destroy any associated menu when this button is destroyed.\nIn addition, a value of <code>true</code> for this config will destroy the currently bound menu when a new\nmenu is set in <a href=\"#!/api/Ext.button.Button-method-setMenu\" rel=\"Ext.button.Button-method-setMenu\" class=\"docClass\">setMenu</a> unless overridden by that method's destroyMenu function argument.</p>\n"},"disabled":{"!type":"bool","!doc":"<p>True if this button is disabled.</p>\n"},"enableToggle":{"!type":"bool","!doc":"<p>True to enable pressed/not pressed toggling. If a <a href=\"#!/api/Ext.button.Button-cfg-toggleGroup\" rel=\"Ext.button.Button-cfg-toggleGroup\" class=\"docClass\">toggleGroup</a> is specified, this\noption will be set to true.</p>\n"},"frame":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to have the Component inject framing elements within the Component at render time to provide a\ngraphical rounded frame around the Component content.</p>\n\n<p>This is only necessary when running on outdated, or non standard-compliant browsers such as Microsoft's Internet\nExplorer prior to version 9 which do not support rounded corners natively.</p>\n\n<p>The extra space taken up by this framing is available from the read only property <a href=\"#!/api/Ext.button.Button-property-frameSize\" rel=\"Ext.button.Button-property-frameSize\" class=\"docClass\">frameSize</a>.</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon for this button. The default\nfont-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"handleMouseEvents":{"!type":"bool","!doc":"<p>False to disable visual cues on mouseover, mouseout and mousedown.</p>\n"},"handler":{"!doc":"<p>A function called when the button is clicked (can be used instead of click event).</p>\n"},"hidden":{"!type":"bool","!doc":"<p>True if this button is hidden.</p>\n"},"href":{"!type":"string","!doc":"<p>The URL to open when the button is clicked. Specifying this config causes the Button to be\nrendered with the specified URL as the <code>href</code> attribute of its <code>&lt;a&gt;</code> Element.</p>\n\n<p>This is better than specifying a click handler of</p>\n\n<pre><code>function() { window.location = \"http://www.sencha.com\" }\n</code></pre>\n\n<p>because the UI will provide meaningful hints to the user as to what to expect upon clicking\nthe button, and will also allow the user to open in a new tab or window, bookmark or drag the URL, or directly save\nthe URL stream to disk.</p>\n\n<p>See also the <a href=\"#!/api/Ext.button.Button-cfg-hrefTarget\" rel=\"Ext.button.Button-cfg-hrefTarget\" class=\"docClass\">hrefTarget</a> config.</p>\n"},"hrefTarget":{"!type":"string","!doc":"<p>The target attribute to use for the underlying anchor. Only used if the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a>\nproperty is specified.</p>\n"},"icon":{"!type":"string","!doc":"<p>The path to an image to display in the button.</p>\n\n<p>There are no default icons that come with Ext JS.</p>\n"},"iconAlign":{"!type":"string","!doc":"<p>The side of the Button box to render the icon. Four values are allowed:</p>\n\n<ul>\n<li>'top'</li>\n<li>'right'</li>\n<li>'bottom'</li>\n<li>'left'</li>\n</ul>\n\n"},"iconCls":{"!type":"string","!doc":"<p>A css class which sets a background image to be used as the icon for this button.</p>\n\n<p>There are no default icon classes that come with Ext JS.</p>\n"},"menu":{"!doc":"<p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object associated with this Button when configured with the <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> config\noption.</p>\n"},"menuAlign":{"!type":"string","!doc":"<p>The position to align the menu to (see Ext.util.Positionable.alignTo for more details).</p>\n"},"minWidth":{"!type":"number","!doc":"<p>The minimum width for this button (used to give a set of buttons a common width).\nSee also <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>.<a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>.</p>\n"},"overCls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n"},"overflowText":{"!type":"string","!doc":"<p>If used in a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>, the text to be used if this item is shown in the overflow menu.\nSee also <a href=\"#!/api/Ext.toolbar.Item\" rel=\"Ext.toolbar.Item\" class=\"docClass\">Ext.toolbar.Item</a>.<code><a href=\"#!/api/Ext.toolbar.Item-cfg-overflowText\" rel=\"Ext.toolbar.Item-cfg-overflowText\" class=\"docClass\">overflowText</a></code>.</p>\n"},"params":{"!doc":"<p>An object literal of parameters to pass to the url when the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a> property is specified. Any params\noverride <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a>. New params can be set using the <a href=\"#!/api/Ext.button.Button-method-setParams\" rel=\"Ext.button.Button-method-setParams\" class=\"docClass\">setParams</a> method.</p>\n"},"pressed":{"!type":"bool","!doc":"<p>True if this button is pressed (only if enableToggle = true).</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>True to prevent the default action when the <a href=\"#!/api/Ext.button.Button-cfg-clickEvent\" rel=\"Ext.button.Button-cfg-clickEvent\" class=\"docClass\">clickEvent</a> is processed.</p>\n"},"renderTpl":{"!doc":"<p>We have to keep \"unselectable\" attribute on all elements because it's not inheritable.\nWithout it, clicking anywhere on a button disrupts current selection and cursor position\nin HtmlEditor.</p>\n"},"repeat":{"!doc":"<p>True to repeat fire the click event while the mouse is down. This can also be a\n<a href=\"#!/api/Ext.util.ClickRepeater\" rel=\"Ext.util.ClickRepeater\" class=\"docClass\">ClickRepeater</a> config object.</p>\n"},"scale":{"!doc":"<p>The size of the Button. Three values are allowed:</p>\n\n<ul>\n<li>'small' - Results in the button element being 16px high.</li>\n<li>'medium' - Results in the button element being 24px high.</li>\n<li>'large' - Results in the button element being 32px high.</li>\n</ul>\n\n"},"scope":{"!doc":"<p>The scope (<strong>this</strong> reference) in which the <code><a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a></code> and <code><a href=\"#!/api/Ext.button.Button-cfg-toggleHandler\" rel=\"Ext.button.Button-cfg-toggleHandler\" class=\"docClass\">toggleHandler</a></code> is executed.\nDefaults to this Button.</p>\n"},"showEmptyMenu":{"!type":"bool","!doc":"<p>True to force an attached <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> with no items to be shown when clicking\nthis button. By default, the menu will not show if it is empty.</p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0 (or <code>false</code>): Neither width nor height depend on content.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2 (default): Height depends on content (shrink wraps), but width does not.</li>\n<li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"tabIndex":{"!type":"number","!doc":"<p>Set a DOM tabIndex for this button.</p>\n"},"text":{"!type":"string","!doc":"<p>The button text to be used as innerHTML (html tags are accepted).</p>\n"},"textAlign":{"!type":"string","!doc":"<p>The text alignment for this button (center, left, right).</p>\n"},"toggleGroup":{"!type":"string","!doc":"<p>The group this toggle button is a member of (only 1 per group can be pressed). If a toggleGroup\nis specified, the <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> configuration will automatically be set to true.</p>\n"},"toggleHandler":{"!doc":"<p>Function called when a Button with <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> set to true is clicked.</p>\n"},"tooltip":{"!doc":"<p>The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted) or\nQuickTips config object.</p>\n"},"tooltipType":{"!type":"string","!doc":"<p>The type of tooltip to use. Either 'qtip' for QuickTips or 'title' for title attribute.</p>\n"},"value":{"!doc":"<p>The value of this button.  Only applicable when used as an item of a <a href=\"#!/api/Ext.button.Segmented\" rel=\"Ext.button.Segmented\" class=\"docClass\">Segmented Button</a>.</p>\n"},"_baseIconCls":{"!type":"string"},"_btnCls":{"!type":"string"},"_btnWrapCls":{"!type":"string"},"_disabledCls":{"!type":"string"},"_glyphCls":{"!type":"string"},"_hasIconCls":{"!type":"string"},"_innerCls":{"!type":"string"},"_menuActiveCls":{"!type":"string"},"_noTextCls":{"!type":"string"},"_operaArrowCls":{"!type":"string","!doc":"<p><feature legacyBrowser>\n extra class to work around broken display:table impl in opera12</feature></p>\n"},"_pressedCls":{"!type":"string"},"_syncFrameHeight":{"!type":"bool","!doc":"<p><code>true</code> to keep height of the frame's \"MC\" element in sync.  This is needed in IE8\nso that the button's inner element(s) can use height:100% to fill the button when\nit not in shrinkWrap mode</p>\n"},"_textCls":{"!type":"string"},"_triggerRegion":{"!doc":"<p>A reusable object used by getTriggerRegion to avoid excessive object creation.</p>\n"},"allowedScales":{"!doc":"<p>An array of allowed scales.</p>\n"},"defaultBindProperty":{"!type":"string"},"focusCls":{"!type":"string"},"iconTpl":{"!type":"string"},"isButton":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Button, or subclass thereof.</p>\n"},"liquidLayout":{"!type":"bool","!doc":"<p>private, readonly</p>\n"},"menuClickBuffer":{"!type":"number","!doc":"<p>private</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Positionable methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"publishes":{},"template":{"!doc":"<p>A Template used to create the Button's DOM structure.</p>\n\n<p>Instances, or subclasses which need a different DOM structure may provide a different template layout in\nconjunction with an implementation of <a href=\"#!/api/Ext.button.Button-method-getTemplateArgs\" rel=\"Ext.button.Button-method-getTemplateArgs\" class=\"docClass\">getTemplateArgs</a>.</p>\n"},"_hasIcon":{"!type":"fn() -> bool","!doc":"<p>Returns true if this button has an icon (either icon, iconCls, or glyph)</p>\n"},"applyText":{"!type":"fn(text: ?) -> !this"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"clearTip":{"!type":"fn() -> !this"},"didIconStateChange":{"!type":"fn(old: ?, current: ?) -> bool","!doc":"<p>Checks if the icon/iconCls changed from being empty to having a value, or having a value to being empty.</p>\n"},"disable":{"!type":"fn(silent: ?) -> !this","!doc":"<p>Disable the component.</p>\n"},"doNavigate":{"!type":"fn() -> !this"},"doPreventDefault":{"!type":"fn(e: ?) -> !this"},"doToggle":{"!type":"fn() -> !this"},"enable":{"!type":"fn(silent: ?) -> !this","!doc":"<p>Enable the component</p>\n"},"fireHandler":{"!type":"fn(e: ?) -> !this"},"frameTableListener":{"!type":"fn() -> !this"},"getArrowVisible":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Button-cfg-arrowVisible\" rel=\"Ext.button.Button-cfg-arrowVisible\" class=\"docClass\">arrowVisible</a>.</p>\n"},"getElConfig":{"!type":"fn() -> !this"},"getHref":{"!type":"fn() -> ?","!doc":"<p>If there is a configured href for this Button, returns the href with parameters appended.</p>\n"},"getIconAlign":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Button-cfg-iconAlign\" rel=\"Ext.button.Button-cfg-iconAlign\" class=\"docClass\">iconAlign</a>.</p>\n"},"getMenu":{"!type":"fn() -> ?","!doc":"<p>Get the <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> for this button.</p>\n"},"getRefItems":{"!type":"fn(deep: ?) -> !this"},"getSplitCls":{"!type":"fn() -> !this"},"getTdCls":{"!type":"fn() -> !this","!doc":"<p>Needed for when widget is rendered into a grid cell. The class to add to the cell element.\nOverride needed to add scale to the mix which is poart of the ui name in the mixin and the CSS rule</p>\n"},"getTemplateArgs":{"!type":"fn() -> ?","!doc":"<p>This method returns an object which provides substitution parameters for the <a href=\"#!/api/Ext.button.Button-cfg-renderTpl\" rel=\"Ext.button.Button-cfg-renderTpl\" class=\"docClass\">XTemplate</a> used to\ncreate this Button's DOM structure.</p>\n\n<p>Instances or subclasses which use a different Template to create a different DOM structure may need to provide\ntheir own implementation of this method.</p>\n"},"getText":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Button-cfg-text\" rel=\"Ext.button.Button-cfg-text\" class=\"docClass\">text</a>.</p>\n"},"getTextAlign":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Button-cfg-textAlign\" rel=\"Ext.button.Button-cfg-textAlign\" class=\"docClass\">textAlign</a>.</p>\n"},"getTipAttr":{"!type":"fn() -> !this"},"getTriggerRegion":{"!type":"fn() -> ?","!doc":"<p>Returns an object containing <code>begin</code> and <code>end</code> properties that indicate the\nleft/right bounds of a right trigger or the top/bottom bounds of a bottom trigger.</p>\n"},"hasFrameTable":{"!type":"fn() -> !this"},"hasVisibleMenu":{"!type":"fn() -> bool","!doc":"<p>Returns true if the button has a menu and it is visible</p>\n"},"hideMenu":{"!type":"fn() -> ?","!doc":"<p>Hides this button's menu (if it has one)</p>\n"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"isWithinTrigger":{"!type":"fn(e: ?) -> !this","!doc":"<p>Returns true if the passed event's x/y coordinates are within the trigger region</p>\n"},"maybeShowMenu":{"!type":"fn() -> !this"},"onClick":{"!type":"fn(e: ?) -> !this"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onDownKey":{"!type":"fn(k: ?, e: ?) -> !this"},"onMenuHide":{"!type":"fn(e: ?) -> !this"},"onMenuShow":{"!type":"fn() -> !this"},"onMenuTriggerOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseleave handler called when it is detected that the mouseout event\nsignified the mouse leaving the arrow area of the button - the <code>&lt;em&gt;</code>.</p>\n"},"onMenuTriggerOver":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseenter handler called when it is detected that the mouseover event\nsignified the mouse entering the arrow area of the button - the <code>&lt;em&gt;</code>.</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus\nunless the mousedown was on a focusable element*</p>\n"},"onMouseEnter":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseenter handler called when it is detected that the mouseout event\nsignified the mouse entering the encapsulating element.</p>\n"},"onMouseLeave":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseleave handler called when it is detected that the mouseover event\nsignified the mouse entering the encapsulating element.</p>\n"},"onMouseMove":{"!type":"fn(e: ?) -> !this","!doc":"<p>mousemove handler called when the mouse moves anywhere within the encapsulating element.\nThe position is checked to determine if the mouse is entering or leaving the trigger area. Using\nmousemove to check this is more resource intensive than we'd like, but it is necessary because\nthe trigger area does not line up exactly with sub-elements so we don't always get mouseover/out\nevents when needed. In the future we should consider making the trigger a separate element that\nis absolutely positioned and sized over the trigger area.</p>\n"},"onMouseOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>mouseout handler called when a mouseout event occurs anywhere within the encapsulating element -\nor the mouse leaves the encapsulating element.\nThe targets are interrogated to see what is being exited to where.</p>\n"},"onMouseOver":{"!type":"fn(e: ?) -> !this","!doc":"<p>mouseover handler called when a mouseover event occurs anywhere within the encapsulating element.\nThe targets are interrogated to see what is being entered from where.</p>\n"},"onMouseUp":{"!type":"fn(e: ?) -> !this"},"onRender":{"!type":"fn() -> !this","!doc":"<p>Template method called when this Component's DOM structure is created.</p>\n\n<p>At this point, this Component's (and all descendants') DOM structure <em>exists</em> but it has not\nbeen layed out (positioned and sized).</p>\n\n<p>Subclasses which override this to gain access to the structure at render time should\ncall the parent class's method before attempting to access any child elements of the Component.</p>\n"},"onRepeatClick":{"!type":"fn(repeat: ?, e: ?) -> !this"},"onTouchStart":{"!type":"fn(e: ?) -> !this"},"renderIcon":{"!type":"fn(values: ?) -> !this"},"restoreClick":{"!type":"fn() -> !this"},"setArrowVisible":{"!type":"fn(arrowVisible: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Button-cfg-arrowVisible\" rel=\"Ext.button.Button-cfg-arrowVisible\" class=\"docClass\">arrowVisible</a>.</p>\n"},"setGlyph":{"!type":"fn(glyph: ?) -> ?","!doc":"<p>Sets this button's glyph</p>\n"},"setHandler":{"!type":"fn(handler: ?, scope?: ?) -> ?","!doc":"<p>Assigns this Button's click handler</p>\n"},"setHref":{"!type":"fn(href: ?) -> !this","!doc":"<p>Sets the href of the embedded anchor element to the passed URL.</p>\n\n<p>Also appends any configured <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a> and parameters set through <a href=\"#!/api/Ext.button.Button-method-setParams\" rel=\"Ext.button.Button-method-setParams\" class=\"docClass\">setParams</a>.</p>\n"},"setIcon":{"!type":"fn(icon: ?) -> ?","!doc":"<p>Sets the background image (inline style) of the button. This method also changes the value of the <a href=\"#!/api/Ext.button.Button-cfg-icon\" rel=\"Ext.button.Button-cfg-icon\" class=\"docClass\">icon</a>\nconfig internally.</p>\n"},"setIconAlign":{"!type":"fn(iconAlign: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Button-cfg-iconAlign\" rel=\"Ext.button.Button-cfg-iconAlign\" class=\"docClass\">iconAlign</a>.</p>\n"},"setIconCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Sets the CSS class that provides a background image to use as the button's icon. This method also changes the\nvalue of the <a href=\"#!/api/Ext.button.Button-cfg-iconCls\" rel=\"Ext.button.Button-cfg-iconCls\" class=\"docClass\">iconCls</a> config internally.</p>\n"},"setMenu":{"!type":"fn(menu: ?, destroyMenu: ?) -> !this","!doc":"<p>Sets a new menu for this button. Pass a falsy value to unset the current menu.\nTo destroy the previous menu for this button, explicitly pass <code>false</code> as the second argument. If this is not set, the destroy will depend on the\nvalue of <a href=\"#!/api/Ext.button.Button-cfg-destroyMenu\" rel=\"Ext.button.Button-cfg-destroyMenu\" class=\"docClass\">destroyMenu</a>.</p>\n"},"setParams":{"!type":"fn(params: ?) -> !this","!doc":"<p>Sets the href of the link dynamically according to the params passed, and any <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a> configured.</p>\n\n<pre><code>var button = Ext.create('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>', {\n    renderTo   : document.body,\n    text       : 'Open',\n    href       : 'http://www.sencha.com',\n    baseParams : {\n        foo : 'bar'\n    }\n});\n\nbutton.setParams({\n    company : 'Sencha'\n});\n</code></pre>\n\n<p>When clicked, this button will open a new window with the url http://www.sencha.com/?foo=bar&amp;company=Sencha because\nthe button wased configured with the <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a> to have <code>foo</code> = <code>'bar'</code> and then used <a href=\"#!/api/Ext.button.Button-method-setParams\" rel=\"Ext.button.Button-method-setParams\" class=\"docClass\">setParams</a> to set the <code>company</code> parameter to <code>'Sencha'</code>.</p>\n\n<p><strong>Only valid if the Button was originally configured with a <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a></strong></p>\n"},"setPressed":{"!type":"fn(pressed?: ?) -> ?","!doc":"<p>Sets the <code>pressed</code> state of this button.</p>\n"},"setScale":{"!type":"fn(scale: ?) -> !this","!doc":"<p>Method to change the scale of the button. See <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">scale</a> for allowed configurations.</p>\n"},"setText":{"!type":"fn(text: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Button-cfg-text\" rel=\"Ext.button.Button-cfg-text\" class=\"docClass\">text</a>.</p>\n"},"setTextAlign":{"!type":"fn(textAlign: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Button-cfg-textAlign\" rel=\"Ext.button.Button-cfg-textAlign\" class=\"docClass\">textAlign</a>.</p>\n"},"setTooltip":{"!type":"fn(tooltip: ?) -> ?","!doc":"<p>Sets the tooltip for this Button.</p>\n"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\n<code>uiCls</code> set on the component and rename them so they include the new UI.</p>\n"},"showMenu":{"!type":"fn(fromEvent: ?) -> !this","!doc":"<p>Shows this button's menu (if it has one)</p>\n"},"toggle":{"!type":"fn(this: ?, pressed: ?, eOpts: ?)","!doc":"<p>Fires when the 'pressed' state of this button changes (only if enableToggle = true)</p>\n"},"updateArrowVisible":{"!type":"fn(visible: ?) -> !this"},"updateIconAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"},"updateTextAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"},"click":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when this button is clicked, before the configured <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> is invoked. Execution of the\n<a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> may be vetoed by returning <code>false</code> to this event.</p>\n"},"glyphchange":{"!type":"fn(this: ?, newGlyph: ?, oldGlyph: ?, eOpts: ?)","!doc":"<p>Fired when the button's glyph is changed by the <a href=\"#!/api/Ext.button.Button-method-setGlyph\" rel=\"Ext.button.Button-method-setGlyph\" class=\"docClass\">setGlyph</a> method.</p>\n"},"iconchange":{"!type":"fn(this: ?, oldIcon: ?, newIcon: ?, eOpts: ?)","!doc":"<p>Fired when the button's icon is changed by the <a href=\"#!/api/Ext.button.Button-method-setIcon\" rel=\"Ext.button.Button-method-setIcon\" class=\"docClass\">setIcon</a> or <a href=\"#!/api/Ext.button.Button-method-setIconCls\" rel=\"Ext.button.Button-method-setIconCls\" class=\"docClass\">setIconCls</a> methods.</p>\n"},"menuhide":{"!type":"fn(this: ?, menu: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when it is hidden</p>\n"},"menushow":{"!type":"fn(this: ?, menu: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when it is shown</p>\n"},"menutriggerout":{"!type":"fn(this: ?, menu: ?, e: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when the mouse leaves the menu triggering element</p>\n"},"menutriggerover":{"!type":"fn(this: ?, menu: ?, e: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when the mouse enters the menu triggering element</p>\n"},"mouseout":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse exits the button</p>\n"},"mouseover":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse hovers over the button</p>\n"},"textchange":{"!type":"fn(this: ?, oldText: ?, newText: ?, eOpts: ?)","!doc":"<p>Fired when the button's text is changed by the <a href=\"#!/api/Ext.button.Button-method-setText\" rel=\"Ext.button.Button-method-setText\" class=\"docClass\">setText</a> method.</p>\n"}}},"Cycle":{"!doc":"<p>A specialized SplitButton that contains a menu of <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a> elements. The button automatically\ncycles through each menu item on click, raising the button's <a href=\"#!/api/Ext.button.Cycle-event-change\" rel=\"Ext.button.Cycle-event-change\" class=\"docClass\">change</a> event (or calling the button's\n<a href=\"#!/api/Ext.button.Cycle-cfg-changeHandler\" rel=\"Ext.button.Cycle-cfg-changeHandler\" class=\"docClass\">changeHandler</a> function, if supplied) for the active menu item. Clicking on the arrow section of the\nbutton displays the dropdown menu just like a normal SplitButton.  Example usage:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.button.Cycle\" rel=\"Ext.button.Cycle\" class=\"docClass\">Ext.button.Cycle</a>', {\n    showText: true,\n    prependText: 'View as ',\n    renderTo: Ext.getBody(),\n    menu: {\n        id: 'view-type-menu',\n        items: [{\n            text: 'text only',\n            iconCls: 'view-text',\n            checked: true\n        },{\n            text: 'HTML',\n            iconCls: 'view-html'\n        }]\n    },\n    changeHandler: function(cycleBtn, activeItem) {\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Change View', activeItem.text);\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"changeHandler":{"!doc":"<p>A callback function that will be invoked each time the active menu item in the button's menu has changed. If this\ncallback is not supplied, the SplitButton will instead fire the <a href=\"#!/api/Ext.button.Cycle-event-change\" rel=\"Ext.button.Cycle-event-change\" class=\"docClass\">change</a> event on active item change. The\nchangeHandler function will be called with the following argument list: (SplitButton this, <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a>\nitem)</p>\n"},"forceGlyph":{"!doc":"<p>The charCode to be used as the static icon for this button.  This icon will always be\ndisplayed regardless of which item is selected in the dropdown list. This override\nthe default behavior of changing the button's icon to match the selected item's icon\non change. This property expects a format consistent with that of <a href=\"#!/api/Ext.button.Cycle-cfg-glyph\" rel=\"Ext.button.Cycle-cfg-glyph\" class=\"docClass\">glyph</a></p>\n"},"forceIcon":{"!type":"string","!doc":"<p>A css class which sets an image to be used as the static icon for this button. This icon will always be displayed\nregardless of which item is selected in the dropdown list. This overrides the default behavior of changing the\nbutton's icon to match the selected item's icon on change.</p>\n"},"items":{"!doc":"<p>An array of <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a> <strong>config</strong> objects to be used when creating the button's menu items (e.g.,\n<code>{text:'Foo', iconCls:'foo-icon'}</code>)</p>\n"},"prependText":{"!type":"string","!doc":"<p>A static string to prepend before the active item's text when displayed as the button's text (only applies when\nshowText = true).</p>\n"},"showText":{"!type":"bool","!doc":"<p>True to display the active item's text as the button text. The Button will show its\nconfigured <a href=\"#!/api/Ext.button.Cycle-cfg-text\" rel=\"Ext.button.Cycle-cfg-text\" class=\"docClass\">text</a> if this config is omitted.</p>\n"},"menu":{"!doc":"<p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object used to display the <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">CheckItems</a> representing the\navailable choices.</p>\n"},"checkHandler":{"!type":"fn(item: ?, pressed: ?) -> !this"},"getActiveItem":{"!type":"fn() -> ?","!doc":"<p>Gets the currently active menu item.</p>\n"},"getButtonText":{"!type":"fn(item: ?) -> !this"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"setActiveItem":{"!type":"fn(item: ?, suppressEvent?: ?) -> !this","!doc":"<p>Sets the button's active menu item.</p>\n"},"toggleSelected":{"!type":"fn() -> !this","!doc":"<p>This is normally called internally on button click, but can be called externally to advance the button's active\nitem programmatically to the next one in the menu. If the current item is the last one in the menu the active\nitem will be set to the first item in the menu.</p>\n"},"change":{"!type":"fn(this: ?, item: ?, eOpts: ?)","!doc":"<p>Fires after the button's active menu item has changed. Note that if a <a href=\"#!/api/Ext.button.Cycle-cfg-changeHandler\" rel=\"Ext.button.Cycle-cfg-changeHandler\" class=\"docClass\">changeHandler</a> function is\nset on this CycleButton, it will be called instead on active item change and this change event will not\nbe fired.</p>\n"}}},"Split":{"prototype":{"arrowCls":{"!type":"string","!doc":"<p>The className used for the inner arrow element if the button has a menu.</p>\n"},"arrowHandler":{"!doc":"<p>A function called when the arrow button is clicked (can be used instead of click event)</p>\n"},"arrowTooltip":{"!type":"string","!doc":"<p>The title attribute of the arrow.</p>\n"},"isSplitButton":{"!type":"bool","!doc":"<p>End Definitions</p>\n"},"split":{"!type":"bool"},"onClick":{"!type":"fn(e: ?) -> !this"},"setArrowHandler":{"!type":"fn(handler: ?, scope?: ?) -> !this","!doc":"<p>Sets this button's arrow click handler.</p>\n"},"arrowclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when this button's arrow is clicked.</p>\n"}},"!doc":"<p>A split button that provides a built-in dropdown arrow that can fire an event separately from the default click event\nof the button. Typically this would be used to display a dropdown menu that provides additional options to the\nprimary button action, but any custom handler can provide the arrowclick implementation.  Example usage:</p>\n\n<pre class='inline-example '><code>// display a dropdown menu:\nExt.create('<a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>', {\n    renderTo: Ext.getBody(),\n    text: 'Options',\n    // handle a click on the button itself\n    handler: function() {\n        alert(\"The button was clicked\");\n    },\n    menu: new <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>({\n        items: [\n            // these will render as dropdown menu items when the arrow is clicked:\n            {text: 'Item 1', handler: function(){ alert(\"Item 1 clicked\"); }},\n            {text: 'Item 2', handler: function(){ alert(\"Item 2 clicked\"); }}\n        ]\n    })\n});\n</code></pre>\n\n<p>Instead of showing a menu, you can provide any type of custom functionality you want when the dropdown\narrow is clicked:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>', {\n    renderTo: 'button-ct',\n    text: 'Options',\n    handler: optionsHandler,\n    arrowHandler: myCustomHandler\n});\n</code></pre>\n","!type":"fn(config: ?)"},"Manager":{"buttonSelector":{"!type":"string"},"groups":{},"pressedButton":{},"getPressed":{"!type":"fn(groupName: ?) -> ?","!doc":"<p>Gets the pressed button in the passed group or null</p>\n"},"init":{"!type":"fn() -> !this"},"onButtonMousedown":{"!type":"fn(button: ?, e: ?) -> !this","!doc":"<p>Called by buton instances.\nTrack the button which was mousedowned upon so that the next <em>document</em> mouseup can be delivered to it\nin case mouse is moved outside of button element.</p>\n"},"onDocumentKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Buttons must react to SPACE and ENTER to trigger the click handler.\nNow that they are <code>&lt;a&gt;</code> elements, we use a keydown listener.</p>\n"},"onDocumentMouseUp":{"!type":"fn(e: ?) -> !this"},"register":{"!type":"fn(btn: ?) -> !this"},"toggleGroup":{"!type":"fn(btn: ?, state: ?) -> !this"},"unregister":{"!type":"fn(btn: ?) -> !this"}},"Segmented":{"!doc":"<p>SegmentedButton is a container for a group of <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Button</a>s.</p>\n","!type":"fn(config: ?)","prototype":{"allowDepress":{"!type":"bool","!doc":"<p>Allow toggling the pressed state of each button.\nOnly applicable when <a href=\"#!/api/Ext.button.Segmented-cfg-allowMultiple\" rel=\"Ext.button.Segmented-cfg-allowMultiple\" class=\"docClass\">allowMultiple</a> is <code>false</code>.</p>\n"},"allowMultiple":{"!type":"bool","!doc":"<p>Allow multiple pressed buttons.</p>\n"},"allowToggle":{"!type":"bool","!doc":"<p>True to enable pressed/not pressed toggling.</p>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"defaultUI":{"!type":"string","!doc":"<p>Default <a href=\"#!/api/Ext.Component-cfg-ui\" rel=\"Ext.Component-cfg-ui\" class=\"docClass\">ui</a> to use for buttons in this segmented button.\nButtons can override this default by specifying their own UI</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.button.Segmented-cfg-items\" rel=\"Ext.button.Segmented-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"value":{"!doc":"<p>The value of this button.  When <a href=\"#!/api/Ext.button.Segmented-cfg-allowMultiple\" rel=\"Ext.button.Segmented-cfg-allowMultiple\" class=\"docClass\">allowMultiple</a> is <code>false</code>, value is a\nString or Number.  When <a href=\"#!/api/Ext.button.Segmented-cfg-allowMultiple\" rel=\"Ext.button.Segmented-cfg-allowMultiple\" class=\"docClass\">is &lt;code&gt;true&lt;/code&gt;, value is an array\nof values.  A value corresponds to a child button's {@link Ext.button.Button#value\nvalue</a>, or its index if no child button values match the given value.</p>\n\n<p>Using the <code>value</code> config of the child buttons with single toggle:</p>\n\n<pre class='inline-example '><code>var button = Ext.create('<a href=\"#!/api/Ext.button.Segmented\" rel=\"Ext.button.Segmented\" class=\"docClass\">Ext.button.Segmented</a>', {\n    renderTo: Ext.getBody(),\n    value: 'optTwo', // begin with \"Option Two\" selected\n    items: [{\n        text: 'Option One',\n        value: 'optOne'\n    }, {\n        text: 'Option Two',\n        value: 'optTwo'\n    }, {\n        text: 'Option Three',\n        value:  'optThree'\n    }]\n});\n\nconsole.log(button.getValue()); // optTwo\n\n// Sets the value to optOne, and sets the pressed state of the \"Option One\" button\nbutton.setValue('optOne');\n\nconsole.log(button.getValue()); // optOne\n</code></pre>\n\n<p>Using multiple toggle, and index-based values:</p>\n\n<pre class='inline-example '><code>var button = Ext.create('<a href=\"#!/api/Ext.button.Segmented\" rel=\"Ext.button.Segmented\" class=\"docClass\">Ext.button.Segmented</a>', {\n    renderTo: Ext.getBody(),\n    allowMultiple: true\n    value: [1, 2], // begin with \"Option Two\" and \"Option Three\" selected\n    items: [{\n        text: 'Option One'\n    }, {\n        text: 'Option Two'\n    }, {\n        text: 'Option Three'\n    }]\n});\n\n// Sets value to [0, 2], and sets pressed state of \"Option One\" and \"Option Three\"\nbutton.setValue([0, 2]);\n\nconsole.log(button.getValue()); // [0, 2]\n\n// Remove all pressed buttons, and set value to null\nbutton.setValue(null);\n</code></pre>\n"},"vertical":{"!type":"bool","!doc":"<p>True to align the buttons vertically</p>\n"},"_firstCls":{"!type":"string","!doc":"<p>private</p>\n"},"_lastCls":{"!type":"string","!doc":"<p>private</p>\n"},"_middleCls":{"!type":"string","!doc":"<p>private</p>\n"},"beforeRenderConfig":{},"isSegmentedButton":{"!type":"bool"},"itemCls":{"!type":"string"},"maskOnDisable":{"!type":"bool","!doc":"<p>This is an internal flag that you use when creating custom components. By default this is set to <code>true</code> which means\nthat every component gets a mask when it's disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to <code>false</code> since they want to implement custom disable logic.</p>\n"},"privates":{"!doc":"<p></p>\n"},"publishes":{},"twoWayBindable":{},"_lookupButtonByValue":{"!type":"fn(value: ?) -> ?","!doc":"<p>Looks up a child button by its value</p>\n"},"_onItemToggle":{"!type":"fn(button: ?, pressed: ?) -> !this","!doc":"<p>Handles the \"toggle\" event of the child buttons.</p>\n"},"_syncItemClasses":{"!type":"fn(force: ?) -> !this","!doc":"<p>Synchronizes the \"first\", \"last\", and \"middle\" css classes when buttons are\nadded, removed, shown, or hidden</p>\n"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"getAllowDepress":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowDepress\" rel=\"Ext.button.Segmented-cfg-allowDepress\" class=\"docClass\">allowDepress</a>.</p>\n"},"getAllowMultiple":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowMultiple\" rel=\"Ext.button.Segmented-cfg-allowMultiple\" class=\"docClass\">allowMultiple</a>.</p>\n"},"getAllowToggle":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowToggle\" rel=\"Ext.button.Segmented-cfg-allowToggle\" class=\"docClass\">allowToggle</a>.</p>\n"},"getDefaultUI":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Segmented-cfg-defaultUI\" rel=\"Ext.button.Segmented-cfg-defaultUI\" class=\"docClass\">defaultUI</a>.</p>\n"},"getVertical":{"!type":"fn() -> bool","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.button.Segmented-cfg-vertical\" rel=\"Ext.button.Segmented-cfg-vertical\" class=\"docClass\">vertical</a>.</p>\n"},"onAdd":{"!type":"fn(item: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been added. It\nis passed the Component which has been added. This method may\nbe used to update any internal structure which may depend upon\nthe state of the child items.</p>\n"},"onRemove":{"!type":"fn(item: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been\nremoved. It is passed the Component which has been\nremoved. This method may be used to update any internal\nstructure which may depend upon the state of the child items.</p>\n"},"setAllowDepress":{"!type":"fn(allowDepress: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowDepress\" rel=\"Ext.button.Segmented-cfg-allowDepress\" class=\"docClass\">allowDepress</a>.</p>\n"},"setAllowMultiple":{"!type":"fn(allowMultiple: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowMultiple\" rel=\"Ext.button.Segmented-cfg-allowMultiple\" class=\"docClass\">allowMultiple</a>.</p>\n"},"setAllowToggle":{"!type":"fn(allowToggle: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Segmented-cfg-allowToggle\" rel=\"Ext.button.Segmented-cfg-allowToggle\" class=\"docClass\">allowToggle</a>.</p>\n"},"setDefaultUI":{"!type":"fn(defaultUI: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Segmented-cfg-defaultUI\" rel=\"Ext.button.Segmented-cfg-defaultUI\" class=\"docClass\">defaultUI</a>.</p>\n"},"setVertical":{"!type":"fn(vertical: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.button.Segmented-cfg-vertical\" rel=\"Ext.button.Segmented-cfg-vertical\" class=\"docClass\">vertical</a>.</p>\n"},"updateAllowDepress":{"!type":"fn(newAllowDepress: ?, oldAllowDepress: ?) -> !this","!doc":"<p><debug></debug></p>\n"},"updateAllowMultiple":{"!type":"fn(newAllowMultiple: ?, oldAllowMultiple: ?) -> !this"},"updateAllowToggle":{"!type":"fn(newAllowToggle: ?, oldAllowToggle: ?) -> !this"},"updateDefaultUI":{"!type":"fn(defaultUI: ?) -> !this"},"updateVertical":{"!type":"fn(newVertical: ?, oldVertical: ?) -> !this"},"toggle":{"!type":"fn(this: ?, button: ?, isPressed: ?, eOpts: ?)","!doc":"<p>Fires when any child button's pressed state has changed.</p>\n"}}}},"Component":{"prototype":{"alignTarget":{"!type":"string","!doc":"<p>A Component or Element by which to position this component according to the <a href=\"#!/api/Ext.Component-cfg-defaultAlign\" rel=\"Ext.Component-cfg-defaultAlign\" class=\"docClass\">defaultAlign</a>.\nDefaults to ths owning Container.</p>\n\n<p><em>Only applicable if this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a></em></p>\n\n<p><em>Used upon first show</em>.</p>\n"},"autoRender":{"!doc":"<p>This config is intended mainly for non-<a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which may or may not be shown. Instead of using\n<a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a> in the configuration, and rendering upon construction, this allows a Component to render itself\nupon first <em><a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a></em>. If <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> is <code>true</code>, the value of this config is omitted as if it is <code>true</code>.</p>\n\n<p>Specify as <code>true</code> to have this Component render to the document body upon first show.</p>\n\n<p>Specify as an element, or the ID of an element to have this Component render to a specific element upon first\nshow.</p>\n"},"autoScroll":{"!type":"bool","!doc":"<p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\n<code>false</code> to clip any overflowing content.\nThis should not be combined with <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> or  <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a>.</p>\n"},"autoShow":{"!type":"bool","!doc":"<p><code>true</code> to automatically show the component upon creation. This config option may only be used for\n<a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> components or components that use <a href=\"#!/api/Ext.Component-cfg-autoRender\" rel=\"Ext.Component-cfg-autoRender\" class=\"docClass\">autoRender</a>.</p>\n"},"border":{"!doc":"<p>Specifies the border size for this component. The border can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n\n<p>For components that have no border by default, setting this won't make the border appear by itself.\nYou also need to specify border color and style:</p>\n\n<pre><code>border: 5,\nstyle: {\n    borderColor: 'red',\n    borderStyle: 'solid'\n}\n</code></pre>\n\n<p>To turn off the border, use <code>border: false</code>.</p>\n"},"columnWidth":{"!doc":"<p>Defines the column width inside <a href=\"#!/api/Ext.layout.container.Column\" rel=\"Ext.layout.container.Column\" class=\"docClass\">column layout</a>.</p>\n\n<p>Can be specified as a number or as a percentage.</p>\n"},"componentCls":{"!type":"string","!doc":"<p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n"},"componentLayout":{"!doc":"<p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.Component-method-setSize\" rel=\"Ext.Component-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"constrainTo":{"!doc":"<p>A Region (or an element from which a Region measurement will be read) which is used\nto constrain the component. Only applies when the component is floating.</p>\n"},"constraintInsets":{"!doc":"<p>An object or a string (in TRBL order) specifying insets from the configured <a href=\"#!/api/Ext.Component-cfg-constrainTo\" rel=\"Ext.Component-cfg-constrainTo\" class=\"docClass\">constrain region</a>\nwithin which this component must be constrained when positioning or sizing.\nexample:</p>\n\n<p>   constraintInsets: '10 10 10 10' // Constrain with 10px insets from parent</p>\n"},"contentEl":{"!type":"string","!doc":"<p>Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content for this component.</p>\n\n<p>This config option is used to take an existing HTML element and place it in the layout element of a new component\n(it simply moves the specified DOM element <em>after the Component is rendered</em> to use as the content.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>The specified HTML element is appended to the layout element of the component <em>after any configured\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">HTML</a> has been inserted</em>, and so the document will not contain this element at the time\nthe <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">render</a> event is fired.</p>\n\n<p>The specified HTML element used will not participate in any <strong><code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code></strong>\nscheme that the Component may use. It is just HTML. Layouts operate on child\n<strong><code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code></strong>.</p>\n\n<p>Add either the <code>x-hidden</code> or the <code>x-hidden-display</code> CSS class to prevent a brief flicker of the content before it\nis rendered to the panel.</p>\n"},"data":{"!doc":"<p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content\narea of the Component.</p>\n"},"defaultAlign":{"!type":"string","!doc":"<p>The default Ext.dom.Element#getAlignToXY anchor position value for this component\nrelative to its <a href=\"#!/api/Ext.Component-cfg-alignTarget\" rel=\"Ext.Component-cfg-alignTarget\" class=\"docClass\">alignTarget</a> (which defaults to its owning Container).</p>\n\n<p><em>Only applicable if this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a></em></p>\n\n<p><em>Used upon first show</em>.</p>\n"},"disabledCls":{"!type":"string","!doc":"<p>CSS class to add when the Component is disabled.</p>\n"},"draggable":{"!doc":"<p>Specify as true to make a <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Component draggable using the Component's encapsulating element as\nthe drag handle.</p>\n\n<p>This may also be specified as a config object for the <a href=\"#!/api/Ext.util.ComponentDragger\" rel=\"Ext.util.ComponentDragger\" class=\"docClass\">ComponentDragger</a> which is\ninstantiated to perform dragging.</p>\n\n<p>For example to create a Component which may only be dragged around using a certain internal element as the drag\nhandle, use the delegate option:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>({\n    constrain: true,\n    floating: true,\n    style: {\n        backgroundColor: '#fff',\n        border: '1px solid black'\n    },\n    html: '&lt;h1 style=\"cursor:move\"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',\n    draggable: {\n        delegate: 'h1'\n    }\n}).show();\n</code></pre>\n"},"floating":{"!type":"bool","!doc":"<p>Specify as true to float the Component outside of the document flow using CSS absolute positioning.</p>\n\n<p>Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a>s are floating by default.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will register\nthemselves with the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<h3>Floating Components as child items of a Container</h3>\n\n<p>A floating Component may be used as a child item of a Container. This just allows the floating Component to seek\na ZIndexManager by examining the ownerCt chain.</p>\n\n<p>When configured as floating, Components acquire, at render time, a <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which\nmanages a stack of related floating Components. The ZIndexManager brings a single floating Component to the top\nof its stack when the Component's <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> method is called.</p>\n\n<p>The ZIndexManager is found by traversing up the <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a> chain to find an ancestor which itself is\nfloating. This is so that descendant floating Components of floating <em>Containers</em> (Such as a ComboBox dropdown\nwithin a Window) can have its zIndex managed relative to any siblings, but always <strong>above</strong> that floating\nancestor Container.</p>\n\n<p>If no floating ancestor is found, a floating Component registers itself with the default <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Floating components <em>do not participate in the Container's layout</em>. Because of this, they are not rendered until\nyou explicitly <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> them.</p>\n\n<p>After rendering, the ownerCt reference is deleted, and the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property is set to the found\nfloating ancestor Container. If no floating ancestor Container was found the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property will\nnot be set.</p>\n"},"formBind":{"!type":"bool","!doc":"<p>When inside FormPanel, any component configured with <code>formBind: true</code> will\nbe enabled/disabled depending on the validity state of the form.\nSee <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a> for more information and example.</p>\n"},"height":{"!type":"number","!doc":"<p>The height of this component in pixels.</p>\n"},"hideMode":{"!type":"string","!doc":"<p>A String which specifies how this Component's encapsulating DOM element will be hidden. Values may be:</p>\n\n<ul>\n<li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>\n<li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>\n<li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the visible area of the document.\nThis is useful when a hidden Component must maintain measurable dimensions. Hiding using <code>display</code> results in a\nComponent having zero dimensions.</li>\n</ul>\n\n"},"html":{"!doc":"<p>An HTML fragment, or a DomHelper specification to use as the layout element content.\nThe HTML content is added after the component is rendered, so the document will not contain this HTML at the time\nthe <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">render</a> event is fired. This content is inserted into the body <em>before</em> any configured <a href=\"#!/api/Ext.Component-cfg-contentEl\" rel=\"Ext.Component-cfg-contentEl\" class=\"docClass\">contentEl</a>\nis appended.</p>\n"},"id":{"!type":"string","!doc":"<p>The <strong>unique</strong> id of this component instance.</p>\n\n<p>Use of this config should be considered carefully as this value must be unique across\nall existing components. Components created with an <code>id</code> may be accessed globally\nusing Ext.getCmp.</p>\n\n<p>Instead of using assigned ids, consider a reference config and a ViewController\nto respond to events and perform processing upon this Component.</p>\n\n<p>Alternatively, <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a> and ComponentQuery can be\nused to perform selector-based searching for Components analogous to DOM querying.\nThe <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class contains several helpful\nshortcut methods to query its descendant\nComponents by selector.</p>\n\n<p>Note that this <code>id</code> will also be used as the element id for the containing HTML\nelement that is rendered to the page for this component. This allows you to write\nid-based CSS rules to style the specific instance of this component uniquely, and\nalso to select sub-elements using this component's <code>id</code> as the parent.</p>\n\n<p>Defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>.</p>\n\n<p><strong>Note</strong>: Valid identifiers start with a letter or underscore and are followed by\n(optional) additional letters, underscores, digits or hyphens.</p>\n"},"itemId":{"!type":"string","!doc":"<p>The <strong>unique</strong> id of this component instance within its container. See also the\nreference config.</p>\n\n<p>An <code>itemId</code> can be used as an alternative way to get a reference to a component when no object reference is\navailable. Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with getCmp, use\n<code>itemId</code> with <a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will\nretrieve <code>itemId</code>'s or <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>'s. Since <code>itemId</code>'s are an index to the container's\ninternal collection, the <code>itemId</code> is scoped locally to the container -- avoiding\npotential conflicts with Ext.ComponentManager which requires a <strong>unique</strong>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> values.</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({ //\n    <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as Ext.getCmp()\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>, <code>Ext.container.Container.query</code>, <code>Ext.container.Container.down</code> and\n<code>Ext.container.Container.child</code>.</p>\n\n<p><strong>Note</strong>: Valid identifiers start with a letter or underscore and are followed by\n(optional) additional letters, underscores, digits or hyphens.</p>\n\n<p><strong>Note</strong>: to access the container of an item see <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.</p>\n"},"loader":{"!doc":"<p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content\nfor this Component.</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: Ext.getBody()\n});\n</code></pre>\n"},"margin":{"!doc":"<p>Specifies the margin for this component. The margin can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"maskElement":{"!type":"string","!doc":"<p>Related to the <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a> configuration which specifies named properties which correspond to component sub-elements.</p>\n\n<p>The name of the element property in this component to mask when masked by a LoadMask.</p>\n\n<p>Defaults to <code>null</code> to indicate that Components cannot by default contain a LoadMask, and that any LoadMask should be rendered into the document body.</p>\n\n<p>For example, Panels use <code>\"el\"</code> to indicate that the whole panel should be masked. This could be configured to be\n<code>\"body\"</code> so that only the body is masked and toolbars and the header are still mouse-accessible.</p>\n"},"maxHeight":{"!type":"number","!doc":"<p>The maximum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"maxWidth":{"!type":"number","!doc":"<p>The maximum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"minHeight":{"!type":"number","!doc":"<p>The minimum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"modelValidation":{"!type":"bool","!doc":"<p>This config enables binding to your <code>Ext.data.Model.validators</code>. This\nis only processed by form fields (e.g., <code><a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a></code>) at present, but\nthis setting is inherited and so can be set on a parent container.</p>\n\n<p>When set to <code>true</code> by a component or not set by a component but inherited from\nan ancestor container, <code>Ext.data.Validation</code> records are used to automatically\nbind validation results for any form field to which a <code>value</code> is bound.</p>\n\n<p>While this config can be set arbitrarily high in the component hierarchy, doing\nso can create a lot overhead if most of your form fields do not actually rely on\n<code>validators</code> in your data model.</p>\n\n<p>Using this setting for a form that is bound to an <code>Ext.data.Model</code> might look\nlike this:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     modelValidation: true,\n     items: [{\n         xtype: 'textfield',\n         bind: '{theUser.firstName}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.lastName}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.phoneNumber}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.email}'\n     }]\n }\n</code></pre>\n\n<p>The above is equivalent to the following manual binding of validation:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     items: [{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.firstName}'\n             validation: '{theUser.validation.firstName}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.lastName}'\n             validation: '{theUser.validation.lastName}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.phoneNumber}'\n             validation: '{theUser.validation.phoneNumber}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.email}'\n             validation: '{theUser.validation.email}'\n         }\n     }]\n }\n</code></pre>\n\n<p>Notice that \"validation\" is a pseudo-association defined for all entities. See\n<code>Ext.data.Model.getValidation</code> for further details.</p>\n"},"overflowX":{"!type":"string","!doc":"<p>Possible values are:</p>\n\n<ul>\n<li><code>'auto'</code> to enable automatic horizontal scrollbar (Style overflow-x: 'auto').</li>\n<li><code>'scroll'</code> to always enable horizontal scrollbar (Style overflow-x: 'scroll').</li>\n</ul>\n\n\n<p>The default is overflow-x: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"overflowY":{"!type":"string","!doc":"<p>Possible values are:</p>\n\n<ul>\n<li><code>'auto'</code> to enable automatic vertical scrollbar (Style overflow-y: 'auto').</li>\n<li><code>'scroll'</code> to always enable vertical scrollbar (Style overflow-y: 'scroll').</li>\n</ul>\n\n\n<p>The default is overflow-y: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"padding":{"!doc":"<p>Specifies the padding for this component. The padding can be a single numeric value to apply to all sides or it\ncan be a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"plugins":{"!doc":"<p>An array of plugins to be added to this component. Can also be just a single plugin instead of array.</p>\n\n<p>Plugins provide custom functionality for a component. The only requirement for\na valid plugin is that it contain an <code>init</code> method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. When a component\nis created, if any plugins are available, the component will call the init method on each plugin, passing a\nreference to itself. Each plugin can then call methods or respond to events on the component as needed to provide\nits functionality.</p>\n\n<p>Plugins can be added to component by either directly referencing the plugin instance:</p>\n\n<pre><code>plugins: [Ext.create('<a href=\"#!/api/Ext.grid.plugin.CellEditing\" rel=\"Ext.grid.plugin.CellEditing\" class=\"docClass\">Ext.grid.plugin.CellEditing</a>', {clicksToEdit: 1})],\n</code></pre>\n\n<p>By using config object with ptype:</p>\n\n<pre><code>plugins: [{ptype: 'cellediting', clicksToEdit: 1}],\n</code></pre>\n\n<p>Or with just a ptype:</p>\n\n<pre><code>plugins: ['cellediting', 'gridviewdragdrop'],\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Plugin\" rel=\"Ext.enums.Plugin\" class=\"docClass\">Ext.enums.Plugin</a> for list of all ptypes.</p>\n"},"region":{"!doc":"<p>Defines the region inside <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p>\n\n<p>Possible values:</p>\n\n<ul>\n<li>north - Positions component at top.</li>\n<li>south - Positions component at bottom.</li>\n<li>east - Positions component at right.</li>\n<li>west - Positions component at left.</li>\n<li>center - Positions component at the remaining space.\nThere <strong>must</strong> be a component with <code>region: \"center\"</code> in every border layout.</li>\n</ul>\n\n"},"renderData":{"!doc":"<p>The data used by <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a> in addition to the following property values of the component:</p>\n\n<ul>\n<li>id</li>\n<li>ui</li>\n<li>uiCls</li>\n<li>baseCls</li>\n<li>componentCls</li>\n<li>frame</li>\n</ul>\n\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-renderSelectors\" rel=\"Ext.Component-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a> for usage examples.</p>\n"},"renderSelectors":{"!doc":"<p>An object containing properties specifying CSS selectors which identify child elements\ncreated by the render process.</p>\n\n<p>After the Component's internal structure is rendered according to the <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, this object is iterated through,\nand the found Elements are added as properties to the Component using the <code>renderSelector</code> property name.</p>\n\n<p>For example, a Component which renders a title and description into its element:</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     renderSelectors: {\n         titleEl: 'h1.title',\n         descEl: 'p'\n     },\n     listeners: {\n         afterrender: function(cmp){\n             // After rendering the component will have a titleEl and descEl properties\n             cmp.titleEl.setStyle({color: \"red\"});\n         }\n     }\n });\n</code></pre>\n\n<p>The use of <code>renderSelectors</code> is deprecated (for performance reasons). The above\ncode should be refactored into something like this:</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\" id=\"{id}-titleEl\" data-ref=\"titleEl\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p id=\"{id}-descEl\" data-ref=\"descEl\"&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     childEls: [\n         'titleEl',\n         'descEl'\n     ]\n });\n</code></pre>\n\n<p>To use <code>childEls</code> yet retain the use of selectors (which remains as expensive as\n<code>renderSelectors</code>):</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     childEls: {\n         titleEl: { selectNode: 'h1.title' },\n         descEl: { selectNode: 'p' }\n     }\n });\n</code></pre>\n"},"renderTo":{"!doc":"<p>Specify the <code>id</code> of the element, a DOM element or an existing Element that this component will be rendered into.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>Do <em>not</em> use this option if the Component is to be a child item of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>.\nIt is the responsibility of the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>'s\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout manager</a> to render and manage its child items.</p>\n\n<p>When using this config, a call to <code>render()</code> is not required.</p>\n\n<p>See also: <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n"},"resizable":{"!doc":"<p>Specify as <code>true</code> to apply a <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a> to this Component after rendering.</p>\n\n<p>May also be specified as a config object to be passed to the constructor of <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a>\nto override any defaults. By default the Component passes its minimum and maximum size, and uses\n<code><a href=\"#!/api/Ext.resizer.Resizer-cfg-dynamic\" rel=\"Ext.resizer.Resizer-cfg-dynamic\" class=\"docClass\">Ext.resizer.Resizer.dynamic</a>: false</code></p>\n"},"resizeHandles":{"!type":"string","!doc":"<p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n"},"rtl":{"!type":"bool","!doc":"<p>True to layout this component and its descendants in \"rtl\" (right-to-left) mode.\nCan be explicitly set to false to override a true value inherited from an ancestor.</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"style":{"!doc":"<p>A custom style specification to be applied to this component's Element. Should be a valid argument to\nExt.dom.Element.applyStyles.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Some Title',\n    renderTo: Ext.getBody(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n    new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>({\n        text: 'Send',\n        minWidth: '100',\n        style: {\n            marginBottom: '10px'\n        }\n    })\n    ]\n});\n</code></pre>\n"},"toFrontOnShow":{"!type":"bool","!doc":"<p>True to automatically call <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> when the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method is called on an already visible,\nfloating component.</p>\n"},"tpl":{"!doc":"<p>An Ext.Template, Ext.XTemplate or an array of strings to form an Ext.XTemplate. Used in\nconjunction with the <code><a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-tplWriteMode\" rel=\"Ext.Component-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n"},"tplWriteMode":{"!type":"string","!doc":"<p>The Ext.(X)Template method to use when updating the content area of the Component.\nSee <code>Ext.XTemplate.overwrite</code> for information on default mode.</p>\n"},"ui":{"!type":"string","!doc":"<p>A UI style for a component.</p>\n"},"uiCls":{"!doc":"<p>An array of of <code>classNames</code> which are currently applied to this component.</p>\n"},"weight":{"!type":"number","!doc":"<p>A value to control how Components are laid out in a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border</a> layout or as docked items.</p>\n\n<p>In a Border layout, this can control how the regions (not the center) region lay out if the west or east take full height\nor if the north or south region take full width. Also look at the <a href=\"#!/api/Ext.layout.container.Border-cfg-regionWeights\" rel=\"Ext.layout.container.Border-cfg-regionWeights\" class=\"docClass\">Ext.layout.container.Border.regionWeights</a> on the Border layout. An example to show how you can\ntake control of this is:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>', {\n    layout      : 'border',\n    defaultType : 'panel',\n    items       : [\n        {\n            region : 'north',\n            title  : 'North',\n            height : 100\n        },\n        {\n            region : 'south',\n            title  : 'South',\n            height : 100,\n            weight : -25\n        },\n        {\n            region : 'west',\n            title  : 'West',\n            width  : 200,\n            weight : 15\n        },\n        {\n            region : 'east',\n            title  : 'East',\n            width  : 200\n        },\n        {\n            region : 'center',\n            title  : 'center'\n        }\n    ]\n});\n</code></pre>\n\n<p>If docked items, the weight will order how the items are laid out. Here is an example to put a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a> above\na <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>'s header:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    renderTo    : document.body,\n    width       : 300,\n    height      : 300,\n    title       : 'Panel',\n    html        : 'Panel Body',\n    dockedItems : [\n        {\n            xtype : 'toolbar',\n            items : [\n                {\n                    text : 'Save'\n                }\n            ]\n        },\n        {\n            xtype  : 'toolbar',\n            weight : -10,\n            items  : [\n                {\n                    text : 'Remove'\n                }\n            ]\n        }\n    ]\n});\n</code></pre>\n"},"width":{"!type":"number","!doc":"<p>The width of this component in pixels.</p>\n"},"xtype":{"!doc":"<p>This property provides a shorter alternative to creating objects than using a full\nclass name. Using <code>xtype</code> is the most common way to define component instances,\nespecially in a container. For example, the items in a form containing text fields\ncould be created explicitly like so:</p>\n\n<pre><code> items: [\n     Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Foo'\n     }),\n     Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Bar'\n     }),\n     Ext.create('<a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>', {\n         fieldLabel: 'Num'\n     })\n ]\n</code></pre>\n\n<p>But by using <code>xtype</code>, the above becomes:</p>\n\n<pre><code> items: [\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Foo'\n     },\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Bar'\n     },\n     {\n         xtype: 'numberfield',\n         fieldLabel: 'Num'\n     }\n ]\n</code></pre>\n\n<p>When the <code>xtype</code> is common to many items, <a href=\"#!/api/Ext.container.Container-cfg-defaultType\" rel=\"Ext.container.Container-cfg-defaultType\" class=\"docClass\">Ext.container.Container.defaultType</a>\nis another way to specify the <code>xtype</code> for all items that don't have an explicit <code>xtype</code>:</p>\n\n<pre><code> defaultType: 'textfield',\n items: [\n     { fieldLabel: 'Foo' },\n     { fieldLabel: 'Bar' },\n     { fieldLabel: 'Num', xtype: 'numberfield' }\n ]\n</code></pre>\n\n<p>Each member of the <code>items</code> array is now just a \"configuration object\". These objects\nare used to create and configure component instances. A configuration object can be\nmanually used to instantiate a component using Ext.widget:</p>\n\n<pre><code> var text1 = Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n     fieldLabel: 'Foo'\n });\n\n // or alternatively:\n\n var text1 = Ext.widget({\n     xtype: 'textfield',\n     fieldLabel: 'Foo'\n });\n</code></pre>\n\n<p>This conversion of configuration objects into instantiated components is done when\na container is created as part of its {Ext.container.AbstractContainer#initComponent}\nprocess. As part of the same process, the <code>items</code> array is converted from its raw\narray form into a Ext.util.MixedCollection instance.</p>\n\n<p>You can define your own <code>xtype</code> on a custom <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">component</a> by specifying\nthe <code>xtype</code> property in Ext.define. For example:</p>\n\n<pre><code>Ext.define('MyApp.PressMeButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'pressmebutton',\n    text: 'Press Me'\n});\n</code></pre>\n\n<p>Care should be taken when naming an <code>xtype</code> in a custom component because there is\na single, shared scope for all xtypes. Third part components should consider using\na prefix to avoid collisions.</p>\n\n<pre><code>Ext.define('Foo.form.CoolButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'ux-coolbutton',\n    text: 'Cool!'\n});\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Widget\" rel=\"Ext.enums.Widget\" class=\"docClass\">Ext.enums.Widget</a> for list of all available xtypes.</p>\n"},"$configPrefixed":{"!type":"bool","!doc":"<p>We do not want \"_hidden\" style backing properties.</p>\n"},"$configStrict":{"!type":"bool","!doc":"<p>We also want non-config system properties to go to the instance.</p>\n"},"_asLayoutRoot":{},"_isLayoutRoot":{"!type":"bool","!doc":"<p>Setting this property to <code>true</code> causes the <a href=\"#!/api/Ext.Component-method-isLayoutRoot\" rel=\"Ext.Component-method-isLayoutRoot\" class=\"docClass\">isLayoutRoot</a> method to return\n<code>true</code> and stop the search for the top-most component for a layout.</p>\n"},"allowDomMove":{"!type":"bool","!doc":"<p>private</p>\n"},"autoGenId":{"!type":"bool","!doc":"<p><code>true</code> indicates an <code>id</code> was auto-generated rather than provided by configuration.</p>\n"},"borderBoxCls":{"!type":"string","!doc":"<p>private</p>\n"},"componentLayoutCounter":{"!type":"number","!doc":"<p>The number of component layout calls made on this object.</p>\n"},"contentPaddingProperty":{"!type":"string","!doc":"<p>The name of the padding property that is used by the layout to manage\npadding.  See <a href=\"#!/api/Ext.layout.container.Auto-property-managePadding\" rel=\"Ext.layout.container.Auto-property-managePadding\" class=\"docClass\">managePadding</a></p>\n"},"deferLayouts":{"!type":"bool","!doc":"<p>private</p>\n"},"deprecated":{"!doc":"<p>private</p>\n"},"disabledRe":{"!doc":"<p>http://www.w3.org/TR/html5/disabled-elements.html</p>\n"},"floatParent":{"!doc":"<p><strong>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers.</strong></p>\n\n<p>There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>floatParent</code>\nproperty.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"frameSize":{"!doc":"<p>Indicates the width of any framing elements which were added within the encapsulating\nelement to provide graphical, rounded borders. See the <a href=\"#!/api/Ext.Component-cfg-frame\" rel=\"Ext.Component-cfg-frame\" class=\"docClass\">frame</a> config. This\nproperty is <code>null</code> if the component is not framed.</p>\n\n<p>This is an object containing the frame width in pixels for all four sides of the\nComponent containing the following properties:</p>\n"},"horizontalPosProp":{"!type":"string","!doc":"<p>private</p>\n"},"isComponent":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Component, or subclass thereof.</p>\n"},"layoutSuspendCount":{"!type":"number","!doc":"<p>private</p>\n"},"maskOnDisable":{"!type":"bool","!doc":"<p>This is an internal flag that you use when creating custom components. By default this is set to <code>true</code> which means\nthat every component gets a mask when it's disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to <code>false</code> since they want to implement custom disable logic.</p>\n"},"nonMaskableRe":{},"offsetsCls":{"!type":"string","!doc":"<p>private</p>\n"},"ownerCt":{"!doc":"<p>This Component's owner <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> (is set automatically\nwhen this Component is added to a Container).</p>\n\n<p><em>Important.</em> This is not a universal upwards navigation pointer. It indicates the Container which owns and manages\nthis Component if any. There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p><strong>Note</strong>: to access items within the Container see <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"rendered":{"!type":"bool","!doc":"<p>Indicates whether or not the component has been rendered.</p>\n"},"rootCls":{"!type":"string","!doc":"<p>private</p>\n"},"scrollFlags":{"!doc":"<p>An object property which provides unified information as to which dimensions are scrollable based upon\nthe <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> settings (And for <em>views</em> of trees and grids, the owning panel's <a href=\"#!/api/Ext.panel.Table-cfg-scroll\" rel=\"Ext.panel.Table-cfg-scroll\" class=\"docClass\">scroll</a> setting).</p>\n\n<p>Note that if you set overflow styles using the <a href=\"#!/api/Ext.Component-cfg-style\" rel=\"Ext.Component-cfg-style\" class=\"docClass\">style</a> config or <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config, this object does not include that information;\nit is best to use <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> if you need to access these flags.</p>\n\n<p>This object has the following properties:</p>\n"},"scrollerCls":{"!type":"string","!doc":"<p>private</p>\n"},"scrollerSelector":{"!type":"string"},"synthetic":{"!type":"bool","!doc":"<p>This property is <code>true</code> if the component was created internally by the framework\nand is not explicitly user-defined. This is set for such things as <code>Splitter</code>\ninstances managed by <code>border</code> and <code>box</code> layouts.</p>\n"},"validIdRe":{},"zIndexManager":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components after they have been rendered.</p>\n\n<p>A reference to the ZIndexManager which is managing this Component's z-index.</p>\n\n<p>The <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> maintains a stack of floating Component z-indices, and also provides\na single modal mask which is insert just beneath the topmost visible modal floating Component.</p>\n\n<p>Floating Components may be <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">brought to the front</a> or <a href=\"#!/api/Ext.Component-method-toBack\" rel=\"Ext.Component-method-toBack\" class=\"docClass\">sent to the back</a> of the\nz-index stack.</p>\n\n<p>This defaults to the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> for floating Components that are\nprogramatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a>.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are added to a Container, the ZIndexManager is acquired from the first\nancestor Container found which is floating. If no floating ancestor is found, the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> is\nused.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexParent\" rel=\"Ext.Component-property-zIndexParent\" class=\"docClass\">zIndexParent</a></p>\n"},"zIndexParent":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers, and which have a floating\nContainer in their containment ancestry.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are child items of a Container, the zIndexParent will be a floating\nancestor Container which is responsible for the base z-index value of all its floating descendants. It provides\na <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which provides z-indexing services for all its descendant floating\nComponents.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>zIndexParent</code>\nproperty.</p>\n\n<p>For example, the dropdown <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">BoundList</a> of a ComboBox which is in a Window will have the\nWindow as its <code>zIndexParent</code>, and will always show above that Window, wherever the Window is placed in the z-index stack.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"addClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addClsWithUI":{"!type":"fn(classes: ?, skip?: ?) -> !this","!doc":"<p>Adds a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.Component-method-addUIClsToElement\" rel=\"Ext.Component-method-addUIClsToElement\" class=\"docClass\">addUIClsToElement</a> and adds to all elements of this\ncomponent.</p>\n"},"addFocusListener":{"!type":"fn() -> !this","!doc":"<p>Sets up the focus listener on this Component's <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a> if it has one.</p>\n\n<p>Form Components which must implicitly participate in tabbing order usually have a naturally focusable\nelement as their <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a>, and it is the DOM event of that receiving focus which drives\nthe Component's <code>onFocus</code> handling, and the DOM event of it being blurred which drives the <code>onBlur</code> handling.</p>\n\n<p>If the <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a> is <strong>not</strong> naturally focusable, then the listeners are only added\nif the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is enabled.</p>\n"},"addListener":{"!type":"fn(element: ?, listeners: ?, scope: ?, options: ?) -> !this"},"addPlugin":{"!type":"fn(plugin: ?) -> !this","!doc":"<p>Adds a plugin. May be called at any time in the component's lifecycle.</p>\n"},"addPropertyToState":{"!type":"fn(state: ?, propName: ?, value?: ?) -> bool","!doc":"<p>Save a property to the given state object if it is not its default or configured\nvalue.</p>\n"},"addUIClsToElement":{"!type":"fn(uiCls: ?) -> !this","!doc":"<p>Method which adds a specified UI + <code>uiCls</code> to the components element. Can be overridden\nto add the UI to more than just the component's element.</p>\n"},"addUIToElement":{"!type":"fn() -> !this","!doc":"<p>Method which adds a specified UI to the components element.</p>\n"},"adjustPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>private</p>\n"},"afterComponentLayout":{"!type":"fn(width: ?, height: ?, oldWidth: ?, oldHeight: ?) -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"afterHide":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component has been hidden.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-onHide\" rel=\"Ext.Component-method-onHide\" class=\"docClass\">onHide</a> received.</p>\n"},"afterSetPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Template method called after a Component has been positioned.</p>\n"},"afterShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component is shown (after <a href=\"#!/api/Ext.Component-method-onShow\" rel=\"Ext.Component-method-onShow\" class=\"docClass\">onShow</a> is called).</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-event-show\" rel=\"Ext.Component-event-show\" class=\"docClass\">show</a>.</p>\n"},"animate":{"!type":"fn(animObj: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the Sprite\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = Ext.create('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margin: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margin: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"},"applyData":{"!type":"fn(data: ?) -> !this"},"beforeBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-blur processing.</p>\n"},"beforeComponentLayout":{"!type":"fn(adjWidth: ?, adjHeight: ?) -> !this","!doc":"<p>Occurs before <code>componentLayout</code> is run. Returning <code>false</code> from this method will prevent the <code>componentLayout</code> from\nbeing executed.</p>\n"},"beforeFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-focus processing.</p>\n"},"beforeInitConfig":{"!type":"fn() -> !this"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeSetPosition":{"!type":"fn(x: ?, y: ?, animate: ?) -> !this","!doc":"<p>Template method called before a Component is positioned.</p>\n\n<p>Ensures that the position is adjusted so that the Component is constrained if so configured.</p>\n"},"beforeShow":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is shown.</p>\n"},"bubble":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Bubbles up the component/container hierarchy, calling the specified function with each component. The scope\n(<em>this</em>) of function call will be the scope provided or the current component. The arguments to the function will\nbe the args provided or the current component. If the function returns false at any point, the bubble is stopped.</p>\n"},"cancelFocus":{"!type":"fn() -> !this","!doc":"<p>Cancel any deferred focus on this component</p>\n"},"cloneConfig":{"!type":"fn(overrides: ?) -> ?","!doc":"<p>Clone the current component using the original config values passed into this instance by default.</p>\n"},"constructPlugin":{"!type":"fn(ptype: ?) -> !this"},"constructPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of fully constructed plugin instances. This converts any configs into their\nappropriate instances.</p>\n\n<p>It does not mutate the plugins array. It creates a new array.</p>\n"},"destroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is <a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>ed.</p>\n"},"doComponentLayout":{"!type":"fn() -> ?","!doc":"<p>This method needs to be called whenever you change something on this component that\nrequires the Component's layout to be recalculated.</p>\n"},"findComponentByElement":{"!type":"fn(node: ?) -> !this","!doc":"<p>Walk the DOM tree upwards and find the Component these elements belong to.</p>\n"},"findParentBy":{"!type":"fn(fn: ?) -> ?","!doc":"<p>Find a container above this component at any level by a custom function. If the passed function returns true, the\ncontainer will be returned.</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findParentByType":{"!type":"fn(xtype: ?) -> ?","!doc":"<p>Find a container above this component at any level by xtype or class</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findPlugin":{"!type":"fn(ptype: ?) -> ?","!doc":"<p>Retrieves plugin from this component's collection by its <code>ptype</code>.</p>\n"},"fireHierarchyEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>This method fires an event on <code>Ext.GlobalEvents</code> allowing interested parties to know\nof certain critical events for this component. This is done globally because the\n(few) listeners can immediately receive the event rather than bubbling the event\nonly to reach the top and have no listeners.</p>\n\n<p>The main usage for these events is to do with floating components. For example, the\nload mask is a floating component. The component it is masking may be inside several\ncontainers. As such, they need to know when component is hidden, either directly, or\nvia a parent container being hidden. To do this they subscribe to these events and\nfilter out the appropriate container.</p>\n\n<p>This functionality is contained in Component (as opposed to Container) because a\nComponent can be the ownerCt for a floating component (loadmask), and the loadmask\nneeds to know when its owner is shown/hidden so that its hidden state can be\nsynchronized.</p>\n"},"focus":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component receives focus.</p>\n"},"forceComponentLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"getActiveComponent":{"!type":"fn() -> ?","!doc":"<p>Return the currently active (focused) Component</p>\n"},"getAnchorToXY":{"!type":"fn(el: ?, anchor: ?, local: ?, mySize: ?) -> !this","!doc":"<p><editor-fold desc=\"Positionable Methods\"></editor></p>\n\n<hr />\n\n<p> Begin Positionable methods</p>\n\n<hr />\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getAnimateTarget":{"!type":"fn(target: ?) -> !this"},"getAutoId":{"!type":"fn() -> !this"},"getBorderPadding":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getBubbleTarget":{"!type":"fn() -> !this","!doc":"<p>Implements an upward event bubbling policy. By default a Component bubbles events up to its reference owner.</p>\n\n<p>Component subclasses may implement a different bubbling strategy by overriding this method.</p>\n"},"getComponentByElement":{"!type":"fn(el: ?) -> ?","!doc":"<p>Find a Component that the given Element belongs to.</p>\n"},"getComponentLayout":{"!type":"fn() -> !this"},"getData":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a>.</p>\n"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Retrieves the top level element representing this component.</p>\n"},"getFocusEl":{"!type":"fn() -> ?","!doc":"<p>Returns the focus holder element associated with this Component. At the Component base class level, this function returns <code>undefined</code>.</p>\n\n<p>Subclasses which use embedded focusable elements (such as Window, Field and Button) should override this\nfor use by the <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focus</a> method.</p>\n\n<p>Containers which need to participate in the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a>'s navigation and Container focusing scheme also\nneed to return a <code>focusEl</code>, although focus is only listened for in this case if the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is <a href=\"#!/api/Ext.FocusManager-method-enable\" rel=\"Ext.FocusManager-method-enable\" class=\"docClass\">enable</a>d.</p>\n"},"getHeight":{"!type":"fn() -> number","!doc":"<p>Gets the current height of the component's underlying element.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Retrieves the <code>id</code> of this component. Will auto-generate an <code>id</code> if one has not already been set.</p>\n"},"getItemId":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a> assigned to this component, or when that\nis not set, returns the value of <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getLoader":{"!type":"fn() -> ?","!doc":"<p>Gets the <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> for this Component.</p>\n"},"getLocalX":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getLocalXY":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getLocalY":{"!type":"fn() -> !this"},"getMaskTarget":{"!type":"fn() -> !this","!doc":"<p>Returns the element which is masked by the <a href=\"#!/api/Ext.Component-method-mask\" rel=\"Ext.Component-method-mask\" class=\"docClass\">mask</a> method, or into which the <a href=\"#!/api/Ext.Component-method-setLoading\" rel=\"Ext.Component-method-setLoading\" class=\"docClass\">LoadMask</a> is rendered into.</p>\n\n<p>The default implementation uses the <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a> configuration to access the Component's child element by name. By default, <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>\nis <code>null</code> which means that <code>null</code> is returned from this method indicating that the mask needs to be rendered into the document because\ncomponent structure should not be contaminated by mask elements.</p>\n\n<p>Some subclasses may override this method if they have knowledge about external structures where a mask could usefully be rendered.</p>\n\n<p>For example a <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">GridView</a> will request that its owning <a href=\"#!/api/Ext.panel.Table\" rel=\"Ext.panel.Table\" class=\"docClass\">GridPanel</a> be masked. The\nGridPanel will have its own implementation of <code>getMaskTarget</code> which will return the element dicated by its own <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>\nPanels use <code>\"el\"</code> as their <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a> by default, but that could be overridden to be <code>\"body\"</code> to leave toolbars and the header\nmouse-accessible.</p>\n"},"getOverflowEl":{"!type":"fn() -> !this","!doc":"<p>Get an el for overflowing, defaults to the target el</p>\n"},"getOverflowStyle":{"!type":"fn() -> !this","!doc":"<p>Returns the CSS style object which will set the Component's scroll styles. This must be applied\nto the <a href=\"#!/api/Ext.Component-method-getTargetEl\" rel=\"Ext.Component-method-getTargetEl\" class=\"docClass\">target element</a>.</p>\n"},"getOwningBorderContainer":{"!type":"fn() -> ?","!doc":"<p>Returns the owning container if that container uses <code>border</code> layout. Otherwise\nthis method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getOwningBorderLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the owning <code>border</code> (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>) instance if there is\none. Otherwise this method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getPlugin":{"!type":"fn(pluginId: ?) -> ?","!doc":"<p>Retrieves a plugin from this component's collection by its <code>pluginId</code>.</p>\n"},"getPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of current fully constructed plugin instances.</p>\n"},"getPosition":{"!type":"fn(local?: ?) -> ?","!doc":"<p>Gets the current XY position of the component's underlying element.</p>\n"},"getScrollX":{"!type":"fn() -> number","!doc":"<p>Returns the \"x\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code>.</p>\n"},"getScrollY":{"!type":"fn() -> number","!doc":"<p>Returns the \"y\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"getSize":{"!type":"fn(contentSize?: ?) -> ?","!doc":"<p>Gets the current size of the component's underlying element.</p>\n"},"getSizeModel":{"!type":"fn(ownerCtSizeModel: ?) -> ?","!doc":"<p>Returns an object that describes how this component's width and height are managed.\nAll of these objects are shared and should not be modified.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>The supplied default state gathering method for the Component class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n"},"getTargetEl":{"!type":"fn() -> !this","!doc":"<p>This is used to determine where to insert the 'html', 'contentEl' and 'items' in this component.</p>\n"},"getTdType":{"!type":"fn() -> !this","!doc":"<p>Partner method to <a href=\"#!/api/Ext.Component-method-getTdCls\" rel=\"Ext.Component-method-getTdCls\" class=\"docClass\">getTdCls</a>.</p>\n\n<p>Returns the base type for the component. Defaults to return <code>this.xtype</code>, but\nAll derived classes of <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">TextField</a> can return the type 'textfield',\nand all derived classes of <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Button</a> can return the type 'button'</p>\n"},"getTpl":{"!type":"fn(name: ?) -> !this"},"getWidth":{"!type":"fn() -> number","!doc":"<p>Gets the current width of the component's underlying element.</p>\n"},"getX":{"!type":"fn() -> !this"},"getXType":{"!type":"fn() -> string","!doc":"<p>Gets the xtype for this component as registered with Ext.ComponentManager. For a list of all available\nxtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n"},"getXTypes":{"!type":"fn() -> string","!doc":"<p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all available xtypes, see the\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXTypes());  // alerts 'component/field/textfield'\n</code></pre>\n"},"getXY":{"!type":"fn() -> !this"},"getY":{"!type":"fn() -> !this"},"hasCls":{"!type":"fn(className: ?) -> bool","!doc":"<p>Checks if the specified CSS class exists on this element's DOM node.</p>\n"},"hasUICls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Checks if there is currently a specified <code>uiCls</code>.</p>\n"},"hide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is hidden. Fires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>\nmethod.</p>\n"},"initBorderRegion":{"!type":"fn() -> !this","!doc":"<p>This method is called by the <code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class when instances are\nadded as regions to the layout. Since it is valid to add any component to a border\nlayout as a region, this method must be added to <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code> but is only ever\ncalled when that component is owned by a <code>border</code> layout.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"initEvents":{"!type":"fn() -> !this","!doc":"<p>Initialize any events on this component</p>\n"},"initInheritedState":{"!type":"fn(inheritedState: ?) -> !this","!doc":"<p>Called by <code>getInherited</code> to initialize the inheritedState the first time it is\nrequested.</p>\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"initPadding":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Initializes padding by applying it to the target element, or if the layout manages\npadding ensures that the padding on the target element is \"0\".</p>\n"},"initStyles":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Applies padding, margin, border, top, left, height, and width configs to the\nappropriate elements.</p>\n"},"is":{"!type":"fn(selector: ?) -> bool","!doc":"<p>Tests whether this Component matches a ComponentQuery\nselector string.</p>\n"},"isDescendantOf":{"!type":"fn(container: ?) -> bool","!doc":"<p>Determines whether this component is the descendant of a particular container.</p>\n"},"isDisabled":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently disabled.</p>\n"},"isDraggable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is draggable.</p>\n"},"isDroppable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is droppable.</p>\n"},"isFloating":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is floating.</p>\n"},"isFocusable":{"!type":"fn() -> !this"},"isHidden":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently set to hidden.</p>\n"},"isHierarchicallyHidden":{"!type":"fn() -> !this"},"isLayoutRoot":{"!type":"fn() -> !this","!doc":"<p>Determines whether this Component is the root of a layout. This returns <code>true</code> if\nthis component can run its layout without assistance from or impact on its owner.\nIf this component cannot run its layout given these restrictions, <code>false</code> is returned\nand its owner will be considered as the next candidate for the layout root.</p>\n\n<p>Setting the <a href=\"#!/api/Ext.Component-property-_isLayoutRoot\" rel=\"Ext.Component-property-_isLayoutRoot\" class=\"docClass\">_isLayoutRoot</a> property to <code>true</code> causes this method to always\nreturn <code>true</code>. This may be useful when updating a layout of a Container which shrink\nwraps content, and you know that it will not change size, and so can safely be the\ntopmost participant in the layout run.</p>\n"},"isLayoutSuspended":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if layout is suspended for this component. This can come from direct\nsuspension of this component's layout activity (<a href=\"#!/api/Ext.container.Container-cfg-suspendLayout\" rel=\"Ext.container.Container-cfg-suspendLayout\" class=\"docClass\">Ext.Container.suspendLayout</a>) or if one\nof this component's containers is suspended.</p>\n"},"isLocalRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's local coordinate system is rtl. For normal\ncomponents this equates to the value of isParentRtl().  Floaters are a bit different\nbecause a floater's element can be a childNode of something other than its\nparent component's element.  For floaters we have to read the dom to see if the\ncomponent's element's parentNode has a css direction value of \"rtl\".</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isOppositeRootDirection":{"!type":"fn() -> !this","!doc":"<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isParentRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's parent container is rtl. Used by rtl positioning\nmethods to determine if the component should be positioned using a right-to-left\ncoordinate system.</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isVisible":{"!type":"fn(deep?: ?) -> bool","!doc":"<p>Returns <code>true</code> if this component is visible.</p>\n"},"isXType":{"!type":"fn(xtype: ?, shallow?: ?) -> bool","!doc":"<p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (<code>shallow = true</code>).</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('field');       // true, descended from <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nvar isBoxInstance = t.isXType('field', true); // false, not a direct <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> instance\n</code></pre>\n"},"mask":{"!type":"fn(msg?: ?, msgCls?: ?) -> !this","!doc":"<p>Masks this component with a semi-opaque layer and makes the contents unavailable to clicks.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-method-unmask\" rel=\"Ext.Component-method-unmask\" class=\"docClass\">unmask</a>.</p>\n"},"nextNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree to attempt to find a match. Contrast with <a href=\"#!/api/Ext.Component-method-nextSibling\" rel=\"Ext.Component-method-nextSibling\" class=\"docClass\">nextSibling</a>.</p>\n"},"nextSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next sibling of this Component.</p>\n\n<p>Optionally selects the next sibling which matches the passed ComponentQuery selector.</p>\n\n<p>May also be referred to as <strong><code>next()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.Component-method-nextNode\" rel=\"Ext.Component-method-nextNode\" class=\"docClass\">nextNode</a></p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onBoxReady":{"!type":"fn(width: ?, height: ?) -> !this","!doc":"<p>Invoked when this component has first achieved size. Occurs after the\n<a href=\"#!/api/Ext.Component-cfg-componentLayout\" rel=\"Ext.Component-cfg-componentLayout\" class=\"docClass\">componentLayout</a> has completed its initial run.</p>\n"},"onDisable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the disable operation.\nAfter calling the superclass's <code>onDisable</code>, the Component will be disabled.</p>\n"},"onEnable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the enable operation.\nAfter calling the superclass's <code>onEnable</code>, the Component will be enabled.</p>\n"},"onFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onHide":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Allows addition of behavior to the hide operation. After\ncalling the superclass's onHide, the Component will be hidden.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-event-hide\" rel=\"Ext.Component-event-hide\" class=\"docClass\">hide</a>.</p>\n"},"onPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Called after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.Component-event-removed\" rel=\"Ext.Component-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"onResize":{"!type":"fn(width: ?, height: ?, oldWidth: ?, oldHeight: ?) -> !this","!doc":"<p>Allows addition of behavior to the resize operation.</p>\n\n<p>Called when Ext.resizer.Resizer#drag event is fired.</p>\n"},"onShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Allows addition of behavior to the show operation. After\ncalling the superclass's onShow, the Component will be visible.</p>\n\n<p>Override in subclasses where more complex behaviour is needed.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-event-show\" rel=\"Ext.Component-event-show\" class=\"docClass\">show</a>.</p>\n"},"onShowComplete":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> method is complete.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> received.</p>\n"},"onShowVeto":{"!type":"fn() -> !this"},"owns":{"!type":"fn(element: ?) -> !this","!doc":"<p>Returns <code>true</code> if the passed element is within the container tree of this component.</p>\n\n<p>For example if a menu's submenu contains an <a href=\"#!/api/Ext.form.field.Date\" rel=\"Ext.form.field.Date\" class=\"docClass\">Ext.form.field.Date</a>, that top level\nmenu owns the elements of the date picker. Using this method, you can tell if an event took place\nwithin a certain component tree.</p>\n"},"postBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any post-blur processing.</p>\n"},"previousNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree in reverse order to attempt to find a match. Contrast with <a href=\"#!/api/Ext.Component-method-previousSibling\" rel=\"Ext.Component-method-previousSibling\" class=\"docClass\">previousSibling</a>.</p>\n"},"previousSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous sibling of this Component.</p>\n\n<p>Optionally selects the previous sibling which matches the passed ComponentQuery\nselector.</p>\n\n<p>May also be referred to as <strong><code>prev()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.Component-method-previousNode\" rel=\"Ext.Component-method-previousNode\" class=\"docClass\">previousNode</a></p>\n"},"refreshScroll":{"!type":"fn() -> !this","!doc":"<p>Implementation which updates the scroll range of a touch scroller.\nSubclasses may change implementation.</p>\n"},"registerFloatingItem":{"!type":"fn(cmp: ?) -> !this","!doc":"<p>Called by Component#doAutoRender</p>\n\n<p>Register a Container configured <code>floating: true</code> with this Component's <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Components added in this way will not participate in any layout, but will be rendered\nupon first show in the way that <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s are.</p>\n"},"removeClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeClsWithUI":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Removes a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.Component-method-removeUIClsFromElement\" rel=\"Ext.Component-method-removeUIClsFromElement\" class=\"docClass\">removeUIClsFromElement</a> and removes it from all\nelements of this component.</p>\n"},"removeUIClsFromElement":{"!type":"fn(uiCls: ?) -> !this","!doc":"<p>Method which removes a specified UI + <code>uiCls</code> from the components element. The <code>cls</code>\nwhich is added to the element will be: <code>this.baseCls + '-' + ui + uiCls</code>.</p>\n"},"removeUIFromElement":{"!type":"fn() -> !this","!doc":"<p>Method which removes a specified UI from the components element.</p>\n"},"resumeLayouts":{"!type":"fn(flushOptions: ?) -> !this"},"scrollBy":{"!type":"fn(deltaX: ?, deltaY: ?, animate: ?) -> !this","!doc":"<p>Scrolls this Component by the passed delta values, optionally animating.</p>\n\n<p>All of the following are equivalent:</p>\n\n<pre><code> comp.scrollBy(10, 10, true);\n comp.scrollBy([10, 10], true);\n comp.scrollBy({ x: 10, y: 10 }, true);\n</code></pre>\n"},"scrollTo":{"!type":"fn(x: ?, y: ?, animate?: ?) -> !this","!doc":"<p>Scrolls this component to the specified <code>x</code> and <code>y</code> coordinates.  Only applicable\nfor components that have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or\n<code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"setAutoScroll":{"!type":"fn(scroll: ?) -> ?","!doc":"<p>Sets the overflow on the content element of the component.</p>\n"},"setBorder":{"!type":"fn(border: ?) -> !this"},"setData":{"!type":"fn(data: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a>.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Enable or disable the component.</p>\n"},"setDock":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setDocked":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setFlex":{"!type":"fn(flex: ?) -> !this","!doc":"<p>Sets the flex property of this component. Only applicable when this component is\nan item of a box layout</p>\n"},"setHeight":{"!type":"fn(height: ?) -> ?","!doc":"<p>Sets the height of the component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setHidden":{"!type":"fn(hidden: ?) -> ?","!doc":"<p>Sets the hidden state of this component. This is basically the same as\n<code><a href=\"#!/api/Ext.Component-method-setVisible\" rel=\"Ext.Component-method-setVisible\" class=\"docClass\">setVisible</a></code> but the boolean parameter has the opposite meaning.</p>\n"},"setHtml":{"!type":"fn(html: ?) -> !this"},"setLoading":{"!type":"fn(load: ?) -> ?","!doc":"<p>This method allows you to show or hide a LoadMask on top of this component.</p>\n\n<p>The mask will be rendered into the element returned by <a href=\"#!/api/Ext.Component-method-getMaskTarget\" rel=\"Ext.Component-method-getMaskTarget\" class=\"docClass\">getMaskTarget</a> which for most Components is the Component's\nelement. See <a href=\"#!/api/Ext.Component-method-getMaskTarget\" rel=\"Ext.Component-method-getMaskTarget\" class=\"docClass\">getMaskTarget</a> and <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>.</p>\n\n<p>Most Components will return <code>null</code> indicating that their LoadMask cannot reside inside their element, but must\nbe rendered into the document body.</p>\n\n<p><a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Grid Views</a> however will direct a LoadMask to be rendered into the owning <a href=\"#!/api/Ext.panel.Table\" rel=\"Ext.panel.Table\" class=\"docClass\">GridPanel</a>.</p>\n"},"setLocalX":{"!type":"fn(x: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"setLocalXY":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"setLocalY":{"!type":"fn(y: ?) -> !this"},"setMargin":{"!type":"fn(margin: ?) -> !this","!doc":"<p>Sets the margin on the target element.</p>\n"},"setOverflowXY":{"!type":"fn(overflowX: ?, overflowY: ?) -> ?","!doc":"<p>Sets the overflow x/y on the content element of the component. The x/y overflow\nvalues can be any valid CSS overflow (e.g., 'auto' or 'scroll'). By default, the\nvalue is 'hidden'. Passing null for one of the values will erase the inline style.\nPassing <code>undefined</code> will preserve the current value.</p>\n"},"setPagePosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the page XY position of the component. To set the left and top instead, use <a href=\"#!/api/Ext.Component-method-setPosition\" rel=\"Ext.Component-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setPosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the left and top of the component. To set the page XY position instead, use <a href=\"#!/api/Ext.Component-method-setPagePosition\" rel=\"Ext.Component-method-setPagePosition\" class=\"docClass\">setPagePosition</a>. This\nmethod fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setRegion":{"!type":"fn(region: ?) -> string","!doc":"<p>This method changes the <code>region</code> config property for this border region. This is\nonly valid if this component is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setScrollX":{"!type":"fn(x: ?) -> !this","!doc":"<p>Sets the \"x\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code>.</p>\n"},"setScrollY":{"!type":"fn(y: ?) -> !this","!doc":"<p>Sets the \"y\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"setSize":{"!type":"fn(width: ?, height: ?) -> ?","!doc":"<p>Sets the width and height of this Component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n"},"setStyle":{"!type":"fn(style: ?) -> !this","!doc":"<p>Sets the stlye for this Component's primary element.</p>\n"},"setVisible":{"!type":"fn(visible: ?) -> ?","!doc":"<p>Convenience function to hide or show this component by Boolean.</p>\n"},"setWeight":{"!type":"fn(weight: ?) -> number","!doc":"<p>Sets the <code>weight</code> config property for this component. This is only valid if this\ncomponent is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setWidth":{"!type":"fn(width: ?) -> ?","!doc":"<p>Sets the width of the component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setX":{"!type":"fn(x: ?, animate: ?) -> !this"},"setXY":{"!type":"fn(xy: ?, animate: ?) -> !this"},"setY":{"!type":"fn(y: ?, animate: ?) -> !this"},"show":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n"},"showAt":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Displays component at specific xy position.\nA floating component (like a menu) is positioned relative to its ownerCt if any.\nUseful for popping up a context menu:</p>\n\n<pre><code>listeners: {\n    itemcontextmenu: function(view, record, item, index, event, options) {\n        Ext.create('<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>', {\n            width: 100,\n            height: 100,\n            margin: '0 0 10 0',\n            items: [{\n                text: 'regular item 1'\n            },{\n                text: 'regular item 2'\n            },{\n                text: 'regular item 3'\n            }]\n        }).showAt(event.getXY());\n    }\n}\n</code></pre>\n"},"showBy":{"!type":"fn(component: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Shows this component by the specified <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> or Element.\nUsed when this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a>.</p>\n"},"suspendLayouts":{"!type":"fn() -> !this"},"unitizeBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"unmask":{"!type":"fn() -> !this","!doc":"<p>Removes the mask applied by <a href=\"#!/api/Ext.Component-method-mask\" rel=\"Ext.Component-method-mask\" class=\"docClass\">mask</a></p>\n"},"unregisterFloatingItem":{"!type":"fn(cmp: ?) -> !this"},"up":{"!type":"fn(selector?: ?, limit?: ?) -> ?","!doc":"<p>Navigates up the ownership hierarchy searching for an ancestor Container which matches any passed selector or component.</p>\n\n<p><em>Important.</em> There is not a universal upwards navigation pointer. There are several upwards relationships\nsuch as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by this method.</p>\n\n<p>Example:</p>\n\n<pre><code>var owningTabPanel = grid.up('tabpanel');\n</code></pre>\n"},"update":{"!type":"fn(htmlOrData: ?, loadScripts?: ?, callback?: ?) -> !this","!doc":"<p>Update the content area of a component.</p>\n"},"updateBox":{"!type":"fn(box: ?) -> ?","!doc":"<p>Sets the current box measurements of the component's underlying element.</p>\n"},"updateLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"activate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after a Component has been visually activated.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout or this Component is a floating Component.</p>\n"},"added":{"!type":"fn(this: ?, container: ?, pos: ?, eOpts: ?)","!doc":"<p>Fires after a Component had been added to a Container.</p>\n"},"afterrender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component rendering is finished.</p>\n\n<p>The <code>afterrender</code> event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocessed by any\n<code>afterRender</code> method defined for the Component.</p>\n"},"beforeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually activated. Returning <code>false</code> from an event listener can prevent\nthe activate from occurring.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout.</p>\n"},"beforedeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually deactivated. Returning <code>false</code> from an event listener can\nprevent the deactivate from occurring.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout.</p>\n"},"beforedestroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>ed. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>.</p>\n"},"beforehide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method. Return <code>false</code> from an event\nhandler to stop the hide.</p>\n"},"beforerender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n"},"beforeshow":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method. Return <code>false</code> from an event\nhandler to stop the show.</p>\n"},"blur":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component loses focus.</p>\n"},"boxready":{"!type":"fn(this: ?, width: ?, height: ?, eOpts: ?)","!doc":"<p>Fires <em>one time</em> - after the component has been laid out for the first time at its initial size.</p>\n"},"deactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after a Component has been visually deactivated.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout or this Component is a floating Component.</p>\n"},"disable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is disabled.</p>\n"},"enable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is enabled.</p>\n"},"move":{"!type":"fn(this: ?, x: ?, y: ?, eOpts: ?)","!doc":"<p>Fires after the component is moved.</p>\n"},"removed":{"!type":"fn(this: ?, ownerCt: ?, eOpts: ?)","!doc":"<p>Fires when a component is removed from an <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></p>\n"},"render":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n"},"resize":{"!type":"fn(this: ?, width: ?, height: ?, oldWidth: ?, oldHeight: ?, eOpts: ?)","!doc":"<p>Fires after the component is resized. Note that this does <em>not</em> fire when the component is first laid out at its initial\nsize. To hook that point in the life cycle, use the <a href=\"#!/api/Ext.Component-event-boxready\" rel=\"Ext.Component-event-boxready\" class=\"docClass\">boxready</a> event.</p>\n"},"autoEl":{"!doc":"<p>A tag name or DomHelper spec used to create the <a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"cls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n"},"disabled":{"!type":"bool","!doc":"<p><code>true</code> to disable the component.</p>\n"},"frame":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to have the Component inject framing elements within the Component at render time to provide a\ngraphical rounded frame around the Component content.</p>\n\n<p>This is only necessary when running on outdated, or non standard-compliant browsers such as Microsoft's Internet\nExplorer prior to version 9 which do not support rounded corners natively.</p>\n\n<p>The extra space taken up by this framing is available from the read only property <a href=\"#!/api/Ext.Component-property-frameSize\" rel=\"Ext.Component-property-frameSize\" class=\"docClass\">frameSize</a>.</p>\n"},"hidden":{"!type":"bool","!doc":"<p><code>true</code> to hide the component.</p>\n"},"minWidth":{"!type":"number","!doc":"<p>The minimum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"overCls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0 (or <code>false</code>): Neither width nor height depend on content.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2 (default): Height depends on content (shrink wraps), but width does not.</li>\n<li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"defaultBindProperty":{"!type":"string"},"liquidLayout":{"!type":"bool","!doc":"<p>Components that achieve their internal layout results using solely CSS with no JS\nintervention must set this to true.  Failure to set this property to true may result\nin setSize failing to work if the component opted out of the layout run.</p>\n"},"getTdCls":{"!type":"fn() -> !this","!doc":"<p>Needed for when widget is rendered into a grid cell. The class to add to the cell element.</p>\n"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\n<code>uiCls</code> set on the component and rename them so they include the new UI.</p>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.Component-cfg-renderSelectors\" rel=\"Ext.Component-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Positionable methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"AUTO_ID":{"!type":"number"},"DIRECTION_BOTTOM":{"!type":"string"},"DIRECTION_LEFT":{"!type":"string"},"DIRECTION_RIGHT":{"!type":"string"},"DIRECTION_TOP":{"!type":"string","!doc":"<p>Collapse/expand directions</p>\n"},"INVALID_ID_CHARS_Re":{"!doc":"<p>RegExp whih specifies characters in an xtype which must be translated to '-' when generating auto IDs.\nThis includes dot, comma and whitespace</p>\n"},"VERTICAL_DIRECTION_Re":{},"componentIdAttribute":{"!type":"string","!doc":"<p>Name of the element attribute containing its Component id. Used to look up Components\nby their Elements.</p>\n"},"pendingLayouts":{},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"cancelLayout":{"!type":"fn(comp: ?) -> !this","!doc":"<p>Cancels layout of a component.</p>\n"},"flushLayouts":{"!type":"fn() -> !this","!doc":"<p>Performs all pending layouts that were scheduled while\n<a href=\"#!/api/Ext.Component-method-suspendLayouts\" rel=\"Ext.Component-method-suspendLayouts\" class=\"docClass\">suspendLayouts</a> was in effect.</p>\n"}},"!doc":"<p>Base class for all Ext components.</p>\n\n<p>The Component base class has built-in support for basic hide/show and enable/disable\nand size control behavior.</p>\n\n<h2>xtypes</h2>\n\n<p>Every component has a specific xtype, which is its Ext-specific type name, along with\nmethods for checking the xtype like <a href=\"#!/api/Ext.Component-method-getXType\" rel=\"Ext.Component-method-getXType\" class=\"docClass\">getXType</a> and <a href=\"#!/api/Ext.Component-method-isXType\" rel=\"Ext.Component-method-isXType\" class=\"docClass\">isXType</a>. See the\n<a href=\"#!/guide/components\">Component Guide</a> for more information on xtypes and the Component hierarchy.</p>\n\n<h2>Finding components</h2>\n\n<p>All Components are registered with the Ext.ComponentManager on construction so\nthat they can be referenced at any time via Ext.getCmp, passing the\n<a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>.</p>\n\n<p>Additionally the Ext.ComponentQuery provides a CSS-selectors-like way to look\nup components by their xtype and many other attributes.  For example the following code\nwill find all textfield components inside component with <code>id: 'myform'</code>:</p>\n\n<pre><code>Ext.ComponentQuery.query('#myform textfield');\n</code></pre>\n\n<h2>Extending <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></h2>\n\n<p>All subclasses of Component may participate in the automated Ext component\nlifecycle of creation, rendering and destruction which is provided by the\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class. Components may be added to a Container\nthrough the <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> config option at the time\nthe Container is created, or they may be added dynamically via the\n<a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">add</a> method.</p>\n\n<p>All user-developed visual widgets that are required to participate in automated\nlifecycle and size management should subclass Component.</p>\n\n<p>See the Creating new UI controls chapter in <a href=\"#!/guide/components\">Component Guide</a> for details on how and\nto either extend or augment Ext JS base classes to create custom Components.</p>\n\n<h2>The <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> class by itself</h2>\n\n<p>Usually one doesn't need to instantiate the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> class. There are subclasses\nwhich implement specialized use cases, covering most application needs. However it is\npossible to instantiate a base Component, and it can be rendered to document, or handled\nby layouts as the child item of a Container:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    html: 'Hello world!',\n    width: 300,\n    height: 200,\n    padding: 20,\n    style: {\n        color: '#FFFFFF',\n        backgroundColor:'#000000'\n    },\n    renderTo: Ext.getBody()\n});\n</code></pre>\n\n<p>The Component above creates its encapsulating <code>div</code> upon render, and use the configured\nHTML as content. More complex internal structure may be created using the\n<a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a> configuration, although to display database-derived mass data, it is\nrecommended that an ExtJS data-backed Component such as a <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">View</a>,\n<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">GridPanel</a>, or <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">TreePanel</a> be used.</p>\n\n<p><strong>From override Ext.layout.container.border.Region:</strong> This override provides extra, border layout specific methods for <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code>. The\n<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class requires this override so that the added functions\nare only included in a build when <code>border</code> layout is used.</p>\n\n<p><strong>From override Ext.rtl.Component:</strong> This override adds RTL support and the <code>rtl</code> config option to AbstactComponent.</p>\n","!type":"fn(config: ?)","alignTarget":{"!type":"string","!doc":"<p>A Component or Element by which to position this component according to the <a href=\"#!/api/Ext.Component-cfg-defaultAlign\" rel=\"Ext.Component-cfg-defaultAlign\" class=\"docClass\">defaultAlign</a>.\nDefaults to ths owning Container.</p>\n\n<p><em>Only applicable if this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a></em></p>\n\n<p><em>Used upon first show</em>.</p>\n"},"autoEl":{"!doc":"<p>A tag name or DomHelper spec used to create the <a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"autoShow":{"!type":"bool","!doc":"<p><code>true</code> to automatically show the component upon creation. This config option may only be used for\n<a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> components or components that use <a href=\"#!/api/Ext.Component-cfg-autoRender\" rel=\"Ext.Component-cfg-autoRender\" class=\"docClass\">autoRender</a>.</p>\n"},"columnWidth":{"!doc":"<p>Defines the column width inside <a href=\"#!/api/Ext.layout.container.Column\" rel=\"Ext.layout.container.Column\" class=\"docClass\">column layout</a>.</p>\n\n<p>Can be specified as a number or as a percentage.</p>\n"},"componentCls":{"!type":"string","!doc":"<p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n"},"constrainTo":{"!doc":"<p>A Region (or an element from which a Region measurement will be read) which is used\nto constrain the component. Only applies when the component is floating.</p>\n"},"constraintInsets":{"!doc":"<p>An object or a string (in TRBL order) specifying insets from the configured <a href=\"#!/api/Ext.Component-cfg-constrainTo\" rel=\"Ext.Component-cfg-constrainTo\" class=\"docClass\">constrain region</a>\nwithin which this component must be constrained when positioning or sizing.\nexample:</p>\n\n<p>   constraintInsets: '10 10 10 10' // Constrain with 10px insets from parent</p>\n"},"contentEl":{"!type":"string","!doc":"<p>Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content for this component.</p>\n\n<p>This config option is used to take an existing HTML element and place it in the layout element of a new component\n(it simply moves the specified DOM element <em>after the Component is rendered</em> to use as the content.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>The specified HTML element is appended to the layout element of the component <em>after any configured\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">HTML</a> has been inserted</em>, and so the document will not contain this element at the time\nthe <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">render</a> event is fired.</p>\n\n<p>The specified HTML element used will not participate in any <strong><code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code></strong>\nscheme that the Component may use. It is just HTML. Layouts operate on child\n<strong><code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code></strong>.</p>\n\n<p>Add either the <code>x-hidden</code> or the <code>x-hidden-display</code> CSS class to prevent a brief flicker of the content before it\nis rendered to the panel.</p>\n"},"data":{"!doc":"<p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content\narea of the Component.</p>\n"},"defaultAlign":{"!type":"string","!doc":"<p>The default Ext.dom.Element#getAlignToXY anchor position value for this component\nrelative to its <a href=\"#!/api/Ext.Component-cfg-alignTarget\" rel=\"Ext.Component-cfg-alignTarget\" class=\"docClass\">alignTarget</a> (which defaults to its owning Container).</p>\n\n<p><em>Only applicable if this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a></em></p>\n\n<p><em>Used upon first show</em>.</p>\n"},"disabled":{"!type":"bool","!doc":"<p><code>true</code> to disable the component.</p>\n"},"disabledCls":{"!type":"string","!doc":"<p>CSS class to add when the Component is disabled.</p>\n"},"floating":{"!type":"bool","!doc":"<p>Specify as true to float the Component outside of the document flow using CSS absolute positioning.</p>\n\n<p>Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a>s are floating by default.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will register\nthemselves with the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<h3>Floating Components as child items of a Container</h3>\n\n<p>A floating Component may be used as a child item of a Container. This just allows the floating Component to seek\na ZIndexManager by examining the ownerCt chain.</p>\n\n<p>When configured as floating, Components acquire, at render time, a <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which\nmanages a stack of related floating Components. The ZIndexManager brings a single floating Component to the top\nof its stack when the Component's <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> method is called.</p>\n\n<p>The ZIndexManager is found by traversing up the <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a> chain to find an ancestor which itself is\nfloating. This is so that descendant floating Components of floating <em>Containers</em> (Such as a ComboBox dropdown\nwithin a Window) can have its zIndex managed relative to any siblings, but always <strong>above</strong> that floating\nancestor Container.</p>\n\n<p>If no floating ancestor is found, a floating Component registers itself with the default <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Floating components <em>do not participate in the Container's layout</em>. Because of this, they are not rendered until\nyou explicitly <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> them.</p>\n\n<p>After rendering, the ownerCt reference is deleted, and the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property is set to the found\nfloating ancestor Container. If no floating ancestor Container was found the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property will\nnot be set.</p>\n"},"formBind":{"!type":"bool","!doc":"<p>When inside FormPanel, any component configured with <code>formBind: true</code> will\nbe enabled/disabled depending on the validity state of the form.\nSee <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a> for more information and example.</p>\n"},"height":{"!type":"number","!doc":"<p>The height of this component in pixels.</p>\n"},"html":{"!doc":"<p>An HTML fragment, or a DomHelper specification to use as the layout element content.\nThe HTML content is added after the component is rendered, so the document will not contain this HTML at the time\nthe <a href=\"#!/api/Ext.Component-event-render\" rel=\"Ext.Component-event-render\" class=\"docClass\">render</a> event is fired. This content is inserted into the body <em>before</em> any configured <a href=\"#!/api/Ext.Component-cfg-contentEl\" rel=\"Ext.Component-cfg-contentEl\" class=\"docClass\">contentEl</a>\nis appended.</p>\n"},"id":{"!type":"string","!doc":"<p>The <strong>unique</strong> id of this component instance.</p>\n\n<p>Use of this config should be considered carefully as this value must be unique across\nall existing components. Components created with an <code>id</code> may be accessed globally\nusing Ext.getCmp.</p>\n\n<p>Instead of using assigned ids, consider a reference config and a ViewController\nto respond to events and perform processing upon this Component.</p>\n\n<p>Alternatively, <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a> and ComponentQuery can be\nused to perform selector-based searching for Components analogous to DOM querying.\nThe <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class contains several helpful\nshortcut methods to query its descendant\nComponents by selector.</p>\n\n<p>Note that this <code>id</code> will also be used as the element id for the containing HTML\nelement that is rendered to the page for this component. This allows you to write\nid-based CSS rules to style the specific instance of this component uniquely, and\nalso to select sub-elements using this component's <code>id</code> as the parent.</p>\n\n<p>Defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>.</p>\n\n<p><strong>Note</strong>: Valid identifiers start with a letter or underscore and are followed by\n(optional) additional letters, underscores, digits or hyphens.</p>\n"},"itemId":{"!type":"string","!doc":"<p>The <strong>unique</strong> id of this component instance within its container. See also the\nreference config.</p>\n\n<p>An <code>itemId</code> can be used as an alternative way to get a reference to a component when no object reference is\navailable. Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with getCmp, use\n<code>itemId</code> with <a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will\nretrieve <code>itemId</code>'s or <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>'s. Since <code>itemId</code>'s are an index to the container's\ninternal collection, the <code>itemId</code> is scoped locally to the container -- avoiding\npotential conflicts with Ext.ComponentManager which requires a <strong>unique</strong>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> values.</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({ //\n    <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as Ext.getCmp()\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>, <code>Ext.container.Container.query</code>, <code>Ext.container.Container.down</code> and\n<code>Ext.container.Container.child</code>.</p>\n\n<p><strong>Note</strong>: Valid identifiers start with a letter or underscore and are followed by\n(optional) additional letters, underscores, digits or hyphens.</p>\n\n<p><strong>Note</strong>: to access the container of an item see <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.</p>\n"},"loader":{"!doc":"<p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content\nfor this Component.</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: Ext.getBody()\n});\n</code></pre>\n"},"margin":{"!doc":"<p>Specifies the margin for this component. The margin can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"modelValidation":{"!type":"bool","!doc":"<p>This config enables binding to your <code>Ext.data.Model.validators</code>. This\nis only processed by form fields (e.g., <code><a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a></code>) at present, but\nthis setting is inherited and so can be set on a parent container.</p>\n\n<p>When set to <code>true</code> by a component or not set by a component but inherited from\nan ancestor container, <code>Ext.data.Validation</code> records are used to automatically\nbind validation results for any form field to which a <code>value</code> is bound.</p>\n\n<p>While this config can be set arbitrarily high in the component hierarchy, doing\nso can create a lot overhead if most of your form fields do not actually rely on\n<code>validators</code> in your data model.</p>\n\n<p>Using this setting for a form that is bound to an <code>Ext.data.Model</code> might look\nlike this:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     modelValidation: true,\n     items: [{\n         xtype: 'textfield',\n         bind: '{theUser.firstName}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.lastName}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.phoneNumber}'\n     },{\n         xtype: 'textfield',\n         bind: '{theUser.email}'\n     }]\n }\n</code></pre>\n\n<p>The above is equivalent to the following manual binding of validation:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     items: [{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.firstName}'\n             validation: '{theUser.validation.firstName}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.lastName}'\n             validation: '{theUser.validation.lastName}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.phoneNumber}'\n             validation: '{theUser.validation.phoneNumber}'\n         }\n     },{\n         xtype: 'textfield',\n         bind: {\n             value:      '{theUser.email}'\n             validation: '{theUser.validation.email}'\n         }\n     }]\n }\n</code></pre>\n\n<p>Notice that \"validation\" is a pseudo-association defined for all entities. See\n<code>Ext.data.Model.getValidation</code> for further details.</p>\n"},"overCls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n"},"overflowX":{"!type":"string","!doc":"<p>Possible values are:</p>\n\n<ul>\n<li><code>'auto'</code> to enable automatic horizontal scrollbar (Style overflow-x: 'auto').</li>\n<li><code>'scroll'</code> to always enable horizontal scrollbar (Style overflow-x: 'scroll').</li>\n</ul>\n\n\n<p>The default is overflow-x: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"overflowY":{"!type":"string","!doc":"<p>Possible values are:</p>\n\n<ul>\n<li><code>'auto'</code> to enable automatic vertical scrollbar (Style overflow-y: 'auto').</li>\n<li><code>'scroll'</code> to always enable vertical scrollbar (Style overflow-y: 'scroll').</li>\n</ul>\n\n\n<p>The default is overflow-y: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"padding":{"!doc":"<p>Specifies the padding for this component. The padding can be a single numeric value to apply to all sides or it\ncan be a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"plugins":{"!doc":"<p>An array of plugins to be added to this component. Can also be just a single plugin instead of array.</p>\n\n<p>Plugins provide custom functionality for a component. The only requirement for\na valid plugin is that it contain an <code>init</code> method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. When a component\nis created, if any plugins are available, the component will call the init method on each plugin, passing a\nreference to itself. Each plugin can then call methods or respond to events on the component as needed to provide\nits functionality.</p>\n\n<p>Plugins can be added to component by either directly referencing the plugin instance:</p>\n\n<pre><code>plugins: [Ext.create('<a href=\"#!/api/Ext.grid.plugin.CellEditing\" rel=\"Ext.grid.plugin.CellEditing\" class=\"docClass\">Ext.grid.plugin.CellEditing</a>', {clicksToEdit: 1})],\n</code></pre>\n\n<p>By using config object with ptype:</p>\n\n<pre><code>plugins: [{ptype: 'cellediting', clicksToEdit: 1}],\n</code></pre>\n\n<p>Or with just a ptype:</p>\n\n<pre><code>plugins: ['cellediting', 'gridviewdragdrop'],\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Plugin\" rel=\"Ext.enums.Plugin\" class=\"docClass\">Ext.enums.Plugin</a> for list of all ptypes.</p>\n"},"region":{"!doc":"<p>Defines the region inside <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p>\n\n<p>Possible values:</p>\n\n<ul>\n<li>north - Positions component at top.</li>\n<li>south - Positions component at bottom.</li>\n<li>east - Positions component at right.</li>\n<li>west - Positions component at left.</li>\n<li>center - Positions component at the remaining space.\nThere <strong>must</strong> be a component with <code>region: \"center\"</code> in every border layout.</li>\n</ul>\n\n"},"renderData":{"!doc":"<p>The data used by <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a> in addition to the following property values of the component:</p>\n\n<ul>\n<li>id</li>\n<li>ui</li>\n<li>uiCls</li>\n<li>baseCls</li>\n<li>componentCls</li>\n<li>frame</li>\n</ul>\n\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-renderSelectors\" rel=\"Ext.Component-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a> for usage examples.</p>\n"},"renderSelectors":{"!doc":"<p>An object containing properties specifying CSS selectors which identify child elements\ncreated by the render process.</p>\n\n<p>After the Component's internal structure is rendered according to the <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, this object is iterated through,\nand the found Elements are added as properties to the Component using the <code>renderSelector</code> property name.</p>\n\n<p>For example, a Component which renders a title and description into its element:</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     renderSelectors: {\n         titleEl: 'h1.title',\n         descEl: 'p'\n     },\n     listeners: {\n         afterrender: function(cmp){\n             // After rendering the component will have a titleEl and descEl properties\n             cmp.titleEl.setStyle({color: \"red\"});\n         }\n     }\n });\n</code></pre>\n\n<p>The use of <code>renderSelectors</code> is deprecated (for performance reasons). The above\ncode should be refactored into something like this:</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\" id=\"{id}-titleEl\" data-ref=\"titleEl\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p id=\"{id}-descEl\" data-ref=\"descEl\"&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     childEls: [\n         'titleEl',\n         'descEl'\n     ]\n });\n</code></pre>\n\n<p>To use <code>childEls</code> yet retain the use of selectors (which remains as expensive as\n<code>renderSelectors</code>):</p>\n\n<pre><code> Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n     renderTo: Ext.getBody(),\n     renderTpl: [\n         '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n         '&lt;p&gt;{desc}&lt;/p&gt;'\n     ],\n     renderData: {\n         title: \"Error\",\n         desc: \"Something went wrong\"\n     },\n     childEls: {\n         titleEl: { selectNode: 'h1.title' },\n         descEl: { selectNode: 'p' }\n     }\n });\n</code></pre>\n"},"renderTo":{"!doc":"<p>Specify the <code>id</code> of the element, a DOM element or an existing Element that this component will be rendered into.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>Do <em>not</em> use this option if the Component is to be a child item of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>.\nIt is the responsibility of the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>'s\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout manager</a> to render and manage its child items.</p>\n\n<p>When using this config, a call to <code>render()</code> is not required.</p>\n\n<p>See also: <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n"},"resizeHandles":{"!type":"string","!doc":"<p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n"},"rtl":{"!type":"bool","!doc":"<p>True to layout this component and its descendants in \"rtl\" (right-to-left) mode.\nCan be explicitly set to false to override a true value inherited from an ancestor.</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0 (or <code>false</code>): Neither width nor height depend on content.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2 (default): Height depends on content (shrink wraps), but width does not.</li>\n<li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"style":{"!doc":"<p>A custom style specification to be applied to this component's Element. Should be a valid argument to\nExt.dom.Element.applyStyles.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Some Title',\n    renderTo: Ext.getBody(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n    new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>({\n        text: 'Send',\n        minWidth: '100',\n        style: {\n            marginBottom: '10px'\n        }\n    })\n    ]\n});\n</code></pre>\n"},"toFrontOnShow":{"!type":"bool","!doc":"<p>True to automatically call <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> when the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method is called on an already visible,\nfloating component.</p>\n"},"tpl":{"!doc":"<p>An Ext.Template, Ext.XTemplate or an array of strings to form an Ext.XTemplate. Used in\nconjunction with the <code><a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-tplWriteMode\" rel=\"Ext.Component-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n"},"tplWriteMode":{"!type":"string","!doc":"<p>The Ext.(X)Template method to use when updating the content area of the Component.\nSee <code>Ext.XTemplate.overwrite</code> for information on default mode.</p>\n"},"ui":{"!type":"string","!doc":"<p>A UI style for a component.</p>\n"},"uiCls":{"!doc":"<p>An array of of <code>classNames</code> which are currently applied to this component.</p>\n"},"weight":{"!type":"number","!doc":"<p>A value to control how Components are laid out in a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border</a> layout or as docked items.</p>\n\n<p>In a Border layout, this can control how the regions (not the center) region lay out if the west or east take full height\nor if the north or south region take full width. Also look at the <a href=\"#!/api/Ext.layout.container.Border-cfg-regionWeights\" rel=\"Ext.layout.container.Border-cfg-regionWeights\" class=\"docClass\">Ext.layout.container.Border.regionWeights</a> on the Border layout. An example to show how you can\ntake control of this is:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>', {\n    layout      : 'border',\n    defaultType : 'panel',\n    items       : [\n        {\n            region : 'north',\n            title  : 'North',\n            height : 100\n        },\n        {\n            region : 'south',\n            title  : 'South',\n            height : 100,\n            weight : -25\n        },\n        {\n            region : 'west',\n            title  : 'West',\n            width  : 200,\n            weight : 15\n        },\n        {\n            region : 'east',\n            title  : 'East',\n            width  : 200\n        },\n        {\n            region : 'center',\n            title  : 'center'\n        }\n    ]\n});\n</code></pre>\n\n<p>If docked items, the weight will order how the items are laid out. Here is an example to put a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a> above\na <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>'s header:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    renderTo    : document.body,\n    width       : 300,\n    height      : 300,\n    title       : 'Panel',\n    html        : 'Panel Body',\n    dockedItems : [\n        {\n            xtype : 'toolbar',\n            items : [\n                {\n                    text : 'Save'\n                }\n            ]\n        },\n        {\n            xtype  : 'toolbar',\n            weight : -10,\n            items  : [\n                {\n                    text : 'Remove'\n                }\n            ]\n        }\n    ]\n});\n</code></pre>\n"},"width":{"!type":"number","!doc":"<p>The width of this component in pixels.</p>\n"},"xtype":{"!doc":"<p>This property provides a shorter alternative to creating objects than using a full\nclass name. Using <code>xtype</code> is the most common way to define component instances,\nespecially in a container. For example, the items in a form containing text fields\ncould be created explicitly like so:</p>\n\n<pre><code> items: [\n     Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Foo'\n     }),\n     Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Bar'\n     }),\n     Ext.create('<a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>', {\n         fieldLabel: 'Num'\n     })\n ]\n</code></pre>\n\n<p>But by using <code>xtype</code>, the above becomes:</p>\n\n<pre><code> items: [\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Foo'\n     },\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Bar'\n     },\n     {\n         xtype: 'numberfield',\n         fieldLabel: 'Num'\n     }\n ]\n</code></pre>\n\n<p>When the <code>xtype</code> is common to many items, <a href=\"#!/api/Ext.container.Container-cfg-defaultType\" rel=\"Ext.container.Container-cfg-defaultType\" class=\"docClass\">Ext.container.Container.defaultType</a>\nis another way to specify the <code>xtype</code> for all items that don't have an explicit <code>xtype</code>:</p>\n\n<pre><code> defaultType: 'textfield',\n items: [\n     { fieldLabel: 'Foo' },\n     { fieldLabel: 'Bar' },\n     { fieldLabel: 'Num', xtype: 'numberfield' }\n ]\n</code></pre>\n\n<p>Each member of the <code>items</code> array is now just a \"configuration object\". These objects\nare used to create and configure component instances. A configuration object can be\nmanually used to instantiate a component using Ext.widget:</p>\n\n<pre><code> var text1 = Ext.create('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n     fieldLabel: 'Foo'\n });\n\n // or alternatively:\n\n var text1 = Ext.widget({\n     xtype: 'textfield',\n     fieldLabel: 'Foo'\n });\n</code></pre>\n\n<p>This conversion of configuration objects into instantiated components is done when\na container is created as part of its {Ext.container.AbstractContainer#initComponent}\nprocess. As part of the same process, the <code>items</code> array is converted from its raw\narray form into a Ext.util.MixedCollection instance.</p>\n\n<p>You can define your own <code>xtype</code> on a custom <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">component</a> by specifying\nthe <code>xtype</code> property in Ext.define. For example:</p>\n\n<pre><code>Ext.define('MyApp.PressMeButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'pressmebutton',\n    text: 'Press Me'\n});\n</code></pre>\n\n<p>Care should be taken when naming an <code>xtype</code> in a custom component because there is\na single, shared scope for all xtypes. Third part components should consider using\na prefix to avoid collisions.</p>\n\n<pre><code>Ext.define('Foo.form.CoolButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'ux-coolbutton',\n    text: 'Cool!'\n});\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Widget\" rel=\"Ext.enums.Widget\" class=\"docClass\">Ext.enums.Widget</a> for list of all available xtypes.</p>\n"},"$configPrefixed":{"!type":"bool","!doc":"<p>We do not want \"_hidden\" style backing properties.</p>\n"},"$configStrict":{"!type":"bool","!doc":"<p>We also want non-config system properties to go to the instance.</p>\n"},"_asLayoutRoot":{},"_isLayoutRoot":{"!type":"bool","!doc":"<p>Setting this property to <code>true</code> causes the <a href=\"#!/api/Ext.Component-method-isLayoutRoot\" rel=\"Ext.Component-method-isLayoutRoot\" class=\"docClass\">isLayoutRoot</a> method to return\n<code>true</code> and stop the search for the top-most component for a layout.</p>\n"},"allowDomMove":{"!type":"bool","!doc":"<p>private</p>\n"},"autoGenId":{"!type":"bool","!doc":"<p><code>true</code> indicates an <code>id</code> was auto-generated rather than provided by configuration.</p>\n"},"borderBoxCls":{"!type":"string","!doc":"<p>private</p>\n"},"componentLayoutCounter":{"!type":"number","!doc":"<p>The number of component layout calls made on this object.</p>\n"},"deferLayouts":{"!type":"bool","!doc":"<p>private</p>\n"},"deprecated":{"!doc":"<p>private</p>\n"},"disabledRe":{"!doc":"<p>http://www.w3.org/TR/html5/disabled-elements.html</p>\n"},"floatParent":{"!doc":"<p><strong>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers.</strong></p>\n\n<p>There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>floatParent</code>\nproperty.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"frameSize":{"!doc":"<p>Indicates the width of any framing elements which were added within the encapsulating\nelement to provide graphical, rounded borders. See the <a href=\"#!/api/Ext.Component-cfg-frame\" rel=\"Ext.Component-cfg-frame\" class=\"docClass\">frame</a> config. This\nproperty is <code>null</code> if the component is not framed.</p>\n\n<p>This is an object containing the frame width in pixels for all four sides of the\nComponent containing the following properties:</p>\n"},"horizontalPosProp":{"!type":"string","!doc":"<p>private</p>\n"},"isComponent":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Component, or subclass thereof.</p>\n"},"layoutSuspendCount":{"!type":"number","!doc":"<p>private</p>\n"},"liquidLayout":{"!type":"bool","!doc":"<p>Components that achieve their internal layout results using solely CSS with no JS\nintervention must set this to true.  Failure to set this property to true may result\nin setSize failing to work if the component opted out of the layout run.</p>\n"},"maskOnDisable":{"!type":"bool","!doc":"<p>This is an internal flag that you use when creating custom components. By default this is set to <code>true</code> which means\nthat every component gets a mask when it's disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to <code>false</code> since they want to implement custom disable logic.</p>\n"},"nonMaskableRe":{},"offsetsCls":{"!type":"string","!doc":"<p>private</p>\n"},"ownerCt":{"!doc":"<p>This Component's owner <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> (is set automatically\nwhen this Component is added to a Container).</p>\n\n<p><em>Important.</em> This is not a universal upwards navigation pointer. It indicates the Container which owns and manages\nthis Component if any. There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p><strong>Note</strong>: to access items within the Container see <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"rendered":{"!type":"bool","!doc":"<p>Indicates whether or not the component has been rendered.</p>\n"},"rootCls":{"!type":"string","!doc":"<p>private</p>\n"},"scrollFlags":{"!doc":"<p>An object property which provides unified information as to which dimensions are scrollable based upon\nthe <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> settings (And for <em>views</em> of trees and grids, the owning panel's <a href=\"#!/api/Ext.panel.Table-cfg-scroll\" rel=\"Ext.panel.Table-cfg-scroll\" class=\"docClass\">scroll</a> setting).</p>\n\n<p>Note that if you set overflow styles using the <a href=\"#!/api/Ext.Component-cfg-style\" rel=\"Ext.Component-cfg-style\" class=\"docClass\">style</a> config or <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config, this object does not include that information;\nit is best to use <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> if you need to access these flags.</p>\n\n<p>This object has the following properties:</p>\n"},"scrollerCls":{"!type":"string","!doc":"<p>private</p>\n"},"scrollerSelector":{"!type":"string"},"synthetic":{"!type":"bool","!doc":"<p>This property is <code>true</code> if the component was created internally by the framework\nand is not explicitly user-defined. This is set for such things as <code>Splitter</code>\ninstances managed by <code>border</code> and <code>box</code> layouts.</p>\n"},"validIdRe":{},"zIndexManager":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components after they have been rendered.</p>\n\n<p>A reference to the ZIndexManager which is managing this Component's z-index.</p>\n\n<p>The <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> maintains a stack of floating Component z-indices, and also provides\na single modal mask which is insert just beneath the topmost visible modal floating Component.</p>\n\n<p>Floating Components may be <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">brought to the front</a> or <a href=\"#!/api/Ext.Component-method-toBack\" rel=\"Ext.Component-method-toBack\" class=\"docClass\">sent to the back</a> of the\nz-index stack.</p>\n\n<p>This defaults to the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> for floating Components that are\nprogramatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a>.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are added to a Container, the ZIndexManager is acquired from the first\nancestor Container found which is floating. If no floating ancestor is found, the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> is\nused.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexParent\" rel=\"Ext.Component-property-zIndexParent\" class=\"docClass\">zIndexParent</a></p>\n"},"zIndexParent":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers, and which have a floating\nContainer in their containment ancestry.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are child items of a Container, the zIndexParent will be a floating\nancestor Container which is responsible for the base z-index value of all its floating descendants. It provides\na <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which provides z-indexing services for all its descendant floating\nComponents.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>zIndexParent</code>\nproperty.</p>\n\n<p>For example, the dropdown <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">BoundList</a> of a ComboBox which is in a Window will have the\nWindow as its <code>zIndexParent</code>, and will always show above that Window, wherever the Window is placed in the z-index stack.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"addClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addClsWithUI":{"!type":"fn(classes: ?, skip?: ?) -> !this","!doc":"<p>Adds a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.Component-method-addUIClsToElement\" rel=\"Ext.Component-method-addUIClsToElement\" class=\"docClass\">addUIClsToElement</a> and adds to all elements of this\ncomponent.</p>\n"},"addFocusListener":{"!type":"fn() -> !this","!doc":"<p>Sets up the focus listener on this Component's <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a> if it has one.</p>\n\n<p>Form Components which must implicitly participate in tabbing order usually have a naturally focusable\nelement as their <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a>, and it is the DOM event of that receiving focus which drives\nthe Component's <code>onFocus</code> handling, and the DOM event of it being blurred which drives the <code>onBlur</code> handling.</p>\n\n<p>If the <a href=\"#!/api/Ext.Component-method-getFocusEl\" rel=\"Ext.Component-method-getFocusEl\" class=\"docClass\">focusEl</a> is <strong>not</strong> naturally focusable, then the listeners are only added\nif the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is enabled.</p>\n"},"addListener":{"!type":"fn(element: ?, listeners: ?, scope: ?, options: ?) -> !this"},"addPlugin":{"!type":"fn(plugin: ?) -> !this","!doc":"<p>Adds a plugin. May be called at any time in the component's lifecycle.</p>\n"},"addPropertyToState":{"!type":"fn(state: ?, propName: ?, value?: ?) -> bool","!doc":"<p>Save a property to the given state object if it is not its default or configured\nvalue.</p>\n"},"addUIToElement":{"!type":"fn() -> !this","!doc":"<p>Method which adds a specified UI to the components element.</p>\n"},"adjustPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>private</p>\n"},"afterSetPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Template method called after a Component has been positioned.</p>\n"},"afterShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component is shown (after <a href=\"#!/api/Ext.Component-method-onShow\" rel=\"Ext.Component-method-onShow\" class=\"docClass\">onShow</a> is called).</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-event-show\" rel=\"Ext.Component-event-show\" class=\"docClass\">show</a>.</p>\n"},"animate":{"!type":"fn(animObj: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the Sprite\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = Ext.create('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margin: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margin: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"},"applyData":{"!type":"fn(data: ?) -> !this"},"beforeBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-blur processing.</p>\n"},"beforeComponentLayout":{"!type":"fn(adjWidth: ?, adjHeight: ?) -> !this","!doc":"<p>Occurs before <code>componentLayout</code> is run. Returning <code>false</code> from this method will prevent the <code>componentLayout</code> from\nbeing executed.</p>\n"},"beforeFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-focus processing.</p>\n"},"beforeInitConfig":{"!type":"fn() -> !this"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeSetPosition":{"!type":"fn(x: ?, y: ?, animate: ?) -> !this","!doc":"<p>Template method called before a Component is positioned.</p>\n\n<p>Ensures that the position is adjusted so that the Component is constrained if so configured.</p>\n"},"beforeShow":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is shown.</p>\n"},"bubble":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Bubbles up the component/container hierarchy, calling the specified function with each component. The scope\n(<em>this</em>) of function call will be the scope provided or the current component. The arguments to the function will\nbe the args provided or the current component. If the function returns false at any point, the bubble is stopped.</p>\n"},"cancelFocus":{"!type":"fn() -> !this","!doc":"<p>Cancel any deferred focus on this component</p>\n"},"cloneConfig":{"!type":"fn(overrides: ?) -> ?","!doc":"<p>Clone the current component using the original config values passed into this instance by default.</p>\n"},"constructPlugin":{"!type":"fn(ptype: ?) -> !this"},"constructPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of fully constructed plugin instances. This converts any configs into their\nappropriate instances.</p>\n\n<p>It does not mutate the plugins array. It creates a new array.</p>\n"},"destroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is <a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>ed.</p>\n"},"doComponentLayout":{"!type":"fn() -> ?","!doc":"<p>This method needs to be called whenever you change something on this component that\nrequires the Component's layout to be recalculated.</p>\n"},"findComponentByElement":{"!type":"fn(node: ?) -> !this","!doc":"<p>Walk the DOM tree upwards and find the Component these elements belong to.</p>\n"},"findParentBy":{"!type":"fn(fn: ?) -> ?","!doc":"<p>Find a container above this component at any level by a custom function. If the passed function returns true, the\ncontainer will be returned.</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findParentByType":{"!type":"fn(xtype: ?) -> ?","!doc":"<p>Find a container above this component at any level by xtype or class</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findPlugin":{"!type":"fn(ptype: ?) -> ?","!doc":"<p>Retrieves plugin from this component's collection by its <code>ptype</code>.</p>\n"},"fireHierarchyEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>This method fires an event on <code>Ext.GlobalEvents</code> allowing interested parties to know\nof certain critical events for this component. This is done globally because the\n(few) listeners can immediately receive the event rather than bubbling the event\nonly to reach the top and have no listeners.</p>\n\n<p>The main usage for these events is to do with floating components. For example, the\nload mask is a floating component. The component it is masking may be inside several\ncontainers. As such, they need to know when component is hidden, either directly, or\nvia a parent container being hidden. To do this they subscribe to these events and\nfilter out the appropriate container.</p>\n\n<p>This functionality is contained in Component (as opposed to Container) because a\nComponent can be the ownerCt for a floating component (loadmask), and the loadmask\nneeds to know when its owner is shown/hidden so that its hidden state can be\nsynchronized.</p>\n"},"focus":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component receives focus.</p>\n"},"forceComponentLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"getActiveComponent":{"!type":"fn() -> ?","!doc":"<p>Return the currently active (focused) Component</p>\n"},"getAnchorToXY":{"!type":"fn(el: ?, anchor: ?, local: ?, mySize: ?) -> !this","!doc":"<p><editor-fold desc=\"Positionable Methods\"></editor></p>\n\n<hr />\n\n<p> Begin Positionable methods</p>\n\n<hr />\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getAnimateTarget":{"!type":"fn(target: ?) -> !this"},"getAutoId":{"!type":"fn() -> !this"},"getBorderPadding":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getBubbleTarget":{"!type":"fn() -> !this","!doc":"<p>Implements an upward event bubbling policy. By default a Component bubbles events up to its reference owner.</p>\n\n<p>Component subclasses may implement a different bubbling strategy by overriding this method.</p>\n"},"getComponentByElement":{"!type":"fn(el: ?) -> ?","!doc":"<p>Find a Component that the given Element belongs to.</p>\n"},"getComponentLayout":{"!type":"fn() -> !this"},"getData":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a>.</p>\n"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Retrieves the top level element representing this component.</p>\n"},"getHeight":{"!type":"fn() -> number","!doc":"<p>Gets the current height of the component's underlying element.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Retrieves the <code>id</code> of this component. Will auto-generate an <code>id</code> if one has not already been set.</p>\n"},"getItemId":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a> assigned to this component, or when that\nis not set, returns the value of <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getLoader":{"!type":"fn() -> ?","!doc":"<p>Gets the <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> for this Component.</p>\n"},"getLocalX":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getLocalXY":{"!type":"fn() -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"getLocalY":{"!type":"fn() -> !this"},"getMaskTarget":{"!type":"fn() -> !this","!doc":"<p>Returns the element which is masked by the <a href=\"#!/api/Ext.Component-method-mask\" rel=\"Ext.Component-method-mask\" class=\"docClass\">mask</a> method, or into which the <a href=\"#!/api/Ext.Component-method-setLoading\" rel=\"Ext.Component-method-setLoading\" class=\"docClass\">LoadMask</a> is rendered into.</p>\n\n<p>The default implementation uses the <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a> configuration to access the Component's child element by name. By default, <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>\nis <code>null</code> which means that <code>null</code> is returned from this method indicating that the mask needs to be rendered into the document because\ncomponent structure should not be contaminated by mask elements.</p>\n\n<p>Some subclasses may override this method if they have knowledge about external structures where a mask could usefully be rendered.</p>\n\n<p>For example a <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">GridView</a> will request that its owning <a href=\"#!/api/Ext.panel.Table\" rel=\"Ext.panel.Table\" class=\"docClass\">GridPanel</a> be masked. The\nGridPanel will have its own implementation of <code>getMaskTarget</code> which will return the element dicated by its own <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>\nPanels use <code>\"el\"</code> as their <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a> by default, but that could be overridden to be <code>\"body\"</code> to leave toolbars and the header\nmouse-accessible.</p>\n"},"getOverflowEl":{"!type":"fn() -> !this","!doc":"<p>Get an el for overflowing, defaults to the target el</p>\n"},"getOverflowStyle":{"!type":"fn() -> !this","!doc":"<p>Returns the CSS style object which will set the Component's scroll styles. This must be applied\nto the <a href=\"#!/api/Ext.Component-method-getTargetEl\" rel=\"Ext.Component-method-getTargetEl\" class=\"docClass\">target element</a>.</p>\n"},"getOwningBorderContainer":{"!type":"fn() -> ?","!doc":"<p>Returns the owning container if that container uses <code>border</code> layout. Otherwise\nthis method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getOwningBorderLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the owning <code>border</code> (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>) instance if there is\none. Otherwise this method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getPlugin":{"!type":"fn(pluginId: ?) -> ?","!doc":"<p>Retrieves a plugin from this component's collection by its <code>pluginId</code>.</p>\n"},"getPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of current fully constructed plugin instances.</p>\n"},"getPosition":{"!type":"fn(local?: ?) -> ?","!doc":"<p>Gets the current XY position of the component's underlying element.</p>\n"},"getScrollX":{"!type":"fn() -> number","!doc":"<p>Returns the \"x\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code>.</p>\n"},"getScrollY":{"!type":"fn() -> number","!doc":"<p>Returns the \"y\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"getSize":{"!type":"fn(contentSize?: ?) -> ?","!doc":"<p>Gets the current size of the component's underlying element.</p>\n"},"getSizeModel":{"!type":"fn(ownerCtSizeModel: ?) -> ?","!doc":"<p>Returns an object that describes how this component's width and height are managed.\nAll of these objects are shared and should not be modified.</p>\n"},"getTargetEl":{"!type":"fn() -> !this","!doc":"<p>This is used to determine where to insert the 'html', 'contentEl' and 'items' in this component.</p>\n"},"getTdCls":{"!type":"fn() -> !this","!doc":"<p>Needed for when widget is rendered into a grid cell. The class to add to the cell element.</p>\n"},"getTdType":{"!type":"fn() -> !this","!doc":"<p>Partner method to <a href=\"#!/api/Ext.Component-method-getTdCls\" rel=\"Ext.Component-method-getTdCls\" class=\"docClass\">getTdCls</a>.</p>\n\n<p>Returns the base type for the component. Defaults to return <code>this.xtype</code>, but\nAll derived classes of <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">TextField</a> can return the type 'textfield',\nand all derived classes of <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Button</a> can return the type 'button'</p>\n"},"getTpl":{"!type":"fn(name: ?) -> !this"},"getWidth":{"!type":"fn() -> number","!doc":"<p>Gets the current width of the component's underlying element.</p>\n"},"getX":{"!type":"fn() -> !this"},"getXType":{"!type":"fn() -> string","!doc":"<p>Gets the xtype for this component as registered with Ext.ComponentManager. For a list of all available\nxtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n"},"getXTypes":{"!type":"fn() -> string","!doc":"<p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all available xtypes, see the\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXTypes());  // alerts 'component/field/textfield'\n</code></pre>\n"},"getXY":{"!type":"fn() -> !this"},"getY":{"!type":"fn() -> !this"},"hasCls":{"!type":"fn(className: ?) -> bool","!doc":"<p>Checks if the specified CSS class exists on this element's DOM node.</p>\n"},"hasUICls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Checks if there is currently a specified <code>uiCls</code>.</p>\n"},"initBorderRegion":{"!type":"fn() -> !this","!doc":"<p>This method is called by the <code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class when instances are\nadded as regions to the layout. Since it is valid to add any component to a border\nlayout as a region, this method must be added to <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code> but is only ever\ncalled when that component is owned by a <code>border</code> layout.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"initEvents":{"!type":"fn() -> !this","!doc":"<p>Initialize any events on this component</p>\n"},"initPadding":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Initializes padding by applying it to the target element, or if the layout manages\npadding ensures that the padding on the target element is \"0\".</p>\n"},"initStyles":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Applies padding, margin, border, top, left, height, and width configs to the\nappropriate elements.</p>\n"},"is":{"!type":"fn(selector: ?) -> bool","!doc":"<p>Tests whether this Component matches a ComponentQuery\nselector string.</p>\n"},"isDescendantOf":{"!type":"fn(container: ?) -> bool","!doc":"<p>Determines whether this component is the descendant of a particular container.</p>\n"},"isDisabled":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently disabled.</p>\n"},"isDraggable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is draggable.</p>\n"},"isDroppable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is droppable.</p>\n"},"isFloating":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is floating.</p>\n"},"isFocusable":{"!type":"fn() -> !this"},"isHidden":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently set to hidden.</p>\n"},"isHierarchicallyHidden":{"!type":"fn() -> !this"},"isLayoutSuspended":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if layout is suspended for this component. This can come from direct\nsuspension of this component's layout activity (<a href=\"#!/api/Ext.container.Container-cfg-suspendLayout\" rel=\"Ext.container.Container-cfg-suspendLayout\" class=\"docClass\">Ext.Container.suspendLayout</a>) or if one\nof this component's containers is suspended.</p>\n"},"isLocalRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's local coordinate system is rtl. For normal\ncomponents this equates to the value of isParentRtl().  Floaters are a bit different\nbecause a floater's element can be a childNode of something other than its\nparent component's element.  For floaters we have to read the dom to see if the\ncomponent's element's parentNode has a css direction value of \"rtl\".</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isOppositeRootDirection":{"!type":"fn() -> !this","!doc":"<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isParentRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's parent container is rtl. Used by rtl positioning\nmethods to determine if the component should be positioned using a right-to-left\ncoordinate system.</p>\n\n<p><strong>Defined in override Ext.rtl.Component.</strong></p>\n"},"isXType":{"!type":"fn(xtype: ?, shallow?: ?) -> bool","!doc":"<p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (<code>shallow = true</code>).</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('field');       // true, descended from <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nvar isBoxInstance = t.isXType('field', true); // false, not a direct <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> instance\n</code></pre>\n"},"mask":{"!type":"fn(msg?: ?, msgCls?: ?) -> !this","!doc":"<p>Masks this component with a semi-opaque layer and makes the contents unavailable to clicks.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-method-unmask\" rel=\"Ext.Component-method-unmask\" class=\"docClass\">unmask</a>.</p>\n"},"nextNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree to attempt to find a match. Contrast with <a href=\"#!/api/Ext.Component-method-nextSibling\" rel=\"Ext.Component-method-nextSibling\" class=\"docClass\">nextSibling</a>.</p>\n"},"nextSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next sibling of this Component.</p>\n\n<p>Optionally selects the next sibling which matches the passed ComponentQuery selector.</p>\n\n<p>May also be referred to as <strong><code>next()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.Component-method-nextNode\" rel=\"Ext.Component-method-nextNode\" class=\"docClass\">nextNode</a></p>\n"},"onBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onDisable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the disable operation.\nAfter calling the superclass's <code>onDisable</code>, the Component will be disabled.</p>\n"},"onEnable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the enable operation.\nAfter calling the superclass's <code>onEnable</code>, the Component will be enabled.</p>\n"},"onShowComplete":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> method is complete.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> received.</p>\n"},"onShowVeto":{"!type":"fn() -> !this"},"owns":{"!type":"fn(element: ?) -> !this","!doc":"<p>Returns <code>true</code> if the passed element is within the container tree of this component.</p>\n\n<p>For example if a menu's submenu contains an <a href=\"#!/api/Ext.form.field.Date\" rel=\"Ext.form.field.Date\" class=\"docClass\">Ext.form.field.Date</a>, that top level\nmenu owns the elements of the date picker. Using this method, you can tell if an event took place\nwithin a certain component tree.</p>\n"},"postBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any post-blur processing.</p>\n"},"previousNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree in reverse order to attempt to find a match. Contrast with <a href=\"#!/api/Ext.Component-method-previousSibling\" rel=\"Ext.Component-method-previousSibling\" class=\"docClass\">previousSibling</a>.</p>\n"},"previousSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous sibling of this Component.</p>\n\n<p>Optionally selects the previous sibling which matches the passed ComponentQuery\nselector.</p>\n\n<p>May also be referred to as <strong><code>prev()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.Component-method-previousNode\" rel=\"Ext.Component-method-previousNode\" class=\"docClass\">previousNode</a></p>\n"},"refreshScroll":{"!type":"fn() -> !this","!doc":"<p>Implementation which updates the scroll range of a touch scroller.\nSubclasses may change implementation.</p>\n"},"registerFloatingItem":{"!type":"fn(cmp: ?) -> !this","!doc":"<p>Called by Component#doAutoRender</p>\n\n<p>Register a Container configured <code>floating: true</code> with this Component's <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Components added in this way will not participate in any layout, but will be rendered\nupon first show in the way that <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s are.</p>\n"},"removeClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeClsWithUI":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Removes a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.Component-method-removeUIClsFromElement\" rel=\"Ext.Component-method-removeUIClsFromElement\" class=\"docClass\">removeUIClsFromElement</a> and removes it from all\nelements of this component.</p>\n"},"removeUIFromElement":{"!type":"fn() -> !this","!doc":"<p>Method which removes a specified UI from the components element.</p>\n"},"resumeLayouts":{"!type":"fn(flushOptions: ?) -> !this"},"scrollBy":{"!type":"fn(deltaX: ?, deltaY: ?, animate: ?) -> !this","!doc":"<p>Scrolls this Component by the passed delta values, optionally animating.</p>\n\n<p>All of the following are equivalent:</p>\n\n<pre><code> comp.scrollBy(10, 10, true);\n comp.scrollBy([10, 10], true);\n comp.scrollBy({ x: 10, y: 10 }, true);\n</code></pre>\n"},"scrollTo":{"!type":"fn(x: ?, y: ?, animate?: ?) -> !this","!doc":"<p>Scrolls this component to the specified <code>x</code> and <code>y</code> coordinates.  Only applicable\nfor components that have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or\n<code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"setAutoScroll":{"!type":"fn(scroll: ?) -> ?","!doc":"<p>Sets the overflow on the content element of the component.</p>\n"},"setData":{"!type":"fn(data: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a>.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Enable or disable the component.</p>\n"},"setDock":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setDocked":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setFlex":{"!type":"fn(flex: ?) -> !this","!doc":"<p>Sets the flex property of this component. Only applicable when this component is\nan item of a box layout</p>\n"},"setHeight":{"!type":"fn(height: ?) -> ?","!doc":"<p>Sets the height of the component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setHidden":{"!type":"fn(hidden: ?) -> ?","!doc":"<p>Sets the hidden state of this component. This is basically the same as\n<code><a href=\"#!/api/Ext.Component-method-setVisible\" rel=\"Ext.Component-method-setVisible\" class=\"docClass\">setVisible</a></code> but the boolean parameter has the opposite meaning.</p>\n"},"setHtml":{"!type":"fn(html: ?) -> !this"},"setLoading":{"!type":"fn(load: ?) -> ?","!doc":"<p>This method allows you to show or hide a LoadMask on top of this component.</p>\n\n<p>The mask will be rendered into the element returned by <a href=\"#!/api/Ext.Component-method-getMaskTarget\" rel=\"Ext.Component-method-getMaskTarget\" class=\"docClass\">getMaskTarget</a> which for most Components is the Component's\nelement. See <a href=\"#!/api/Ext.Component-method-getMaskTarget\" rel=\"Ext.Component-method-getMaskTarget\" class=\"docClass\">getMaskTarget</a> and <a href=\"#!/api/Ext.Component-cfg-maskElement\" rel=\"Ext.Component-cfg-maskElement\" class=\"docClass\">maskElement</a>.</p>\n\n<p>Most Components will return <code>null</code> indicating that their LoadMask cannot reside inside their element, but must\nbe rendered into the document body.</p>\n\n<p><a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Grid Views</a> however will direct a LoadMask to be rendered into the owning <a href=\"#!/api/Ext.panel.Table\" rel=\"Ext.panel.Table\" class=\"docClass\">GridPanel</a>.</p>\n"},"setLocalX":{"!type":"fn(x: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"setLocalXY":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"setLocalY":{"!type":"fn(y: ?) -> !this"},"setMargin":{"!type":"fn(margin: ?) -> !this","!doc":"<p>Sets the margin on the target element.</p>\n"},"setOverflowXY":{"!type":"fn(overflowX: ?, overflowY: ?) -> ?","!doc":"<p>Sets the overflow x/y on the content element of the component. The x/y overflow\nvalues can be any valid CSS overflow (e.g., 'auto' or 'scroll'). By default, the\nvalue is 'hidden'. Passing null for one of the values will erase the inline style.\nPassing <code>undefined</code> will preserve the current value.</p>\n"},"setPagePosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the page XY position of the component. To set the left and top instead, use <a href=\"#!/api/Ext.Component-method-setPosition\" rel=\"Ext.Component-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setPosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the left and top of the component. To set the page XY position instead, use <a href=\"#!/api/Ext.Component-method-setPagePosition\" rel=\"Ext.Component-method-setPagePosition\" class=\"docClass\">setPagePosition</a>. This\nmethod fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setRegion":{"!type":"fn(region: ?) -> string","!doc":"<p>This method changes the <code>region</code> config property for this border region. This is\nonly valid if this component is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setScrollX":{"!type":"fn(x: ?) -> !this","!doc":"<p>Sets the \"x\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a></code>.</p>\n"},"setScrollY":{"!type":"fn(y: ?) -> !this","!doc":"<p>Sets the \"y\" scroll position for this component.  Only applicable for components\nthat have been configured with <code><a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a></code>.</p>\n"},"setSize":{"!type":"fn(width: ?, height: ?) -> ?","!doc":"<p>Sets the width and height of this Component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n"},"setStyle":{"!type":"fn(style: ?) -> !this","!doc":"<p>Sets the stlye for this Component's primary element.</p>\n"},"setVisible":{"!type":"fn(visible: ?) -> ?","!doc":"<p>Convenience function to hide or show this component by Boolean.</p>\n"},"setWeight":{"!type":"fn(weight: ?) -> number","!doc":"<p>Sets the <code>weight</code> config property for this component. This is only valid if this\ncomponent is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setWidth":{"!type":"fn(width: ?) -> ?","!doc":"<p>Sets the width of the component. This method fires the <a href=\"#!/api/Ext.Component-event-resize\" rel=\"Ext.Component-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setX":{"!type":"fn(x: ?, animate: ?) -> !this"},"setXY":{"!type":"fn(xy: ?, animate: ?) -> !this"},"setY":{"!type":"fn(y: ?, animate: ?) -> !this"},"showAt":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Displays component at specific xy position.\nA floating component (like a menu) is positioned relative to its ownerCt if any.\nUseful for popping up a context menu:</p>\n\n<pre><code>listeners: {\n    itemcontextmenu: function(view, record, item, index, event, options) {\n        Ext.create('<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>', {\n            width: 100,\n            height: 100,\n            margin: '0 0 10 0',\n            items: [{\n                text: 'regular item 1'\n            },{\n                text: 'regular item 2'\n            },{\n                text: 'regular item 3'\n            }]\n        }).showAt(event.getXY());\n    }\n}\n</code></pre>\n"},"showBy":{"!type":"fn(component: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Shows this component by the specified <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> or Element.\nUsed when this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a>.</p>\n"},"suspendLayouts":{"!type":"fn() -> !this"},"unitizeBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"unmask":{"!type":"fn() -> !this","!doc":"<p>Removes the mask applied by <a href=\"#!/api/Ext.Component-method-mask\" rel=\"Ext.Component-method-mask\" class=\"docClass\">mask</a></p>\n"},"unregisterFloatingItem":{"!type":"fn(cmp: ?) -> !this"},"up":{"!type":"fn(selector?: ?, limit?: ?) -> ?","!doc":"<p>Navigates up the ownership hierarchy searching for an ancestor Container which matches any passed selector or component.</p>\n\n<p><em>Important.</em> There is not a universal upwards navigation pointer. There are several upwards relationships\nsuch as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by this method.</p>\n\n<p>Example:</p>\n\n<pre><code>var owningTabPanel = grid.up('tabpanel');\n</code></pre>\n"},"update":{"!type":"fn(htmlOrData: ?, loadScripts?: ?, callback?: ?) -> !this","!doc":"<p>Update the content area of a component.</p>\n"},"updateBox":{"!type":"fn(box: ?) -> ?","!doc":"<p>Sets the current box measurements of the component's underlying element.</p>\n"},"updateLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"added":{"!type":"fn(this: ?, container: ?, pos: ?, eOpts: ?)","!doc":"<p>Fires after a Component had been added to a Container.</p>\n"},"afterrender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component rendering is finished.</p>\n\n<p>The <code>afterrender</code> event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocessed by any\n<code>afterRender</code> method defined for the Component.</p>\n"},"beforeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually activated. Returning <code>false</code> from an event listener can prevent\nthe activate from occurring.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout.</p>\n"},"beforedeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually deactivated. Returning <code>false</code> from an event listener can\nprevent the deactivate from occurring.</p>\n\n<p><strong>Note</strong> This event is only fired if this Component is a child of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as it's layout.</p>\n"},"beforedestroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>ed. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a>.</p>\n"},"beforehide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method. Return <code>false</code> from an event\nhandler to stop the hide.</p>\n"},"beforerender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n"},"beforeshow":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method. Return <code>false</code> from an event\nhandler to stop the show.</p>\n"},"blur":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component loses focus.</p>\n"},"boxready":{"!type":"fn(this: ?, width: ?, height: ?, eOpts: ?)","!doc":"<p>Fires <em>one time</em> - after the component has been laid out for the first time at its initial size.</p>\n"},"disable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is disabled.</p>\n"},"enable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is enabled.</p>\n"},"hide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is hidden. Fires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>\nmethod.</p>\n"},"removed":{"!type":"fn(this: ?, ownerCt: ?, eOpts: ?)","!doc":"<p>Fires when a component is removed from an <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></p>\n"},"render":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n"},"show":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n"}},"util":{"Floating":{"prototype":{"constrain":{"!type":"bool","!doc":"<p>True to constrain this Components within its containing element, false to allow it to fall outside of its containing\nelement. By default this Component will be rendered to <code>document.body</code>. To render and constrain this Component within\nanother element specify <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>.</p>\n"},"fixed":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser viewport, immune\nto scrolling the document.</p>\n"},"focusOnToFront":{"!type":"bool","!doc":"<p>Specifies whether the floated component should be automatically <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focused</a> when\nit is <a href=\"#!/api/Ext.util.Floating-method-toFront\" rel=\"Ext.util.Floating-method-toFront\" class=\"docClass\">brought to the front</a>.</p>\n"},"shadow":{"!doc":"<p>Specifies whether the floating component should be given a shadow. Set to true to automatically create an\n<a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the shadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. Set to false to\ndisable the shadow.</p>\n"},"shadowOffset":{"!type":"number","!doc":"<p>Number of pixels to offset the shadow.</p>\n"},"mixinId":{"!type":"string"},"center":{"!type":"fn() -> ?","!doc":"<p>Center this Component in its container.</p>\n"},"doConstrain":{"!type":"fn(constrainTo?: ?) -> !this","!doc":"<p>Moves this floating Component into a constrain region.</p>\n\n<p>By default, this Component is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"fitContainer":{"!type":"fn(animate: ?) -> !this"},"initHierarchyEvents":{"!type":"fn() -> !this"},"onAfterFloatLayout":{"!type":"fn() -> !this"},"onBeforeFloatLayout":{"!type":"fn() -> !this"},"onFloatShow":{"!type":"fn() -> !this"},"onKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Listen for TAB events and wrap round if tabbing of either end of the Floater</p>\n"},"registerWithOwnerCt":{"!type":"fn() -> !this"},"setActive":{"!type":"fn(active?: ?, newActive?: ?) -> !this","!doc":"<p>This method is called internally by <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a> to signal that a floating Component has either been\nmoved to the top of its zIndex stack, or pushed from the top of its zIndex stack.</p>\n\n<p>If a <em>Window</em> is superceded by another Window, deactivating it hides its shadow.</p>\n\n<p>This method also fires the <a href=\"#!/api/Ext.Component-event-activate\" rel=\"Ext.Component-event-activate\" class=\"docClass\">activate</a> or\n<a href=\"#!/api/Ext.Component-event-deactivate\" rel=\"Ext.Component-event-deactivate\" class=\"docClass\">deactivate</a> event depending on which action occurred.</p>\n"},"setFloatParent":{"!type":"fn(floatParent: ?) -> !this"},"setZIndex":{"!type":"fn(index: ?) -> !this","!doc":"<p>z-index is managed by the zIndexManager and may be overwritten at any time.\nReturns the next z-index to be used.\nIf this is a Container, then it will have rebased any managed floating Components,\nand so the next available z-index will be approximately 10000 above that.</p>\n"},"syncHidden":{"!type":"fn() -> !this","!doc":"<p>synchronizes the hidden state of this component with the state of its hierarchy</p>\n"},"syncShadow":{"!type":"fn() -> !this"},"toBack":{"!type":"fn() -> ?","!doc":"<p>Sends this Component to the back of (lower z-index than) any other visible windows</p>\n"},"toFront":{"!type":"fn(preventFocus?: ?) -> ?","!doc":"<p>Brings this floating Component to the front of any other visible, floating Components managed by the same\n<a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<p>If this Component is modal, inserts the modal mask just below this Component in the z-index stack.</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus\nunless the mousedown was on a focusable element*</p>\n"}},"fixed":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser viewport, immune\nto scrolling the document.</p>\n"},"focusOnToFront":{"!type":"bool","!doc":"<p>Specifies whether the floated component should be automatically <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focused</a> when\nit is <a href=\"#!/api/Ext.util.Floating-method-toFront\" rel=\"Ext.util.Floating-method-toFront\" class=\"docClass\">brought to the front</a>.</p>\n"},"shadow":{"!doc":"<p>Specifies whether the floating component should be given a shadow. Set to true to automatically create an\n<a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the shadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. Set to false to\ndisable the shadow.</p>\n"},"shadowOffset":{"!type":"number","!doc":"<p>Number of pixels to offset the shadow.</p>\n"},"mixinId":{"!type":"string"},"center":{"!type":"fn() -> ?","!doc":"<p>Center this Component in its container.</p>\n"},"doConstrain":{"!type":"fn(constrainTo?: ?) -> !this","!doc":"<p>Moves this floating Component into a constrain region.</p>\n\n<p>By default, this Component is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"fitContainer":{"!type":"fn(animate: ?) -> !this"},"initHierarchyEvents":{"!type":"fn() -> !this"},"onAfterFloatLayout":{"!type":"fn() -> !this"},"onBeforeFloatLayout":{"!type":"fn() -> !this"},"onFloatShow":{"!type":"fn() -> !this"},"onKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Listen for TAB events and wrap round if tabbing of either end of the Floater</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus\nunless the mousedown was on a focusable element*</p>\n"},"registerWithOwnerCt":{"!type":"fn() -> !this"},"setActive":{"!type":"fn(active?: ?, newActive?: ?) -> !this","!doc":"<p>This method is called internally by <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a> to signal that a floating Component has either been\nmoved to the top of its zIndex stack, or pushed from the top of its zIndex stack.</p>\n\n<p>If a <em>Window</em> is superceded by another Window, deactivating it hides its shadow.</p>\n\n<p>This method also fires the <a href=\"#!/api/Ext.Component-event-activate\" rel=\"Ext.Component-event-activate\" class=\"docClass\">activate</a> or\n<a href=\"#!/api/Ext.Component-event-deactivate\" rel=\"Ext.Component-event-deactivate\" class=\"docClass\">deactivate</a> event depending on which action occurred.</p>\n"},"setFloatParent":{"!type":"fn(floatParent: ?) -> !this"},"setZIndex":{"!type":"fn(index: ?) -> !this","!doc":"<p>z-index is managed by the zIndexManager and may be overwritten at any time.\nReturns the next z-index to be used.\nIf this is a Container, then it will have rebased any managed floating Components,\nand so the next available z-index will be approximately 10000 above that.</p>\n"},"syncHidden":{"!type":"fn() -> !this","!doc":"<p>synchronizes the hidden state of this component with the state of its hierarchy</p>\n"},"syncShadow":{"!type":"fn() -> !this"},"toBack":{"!type":"fn() -> ?","!doc":"<p>Sends this Component to the back of (lower z-index than) any other visible windows</p>\n"},"toFront":{"!type":"fn(preventFocus?: ?) -> ?","!doc":"<p>Brings this floating Component to the front of any other visible, floating Components managed by the same\n<a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<p>If this Component is modal, inserts the modal mask just below this Component in the z-index stack.</p>\n"},"!doc":"<p>A mixin to add floating capability to a Component.</p>\n"},"Renderable":{"prototype":{"_renderState":{"!type":"number","!doc":"<p>This property holds one of the following values during the render process:</p>\n\n<ul>\n<li><strong>0</strong> - The component is not rendered.</li>\n<li><strong>1</strong> - The component has fired beforerender and is about to call beforeRender.\nThe component has just started rendering.</li>\n<li><strong>2</strong> - The component has finished the <code>beforeRender</code> process and is about to\ncall <code>onRender</code>. This is when <code>rendering</code> is set to <code>true</code>.</li>\n<li><strong>3</strong> - The component has started <code>onRender</code>. This is when <code>rendered</code> is set\nto <code>true</code>.</li>\n<li><strong>4</strong> - The component has finished its afterrender process.</li>\n</ul>\n\n"},"frameCls":{"!type":"string"},"frameElNames":{},"frameIdRegex":{},"frameTableTpl":{},"frameTpl":{},"afterFirstLayout":{"!type":"fn(width: ?, height: ?) -> !this"},"afterRender":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior after rendering is complete. At this stage the Component's Element\nwill have been styled according to the configuration, will have had any configured CSS class\nnames added, and will be in the configured visibility and the configured enable state.</p>\n"},"applyRenderSelectors":{"!type":"fn() -> !this","!doc":"<p>Sets references to elements inside the component. This applies <a href=\"#!/api/Ext.Component-cfg-renderSelectors\" rel=\"Ext.Component-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>\nas well as <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"cacheRefEls":{"!type":"fn(el: ?) -> !this","!doc":"<p>Ensures that all elements with \"data-ref\" attributes get loaded into the cache.\nThis really helps on IE8 where <code>getElementById</code> is a search not a lookup. By\npopulating our cache with one search of the DOM we then have random access to\nthe elements as we do our <code>childEls</code> wire up.</p>\n"},"doApplyRenderTpl":{"!type":"fn(out: ?, values: ?) -> !this","!doc":"<p>Called from the selected frame generation template to insert this Component's inner structure inside the framing structure.</p>\n\n<p>When framing is used, a selected frame generation template is used as the primary template of the <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> instead\nof the configured <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>. The renderTpl is invoked by this method which is injected into the framing template.</p>\n"},"doAutoRender":{"!type":"fn() -> !this","!doc":"<p>Handles autoRender.\nFloating Components may have an ownerCt. If they are asking to be constrained, constrain them within that\nownerCt, and have their z-index managed locally. Floating Components are always rendered to document.body</p>\n"},"ensureAttachedToBody":{"!type":"fn(runLayout?: ?) -> !this","!doc":"<p>Ensures that this component is attached to <code>document.body</code>. If the component was\nrendered to Ext.getDetachedBody, then it will be appended to <code>document.body</code>.\nAny configured position is also restored.</p>\n"},"finishRender":{"!type":"fn(containerIdx: ?) -> !this","!doc":"<p>This method visits the rendered component tree in a \"top-down\" order. That is, this\ncode runs on a parent component before running on a child. This method calls the\n<a href=\"#!/api/Ext.util.Renderable-method-onRender\" rel=\"Ext.util.Renderable-method-onRender\" class=\"docClass\">onRender</a> method of each component.</p>\n"},"getFrameInfo":{"!type":"fn() -> !this","!doc":"<p>On render, reads an encoded style attribute, \"filter\" from the style of this Component's element.\nThis information is memoized based upon the CSS class name of this Component's element.\nBecause child Components are rendered as textual HTML as part of the topmost Container, a dummy div is inserted\ninto the document to receive the document element's CSS class name, and therefore style attributes.</p>\n"},"getFrameTpl":{"!type":"fn(table: ?) -> !this"},"getInsertPosition":{"!type":"fn(position: ?) -> ?","!doc":"<p>This function takes the position argument passed to onRender and returns a\nDOM element that you can use in the insertBefore.</p>\n"},"getRenderTree":{"!type":"fn() -> !this"},"getStyleProxy":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Returns an offscreen div with the same class name as the element this is being rendered.\nThis is because child item rendering takes place in a detached div which, being not\npart of the document, has no styling.</p>\n"},"initRenderTpl":{"!type":"fn() -> ?","!doc":"<p>Initializes the renderTpl.</p>\n"},"onClassMixedIn":{"!type":"fn(targetClass: ?) -> !this"},"render":{"!type":"fn(container?: ?, position?: ?) -> !this","!doc":"<p>Renders the Component into the passed HTML element.</p>\n\n<p><strong>If you are using a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> object to house this\nComponent, then do not use the render method.</strong></p>\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.container.Container-method-doLayout\" rel=\"Ext.container.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which\ncauses any unrendered child Components to be rendered. This is required so that you can add\nmultiple child components if needed while only refreshing the layout once.</p>\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>\nmanager.  If you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n<p><strong>Omitting the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</strong></p>\n"},"setupFramingTpl":{"!type":"fn(frameTpl: ?) -> !this","!doc":"<p>Inject a reference to the function which applies the render template into the framing template. The framing template\nwraps the content.</p>\n"},"updateFrame":{"!type":"fn() -> !this","!doc":"<p>Updates the frame elements to match new framing. The current <code>frameBody</code> is\npreserved by transplanting it into the new frame. All other frame <code>childEls</code>\nare destroyed and recreated if needed by the new frame. This method cannot\ntransition from framed to non-framed or vise-versa or between table and div\nbased framing.</p>\n"},"getElConfig":{"!type":"fn() -> !this"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"onRender":{"!type":"fn(parentNode: ?, containerIdx: ?) -> !this","!doc":"<p>Template method called when this Component's DOM structure is created.</p>\n\n<p>At this point, this Component's (and all descendants') DOM structure <em>exists</em> but it has not\nbeen layed out (positioned and sized).</p>\n\n<p>Subclasses which override this to gain access to the structure at render time should\ncall the parent class's method before attempting to access any child elements of the Component.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"mixinId":{"!type":"string"},"privates":{"!doc":"<hr />\n"},"makeRenderSetter":{"!type":"fn(cfg: ?, renderState: ?) -> !this"},"processRenderConfig":{"!type":"fn(source: ?, configName: ?, state: ?) -> !this"}},"_renderState":{"!type":"number","!doc":"<p>This property holds one of the following values during the render process:</p>\n\n<ul>\n<li><strong>0</strong> - The component is not rendered.</li>\n<li><strong>1</strong> - The component has fired beforerender and is about to call beforeRender.\nThe component has just started rendering.</li>\n<li><strong>2</strong> - The component has finished the <code>beforeRender</code> process and is about to\ncall <code>onRender</code>. This is when <code>rendering</code> is set to <code>true</code>.</li>\n<li><strong>3</strong> - The component has started <code>onRender</code>. This is when <code>rendered</code> is set\nto <code>true</code>.</li>\n<li><strong>4</strong> - The component has finished its afterrender process.</li>\n</ul>\n\n"},"frameCls":{"!type":"string"},"frameElNames":{},"frameIdRegex":{},"frameTableTpl":{},"frameTpl":{},"afterFirstLayout":{"!type":"fn(width: ?, height: ?) -> !this"},"applyRenderSelectors":{"!type":"fn() -> !this","!doc":"<p>Sets references to elements inside the component. This applies <a href=\"#!/api/Ext.Component-cfg-renderSelectors\" rel=\"Ext.Component-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>\nas well as <a href=\"#!/api/Ext.Component-cfg-childEls\" rel=\"Ext.Component-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"cacheRefEls":{"!type":"fn(el: ?) -> !this","!doc":"<p>Ensures that all elements with \"data-ref\" attributes get loaded into the cache.\nThis really helps on IE8 where <code>getElementById</code> is a search not a lookup. By\npopulating our cache with one search of the DOM we then have random access to\nthe elements as we do our <code>childEls</code> wire up.</p>\n"},"doApplyRenderTpl":{"!type":"fn(out: ?, values: ?) -> !this","!doc":"<p>Called from the selected frame generation template to insert this Component's inner structure inside the framing structure.</p>\n\n<p>When framing is used, a selected frame generation template is used as the primary template of the <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> instead\nof the configured <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a>. The renderTpl is invoked by this method which is injected into the framing template.</p>\n"},"doAutoRender":{"!type":"fn() -> !this","!doc":"<p>Handles autoRender.\nFloating Components may have an ownerCt. If they are asking to be constrained, constrain them within that\nownerCt, and have their z-index managed locally. Floating Components are always rendered to document.body</p>\n"},"ensureAttachedToBody":{"!type":"fn(runLayout?: ?) -> !this","!doc":"<p>Ensures that this component is attached to <code>document.body</code>. If the component was\nrendered to Ext.getDetachedBody, then it will be appended to <code>document.body</code>.\nAny configured position is also restored.</p>\n"},"finishRender":{"!type":"fn(containerIdx: ?) -> !this","!doc":"<p>This method visits the rendered component tree in a \"top-down\" order. That is, this\ncode runs on a parent component before running on a child. This method calls the\n<a href=\"#!/api/Ext.util.Renderable-method-onRender\" rel=\"Ext.util.Renderable-method-onRender\" class=\"docClass\">onRender</a> method of each component.</p>\n"},"getFrameInfo":{"!type":"fn() -> !this","!doc":"<p>On render, reads an encoded style attribute, \"filter\" from the style of this Component's element.\nThis information is memoized based upon the CSS class name of this Component's element.\nBecause child Components are rendered as textual HTML as part of the topmost Container, a dummy div is inserted\ninto the document to receive the document element's CSS class name, and therefore style attributes.</p>\n"},"getFrameTpl":{"!type":"fn(table: ?) -> !this"},"getInsertPosition":{"!type":"fn(position: ?) -> ?","!doc":"<p>This function takes the position argument passed to onRender and returns a\nDOM element that you can use in the insertBefore.</p>\n"},"getRenderTree":{"!type":"fn() -> !this"},"getStyleProxy":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Returns an offscreen div with the same class name as the element this is being rendered.\nThis is because child item rendering takes place in a detached div which, being not\npart of the document, has no styling.</p>\n"},"initRenderTpl":{"!type":"fn() -> ?","!doc":"<p>Initializes the renderTpl.</p>\n"},"onClassMixedIn":{"!type":"fn(targetClass: ?) -> !this"},"render":{"!type":"fn(container?: ?, position?: ?) -> !this","!doc":"<p>Renders the Component into the passed HTML element.</p>\n\n<p><strong>If you are using a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> object to house this\nComponent, then do not use the render method.</strong></p>\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.container.Container-method-doLayout\" rel=\"Ext.container.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which\ncauses any unrendered child Components to be rendered. This is required so that you can add\nmultiple child components if needed while only refreshing the layout once.</p>\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>\nmanager.  If you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n<p><strong>Omitting the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</strong></p>\n"},"setupFramingTpl":{"!type":"fn(frameTpl: ?) -> !this","!doc":"<p>Inject a reference to the function which applies the render template into the framing template. The framing template\nwraps the content.</p>\n"},"updateFrame":{"!type":"fn() -> !this","!doc":"<p>Updates the frame elements to match new framing. The current <code>frameBody</code> is\npreserved by transplanting it into the new frame. All other frame <code>childEls</code>\nare destroyed and recreated if needed by the new frame. This method cannot\ntransition from framed to non-framed or vise-versa or between table and div\nbased framing.</p>\n"},"!doc":"<p>Given a component hierarchy of this:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     id: 'ContainerA',\n     layout: 'hbox',\n     renderTo: Ext.getBody(),\n     items: [\n         {\n             id: 'ContainerB',\n             xtype: 'container',\n             items: [\n                 { id: 'ComponentA' }\n             ]\n         }\n     ]\n }\n</code></pre>\n\n<p>The rendering of the above proceeds roughly like this:</p>\n\n<ul>\n<li>ContainerA's initComponent calls <a href=\"#!/api/Ext.util.Renderable-method-render\" rel=\"Ext.util.Renderable-method-render\" class=\"docClass\">render</a> passing the <code>renderTo</code> property as the\ncontainer argument.</li>\n<li><code>render</code> calls the <code>getRenderTree</code> method to get a complete Ext.dom.Helper spec.</li>\n<li><code>getRenderTree</code> fires the \"beforerender\" event and calls the <a href=\"#!/api/Ext.util.Renderable-method-beforeRender\" rel=\"Ext.util.Renderable-method-beforeRender\" class=\"docClass\">beforeRender</a>\nmethod. Its result is obtained by calling <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a>.</li>\n<li>The <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> method uses the <code>renderTpl</code> and its render data as the content\nof the <code>autoEl</code> described element.</li>\n<li>The result of <code>getRenderTree</code> is passed to Ext.dom.Helper.append.</li>\n<li>The <code>renderTpl</code> contains calls to render things like docked items, container items\nand raw markup (such as the <code>html</code> or <code>tpl</code> config properties). These calls are to\nmethods added to the Ext.XTemplate instance by #setupRenderTpl.</li>\n<li>The #setupRenderTpl method adds methods such as <code>renderItems</code>, <code>renderContent</code>, etc.\nto the template. These are directed to \"doRenderItems\", \"doRenderContent\" etc..</li>\n<li>The #setupRenderTpl calls traverse from components to their <a href=\"#!/api/Ext.layout.Layout\" rel=\"Ext.layout.Layout\" class=\"docClass\">Ext.layout.Layout</a>\nobject.</li>\n<li>When a container is rendered, it also has a <code>renderTpl</code>. This is processed when the\n<code>renderContainer</code> method is called in the component's <code>renderTpl</code>. This call goes to\n<a href=\"#!/api/Ext.layout.container.Container-method-doRenderContainer\" rel=\"Ext.layout.container.Container-method-doRenderContainer\" class=\"docClass\">Ext.layout.container.Container.doRenderContainer</a>. This method repeats this\nprocess for all components in the container.</li>\n<li>After the top-most component's markup is generated and placed in to the DOM, the next\nstep is to link elements to their components and finish calling the component methods\n<code>onRender</code> and <code>afterRender</code> as well as fire the corresponding events.</li>\n<li>The first step in this is to call <a href=\"#!/api/Ext.util.Renderable-method-finishRender\" rel=\"Ext.util.Renderable-method-finishRender\" class=\"docClass\">finishRender</a>. This method descends the\ncomponent hierarchy and calls <code>onRender</code> and fires the <code>render</code> event. These calls\nare delivered top-down to approximate the timing of these calls/events from previous\nversions.</li>\n<li>During the pass, the component's <code>el</code> is set. Likewise, the <code>renderSelectors</code> and\n<code>childEls</code> are applied to capture references to the component's elements.</li>\n<li>These calls are also made on the <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">Ext.layout.container.Container</a> layout to\ncapture its elements. Both of these classes use <a href=\"#!/api/Ext.util.ElementContainer\" rel=\"Ext.util.ElementContainer\" class=\"docClass\">Ext.util.ElementContainer</a> to\nhandle <code>childEls</code> processing.</li>\n</ul>\n\n"},"Animate":{"prototype":{"isAnimate":{"!type":"bool"},"anim":{"!type":"fn(config: ?) -> !this","!doc":"<ul>\n<li>process the passed fx configuration.</li>\n</ul>\n\n"},"getActiveAnimation":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"getAnimationProps":{"!type":"fn() -> !this","!doc":"<ul>\n<li>get animation properties</li>\n</ul>\n\n"},"hasActiveFx":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"sequenceFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after sequenceFx is called on this object are run in sequence. This is the\nopposite of <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a>.</p>\n"},"stopAnimation":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"stopFx":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"syncFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after syncFx is called on this object are run concurrently. This is the opposite\nof <a href=\"#!/api/Ext.util.Animate-method-sequenceFx\" rel=\"Ext.util.Animate-method-sequenceFx\" class=\"docClass\">sequenceFx</a>.</p>\n"},"mixinId":{"!type":"string"},"animate":{"!type":"fn(config: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the Sprite\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = Ext.create('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margin: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margin: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"}},"isAnimate":{"!type":"bool"},"anim":{"!type":"fn(config: ?) -> !this","!doc":"<ul>\n<li>process the passed fx configuration.</li>\n</ul>\n\n"},"getActiveAnimation":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"hasActiveFx":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"sequenceFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after sequenceFx is called on this object are run in sequence. This is the\nopposite of <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a>.</p>\n"},"stopAnimation":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"stopFx":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"syncFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after syncFx is called on this object are run concurrently. This is the opposite\nof <a href=\"#!/api/Ext.util.Animate-method-sequenceFx\" rel=\"Ext.util.Animate-method-sequenceFx\" class=\"docClass\">sequenceFx</a>.</p>\n"},"!doc":"<p>This animation class is a mixin.</p>\n\n<p><a href=\"#!/api/Ext.util.Animate\" rel=\"Ext.util.Animate\" class=\"docClass\">Ext.util.Animate</a> provides an API for the creation of animated transitions of properties and styles.\nThis class is used as a mixin and currently applied to Ext.dom.Element, Ext.CompositeElement,\nExt.draw.sprite.Sprite, Ext.draw.sprite.Composite, and <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.  Note that Components\nhave a limited subset of what attributes can be animated such as top, left, x, y, height, width, and\nopacity (color, paddings, and margins can not be animated).</p>\n\n<h2>Animation Basics</h2>\n\n<p>All animations require three things - <code>easing</code>, <code>duration</code>, and <code>to</code> (the final end value for each property)\nyou wish to animate. Easing and duration are defaulted values specified below.\nEasing describes how the intermediate values used during a transition will be calculated.\n<a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">Easing</a> allows for a transition to change speed over its duration.\nYou may use the defaults for easing and duration, but you must always set a\n<a href=\"#!/api/Ext.fx.Anim-cfg-to\" rel=\"Ext.fx.Anim-cfg-to\" class=\"docClass\">to</a> property which is the end value for all animations.</p>\n\n<p>Popular element 'to' configurations are:</p>\n\n<ul>\n<li>opacity</li>\n<li>x</li>\n<li>y</li>\n<li>color</li>\n<li>height</li>\n<li>width</li>\n</ul>\n\n\n<p>Popular sprite 'to' configurations are:</p>\n\n<ul>\n<li>translation</li>\n<li>path</li>\n<li>scale</li>\n<li>stroke</li>\n<li>rotation</li>\n</ul>\n\n\n<p>The default duration for animations is 250 (which is a 1/4 of a second).  Duration is denoted in\nmilliseconds.  Therefore 1 second is 1000, 1 minute would be 60000, and so on. The default easing curve\nused for all animations is 'ease'.  Popular easing functions are included and can be found in <a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">Easing</a>.</p>\n\n<p>For example, a simple animation to fade out an element with a default easing and duration:</p>\n\n<pre><code>var p1 = Ext.get('myElementId');\n\np1.animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>To make this animation fade out in a tenth of a second:</p>\n\n<pre><code>var p1 = Ext.get('myElementId');\n\np1.animate({\n   duration: 100,\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<h2>Animation Queues</h2>\n\n<p>By default all animations are added to a queue which allows for animation via a chain-style API.\nFor example, the following code will queue 4 animations which occur sequentially (one right after the other):</p>\n\n<pre><code>p1.animate({\n    to: {\n        x: 500\n    }\n}).animate({\n    to: {\n        y: 150\n    }\n}).animate({\n    to: {\n        backgroundColor: '#f00'  //red\n    }\n}).animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>You can change this behavior by calling the <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a> method and all\nsubsequent animations for the specified target will be run concurrently (at the same time).</p>\n\n<pre><code>p1.syncFx();  //this will make all animations run at the same time\n\np1.animate({\n    to: {\n        x: 500\n    }\n}).animate({\n    to: {\n        y: 150\n    }\n}).animate({\n    to: {\n        backgroundColor: '#f00'  //red\n    }\n}).animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>This works the same as:</p>\n\n<pre><code>p1.animate({\n    to: {\n        x: 500,\n        y: 150,\n        backgroundColor: '#f00'  //red\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.util.Animate-method-stopAnimation\" rel=\"Ext.util.Animate-method-stopAnimation\" class=\"docClass\">stopAnimation</a> method can be used to stop any\ncurrently running animations and clear any queued animations.</p>\n\n<h2>Animation Keyframes</h2>\n\n<p>You can also set up complex animations with <a href=\"#!/api/Ext.fx.Anim-cfg-keyframes\" rel=\"Ext.fx.Anim-cfg-keyframes\" class=\"docClass\">keyframes</a> which follow the\nCSS3 Animation configuration pattern. Note rotation, translation, and scaling can only be done for sprites.\nThe previous example can be written with the following syntax:</p>\n\n<pre><code>p1.animate({\n    duration: 1000,  //one second total\n    keyframes: {\n        25: {     //from 0 to 250ms (25%)\n            x: 0\n        },\n        50: {   //from 250ms to 500ms (50%)\n            y: 0\n        },\n        75: {  //from 500ms to 750ms (75%)\n            backgroundColor: '#f00'  //red\n        },\n        100: {  //from 750ms to 1sec\n            opacity: 0\n        }\n    }\n});\n</code></pre>\n\n<h2>Animation Events</h2>\n\n<p>Each animation you create has events for <a href=\"#!/api/Ext.fx.Anim-event-beforeanimate\" rel=\"Ext.fx.Anim-event-beforeanimate\" class=\"docClass\">beforeanimate</a>,\n<a href=\"#!/api/Ext.fx.Anim-event-afteranimate\" rel=\"Ext.fx.Anim-event-afteranimate\" class=\"docClass\">afteranimate</a>, and <a href=\"#!/api/Ext.fx.Anim-event-lastframe\" rel=\"Ext.fx.Anim-event-lastframe\" class=\"docClass\">lastframe</a>.\nKeyframed animations adds an additional <a href=\"#!/api/Ext.fx.Animator-event-keyframe\" rel=\"Ext.fx.Animator-event-keyframe\" class=\"docClass\">keyframe</a> event which\nfires for each keyframe in your animation.</p>\n\n<p>All animations support the listeners configuration to attact functions to these events.</p>\n\n<pre><code>startAnimate: function() {\n    var p1 = Ext.get('myElementId');\n    p1.animate({\n       duration: 100,\n        to: {\n            opacity: 0\n        },\n        listeners: {\n            beforeanimate:  function() {\n                // Execute my custom method before the animation\n                this.myBeforeAnimateFn();\n            },\n            afteranimate: function() {\n                // Execute my custom method after the animation\n                this.myAfterAnimateFn();\n            },\n            scope: this\n    });\n},\nmyBeforeAnimateFn: function() {\n  // My custom logic\n},\nmyAfterAnimateFn: function() {\n  // My custom logic\n}\n</code></pre>\n\n<p>Due to the fact that animations run asynchronously, you can determine if an animation is currently\nrunning on any target by using the <a href=\"#!/api/Ext.util.Animate-method-getActiveAnimation\" rel=\"Ext.util.Animate-method-getActiveAnimation\" class=\"docClass\">getActiveAnimation</a>\nmethod.  This method will return false if there are no active animations or return the currently\nrunning <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> instance.</p>\n\n<p>In this example, we're going to wait for the current animation to finish, then stop any other\nqueued animations before we fade our element's opacity to 0:</p>\n\n<pre><code>var curAnim = p1.getActiveAnimation();\nif (curAnim) {\n    curAnim.on('afteranimate', function() {\n        p1.stopAnimation();\n        p1.animate({\n            to: {\n                opacity: 0\n            }\n        });\n    });\n}\n</code></pre>\n"},"ElementContainer":{"prototype":{"afterClassMixedIn":{"!type":"fn(targetClass: ?) -> !this","!doc":"<p>Called after the mixin is applied. We need to see if <code>childEls</code> were used by\nthe <code>targetClass</code> and apply them to the config.</p>\n"},"attachChildEls":{"!type":"fn(el: ?, owner: ?) -> !this","!doc":"<p>Sets references to elements inside the component.</p>\n"},"getChildEls":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.util.ElementContainer-cfg-childEls\" rel=\"Ext.util.ElementContainer-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"setChildEls":{"!type":"fn(childEls: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.util.ElementContainer-cfg-childEls\" rel=\"Ext.util.ElementContainer-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"mixinId":{"!type":"string"},"privates":{},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"destroy":{"!type":"fn() -> !this"}},"afterClassMixedIn":{"!type":"fn(targetClass: ?) -> !this","!doc":"<p>Called after the mixin is applied. We need to see if <code>childEls</code> were used by\nthe <code>targetClass</code> and apply them to the config.</p>\n"},"attachChildEls":{"!type":"fn(el: ?, owner: ?) -> !this","!doc":"<p>Sets references to elements inside the component.</p>\n"},"getChildEls":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.util.ElementContainer-cfg-childEls\" rel=\"Ext.util.ElementContainer-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"setChildEls":{"!type":"fn(childEls: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.util.ElementContainer-cfg-childEls\" rel=\"Ext.util.ElementContainer-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"!doc":"<p>This mixin enables classes to declare relationships to child elements and provides the\nmechanics for acquiring the elements and storing them on an object\ninstance as properties.</p>\n\n<p>This class is used by <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">components</a> and <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">container layouts</a> to\nmanage their child elements.</p>\n\n<p>A typical component that uses these features might look something like this:</p>\n\n<pre><code> Ext.define('Ext.ux.SomeComponent', {\n     extend: '<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>',\n\n     childEls: [\n         'bodyEl'\n     ],\n\n     renderTpl: [\n         '&lt;div id=\"{id}-bodyEl\" data-ref=\"bodyEl\"&gt;&lt;/div&gt;'\n     ],\n\n     // ...\n });\n</code></pre>\n\n<p>The <code><a href=\"#!/api/Ext.util.ElementContainer-cfg-childEls\" rel=\"Ext.util.ElementContainer-cfg-childEls\" class=\"docClass\">childEls</a></code> config lists one or more relationships to child elements managed\nby the component. The items in this array can be objects that more fully specify the\nchild. For example, the above could have used this instead to achieve the same result:</p>\n\n<pre><code> childEls: [\n     { name: 'bodyEl', itemId: 'bodyEl' }\n ]\n</code></pre>\n\n<p>Unlike a <code>renderTpl</code> where there is a single value for an instance, <code>childEls</code> are aggregated\nup the class hierarchy so that they are effectively inherited. In other words, if a\nclass where to derive from <code>Ext.ux.SomeComponent</code> in the example above, it could also\nhave a <code>childEls</code> property in the same way as <code>Ext.ux.SomeComponent</code>.</p>\n\n<pre><code> Ext.define('Ext.ux.AnotherComponent', {\n     extend: 'Ext.ux.SomeComponent',\n\n     childEls: [\n         // 'bodyEl' is inherited\n         'innerEl'\n     ],\n\n     renderTpl: [\n         '&lt;div id=\"{id}-bodyEl\" data-ref=\"bodyEl\"&gt;'\n             '&lt;div id=\"{id}-innerEl\" data-ref=\"innerEl\"&gt;&lt;/div&gt;'\n         '&lt;/div&gt;'\n     ],\n\n     // ...\n });\n</code></pre>\n\n<p><strong>IMPORTANT</strong>\nThe <code>renderTpl</code> contains both child elements and unites them in the desired markup, but\nthe <code>childEls</code> only contains the new child element. The <code>data-ref</code> attribute must be\nrendered on to child elements that do not use <code>select</code> or <code>selectNode</code> options. This\nis done for performance reasons on IE8 where element lookup (even by id) is not very\nefficient.</p>\n"},"StoreHolder":{"prototype":{"mixinId":{"!type":"string"},"bindStoreListeners":{"!type":"fn(store: ?) -> !this","!doc":"<p>Binds listeners for this component to the store. By default it will add\nanything bound by the getStoreListeners method, however it can be overridden\nin a subclass to provide any more complicated handling.</p>\n"},"setStore":{"!type":"fn(store: ?) -> !this","!doc":"<p>Sets the store to the specified store.</p>\n"},"unbindStoreListeners":{"!type":"fn(store: ?) -> !this","!doc":"<p>Unbinds listeners from this component to the store. By default it will remove\nanything bound by the bindStoreListeners method, however it can be overridden\nin a subclass to provide any more complicated handling.</p>\n"},"onBindStore":{"!type":"fn(store: ?, initial: ?) -> !this","!doc":"<p>Template method, it is called when a new store is bound\nto the current instance.</p>\n"},"onUnbindStore":{"!type":"fn(store: ?, initial: ?) -> !this","!doc":"<p>Template method, it is called when an existing store is unbound\nfrom the current instance.</p>\n"},"getStore":{"!type":"fn() -> ?","!doc":"<p>Gets the current store instance.</p>\n"},"bindStore":{"!type":"fn(store?: ?) -> !this","!doc":"<p>Binds a store to this instance.</p>\n"},"getStoreListeners":{"!type":"fn(store: ?) -> ?","!doc":"<p>Gets the listeners to bind to a new store.</p>\n"}},"!doc":"<p>This class is used as a mixin.</p>\n\n<p>This class is to be used to provide basic methods for binding/unbinding stores to other\nclasses.</p>\n\n<p>This class is not intended for direct use but rather internally by those classes that\nmanage a Store.</p>\n"},"KeyNav":{"prototype":{"defaultEventAction":{"!type":"string","!doc":"<p>The method to call on the Ext.event.Event after this KeyNav intercepts a key. Valid values are Ext.event.Event.stopEvent, Ext.event.Event.preventDefault and Ext.event.Event.stopPropagation.</p>\n\n<p>If a falsy value is specified, no method is called on the key event.</p>\n"},"disabled":{"!type":"bool","!doc":"<p>True to disable this KeyNav instance.</p>\n"},"eventName":{"!type":"string","!doc":"<p>The event to listen for to pick up key events.</p>\n"},"forceKeyDown":{"!type":"bool","!doc":"<p>Handle the keydown event instead of keypress. KeyNav automatically does this for IE since IE does not propagate\nspecial keys on keypress, but setting this to true will force other browsers to also handle keydown instead of\nkeypress.</p>\n"},"ignoreInputFields":{"!type":"bool","!doc":"<p>Configure this as <code>true</code> if there are any input fields within the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a>, and this KeyNav\nshould not process events from input fields, (<code>&amp;lt;input&gt;, &amp;lt;textarea&gt; and elements with</code>contentEditable=\"true\"`)</p>\n"},"keyMap":{"!doc":"<p>An optional pre-existing <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">KeyMap</a> to use to listen for key events. If not specified,\none is created.</p>\n"},"processEvent":{"!doc":"<p>An optional event processor function which accepts the argument list provided by the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">configured\nevent</a> of the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a>, and returns a keyEvent for processing by the KeyMap.</p>\n\n<p>This may be useful when the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a> is a Component with s complex event signature. Extra information from\nthe event arguments may be injected into the event for use by the handler functions before returning it.</p>\n"},"processEventScope":{"!doc":"<p>The scope (<code>this</code> context) in which the <a href=\"#!/api/Ext.util.KeyNav-cfg-processEvent\" rel=\"Ext.util.KeyNav-cfg-processEvent\" class=\"docClass\">processEvent</a> method is executed.</p>\n"},"target":{"!doc":"<p>The object on which to listen for the event specified by the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> config option.</p>\n"},"destroy":{"!type":"fn(removeEl: ?) -> !this","!doc":"<p>Destroy this KeyNav.</p>\n"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disables this KeyNav.</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables this KeyNav.</p>\n"},"getKeyEvent":{"!type":"fn(forceKeyDown: ?, configuredEventName: ?) -> string","!doc":"<p>Determines the event to bind to listen for keys. Defaults to the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> value, but\nmay be overridden the <a href=\"#!/api/Ext.util.KeyNav-cfg-forceKeyDown\" rel=\"Ext.util.KeyNav-cfg-forceKeyDown\" class=\"docClass\">forceKeyDown</a> setting.</p>\n"},"handleEvent":{"!type":"fn(keyCode: ?, event: ?, options: ?) -> !this","!doc":"<p>Method for filtering out the map argument</p>\n"},"legacyConstructor":{"!type":"fn(el: ?, config: ?) -> !this","!doc":"<p>Old constructor signature.</p>\n"},"setConfig":{"!type":"fn(config: ?) -> !this","!doc":"<p>Sets up a configuration for the KeyNav.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"keyOptions":{}},"!doc":"<p>Provides a convenient wrapper for normalized keyboard navigation. KeyNav allows you to bind navigation keys to\nfunction calls that will get called when the keys are pressed, providing an easy way to implement custom navigation\nschemes for any UI component.</p>\n\n<p>The following are all of the possible keys that can be implemented: enter, space, left, right, up, down, tab, esc,\npageUp, pageDown, del, backspace, home, end.</p>\n\n<p>Usage:</p>\n\n<pre><code>var nav = new <a href=\"#!/api/Ext.util.KeyNav\" rel=\"Ext.util.KeyNav\" class=\"docClass\">Ext.util.KeyNav</a>({\n    target : \"my-element\",\n    left   : function(e){\n        this.moveLeft(e.ctrlKey);\n    },\n    right  : function(e){\n        this.moveRight(e.ctrlKey);\n    },\n    enter  : function(e){\n        this.save();\n    },\n\n    // Binding may be a function specifiying fn, scope and defaultAction\n    esc: {\n        fn: this.onEsc,\n        defaultEventAction: false\n    },\n\n    // Binding may be keyed by a single character\n    A: {\n        ctrl: true,\n        fn: selectAll\n    },\n\n    // Binding may be keyed by a key code (45 = INSERT)\n    45: {\n        fn: doInsert\n    }\n    scope : this\n});\n</code></pre>\n","!type":"fn(config: ?)"},"ClickRepeater":{"!doc":"<p>A wrapper class which can be applied to any element. Fires a \"click\" event while the\nmouse is pressed. The interval between firings may be specified in the config but\ndefaults to 20 milliseconds.</p>\n\n<p>Optionally, a CSS class may be applied to the element during the time it is pressed.</p>\n","!type":"fn(el: ?, config?: ?)","prototype":{"accelerate":{"!type":"bool","!doc":"<p>True if autorepeating should start slowly and accelerate.\n\"interval\" and \"delay\" are ignored.</p>\n"},"delay":{"!type":"number","!doc":"<p>The initial delay before the repeating event begins firing.\nSimilar to an autorepeat key delay.</p>\n"},"el":{"!doc":"<p>The element to act as a button.</p>\n"},"interval":{"!type":"number","!doc":"<p>The interval between firings of the \"click\" event (in milliseconds).</p>\n"},"pressedCls":{"!type":"string","!doc":"<p>A CSS class name to be applied to the element while pressed.</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>True to prevent the default click event</p>\n"},"stopDefault":{"!type":"bool","!doc":"<p>True to stop the default click event</p>\n"},"timer":{"!type":"number"},"click":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires on a specified interval during the time the element is pressed.</p>\n"},"destroy":{"!type":"fn() -> !this"},"disable":{"!type":"fn(force: ?) -> !this","!doc":"<p>Disables the repeater and stops events from firing.</p>\n"},"easeOutExpo":{"!type":"fn(t: ?, b: ?, c: ?, d: ?) -> !this"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables the repeater and allows events to fire.</p>\n"},"eventOptions":{"!type":"fn(e: ?) -> !this"},"handleDblClick":{"!type":"fn(e: ?) -> !this"},"handleMouseDown":{"!type":"fn(e: ?) -> !this"},"handleMouseOut":{"!type":"fn() -> !this"},"handleMouseReturn":{"!type":"fn() -> !this"},"handleMouseUp":{"!type":"fn(e: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"mousedown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse button is depressed.</p>\n"},"mouseup":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse key is released.</p>\n"}}},"ComponentDragger":{"!doc":"<p>A subclass of <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a> which handles dragging any Component.</p>\n\n<p>This is configured with a Component to be made draggable, and a config object for the <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>\nclass.</p>\n\n<p>A <a href=\"#!/api/Ext.util.ComponentDragger-cfg-delegate\" rel=\"Ext.util.ComponentDragger-cfg-delegate\" class=\"docClass\">delegate</a> may be provided which may be either the element to use as the mousedown target or a\nCSS selector to activate multiple mousedown targets.</p>\n\n<p>When the Component begins to be dragged, its <code>beginDrag</code> method will be called if implemented.</p>\n\n<p>When the drag ends, its <code>endDrag</code> method will be called if implemented.</p>\n","!type":"fn(comp: ?, config?: ?)","prototype":{"constrain":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to constrain the Component to within the bounds of the <a href=\"#!/api/Ext.util.ComponentDragger-cfg-constrainTo\" rel=\"Ext.util.ComponentDragger-cfg-constrainTo\" class=\"docClass\">constrainTo</a> region.</p>\n"},"constrainDelegate":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to constrain the drag handles within the <a href=\"#!/api/Ext.util.ComponentDragger-cfg-constrainTo\" rel=\"Ext.util.ComponentDragger-cfg-constrainTo\" class=\"docClass\">constrainTo</a> region.</p>\n"},"delegate":{"!doc":"<p>A CSS selector which identifies child elements within the Component's encapsulating\nElement which are the drag handles. This limits dragging to only begin when the matching elements are\nmousedowned.</p>\n\n<p>This may also be a specific child element within the Component's encapsulating element to use as the drag handle.</p>\n"},"calculateConstrainRegion":{"!type":"fn() -> !this"},"onDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Move either the ghost Component or the target Component to its new position on drag</p>\n"},"onEnd":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation has been completed\n(e.g. the user clicked and held the mouse down, dragged the element and then released the mouse button)</p>\n"},"onStart":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation starts\n(e.g. the user has moved the tracked element beyond the specified tolerance)</p>\n"}}},"Cookies":{"!doc":"<p>Utility class for setting/reading values from browser cookies.\nValues can be written using the <a href=\"#!/api/Ext.util.Cookies-method-set\" rel=\"Ext.util.Cookies-method-set\" class=\"docClass\">set</a> method.\nValues can be read using the <a href=\"#!/api/Ext.util.Cookies-method-get\" rel=\"Ext.util.Cookies-method-get\" class=\"docClass\">get</a> method.\nA cookie can be invalidated on the client machine using the <a href=\"#!/api/Ext.util.Cookies-method-clear\" rel=\"Ext.util.Cookies-method-clear\" class=\"docClass\">clear</a> method.</p>\n","clear":{"!type":"fn(name: ?, path?: ?) -> !this","!doc":"<p>Removes a cookie with the provided name from the browser\nif found by setting its expiration date to sometime in the past.</p>\n"},"get":{"!type":"fn(name: ?) -> ?","!doc":"<p>Retrieves cookies that are accessible by the current page. If a cookie does not exist, <code>get()</code> returns null. The\nfollowing example retrieves the cookie called \"valid\" and stores the String value in the variable validStatus.</p>\n\n<pre><code>var validStatus = <a href=\"#!/api/Ext.util.Cookies-method-get\" rel=\"Ext.util.Cookies-method-get\" class=\"docClass\">Ext.util.Cookies.get</a>(\"valid\");\n</code></pre>\n"},"getCookieVal":{"!type":"fn(offset: ?) -> !this"},"set":{"!type":"fn(name: ?, value: ?, expires?: ?, path?: ?, domain?: ?, secure?: ?) -> !this","!doc":"<p>Creates a cookie with the specified name and value. Additional settings for the cookie may be optionally specified\n(for example: expiration, access restriction, SSL).</p>\n"}},"CSS":{"!doc":"<p>Utility class for manipulating CSS rules</p>\n","createRule":{"!type":"fn(styleSheet: ?, selector: ?, property: ?) -> ?","!doc":"<p>Creates a rule.</p>\n"},"createStyleSheet":{"!type":"fn(cssText: ?, id: ?) -> ?","!doc":"<p>Creates a stylesheet from a text blob of rules.\nThese rules will be wrapped in a STYLE tag and appended to the HEAD of the document.</p>\n"},"getRule":{"!type":"fn(selector: ?, refreshCache: ?) -> ?","!doc":"<p>Gets an an individual CSS rule by selector(s)</p>\n"},"getRules":{"!type":"fn(refreshCache: ?) -> ?","!doc":"<p>Gets all css rules for the document</p>\n"},"refreshCache":{"!type":"fn() -> ?","!doc":"<p>Refresh the rule cache if you have dynamically added stylesheets</p>\n"},"removeStyleSheet":{"!type":"fn(id: ?) -> !this","!doc":"<p>Removes a style or link tag by id</p>\n"},"swapStyleSheet":{"!type":"fn(id: ?, url: ?) -> !this","!doc":"<p>Dynamically swaps an existing stylesheet reference for a new one</p>\n"},"updateRule":{"!type":"fn(selector: ?, property: ?, value: ?) -> bool","!doc":"<p>Updates a rule property</p>\n"}},"History":{"!doc":"<p>History management component that allows you to register arbitrary tokens that signify application\nhistory state on navigation actions.  You can then handle the history <a href=\"#!/api/Ext.util.History-event-change\" rel=\"Ext.util.History-event-change\" class=\"docClass\">change</a> event in order\nto reset your application UI to the appropriate state when the user navigates forward or backward through\nthe browser history stack.</p>\n\n<h2>Initializing</h2>\n\n<p>The <a href=\"#!/api/Ext.util.History-method-init\" rel=\"Ext.util.History-method-init\" class=\"docClass\">init</a> method of the History object must be called before using History. This sets up the internal\nstate and must be the first thing called before using History.</p>\n","currentToken":{"!type":"string","!doc":"<p>The current token.</p>\n"},"useTopWindow":{"!type":"bool","!doc":"<p>True to use <code>window.top.location.hash</code> or false to use <code>window.location.hash</code>. Must be set before <a href=\"#!/api/Ext.util.History-method-init\" rel=\"Ext.util.History-method-init\" class=\"docClass\">init</a> is called\nbecause the <code>hashchange</code> event listener is added to the window at initialization time.</p>\n"},"add":{"!type":"fn(token: ?, preventDuplicates?: ?) -> !this","!doc":"<p>Add a new token to the history stack. This can be any arbitrary value, although it would\ncommonly be the concatenation of a component id and another id marking the specific history\nstate of that component. Example usage:</p>\n\n<pre><code>// Handle tab changes on a TabPanel\ntabPanel.on('tabchange', function(tabPanel, tab){\n     <a href=\"#!/api/Ext.util.History-method-add\" rel=\"Ext.util.History-method-add\" class=\"docClass\">Ext.History.add</a>(tabPanel.id + ':' + tab.id);\n});\n</code></pre>\n"},"back":{"!type":"fn() -> !this","!doc":"<p>Programmatically steps back one step in browser history (equivalent to the user pressing the Back button).</p>\n"},"forward":{"!type":"fn() -> !this","!doc":"<p>Programmatically steps forward one step in browser history (equivalent to the user pressing the Forward button).</p>\n"},"getHash":{"!type":"fn() -> string","!doc":"<p>Gets the actual hash from the url. This shouldn't need to be used directly but use the\n<a href=\"#!/api/Ext.util.History-method-getToken\" rel=\"Ext.util.History-method-getToken\" class=\"docClass\">getToken</a> method instead.</p>\n"},"getToken":{"!type":"fn() -> string","!doc":"<p>Retrieves the currently-active history token.</p>\n"},"handleStateChange":{"!type":"fn(token: ?) -> !this","!doc":"<p>Handles when the hash in the URL has been updated. Will also fired the change event.</p>\n"},"init":{"!type":"fn(onReady?: ?, scope?: ?) -> !this","!doc":"<p>Initializes the global History instance.</p>\n"},"setHash":{"!type":"fn(hash: ?) -> !this","!doc":"<p>Updates the hash on the window. This shouldn't need to be used directly but use the\n<a href=\"#!/api/Ext.util.History-method-add\" rel=\"Ext.util.History-method-add\" class=\"docClass\">add</a> method instead.</p>\n"},"startUp":{"!type":"fn() -> !this","!doc":"<p>Bootstraps the initialization the location.hash.\nThis will setup the Ext.TaskManager to poll for hash changes every 50ms.</p>\n"},"change":{"!type":"fn(token: ?, eOpts: ?)","!doc":"<p>Fires when navigation back or forwards within the local page's history occurs.</p>\n"},"ready":{"!type":"fn(The: ?, eOpts: ?)","!doc":"<p>Fires when the <a href=\"#!/api/Ext.util.History\" rel=\"Ext.util.History\" class=\"docClass\">Ext.util.History</a> singleton has been initialized and is ready for use.</p>\n"}},"KeyMap":{"!doc":"<p>Handles mapping key events to handling functions for an element or a Component. One KeyMap can be used for multiple\nactions.</p>\n\n<p>A KeyMap must be configured with a <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> as an event source which may be an Element or a Component.</p>\n\n<p>If the target is an element, then the <code>keydown</code> event will trigger the invocation of <a href=\"#!/api/Ext.util.KeyMap-cfg-binding\" rel=\"Ext.util.KeyMap-cfg-binding\" class=\"docClass\">binding</a>s.</p>\n\n<p>It is possible to configure the KeyMap with a custom <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">eventName</a> to listen for. This may be useful when the\n<a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> is a Component.</p>\n\n<p>The KeyMap's event handling requires that the first parameter passed is a key event. So if the Component's event\nsignature is different, specify a <a href=\"#!/api/Ext.util.KeyMap-cfg-processEvent\" rel=\"Ext.util.KeyMap-cfg-processEvent\" class=\"docClass\">processEvent</a> configuration which accepts the event's parameters and\nreturns a key event.</p>\n\n<p>Functions specified in <a href=\"#!/api/Ext.util.KeyMap-cfg-binding\" rel=\"Ext.util.KeyMap-cfg-binding\" class=\"docClass\">binding</a>s are called with this signature : <code>(String key, Ext.event.Event e)</code> (if the\nmatch is a multi-key combination the callback will still be called only once). A KeyMap can also handle a string\nrepresentation of keys. By default KeyMap starts enabled.</p>\n\n<p>Usage:</p>\n\n<pre><code>// map one key by key code\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    key: 13, // or Ext.event.Event.ENTER\n    fn: myHandler,\n    scope: myObject\n});\n\n// map multiple keys to one action by string\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    key: \"a\\r\\n\\t\",\n    fn: myHandler,\n    scope: myObject\n});\n\n// map multiple keys to multiple actions by strings and array of codes\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    binding: [{\n        key: [10,13],\n        fn: function(){ alert(\"Return was pressed\"); }\n    }, {\n        key: \"abc\",\n        fn: function(){ alert('a, b or c was pressed'); }\n    }, {\n        key: \"\\t\",\n        ctrl:true,\n        shift:true,\n        fn: function(){ alert('Control + shift + tab was pressed.'); }\n    }]\n});\n</code></pre>\n\n<p>Since 4.1.0, KeyMaps can bind to Components and process key-based events fired by Components.</p>\n\n<p>To bind to a Component, use the single parameter form of constructor and include the Component event name\nto listen for, and a <code>processEvent</code> implementation which returns the key event for further processing by\nthe KeyMap:</p>\n\n<pre><code>var map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: myGridView,\n    eventName: 'itemkeydown',\n    processEvent: function(view, record, node, index, event) {\n\n        // Load the event with the extra information needed by the mappings\n        event.view = view;\n        event.store = view.getStore();\n        event.record = record;\n        event.index = index;\n        return event;\n    },\n    binding: {\n        key: Ext.event.Event.DELETE,\n        fn: function(keyCode, e) {\n            e.store.remove(e.record);\n\n            // Attempt to select the record that's now in its place\n            e.view.getSelectionModel().select(e.index);\n            e.view.el.focus();\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"binding":{"!doc":"<p>Either a single object describing a handling function for s specified key (or set of keys), or\nan array of such objects.</p>\n"},"eventName":{"!type":"string","!doc":"<p>The event to listen for to pick up key events.</p>\n"},"ignoreInputFields":{"!type":"bool","!doc":"<p>Configure this as <code>true</code> if there are any input fields within the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>, and this KeyNav\nshould not process events from input fields, (<code>&amp;lt;input&gt;, &amp;lt;textarea&gt; and elements with</code>contentEditable=\"true\"`)</p>\n"},"processEvent":{"!doc":"<p>An optional event processor function which accepts the argument list provided by the\n<a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">configured event</a> of the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>, and returns a keyEvent for processing by the KeyMap.</p>\n\n<p>This may be useful when the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> is a Component with a complex event signature, where the event is not\nthe first parameter. Extra information from the event arguments may be injected into the event for use by the handler\nfunctions before returning it.</p>\n"},"processEventScope":{"!doc":"<p>The scope (<code>this</code> context) in which the <a href=\"#!/api/Ext.util.KeyMap-cfg-processEvent\" rel=\"Ext.util.KeyMap-cfg-processEvent\" class=\"docClass\">processEvent</a> method is executed.</p>\n"},"target":{"!doc":"<p>The object on which to listen for the event specified by the <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">eventName</a> config option.</p>\n"},"addBinding":{"!type":"fn(binding: ?) -> !this","!doc":"<p>Add a new binding to this KeyMap.</p>\n\n<p>Usage:</p>\n\n<pre><code>// Create a KeyMap\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>(document, {\n    key: Ext.event.Event.ENTER,\n    fn: handleKey,\n    scope: this\n});\n\n//Add a new binding to the existing KeyMap later\nmap.addBinding({\n    key: 'abc',\n    shift: true,\n    fn: handleKey,\n    scope: this\n});\n</code></pre>\n"},"checkModifiers":{"!type":"fn(binding: ?, event: ?) -> bool","!doc":"<p>Check if the modifiers on the event match those on the binding</p>\n"},"destroy":{"!type":"fn(removeTarget: ?) -> !this","!doc":"<p>Destroys the KeyMap instance and removes all handlers.</p>\n"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disable this KeyMap</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables this KeyMap</p>\n"},"handleTargetEvent":{"!type":"fn(event: ?) -> !this","!doc":"<p>Process the <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">event</a> from the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>.</p>\n"},"isEnabled":{"!type":"fn() -> bool","!doc":"<p>Returns true if this KeyMap is enabled</p>\n"},"legacyConstructor":{"!type":"fn(el: ?, binding: ?, eventName?: ?) -> !this","!doc":"<p>Old constructor signature</p>\n"},"on":{"!type":"fn(key: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for adding a single key listener.</p>\n"},"processBinding":{"!type":"fn(binding: ?, event: ?) -> !this","!doc":"<p>Process a particular binding and fire the handler if necessary.</p>\n"},"processKeys":{"!type":"fn(keyCode: ?) -> !this"},"removeBinding":{"!type":"fn(binding: ?) -> !this","!doc":"<p>Remove a binding from this KeyMap.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"un":{"!type":"fn(key: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for removing a single key listener.</p>\n"}}},"Memento":{"!doc":"<p>This class manages a set of captured properties from an object. These captured properties\ncan later be restored to an object.</p>\n","!type":"fn(target: ?, props: ?)","prototype":{"data":{"!doc":"<p>The collection of captured properties.</p>\n"},"target":{"!doc":"<p>The default target object for capture/restore (passed to the constructor).</p>\n"},"capture":{"!type":"fn(props: ?, target: ?) -> !this","!doc":"<p>Captures the specified properties from the target object in this memento.</p>\n"},"remove":{"!type":"fn(props: ?) -> !this","!doc":"<p>Removes the specified properties from this memento. These properties will not be\nrestored later without re-capturing their values.</p>\n"},"restore":{"!type":"fn(props: ?, clear: ?, target: ?) -> !this","!doc":"<p>Restores the specified properties from this memento to the target object.</p>\n"},"restoreAll":{"!type":"fn(clear: ?, target: ?) -> !this","!doc":"<p>Restores all captured properties in this memento to the target object.</p>\n"}}},"ProtoElement":{"!doc":"<p>Manages certain element-like data prior to rendering. These values are passed\non to the render process. This is currently used to manage the \"class\" and \"style\" attributes\nof a component's primary el as well as the bodyEl of panels. This allows things like\naddBodyCls in Panel to share logic with addCls in Component.</p>\n","prototype":{"clsProp":{"!type":"string","!doc":"<p>The property name for the className on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"removedProp":{"!type":"string","!doc":"<p>The property name for the removed classes on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"styleIsText":{"!type":"bool","!doc":"<p>True if the style must be converted to text during <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>. When used to\npopulate tpl data, this will be true. When used to populate Ext.dom.Helper\nspecs, this will be false (the default).</p>\n"},"styleProp":{"!type":"string","!doc":"<p>The property name for the style on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds class to the element.</p>\n"},"flush":{"!type":"fn() -> !this","!doc":"<p>Indicates that the current state of the object has been flushed to the DOM, so we need\nto track any subsequent changes</p>\n"},"hasCls":{"!type":"fn(cls: ?) -> bool","!doc":"<p>True if the element has given class.</p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes class from the element.</p>\n"},"setStyle":{"!type":"fn(prop: ?, value?: ?) -> ?","!doc":"<p>Adds styles to the element.</p>\n"},"writeTo":{"!type":"fn(to: ?) -> ?","!doc":"<p>Writes style and class properties to given object.\nStyles will be written to <a href=\"#!/api/Ext.util.ProtoElement-property-styleProp\" rel=\"Ext.util.ProtoElement-property-styleProp\" class=\"docClass\">styleProp</a> and class names to <a href=\"#!/api/Ext.util.ProtoElement-property-clsProp\" rel=\"Ext.util.ProtoElement-property-clsProp\" class=\"docClass\">clsProp</a>.</p>\n"}}},"Queue":{"!doc":"<p>An internal Queue class.</p>\n","!type":"fn()","prototype":{"add":{"!type":"fn(obj: ?) -> !this"},"clear":{"!type":"fn() -> !this","!doc":"<p>Removes all items from the collection.</p>\n"},"contains":{"!type":"fn(obj: ?) -> !this"},"getCount":{"!type":"fn() -> number","!doc":"<p>Returns the number of items in the collection.</p>\n"},"getKey":{"!type":"fn(obj: ?) -> !this"},"remove":{"!type":"fn(obj: ?) -> ?","!doc":"<p>Remove an item from the collection.</p>\n"}}}},"state":{"Stateful":{"prototype":{"saveDelay":{"!type":"number","!doc":"<p>A buffer to be applied if many state events are fired within a short period.</p>\n"},"stateEvents":{"!doc":"<p>&lt;An array of events that, when fired, should trigger this object to\nsave its state. Defaults to none. <code>stateEvents</code> may be any type\nof event supported by this object, including browser or custom events\n(e.g., <code>['click', 'customerchange']</code>).</p>\n\n<p>See <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring object state.</p>\n"},"stateId":{"!type":"string","!doc":"<p>The unique id for this object to use for state management purposes.</p>\n\n<p>See <a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a> for an explanation of saving and restoring state.</p>\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state and store state (sorters and filters and grouper) in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.state.Stateful-event-beforestaterestore\" rel=\"Ext.state.Stateful-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.state.Stateful-event-staterestore\" rel=\"Ext.state.Stateful-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.state.Stateful-event-beforestatesave\" rel=\"Ext.state.Stateful-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.state.Stateful-event-statesave\" rel=\"Ext.state.Stateful-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"addStateEvents":{"!type":"fn(events: ?) -> !this","!doc":"<p>Add events that will trigger the state to be saved. If the first argument is an\narray, each element of that array is the name of a state event. Otherwise, each\nargument passed to this method is the name of a state event.</p>\n"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Applies the state to the object. This should be overridden in subclasses to do\nmore complex state operations. By default it applies the state properties onto\nthe current object.</p>\n"},"getStateId":{"!type":"fn() -> string","!doc":"<p>Gets the state id for this object.</p>\n"},"initState":{"!type":"fn() -> !this","!doc":"<p>Initializes the state of the object upon construction.</p>\n"},"onStateChange":{"!type":"fn() -> !this","!doc":"<p>This method is called when any of the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> are fired.</p>\n"},"savePropToState":{"!type":"fn(propName: ?, state: ?, stateName?: ?) -> bool","!doc":"<p>Conditionally saves a single property from this object to the given state object.\nThe idea is to only save state which has changed from the initial state so that\ncurrent software settings do not override future software settings. Only those\nvalues that are user-changed state should be saved.</p>\n"},"savePropsToState":{"!type":"fn(propNames: ?, state: ?) -> ?","!doc":"<p>Gathers additional named properties of the instance and adds their current values\nto the passed state object.</p>\n"},"saveState":{"!type":"fn() -> !this","!doc":"<p>Saves the state of the object to the persistence store.</p>\n"},"beforestaterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is restored. Return false from an event handler to stop the restore.</p>\n"},"beforestatesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is saved to the configured state provider. Return false to stop the save.</p>\n"},"staterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is restored.</p>\n"},"statesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is saved to the configured state provider.</p>\n"},"mixinId":{"!type":"string"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this stateful object.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>Gets the current state of the object. By default this function returns null,\nit should be overridden in subclasses to implement methods for getting the state.</p>\n"}},"saveDelay":{"!type":"number","!doc":"<p>A buffer to be applied if many state events are fired within a short period.</p>\n"},"stateEvents":{"!doc":"<p>&lt;An array of events that, when fired, should trigger this object to\nsave its state. Defaults to none. <code>stateEvents</code> may be any type\nof event supported by this object, including browser or custom events\n(e.g., <code>['click', 'customerchange']</code>).</p>\n\n<p>See <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring object state.</p>\n"},"stateId":{"!type":"string","!doc":"<p>The unique id for this object to use for state management purposes.</p>\n\n<p>See <a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a> for an explanation of saving and restoring state.</p>\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state and store state (sorters and filters and grouper) in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.state.Stateful-event-beforestaterestore\" rel=\"Ext.state.Stateful-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.state.Stateful-event-staterestore\" rel=\"Ext.state.Stateful-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.state.Stateful-event-beforestatesave\" rel=\"Ext.state.Stateful-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.state.Stateful-event-statesave\" rel=\"Ext.state.Stateful-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"addStateEvents":{"!type":"fn(events: ?) -> !this","!doc":"<p>Add events that will trigger the state to be saved. If the first argument is an\narray, each element of that array is the name of a state event. Otherwise, each\nargument passed to this method is the name of a state event.</p>\n"},"getStateId":{"!type":"fn() -> string","!doc":"<p>Gets the state id for this object.</p>\n"},"initState":{"!type":"fn() -> !this","!doc":"<p>Initializes the state of the object upon construction.</p>\n"},"onStateChange":{"!type":"fn() -> !this","!doc":"<p>This method is called when any of the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> are fired.</p>\n"},"savePropToState":{"!type":"fn(propName: ?, state: ?, stateName?: ?) -> bool","!doc":"<p>Conditionally saves a single property from this object to the given state object.\nThe idea is to only save state which has changed from the initial state so that\ncurrent software settings do not override future software settings. Only those\nvalues that are user-changed state should be saved.</p>\n"},"savePropsToState":{"!type":"fn(propNames: ?, state: ?) -> ?","!doc":"<p>Gathers additional named properties of the instance and adds their current values\nto the passed state object.</p>\n"},"saveState":{"!type":"fn() -> !this","!doc":"<p>Saves the state of the object to the persistence store.</p>\n"},"beforestaterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is restored. Return false from an event handler to stop the restore.</p>\n"},"beforestatesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is saved to the configured state provider. Return false to stop the save.</p>\n"},"staterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is restored.</p>\n"},"statesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is saved to the configured state provider.</p>\n"},"!doc":"<p>A mixin for being able to save the state of an object to an underlying\n<a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a>.</p>\n"},"CookieProvider":{"!doc":"<p>A Provider implementation which saves and retrieves state via cookies. The CookieProvider supports the usual cookie\noptions, such as:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-path\" rel=\"Ext.state.CookieProvider-cfg-path\" class=\"docClass\">path</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-expires\" rel=\"Ext.state.CookieProvider-cfg-expires\" class=\"docClass\">expires</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-domain\" rel=\"Ext.state.CookieProvider-cfg-domain\" class=\"docClass\">domain</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-secure\" rel=\"Ext.state.CookieProvider-cfg-secure\" class=\"docClass\">secure</a></li>\n</ul>\n\n\n<p>Example:</p>\n\n<pre><code>var cp = Ext.create('<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>', {\n    path: \"/cgi-bin/\",\n    expires: new Date(new Date().getTime()+(1000*60*60*24*30)), //30 days\n    domain: \"sencha.com\"\n});\n\n<a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(cp);\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"domain":{"!type":"string","!doc":"<p>The domain to save the cookie for. Note that you cannot specify a different domain than your page is on, but you can\nspecify a sub-domain, or simply the domain itself like 'sencha.com' to include all sub-domains if you need to access\ncookies across different sub-domains. Defaults to null which uses the same domain the page is running on including\nthe 'www' like 'www.sencha.com'.</p>\n"},"expires":{"!doc":"<p>The cookie expiration date. Defaults to 7 days from now.</p>\n"},"path":{"!type":"string","!doc":"<p>The path for which the cookie is active. Defaults to root '/' which makes it active for all pages in the site.</p>\n"},"secure":{"!type":"bool","!doc":"<p>True if the site is using SSL</p>\n"},"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"clearCookie":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"readCookies":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>private</p>\n"},"setCookie":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>private</p>\n"}}},"Provider":{"prototype":{"prefix":{"!type":"string","!doc":"<p>A string to prefix to items stored in the underlying state store.\nDefaults to <tt>'ext-'</tt></p>\n"},"decodeValue":{"!type":"fn(value: ?) -> ?","!doc":"<p>Decodes a string previously encoded with <a href=\"#!/api/Ext.state.Provider-method-encodeValue\" rel=\"Ext.state.Provider-method-encodeValue\" class=\"docClass\">encodeValue</a>.</p>\n"},"encodeValue":{"!type":"fn(value: ?) -> string","!doc":"<p>Encodes a value including type information.  Decode with <a href=\"#!/api/Ext.state.Provider-method-decodeValue\" rel=\"Ext.state.Provider-method-decodeValue\" class=\"docClass\">decodeValue</a>.</p>\n"},"get":{"!type":"fn(name: ?, defaultValue: ?) -> ?","!doc":"<p>Returns the current value for a key</p>\n"},"statechange":{"!type":"fn(this: ?, key: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when a state change occurs.</p>\n"},"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>Clears a value from the state</p>\n"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"}},"!doc":"<p>Abstract base class for state provider implementations. The provider is responsible\nfor setting values  and extracting values to/from the underlying storage source. The \nstorage source can vary and the details should be implemented in a subclass. For example\na provider could use a server side database or the browser localstorage where supported.</p>\n\n\n\n\n<p>This class provides methods for encoding and decoding <b>typed</b> variables including \ndates and defines the Provider interface. By default these methods put the value and the\ntype information into a delimited string that can be stored. These should be overridden in \na subclass if you want to change the format of the encoded value and subsequent decoding.</p>\n\n"},"LocalStorageProvider":{"!doc":"<p>A Provider implementation which saves and retrieves state via the HTML5 localStorage API\nor IE <code>userData</code> storage. For details see <code>Ext.util.LocalStorage</code>.</p>\n\n<p>If the browser does not support local storage, there will be no attempt to read the state.\nBefore creating this class, check Ext.util.LocalStorage.supported.</p>\n","!type":"fn()","prototype":{"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"getStorageObject":{"!type":"fn() -> !this"},"readLocalStorage":{"!type":"fn() -> !this"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"}}},"Manager":{"!doc":"<p>This is the global state manager. By default all components that are \"state aware\" check this class\nfor state information if you don't pass them a custom state provider. In order for this class\nto be useful, it must be initialized with a provider when your application initializes. Example usage:</p>\n\n<pre><code> // in your initialization function\n init: function() {\n     <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>());\n }\n</code></pre>\n\n<p>This class passes on calls from components to the underlying <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> so that\nthere is a common interface that can be used without needing to refer to a specific provider instance\nin every component.</p>\n","!type":"fn()","clear":{"!type":"fn(key: ?) -> !this","!doc":"<p>Clears a value from the state</p>\n"},"get":{"!type":"fn(key: ?, defaultValue: ?) -> ?","!doc":"<p>Returns the current value for a key</p>\n"},"getProvider":{"!type":"fn() -> ?","!doc":"<p>Gets the currently configured state provider</p>\n"},"set":{"!type":"fn(key: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"},"setProvider":{"!type":"fn(stateProvider: ?) -> !this","!doc":"<p>Configures the default state provider for your application</p>\n"}}},"container":{"Container":{"prototype":{"activeItem":{"!doc":"<p>A string component id or the numeric index of the component that should be\ninitially activated within the container's layout on render.  For example,\nactiveItem: 'item-1' or activeItem: 0 (index 0 = the first item in the\ncontainer's collection).  activeItem only applies to layout styles that can\ndisplay items one at a time (like <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> and\n<a href=\"#!/api/Ext.layout.container.Fit\" rel=\"Ext.layout.container.Fit\" class=\"docClass\">Ext.layout.container.Fit</a>).</p>\n"},"anchorSize":{"!doc":"<p>Defines the anchoring size of container.\nEither a number to define the width of the container or an object with <code>width</code> and <code>height</code> fields.</p>\n"},"autoDestroy":{"!type":"bool","!doc":"<p>If true the container will automatically destroy any contained component that is removed\nfrom it, else destruction must be handled manually.</p>\n"},"bubbleEvents":{"!doc":"<p>An array of events that, when fired, should be bubbled to any parent container.\nSee Ext.util.Observable.enableBubble.</p>\n"},"defaults":{"!doc":"<p>This option is a means of applying default settings to all added items whether added\nthrough the <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> config or via the <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">add</a> or <a href=\"#!/api/Ext.container.Container-method-insert\" rel=\"Ext.container.Container-method-insert\" class=\"docClass\">insert</a> methods.</p>\n\n<p>Defaults are applied to both config objects and instantiated components conditionally\nso as not to override existing properties in the item (see Ext.applyIf).</p>\n\n<p>If the defaults option is specified as a function, then the function will be called\nusing this Container as the scope (<code>this</code> reference) and passing the added item as\nthe first parameter. Any resulting object from that call is then applied to the item\nas default properties.</p>\n\n<p>For example, to automatically apply padding to the body of each of a set of\ncontained <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a> items, you could pass:\n<code>defaults: {bodyStyle:'padding:15px'}</code>.</p>\n\n<p>Usage:</p>\n\n<pre><code>defaults: { // defaults are applied to items, not the container\n    autoScroll: true\n},\nitems: [\n    // default will not be applied here, panel1 will be autoScroll: false\n    {\n        xtype: 'panel',\n        id: 'panel1',\n        autoScroll: false\n    },\n    // this component will have autoScroll: true\n    new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n        id: 'panel2'\n    })\n]\n</code></pre>\n"},"detachOnRemove":{"!type":"bool","!doc":"<p>True to move any component to the detachedBody when the component is\nremoved from this container. This option is only applicable when the component is not destroyed while\nbeing removed, see <a href=\"#!/api/Ext.container.Container-cfg-autoDestroy\" rel=\"Ext.container.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> and <a href=\"#!/api/Ext.container.Container-method-remove\" rel=\"Ext.container.Container-method-remove\" class=\"docClass\">remove</a>. If this option is set to false, the DOM\nof the component will remain in the current place until it is explicitly moved.</p>\n"},"items":{"!doc":"<p>The MixedCollection containing all the child items of this container.</p>\n"},"referenceHolder":{"!type":"bool","!doc":"<p>If <code>true</code>, this container will be marked as being a point in the hierarchy where\nreferences to items with a specified <code>reference</code> config will be held. The container\nwill automatically become a referenceHolder if a controller is specified.</p>\n\n<p>See the introductory docs for <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> for more information\nabout references &amp; reference holders.</p>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.container.Container-method-getEl\" rel=\"Ext.container.Container-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.container.Container-method-getEl\" rel=\"Ext.container.Container-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.container.Container-cfg-renderSelectors\" rel=\"Ext.container.Container-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.container.Container-cfg-childEls\" rel=\"Ext.container.Container-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"suspendLayout":{"!type":"bool","!doc":"<p>If true, suspend calls to doLayout. Useful when batching multiple adds to a container\nand not passing them as multiple arguments or an array.</p>\n"},"ariaRole":{"!type":"string","!doc":"<p><editor-fold desc=\"Properties\"></editor></p>\n\n<hr />\n\n<p> Begin Properties</p>\n\n<hr />\n"},"isContainer":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Container, or subclass thereof.</p>\n"},"layoutCounter":{"!type":"number","!doc":"<p>The number of container layout calls made on this object.</p>\n"},"add":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.</p>\n\n<p><strong>This event bubbles:</strong> 'add' will also be fired when Component is added to any of\nthe child containers or their childern or ...</p>\n"},"afterComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"afterLayout":{"!type":"fn(layout: ?) -> !this","!doc":"<p>Invoked after the Container has laid out (and rendered if necessary)\nits child Components.</p>\n"},"attachReference":{"!type":"fn(component: ?) -> !this","!doc":"<p>Sets up a component reference.</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"cascade":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Cascades down the component/container heirarchy from this component (passed in\nthe first call), calling the specified function with each component. The scope\n(this reference) of the function call will be the scope provided or the current\ncomponent. The arguments to the function will be the args provided or the current\ncomponent. If the function returns false at any point, the cascade is stopped on\nthat branch.</p>\n"},"clearReference":{"!type":"fn(component: ?) -> !this","!doc":"<p>Clear a component reference.</p>\n"},"clearReferences":{"!type":"fn() -> !this","!doc":"<p>Invalidates the references collection. Typically called when\nremoving a container from this container, since it's difficult\nto know what references got removed.</p>\n"},"contains":{"!type":"fn(comp: ?, deep?: ?) -> bool","!doc":"<p>Determines whether the passed Component is either an immediate child of this Container,\nor whether it is a descendant.</p>\n"},"disable":{"!type":"fn() -> ?","!doc":"<p>Disables all child input fields and buttons.</p>\n"},"doLayout":{"!type":"fn() -> ?","!doc":"<p>Manually force this container's layout to be recalculated.</p>\n"},"enable":{"!type":"fn() -> ?","!doc":"<p>Enables all child input fields and buttons.</p>\n"},"getChildByElement":{"!type":"fn(el: ?, deep: ?) -> ?","!doc":"<p>Return the immediate child Component in which the passed element is located.</p>\n"},"getChildItemsToDisable":{"!type":"fn() -> ?","!doc":"<p>Gets a list of child components to enable/disable when the container is\nenabled/disabled</p>\n"},"getComponent":{"!type":"fn(comp: ?) -> ?","!doc":"<p>Examines this container's <a href=\"#!/api/Ext.container.Container-property-items\" rel=\"Ext.container.Container-property-items\" class=\"docClass\">items</a> <strong>property</strong> and gets a direct child\ncomponent of this container.</p>\n"},"getFocusEl":{"!type":"fn() -> ?","!doc":"<p>Returns the focus holder element associated with this Container. By default, this is the Container's target\nelement. Subclasses which use embedded focusable elements (such as Window and Button) should override this for use\nby the <a href=\"#!/api/Ext.container.Container-method-focus\" rel=\"Ext.container.Container-method-focus\" class=\"docClass\">focus</a> method.</p>\n"},"getLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">layout</a> instance currently associated with this Container.\nIf a layout has not been instantiated yet, that is done first</p>\n"},"getRefItems":{"!type":"fn(deep: ?) -> !this","!doc":"<p>Used by ComponentQuery, child and down to retrieve all of the items\nwhich can potentially be considered a child of this Container.</p>\n\n<p>This may be overriden by Components which have ownership of Components\nthat are not contained in the <a href=\"#!/api/Ext.container.Container-property-items\" rel=\"Ext.container.Container-property-items\" class=\"docClass\">items</a> collection.</p>\n\n<p>NOTE: IMPORTANT note for maintainers:\nItems are returned in tree traversal order. Each item is appended to the result array\nfollowed by the results of that child's getRefItems call.\nFloating child items are appended after internal child items.</p>\n"},"getReferences":{"!type":"fn() -> ?","!doc":"<p>Returns an object holding the descendants of this view keyed by their\n<code>reference</code>. This object should not be held\npast the scope of the function calling this method. It will not be valid if items\nare added or removed from this or any sub-container.</p>\n\n<p>The intended usage is shown here (assume there are 3 components with reference\nvalues of \"foo\", \"bar\" and \"baz\" at some level below this container):</p>\n\n<pre><code> onClick: function () {\n     var refs = this.getReferences();\n\n     // using \"refs\" we can access any descendant by its \"reference\"\n\n     refs.foo.getValue() + refs.bar.getValue() + refs.baz.getValue();\n }\n</code></pre>\n\n<p>If <code>this</code> component has a <code>reference</code> assigned\nto it, that is <strong>not</strong> included in this object. That reference is understood to\nbelong to the ancestor container configured as the <code>referenceHolder</code>.</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"initInheritedState":{"!type":"fn(inheritedState: ?, inheritedStateInner: ?) -> !this","!doc":"<p>Called by <code>getInherited</code> to initialize the inheritedState the first time it is\nrequested.</p>\n"},"initItems":{"!type":"fn() -> !this","!doc":"<p>This method is called to initialize the <code>items</code> collection. A derived class can\noverride this method to do any last minute manipulation of <code>items</code> and then call\nthis method using <code>callParent</code>. Upon return, the <code>items</code> will no longer be a simple\narray.</p>\n"},"insert":{"!type":"fn(index: ?, component: ?) -> ?","!doc":"<p>Inserts a Component into this Container at a specified index. Fires the\n<a href=\"#!/api/Ext.container.Container-event-beforeadd\" rel=\"Ext.container.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before inserting, then fires the <a href=\"#!/api/Ext.container.Container-event-add\" rel=\"Ext.container.Container-event-add\" class=\"docClass\">add</a>\nevent after the Component has been inserted.</p>\n"},"isAncestor":{"!type":"fn(possibleDescendant: ?) -> !this","!doc":"<p>Determines whether <strong>this Container</strong> is an ancestor of the passed Component.\nThis will return <code>true</code> if the passed Component is anywhere within the subtree\nbeneath this Container.</p>\n"},"lookupComponent":{"!type":"fn(comp: ?) -> !this"},"lookupReference":{"!type":"fn(key: ?) -> ?","!doc":"<p>Gets a reference to a child specified using the reference configuration.</p>\n"},"move":{"!type":"fn(this: ?, component: ?, prevIndex: ?, newIndex: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> has changed its ordinal position within the container.</p>\n\n<p><strong>This event bubbles:</strong> 'move' will also be fired when Component is removed from any of\nthe child containers or their children or ...</p>\n"},"moveAfter":{"!type":"fn(item: ?, after: ?) -> !this","!doc":"<p>Moves the given <code>item</code> into this container following <code>after</code>. This method will\naccount for layout-generated components like splitters and should be used instead\nof index based <code><a href=\"#!/api/Ext.container.Container-event-move\" rel=\"Ext.container.Container-event-move\" class=\"docClass\">move</a></code>. If <code>after</code> is <code>null</code> then the <code>item</code> will be the\nfirst item in this container.</p>\n"},"moveBefore":{"!type":"fn(item: ?, before: ?) -> !this","!doc":"<p>Moves the given <code>item</code> into this container in front of <code>before</code>. This method will\naccount for layout-generated components like splitters and should be used instead\nof index based <code><a href=\"#!/api/Ext.container.Container-event-move\" rel=\"Ext.container.Container-event-move\" class=\"docClass\">move</a></code>. If <code>before</code> is <code>null</code> then the <code>item</code> will be the\nlast item in this container.</p>\n"},"nextChild":{"!type":"fn(child: ?, selector?: ?) -> ?","!doc":"<p>A method to find a child component after the passed child parameter. If a selector is also provided,\nthe first child component matching the selector will be returned.</p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.container.Container-event-added\" rel=\"Ext.container.Container-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onBeforeAdd":{"!type":"fn(item: ?) -> !this","!doc":"<p>This method is invoked before adding a new child Component. It\nis passed the new Component, and may be used to modify the\nComponent, or prepare the Container in some way. Returning\nfalse aborts the add operation.</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onMove":{"!type":"fn() -> !this"},"onPosition":{"!type":"fn() -> !this","!doc":"<p>Called after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.container.Container-event-removed\" rel=\"Ext.container.Container-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"onResize":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the resize operation.</p>\n\n<p>Called when Ext.resizer.Resizer#drag event is fired.</p>\n"},"prevChild":{"!type":"fn(child: ?, selector?: ?) -> ?","!doc":"<p>A method to find a child component before the passed child parameter. If a selector is also provided,\nthe first child component matching the selector will be returned.</p>\n"},"remove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.</p>\n\n<p><strong>This event bubbles:</strong> 'remove' will also be fired when Component is removed from any of\nthe child containers or their children or ...</p>\n"},"removeAll":{"!type":"fn(autoDestroy?: ?) -> ?","!doc":"<p>Removes all components from this container.</p>\n"},"setActiveItem":{"!type":"fn(item: ?) -> ?","!doc":"<p>Sets a component as the active layout item. This only applies when using\na <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> layout.</p>\n\n<pre><code>var card1 = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {itemId: 'card-1'});\nvar card2 = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {itemId: 'card-2'});\nvar panel = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    layout: 'card',\n    items: [card1, card2]\n});\n// These are all equivalent\npanel.getLayout().setActiveItem(card2);\npanel.getLayout().setActiveItem('card-2');\npanel.getLayout().setActiveItem(1);\n</code></pre>\n"},"setLayout":{"!type":"fn(configuration: ?) -> !this","!doc":"<p>Reconfigures the initially configured <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>.</p>\n\n<p>NOTE: this method cannot be used to change the \"type\" of layout after the component\nhas been rendered to the DOM. After rendering, this method can only modify the\nexisting layout's configuration properties. The reason for this restriction is that\nmany container layouts insert special wrapping elements into the dom, and the\nframework does not currently support dynamically changing these elements once\nrendered.</p>\n"},"afterlayout":{"!type":"fn(this: ?, layout: ?, eOpts: ?)","!doc":"<p>Fires when the components in this container are arranged by the associated layout manager.</p>\n"},"beforeadd":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.\nA handler can return false to cancel the add.</p>\n"},"beforeremove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.  A handler can return\nfalse to cancel the remove.</p>\n"},"onAdd":{"!type":"fn(component: ?, position: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been added. It\nis passed the Component which has been added. This method may\nbe used to update any internal structure which may depend upon\nthe state of the child items.</p>\n"},"onRemove":{"!type":"fn(component: ?, autoDestroy: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been\nremoved. It is passed the Component which has been\nremoved. This method may be used to update any internal\nstructure which may depend upon the state of the child items.</p>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n"},"beforeRender":{"!type":"fn() -> !this"}},"!doc":"<p>Base class for any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> that may contain other Components. Containers handle the basic behavior of\ncontaining items, namely adding, inserting and removing items.</p>\n\n<p>The most commonly used Container classes are <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>, <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a> and\n<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>. If you do not need the capabilities offered by the aforementioned classes you can create a\nlightweight Container to be encapsulated by an HTML element to your specifications by using the\n<a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a> config option.</p>\n\n<p>The code below illustrates how to explicitly create a Container:</p>\n\n<pre class='inline-example '><code>// Explicitly create a Container\nExt.create('<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>', {\n    layout: {\n        type: 'hbox'\n    },\n    width: 400,\n    renderTo: Ext.getBody(),\n    border: 1,\n    style: {borderColor:'#000000', borderStyle:'solid', borderWidth:'1px'},\n    defaults: {\n        labelWidth: 80,\n        // implicitly create Container by specifying xtype\n        xtype: 'datefield',\n        flex: 1,\n        style: {\n            padding: '10px'\n        }\n    },\n    items: [{\n        xtype: 'datefield',\n        name: 'startDate',\n        fieldLabel: 'Start date'\n    },{\n        xtype: 'datefield',\n        name: 'endDate',\n        fieldLabel: 'End date'\n    }]\n});\n</code></pre>\n\n<h2>Layout</h2>\n\n<p>Container classes delegate the rendering of child Components to a layout manager class which must be configured into\nthe Container using the <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> configuration property.</p>\n\n<p>When either specifying child <code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code> of a Container, or dynamically <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">adding</a> Components to a\nContainer, remember to consider how you wish the Container to arrange those child elements, and whether those child\nelements need to be sized using one of Ext's built-in <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> schemes. By default, Containers use the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Auto</a> scheme which only renders child components, appending them one after the other\ninside the Container, and <strong>does not apply any sizing</strong> at all.</p>\n\n<p>A common mistake is when a developer neglects to specify a <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> (e.g. GridPanels or\nTreePanels are added to Containers for which no <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> has been specified). If a Container is left to\nuse the default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Auto</a> scheme, none of its child components will be resized, or changed in\nany way when the Container is resized.</p>\n\n<p>Certain layout managers allow dynamic addition of child components. Those that do include\n<a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a>, <a href=\"#!/api/Ext.layout.container.Anchor\" rel=\"Ext.layout.container.Anchor\" class=\"docClass\">Ext.layout.container.Anchor</a>, <a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>,\n<a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>, and <a href=\"#!/api/Ext.layout.container.Table\" rel=\"Ext.layout.container.Table\" class=\"docClass\">Ext.layout.container.Table</a>. For example:</p>\n\n<pre><code>//  Create the GridPanel.\nvar myNewGrid = Ext.create('<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>', {\n    store: myStore,\n    headers: myHeaders,\n    title: 'Results', // the title becomes the title of the tab\n});\n\nmyTabPanel.add(myNewGrid); // <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a> implicitly uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Card</a>\nmyTabPanel.<a href=\"#!/api/Ext.tab.Panel-method-setActiveTab\" rel=\"Ext.tab.Panel-method-setActiveTab\" class=\"docClass\">setActiveTab</a>(myNewGrid);\n</code></pre>\n\n<p>The example above adds a newly created GridPanel to a TabPanel. Note that a TabPanel uses <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> as its layout manager which means all its child items are sized to <a href=\"#!/api/Ext.layout.container.Fit\" rel=\"Ext.layout.container.Fit\" class=\"docClass\">fit</a> exactly into its client area.</p>\n\n<p><strong><em>Overnesting is a common problem</em></strong>. An example of overnesting occurs when a GridPanel is added to a TabPanel by\nwrapping the GridPanel <em>inside</em> a wrapping Panel (that has no <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> specified) and then add that\nwrapping Panel to the TabPanel. The point to realize is that a GridPanel <strong>is</strong> a Component which can be added\ndirectly to a Container. If the wrapping Panel has no <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code> configuration, then the overnested\nGridPanel will not be sized as expected.</p>\n\n<h2>References and <a href=\"#!/api/Ext.container.Container-cfg-referenceHolder\" rel=\"Ext.container.Container-cfg-referenceHolder\" class=\"docClass\">Reference Holders</a></h2>\n\n<p>Reference holders are used to keep references to child components inside a hierarchy.</p>\n\n<p>This functionality allows the connection of encapsulated references between containers\nand their child components declaratively. Simple usage:</p>\n\n<pre><code>Ext.define('Login', {\n    extend: '<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>',\n\n    // This config is not compatible with the more common \"controller\" config\n    // used to specify a ViewController for the view. When a ViewController is\n    // specified it effectively acts as the \"reference holder\" for the view. In\n    // this example we simply mark this container as the reference holder for\n    // demonstration purposes.\n    referenceHolder: true,\n\n    title: 'Login',\n    items: [{\n        xtype: 'form',\n        items: [{\n            xtype: 'textfield',\n            reference: 'username', // A named reference to be held on the referenceHolder\n            name: 'username',\n            fieldLabel: 'Username'\n        }, {\n            xtype: 'textfield',\n            reference: 'password', // A named reference to be held on the referenceHolder\n            name: 'password',\n            fieldLabel: 'Password'\n        }] \n    }] \n});\nvar w = new Login();\nconsole.log(w.lookupReference('password')); // The password field\n</code></pre>\n\n<p>Reference holders are also encapsulated, so a reference will only be put on the closest\nreference holder above it in the component hierarchy:</p>\n\n<pre><code>var ct = new <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>({\n    referenceHolder: true,\n    items: [{\n        xtype: 'container',\n        referenceHolder: true,\n        reference: 'innerCt1',\n        items: [{\n            xtype: 'component',\n            reference: 'a',\n            id: 'a1'\n        }, {\n            xtype: 'component',\n            reference: 'b',\n            id: 'b1'\n        }]\n    }, {\n        xtype: 'container',\n        referenceHolder: true,\n        reference: 'innerCt2',\n        items: [{\n            xtype: 'component',\n            reference: 'a',\n            id: 'a2'\n        }, {\n            xtype: 'component',\n            reference: 'b',\n            id: 'b2'\n        }]\n    }]\n});\n// The main container will not have references to a/b, each innerCt will\nconsole.log(ct.lookupReference('a'), ct.lookupReference('b'));\nvar inner1 = ct.lookupReference('innerCt1');\nvar inner2 = ct.lookupReference('innerCt2');\n\nconsole.log(inner1.lookupReference('a').id, inner1.lookupReference('b').id);\nconsole.log(inner2.lookupReference('a').id, inner2.lookupReference('b').id);\n</code></pre>\n\n<p>If the view has a controller attached, it will automatically become a <a href=\"#!/api/Ext.container.Container-cfg-referenceHolder\" rel=\"Ext.container.Container-cfg-referenceHolder\" class=\"docClass\">referenceHolder</a>.\nReferences will be available in both the view and the controller:</p>\n\n<pre><code>Ext.define('ProfileController', {\n    extend: '<a href=\"#!/api/Ext.app.ViewController\" rel=\"Ext.app.ViewController\" class=\"docClass\">Ext.app.ViewController</a>',\n    alias: 'controller.profile',\n\n    init: function() {\n        console.log(this.lookupReference('firstName'));\n    }\n});\n\nExt.define('Profile', {\n    extend: '<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>',\n    controller: 'profile',\n    items: [{\n        xtype: 'textfield',\n        reference: 'firstName',\n        fieldLabel: 'First Name'\n    }]\n});\n\nnew Profile(); \n</code></pre>\n\n<h2>Events &amp; defaultListenerScope</h2>\n\n<p>Events can use the default listener scope to determine at runtime the appropriate place\nto fire. This allows for declarative binding of events in a useful way:</p>\n\n<pre><code>Ext.define('MyView', {\n    extend: '<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>',\n    defaultListenerScope: true,\n    referenceHolder: true,\n    items: [{\n        xtype: 'textfield',\n        reference: 'myfield'\n    }, {\n        xtype: 'button',\n        text: 'Set to A',\n        listeners: {\n            click: 'onButtonAClick'\n        }\n    }, {\n        xtype: 'button',\n        text: 'Set to B',\n        listeners: {\n            click: 'onButtonBClick'\n        }\n    }],\n\n    onButtonAClick: function() {\n        this.lookupReference('myfield').setValue('A');\n    },\n\n    onButtonBClick: function() {\n        this.lookupReference('myfield').setValue('B');\n    }\n});\n</code></pre>\n\n<p>Like <a href=\"#!/api/Ext.container.Container-cfg-referenceHolder\" rel=\"Ext.container.Container-cfg-referenceHolder\" class=\"docClass\">referenceHolder</a>, the defaultListenerScope is encapsulated, the scope will\nbe resolved at the closest defaultListenerScope above it in the component hierarchy:</p>\n\n<pre><code>var ct = new <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>({\n    defaultListenerScope: true,\n    onCustomEvent: function() {\n        console.log('Outer called'); // Will NOT be called\n    },\n    items: [{\n        xtype: 'container',\n        defaultListenerScope: true,\n        onCustomEvent: function() {\n            console.log('Inner called'); // Will be called\n        },\n        items: [{\n            xtype: 'component',\n            itemId: 'child',\n            listeners: {\n                customevent: 'onCustomEvent'\n            }\n        }]\n    }]\n});\n// The main container will not have references to a/b, each innerCt will\nconsole.log(ct.lookupReference('a'), ct.lookupReference('b'));\nvar inner1 = ct.lookupReference('innerCt1');\nvar inner2 = ct.lookupReference('innerCt2');\n\nconsole.log(inner1.lookupReference('a').id, inner1.lookupReference('b').id);\nconsole.log(inner2.lookupReference('a').id, inner2.lookupReference('b').id);\n</code></pre>\n\n<p>Similar to references, if a <a href=\"#!/api/Ext.app.ViewController\" rel=\"Ext.app.ViewController\" class=\"docClass\">Ext.app.ViewController</a> is attached to this view, it becomes\nthe defaultListenerScope, which means un-scoped, late bound events will be directed to the\ncontroller. This is powerful as it allows views to be totally declarative:</p>\n\n<pre><code>Ext.define('MyApp.controller.Login', {\n    extend : '<a href=\"#!/api/Ext.app.ViewController\" rel=\"Ext.app.ViewController\" class=\"docClass\">Ext.app.ViewController</a>',\n    alias : 'controller.login',\n\n    init: function() {\n        this.sendCount = 0;    \n    },\n\n    onLoginClick : function(btn) {\n        this.login();\n    },\n\n    onFieldSpecialKey : function(field, e) {\n        if (e.getKey() === e.ENTER) {\n           this.login();\n        }\n    },\n\n    login : function() {\n       var form = this.lookupReference('form');\n        this.lookupReference('error').hide();\n        if (form.isValid()) {\n            console.log('Do the login!');\n            // Server responded...\n            if (++this.sendCount % 2 === 0) {\n                this.onServerSuccess();\n            } else {\n                this.onServerFailure();\n            }\n        }\n    },\n\n    onServerSuccess: function() {\n        // Proceed   \n        console.log('All good');\n    },\n\n    onServerFailure: function() {\n        var error = this.lookupReference('error');\n        error.update('Invalid username/password');\n        error.show();\n    }\n});\n\nExt.define('MyApp.view.Login', {\n    extend : '<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>',\n    controller : 'login',\n    referenceHolder: true,\n\n    title : 'Login',\n    width : 400,\n\n    items : [{\n        xtype : 'form',\n        reference : 'form',\n        border : false,\n        bodyPadding : 10,\n        defaultType : 'textfield',\n        defaults : {\n            anchor : '90%',\n            allowBlank : false,\n            enableKeyEvents : true\n        },\n        items : [{\n            xtype: 'component',\n            reference: 'error',\n            hidden: true,\n            margin: '0 0 10 0',\n            style: 'color: red;'\n        }, {\n            name : 'username',\n            fieldLabel : 'Username',\n            reference : 'username',\n            listeners : {\n                specialkey : 'onFieldSpecialKey'\n            }\n        }, {\n            name : 'password',\n            fieldLabel : 'Password',\n            reference : 'password',\n            inputType : 'password',\n            listeners : {\n                specialkey : 'onFieldSpecialKey'\n            }\n        }]\n    }],\n    buttons : ['-&gt;', {\n       text : 'Login',\n        listeners : {\n            click : 'onLoginClick'\n        }\n    }]\n});\n</code></pre>\n\n<h2>Adding via remote configuration</h2>\n\n<p>A server side script can be used to add Components which are generated dynamically on the server. An example of\nadding a GridPanel to a TabPanel where the GridPanel is generated by the server based on certain parameters:</p>\n\n<pre><code>// execute an Ajax request to invoke server side script:\nExt.Ajax.request({\n    url: 'gen-invoice-grid.php',\n    // send additional parameters to instruct server script\n    params: {\n        startDate: Ext.getCmp('start-date').getValue(),\n        endDate: Ext.getCmp('end-date').getValue()\n    },\n    // process the response object to add it to the TabPanel:\n    success: function(xhr) {\n        var newComponent = eval(xhr.responseText); // see discussion below\n        myTabPanel.add(newComponent); // add the component to the TabPanel\n        myTabPanel.setActiveTab(newComponent);\n    },\n    failure: function() {\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>(\"Grid create failed\", \"Server communication failure\");\n    }\n});\n</code></pre>\n\n<p>The server script needs to return a JSON representation of a configuration object, which, when decoded will return a\nconfig object with an <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a>. The server might return the following JSON:</p>\n\n<pre><code>{\n    \"xtype\": 'grid',\n    \"title\": 'Invoice Report',\n    \"store\": {\n        \"model\": 'Invoice',\n        \"proxy\": {\n            \"type\": 'ajax',\n            \"url\": 'get-invoice-data.php',\n            \"reader\": {\n                \"type\": 'json'\n                \"record\": 'transaction',\n                \"idProperty\": 'id',\n                \"totalRecords\": 'total'\n            })\n        },\n        \"autoLoad\": {\n            \"params\": {\n                \"startDate\": '01/01/2008',\n                \"endDate\": '01/31/2008'\n            }\n        }\n    },\n    \"headers\": [\n        {\"header\": \"Customer\", \"width\": 250, \"dataIndex\": 'customer', \"sortable\": true},\n        {\"header\": \"Invoice Number\", \"width\": 120, \"dataIndex\": 'invNo', \"sortable\": true},\n        {\"header\": \"Invoice Date\", \"width\": 100, \"dataIndex\": 'date', \"renderer\": Ext.util.Format.dateRenderer('M d, y'), \"sortable\": true},\n        {\"header\": \"Value\", \"width\": 120, \"dataIndex\": 'value', \"renderer\": 'usMoney', \"sortable\": true}\n    ]\n}\n</code></pre>\n\n<p>When the above code fragment is passed through the <code>eval</code> function in the success handler of the Ajax request, the\nresult will be a config object which, when added to a Container, will cause instantiation of a GridPanel. <strong>Be sure\nthat the Container is configured with a layout which sizes and positions the child items to your requirements.</strong></p>\n\n<p><strong>Note:</strong> since the code above is <em>generated</em> by a server script, the <code>autoLoad</code> params for the Store, the user's\npreferred date format, the metadata to allow generation of the Model layout, and the ColumnModel can all be generated\ninto the code since these are all known on the server.</p>\n","!type":"fn(config: ?)","activeItem":{"!doc":"<p>A string component id or the numeric index of the component that should be\ninitially activated within the container's layout on render.  For example,\nactiveItem: 'item-1' or activeItem: 0 (index 0 = the first item in the\ncontainer's collection).  activeItem only applies to layout styles that can\ndisplay items one at a time (like <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> and\n<a href=\"#!/api/Ext.layout.container.Fit\" rel=\"Ext.layout.container.Fit\" class=\"docClass\">Ext.layout.container.Fit</a>).</p>\n"},"anchorSize":{"!doc":"<p>Defines the anchoring size of container.\nEither a number to define the width of the container or an object with <code>width</code> and <code>height</code> fields.</p>\n"},"autoDestroy":{"!type":"bool","!doc":"<p>If true the container will automatically destroy any contained component that is removed\nfrom it, else destruction must be handled manually.</p>\n"},"bubbleEvents":{"!doc":"<p>An array of events that, when fired, should be bubbled to any parent container.\nSee Ext.util.Observable.enableBubble.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"defaults":{"!doc":"<p>This option is a means of applying default settings to all added items whether added\nthrough the <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> config or via the <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">add</a> or <a href=\"#!/api/Ext.container.Container-method-insert\" rel=\"Ext.container.Container-method-insert\" class=\"docClass\">insert</a> methods.</p>\n\n<p>Defaults are applied to both config objects and instantiated components conditionally\nso as not to override existing properties in the item (see Ext.applyIf).</p>\n\n<p>If the defaults option is specified as a function, then the function will be called\nusing this Container as the scope (<code>this</code> reference) and passing the added item as\nthe first parameter. Any resulting object from that call is then applied to the item\nas default properties.</p>\n\n<p>For example, to automatically apply padding to the body of each of a set of\ncontained <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a> items, you could pass:\n<code>defaults: {bodyStyle:'padding:15px'}</code>.</p>\n\n<p>Usage:</p>\n\n<pre><code>defaults: { // defaults are applied to items, not the container\n    autoScroll: true\n},\nitems: [\n    // default will not be applied here, panel1 will be autoScroll: false\n    {\n        xtype: 'panel',\n        id: 'panel1',\n        autoScroll: false\n    },\n    // this component will have autoScroll: true\n    new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n        id: 'panel2'\n    })\n]\n</code></pre>\n"},"detachOnRemove":{"!type":"bool","!doc":"<p>True to move any component to the detachedBody when the component is\nremoved from this container. This option is only applicable when the component is not destroyed while\nbeing removed, see <a href=\"#!/api/Ext.container.Container-cfg-autoDestroy\" rel=\"Ext.container.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> and <a href=\"#!/api/Ext.container.Container-method-remove\" rel=\"Ext.container.Container-method-remove\" class=\"docClass\">remove</a>. If this option is set to false, the DOM\nof the component will remain in the current place until it is explicitly moved.</p>\n"},"items":{"!doc":"<p>The MixedCollection containing all the child items of this container.</p>\n"},"referenceHolder":{"!type":"bool","!doc":"<p>If <code>true</code>, this container will be marked as being a point in the hierarchy where\nreferences to items with a specified <code>reference</code> config will be held. The container\nwill automatically become a referenceHolder if a controller is specified.</p>\n\n<p>See the introductory docs for <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> for more information\nabout references &amp; reference holders.</p>\n"},"suspendLayout":{"!type":"bool","!doc":"<p>If true, suspend calls to doLayout. Useful when batching multiple adds to a container\nand not passing them as multiple arguments or an array.</p>\n"},"isContainer":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Container, or subclass thereof.</p>\n"},"layoutCounter":{"!type":"number","!doc":"<p>The number of container layout calls made on this object.</p>\n"},"add":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.</p>\n\n<p><strong>This event bubbles:</strong> 'add' will also be fired when Component is added to any of\nthe child containers or their childern or ...</p>\n"},"afterComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"afterLayout":{"!type":"fn(layout: ?) -> !this","!doc":"<p>Invoked after the Container has laid out (and rendered if necessary)\nits child Components.</p>\n"},"attachReference":{"!type":"fn(component: ?) -> !this","!doc":"<p>Sets up a component reference.</p>\n"},"cascade":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Cascades down the component/container heirarchy from this component (passed in\nthe first call), calling the specified function with each component. The scope\n(this reference) of the function call will be the scope provided or the current\ncomponent. The arguments to the function will be the args provided or the current\ncomponent. If the function returns false at any point, the cascade is stopped on\nthat branch.</p>\n"},"clearReference":{"!type":"fn(component: ?) -> !this","!doc":"<p>Clear a component reference.</p>\n"},"clearReferences":{"!type":"fn() -> !this","!doc":"<p>Invalidates the references collection. Typically called when\nremoving a container from this container, since it's difficult\nto know what references got removed.</p>\n"},"contains":{"!type":"fn(comp: ?, deep?: ?) -> bool","!doc":"<p>Determines whether the passed Component is either an immediate child of this Container,\nor whether it is a descendant.</p>\n"},"disable":{"!type":"fn() -> ?","!doc":"<p>Disables all child input fields and buttons.</p>\n"},"doLayout":{"!type":"fn() -> ?","!doc":"<p>Manually force this container's layout to be recalculated.</p>\n"},"enable":{"!type":"fn() -> ?","!doc":"<p>Enables all child input fields and buttons.</p>\n"},"getChildByElement":{"!type":"fn(el: ?, deep: ?) -> ?","!doc":"<p>Return the immediate child Component in which the passed element is located.</p>\n"},"getChildItemsToDisable":{"!type":"fn() -> ?","!doc":"<p>Gets a list of child components to enable/disable when the container is\nenabled/disabled</p>\n"},"getLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">layout</a> instance currently associated with this Container.\nIf a layout has not been instantiated yet, that is done first</p>\n"},"getReferences":{"!type":"fn() -> ?","!doc":"<p>Returns an object holding the descendants of this view keyed by their\n<code>reference</code>. This object should not be held\npast the scope of the function calling this method. It will not be valid if items\nare added or removed from this or any sub-container.</p>\n\n<p>The intended usage is shown here (assume there are 3 components with reference\nvalues of \"foo\", \"bar\" and \"baz\" at some level below this container):</p>\n\n<pre><code> onClick: function () {\n     var refs = this.getReferences();\n\n     // using \"refs\" we can access any descendant by its \"reference\"\n\n     refs.foo.getValue() + refs.bar.getValue() + refs.baz.getValue();\n }\n</code></pre>\n\n<p>If <code>this</code> component has a <code>reference</code> assigned\nto it, that is <strong>not</strong> included in this object. That reference is understood to\nbelong to the ancestor container configured as the <code>referenceHolder</code>.</p>\n"},"initInheritedState":{"!type":"fn(inheritedState: ?, inheritedStateInner: ?) -> !this","!doc":"<p>Called by <code>getInherited</code> to initialize the inheritedState the first time it is\nrequested.</p>\n"},"insert":{"!type":"fn(index: ?, component: ?) -> ?","!doc":"<p>Inserts a Component into this Container at a specified index. Fires the\n<a href=\"#!/api/Ext.container.Container-event-beforeadd\" rel=\"Ext.container.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before inserting, then fires the <a href=\"#!/api/Ext.container.Container-event-add\" rel=\"Ext.container.Container-event-add\" class=\"docClass\">add</a>\nevent after the Component has been inserted.</p>\n"},"isAncestor":{"!type":"fn(possibleDescendant: ?) -> !this","!doc":"<p>Determines whether <strong>this Container</strong> is an ancestor of the passed Component.\nThis will return <code>true</code> if the passed Component is anywhere within the subtree\nbeneath this Container.</p>\n"},"lookupComponent":{"!type":"fn(comp: ?) -> !this"},"lookupReference":{"!type":"fn(key: ?) -> ?","!doc":"<p>Gets a reference to a child specified using the reference configuration.</p>\n"},"move":{"!type":"fn(this: ?, component: ?, prevIndex: ?, newIndex: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> has changed its ordinal position within the container.</p>\n\n<p><strong>This event bubbles:</strong> 'move' will also be fired when Component is removed from any of\nthe child containers or their children or ...</p>\n"},"moveAfter":{"!type":"fn(item: ?, after: ?) -> !this","!doc":"<p>Moves the given <code>item</code> into this container following <code>after</code>. This method will\naccount for layout-generated components like splitters and should be used instead\nof index based <code><a href=\"#!/api/Ext.container.Container-event-move\" rel=\"Ext.container.Container-event-move\" class=\"docClass\">move</a></code>. If <code>after</code> is <code>null</code> then the <code>item</code> will be the\nfirst item in this container.</p>\n"},"moveBefore":{"!type":"fn(item: ?, before: ?) -> !this","!doc":"<p>Moves the given <code>item</code> into this container in front of <code>before</code>. This method will\naccount for layout-generated components like splitters and should be used instead\nof index based <code><a href=\"#!/api/Ext.container.Container-event-move\" rel=\"Ext.container.Container-event-move\" class=\"docClass\">move</a></code>. If <code>before</code> is <code>null</code> then the <code>item</code> will be the\nlast item in this container.</p>\n"},"nextChild":{"!type":"fn(child: ?, selector?: ?) -> ?","!doc":"<p>A method to find a child component after the passed child parameter. If a selector is also provided,\nthe first child component matching the selector will be returned.</p>\n"},"onAdd":{"!type":"fn(component: ?, position: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been added. It\nis passed the Component which has been added. This method may\nbe used to update any internal structure which may depend upon\nthe state of the child items.</p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.container.Container-event-added\" rel=\"Ext.container.Container-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onBeforeAdd":{"!type":"fn(item: ?) -> !this","!doc":"<p>This method is invoked before adding a new child Component. It\nis passed the new Component, and may be used to modify the\nComponent, or prepare the Container in some way. Returning\nfalse aborts the add operation.</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onMove":{"!type":"fn() -> !this"},"onPosition":{"!type":"fn() -> !this","!doc":"<p>Called after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n"},"onRemove":{"!type":"fn(component: ?, autoDestroy: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been\nremoved. It is passed the Component which has been\nremoved. This method may be used to update any internal\nstructure which may depend upon the state of the child items.</p>\n"},"onResize":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the resize operation.</p>\n\n<p>Called when Ext.resizer.Resizer#drag event is fired.</p>\n"},"prevChild":{"!type":"fn(child: ?, selector?: ?) -> ?","!doc":"<p>A method to find a child component before the passed child parameter. If a selector is also provided,\nthe first child component matching the selector will be returned.</p>\n"},"remove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.</p>\n\n<p><strong>This event bubbles:</strong> 'remove' will also be fired when Component is removed from any of\nthe child containers or their children or ...</p>\n"},"removeAll":{"!type":"fn(autoDestroy?: ?) -> ?","!doc":"<p>Removes all components from this container.</p>\n"},"setActiveItem":{"!type":"fn(item: ?) -> ?","!doc":"<p>Sets a component as the active layout item. This only applies when using\na <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a> layout.</p>\n\n<pre><code>var card1 = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {itemId: 'card-1'});\nvar card2 = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {itemId: 'card-2'});\nvar panel = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    layout: 'card',\n    items: [card1, card2]\n});\n// These are all equivalent\npanel.getLayout().setActiveItem(card2);\npanel.getLayout().setActiveItem('card-2');\npanel.getLayout().setActiveItem(1);\n</code></pre>\n"},"setLayout":{"!type":"fn(configuration: ?) -> !this","!doc":"<p>Reconfigures the initially configured <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>.</p>\n\n<p>NOTE: this method cannot be used to change the \"type\" of layout after the component\nhas been rendered to the DOM. After rendering, this method can only modify the\nexisting layout's configuration properties. The reason for this restriction is that\nmany container layouts insert special wrapping elements into the dom, and the\nframework does not currently support dynamically changing these elements once\nrendered.</p>\n"},"afterlayout":{"!type":"fn(this: ?, layout: ?, eOpts: ?)","!doc":"<p>Fires when the components in this container are arranged by the associated layout manager.</p>\n"},"beforeadd":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.\nA handler can return false to cancel the add.</p>\n"},"beforeremove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.  A handler can return\nfalse to cancel the remove.</p>\n"}},"ButtonGroup":{"!doc":"<p>Provides a container for arranging a group of related Buttons in a tabular manner.</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    title: 'Panel with ButtonGroup',\n    width: 300,\n    height:200,\n    renderTo: document.body,\n    bodyPadding: 10,\n    html: 'HTML Panel Content',\n    tbar: [{\n        xtype: 'buttongroup',\n        columns: 3,\n        title: 'Clipboard',\n        items: [{\n            text: 'Paste',\n            scale: 'large',\n            rowspan: 3,\n            iconCls: 'add',\n            iconAlign: 'top',\n            cls: 'btn-as-arrow'\n        },{\n            xtype:'splitbutton',\n            text: 'Menu Button',\n            scale: 'large',\n            rowspan: 3,\n            iconCls: 'add',\n            iconAlign: 'top',\n            arrowAlign:'bottom',\n            menu: [{ text: 'Menu Item 1' }]\n        },{\n            xtype:'splitbutton', text: 'Cut', iconCls: 'add16', menu: [{text: 'Cut Menu Item'}]\n        },{\n            text: 'Copy', iconCls: 'add16'\n        },{\n            text: 'Format', iconCls: 'add16'\n        }]\n    }]\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"animCollapse":{"!type":"bool"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"closable":{"!type":"bool"},"collapseMode":{"!type":"bool"},"collapsible":{"!type":"bool"},"columns":{"!type":"number","!doc":"<p>The <code>columns</code> configuration property passed to the <a href=\"#!/api/Ext.container.ButtonGroup-cfg-layout\" rel=\"Ext.container.ButtonGroup-cfg-layout\" class=\"docClass\">configured layout manager</a>.\nSee <a href=\"#!/api/Ext.layout.container.Table-cfg-columns\" rel=\"Ext.layout.container.Table-cfg-columns\" class=\"docClass\">Ext.layout.container.Table.columns</a>.</p>\n"},"defaultButtonUI":{"!type":"string","!doc":"<p>A default <a href=\"#!/api/Ext.Component-cfg-ui\" rel=\"Ext.Component-cfg-ui\" class=\"docClass\">ui</a> to use for <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Button</a> items</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"frame":{"!type":"bool","!doc":"<p>True to apply a frame to the panel.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.container.ButtonGroup-cfg-items\" rel=\"Ext.container.ButtonGroup-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"tools":{},"ariaRole":{"!type":"string","!doc":"<p><editor-fold desc=\"Properties\"></editor></p>\n\n<hr />\n\n<p> Begin Properties</p>\n\n<hr />\n"},"noTitleCls":{"!type":"string"},"privates":{"!doc":"<hr />\n\n<p> End Methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n"},"titleAlign":{"!type":"string"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"onBeforeAdd":{"!type":"fn(component: ?) -> !this","!doc":"<p>private</p>\n"}}},"DockingContainer":{"prototype":{"defaultDockWeights":{"!doc":"<p>This object holds the default weights applied to dockedItems that have no weight. These start with a\nweight of 1, to allow negative weights to insert before top items and are odd numbers\nso that even weights can be used to get between different dock orders.</p>\n\n<p>To make default docking order match border layout, do this:</p>\n\n<pre><code> Ext.panel.Panel.prototype.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };\n</code></pre>\n\n<p>Changing these defaults as above or individually on this object will effect all Panels.\nTo change the defaults on a single panel, you should replace the entire object:</p>\n\n<pre><code> initComponent: function () {\n     // NOTE: Don't change members of defaultDockWeights since the object is shared.\n     this.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };\n\n     this.callParent();\n }\n</code></pre>\n\n<p>To change only one of the default values, you do this:</p>\n\n<pre><code> initComponent: function () {\n     // NOTE: Don't change members of defaultDockWeights since the object is shared.\n     this.defaultDockWeights = Ext.applyIf({ top: 10 }, this.defaultDockWeights);\n\n     this.callParent();\n }\n</code></pre>\n"},"dockOrder":{"!doc":"<p>Values to decide which side of the body element docked items must go\nThis overides any weight. A left/top will <em>always</em> sort before a right/bottom\nregardless of any weight value. Weights sort at either side of the \"body\" dividing point.</p>\n"},"horizontalDocks":{"!type":"number","!doc":"<p>Number of dock 'left' and 'right' items.</p>\n"},"isDockingContainer":{"!type":"bool","!doc":"<p>End Definitions</p>\n"},"addDocked":{"!type":"fn(items: ?, pos?: ?) -> ?","!doc":"<p>Adds docked item(s) to the container.</p>\n"},"destroyDockedItems":{"!type":"fn() -> !this"},"doRenderDockedItems":{"!type":"fn(out: ?, renderData: ?, after: ?) -> !this"},"getDockedComponent":{"!type":"fn(comp: ?) -> ?","!doc":"<p>Finds a docked component by id, itemId or position. Also see <a href=\"#!/api/Ext.container.DockingContainer-method-getDockedItems\" rel=\"Ext.container.DockingContainer-method-getDockedItems\" class=\"docClass\">getDockedItems</a></p>\n"},"getDockedItems":{"!type":"fn(selector: ?, beforeBody: ?) -> ?","!doc":"<p>Retrieves an array of all currently docked Components.</p>\n\n<p>For example to find a toolbar that has been docked at top:</p>\n\n<pre><code>panel.getDockedItems('toolbar[dock=\"top\"]');\n</code></pre>\n"},"getDockingRefItems":{"!type":"fn(deep: ?, containerItems: ?) -> !this"},"initDockingItems":{"!type":"fn() -> !this"},"insertDocked":{"!type":"fn(pos: ?, items: ?) -> !this","!doc":"<p>Inserts docked item(s) to the panel at the indicated position.</p>\n"},"moveDocked":{"!type":"fn(item: ?, side: ?) -> !this","!doc":"<p>Moves a docked item to a different side.</p>\n"},"onDockedAdd":{"!type":"fn(component: ?) -> !this","!doc":"<p>Invoked after a docked item is added to the Panel.</p>\n"},"onDockedRemove":{"!type":"fn(component: ?) -> !this","!doc":"<p>Invoked after a docked item is removed from the Panel.</p>\n"},"removeDocked":{"!type":"fn(item: ?, autoDestroy?: ?) -> !this","!doc":"<p>Removes the docked item from the panel.</p>\n"},"setupDockingRenderTpl":{"!type":"fn(renderTpl: ?) -> !this"},"dockedadd":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted as a docked item.</p>\n"},"dockedremove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires when any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the docked items.</p>\n"}},"defaultDockWeights":{"!doc":"<p>This object holds the default weights applied to dockedItems that have no weight. These start with a\nweight of 1, to allow negative weights to insert before top items and are odd numbers\nso that even weights can be used to get between different dock orders.</p>\n\n<p>To make default docking order match border layout, do this:</p>\n\n<pre><code> Ext.panel.Panel.prototype.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };\n</code></pre>\n\n<p>Changing these defaults as above or individually on this object will effect all Panels.\nTo change the defaults on a single panel, you should replace the entire object:</p>\n\n<pre><code> initComponent: function () {\n     // NOTE: Don't change members of defaultDockWeights since the object is shared.\n     this.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };\n\n     this.callParent();\n }\n</code></pre>\n\n<p>To change only one of the default values, you do this:</p>\n\n<pre><code> initComponent: function () {\n     // NOTE: Don't change members of defaultDockWeights since the object is shared.\n     this.defaultDockWeights = Ext.applyIf({ top: 10 }, this.defaultDockWeights);\n\n     this.callParent();\n }\n</code></pre>\n"},"dockOrder":{"!doc":"<p>Values to decide which side of the body element docked items must go\nThis overides any weight. A left/top will <em>always</em> sort before a right/bottom\nregardless of any weight value. Weights sort at either side of the \"body\" dividing point.</p>\n"},"horizontalDocks":{"!type":"number","!doc":"<p>Number of dock 'left' and 'right' items.</p>\n"},"isDockingContainer":{"!type":"bool","!doc":"<p>End Definitions</p>\n"},"addDocked":{"!type":"fn(items: ?, pos?: ?) -> ?","!doc":"<p>Adds docked item(s) to the container.</p>\n"},"destroyDockedItems":{"!type":"fn() -> !this"},"doRenderDockedItems":{"!type":"fn(out: ?, renderData: ?, after: ?) -> !this"},"getDockedComponent":{"!type":"fn(comp: ?) -> ?","!doc":"<p>Finds a docked component by id, itemId or position. Also see <a href=\"#!/api/Ext.container.DockingContainer-method-getDockedItems\" rel=\"Ext.container.DockingContainer-method-getDockedItems\" class=\"docClass\">getDockedItems</a></p>\n"},"getDockedItems":{"!type":"fn(selector: ?, beforeBody: ?) -> ?","!doc":"<p>Retrieves an array of all currently docked Components.</p>\n\n<p>For example to find a toolbar that has been docked at top:</p>\n\n<pre><code>panel.getDockedItems('toolbar[dock=\"top\"]');\n</code></pre>\n"},"getDockingRefItems":{"!type":"fn(deep: ?, containerItems: ?) -> !this"},"initDockingItems":{"!type":"fn() -> !this"},"insertDocked":{"!type":"fn(pos: ?, items: ?) -> !this","!doc":"<p>Inserts docked item(s) to the panel at the indicated position.</p>\n"},"moveDocked":{"!type":"fn(item: ?, side: ?) -> !this","!doc":"<p>Moves a docked item to a different side.</p>\n"},"onDockedAdd":{"!type":"fn(component: ?) -> !this","!doc":"<p>Invoked after a docked item is added to the Panel.</p>\n"},"onDockedRemove":{"!type":"fn(component: ?) -> !this","!doc":"<p>Invoked after a docked item is removed from the Panel.</p>\n"},"removeDocked":{"!type":"fn(item: ?, autoDestroy?: ?) -> !this","!doc":"<p>Removes the docked item from the panel.</p>\n"},"setupDockingRenderTpl":{"!type":"fn(renderTpl: ?) -> !this"},"dockedadd":{"!type":"fn(this: ?, component: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted as a docked item.</p>\n"},"dockedremove":{"!type":"fn(this: ?, component: ?, eOpts: ?)","!doc":"<p>Fires when any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the docked items.</p>\n"}},"Monitor":{"!doc":"<p>This is a utility class for being able to track all items of a particular type\ninside any level at a container. This can be used in favour of bubbling add/remove events\nwhich can add a large perf cost when implemented globally</p>\n","!type":"fn(config: ?)","prototype":{"addHandler":{},"disabled":{"!type":"number"},"invalidateHandler":{},"removeHandler":{},"scope":{},"selector":{"!type":"string"},"target":{},"bind":{"!type":"fn(target: ?) -> !this"},"disable":{"!type":"fn() -> !this"},"enable":{"!type":"fn() -> !this"},"getItems":{"!type":"fn() -> !this"},"handleAdd":{"!type":"fn(ct: ?, comp: ?) -> !this"},"handleRemove":{"!type":"fn(ct: ?, comp: ?) -> !this"},"invalidateItems":{"!type":"fn(triggerHandler: ?) -> !this"},"onContainerAdd":{"!type":"fn(ct: ?, preventChildren: ?) -> !this"},"onContainerRemove":{"!type":"fn(ct: ?, comp: ?) -> !this"},"onItemAdd":{"!type":"fn(ct: ?, comp: ?) -> !this"},"onItemRemove":{"!type":"fn(ct: ?, comp: ?) -> !this"},"removeCtListeners":{"!type":"fn(comp: ?) -> !this"},"unbind":{"!type":"fn() -> !this"}}},"Viewport":{"!doc":"<p>A specialized container representing the viewable application area (the browser viewport).</p>\n\n<p>The Viewport renders itself to the document body, and automatically sizes itself to the size of\nthe browser viewport and manages window resizing. There may only be one Viewport created\nin a page.</p>\n\n<p>Like any <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>, a Viewport will only perform sizing and positioning\non its child Components if you configure it with a <a href=\"#!/api/Ext.container.Viewport-cfg-layout\" rel=\"Ext.container.Viewport-cfg-layout\" class=\"docClass\">layout</a>.</p>\n\n<p>A Common layout used with Viewports is <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, but if the\nrequired layout is simpler, a different layout should be chosen.</p>\n\n<p>For example, to simply make a single child item occupy all available space, use\n<a href=\"#!/api/Ext.layout.container.Fit\" rel=\"Ext.layout.container.Fit\" class=\"docClass\">fit layout</a>.</p>\n\n<p>To display one \"active\" item at full size from a choice of several child items, use\n<a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">card layout</a>.</p>\n\n<p>Inner layouts are available because all <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Panel</a>s\nadded to the Viewport, either through its <a href=\"#!/api/Ext.container.Viewport-cfg-items\" rel=\"Ext.container.Viewport-cfg-items\" class=\"docClass\">items</a>, or the <a href=\"#!/api/Ext.container.Viewport-method-add\" rel=\"Ext.container.Viewport-method-add\" class=\"docClass\">add</a>\nmethod of any of its child Panels may themselves have a layout.</p>\n\n<p>The Viewport does not provide scrolling, so child Panels within the Viewport should provide\nfor scrolling if needed using the <a href=\"#!/api/Ext.container.Viewport-cfg-autoScroll\" rel=\"Ext.container.Viewport-cfg-autoScroll\" class=\"docClass\">autoScroll</a> config.</p>\n\n<p>An example showing a classic application border layout:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>', {\n    layout: 'border',\n    items: [{\n        region: 'north',\n        html: '&lt;h1 class=\"x-panel-header\"&gt;Page Title&lt;/h1&gt;',\n        border: false,\n        margin: '0 0 5 0'\n    }, {\n        region: 'west',\n        collapsible: true,\n        title: 'Navigation',\n        width: 150\n        // could use a TreePanel or AccordionLayout for navigational items\n    }, {\n        region: 'south',\n        title: 'South Panel',\n        collapsible: true,\n        html: 'Information goes here',\n        split: true,\n        height: 100,\n        minHeight: 100\n    }, {\n        region: 'east',\n        title: 'East Panel',\n        collapsible: true,\n        split: true,\n        width: 150\n    }, {\n        region: 'center',\n        xtype: 'tabpanel', // TabPanel itself has no title\n        activeTab: 0,      // First tab active by default\n        items: {\n            title: 'Default Tab',\n            html: 'The first tab\\'s content. Others may be added dynamically'\n        }\n    }]\n});\n</code></pre>\n\n<p>Alternatively you can turn any normal Container (or Component) into a Viewport using\nthe <code><a href=\"#!/api/Ext.plugin.Viewport\" rel=\"Ext.plugin.Viewport\" class=\"docClass\">viewport plugin</a></code>.</p>\n","!type":"fn(config: ?)","prototype":{"allowDomMove":{"!type":"bool"},"height":{"!type":"number","!doc":"<p>Sets itself to viewport width.</p>\n"},"maxUserScale":{"!type":"number","!doc":"<p>The maximum zoom scale. Only applicable for touch devices. Set this to 1 to\ndisable zooming.</p>\n"},"renderTo":{"!doc":"<p>Always renders to document body.</p>\n"},"width":{"!type":"number","!doc":"<p>Sets itself to viewport height.</p>\n"},"isViewport":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Viewport, or subclass thereof.</p>\n"}}}},"ComponentLoader":{"!doc":"<p>This class is used to load content via Ajax into a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. In general\nthis class will not be instanced directly, rather a loader configuration will be passed to the\nconstructor of the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n\n<h2>HTML Renderer</h2>\n\n<p>By default, the content loaded will be processed as raw html. The response text\nfrom the request is taken and added to the component. This can be used in\nconjunction with the <a href=\"#!/api/Ext.ComponentLoader-cfg-scripts\" rel=\"Ext.ComponentLoader-cfg-scripts\" class=\"docClass\">scripts</a> option to execute any inline scripts in\nthe resulting content. Using this renderer has the same effect as passing the\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">Ext.Component.html</a> configuration option.</p>\n\n<h2>Data Renderer</h2>\n\n<p>This renderer allows content to be added by using JSON data and a Ext.XTemplate.\nThe content received from the response is passed to the <a href=\"#!/api/Ext.Component-method-update\" rel=\"Ext.Component-method-update\" class=\"docClass\">Ext.Component.update</a> method.\nThis content is run through the attached <a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">Ext.Component.tpl</a> and the data is added to\nthe Component. Using this renderer has the same effect as using the <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">Ext.Component.data</a>\nconfiguration in conjunction with a <a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">Ext.Component.tpl</a>.</p>\n\n<h2>Component Renderer</h2>\n\n<p>This renderer can only be used with a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> and subclasses. It allows for\nComponents to be loaded remotely into a Container. The response is expected to be a single/series of\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> configuration objects. When the response is received, the data is decoded\nand then passed to <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">Ext.container.Container.add</a>. Using this renderer has the same effect as specifying\nthe <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">Ext.container.Container.items</a> configuration on a Container.</p>\n\n<h2>Custom Renderer</h2>\n\n<p>A custom function can be passed to handle any other special case, see the <a href=\"#!/api/Ext.ComponentLoader-cfg-renderer\" rel=\"Ext.ComponentLoader-cfg-renderer\" class=\"docClass\">renderer</a> option.</p>\n\n<h2>Example Usage</h2>\n\n<pre><code>var cmp = Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    tpl: '{firstName} - {lastName}',\n    loader: {\n        url: 'myPage.php',\n        renderer: 'data',\n        params: {\n            userId: 1\n        }\n    }\n});\n\n// call the loader manually (or use autoLoad:true instead)\ncmp.getLoader().load();\n</code></pre>\n","prototype":{"loadMask":{"!doc":"<p>True or a <a href=\"#!/api/Ext.LoadMask\" rel=\"Ext.LoadMask\" class=\"docClass\">Ext.LoadMask</a> configuration to enable masking during loading.</p>\n"},"renderer":{"!doc":"<p>The type of content that is to be loaded into, which can be one of 3 types:</p>\n\n<ul>\n<li><strong>html</strong> : Loads raw html content, see <a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">Ext.Component.html</a></li>\n<li><strong>data</strong> : Loads raw html content, see <a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">Ext.Component.data</a></li>\n<li><strong>component</strong> : Loads child {<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>} instances. This option is only valid when used with a Container.</li>\n</ul>\n\n\n<p>Alternatively, you can pass a function which is called with the following parameters.</p>\n\n<ul>\n<li>loader - Loader instance</li>\n<li>response - The server response</li>\n<li>active - The active request</li>\n</ul>\n\n\n<p>The function must return false is loading is not successful. Below is a sample of using a custom renderer:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>({\n    loader: {\n        url: 'myPage.php',\n        renderer: function(loader, response, active) {\n            var text = response.responseText;\n            loader.getTarget().setHtml('The response is ' + text);\n            return true;\n        }\n    }\n});\n</code></pre>\n"},"scripts":{"!type":"bool","!doc":"<p>True to parse any inline script tags in the response. This only used when using the html\n<a href=\"#!/api/Ext.ComponentLoader-cfg-renderer\" rel=\"Ext.ComponentLoader-cfg-renderer\" class=\"docClass\">renderer</a>.</p>\n"},"target":{"!doc":"<p>The target <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> for the loader.\nIf a string is passed it will be looked up via the id.</p>\n"},"Renderer":{},"addMask":{"!type":"fn(mask: ?) -> !this","!doc":"<p>Add the mask on the target</p>\n"},"getRenderer":{"!type":"fn(renderer: ?) -> ?","!doc":"<p>Gets the renderer to use</p>\n"},"removeMask":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"setOptions":{"!type":"fn(active: ?, options: ?) -> !this","!doc":"<p>Sets any additional options on the active request</p>\n"},"setTarget":{"!type":"fn(target: ?) -> !this","!doc":"<p>Set a {<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>} as the target of this loader. Note that if the target is changed,\nany active requests will be aborted.</p>\n"}}},"ElementLoader":{"prototype":{"ajaxOptions":{"!doc":"<p>Any additional options to be passed to the request, for example timeout or headers.</p>\n"},"autoLoad":{"!doc":"<p>True to have the loader make a request as soon as it is created.\nThis argument can also be a set of options that will be passed to <a href=\"#!/api/Ext.ElementLoader-method-load\" rel=\"Ext.ElementLoader-method-load\" class=\"docClass\">load</a> is called.</p>\n"},"baseParams":{"!doc":"<p>Params that will be attached to every request. These parameters\nwill not be overridden by any params in the load options.</p>\n"},"callback":{"!doc":"<p>A function to be called when a load request finishes.\nWill be called with the following config parameters:</p>\n\n<ul>\n<li>this - The ElementLoader instance.</li>\n<li>success - True if successful request.</li>\n<li>response - The response object.</li>\n<li>options - Ajax options.</li>\n</ul>\n\n"},"failure":{"!doc":"<p>A function to be called when a load request fails.\nWill be called with the following config parameters:</p>\n\n<ul>\n<li>this - The ElementLoader instance.</li>\n<li>response - The response object.</li>\n<li>options - Ajax options.</li>\n</ul>\n\n"},"params":{"!doc":"<p>Any params to be attached to the Ajax request. These parameters will\nbe overridden by any params in the load options.</p>\n"},"rendererScope":{"!doc":"<p>The scope to execute the <a href=\"#!/api/Ext.ElementLoader-cfg-renderer\" rel=\"Ext.ElementLoader-cfg-renderer\" class=\"docClass\">renderer</a> function in.</p>\n"},"scope":{"!doc":"<p>The scope to execute the <a href=\"#!/api/Ext.ElementLoader-cfg-success\" rel=\"Ext.ElementLoader-cfg-success\" class=\"docClass\">success</a> and <a href=\"#!/api/Ext.ElementLoader-cfg-failure\" rel=\"Ext.ElementLoader-cfg-failure\" class=\"docClass\">failure</a> functions in.</p>\n"},"success":{"!doc":"<p>A function to be called when a load request is successful.\nWill be called with the following config parameters:</p>\n\n<ul>\n<li>this - The ElementLoader instance.</li>\n<li>response - The response object.</li>\n<li>options - Ajax options.</li>\n</ul>\n\n"},"url":{"!type":"string","!doc":"<p>The url to retrieve the content from.</p>\n"},"isLoader":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated ElementLoader, or subclass thereof.</p>\n"},"abort":{"!type":"fn() -> !this","!doc":"<p>Aborts the active load request</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys the loader. Any active requests will be aborted.</p>\n"},"getTarget":{"!type":"fn() -> ?","!doc":"<p>Returns the target of this loader.</p>\n"},"isAutoRefreshing":{"!type":"fn() -> bool","!doc":"<p>Checks whether the loader is automatically refreshing. See <a href=\"#!/api/Ext.ElementLoader-method-startAutoRefresh\" rel=\"Ext.ElementLoader-method-startAutoRefresh\" class=\"docClass\">startAutoRefresh</a>.</p>\n"},"load":{"!type":"fn(this: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires after a successful load.</p>\n"},"onComplete":{"!type":"fn(options: ?, success: ?, response: ?) -> !this","!doc":"<p>Parses the response after the request completes</p>\n"},"startAutoRefresh":{"!type":"fn(interval: ?, options?: ?) -> !this","!doc":"<p>Automatically refreshes the content over a specified period.</p>\n"},"stopAutoRefresh":{"!type":"fn() -> !this","!doc":"<p>Clears any auto refresh. See <a href=\"#!/api/Ext.ElementLoader-method-startAutoRefresh\" rel=\"Ext.ElementLoader-method-startAutoRefresh\" class=\"docClass\">startAutoRefresh</a>.</p>\n"},"beforeload":{"!type":"fn(this: ?, options: ?, eOpts: ?)","!doc":"<p>Fires before a load request is made to the server.\nReturning false from an event listener can prevent the load\nfrom occurring.</p>\n"},"exception":{"!type":"fn(this: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires after an unsuccessful load.</p>\n"},"loadMask":{"!doc":"<p>True or a string to show when the element is loading.</p>\n"},"renderer":{"!doc":"<p>A custom function to render the content to the element. The function should\nreturn false if the renderer could not be applied. The passed parameters are:</p>\n\n<ul>\n<li>The loader</li>\n<li>The response</li>\n<li>The active request</li>\n</ul>\n\n"},"scripts":{"!type":"bool","!doc":"<p>True to parse any inline script tags in the response.</p>\n"},"target":{"!doc":"<p>The target element for the loader. It can be the DOM element, the id or an Ext.dom.Element.</p>\n"},"Renderer":{},"addMask":{"!type":"fn(mask: ?) -> !this","!doc":"<p>Adds the mask on the target</p>\n"},"getRenderer":{"!type":"fn(renderer: ?) -> ?","!doc":"<p>Gets the renderer to use</p>\n"},"removeMask":{"!type":"fn() -> !this","!doc":"<p>Removes the mask on the target</p>\n"},"setOptions":{"!type":"fn(active: ?, options: ?) -> !this","!doc":"<p>Sets any additional options on the active request</p>\n"},"setTarget":{"!type":"fn(target: ?) -> !this","!doc":"<p>Sets an Ext.dom.Element as the target of this loader.\nNote that if the target is changed, any active requests will be aborted.</p>\n"}},"!doc":"<p>A class used to load remote content to an Element. Sample usage:</p>\n\n<pre><code>Ext.get('el').load({\n    url: 'myPage.php',\n    scripts: true,\n    params: {\n        id: 1\n    }\n});\n</code></pre>\n\n<p>In general this class will not be instanced directly, rather the Ext.dom.Element.load method\nwill be used.</p>\n"},"panel":{"Panel":{"prototype":{"bbar":{"!doc":"<p>Convenience config. Short for 'Bottom Bar'.</p>\n\n<pre><code>bbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"bodyBorder":{"!type":"bool","!doc":"<p>A shortcut to add or remove the border on the body of a panel. In the classic theme\nthis only applies to a panel which has the <a href=\"#!/api/Ext.panel.Panel-cfg-frame\" rel=\"Ext.panel.Panel-cfg-frame\" class=\"docClass\">frame</a> configuration set to <code>true</code>.</p>\n"},"bodyCls":{"!doc":"<p>A CSS class, space-delimited string of classes, or array of classes to be applied to the panel's body element.\nThe following examples are all valid:</p>\n\n<pre><code>bodyCls: 'foo'\nbodyCls: 'foo bar'\nbodyCls: ['foo', 'bar']\n</code></pre>\n"},"bodyPadding":{"!doc":"<p>A shortcut for setting a padding style on the body element. The value can either be\na number to be applied to all sides, or a normal css string describing padding.</p>\n"},"bodyStyle":{"!doc":"<p>Custom CSS styles to be applied to the panel's body element, which can be supplied as a valid CSS style string,\nan object containing style property name/value pairs or a function that returns such a string or object.\nFor example, these two formats are interpreted to be equivalent:</p>\n\n<pre><code>bodyStyle: 'background:#ffc; padding:10px;'\n\nbodyStyle: {\n    background: '#ffc',\n    padding: '10px'\n}\n</code></pre>\n"},"border":{"!type":"bool","!doc":"<p>Specify as <code>false</code> to render the Panel with zero width borders.</p>\n\n<p>Leaving the value as <code>true</code> uses the selected theme's $panel-border-width</p>\n\n<p>Defaults to <code>false</code> when using or extending Neptune.</p>\n"},"buttonAlign":{"!type":"string","!doc":"<p>The alignment of any buttons added to this panel. Valid values are 'right', 'left' and 'center' (defaults to\n'right' for buttons/fbar, 'left' for other toolbar types).</p>\n\n<p><strong>NOTE:</strong> The prefered way to specify toolbars is to use the dockedItems config. Instead of buttonAlign you\nwould add the layout: { pack: 'start' | 'center' | 'end' } option to the dockedItem config.</p>\n"},"buttons":{"!doc":"<p>Convenience config used for adding buttons docked to the bottom of the panel. This is a\nsynonym for the <a href=\"#!/api/Ext.panel.Panel-cfg-fbar\" rel=\"Ext.panel.Panel-cfg-fbar\" class=\"docClass\">fbar</a> config.</p>\n\n<pre><code>buttons: [\n  { text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    ui: 'footer',\n    defaults: {minWidth: <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>},\n    items: [\n        { xtype: 'component', flex: 1 },\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a> is used as the default <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">minWidth</a> for\neach of the buttons in the buttons toolbar.</p>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"closeAction":{"!type":"string","!doc":"<p>The action to take when the close header tool is clicked:</p>\n\n<ul>\n<li><p><strong><code>'<a href=\"#!/api/Ext.panel.Panel-method-destroy\" rel=\"Ext.panel.Panel-method-destroy\" class=\"docClass\">destroy</a>'</code></strong> :</p>\n\n<p><a href=\"#!/api/Ext.panel.Panel-method-remove\" rel=\"Ext.panel.Panel-method-remove\" class=\"docClass\">remove</a> the window from the DOM and <a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a> it and all descendant\nComponents. The window will <strong>not</strong> be available to be redisplayed via the <a href=\"#!/api/Ext.panel.Panel-method-show\" rel=\"Ext.panel.Panel-method-show\" class=\"docClass\">show</a> method.</p></li>\n<li><p><strong><code>'<a href=\"#!/api/Ext.panel.Panel-method-hide\" rel=\"Ext.panel.Panel-method-hide\" class=\"docClass\">hide</a>'</code></strong> :</p>\n\n<p><a href=\"#!/api/Ext.panel.Panel-method-hide\" rel=\"Ext.panel.Panel-method-hide\" class=\"docClass\">hide</a> the window by setting visibility to hidden and applying negative offsets. The window will be\navailable to be redisplayed via the <a href=\"#!/api/Ext.panel.Panel-method-show\" rel=\"Ext.panel.Panel-method-show\" class=\"docClass\">show</a> method.</p></li>\n</ul>\n\n\n<p><strong>Note:</strong> This behavior has changed! setting <em>does</em> affect the <a href=\"#!/api/Ext.panel.Panel-method-close\" rel=\"Ext.panel.Panel-method-close\" class=\"docClass\">close</a> method which will invoke the\napproriate closeAction.</p>\n"},"collapseDirection":{"!type":"string","!doc":"<p>The direction to collapse the Panel when the toggle button is clicked.</p>\n\n<p>Defaults to the <a href=\"#!/api/Ext.panel.Panel-property-headerPosition\" rel=\"Ext.panel.Panel-property-headerPosition\" class=\"docClass\">headerPosition</a></p>\n\n<p><strong>Important: This config is <em>ignored</em> for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>Specify as <code>'top'</code>, <code>'bottom'</code>, <code>'left'</code> or <code>'right'</code>.</p>\n"},"collapseFirst":{"!type":"bool","!doc":"<p><code>true</code> to make sure the collapse/expand toggle button always renders first (to the left of) any other tools in\nthe panel's title bar, <code>false</code> to render it last.</p>\n"},"collapsed":{"!type":"bool","!doc":"<p><code>true</code> to render the panel collapsed, <code>false</code> to render it expanded.</p>\n"},"collapsedCls":{"!type":"string","!doc":"<p>A CSS class to add to the panel's element after it has been collapsed.</p>\n"},"componentLayout":{"!doc":"<p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.panel.Panel-method-setSize\" rel=\"Ext.panel.Panel-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"constrain":{"!type":"bool","!doc":"<p>True to constrain the panel within its containing element, false to allow it to fall outside of its containing\nelement. By default floating components such as Windows will be rendered to <code>document.body</code>. To render and constrain the window within\nanother element specify <a href=\"#!/api/Ext.panel.Panel-cfg-renderTo\" rel=\"Ext.panel.Panel-cfg-renderTo\" class=\"docClass\">renderTo</a>. Optionally the header only can be constrained\nusing <a href=\"#!/api/Ext.panel.Panel-cfg-constrainHeader\" rel=\"Ext.panel.Panel-cfg-constrainHeader\" class=\"docClass\">constrainHeader</a>.</p>\n"},"constrainHeader":{"!type":"bool","!doc":"<p>True to constrain the panel header within its containing element (allowing the panel body to fall outside of\nits containing element) or false to allow the header to fall outside its containing element.\nOptionally the entire panel can be constrained using <a href=\"#!/api/Ext.panel.Panel-cfg-constrain\" rel=\"Ext.panel.Panel-cfg-constrain\" class=\"docClass\">constrain</a>.</p>\n"},"dockedItems":{"!doc":"<p>A component or series of components to be added as docked items to this panel. The docked items can be docked to\neither the top, right, left or bottom of a panel. This is typically used for things like toolbars or tab bars:</p>\n\n<pre><code>var panel = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    dockedItems: [{\n        xtype: 'toolbar',\n        dock: 'top',\n        items: [{\n            text: 'Docked to the top'\n        }]\n    }]\n});\n</code></pre>\n"},"fbar":{"!doc":"<p>Convenience config used for adding items to the bottom of the panel. Short for Footer Bar.</p>\n\n<pre><code>fbar: [\n  { type: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    ui: 'footer',\n    defaults: {minWidth: <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>},\n    items: [\n        { xtype: 'component', flex: 1 },\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a> is used as the default <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">minWidth</a> for\neach of the buttons in the fbar.</p>\n"},"floatable":{"!type":"bool","!doc":"<p><strong>Important: This config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>true to allow clicking a collapsed Panel's <a href=\"#!/api/Ext.panel.Panel-cfg-placeholder\" rel=\"Ext.panel.Panel-cfg-placeholder\" class=\"docClass\">placeholder</a> to display the Panel floated above the layout,\nfalse to force the user to fully expand a collapsed region by clicking the expand button to see it again.</p>\n"},"frameHeader":{"!type":"bool","!doc":"<p>True to apply a frame to the panel panels header (if 'frame' is true).</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon for the panel header. The\ndefault font-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"header":{"!doc":"<p>Pass as <code>false</code> to prevent a Header from being created and shown.</p>\n\n<p>Pass as a config object (optionally containing an <code>xtype</code>) to custom-configure this Panel's header.</p>\n\n<p>See <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a> for all the options that may be specified here.</p>\n\n<p>A <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">panel header</a> is a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> which contains the Panel's <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-tools\" rel=\"Ext.panel.Panel-cfg-tools\" class=\"docClass\">tools</a>.\nYou may also configure the Panel's <code>header</code> option with its own child items which go <em>before</em> the <a href=\"#!/api/Ext.panel.Panel-cfg-tools\" rel=\"Ext.panel.Panel-cfg-tools\" class=\"docClass\">tools</a></p>\n\n<p>By default the panel <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a> is inserted after items configured in this config, but before any tools.\nTo insert the title at any point in the full array, specify the <a href=\"#!/api/Ext.panel.Header-property-titlePosition\" rel=\"Ext.panel.Header-property-titlePosition\" class=\"docClass\">titlePosition</a> config:</p>\n\n<p>   new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n       title: 'Test',\n       tools: [{\n           type: 'refresh\n       }, {\n           type: 'help'\n       }],\n       titlePosition: 2 // Title will come AFTER the two tools\n       ...\n   });</p>\n"},"headerOverCls":{"!type":"string","!doc":"<p>Optional CSS class to apply to the header element on mouseover</p>\n"},"headerPosition":{"!type":"string","!doc":"<p>For performance reasons we give the following configs their default values on\nthe class body.  This prevents the updaters from running on initialization in the\ndefault configuration scenario</p>\n"},"hideCollapseTool":{"!type":"bool","!doc":"<p><code>true</code> to hide the expand/collapse toggle button when <code><a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> == true</code>, <code>false</code> to display it.</p>\n"},"icon":{"!type":"string","!doc":"<p>Path to image for an icon.</p>\n\n<p>There are no default icons that come with Ext JS.</p>\n"},"iconAlign":{"!type":"string"},"iconCls":{"!type":"string","!doc":"<p>CSS class for an icon.</p>\n\n<p>There are no default icon classes that come with Ext JS.</p>\n"},"lbar":{"!doc":"<p>Convenience config. Short for 'Left Bar' (left-docked, vertical toolbar).</p>\n\n<pre><code>lbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'left',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"manageHeight":{"!type":"bool","!doc":"<p>When true, the dock component layout writes\nheight information to the panel's DOM elements based on its shrink wrap height\ncalculation. This ensures that the browser respects the calculated height.\nWhen false, the dock component layout will not write heights on the panel or its\nbody element. In some simple layout cases, not writing the heights to the DOM may\nbe desired because this allows the browser to respond to direct DOM manipulations\n(like animations).</p>\n"},"maskElement":{"!type":"string","!doc":"<p>The name of the element property in this Panel to mask when masked by a LoadMask.</p>\n\n<p>Defaults to <code>\"el\"</code> to indicate that any LoadMask should be rendered into this Panel's encapsulating element.</p>\n\n<p>This could be configured to be <code>\"body\"</code> so that only the body is masked and toolbars and the header are still mouse-accessible.</p>\n"},"minButtonWidth":{"!type":"number","!doc":"<p>Minimum width of all footer toolbar buttons in pixels. If set, this will be used as the default\nvalue for the <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">Ext.button.Button.minWidth</a> config of each Button added to the <strong>footer toolbar</strong> via the\n<a href=\"#!/api/Ext.panel.Panel-cfg-fbar\" rel=\"Ext.panel.Panel-cfg-fbar\" class=\"docClass\">fbar</a> or <a href=\"#!/api/Ext.panel.Panel-cfg-buttons\" rel=\"Ext.panel.Panel-cfg-buttons\" class=\"docClass\">buttons</a> configurations. It will be ignored for buttons that have a minWidth configured\nsome other way, e.g. in their own config object or via the <a href=\"#!/api/Ext.container.Container-cfg-defaults\" rel=\"Ext.container.Container-cfg-defaults\" class=\"docClass\">defaults</a> of\ntheir parent container.</p>\n"},"overlapHeader":{"!type":"bool","!doc":"<p>True to overlap the header in a panel over the framing of the panel itself. This is needed when frame:true (and\nis done automatically for you). Otherwise it is undefined. If you manually add rounded corners to a panel header\nwhich does not have frame:true, this will need to be set to true.</p>\n"},"placeholder":{"!doc":"<p><strong>Important: This config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a> when not using the <code>'header'</code> <a href=\"#!/api/Ext.panel.Panel-cfg-collapseMode\" rel=\"Ext.panel.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a>.</strong></p>\n\n<p><strong>Optional.</strong> A Component (or config object for a Component) to show in place of this Panel when this Panel is\ncollapsed by a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>. Defaults to a generated <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> containing a <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Tool</a> to re-expand the Panel.</p>\n"},"placeholderCollapseHideMode":{"!type":"number","!doc":"<p>The mode for hiding collapsed panels when\nusing <a href=\"#!/api/Ext.panel.Panel-cfg-collapseMode\" rel=\"Ext.panel.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a> \"placeholder\".</p>\n"},"preventHeader":{"!type":"bool"},"rbar":{"!doc":"<p>Convenience config. Short for 'Right Bar' (right-docked, vertical toolbar).</p>\n\n<pre><code>rbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'right',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.panel.Panel-method-getEl\" rel=\"Ext.panel.Panel-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.panel.Panel-method-getEl\" rel=\"Ext.panel.Panel-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.panel.Panel-cfg-renderSelectors\" rel=\"Ext.panel.Panel-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-childEls\" rel=\"Ext.panel.Panel-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"shrinkWrapDock":{"!doc":"<p>Allows for this panel to include the <a href=\"#!/api/Ext.panel.Panel-cfg-dockedItems\" rel=\"Ext.panel.Panel-cfg-dockedItems\" class=\"docClass\">dockedItems</a> when trying to determine the overall\nsize of the panel. This option is only applicable when this panel is also shrink wrapping in the\nsame dimensions. See <a href=\"#!/api/Ext.Component-cfg-shrinkWrap\" rel=\"Ext.Component-cfg-shrinkWrap\" class=\"docClass\">Ext.Component.shrinkWrap</a> for an explanation of the configuration options.</p>\n"},"simpleDrag":{"!type":"bool","!doc":"<p>When <a href=\"#!/api/Ext.panel.Panel-cfg-draggable\" rel=\"Ext.panel.Panel-cfg-draggable\" class=\"docClass\">draggable</a> is <code>true</code>, Specify this as <code>true</code> to  cause the <code>draggable</code> config\nto work the same as it does in <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>. This Panel\njust becomes movable. No DragDrop instances receive any notifications.\nFor example:</p>\n\n<pre class='inline-example '><code>var win = Ext.create('widget.window', {\n    height: 300,\n    width: 300,\n    title: 'Constraining Window',\n    closable: false,\n    items: {\n        title: \"Floating Panel\",\n        width: 100,\n        height: 100,\n        floating: true,\n        draggable: true,\n        constrain: true,\n        simpleDrag: true\n    }\n});\nwin.show();\n// Floating components begin life hidden\nwin.child('[title=Floating Panel]').show();\n</code></pre>\n"},"tbar":{"!doc":"<p>Convenience config. Short for 'Top Bar'.</p>\n\n<pre><code>tbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'top',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"title":{"!type":"string","!doc":"<p>The title text to be used to display in the <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Panel Header</a>.\nOr a config object for a <a href=\"#!/api/Ext.panel.Title\" rel=\"Ext.panel.Title\" class=\"docClass\">Panel Title</a>. When a <code>title</code> is\nspecified the <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a> will automatically be created and\ndisplayed unless <a href=\"#!/api/Ext.panel.Panel-cfg-header\" rel=\"Ext.panel.Panel-cfg-header\" class=\"docClass\">header</a> is set to <code>false</code>.</p>\n"},"titleAlign":{"!type":"string"},"titleCollapse":{"!type":"bool","!doc":"<p><code>true</code> to allow expanding and collapsing the panel (when <code><a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> = true</code>) by clicking anywhere in\nthe header bar, <code>false</code>) to allow it only by clicking to tool button). When a panel is used in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, the <a href=\"#!/api/Ext.panel.Panel-cfg-floatable\" rel=\"Ext.panel.Panel-cfg-floatable\" class=\"docClass\">floatable</a> option can influence the behavior of collapsing.</p>\n"},"titleRotation":{"!type":"string"},"beforeRenderConfig":{},"body":{"!doc":"<p>The Panel's body Element which may be used to contain HTML content.\nThe content may be specified in the <a href=\"#!/api/Ext.panel.Panel-cfg-html\" rel=\"Ext.panel.Panel-cfg-html\" class=\"docClass\">html</a> config, or it may be loaded using the\n<a href=\"#!/api/Ext.panel.Panel-cfg-loader\" rel=\"Ext.panel.Panel-cfg-loader\" class=\"docClass\">loader</a> config. Read-only.</p>\n\n<p>If this is used to load visible HTML elements in either way, then\nthe Panel may not be used as a Layout for hosting nested Panels.</p>\n\n<p>If this Panel is intended to be used as the host of a Layout (See <a href=\"#!/api/Ext.panel.Panel-cfg-layout\" rel=\"Ext.panel.Panel-cfg-layout\" class=\"docClass\">layout</a>\nthen the body Element must not be loaded or changed - it is under the control\nof the Panel's Layout.</p>\n"},"contentPaddingProperty":{"!type":"string","!doc":"<p>The name of the padding property that is used by the layout to manage\npadding.  See <a href=\"#!/api/Ext.layout.container.Auto-property-managePadding\" rel=\"Ext.layout.container.Auto-property-managePadding\" class=\"docClass\">managePadding</a></p>\n"},"dd":{"!doc":"<p>Only present if this Panel has been configured with <a href=\"#!/api/Ext.panel.Panel-cfg-draggable\" rel=\"Ext.panel.Panel-cfg-draggable\" class=\"docClass\">draggable</a> <code>true</code>.</p>\n\n<h2>Simple dragging</h2>\n\n<p>If this Panel is configured <a href=\"#!/api/Ext.panel.Panel-cfg-simpleDrag\" rel=\"Ext.panel.Panel-cfg-simpleDrag\" class=\"docClass\">simpleDrag</a> <code>true</code> (the default is <code>false</code>), this property\nwill reference an instance of <a href=\"#!/api/Ext.util.ComponentDragger\" rel=\"Ext.util.ComponentDragger\" class=\"docClass\">Ext.util.ComponentDragger</a> (A subclass of\n<a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">DragTracker</a>) which handles moving the Panel's DOM Element,\nand constraining according to the <a href=\"#!/api/Ext.panel.Panel-cfg-constrain\" rel=\"Ext.panel.Panel-cfg-constrain\" class=\"docClass\">constrain</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-constrainHeader\" rel=\"Ext.panel.Panel-cfg-constrainHeader\" class=\"docClass\">constrainHeader</a> .</p>\n\n<p>This object fires various events during its lifecycle and during a drag operation.</p>\n\n<h2>Complex dragging interacting with other DragDrop instances</h2>\n\n<p>By default, this property in a <a href=\"#!/api/Ext.panel.Panel-cfg-draggable\" rel=\"Ext.panel.Panel-cfg-draggable\" class=\"docClass\">draggable</a> Panel will contain an instance of <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> which handles dragging the Panel.</p>\n\n<p>The developer must provide implementations of the abstract methods of <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> in order to\nsupply behaviour for each stage of the drag/drop process. See <a href=\"#!/api/Ext.panel.Panel-cfg-draggable\" rel=\"Ext.panel.Panel-cfg-draggable\" class=\"docClass\">draggable</a>.</p>\n"},"defaultBindProperty":{"!type":"string"},"emptyArray":{},"isPanel":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Panel, or subclass thereof.</p>\n"},"addBodyCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the body element. If not rendered, the class will\nbe added when the panel is rendered.</p>\n"},"addTool":{"!type":"fn(tools: ?) -> !this","!doc":"<p>Add tools to this panel</p>\n"},"addTools":{"!type":"fn() -> !this","!doc":"<p>Template method to be implemented in subclasses to add their tools after the collapsible tool.</p>\n"},"addUIClsToElement":{"!type":"fn(cls: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"afterCollapse":{"!type":"fn(animated: ?) -> !this","!doc":"<p>Invoked after the Panel is Collapsed.</p>\n"},"afterExpand":{"!type":"fn(animated: ?) -> !this","!doc":"<p>Invoked after the Panel is Expanded.</p>\n"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Applies the state to the object. This should be overridden in subclasses to do\nmore complex state operations. By default it applies the state properties onto\nthe current object.</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"beginCollapse":{"!type":"fn() -> !this","!doc":"<p>Called before the change from default, configured state into the collapsed state.\nThis method may be called at render time to enable rendering in an initially collapsed state,\nor at runtime when an existing, fully layed out Panel may be collapsed.\nIt basically saves configs which need to be clobbered for the duration of the collapsed state.</p>\n"},"beginDrag":{"!type":"fn() -> !this"},"beginExpand":{"!type":"fn() -> !this"},"bridgeToolbars":{"!type":"fn() -> !this"},"calculateConstrainedPosition":{"!type":"fn(constrainTo: ?, proposedPosition: ?, local: ?, proposedSize: ?) -> !this","!doc":"<p>Override of Positionable method to calculate constrained position based upon possibly only\nconstraining our header.</p>\n"},"close":{"!type":"fn(panel: ?, eOpts: ?)","!doc":"<p>Fires when the user closes the panel.</p>\n"},"collapse":{"!type":"fn(p: ?, eOpts: ?)","!doc":"<p>Fires after this Panel has collapsed.</p>\n"},"collapsedHorizontal":{"!type":"fn() -> !this"},"collapsedVertical":{"!type":"fn() -> !this"},"convertCollapseDir":{"!type":"fn(collapseDir: ?) -> !this","!doc":"<p>converts a collapsdDir into an anchor argument for Element.slideIn\noverridden in rtl mode to switch \"l\" and \"r\"</p>\n"},"createGhost":{"!type":"fn(cls: ?) -> !this"},"createReExpander":{"!type":"fn(direction: ?, defaults: ?) -> !this"},"doClose":{"!type":"fn() -> !this"},"doCollapseExpand":{"!type":"fn(flags: ?, animate: ?) -> !this"},"endDrag":{"!type":"fn() -> !this"},"expand":{"!type":"fn(p: ?, eOpts: ?)","!doc":"<p>Fires after this Panel has expanded.</p>\n"},"findReExpander":{"!type":"fn(direction: ?) -> !this"},"floatCollapsedPanel":{"!type":"fn() -> !this"},"getAnimationProps":{"!type":"fn() -> !this","!doc":"<ul>\n<li>get animation properties</li>\n</ul>\n\n"},"getCollapsed":{"!type":"fn() -> ?","!doc":"<p>Returns the current collapsed state of the panel.</p>\n"},"getCollapsedDockedItems":{"!type":"fn() -> !this"},"getComponent":{"!type":"fn(comp: ?) -> ?","!doc":"<p>Attempts a default component lookup (see <a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">Ext.container.Container.getComponent</a>). If the component is not found in the normal\nitems, the dockedItems are searched and the matched component (if any) returned (see <a href=\"#!/api/Ext.panel.Panel-method-getDockedComponent\" rel=\"Ext.panel.Panel-method-getDockedComponent\" class=\"docClass\">getDockedComponent</a>). Note that docked\nitems will only be matched by component id or itemId -- if you pass a numeric index only non-docked child components will be searched.</p>\n"},"getHeader":{"!type":"fn() -> !this","!doc":"<p>Gets the <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> for this panel.</p>\n"},"getHeaderCollapsedClasses":{"!type":"fn(header: ?) -> !this","!doc":"<p>Create the class array to add to the Header when collpsed.</p>\n"},"getHeightAuthority":{"!type":"fn() -> !this"},"getKeyMap":{"!type":"fn() -> !this"},"getMemento":{"!type":"fn(name: ?) -> !this","!doc":"<p>Memento Factory method</p>\n"},"getOppositeDirection":{"!type":"fn(d: ?) -> !this"},"getPlaceholder":{"!type":"fn(direction: ?) -> !this"},"getProtoBody":{"!type":"fn() -> !this"},"getReExpander":{"!type":"fn(direction: ?) -> !this"},"getRefItems":{"!type":"fn(deep: ?) -> !this","!doc":"<p>Used by ComponentQuery, child and down to retrieve all of the items\nwhich can potentially be considered a child of this Container.</p>\n\n<p>This may be overriden by Components which have ownership of Components\nthat are not contained in the <a href=\"#!/api/Ext.panel.Panel-property-items\" rel=\"Ext.panel.Panel-property-items\" class=\"docClass\">items</a> collection.</p>\n\n<p>NOTE: IMPORTANT note for maintainers:\nItems are returned in tree traversal order. Each item is appended to the result array\nfollowed by the results of that child's getRefItems call.\nFloating child items are appended after internal child items.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>The supplied default state gathering method for the Component class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.panel.Panel-cfg-stateId\" rel=\"Ext.panel.Panel-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n"},"ghost":{"!type":"fn(cls: ?) -> !this","!doc":"<p>used for dragging</p>\n"},"ghostTools":{"!type":"fn() -> !this","!doc":"<p>helper function for ghost</p>\n"},"initBodyBorder":{"!type":"fn() -> !this"},"initBodyStyles":{"!type":"fn() -> string","!doc":"<p>Parses the <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config if available to create a style string that will be applied to the body element.\nThis also includes <a href=\"#!/api/Ext.panel.Panel-cfg-bodyPadding\" rel=\"Ext.panel.Panel-cfg-bodyPadding\" class=\"docClass\">bodyPadding</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-bodyBorder\" rel=\"Ext.panel.Panel-cfg-bodyBorder\" class=\"docClass\">bodyBorder</a> if available.</p>\n"},"initBorderProps":{"!type":"fn() -> !this"},"initItems":{"!type":"fn() -> !this","!doc":"<p>This method is called to initialize the <code>items</code> collection. A derived class can\noverride this method to do any last minute manipulation of <code>items</code> and then call\nthis method using <code>callParent</code>. Upon return, the <code>items</code> will no longer be a simple\narray.</p>\n"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"initSimpleDraggable":{"!type":"fn() -> !this","!doc":"<p>Override Component.initDraggable.\nPanel (and subclasses) use the header element as the delegate.</p>\n"},"initTools":{"!type":"fn() -> !this","!doc":"<p>Tools are a Panel-specific capabilty.\nPanel uses initTools. Subclasses may contribute tools by implementing addTools.</p>\n"},"isLayoutRoot":{"!type":"fn() -> !this","!doc":"<p>Determines whether this Component is the root of a layout. This returns <code>true</code> if\nthis component can run its layout without assistance from or impact on its owner.\nIf this component cannot run its layout given these restrictions, <code>false</code> is returned\nand its owner will be considered as the next candidate for the layout root.</p>\n\n<p>Setting the <a href=\"#!/api/Ext.panel.Panel-property-_isLayoutRoot\" rel=\"Ext.panel.Panel-property-_isLayoutRoot\" class=\"docClass\">_isLayoutRoot</a> property to <code>true</code> causes this method to always\nreturn <code>true</code>. This may be useful when updating a layout of a Container which shrink\nwraps content, and you know that it will not change size, and so can safely be the\ntopmost participant in the layout run.</p>\n"},"isPlaceHolderCollapse":{"!type":"fn() -> !this"},"isVisible":{"!type":"fn(deep: ?) -> bool","!doc":"<p>Returns <code>true</code> if this component is visible.</p>\n"},"onBoxReady":{"!type":"fn() -> !this","!doc":"<p>Invoked when this component has first achieved size. Occurs after the\n<a href=\"#!/api/Ext.panel.Panel-cfg-componentLayout\" rel=\"Ext.panel.Panel-cfg-componentLayout\" class=\"docClass\">componentLayout</a> has completed its initial run.</p>\n"},"onHide":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the hide operation. After\ncalling the superclass's onHide, the Component will be hidden.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.panel.Panel-event-hide\" rel=\"Ext.panel.Panel-event-hide\" class=\"docClass\">hide</a>.</p>\n"},"onMouseEnterFloated":{"!type":"fn(e: ?) -> !this"},"onMouseLeaveFloated":{"!type":"fn(e: ?) -> !this"},"onPlaceholderResize":{"!type":"fn(ph: ?, newWidth: ?, newHeight: ?) -> !this"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.panel.Panel-event-removed\" rel=\"Ext.panel.Panel-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"onShow":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the show operation. After\ncalling the superclass's onShow, the Component will be visible.</p>\n\n<p>Override in subclasses where more complex behaviour is needed.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.panel.Panel-event-show\" rel=\"Ext.panel.Panel-event-show\" class=\"docClass\">show</a>.</p>\n"},"placeholderCollapse":{"!type":"fn(direction: ?, animate: ?) -> !this"},"placeholderExpand":{"!type":"fn(animate: ?) -> !this"},"removeBodyCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the body element.</p>\n"},"removeUIClsFromElement":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Method which removes a specified UI + <code>uiCls</code> from the components element. The <code>cls</code>\nwhich is added to the element will be: <code>this.baseCls + '-' + ui + uiCls</code>.</p>\n"},"restoreDimension":{"!type":"fn() -> !this"},"restoreHiddenDocked":{"!type":"fn() -> !this"},"setBodyStyle":{"!type":"fn(style: ?, value: ?) -> ?","!doc":"<p>Sets the body style according to the passed parameters.</p>\n"},"setBorder":{"!type":"fn(border: ?, targetEl: ?) -> !this"},"setCollapsible":{"!type":"fn(collapsible: ?) -> !this"},"setHiddenDocked":{"!type":"fn() -> !this"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\n<code>uiCls</code> set on the component and rename them so they include the new UI.</p>\n"},"slideOutFloatedPanelBegin":{"!type":"fn() -> !this","!doc":"<p>This method begins the slide out of the floated panel.</p>\n"},"slideOutFloatedPanelEnd":{"!type":"fn(suppressEvents: ?) -> !this","!doc":"<p>This method cleans up after the slide out of the floated panel.</p>\n"},"toggleCollapse":{"!type":"fn() -> ?","!doc":"<p>Shortcut for performing an <a href=\"#!/api/Ext.panel.Panel-method-expand\" rel=\"Ext.panel.Panel-method-expand\" class=\"docClass\">expand</a> or <a href=\"#!/api/Ext.panel.Panel-method-collapse\" rel=\"Ext.panel.Panel-method-collapse\" class=\"docClass\">collapse</a> based on the current state of the panel.</p>\n"},"unghost":{"!type":"fn(show: ?, matchPosition: ?, focus: ?) -> !this"},"updateCollapseTool":{"!type":"fn() -> !this"},"updateGlyph":{"!type":"fn(glyph: ?, oldGlyph: ?) -> !this"},"updateHeader":{"!type":"fn(force: ?) -> !this","!doc":"<p>Create, hide, or show the header component as appropriate based on the current config.</p>\n"},"updateHeaderPosition":{"!type":"fn(position: ?) -> !this"},"updateIcon":{"!type":"fn(icon: ?, oldIcon: ?) -> !this"},"updateIconAlign":{"!type":"fn(align: ?) -> !this"},"updateIconCls":{"!type":"fn(iconCls: ?) -> !this","!doc":"<p>Set the iconCls for the panel's header. See <a href=\"#!/api/Ext.panel.Header-cfg-iconCls\" rel=\"Ext.panel.Header-cfg-iconCls\" class=\"docClass\">Ext.panel.Header.iconCls</a>. It will fire the\n<a href=\"#!/api/Ext.panel.Panel-event-iconclschange\" rel=\"Ext.panel.Panel-event-iconclschange\" class=\"docClass\">iconclschange</a> event after completion.</p>\n"},"updateTitle":{"!type":"fn(title: ?, oldTitle: ?) -> !this"},"updateTitleAlign":{"!type":"fn(align: ?) -> !this"},"updateTitleRotation":{"!type":"fn(rotation: ?) -> !this"},"beforeclose":{"!type":"fn(panel: ?, eOpts: ?)","!doc":"<p>Fires before the user closes the panel. Return false from any listener to stop the close event being\nfired</p>\n"},"beforecollapse":{"!type":"fn(p: ?, direction: ?, animate: ?, eOpts: ?)","!doc":"<p>Fires before this panel is collapsed. Return false to prevent the collapse.</p>\n"},"beforeexpand":{"!type":"fn(p: ?, animate: ?, eOpts: ?)","!doc":"<p>Fires before this panel is expanded. Return false to prevent the expand.</p>\n"},"float":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires after a collapsed Panel has been \"floated\" by clicking on\nit's header. Only applicable when the Panel is an item in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border Layout</a>.</p>\n"},"glyphchange":{"!type":"fn(this: ?, newGlyph: ?, oldGlyph: ?, eOpts: ?)","!doc":"<p>Fired when the Panel glyph has been changed by the setGlyph method.</p>\n"},"iconchange":{"!type":"fn(p: ?, newIcon: ?, oldIcon: ?, eOpts: ?)","!doc":"<p>Fires after the Panel icon has been set or changed.</p>\n"},"iconclschange":{"!type":"fn(p: ?, newIconCls: ?, oldIconCls: ?, eOpts: ?)","!doc":"<p>Fires after the Panel iconCls has been set or changed.</p>\n"},"titlechange":{"!type":"fn(p: ?, newTitle: ?, oldTitle: ?, eOpts: ?)","!doc":"<p>Fires after the Panel title has been set or changed.</p>\n"},"unfloat":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires after a \"floated\" Panel has returned to it's collapsed state\nas a result of the mouse leaving the Panel. Only applicable when\nthe Panel is an item in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border Layout</a>.</p>\n"},"animCollapse":{"!type":"bool","!doc":"<p><code>true</code> to animate the transition when the panel is collapsed, <code>false</code> to skip the animation (defaults to <code>true</code>\nif the <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> class is available, otherwise <code>false</code>). May also be specified as the animation\nduration in milliseconds.</p>\n"},"baseCls":{"!type":"string","!doc":"<p><editor-fold desc=\"Properties\"></editor></p>\n\n<hr />\n\n<p> Begin Properties</p>\n\n<hr />\n"},"closable":{"!type":"bool","!doc":"<p>True to display the 'close' tool button and allow the user to close the window, false to hide the button and\ndisallow closing the window.</p>\n\n<p>By default, when close is requested by clicking the close button in the header, the <a href=\"#!/api/Ext.panel.Panel-method-close\" rel=\"Ext.panel.Panel-method-close\" class=\"docClass\">close</a> method will be\ncalled. This will <em><a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a></em> the Panel and its content meaning that it may not be\nreused.</p>\n\n<p>To make closing a Panel <em>hide</em> the Panel so that it may be reused, set <a href=\"#!/api/Ext.panel.Panel-cfg-closeAction\" rel=\"Ext.panel.Panel-cfg-closeAction\" class=\"docClass\">closeAction</a> to 'hide'.</p>\n"},"collapseMode":{"!type":"string","!doc":"<p><strong>Important: this config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>When <em>not</em> a direct child item of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, then the Panel's header\nremains visible, and the body is collapsed to zero dimensions. If the Panel has no header, then a new header\n(orientated correctly depending on the <a href=\"#!/api/Ext.panel.Panel-cfg-collapseDirection\" rel=\"Ext.panel.Panel-cfg-collapseDirection\" class=\"docClass\">collapseDirection</a>) will be inserted to show a the title and a re-\nexpand tool.</p>\n\n<p>When a child item of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, this config has three possible values:</p>\n\n<ul>\n<li><p><code>undefined</code> - When collapsed, a placeholder <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> is injected into the layout to\nrepresent the Panel and to provide a UI with a Tool to allow the user to re-expand the Panel.</p></li>\n<li><p><code>\"header\"</code> - The Panel collapses to leave its header visible as when not inside a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p></li>\n<li><p><code>\"mini\"</code> - The Panel collapses without a visible header.</p></li>\n</ul>\n\n"},"collapsible":{"!type":"bool","!doc":"<p>True to make the panel collapsible and have an expand/collapse toggle Tool added into the header tool button\narea. False to keep the panel sized either statically, or by an owning layout manager, with no toggle Tool.\nWhen a panel is used in a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, the <a href=\"#!/api/Ext.panel.Panel-cfg-floatable\" rel=\"Ext.panel.Panel-cfg-floatable\" class=\"docClass\">floatable</a> option\ncan influence the behavior of collapsing.\nSee <a href=\"#!/api/Ext.panel.Panel-cfg-collapseMode\" rel=\"Ext.panel.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-collapseDirection\" rel=\"Ext.panel.Panel-cfg-collapseDirection\" class=\"docClass\">collapseDirection</a></p>\n"},"frame":{"!type":"bool","!doc":"<p>True to apply a frame to the panel.</p>\n"},"tools":{"!doc":"<p>An array of <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a> configs/instances to be added to the header tool area. The tools are stored as\nchild components of the header container. They can be accessed using down and {#query}, as well as the\nother component methods. The toggle tool is automatically created if <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> is set to true.</p>\n\n<p>Note that, apart from the toggle tool which is provided when a panel is collapsible, these tools only provide the\nvisual button. Any required functionality must be provided by adding handlers that implement the necessary\nbehavior.</p>\n\n<p>Example usage:</p>\n\n<pre><code>tools:[{\n    type:'refresh',\n    tooltip: 'Refresh form Data',\n    // hidden:true,\n    handler: function(event, toolEl, panelHeader) {\n        // refresh logic\n    }\n},\n{\n    type:'help',\n    tooltip: 'Get Help',\n    callback: function(panel, tool, event) {\n        // show help here\n    }\n}]\n</code></pre>\n\n<p>The difference between <code>handler</code> and <code>callback</code> is the signature. For details on\nthe distinction, see <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a>.</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"}},"animCollapse":{"!type":"bool","!doc":"<p><code>true</code> to animate the transition when the panel is collapsed, <code>false</code> to skip the animation (defaults to <code>true</code>\nif the <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> class is available, otherwise <code>false</code>). May also be specified as the animation\nduration in milliseconds.</p>\n"},"bbar":{"!doc":"<p>Convenience config. Short for 'Bottom Bar'.</p>\n\n<pre><code>bbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"bodyBorder":{"!type":"bool","!doc":"<p>A shortcut to add or remove the border on the body of a panel. In the classic theme\nthis only applies to a panel which has the <a href=\"#!/api/Ext.panel.Panel-cfg-frame\" rel=\"Ext.panel.Panel-cfg-frame\" class=\"docClass\">frame</a> configuration set to <code>true</code>.</p>\n"},"bodyCls":{"!doc":"<p>A CSS class, space-delimited string of classes, or array of classes to be applied to the panel's body element.\nThe following examples are all valid:</p>\n\n<pre><code>bodyCls: 'foo'\nbodyCls: 'foo bar'\nbodyCls: ['foo', 'bar']\n</code></pre>\n"},"bodyPadding":{"!doc":"<p>A shortcut for setting a padding style on the body element. The value can either be\na number to be applied to all sides, or a normal css string describing padding.</p>\n"},"bodyStyle":{"!doc":"<p>Custom CSS styles to be applied to the panel's body element, which can be supplied as a valid CSS style string,\nan object containing style property name/value pairs or a function that returns such a string or object.\nFor example, these two formats are interpreted to be equivalent:</p>\n\n<pre><code>bodyStyle: 'background:#ffc; padding:10px;'\n\nbodyStyle: {\n    background: '#ffc',\n    padding: '10px'\n}\n</code></pre>\n"},"border":{"!type":"bool","!doc":"<p>Specify as <code>false</code> to render the Panel with zero width borders.</p>\n\n<p>Leaving the value as <code>true</code> uses the selected theme's $panel-border-width</p>\n\n<p>Defaults to <code>false</code> when using or extending Neptune.</p>\n"},"buttonAlign":{"!type":"string","!doc":"<p>The alignment of any buttons added to this panel. Valid values are 'right', 'left' and 'center' (defaults to\n'right' for buttons/fbar, 'left' for other toolbar types).</p>\n\n<p><strong>NOTE:</strong> The prefered way to specify toolbars is to use the dockedItems config. Instead of buttonAlign you\nwould add the layout: { pack: 'start' | 'center' | 'end' } option to the dockedItem config.</p>\n"},"buttons":{"!doc":"<p>Convenience config used for adding buttons docked to the bottom of the panel. This is a\nsynonym for the <a href=\"#!/api/Ext.panel.Panel-cfg-fbar\" rel=\"Ext.panel.Panel-cfg-fbar\" class=\"docClass\">fbar</a> config.</p>\n\n<pre><code>buttons: [\n  { text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    ui: 'footer',\n    defaults: {minWidth: <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>},\n    items: [\n        { xtype: 'component', flex: 1 },\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a> is used as the default <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">minWidth</a> for\neach of the buttons in the buttons toolbar.</p>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"collapseDirection":{"!type":"string","!doc":"<p>The direction to collapse the Panel when the toggle button is clicked.</p>\n\n<p>Defaults to the <a href=\"#!/api/Ext.panel.Panel-property-headerPosition\" rel=\"Ext.panel.Panel-property-headerPosition\" class=\"docClass\">headerPosition</a></p>\n\n<p><strong>Important: This config is <em>ignored</em> for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>Specify as <code>'top'</code>, <code>'bottom'</code>, <code>'left'</code> or <code>'right'</code>.</p>\n"},"collapseFirst":{"!type":"bool","!doc":"<p><code>true</code> to make sure the collapse/expand toggle button always renders first (to the left of) any other tools in\nthe panel's title bar, <code>false</code> to render it last.</p>\n"},"collapseMode":{"!type":"string","!doc":"<p><strong>Important: this config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>When <em>not</em> a direct child item of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, then the Panel's header\nremains visible, and the body is collapsed to zero dimensions. If the Panel has no header, then a new header\n(orientated correctly depending on the <a href=\"#!/api/Ext.panel.Panel-cfg-collapseDirection\" rel=\"Ext.panel.Panel-cfg-collapseDirection\" class=\"docClass\">collapseDirection</a>) will be inserted to show a the title and a re-\nexpand tool.</p>\n\n<p>When a child item of a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, this config has three possible values:</p>\n\n<ul>\n<li><p><code>undefined</code> - When collapsed, a placeholder <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> is injected into the layout to\nrepresent the Panel and to provide a UI with a Tool to allow the user to re-expand the Panel.</p></li>\n<li><p><code>\"header\"</code> - The Panel collapses to leave its header visible as when not inside a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p></li>\n<li><p><code>\"mini\"</code> - The Panel collapses without a visible header.</p></li>\n</ul>\n\n"},"collapsedCls":{"!type":"string","!doc":"<p>A CSS class to add to the panel's element after it has been collapsed.</p>\n"},"componentLayout":{"!doc":"<p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.panel.Panel-method-setSize\" rel=\"Ext.panel.Panel-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"dockedItems":{"!doc":"<p>A component or series of components to be added as docked items to this panel. The docked items can be docked to\neither the top, right, left or bottom of a panel. This is typically used for things like toolbars or tab bars:</p>\n\n<pre><code>var panel = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    dockedItems: [{\n        xtype: 'toolbar',\n        dock: 'top',\n        items: [{\n            text: 'Docked to the top'\n        }]\n    }]\n});\n</code></pre>\n"},"fbar":{"!doc":"<p>Convenience config used for adding items to the bottom of the panel. Short for Footer Bar.</p>\n\n<pre><code>fbar: [\n  { type: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'bottom',\n    ui: 'footer',\n    defaults: {minWidth: <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>},\n    items: [\n        { xtype: 'component', flex: 1 },\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a> is used as the default <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">minWidth</a> for\neach of the buttons in the fbar.</p>\n"},"floatable":{"!type":"bool","!doc":"<p><strong>Important: This config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</strong></p>\n\n<p>true to allow clicking a collapsed Panel's <a href=\"#!/api/Ext.panel.Panel-cfg-placeholder\" rel=\"Ext.panel.Panel-cfg-placeholder\" class=\"docClass\">placeholder</a> to display the Panel floated above the layout,\nfalse to force the user to fully expand a collapsed region by clicking the expand button to see it again.</p>\n"},"frame":{"!type":"bool","!doc":"<p>True to apply a frame to the panel.</p>\n"},"frameHeader":{"!type":"bool","!doc":"<p>True to apply a frame to the panel panels header (if 'frame' is true).</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon for the panel header. The\ndefault font-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"header":{"!doc":"<p>Pass as <code>false</code> to prevent a Header from being created and shown.</p>\n\n<p>Pass as a config object (optionally containing an <code>xtype</code>) to custom-configure this Panel's header.</p>\n\n<p>See <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a> for all the options that may be specified here.</p>\n\n<p>A <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">panel header</a> is a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a> which contains the Panel's <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-tools\" rel=\"Ext.panel.Panel-cfg-tools\" class=\"docClass\">tools</a>.\nYou may also configure the Panel's <code>header</code> option with its own child items which go <em>before</em> the <a href=\"#!/api/Ext.panel.Panel-cfg-tools\" rel=\"Ext.panel.Panel-cfg-tools\" class=\"docClass\">tools</a></p>\n\n<p>By default the panel <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a> is inserted after items configured in this config, but before any tools.\nTo insert the title at any point in the full array, specify the <a href=\"#!/api/Ext.panel.Header-property-titlePosition\" rel=\"Ext.panel.Header-property-titlePosition\" class=\"docClass\">titlePosition</a> config:</p>\n\n<p>   new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n       title: 'Test',\n       tools: [{\n           type: 'refresh\n       }, {\n           type: 'help'\n       }],\n       titlePosition: 2 // Title will come AFTER the two tools\n       ...\n   });</p>\n"},"headerOverCls":{"!type":"string","!doc":"<p>Optional CSS class to apply to the header element on mouseover</p>\n"},"headerPosition":{"!type":"string","!doc":"<p>For performance reasons we give the following configs their default values on\nthe class body.  This prevents the updaters from running on initialization in the\ndefault configuration scenario</p>\n"},"hideCollapseTool":{"!type":"bool","!doc":"<p><code>true</code> to hide the expand/collapse toggle button when <code><a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> == true</code>, <code>false</code> to display it.</p>\n"},"icon":{"!type":"string","!doc":"<p>Path to image for an icon.</p>\n\n<p>There are no default icons that come with Ext JS.</p>\n"},"iconAlign":{"!type":"string"},"iconCls":{"!type":"string","!doc":"<p>CSS class for an icon.</p>\n\n<p>There are no default icon classes that come with Ext JS.</p>\n"},"lbar":{"!doc":"<p>Convenience config. Short for 'Left Bar' (left-docked, vertical toolbar).</p>\n\n<pre><code>lbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'left',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"manageHeight":{"!type":"bool","!doc":"<p>When true, the dock component layout writes\nheight information to the panel's DOM elements based on its shrink wrap height\ncalculation. This ensures that the browser respects the calculated height.\nWhen false, the dock component layout will not write heights on the panel or its\nbody element. In some simple layout cases, not writing the heights to the DOM may\nbe desired because this allows the browser to respond to direct DOM manipulations\n(like animations).</p>\n"},"maskElement":{"!type":"string","!doc":"<p>The name of the element property in this Panel to mask when masked by a LoadMask.</p>\n\n<p>Defaults to <code>\"el\"</code> to indicate that any LoadMask should be rendered into this Panel's encapsulating element.</p>\n\n<p>This could be configured to be <code>\"body\"</code> so that only the body is masked and toolbars and the header are still mouse-accessible.</p>\n"},"minButtonWidth":{"!type":"number","!doc":"<p>Minimum width of all footer toolbar buttons in pixels. If set, this will be used as the default\nvalue for the <a href=\"#!/api/Ext.button.Button-cfg-minWidth\" rel=\"Ext.button.Button-cfg-minWidth\" class=\"docClass\">Ext.button.Button.minWidth</a> config of each Button added to the <strong>footer toolbar</strong> via the\n<a href=\"#!/api/Ext.panel.Panel-cfg-fbar\" rel=\"Ext.panel.Panel-cfg-fbar\" class=\"docClass\">fbar</a> or <a href=\"#!/api/Ext.panel.Panel-cfg-buttons\" rel=\"Ext.panel.Panel-cfg-buttons\" class=\"docClass\">buttons</a> configurations. It will be ignored for buttons that have a minWidth configured\nsome other way, e.g. in their own config object or via the <a href=\"#!/api/Ext.container.Container-cfg-defaults\" rel=\"Ext.container.Container-cfg-defaults\" class=\"docClass\">defaults</a> of\ntheir parent container.</p>\n"},"placeholder":{"!doc":"<p><strong>Important: This config is only effective for <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> Panels which are direct child items of a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a> when not using the <code>'header'</code> <a href=\"#!/api/Ext.panel.Panel-cfg-collapseMode\" rel=\"Ext.panel.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a>.</strong></p>\n\n<p><strong>Optional.</strong> A Component (or config object for a Component) to show in place of this Panel when this Panel is\ncollapsed by a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>. Defaults to a generated <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> containing a <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Tool</a> to re-expand the Panel.</p>\n"},"placeholderCollapseHideMode":{"!type":"number","!doc":"<p>The mode for hiding collapsed panels when\nusing <a href=\"#!/api/Ext.panel.Panel-cfg-collapseMode\" rel=\"Ext.panel.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a> \"placeholder\".</p>\n"},"preventHeader":{"!type":"bool"},"rbar":{"!doc":"<p>Convenience config. Short for 'Right Bar' (right-docked, vertical toolbar).</p>\n\n<pre><code>rbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'right',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.panel.Panel-method-getEl\" rel=\"Ext.panel.Panel-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.panel.Panel-method-getEl\" rel=\"Ext.panel.Panel-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.panel.Panel-cfg-renderSelectors\" rel=\"Ext.panel.Panel-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-childEls\" rel=\"Ext.panel.Panel-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"tbar":{"!doc":"<p>Convenience config. Short for 'Top Bar'.</p>\n\n<pre><code>tbar: [\n  { xtype: 'button', text: 'Button 1' }\n]\n</code></pre>\n\n<p>is equivalent to</p>\n\n<pre><code>dockedItems: [{\n    xtype: 'toolbar',\n    dock: 'top',\n    items: [\n        { xtype: 'button', text: 'Button 1' }\n    ]\n}]\n</code></pre>\n"},"titleAlign":{"!type":"string"},"titleCollapse":{"!type":"bool","!doc":"<p><code>true</code> to allow expanding and collapsing the panel (when <code><a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> = true</code>) by clicking anywhere in\nthe header bar, <code>false</code>) to allow it only by clicking to tool button). When a panel is used in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, the <a href=\"#!/api/Ext.panel.Panel-cfg-floatable\" rel=\"Ext.panel.Panel-cfg-floatable\" class=\"docClass\">floatable</a> option can influence the behavior of collapsing.</p>\n"},"titleRotation":{"!type":"string"},"tools":{"!doc":"<p>An array of <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a> configs/instances to be added to the header tool area. The tools are stored as\nchild components of the header container. They can be accessed using down and {#query}, as well as the\nother component methods. The toggle tool is automatically created if <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> is set to true.</p>\n\n<p>Note that, apart from the toggle tool which is provided when a panel is collapsible, these tools only provide the\nvisual button. Any required functionality must be provided by adding handlers that implement the necessary\nbehavior.</p>\n\n<p>Example usage:</p>\n\n<pre><code>tools:[{\n    type:'refresh',\n    tooltip: 'Refresh form Data',\n    // hidden:true,\n    handler: function(event, toolEl, panelHeader) {\n        // refresh logic\n    }\n},\n{\n    type:'help',\n    tooltip: 'Get Help',\n    callback: function(panel, tool, event) {\n        // show help here\n    }\n}]\n</code></pre>\n\n<p>The difference between <code>handler</code> and <code>callback</code> is the signature. For details on\nthe distinction, see <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a>.</p>\n"},"beforeRenderConfig":{},"body":{"!doc":"<p>The Panel's body Element which may be used to contain HTML content.\nThe content may be specified in the <a href=\"#!/api/Ext.panel.Panel-cfg-html\" rel=\"Ext.panel.Panel-cfg-html\" class=\"docClass\">html</a> config, or it may be loaded using the\n<a href=\"#!/api/Ext.panel.Panel-cfg-loader\" rel=\"Ext.panel.Panel-cfg-loader\" class=\"docClass\">loader</a> config. Read-only.</p>\n\n<p>If this is used to load visible HTML elements in either way, then\nthe Panel may not be used as a Layout for hosting nested Panels.</p>\n\n<p>If this Panel is intended to be used as the host of a Layout (See <a href=\"#!/api/Ext.panel.Panel-cfg-layout\" rel=\"Ext.panel.Panel-cfg-layout\" class=\"docClass\">layout</a>\nthen the body Element must not be loaded or changed - it is under the control\nof the Panel's Layout.</p>\n"},"contentPaddingProperty":{"!type":"string","!doc":"<p>The name of the padding property that is used by the layout to manage\npadding.  See <a href=\"#!/api/Ext.layout.container.Auto-property-managePadding\" rel=\"Ext.layout.container.Auto-property-managePadding\" class=\"docClass\">managePadding</a></p>\n"},"defaultBindProperty":{"!type":"string"},"emptyArray":{},"isPanel":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Panel, or subclass thereof.</p>\n"},"addBodyCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the body element. If not rendered, the class will\nbe added when the panel is rendered.</p>\n"},"addTool":{"!type":"fn(tools: ?) -> !this","!doc":"<p>Add tools to this panel</p>\n"},"addUIClsToElement":{"!type":"fn(cls: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"beginCollapse":{"!type":"fn() -> !this","!doc":"<p>Called before the change from default, configured state into the collapsed state.\nThis method may be called at render time to enable rendering in an initially collapsed state,\nor at runtime when an existing, fully layed out Panel may be collapsed.\nIt basically saves configs which need to be clobbered for the duration of the collapsed state.</p>\n"},"beginDrag":{"!type":"fn() -> !this"},"beginExpand":{"!type":"fn() -> !this"},"bridgeToolbars":{"!type":"fn() -> !this"},"calculateConstrainedPosition":{"!type":"fn(constrainTo: ?, proposedPosition: ?, local: ?, proposedSize: ?) -> !this","!doc":"<p>Override of Positionable method to calculate constrained position based upon possibly only\nconstraining our header.</p>\n"},"close":{"!type":"fn(panel: ?, eOpts: ?)","!doc":"<p>Fires when the user closes the panel.</p>\n"},"collapse":{"!type":"fn(p: ?, eOpts: ?)","!doc":"<p>Fires after this Panel has collapsed.</p>\n"},"collapsedHorizontal":{"!type":"fn() -> !this"},"collapsedVertical":{"!type":"fn() -> !this"},"convertCollapseDir":{"!type":"fn(collapseDir: ?) -> !this","!doc":"<p>converts a collapsdDir into an anchor argument for Element.slideIn\noverridden in rtl mode to switch \"l\" and \"r\"</p>\n"},"createReExpander":{"!type":"fn(direction: ?, defaults: ?) -> !this"},"doCollapseExpand":{"!type":"fn(flags: ?, animate: ?) -> !this"},"endDrag":{"!type":"fn() -> !this"},"expand":{"!type":"fn(p: ?, eOpts: ?)","!doc":"<p>Fires after this Panel has expanded.</p>\n"},"findReExpander":{"!type":"fn(direction: ?) -> !this"},"floatCollapsedPanel":{"!type":"fn() -> !this"},"getAnimationProps":{"!type":"fn() -> !this","!doc":"<ul>\n<li>get animation properties</li>\n</ul>\n\n"},"getCollapsed":{"!type":"fn() -> ?","!doc":"<p>Returns the current collapsed state of the panel.</p>\n"},"getCollapsedDockedItems":{"!type":"fn() -> !this"},"getComponent":{"!type":"fn(comp: ?) -> ?","!doc":"<p>Attempts a default component lookup (see <a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">Ext.container.Container.getComponent</a>). If the component is not found in the normal\nitems, the dockedItems are searched and the matched component (if any) returned (see <a href=\"#!/api/Ext.panel.Panel-method-getDockedComponent\" rel=\"Ext.panel.Panel-method-getDockedComponent\" class=\"docClass\">getDockedComponent</a>). Note that docked\nitems will only be matched by component id or itemId -- if you pass a numeric index only non-docked child components will be searched.</p>\n"},"getHeader":{"!type":"fn() -> !this","!doc":"<p>Gets the <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Header</a> for this panel.</p>\n"},"getHeaderCollapsedClasses":{"!type":"fn(header: ?) -> !this","!doc":"<p>Create the class array to add to the Header when collpsed.</p>\n"},"getHeightAuthority":{"!type":"fn() -> !this"},"getKeyMap":{"!type":"fn() -> !this"},"getMemento":{"!type":"fn(name: ?) -> !this","!doc":"<p>Memento Factory method</p>\n"},"getOppositeDirection":{"!type":"fn(d: ?) -> !this"},"getPlaceholder":{"!type":"fn(direction: ?) -> !this"},"getProtoBody":{"!type":"fn() -> !this"},"getReExpander":{"!type":"fn(direction: ?) -> !this"},"getRefItems":{"!type":"fn(deep: ?) -> !this","!doc":"<p>Used by ComponentQuery, child and down to retrieve all of the items\nwhich can potentially be considered a child of this Container.</p>\n\n<p>This may be overriden by Components which have ownership of Components\nthat are not contained in the <a href=\"#!/api/Ext.panel.Panel-property-items\" rel=\"Ext.panel.Panel-property-items\" class=\"docClass\">items</a> collection.</p>\n\n<p>NOTE: IMPORTANT note for maintainers:\nItems are returned in tree traversal order. Each item is appended to the result array\nfollowed by the results of that child's getRefItems call.\nFloating child items are appended after internal child items.</p>\n"},"ghost":{"!type":"fn(cls: ?) -> !this","!doc":"<p>used for dragging</p>\n"},"ghostTools":{"!type":"fn() -> !this","!doc":"<p>helper function for ghost</p>\n"},"initBodyBorder":{"!type":"fn() -> !this"},"initBodyStyles":{"!type":"fn() -> string","!doc":"<p>Parses the <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config if available to create a style string that will be applied to the body element.\nThis also includes <a href=\"#!/api/Ext.panel.Panel-cfg-bodyPadding\" rel=\"Ext.panel.Panel-cfg-bodyPadding\" class=\"docClass\">bodyPadding</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-bodyBorder\" rel=\"Ext.panel.Panel-cfg-bodyBorder\" class=\"docClass\">bodyBorder</a> if available.</p>\n"},"initBorderProps":{"!type":"fn() -> !this"},"initItems":{"!type":"fn() -> !this","!doc":"<p>This method is called to initialize the <code>items</code> collection. A derived class can\noverride this method to do any last minute manipulation of <code>items</code> and then call\nthis method using <code>callParent</code>. Upon return, the <code>items</code> will no longer be a simple\narray.</p>\n"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"initSimpleDraggable":{"!type":"fn() -> !this","!doc":"<p>Override Component.initDraggable.\nPanel (and subclasses) use the header element as the delegate.</p>\n"},"initTools":{"!type":"fn() -> !this","!doc":"<p>Tools are a Panel-specific capabilty.\nPanel uses initTools. Subclasses may contribute tools by implementing addTools.</p>\n"},"isLayoutRoot":{"!type":"fn() -> !this","!doc":"<p>Determines whether this Component is the root of a layout. This returns <code>true</code> if\nthis component can run its layout without assistance from or impact on its owner.\nIf this component cannot run its layout given these restrictions, <code>false</code> is returned\nand its owner will be considered as the next candidate for the layout root.</p>\n\n<p>Setting the <a href=\"#!/api/Ext.panel.Panel-property-_isLayoutRoot\" rel=\"Ext.panel.Panel-property-_isLayoutRoot\" class=\"docClass\">_isLayoutRoot</a> property to <code>true</code> causes this method to always\nreturn <code>true</code>. This may be useful when updating a layout of a Container which shrink\nwraps content, and you know that it will not change size, and so can safely be the\ntopmost participant in the layout run.</p>\n"},"isPlaceHolderCollapse":{"!type":"fn() -> !this"},"isVisible":{"!type":"fn(deep: ?) -> bool","!doc":"<p>Returns <code>true</code> if this component is visible.</p>\n"},"onBoxReady":{"!type":"fn() -> !this","!doc":"<p>Invoked when this component has first achieved size. Occurs after the\n<a href=\"#!/api/Ext.panel.Panel-cfg-componentLayout\" rel=\"Ext.panel.Panel-cfg-componentLayout\" class=\"docClass\">componentLayout</a> has completed its initial run.</p>\n"},"onHide":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the hide operation. After\ncalling the superclass's onHide, the Component will be hidden.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.panel.Panel-event-hide\" rel=\"Ext.panel.Panel-event-hide\" class=\"docClass\">hide</a>.</p>\n"},"onMouseEnterFloated":{"!type":"fn(e: ?) -> !this"},"onMouseLeaveFloated":{"!type":"fn(e: ?) -> !this"},"onPlaceholderResize":{"!type":"fn(ph: ?, newWidth: ?, newHeight: ?) -> !this"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.panel.Panel-event-removed\" rel=\"Ext.panel.Panel-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"placeholderCollapse":{"!type":"fn(direction: ?, animate: ?) -> !this"},"placeholderExpand":{"!type":"fn(animate: ?) -> !this"},"removeBodyCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the body element.</p>\n"},"removeUIClsFromElement":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Method which removes a specified UI + <code>uiCls</code> from the components element. The <code>cls</code>\nwhich is added to the element will be: <code>this.baseCls + '-' + ui + uiCls</code>.</p>\n"},"restoreDimension":{"!type":"fn() -> !this"},"restoreHiddenDocked":{"!type":"fn() -> !this"},"setBodyStyle":{"!type":"fn(style: ?, value: ?) -> ?","!doc":"<p>Sets the body style according to the passed parameters.</p>\n"},"setBorder":{"!type":"fn(border: ?, targetEl: ?) -> !this"},"setCollapsible":{"!type":"fn(collapsible: ?) -> !this"},"setHiddenDocked":{"!type":"fn() -> !this"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\n<code>uiCls</code> set on the component and rename them so they include the new UI.</p>\n"},"slideOutFloatedPanelBegin":{"!type":"fn() -> !this","!doc":"<p>This method begins the slide out of the floated panel.</p>\n"},"slideOutFloatedPanelEnd":{"!type":"fn(suppressEvents: ?) -> !this","!doc":"<p>This method cleans up after the slide out of the floated panel.</p>\n"},"toggleCollapse":{"!type":"fn() -> ?","!doc":"<p>Shortcut for performing an <a href=\"#!/api/Ext.panel.Panel-method-expand\" rel=\"Ext.panel.Panel-method-expand\" class=\"docClass\">expand</a> or <a href=\"#!/api/Ext.panel.Panel-method-collapse\" rel=\"Ext.panel.Panel-method-collapse\" class=\"docClass\">collapse</a> based on the current state of the panel.</p>\n"},"unghost":{"!type":"fn(show: ?, matchPosition: ?, focus: ?) -> !this"},"updateCollapseTool":{"!type":"fn() -> !this"},"updateGlyph":{"!type":"fn(glyph: ?, oldGlyph: ?) -> !this"},"updateHeader":{"!type":"fn(force: ?) -> !this","!doc":"<p>Create, hide, or show the header component as appropriate based on the current config.</p>\n"},"updateHeaderPosition":{"!type":"fn(position: ?) -> !this"},"updateIcon":{"!type":"fn(icon: ?, oldIcon: ?) -> !this"},"updateIconAlign":{"!type":"fn(align: ?) -> !this"},"updateIconCls":{"!type":"fn(iconCls: ?) -> !this","!doc":"<p>Set the iconCls for the panel's header. See <a href=\"#!/api/Ext.panel.Header-cfg-iconCls\" rel=\"Ext.panel.Header-cfg-iconCls\" class=\"docClass\">Ext.panel.Header.iconCls</a>. It will fire the\n<a href=\"#!/api/Ext.panel.Panel-event-iconclschange\" rel=\"Ext.panel.Panel-event-iconclschange\" class=\"docClass\">iconclschange</a> event after completion.</p>\n"},"updateTitle":{"!type":"fn(title: ?, oldTitle: ?) -> !this"},"updateTitleAlign":{"!type":"fn(align: ?) -> !this"},"updateTitleRotation":{"!type":"fn(rotation: ?) -> !this"},"beforeclose":{"!type":"fn(panel: ?, eOpts: ?)","!doc":"<p>Fires before the user closes the panel. Return false from any listener to stop the close event being\nfired</p>\n"},"beforecollapse":{"!type":"fn(p: ?, direction: ?, animate: ?, eOpts: ?)","!doc":"<p>Fires before this panel is collapsed. Return false to prevent the collapse.</p>\n"},"beforeexpand":{"!type":"fn(p: ?, animate: ?, eOpts: ?)","!doc":"<p>Fires before this panel is expanded. Return false to prevent the expand.</p>\n"},"float":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires after a collapsed Panel has been \"floated\" by clicking on\nit's header. Only applicable when the Panel is an item in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border Layout</a>.</p>\n"},"glyphchange":{"!type":"fn(this: ?, newGlyph: ?, oldGlyph: ?, eOpts: ?)","!doc":"<p>Fired when the Panel glyph has been changed by the setGlyph method.</p>\n"},"iconchange":{"!type":"fn(p: ?, newIcon: ?, oldIcon: ?, eOpts: ?)","!doc":"<p>Fires after the Panel icon has been set or changed.</p>\n"},"iconclschange":{"!type":"fn(p: ?, newIconCls: ?, oldIconCls: ?, eOpts: ?)","!doc":"<p>Fires after the Panel iconCls has been set or changed.</p>\n"},"titlechange":{"!type":"fn(p: ?, newTitle: ?, oldTitle: ?, eOpts: ?)","!doc":"<p>Fires after the Panel title has been set or changed.</p>\n"},"unfloat":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires after a \"floated\" Panel has returned to it's collapsed state\nas a result of the mouse leaving the Panel. Only applicable when\nthe Panel is an item in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border Layout</a>.</p>\n"},"!doc":"<p>Panel is a container that has specific functionality and structural components that make it the perfect building\nblock for application-oriented user interfaces.</p>\n\n<p>Panels are, by virtue of their inheritance from <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, capable of being configured with a\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>, and containing child Components.</p>\n\n<p>When either specifying child <a href=\"#!/api/Ext.panel.Panel-cfg-items\" rel=\"Ext.panel.Panel-cfg-items\" class=\"docClass\">items</a> of a Panel, or dynamically <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">adding</a>\nComponents to a Panel, remember to consider how you wish the Panel to arrange those child elements, and whether those\nchild elements need to be sized using one of Ext's built-in <code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code>\nschemes. By default, Panels use the <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Auto</a> scheme. This simply renders child\ncomponents, appending them one after the other inside the Container, and <strong>does not apply any sizing</strong> at all.</p>\n\n<p><p><img src=\"\" alt=\"Panel components\" width=\"\" height=\"\"></p></p>\n\n<p>A Panel may also contain <a href=\"#!/api/Ext.panel.Panel-cfg-bbar\" rel=\"Ext.panel.Panel-cfg-bbar\" class=\"docClass\">bottom</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-tbar\" rel=\"Ext.panel.Panel-cfg-tbar\" class=\"docClass\">top</a> toolbars, along with separate <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">header</a>, <a href=\"#!/api/Ext.panel.Panel-cfg-fbar\" rel=\"Ext.panel.Panel-cfg-fbar\" class=\"docClass\">footer</a> and body sections.</p>\n\n<p>Panel also provides built-in <a href=\"#!/api/Ext.panel.Panel-cfg-collapsible\" rel=\"Ext.panel.Panel-cfg-collapsible\" class=\"docClass\">collapsible, expandable</a> and <a href=\"#!/api/Ext.panel.Panel-cfg-closable\" rel=\"Ext.panel.Panel-cfg-closable\" class=\"docClass\">closable</a> behavior. Panels can\nbe easily dropped into any <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> or layout, and the layout and rendering pipeline\nis <a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">completely managed by the framework</a>.</p>\n\n<p><strong>Note:</strong> By default, the <code><a href=\"#!/api/Ext.panel.Panel-cfg-closable\" rel=\"Ext.panel.Panel-cfg-closable\" class=\"docClass\">close</a></code> header tool <em>destroys</em> the Panel resulting in removal of the\nPanel and the destruction of any descendant Components. This makes the Panel object, and all its descendants\n<strong>unusable</strong>. To enable the close tool to simply <em>hide</em> a Panel for later re-use, configure the Panel with\n<code><a href=\"#!/api/Ext.panel.Panel-cfg-closeAction\" rel=\"Ext.panel.Panel-cfg-closeAction\" class=\"docClass\">closeAction</a>: 'hide'</code>.</p>\n\n<p>Usually, Panels are used as constituents within an application, in which case, they would be used as child items of\nContainers, and would themselves use Ext.Components as child <a href=\"#!/api/Ext.panel.Panel-cfg-items\" rel=\"Ext.panel.Panel-cfg-items\" class=\"docClass\">items</a>. However to illustrate simply rendering a\nPanel into the document, here's how to do it:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    title: 'Hello',\n    width: 200,\n    html: '&lt;p&gt;World!&lt;/p&gt;',\n    renderTo: Ext.getBody()\n});\n</code></pre>\n\n<p>A more realistic scenario is a Panel created to house input fields which will not be rendered, but used as a\nconstituent part of a Container:</p>\n\n<pre class='inline-example '><code>var filterPanel = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    bodyPadding: 5,  // Don't want content to crunch against the borders\n    width: 300,\n    title: 'Filters',\n    items: [{\n        xtype: 'datefield',\n        fieldLabel: 'Start date'\n    }, {\n        xtype: 'datefield',\n        fieldLabel: 'End date'\n    }],\n    renderTo: Ext.getBody()\n});\n</code></pre>\n\n<p>Note that the Panel above is configured to render into the document and assigned a size. In a real world scenario,\nthe Panel will often be added inside a Container which will use a <a href=\"#!/api/Ext.panel.Panel-cfg-layout\" rel=\"Ext.panel.Panel-cfg-layout\" class=\"docClass\">layout</a> to render, size and position its\nchild Components.</p>\n\n<p>Panels will often use specific <a href=\"#!/api/Ext.panel.Panel-cfg-layout\" rel=\"Ext.panel.Panel-cfg-layout\" class=\"docClass\">layout</a>s to provide an application with shape and structure by containing and\narranging child Components:</p>\n\n<pre class='inline-example '><code>var resultsPanel = Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    title: 'Results',\n    width: 600,\n    height: 400,\n    renderTo: Ext.getBody(),\n    layout: {\n        type: 'vbox',       // Arrange child items vertically\n        align: 'stretch',    // Each takes up full width\n        padding: 5\n    },\n    items: [{               // Results grid specified as a config object with an xtype of 'grid'\n        xtype: 'grid',\n        columns: [{header: 'Column One'}],            // One header just for show. There's no data,\n        store: Ext.create('Ext.data.ArrayStore', {}), // A dummy empty data store\n        flex: 1                                       // Use 1/3 of Container's height (hint to Box layout)\n    }, {\n        xtype: 'splitter'   // A splitter between the two child items\n    }, {                    // Details Panel specified as a config object (no xtype defaults to 'panel').\n        title: 'Details',\n        bodyPadding: 5,\n        items: [{\n            fieldLabel: 'Data item',\n            xtype: 'textfield'\n        }], // An array of form fields\n        flex: 2             // Use 2/3 of Container's height (hint to Box layout)\n    }]\n});\n</code></pre>\n\n<p>The example illustrates one possible method of displaying search results. The Panel contains a grid with the\nresulting data arranged in rows. Each selected row may be displayed in detail in the Panel below. The <a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">vbox</a> layout is used to arrange the two vertically. It is configured to stretch child items\nhorizontally to full width. Child items may either be configured with a numeric height, or with a <code>flex</code> value to\ndistribute available space proportionately.</p>\n\n<p>This Panel itself may be a child item of, for exaple, a <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a> which will size its child items to fit\nwithin its content area.</p>\n\n<p>Using these techniques, as long as the <strong>layout</strong> is chosen and configured correctly, an application may have any\nlevel of nested containment, all dynamically sized according to configuration, the user's preference and available\nbrowser size.</p>\n","!type":"fn(config: ?)"},"Table":{"prototype":{"allowDeselect":{"!type":"bool","!doc":"<p>True to allow deselecting a record. This config is forwarded to <a href=\"#!/api/Ext.selection.Model-cfg-allowDeselect\" rel=\"Ext.selection.Model-cfg-allowDeselect\" class=\"docClass\">Ext.selection.Model.allowDeselect</a>.</p>\n"},"autoLoad":{"!type":"bool","!doc":"<p>Use <code>true</code> to load the store as soon as this component is fully constructed. It is\nbest to initiate the store load this way to allow this component and potentially\nits plugins (such as <code><a href=\"#!/api/Ext.grid.filters.Filters\" rel=\"Ext.grid.filters.Filters\" class=\"docClass\">Ext.grid.filters.Filters</a></code> to be ready to load.</p>\n"},"bufferedRenderer":{"!type":"bool","!doc":"<p><code>false</code> to disable buffered rendering. See Ext.grid.plugin.BufferedRenderer.</p>\n"},"columnLines":{"!type":"bool","!doc":"<p>Adds column line styling</p>\n"},"deferRowRender":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to enable deferred row rendering.</p>\n\n<p>This allows the View to execute a refresh quickly, with the update of the row structure deferred so\nthat layouts with GridPanels appear, and lay out more quickly.</p>\n"},"disableSelection":{"!type":"bool","!doc":"<p>True to disable selection model.</p>\n"},"emptyText":{"!type":"string","!doc":"<p>Default text (html tags are accepted) to display in the Panel body when the Store\nis empty. When specified, and the Store is empty, the text will be rendered inside a DIV with the CSS class \"x-grid-empty\".</p>\n"},"enableColumnHide":{"!type":"bool","!doc":"<p>False to disable column hiding within this grid.</p>\n"},"enableColumnMove":{"!type":"bool","!doc":"<p>False to disable column dragging within this grid.</p>\n"},"enableColumnResize":{"!type":"bool","!doc":"<p>False to disable column resizing within this grid.</p>\n"},"enableLocking":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to enable locking support for this grid. Alternatively, locking will also be automatically\nenabled if any of the columns in the <a href=\"#!/api/Ext.panel.Table-cfg-columns\" rel=\"Ext.panel.Table-cfg-columns\" class=\"docClass\">columns</a> configuration contain a <a href=\"#!/api/Ext.grid.column.Column-cfg-locked\" rel=\"Ext.grid.column.Column-cfg-locked\" class=\"docClass\">locked</a> config option.</p>\n\n<p>A locking grid is processed in a special way. The configuration options are cloned and <em>two</em> grids are created to be the locked (left) side\nand the normal (right) side. This Panel becomes merely a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">container</a> which arranges both in an <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">HBox</a> layout.</p>\n\n<p><a href=\"#!/api/Ext.panel.Table-cfg-plugins\" rel=\"Ext.panel.Table-cfg-plugins\" class=\"docClass\">Plugins</a> may be targeted at either locked, or unlocked grid, or, both, in which case the plugin is cloned and used on both sides.</p>\n\n<p>Plugins may also be targeted at the containing locking Panel.</p>\n\n<p>This is configured by specifying a <code>lockableScope</code> property in your plugin which may have the following values:</p>\n\n<ul>\n<li><code>\"both\"</code> (the default) - The plugin is added to both grids</li>\n<li><code>\"top\"</code> - The plugin is added to the containing Panel</li>\n<li><code>\"locked\"</code> - The plugin is added to the locked (left) grid</li>\n<li><code>\"normal\"</code> - The plugin is added to the normal (right) grid</li>\n</ul>\n\n\n<p>If <code>both</code> is specified, then each copy of the plugin gains a property <code>lockingPartner</code> which references its sibling on the other side so that they\ncan synchronize operations is necessary.</p>\n\n<p><a href=\"#!/api/Ext.panel.Table-cfg-features\" rel=\"Ext.panel.Table-cfg-features\" class=\"docClass\">Features</a> may also be configured with <code>lockableScope</code> and may target the locked grid, the normal grid or both grids. Features\nalso get a <code>lockingPartner</code> reference injected.</p>\n"},"features":{"!doc":"<p>An array of grid Features to be added to this grid. Can also be just a single feature instead of array.</p>\n\n<p>Features config behaves much like <a href=\"#!/api/Ext.panel.Table-cfg-plugins\" rel=\"Ext.panel.Table-cfg-plugins\" class=\"docClass\">plugins</a>.\nA feature can be added by either directly referencing the instance:</p>\n\n<pre><code>features: [Ext.create('<a href=\"#!/api/Ext.grid.feature.GroupingSummary\" rel=\"Ext.grid.feature.GroupingSummary\" class=\"docClass\">Ext.grid.feature.GroupingSummary</a>', {groupHeaderTpl: 'Subject: {name}'})],\n</code></pre>\n\n<p>By using config object with ftype:</p>\n\n<pre><code>features: [{ftype: 'groupingsummary', groupHeaderTpl: 'Subject: {name}'}],\n</code></pre>\n\n<p>Or with just a ftype:</p>\n\n<pre><code>features: ['grouping', 'groupingsummary'],\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Feature\" rel=\"Ext.enums.Feature\" class=\"docClass\">Ext.enums.Feature</a> for list of all ftypes.</p>\n"},"forceFit":{"!type":"bool","!doc":"<p>True to force the columns to fit into the available width. Headers are first sized according to configuration,\nwhether that be a specific width, or flex. Then they are all proportionally changed in width so that the entire\ncontent width is used. For more accurate control, it is more optimal to specify a flex setting on the columns\nthat are to be stretched &amp; explicit widths on columns that are not.</p>\n"},"hideHeaders":{"!type":"bool","!doc":"<p>True to hide column headers.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.panel.Table-cfg-items\" rel=\"Ext.panel.Table-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"leadingBufferZone":{"!type":"number","!doc":"<p>TableViews are buffer rendered in 5.x which means that only the visible subset of data rows\nare rendered into the DOM. These are removed and added as scrolling demands.</p>\n\n<p>This configures the number of extra rows to render on the leading side of scrolling\n<strong>outside the <a href=\"#!/api/Ext.panel.Table-cfg-numFromEdge\" rel=\"Ext.panel.Table-cfg-numFromEdge\" class=\"docClass\">numFromEdge</a></strong> buffer as scrolling proceeds.</p>\n"},"multiColumnSort":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have columns remember their sorted state after other columns have been clicked upon to sort.</p>\n\n<p>As subsequent columns are clicked upon, they become the new primary sort key.</p>\n\n<p>The maximum number of sorters allowed in a Store is configurable via its underlying data collection. See Ext.util.Collection.multiSortLimit</p>\n"},"multiSelect":{"!type":"bool","!doc":"<p>True to enable 'MULTI' selection mode on selection model.</p>\n"},"numFromEdge":{"!type":"number","!doc":"<p>This configures the zone which causes new rows to be appended to the view. As soon as the edge\nof the rendered grid is this number of rows from the edge of the viewport, the view is moved.</p>\n"},"reserveScrollbar":{"!type":"bool","!doc":"<p>Set this to true to <strong>always</strong> leave a scrollbar sized space at the end of the grid content when\nfitting content into the width of the grid.</p>\n\n<p>If the grid's record count fluctuates enough to hide and show the scrollbar regularly, this setting\navoids the multiple layouts associated with switching from scrollbar present to scrollbar not present.</p>\n"},"scroll":{"!doc":"<p>Scrollers configuration. Valid values are 'both', 'horizontal' or 'vertical'.\nTrue implies 'both'. False implies 'none'.</p>\n"},"sealedColumns":{"!type":"bool","!doc":"<p>True to constrain column dragging so that a column cannot be dragged in or out of it's\ncurrent group. Only relevant while <a href=\"#!/api/Ext.panel.Table-cfg-enableColumnMove\" rel=\"Ext.panel.Table-cfg-enableColumnMove\" class=\"docClass\">enableColumnMove</a> is enabled.</p>\n"},"selModel":{"!doc":"<p>A <a href=\"#!/api/Ext.selection.Model\" rel=\"Ext.selection.Model\" class=\"docClass\">selection model</a> instance or config object.  In latter case the <a href=\"#!/api/Ext.panel.Table-cfg-selType\" rel=\"Ext.panel.Table-cfg-selType\" class=\"docClass\">selType</a>\nconfig option determines to which type of selection model this config is applied.</p>\n"},"selType":{"!type":"string","!doc":"<p>An xtype of selection model to use. This is used to create selection model if just\na config object or nothing at all given in <a href=\"#!/api/Ext.panel.Table-cfg-selModel\" rel=\"Ext.panel.Table-cfg-selModel\" class=\"docClass\">selModel</a> config.</p>\n"},"simpleSelect":{"!type":"bool","!doc":"<p>True to enable 'SIMPLE' selection mode on selection model.</p>\n"},"sortableColumns":{"!type":"bool","!doc":"<p>False to disable column sorting via clicking the header and via the Sorting menu items.</p>\n"},"store":{"!doc":"<p>The Store the grid should use as its data source.</p>\n"},"trailingBufferZone":{"!type":"number","!doc":"<p>TableViews are buffer rendered in 5.x which means that only the visible subset of data rows\nare rendered into the DOM. These are removed and added as scrolling demands.</p>\n\n<p>This configures the number of extra rows to render on the trailing side of scrolling\n<strong>outside the <a href=\"#!/api/Ext.panel.Table-cfg-numFromEdge\" rel=\"Ext.panel.Table-cfg-numFromEdge\" class=\"docClass\">numFromEdge</a></strong> buffer as scrolling proceeds.</p>\n"},"variableRowHeight":{"!type":"bool"},"view":{"!doc":"<p>The <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a> used by the grid. Use <a href=\"#!/api/Ext.panel.Table-cfg-viewConfig\" rel=\"Ext.panel.Table-cfg-viewConfig\" class=\"docClass\">viewConfig</a> to just supply some config options to\nview (instead of creating an entire View instance).</p>\n"},"viewConfig":{"!doc":"<p>A config object that will be applied to the grid's UI view. Any of the config options available for\n<a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a> can be specified here. This option is ignored if <a href=\"#!/api/Ext.panel.Table-cfg-view\" rel=\"Ext.panel.Table-cfg-view\" class=\"docClass\">view</a> is specified.</p>\n"},"colLinesCls":{"!type":"string"},"defaultBindProperty":{"!type":"string"},"emptyCls":{"!type":"string"},"extraBaseCls":{"!type":"string"},"extraBodyCls":{"!type":"string"},"hasView":{"!type":"bool","!doc":"<p>True to indicate that a view has been injected into the panel.</p>\n"},"hiddenHeaderCls":{"!type":"string"},"hiddenHeaderCtCls":{"!type":"string"},"noRowLinesCls":{"!type":"string"},"optimizedColumnMove":{"!type":"bool","!doc":"<p>If you are writing a grid plugin or a {<a href=\"#!/api/Ext.grid.feature.Feature\" rel=\"Ext.grid.feature.Feature\" class=\"docClass\">Ext.grid.feature.Feature</a> Feature} which creates a column-based structure which\nneeds a view refresh when columns are moved, then set this property in the grid.</p>\n\n<p>An example is the built in <a href=\"#!/api/Ext.grid.feature.AbstractSummary\" rel=\"Ext.grid.feature.AbstractSummary\" class=\"docClass\">Summary</a> Feature. This creates summary rows, and the\nsummary columns must be in the same order as the data columns. This plugin sets the <code>optimizedColumnMove</code> to `false.</p>\n"},"ownerGrid":{"!doc":"<p>A reference to the top-level owning grid component. This is <code>null</code> if this grid is\nnot part of a locked grid arrangement.</p>\n"},"resizeMarkerCls":{"!type":"string"},"rowLinesCls":{"!type":"string"},"scrollerOwner":{"!type":"bool","!doc":"<p>private property used to determine where to go down to find views\nthis is here to support locking.</p>\n"},"afterCollapse":{"!type":"fn() -> !this","!doc":"<p>Invoked after the Panel is Collapsed.</p>\n"},"afterExpand":{"!type":"fn() -> !this","!doc":"<p>Invoked after the Panel is Expanded.</p>\n"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Applies the state to the object. This should be overridden in subclasses to do\nmore complex state operations. By default it applies the state properties onto\nthe current object.</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"bindStore":{"!type":"fn(store: ?, initial: ?) -> !this"},"delayScroll":{"!type":"fn() -> !this"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys the Component.</p>\n"},"getColumnManager":{"!type":"fn() -> !this"},"getEditorParent":{"!type":"fn() -> !this"},"getLhsMarker":{"!type":"fn() -> !this","!doc":"<p>Gets left hand side marker for header resizing.</p>\n"},"getRhsMarker":{"!type":"fn() -> !this","!doc":"<p>Gets right hand side marker for header resizing.</p>\n"},"getScrollTarget":{"!type":"fn() -> !this"},"getScrollerOwner":{"!type":"fn() -> !this"},"getSelection":{"!type":"fn() -> ?","!doc":"<p>Returns the grid's selection. See <code><a href=\"#!/api/Ext.selection.Model-method-getSelection\" rel=\"Ext.selection.Model-method-getSelection\" class=\"docClass\">Ext.selection.Model.getSelection</a></code>.</p>\n"},"getSelectionModel":{"!type":"fn() -> ?","!doc":"<p>Returns the selection model being used and creates it via the configuration if it has not been created already.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>The supplied default state gathering method for the Component class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.panel.Table-cfg-stateId\" rel=\"Ext.panel.Table-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n"},"getStore":{"!type":"fn() -> ?","!doc":"<p>Returns the store associated with this Panel.</p>\n"},"getTopLevelColumnManager":{"!type":"fn() -> !this"},"getTopLevelVisibleColumnManager":{"!type":"fn() -> !this"},"getView":{"!type":"fn() -> ?","!doc":"<p>Gets the view for this panel.</p>\n"},"getVisibleColumnManager":{"!type":"fn() -> !this"},"hasLockedColumns":{"!type":"fn(columns: ?) -> !this","!doc":"<p>Private. Determine if there are any columns with a locked configuration option</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onHeaderHide":{"!type":"fn(headerCt: ?, header: ?) -> !this","!doc":"<p>Section onHeaderHide is invoked after view.</p>\n"},"onHeaderMove":{"!type":"fn(headerCt: ?, header: ?, colsToMove: ?, fromIdx: ?, toIdx: ?) -> !this","!doc":"<p>Update the view when a header moves</p>\n"},"onHeaderResize":{"!type":"fn() -> !this"},"onHeaderShow":{"!type":"fn(headerCt: ?, header: ?) -> !this"},"onHeadersChanged":{"!type":"fn(headerCt: ?, header: ?) -> !this","!doc":"<p>To be triggered on add/remove/move for a leaf header</p>\n"},"onHorizontalScroll":{"!type":"fn(view: ?) -> !this"},"onRestoreHorzScroll":{"!type":"fn() -> !this","!doc":"<p>Tracks when things happen to the view and preserves the horizontal scroll position.</p>\n"},"onStoreLoad":{"!type":"fn() -> !this","!doc":"<p>template method meant to be overriden</p>\n"},"onViewReady":{"!type":"fn() -> !this","!doc":"<p>Fires the TablePanel's viewready event when the view declares that its internal DOM is ready</p>\n"},"processEvent":{"!type":"fn(type: ?, view: ?, cell: ?, recordIndex: ?, cellIndex: ?, e: ?) -> !this","!doc":"<p>Processes UI events from the view. Propagates them to whatever internal Components need to process them.</p>\n"},"relayHeaderCtEvents":{"!type":"fn(headerCt: ?) -> !this"},"restoreScrollPos":{"!type":"fn() -> !this"},"saveScrollPos":{"!type":"fn() -> !this"},"scrollByDeltaX":{"!type":"fn(xDelta: ?, animate: ?) -> !this"},"scrollByDeltaY":{"!type":"fn(yDelta: ?, animate: ?) -> !this"},"setAutoScroll":{"!type":"fn() -> !this","!doc":"<p>autoScroll is never valid for all classes which extend TablePanel.</p>\n"},"setColumns":{"!type":"fn(columns: ?) -> !this"},"setSelection":{"!type":"fn(records: ?, keepExisting?: ?, suppressEvent?: ?) -> !this","!doc":"<p>Sets the grid's selection. See <code><a href=\"#!/api/Ext.selection.Model-method-select\" rel=\"Ext.selection.Model-method-select\" class=\"docClass\">Ext.selection.Model.select</a></code>.</p>\n"},"setStore":{"!type":"fn(store: ?) -> !this"},"syncHorizontalScroll":{"!type":"fn(target: ?, setBody: ?) -> !this"},"unbindStore":{"!type":"fn() -> !this"},"beforecellclick":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell click is processed. Return false to cancel the default action.</p>\n"},"beforecellcontextmenu":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell right click is processed. Return false to cancel the default action.</p>\n"},"beforecelldblclick":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell double click is processed. Return false to cancel the default action.</p>\n"},"beforecellkeydown":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell key down is processed. Return false to cancel the default action.</p>\n"},"beforecellmousedown":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell mouse down is processed. Return false to cancel the default action.</p>\n"},"beforecellmouseup":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired before the cell mouse up is processed. Return false to cancel the default action.</p>\n"},"beforecontainerclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the click event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainercontextmenu":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the contextmenu event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainerdblclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the dblclick event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainerkeydown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the keydown event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainermousedown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mousedown event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainermouseout":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseout event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainermouseover":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseover event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforecontainermouseup":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseup event on the container is processed. Returns false to cancel the default action.</p>\n"},"beforedeselect":{"!type":"fn(this: ?, record: ?, index: ?, eOpts: ?)","!doc":"<p>Fired before a record is deselected. If any listener returns false, the\ndeselection is cancelled.</p>\n"},"beforeitemclick":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the click event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemcontextmenu":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the contextmenu event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemdblclick":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the dblclick event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemkeydown":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the keydown event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemmousedown":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mousedown event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemmouseenter":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseenter event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemmouseleave":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseleave event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeitemmouseup":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires before the mouseup event on an item is processed. Returns false to cancel the default action.</p>\n"},"beforeselect":{"!type":"fn(this: ?, record: ?, index: ?, eOpts: ?)","!doc":"<p>Fired before a record is selected. If any listener returns false, the\nselection is cancelled.</p>\n"},"cellclick":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is clicked.</p>\n"},"cellcontextmenu":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is right clicked.</p>\n"},"celldblclick":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is double clicked.</p>\n"},"cellkeydown":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the keydown event is captured on the cell.</p>\n"},"cellmousedown":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the mousedown event is captured on the cell.</p>\n"},"cellmouseup":{"!type":"fn(this: ?, td: ?, cellIndex: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the mouseup event is captured on the cell.</p>\n"},"columnhide":{"!type":"fn(ct: ?, column: ?, eOpts: ?)"},"columnmove":{"!type":"fn(ct: ?, column: ?, fromIdx: ?, toIdx: ?, eOpts: ?)"},"columnresize":{"!type":"fn(ct: ?, column: ?, width: ?, eOpts: ?)"},"columnschanged":{"!type":"fn(ct: ?, eOpts: ?)","!doc":"<p>Fired after the columns change in any way, when a column has been hidden or shown, or when a column\nis added to or removed from this header container.</p>\n"},"columnshow":{"!type":"fn(ct: ?, column: ?, eOpts: ?)"},"containerclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the container is clicked.</p>\n"},"containercontextmenu":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the container is right clicked.</p>\n"},"containerdblclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the container is double clicked.</p>\n"},"containerkeydown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when a key is pressed while the container is focused, and no item is currently selected.</p>\n"},"containermousedown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when there is a mousedown on the container</p>\n"},"containermouseout":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when you move the mouse out of the container.</p>\n"},"containermouseover":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when you move the mouse over the container.</p>\n"},"containermouseup":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when there is a mouseup on the container</p>\n"},"deselect":{"!type":"fn(this: ?, record: ?, index: ?, eOpts: ?)","!doc":"<p>Fired after a record is deselected</p>\n"},"filterchange":{"!type":"fn(eOpts: ?)"},"groupchange":{"!type":"fn(eOpts: ?)"},"headerclick":{"!type":"fn(ct: ?, column: ?, e: ?, t: ?, eOpts: ?)"},"headercontextmenu":{"!type":"fn(ct: ?, column: ?, e: ?, t: ?, eOpts: ?)"},"headertriggerclick":{"!type":"fn(ct: ?, column: ?, e: ?, t: ?, eOpts: ?)"},"itemclick":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when an item is clicked.</p>\n"},"itemcontextmenu":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when an item is right clicked.</p>\n"},"itemdblclick":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when an item is double clicked.</p>\n"},"itemkeydown":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when a key is pressed while an item is currently selected.</p>\n"},"itemmousedown":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when there is a mouse down on an item</p>\n"},"itemmouseenter":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse enters an item.</p>\n"},"itemmouseleave":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse leaves an item.</p>\n"},"itemmouseup":{"!type":"fn(this: ?, record: ?, item: ?, index: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when there is a mouse up on an item</p>\n"},"rowclick":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is clicked.</p>\n"},"rowcontextmenu":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is right clicked.</p>\n"},"rowdblclick":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when table cell is double clicked.</p>\n"},"rowkeydown":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the keydown event is captured on the cell.</p>\n"},"rowmousedown":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the mousedown event is captured on the cell.</p>\n"},"rowmouseup":{"!type":"fn(this: ?, record: ?, tr: ?, rowIndex: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the mouseup event is captured on the cell.</p>\n"},"select":{"!type":"fn(this: ?, record: ?, index: ?, eOpts: ?)","!doc":"<p>Fired after a record is selected</p>\n"},"selectionchange":{"!type":"fn(this: ?, selected: ?, eOpts: ?)","!doc":"<p>Fired after a selection change has occurred</p>\n"},"sortchange":{"!type":"fn(ct: ?, column: ?, direction: ?, eOpts: ?)"},"viewready":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when the grid view is available (use this for selecting a default row).</p>\n"},"columns":{"!doc":"<p>An array of <a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column</a> definition objects which define all columns that appear in this\ngrid. Each column definition provides the header text for the column, and a definition of where the data for that\ncolumn comes from.</p>\n\n<p>This can also be a configuration object for a <a href=\"#!/api/Ext.grid.header.Container\" rel=\"Ext.grid.header.Container\" class=\"docClass\">HeaderContainer</a> which may override\ncertain default configurations if necessary. For example, the special layout may be overridden to use a simpler\nlayout, or one can set default values shared by all columns:</p>\n\n<pre><code>columns: {\n    items: [\n        {\n            text: \"Column A\",\n            dataIndex: \"field_A\"\n        },{\n            text: \"Column B\",\n            dataIndex: \"field_B\"\n        }, \n        ...\n    ],\n    defaults: {\n        flex: 1\n    }\n}\n</code></pre>\n"},"rowLines":{"!type":"bool","!doc":"<p>Adds row line styling</p>\n"},"viewType":{"!type":"string","!doc":"<p>An xtype of view to use. This is automatically set to 'gridview' by <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Grid</a>\nand to 'treeview' by <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">Tree</a>.</p>\n"},"reconfigure":{"!type":"fn(store: ?, columns: ?) -> !this","!doc":"<p>documented on GridPanel</p>\n"}},"!doc":"<p>This class is the base class for both <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">TreePanel</a> and\n<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">GridPanel</a>.</p>\n\n<p>TablePanel aggregates:</p>\n\n<ul>\n<li>a Selection Model</li>\n<li>a View</li>\n<li>a Store</li>\n<li><a href=\"#!/api/Ext.grid.header.Container\" rel=\"Ext.grid.header.Container\" class=\"docClass\">Ext.grid.header.Container</a></li>\n</ul>\n\n","!type":"fn(config: ?)"},"Bar":{"!doc":"<p>Abstract base class for common functionality shared between <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a>\nand <a href=\"#!/api/Ext.tab.Bar\" rel=\"Ext.tab.Bar\" class=\"docClass\">Ext.tab.Bar</a></p>\n","!type":"fn(config: ?)","prototype":{"_verticalSides":{},"privates":{"!doc":"<hr />\n\n<p> End Methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n"},"vertical":{"!type":"bool"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.panel.Bar-event-added\" rel=\"Ext.panel.Bar-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.panel.Bar-event-removed\" rel=\"Ext.panel.Bar-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"setDock":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"}}},"DD":{"!doc":"<p>DD implementation for Panels.</p>\n","!type":"fn(panel: ?, cfg: ?)","prototype":{"afterInvalidDrop":{"!type":"fn(e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nafter an invalid drop has occurred by providing an implementation.</p>\n"},"autoOffset":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was clicked.</p>\n"},"b4MouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"b4StartDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"createFrame":{"!type":"fn() -> !this","!doc":"<p>Creates the proxy element if it does not yet exist</p>\n"},"endDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>\nBy default we try to move the element to the last location of the frame.\nThis is so that the default behavior mirrors that of <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.</p>\n"},"getDragEl":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns a reference to the actual element to drag.  By default this is\nthe same as the html element, but it can be assigned to another\nelement. An example of this can be found in <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n"},"onInitDrag":{"!type":"fn(x: ?, y: ?) -> !this"},"onInvalidDrop":{"!type":"fn(target: ?, e: ?, id: ?) -> !this","!doc":"<p>Override this, we don't want to repair on an \"invalid\" drop, the panel\nshould main it's position</p>\n"},"setupEl":{"!type":"fn(panel: ?) -> !this"},"showFrame":{"!type":"fn(iPageX: ?, iPageY: ?) -> !this","!doc":"<p>Resizes the drag frame to the dimensions of the clicked object, positions\nit over the object, and finally displays it</p>\n"},"startDrag":{"!type":"fn() -> !this","!doc":"<p>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met.</p>\n"}}},"Header":{"!doc":"<p>Simple header class which is used for on <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a> and <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>.</p>\n","!type":"fn(config: ?)","prototype":{"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon for the panel header. The\ndefault font-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"icon":{"!type":"string","!doc":"<p>Path to image for an icon.</p>\n\n<p>There are no default icons that come with Ext JS.</p>\n"},"iconAlign":{"!type":"string","!doc":"<p>For performance reasons we give the following configs their default values on\nthe class body.  This prevents the updaters from running on initialization in the\ndefault configuration scenario</p>\n"},"iconCls":{"!type":"string","!doc":"<p>CSS class for an icon.</p>\n\n<p>There are no default icon classes that come with Ext JS.</p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0 (or <code>false</code>): Neither width nor height depend on content.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2 (default): Height depends on content (shrink wraps), but width does not.</li>\n<li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"title":{"!doc":"<p>The title text or config object for the <a href=\"#!/api/Ext.panel.Title\" rel=\"Ext.panel.Title\" class=\"docClass\">Title</a> component.</p>\n"},"titleAlign":{"!type":"string"},"titlePosition":{"!type":"number"},"titleRotation":{"!type":"string"},"weight":{"!type":"number","!doc":"<p>A value to control how Components are laid out in a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Border</a> layout or as docked items.</p>\n\n<p>In a Border layout, this can control how the regions (not the center) region lay out if the west or east take full height\nor if the north or south region take full width. Also look at the <a href=\"#!/api/Ext.layout.container.Border-cfg-regionWeights\" rel=\"Ext.layout.container.Border-cfg-regionWeights\" class=\"docClass\">Ext.layout.container.Border.regionWeights</a> on the Border layout. An example to show how you can\ntake control of this is:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>', {\n    layout      : 'border',\n    defaultType : 'panel',\n    items       : [\n        {\n            region : 'north',\n            title  : 'North',\n            height : 100\n        },\n        {\n            region : 'south',\n            title  : 'South',\n            height : 100,\n            weight : -25\n        },\n        {\n            region : 'west',\n            title  : 'West',\n            width  : 200,\n            weight : 15\n        },\n        {\n            region : 'east',\n            title  : 'East',\n            width  : 200\n        },\n        {\n            region : 'center',\n            title  : 'center'\n        }\n    ]\n});\n</code></pre>\n\n<p>If docked items, the weight will order how the items are laid out. Here is an example to put a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a> above\na <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>'s header:</p>\n\n<pre><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    renderTo    : document.body,\n    width       : 300,\n    height      : 300,\n    title       : 'Panel',\n    html        : 'Panel Body',\n    dockedItems : [\n        {\n            xtype : 'toolbar',\n            items : [\n                {\n                    text : 'Save'\n                }\n            ]\n        },\n        {\n            xtype  : 'toolbar',\n            weight : -10,\n            items  : [\n                {\n                    text : 'Remove'\n                }\n            ]\n        }\n    ]\n});\n</code></pre>\n"},"beforeRenderConfig":{},"headerCls":{"!type":"string","!doc":"<p>a class for styling that is shared between panel and window headers</p>\n"},"indicateDrag":{"!type":"bool"},"isHeader":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Header, or subclass thereof.</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n"},"addTool":{"!type":"fn(tool: ?) -> !this","!doc":"<p>Add a tool to the header</p>\n"},"afterLayout":{"!type":"fn() -> !this","!doc":"<p>Invoked after the Container has laid out (and rendered if necessary)\nits child Components.</p>\n"},"applyTitle":{"!type":"fn(title: ?, oldTitle: ?) -> !this"},"applyTitlePosition":{"!type":"fn(position: ?) -> !this"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"getTools":{"!type":"fn() -> ?","!doc":"<p>Gets the tools for this header.</p>\n"},"onAdd":{"!type":"fn(component: ?, index: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been added. It\nis passed the Component which has been added. This method may\nbe used to update any internal structure which may depend upon\nthe state of the child items.</p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.panel.Header-event-added\" rel=\"Ext.panel.Header-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onRemoved":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.panel.Header-event-removed\" rel=\"Ext.panel.Header-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"setDock":{"!type":"fn(dock: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"updateGlyph":{"!type":"fn(glyph: ?) -> !this"},"updateIcon":{"!type":"fn(icon: ?) -> !this"},"updateIconAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"},"updateIconCls":{"!type":"fn(cls: ?) -> !this"},"updateTitle":{"!type":"fn(title: ?, oldTitle: ?) -> !this"},"updateTitleAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"},"updateTitlePosition":{"!type":"fn(position: ?) -> !this"},"updateTitleRotation":{"!type":"fn(rotation: ?) -> !this"},"click":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the header is clicked. This event will not be fired\nif the click was on a <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a></p>\n"},"dblclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the header is double clicked. This event will not\nbe fired if the click was on a <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a></p>\n"}}},"Pinnable":{"!doc":"<p>This mixin is applied to panels that want to manage a Pin state and corresponding tool.</p>\n","prototype":{"mixinId":{"!type":"string"},"pinnable":{"!type":"bool"},"pinnedTip":{"!type":"string"},"unpinnedTip":{"!type":"string"},"initPinnable":{"!type":"fn() -> !this"},"isPinned":{"!type":"fn() -> !this"},"setPinned":{"!type":"fn(pinned: ?) -> !this"},"togglePin":{"!type":"fn() -> !this"},"updatePinned":{"!type":"fn(pinned: ?) -> !this"}}},"Proxy":{"!doc":"<p>A custom drag proxy implementation specific to <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>s. This class\nis primarily used internally for the Panel's drag drop implementation, and\nshould never need to be created directly.</p>\n","!type":"fn(panel: ?, config?: ?)","prototype":{"insertProxy":{"!type":"bool","!doc":"<p>True to insert a placeholder proxy element while dragging the panel, false to drag with no proxy.\nMost Panels are not absolute positioned and therefore we need to reserve this space.</p>\n"},"moveOnDrag":{"!type":"bool","!doc":"<p>True to move the panel to the dragged position when dropped</p>\n"},"panel":{},"getEl":{"!type":"fn() -> ?","!doc":"<p>Gets the proxy's element</p>\n"},"getGhost":{"!type":"fn() -> ?","!doc":"<p>Gets the proxy's ghost Panel</p>\n"},"getProxy":{"!type":"fn() -> ?","!doc":"<p>Gets the proxy element. This is the element that represents where the\nPanel was before we started the drag operation.</p>\n"},"hide":{"!type":"fn() -> !this","!doc":"<p>Hides the proxy</p>\n"},"moveProxy":{"!type":"fn(parentNode: ?, before?: ?) -> !this","!doc":"<p>Moves the proxy to a different position in the DOM.  This is typically\ncalled while dragging the Panel to keep the proxy sync'd to the Panel's\nlocation.</p>\n"},"repair":{"!type":"fn(xy: ?, callback: ?, scope: ?) -> !this","!doc":"<p>private</p>\n"},"reset":{"!type":"fn() -> !this"},"setStatus":{"!type":"fn() -> !this","!doc":"<p>private overrides</p>\n"},"show":{"!type":"fn() -> !this","!doc":"<p>Shows the proxy</p>\n"},"stop":{"!type":"fn() -> !this"},"sync":{"!type":"fn() -> !this"},"update":{"!type":"fn() -> !this"}}},"Title":{"!doc":"<p>A basic title component for a Panel Header</p>\n","!type":"fn(config: ?)","prototype":{"autoEl":{"!doc":"<p>A tag name or DomHelper spec used to create the <a href=\"#!/api/Ext.panel.Title-method-getEl\" rel=\"Ext.panel.Title-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.panel.Title-cfg-renderTpl\" rel=\"Ext.panel.Title-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon. The\ndefault font-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"icon":{"!type":"string","!doc":"<p>Path to image for an icon.</p>\n"},"iconAlign":{"!type":"string"},"iconCls":{"!type":"string","!doc":"<p>CSS class for an icon.</p>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.panel.Title-method-getEl\" rel=\"Ext.panel.Title-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.panel.Title-method-getEl\" rel=\"Ext.panel.Title-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.panel.Title-cfg-renderSelectors\" rel=\"Ext.panel.Title-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.panel.Title-cfg-childEls\" rel=\"Ext.panel.Title-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"rotation":{"!type":"number"},"text":{"!type":"string"},"textAlign":{"!type":"string","!doc":"<p>For performance reasons we give the following configs their default values on\nthe class body.  This prevents the updaters from running on initialization in the\ndefault configuration scenario</p>\n"},"_baseIconCls":{"!type":"string"},"_glyphCls":{"!type":"string"},"_iconAlignClasses":{},"_iconWrapCls":{"!type":"string"},"_itemCls":{"!type":"string"},"_rotationAngles":{},"_rotationClasses":{},"_textAlignClasses":{},"_textCls":{"!type":"string"},"_titleSuffix":{"!type":"string"},"beforeRenderConfig":{},"iconTpl":{"!type":"string"},"isTitle":{"!type":"bool"},"noWrap":{"!type":"bool","!doc":"<p>layout system optimization.  Allows autocomponent layout to measure height without\nhaving to first know the width.</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Positionable methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"afterComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"applyText":{"!type":"fn(text: ?) -> !this"},"beforeRender":{"!type":"fn() -> !this"},"getIconMarkup":{"!type":"fn() -> !this"},"getIconRenderData":{"!type":"fn() -> !this"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?, instanced: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.panel.Title-event-added\" rel=\"Ext.panel.Title-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onRender":{"!type":"fn() -> !this","!doc":"<p>Template method called when this Component's DOM structure is created.</p>\n\n<p>At this point, this Component's (and all descendants') DOM structure <em>exists</em> but it has not\nbeen layed out (positioned and sized).</p>\n\n<p>Subclasses which override this to gain access to the structure at render time should\ncall the parent class's method before attempting to access any child elements of the Component.</p>\n"},"updateGlyph":{"!type":"fn(glyph: ?, oldGlyph: ?) -> !this"},"updateIcon":{"!type":"fn(icon: ?, oldIcon: ?) -> !this"},"updateIconAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"},"updateIconCls":{"!type":"fn(cls: ?, oldCls: ?) -> !this"},"updateRotation":{"!type":"fn(rotation: ?, oldRotation: ?) -> !this"},"updateText":{"!type":"fn(text: ?) -> !this"},"updateTextAlign":{"!type":"fn(align: ?, oldAlign: ?) -> !this"}}},"Tool":{"!doc":"<p>This class is used to display small visual icons in the header of a panel. There are a set of\n25 icons that can be specified by using the <a href=\"#!/api/Ext.panel.Tool-cfg-type\" rel=\"Ext.panel.Tool-cfg-type\" class=\"docClass\">type</a> config. The <a href=\"#!/api/Ext.panel.Tool-cfg-callback\" rel=\"Ext.panel.Tool-cfg-callback\" class=\"docClass\">callback</a> config\ncan be used to provide a function that will respond to any click events. In general, this class\nwill not be instantiated directly, rather it will be created by specifying the <a href=\"#!/api/Ext.panel.Panel-cfg-tools\" rel=\"Ext.panel.Panel-cfg-tools\" class=\"docClass\">Ext.panel.Panel.tools</a>\nconfiguration on the Panel itself.</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>', {\n    width: 200,\n    height: 200,\n    renderTo: document.body,\n    title: 'A Panel',\n    tools: [{\n        type: 'help',\n        callback: function() {\n            // show help here\n        }\n    }, {\n        itemId: 'refresh',\n        type: 'refresh',\n        hidden: true,\n        callback: function() {\n            // do refresh\n        }\n    }, {\n        type: 'search',\n        callback: function (panel) {\n            // do search\n            panel.down('#refresh').show();\n        }\n    }]\n});\n</code></pre>\n\n<p>The <code>callback</code> config was added in Ext JS 4.2.1 as an alternative to <a href=\"#!/api/Ext.panel.Tool-cfg-handler\" rel=\"Ext.panel.Tool-cfg-handler\" class=\"docClass\">handler</a>\nto provide a more convenient list of arguments. In Ext JS 4.2.1 it is also possible to\npass a method name instead of a direct function:</p>\n\n<pre><code> tools: [{\n     type: 'help',\n     callback: 'onHelp',\n     scope: this\n },\n ...\n</code></pre>\n\n<p>The <code>callback</code> (or <code>handler</code>) name is looked up on the <code>scope</code> which will also be the\n<code>this</code> reference when the method is called.</p>\n","!type":"fn(config: ?)","prototype":{"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"callback":{"!doc":"<p>A function to execute when the tool is clicked.</p>\n"},"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"disabledCls":{"!type":"string","!doc":"<p>CSS class to add when the Component is disabled.</p>\n"},"handler":{"!doc":"<p>A function to execute when the tool is clicked. Arguments passed are:</p>\n\n<ul>\n<li><strong>event</strong> : Ext.event.Event - The click event.</li>\n<li><strong>toolEl</strong> : Ext.Element - The tool Element.</li>\n<li><strong>owner</strong> : <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a> - The host panel header.</li>\n<li><strong>tool</strong> : <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a> - The tool object</li>\n</ul>\n\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.panel.Tool-method-getEl\" rel=\"Ext.panel.Tool-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.panel.Tool-method-getEl\" rel=\"Ext.panel.Tool-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.panel.Tool-cfg-renderSelectors\" rel=\"Ext.panel.Tool-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.panel.Tool-cfg-childEls\" rel=\"Ext.panel.Tool-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"scope":{"!doc":"<p>The scope to execute the <a href=\"#!/api/Ext.panel.Tool-cfg-callback\" rel=\"Ext.panel.Tool-cfg-callback\" class=\"docClass\">callback</a> or <a href=\"#!/api/Ext.panel.Tool-cfg-handler\" rel=\"Ext.panel.Tool-cfg-handler\" class=\"docClass\">handler</a> function. Defaults\nto the tool.</p>\n"},"stopEvent":{"!type":"bool","!doc":"<p>Specify as false to allow click event to propagate.</p>\n"},"toolOverCls":{"!type":"string"},"toolOwner":{"!doc":"<p>The owner to report to the <code>callback</code> method. Default is <code>null</code> for the <code>ownerCt</code>.\nThis is automatically set to the owning <code><a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a></code> when a tool is created as\na member of a panel's <code>tools</code>.</p>\n"},"toolPressedCls":{"!type":"string"},"tooltip":{"!doc":"<p>The tooltip for the tool - can be a string to be used as innerHTML (html tags are accepted) or QuickTips config\nobject</p>\n"},"tooltipType":{"!type":"string","!doc":"<p>The type of tooltip to use. Either 'qtip' (default) for QuickTips or 'title' for title attribute.</p>\n"},"type":{"!type":"string","!doc":"<p>The type of tool to render. The following types are available:</p>\n\n<ul>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-close\"></span> close</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-minimize\"></span> minimize</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-maximize\"></span> maximize</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-restore\"></span> restore</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-toggle\"></span> toggle</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-gear\"></span> gear</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-prev\"></span> prev</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-next\"></span> next</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-pin\"></span> pin</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-unpin\"></span> unpin</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-right\"></span> right</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-left\"></span> left</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-down\"></span> down</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-up\"></span> up</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-refresh\"></span> refresh</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-plus\"></span> plus</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-minus\"></span> minus</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-search\"></span> search</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-save\"></span> save</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-help\"></span> help</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-print\"></span> print</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-expand\"></span> expand</li>\n<li><span class=\"x-tool\"><img src=\"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==\" class=\"x-tool-collapse\"></span> collapse</li>\n</ul>\n\n"},"_toolTypes":{"!doc":"<p><debug></debug></p>\n"},"ariaRole":{"!type":"string"},"cacheHeight":{"!type":"bool"},"cacheWidth":{"!type":"bool"},"isTool":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Tool, or subclass thereof.</p>\n"},"privates":{"!doc":"<hr />\n\n<p> End Positionable methods</p>\n\n<hr />\n\n<p> </editor-fold></p>\n\n<p><strong>Overridden in Ext.rtl.Component.</strong></p>\n"},"tipAttrs":{},"afterRender":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p></p>\n"},"onClick":{"!type":"fn(e: ?, target: ?) -> !this","!doc":"<p>Called when the tool element is clicked</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"onMouseDown":{"!type":"fn() -> !this","!doc":"<p>Called when the user presses their mouse button down on a tool\nAdds the press class (<a href=\"#!/api/Ext.panel.Tool-cfg-toolPressedCls\" rel=\"Ext.panel.Tool-cfg-toolPressedCls\" class=\"docClass\">toolPressedCls</a>)</p>\n"},"onMouseOut":{"!type":"fn() -> !this","!doc":"<p>Called when the user rolls out from a tool.\nRemoves the over class (<a href=\"#!/api/Ext.panel.Tool-cfg-toolOverCls\" rel=\"Ext.panel.Tool-cfg-toolOverCls\" class=\"docClass\">toolOverCls</a>)</p>\n"},"onMouseOver":{"!type":"fn() -> !this","!doc":"<p>Called when the user rolls over a tool\nAdds the over class (<a href=\"#!/api/Ext.panel.Tool-cfg-toolOverCls\" rel=\"Ext.panel.Tool-cfg-toolOverCls\" class=\"docClass\">toolOverCls</a>)</p>\n"},"setTooltip":{"!type":"fn(tooltip: ?, type: ?) -> !this"},"setType":{"!type":"fn(type: ?) -> ?","!doc":"<p>Sets the type of the tool. Allows the icon to be changed.</p>\n"},"click":{"!type":"fn(this: ?, e: ?, owner: ?, eOpts: ?)","!doc":"<p>Fires when the tool is clicked</p>\n"}}}},"dashboard":{"Column":{"!doc":"<p>This class manages columns in a <code>Dashboard</code>. The primary role here is the <code>defaultType</code>\nconfig which points to <code><a href=\"#!/api/Ext.dashboard.Panel\" rel=\"Ext.dashboard.Panel\" class=\"docClass\">Ext.dashboard.Panel</a></code> and the self-destruct mechanism to get\nrid of empty columns.</p>\n","!type":"fn(config: ?)","prototype":{"cls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.dashboard.Column-cfg-items\" rel=\"Ext.dashboard.Column-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"isDashboardColumn":{"!type":"bool"},"synthetic":{"!type":"bool","!doc":"<p>This property is <code>true</code> if the component was created internally by the framework\nand is not explicitly user-defined. This is set for such things as <code>Splitter</code>\ninstances managed by <code>border</code> and <code>box</code> layouts.</p>\n"},"onRemove":{"!type":"fn(comp: ?, isDestroying: ?) -> !this","!doc":"<p>not user-defined</p>\n"}}},"Dashboard":{"!doc":"<p>This class manages a drag-drop Dashboard similar to the legacy Ext JS Portal example.\nThe user-directed layout of the Dashboard is preserved the Ext JS <code>stateful</code> mechanism\nto preserve potentially dynamic user sizing and collapsed states as well as order of\nitems in their columns.</p>\n","!type":"fn(config: ?)","prototype":{"autoScroll":{"!type":"bool","!doc":"<p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\n<code>false</code> to clip any overflowing content.\nThis should not be combined with <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-overflowX\" rel=\"Ext.dashboard.Dashboard-cfg-overflowX\" class=\"docClass\">overflowX</a> or  <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-overflowY\" rel=\"Ext.dashboard.Dashboard-cfg-overflowY\" class=\"docClass\">overflowY</a>.</p>\n"},"bodyCls":{"!doc":"<p>A CSS class, space-delimited string of classes, or array of classes to be applied to the panel's body element.\nThe following examples are all valid:</p>\n\n<pre><code>bodyCls: 'foo'\nbodyCls: 'foo bar'\nbodyCls: ['foo', 'bar']\n</code></pre>\n"},"cls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-items\" rel=\"Ext.dashboard.Dashboard-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"maxColumns":{"!doc":"<p>The maximum number of visible columns.</p>\n"},"parts":{"!doc":"<p>An object keyed by <code>id</code> for the parts that can be created for this <code>Dashboard</code>.</p>\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-stateId\" rel=\"Ext.dashboard.Dashboard-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-stateEvents\" rel=\"Ext.dashboard.Dashboard-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.dashboard.Dashboard-method-getState\" rel=\"Ext.dashboard.Dashboard-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.dashboard.Dashboard-method-getState\" rel=\"Ext.dashboard.Dashboard-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state and store state (sorters and filters and grouper) in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-stateId\" rel=\"Ext.dashboard.Dashboard-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-stateId\" rel=\"Ext.dashboard.Dashboard-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.dashboard.Dashboard-method-applyState\" rel=\"Ext.dashboard.Dashboard-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.dashboard.Dashboard-method-applyState\" rel=\"Ext.dashboard.Dashboard-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.dashboard.Dashboard-event-beforestaterestore\" rel=\"Ext.dashboard.Dashboard-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.dashboard.Dashboard-event-staterestore\" rel=\"Ext.dashboard.Dashboard-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.dashboard.Dashboard-event-beforestatesave\" rel=\"Ext.dashboard.Dashboard-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.dashboard.Dashboard-event-statesave\" rel=\"Ext.dashboard.Dashboard-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"firstColumnCls":{"!type":"string"},"idSeed":{"!type":"number"},"isDashboard":{"!type":"bool"},"lastColumnCls":{"!type":"string"},"addNew":{"!type":"fn(type: ?) -> !this"},"addView":{"!type":"fn(instance: ?, columnIndex: ?, beforeAfter: ?) -> !this"},"applyParts":{"!type":"fn(parts: ?, collection: ?) -> !this"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<hr />\n\n<p> State and Item Persistence</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"createColumn":{"!type":"fn(config: ?) -> !this"},"createView":{"!type":"fn(config: ?) -> !this"},"deserializeItems":{"!type":"fn(serialized: ?) -> !this"},"getPart":{"!type":"fn(type: ?) -> !this"},"getParts":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-parts\" rel=\"Ext.dashboard.Dashboard-cfg-parts\" class=\"docClass\">parts</a>.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>The supplied default state gathering method for the Component class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-stateId\" rel=\"Ext.dashboard.Dashboard-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n"},"initEvents":{"!type":"fn() -> !this","!doc":"<p>Initialize any events on this component</p>\n"},"initItems":{"!type":"fn() -> !this","!doc":"<p>This method is called to initialize the <code>items</code> collection. A derived class can\noverride this method to do any last minute manipulation of <code>items</code> and then call\nthis method using <code>callParent</code>. Upon return, the <code>items</code> will no longer be a simple\narray.</p>\n"},"onRemoveItem":{"!type":"fn(column: ?, item: ?) -> !this"},"serializeItem":{"!type":"fn(item: ?) -> !this"},"serializeItems":{"!type":"fn() -> !this"},"setParts":{"!type":"fn(parts: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.dashboard.Dashboard-cfg-parts\" rel=\"Ext.dashboard.Dashboard-cfg-parts\" class=\"docClass\">parts</a>.</p>\n"},"beforedragover":{"!type":"fn(eOpts: ?)"},"beforedrop":{"!type":"fn(eOpts: ?)"},"dragover":{"!type":"fn(eOpts: ?)"},"drop":{"!type":"fn(eOpts: ?)"},"validatedrop":{"!type":"fn(eOpts: ?)"}}},"DropZone":{"!doc":"<p>Internal class that manages drag/drop for the <code>Dashboard</code>.</p>\n","!type":"fn(dashboard: ?, cfg: ?)","prototype":{"overClass":{"!type":"string","!doc":"<p>This causes overflow to go hidden during the drag so that we don't cause panels to\nwrap by triggering overflow.</p>\n"},"ddScrollConfig":{},"getOverEvent":{"!type":"fn(dd: ?, e: ?, data: ?) -> !this"},"notifyDrop":{"!type":"fn(dd: ?, e: ?, data: ?) -> bool","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop target that the dragged item has\nbeen dropped on it. This method removes any <code>overClass</code> and returns false, so you must provide an\nimplementation that does something to process the drop event and returns true so that the drag source's\nrepair action does not run.</p>\n\n<p>You should <code>callParent</code> from an override of this method to ensure proper cleanup is\nperformed.</p>\n"},"notifyOver":{"!type":"fn(dd: ?, e: ?, data: ?) -> string","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls continuously while it is being dragged over the target.\nThis method will be called on every mouse movement while the drag source is over the drop target.\nThis default implementation simply returns the dropAllowed config value.</p>\n"},"unreg":{"!type":"fn() -> !this","!doc":"<p>unregister the dropzone from ScrollManager</p>\n"}}},"Panel":{"!doc":"<p>This class is used to wrap content items in the <code>Dashboard</code>. It uses an\n<code>anchor</code> layout by default and provides resizing on the bottom edge only.</p>\n","!type":"fn(config: ?)","prototype":{"animCollapse":{"!type":"bool","!doc":"<p><code>true</code> to animate the transition when the panel is collapsed, <code>false</code> to skip the animation (defaults to <code>true</code>\nif the <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> class is available, otherwise <code>false</code>). May also be specified as the animation\nduration in milliseconds.</p>\n"},"closable":{"!type":"bool","!doc":"<p>True to display the 'close' tool button and allow the user to close the window, false to hide the button and\ndisallow closing the window.</p>\n\n<p>By default, when close is requested by clicking the close button in the header, the <a href=\"#!/api/Ext.dashboard.Panel-method-close\" rel=\"Ext.dashboard.Panel-method-close\" class=\"docClass\">close</a> method will be\ncalled. This will <em><a href=\"#!/api/Ext.Component-method-destroy\" rel=\"Ext.Component-method-destroy\" class=\"docClass\">destroy</a></em> the Panel and its content meaning that it may not be\nreused.</p>\n\n<p>To make closing a Panel <em>hide</em> the Panel so that it may be reused, set <a href=\"#!/api/Ext.dashboard.Panel-cfg-closeAction\" rel=\"Ext.dashboard.Panel-cfg-closeAction\" class=\"docClass\">closeAction</a> to 'hide'.</p>\n"},"cls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n"},"collapsible":{"!type":"bool","!doc":"<p>True to make the panel collapsible and have an expand/collapse toggle Tool added into the header tool button\narea. False to keep the panel sized either statically, or by an owning layout manager, with no toggle Tool.\nWhen a panel is used in a <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, the <a href=\"#!/api/Ext.dashboard.Panel-cfg-floatable\" rel=\"Ext.dashboard.Panel-cfg-floatable\" class=\"docClass\">floatable</a> option\ncan influence the behavior of collapsing.\nSee <a href=\"#!/api/Ext.dashboard.Panel-cfg-collapseMode\" rel=\"Ext.dashboard.Panel-cfg-collapseMode\" class=\"docClass\">collapseMode</a> and <a href=\"#!/api/Ext.dashboard.Panel-cfg-collapseDirection\" rel=\"Ext.dashboard.Panel-cfg-collapseDirection\" class=\"docClass\">collapseDirection</a></p>\n"},"draggable":{"!doc":"<p>Specify as true to make a <a href=\"#!/api/Ext.dashboard.Panel-cfg-floating\" rel=\"Ext.dashboard.Panel-cfg-floating\" class=\"docClass\">floating</a> Component draggable using the Component's encapsulating element as\nthe drag handle.</p>\n\n<p>This may also be specified as a config object for the <a href=\"#!/api/Ext.util.ComponentDragger\" rel=\"Ext.util.ComponentDragger\" class=\"docClass\">ComponentDragger</a> which is\ninstantiated to perform dragging.</p>\n\n<p>For example to create a Component which may only be dragged around using a certain internal element as the drag\nhandle, use the delegate option:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>({\n    constrain: true,\n    floating: true,\n    style: {\n        backgroundColor: '#fff',\n        border: '1px solid black'\n    },\n    html: '&lt;h1 style=\"cursor:move\"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',\n    draggable: {\n        delegate: 'h1'\n    }\n}).show();\n</code></pre>\n"},"frame":{"!type":"bool","!doc":"<p>True to apply a frame to the panel.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.dashboard.Panel-cfg-items\" rel=\"Ext.dashboard.Panel-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"minHeight":{"!type":"number","!doc":"<p>The minimum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"resizable":{"!doc":"<p>Specify as <code>true</code> to apply a <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a> to this Component after rendering.</p>\n\n<p>May also be specified as a config object to be passed to the constructor of <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a>\nto override any defaults. By default the Component passes its minimum and maximum size, and uses\n<code><a href=\"#!/api/Ext.resizer.Resizer-cfg-dynamic\" rel=\"Ext.resizer.Resizer-cfg-dynamic\" class=\"docClass\">Ext.resizer.Resizer.dynamic</a>: false</code></p>\n"},"resizeHandles":{"!type":"string","!doc":"<p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.dashboard.Panel-cfg-stateId\" rel=\"Ext.dashboard.Panel-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.dashboard.Panel-cfg-stateEvents\" rel=\"Ext.dashboard.Panel-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.dashboard.Panel-method-getState\" rel=\"Ext.dashboard.Panel-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.dashboard.Panel-method-getState\" rel=\"Ext.dashboard.Panel-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state and store state (sorters and filters and grouper) in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.dashboard.Panel-cfg-stateId\" rel=\"Ext.dashboard.Panel-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.dashboard.Panel-cfg-stateId\" rel=\"Ext.dashboard.Panel-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.dashboard.Panel-method-applyState\" rel=\"Ext.dashboard.Panel-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.dashboard.Panel-method-applyState\" rel=\"Ext.dashboard.Panel-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.dashboard.Panel-event-beforestaterestore\" rel=\"Ext.dashboard.Panel-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.dashboard.Panel-event-staterestore\" rel=\"Ext.dashboard.Panel-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.dashboard.Panel-event-beforestatesave\" rel=\"Ext.dashboard.Panel-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.dashboard.Panel-event-statesave\" rel=\"Ext.dashboard.Panel-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"titleCollapse":{"!type":"bool","!doc":"<p><code>true</code> to allow expanding and collapsing the panel (when <code><a href=\"#!/api/Ext.dashboard.Panel-cfg-collapsible\" rel=\"Ext.dashboard.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> = true</code>) by clicking anywhere in\nthe header bar, <code>false</code>) to allow it only by clicking to tool button). When a panel is used in a\n<a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>, the <a href=\"#!/api/Ext.dashboard.Panel-cfg-floatable\" rel=\"Ext.dashboard.Panel-cfg-floatable\" class=\"docClass\">floatable</a> option can influence the behavior of collapsing.</p>\n"},"anchor":{"!type":"string"},"animateClose":{"!type":"bool"},"loadMask":{"!type":"bool"},"afterRender":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior after rendering is complete. At this stage the Component's Element\nwill have been styled according to the configuration, will have had any configured CSS class\nnames added, and will be in the configured visibility and the configured enable state.</p>\n"},"doClose":{"!type":"fn() -> !this","!doc":"<p>Override Panel's default doClose to provide a custom fade out effect\nwhen a portlet is removed from the portal</p>\n"},"finishClose":{"!type":"fn() -> !this"},"getLoadMask":{"!type":"fn() -> !this"},"getState":{"!type":"fn() -> !this"},"onAdd":{"!type":"fn(view: ?) -> !this","!doc":"<p>This method is invoked after a new Component has been added. It\nis passed the Component which has been added. This method may\nbe used to update any internal structure which may depend upon\nthe state of the child items.</p>\n"},"onViewBeforeLoad":{"!type":"fn() -> !this"},"onViewLoaded":{"!type":"fn() -> !this"},"setBox":{"!type":"fn(box: ?) -> !this"}}},"Part":{"!doc":"<p>This class encapsulates the creation of items for a <code>Dashboard</code>. Generally a <code>Part</code> is a\ncomponent factory that allows all parts of a common type to be easily coordinated as\nneeded for that type. For example, an RSS feed might need certain configuration data to\nproperly initialize. Perahps not all of this data can or should be supplied from the UI\nthat creates new instances for the <code>Dashboard</code>.</p>\n\n<h2>Part Configuration</h2>\n\n<p>The primary role of a <code>Part</code> is to provide an abstract way to define the configuration\nneeded to create views. For example, an RSS Part would at least need the URL for the\nfeed.</p>\n\n<p>To implement this a derived class provides a <code>displayForm</code> method:</p>\n\n<pre><code> Ext.define('App.parts.RSS', {\n     extend: '<a href=\"#!/api/Ext.dashboard.Part\" rel=\"Ext.dashboard.Part\" class=\"docClass\">Ext.dashboard.Part</a>',\n     alias: 'part.rss',\n\n     displayForm: function (instance, currentConfig, callback, scope) {\n         var me = this,\n             title = instance ? 'Edit RSS Feed' : 'Add RSS Feed';\n\n         // Display a prompt using current URL as default text.\n         //\n         <a href=\"#!/api/Ext.MessageBox-method-prompt\" rel=\"Ext.MessageBox-method-prompt\" class=\"docClass\">Ext.Msg.prompt</a>(title, 'RSS Feed URL', function (btn, text) {\n             if (btn === 'ok') {\n                 var config = {\n                     feedUrl: text\n                 };\n\n                 callback.call(scope || me, config);\n             }\n         }, me, false, currentConfig ? currentConfig.feedUrl : '');\n     }\n });\n</code></pre>\n\n<p>The returned configuration object is used to create views. It is also passed back to\n<code>displayForm</code> to allow the user to edit the configuration for an existing view.</p>\n\n<h2>Creating Views</h2>\n\n<p>The next step is to define the view (the components) appropriate for the part. To\ncontinue with the above example.</p>\n\n<pre><code> Ext.define('App.parts.RSS', {\n     extend: '<a href=\"#!/api/Ext.dashboard.Part\" rel=\"Ext.dashboard.Part\" class=\"docClass\">Ext.dashboard.Part</a>',\n     alias: 'part.rss',\n\n     // The viewTemplate is \"component template\" that is evaluated against the\n     // configuration (as returned by displayForm). The top-most component is\n     // a panel specific to the Dashboard so it can be configured but should\n     // not be replaced. Instead, fit an appropriate component to the panel.\n     //\n     viewTemplate: {\n         layout: 'fit',\n         items: [{\n             xtype: 'feedpanel',\n             feedUrl: '{feedUrl}'  // from the configuration object\n         }]\n     },\n\n     displayForm: ...\n });\n</code></pre>\n\n<p>You can instead choose to override the <code>createView</code> method if <code>viewTemplate</code> does not\nprovide enough flexibility. It is usually a better solution to create a class (like\nin the above example) and pass basic configurations to it rather than over-complicate\neither the <code>viewTemplate</code> or a custom <code>createView</code> method.</p>\n","!type":"fn(config: ?)","prototype":{"id":{},"viewTemplate":{"!doc":"<p>The configuration object used for creating instances of this <code>Part</code>. This is\nused by the <code>createView</code> method to create views.</p>\n"},"_lastId":{"!type":"number","!doc":"<p>The last assigned identifier for instances created by this <code>Part</code>.</p>\n"},"dashboard":{"!doc":"<p>The <code>Dashboard</code> instance that owns this <code>part</code>.</p>\n"},"factoryConfig":{},"isPart":{"!type":"bool"},"valueRe":{},"viewTemplateOptions":{},"applyViewTemplate":{"!type":"fn(template: ?) -> !this"},"createView":{"!type":"fn(config: ?) -> ?","!doc":"<p>This method is responsible for converting a configuration object from <code>displayForm</code>\ninto a \"view\" (an object that can be passed to <code>Ext.widget</code>).</p>\n\n<p>If you override this method it is recommended that you <code>callParent</code> to get the view\nproduced and then edit that result. This is because there are several private\nproperties placed on the returned configuration object.</p>\n\n<pre><code> createView: function (config) {\n     var view = this.callParent([config]);\n\n     // edit view\n\n     return view;\n }\n</code></pre>\n"},"displayForm":{"!type":"fn(instance: ?, currentConfig: ?, callback: ?, scope: ?) -> !this","!doc":"<p>This method should display an appropriate edit form (probably a modal <code><a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.Window</a></code>\nor <code><a href=\"#!/api/Ext.MessageBox-method-prompt\" rel=\"Ext.MessageBox-method-prompt\" class=\"docClass\">Ext.Msg.prompt</a></code>) to get or edit configuration for an instance of this part.</p>\n\n<p>See the class documentation for examples on implementing this method.</p>\n"},"getId":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.dashboard.Part-cfg-id\" rel=\"Ext.dashboard.Part-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getViewTemplate":{"!type":"fn() -> ?","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.dashboard.Part-cfg-viewTemplate\" rel=\"Ext.dashboard.Part-cfg-viewTemplate\" class=\"docClass\">viewTemplate</a>.</p>\n"},"setId":{"!type":"fn(id: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.dashboard.Part-cfg-id\" rel=\"Ext.dashboard.Part-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"setViewTemplate":{"!type":"fn(viewTemplate: ?)","!doc":"<p>Sets the value of <a href=\"#!/api/Ext.dashboard.Part-cfg-viewTemplate\" rel=\"Ext.dashboard.Part-cfg-viewTemplate\" class=\"docClass\">viewTemplate</a>.</p>\n"}}}},"dd":{"DropTarget":{"prototype":{"ddGroup":{"!type":"string","!doc":"<p>A named drag drop group to which this object belongs.  If a group is specified, then this object will only\ninteract with other drag drop objects in the same group.</p>\n"},"dropAllowed":{"!type":"string","!doc":"<p>The CSS class returned to the drag source when drop is allowed.</p>\n"},"dropNotAllowed":{"!type":"string","!doc":"<p>The CSS class returned to the drag source when drop is not allowed.</p>\n"},"isNotifyTarget":{"!type":"bool","!doc":"<p>private</p>\n"},"isTarget":{"!type":"bool","!doc":"<p>private</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy this DragDrop instance</p>\n"},"notifyEnter":{"!type":"fn(source: ?, e: ?, data: ?) -> string","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop target that the source is now over the\ntarget.  This default implementation adds the CSS class specified by overClass (if any) to the drop element\nand returns the dropAllowed config value.  This method should be overridden if drop validation is required.</p>\n"},"notifyOut":{"!type":"fn(source: ?, e: ?, data: ?) -> !this","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop target that the source has been dragged\nout of the target without dropping. This default implementation simply removes the CSS class specified by\n<code>overClass</code> (if any) from the drop element.</p>\n"},"overClass":{"!type":"string","!doc":"<p>The CSS class applied to the drop target element while the drag source is over it.</p>\n"},"notifyDrop":{"!type":"fn(source: ?, e: ?, data: ?) -> bool","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop target that the dragged item has\nbeen dropped on it. This method removes any <code>overClass</code> and returns false, so you must provide an\nimplementation that does something to process the drop event and returns true so that the drag source's\nrepair action does not run.</p>\n\n<p>You should <code>callParent</code> from an override of this method to ensure proper cleanup is\nperformed.</p>\n"},"notifyOver":{"!type":"fn(source: ?, e: ?, data: ?) -> string","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls continuously while it is being dragged over the target.\nThis method will be called on every mouse movement while the drag source is over the drop target.\nThis default implementation simply returns the dropAllowed config value.</p>\n"}},"!doc":"<p>A simple class that provides the basic implementation needed to make any element a drop target that can have\ndraggable items dropped onto it.  The drop has no effect until an implementation of notifyDrop is provided.</p>\n","!type":"fn(el: ?, config: ?)"},"DragDrop":{"prototype":{"__ygDragDrop":{"!type":"bool","!doc":"<p>Internal typeof flag</p>\n"},"_domRef":{"!doc":"<p>Cached reference to the linked element</p>\n"},"available":{"!type":"bool","!doc":"<p>The available property is false until the linked dom element is accessible.</p>\n"},"config":{"!doc":"<p>Configuration attributes passed into the constructor</p>\n"},"constrainX":{"!type":"bool","!doc":"<p>Set to true when horizontal contraints are applied</p>\n"},"constrainY":{"!type":"bool","!doc":"<p>Set to true when vertical contraints are applied</p>\n"},"defaultPadding":{"!doc":"<p>Provides default constraint padding to \"constrainTo\" elements.</p>\n"},"dragElId":{"!type":"string","!doc":"<p>The id of the element that will be dragged.  By default this is same\nas the linked element, but could be changed to another element. Ex:\n<a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n"},"groups":{"!doc":"<p>The group defines a logical collection of DragDrop objects that are\nrelated.  Instances only get events when interacting with other\nDragDrop object in the same group.  This lets us define multiple\ngroups using a single DragDrop subclass if we want.</p>\n\n<p>An object in the format {'group1':true, 'group2':true}</p>\n"},"handleElId":{"!type":"string","!doc":"<p>The ID of the element that initiates the drag operation.  By default\nthis is the linked element, but could be changed to be a child of this\nelement.  This lets us do things like only starting the drag when the\nheader element within the linked html element is clicked.</p>\n"},"hasOuterHandles":{"!type":"bool","!doc":"<p>By default, drags can only be initiated if the mousedown occurs in the\nregion the linked element is.  This is done in part to work around a\nbug in some browsers that mis-report the mousedown if the previous\nmouseup happened outside of the window.  This property is set to true\nif outer handles are defined. Defaults to false.</p>\n"},"id":{"!type":"string","!doc":"<p>The id of the element associated with this object.  This is what we\nrefer to as the \"linked element\" because the size and position of\nthis element is used to determine when the drag and drop objects have\ninteracted.</p>\n"},"ignoreSelf":{"!type":"bool","!doc":"<p>Set to false to enable a DragDrop object to fire drag events while dragging\nover its own Element. Defaults to true - DragDrop objects do not by default\nfire drag events to themselves.</p>\n"},"invalidHandleClasses":{"!doc":"<p>An Array of CSS class names for elements to be considered in valid as drag handles.</p>\n"},"invalidHandleIds":{"!doc":"<p>An object who's property names identify the IDs of elements to be considered invalid as drag handles.\nA non-null property value identifies the ID as invalid. For example, to prevent\ndragging from being initiated on element ID \"foo\", use:</p>\n\n<pre><code>{\n    foo: true\n}\n</code></pre>\n"},"invalidHandleTypes":{"!doc":"<p>An object who's property names identify HTML tags to be considered invalid as drag handles.\nA non-null property value identifies the tag as invalid. Defaults to the\nfollowing value which prevents drag operations from being initiated by <code>&lt;a&gt;</code> elements:</p>\n\n<pre><code>{\n    A: \"A\"\n}\n</code></pre>\n"},"locked":{"!type":"bool","!doc":"<p>Individual drag/drop instances can be locked.  This will prevent\nonmousedown start drag.</p>\n"},"maintainOffset":{"!type":"bool","!doc":"<p>Maintain offsets when we resetconstraints.  Set to true when you want\nthe position of the element relative to its parent to stay the same\nwhen the page changes</p>\n"},"maxX":{"!type":"number","!doc":"<p>The right constraint</p>\n"},"maxY":{"!type":"number","!doc":"<p>The down constraint</p>\n"},"minX":{"!type":"number","!doc":"<p>The left constraint</p>\n"},"minY":{"!type":"number","!doc":"<p>The up constraint</p>\n"},"moveOnly":{"!type":"bool","!doc":"<p>When set to true, other DD objects in cooperating DDGroups do not receive\nnotification events when this DD object is dragged over them.</p>\n"},"padding":{"!doc":"<p>The padding configured for this drag and drop object for calculating\nthe drop zone intersection with this object.\nAn array containing the 4 padding values: [top, right, bottom, left]</p>\n"},"primaryButtonOnly":{"!type":"bool","!doc":"<p>By default the drag and drop instance will only respond to the primary\nbutton click (left button for a right-handed mouse).  Set to true to\nallow drag and drop to start with any mouse click that is propogated\nby the browser</p>\n"},"startPageX":{"!type":"number","!doc":"<p>The linked element's absolute X position at the time the drag was\nstarted</p>\n"},"startPageY":{"!type":"number","!doc":"<p>The linked element's absolute X position at the time the drag was\nstarted</p>\n"},"triggerEvent":{"!type":"string"},"xTicks":{"!doc":"<p>Array of pixel locations the element will snap to if we specified a\nhorizontal graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n"},"yTicks":{"!doc":"<p>Array of pixel locations the element will snap to if we specified a\nvertical graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n"},"addToGroup":{"!type":"fn(sGroup: ?) -> !this","!doc":"<p>Adds this instance to a group of related drag/drop objects.  All\ninstances belong to at least one group, and can belong to as many\ngroups as needed.</p>\n"},"applyConfig":{"!type":"fn() -> !this","!doc":"<p>Applies the configuration parameters that were passed into the constructor.\nThis is supposed to happen at each level through the inheritance chain.  So\na DDProxy implentation will execute apply config on DDProxy, DD, and\nDragDrop in order to get all of the parameters that are available in\neach object.</p>\n"},"b4Drag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code that executes immediately before the onDrag event</p>\n"},"b4DragDrop":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code that executes immediately before the onDragDrop event</p>\n"},"b4DragOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code that executes immediately before the onDragOut event</p>\n"},"b4DragOver":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code that executes immediately before the onDragOver event</p>\n"},"b4EndDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code that executes immediately before the endDrag event</p>\n"},"b4MouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Code executed immediately before the onMouseDown event</p>\n"},"b4StartDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Code that executes immediately before the startDrag event</p>\n"},"clickValidator":{"!type":"fn(e: ?) -> !this"},"constrainTo":{"!type":"fn(constrainTo: ?, pad?: ?, inContent?: ?) -> !this","!doc":"<p>Initializes the drag drop object's constraints to restrict movement to a certain element.</p>\n\n<p>Usage:</p>\n\n<pre><code>var dd = new <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a>(\"dragDiv1\", \"proxytest\",\n               { dragElId: \"existingProxyDiv\" });\ndd.startDrag = function(){\n    this.constrainTo(\"parent-id\");\n};\n</code></pre>\n\n<p>Or you can initalize it using the Ext.dom.Element object:</p>\n\n<pre><code>Ext.get(\"dragDiv1\").initDDProxy(\"proxytest\", {dragElId: \"existingProxyDiv\"}, {\n    startDrag : function(){\n        this.constrainTo(\"parent-id\");\n    }\n});\n</code></pre>\n"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Returns a reference to the linked element</p>\n"},"getTick":{"!type":"fn(val: ?, tickArray: ?) -> number","!doc":"<p>Normally the drag element is moved pixel by pixel, but we can specify\nthat it move a number of pixels at a time.  This method resolves the\nlocation when we have it set up like this.</p>\n"},"handleMouseDown":{"!type":"fn(e: ?, oDD: ?) -> !this","!doc":"<p>Called when this object is clicked</p>\n"},"handleOnAvailable":{"!type":"fn() -> !this","!doc":"<p>Executed when the linked element is available</p>\n"},"init":{"!type":"fn(id: ?, sGroup: ?, config: ?) -> !this","!doc":"<p>Sets up the DragDrop object.  Must be called in the constructor of any\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> subclass</p>\n"},"initTarget":{"!type":"fn(id: ?, sGroup: ?, config: ?) -> !this","!doc":"<p>Initializes Targeting functionality only... the object does not\nget a mousedown handler.</p>\n"},"isLocked":{"!type":"fn() -> bool","!doc":"<p>Returns true if this instance is locked, or the drag drop mgr is locked\n(meaning that all drag/drop is disabled on the page.)</p>\n"},"lock":{"!type":"fn() -> !this","!doc":"<p>Locks this instance</p>\n"},"onAvailable":{"!type":"fn() -> !this","!doc":"<p>Override the onAvailable method to do what is needed after the initial\nposition was determined.</p>\n"},"removeFromGroup":{"!type":"fn(sGroup: ?) -> !this","!doc":"<p>Removes this instance from the supplied interaction group</p>\n"},"setPadding":{"!type":"fn(iTop: ?, iRight: ?, iBot: ?, iLeft: ?) -> !this","!doc":"<p>Configures the padding for the target zone in px.  Effectively expands\n(or reduces) the virtual object size for targeting calculations.\nSupports css-style shorthand; if only one parameter is passed, all sides\nwill have that padding, and if only two are passed, the top and bottom\nwill have the first param, the left and right the second.</p>\n"},"setStartPosition":{"!type":"fn(pos: ?) -> !this","!doc":"<p>Sets the start position of the element.  This is set when the obj\nis initialized, the reset when a drag is started.</p>\n"},"setXTicks":{"!type":"fn(iStartX: ?, iTickSize: ?) -> !this","!doc":"<p>Creates the array of horizontal tick marks if an interval was specified\nin setXConstraint().</p>\n"},"setYTicks":{"!type":"fn(iStartY: ?, iTickSize: ?) -> !this","!doc":"<p>Creates the array of vertical tick marks if an interval was specified in\nsetYConstraint().</p>\n"},"unlock":{"!type":"fn() -> !this","!doc":"<p>Unlocks this instace</p>\n"},"isTarget":{"!type":"bool","!doc":"<p>By default, all instances can be a drop target.  This can be disabled by\nsetting isTarget to false.</p>\n"},"addInvalidHandleClass":{"!type":"fn(cssClass: ?) -> !this","!doc":"<p>Lets you specify a css class of elements that will not initiate a drag</p>\n"},"addInvalidHandleId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Lets you to specify an element id for a child of a drag handle\nthat should not initiate a drag</p>\n"},"addInvalidHandleType":{"!type":"fn(tagName: ?) -> !this","!doc":"<p>Allows you to specify a tag name that should not start a drag operation\nwhen clicked.  This is designed to facilitate embedding links within a\ndrag handle that do something other than start the drag.</p>\n"},"clearConstraints":{"!type":"fn() -> !this","!doc":"<p>Clears any constraints applied to this instance.  Also clears ticks\nsince they can't exist independent of a constraint at this time.</p>\n"},"clearTicks":{"!type":"fn() -> !this","!doc":"<p>Clears any tick interval defined for this instance</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy this DragDrop instance</p>\n"},"endDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Called when we are done dragging the object</p>\n"},"getDragEl":{"!type":"fn() -> ?","!doc":"<p>Returns a reference to the actual element to drag.  By default this is\nthe same as the html element, but it can be assigned to another\nelement. An example of this can be found in <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n"},"isValidHandleChild":{"!type":"fn(node: ?) -> bool","!doc":"<p>Checks the tag exclusion list to see if this click should be ignored</p>\n"},"onDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Abstract method called during the onMouseMove event while dragging an\nobject.</p>\n"},"onDragDrop":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this item is dropped on another DragDrop\nobj</p>\n"},"onDragEnter":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this element fist begins hovering over\nanother DragDrop obj</p>\n"},"onDragOut":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when we are no longer hovering over an element</p>\n"},"onDragOver":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this element is hovering over another\nDragDrop obj</p>\n"},"onInvalidDrop":{"!type":"fn(e: ?) -> !this","!doc":"<p>Abstract method called when this item is dropped on an area with no\ndrop target</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Called when a drag/drop obj gets a mousedown</p>\n"},"onMouseUp":{"!type":"fn(e: ?) -> !this","!doc":"<p>Called when a drag/drop obj gets a mouseup</p>\n"},"removeInvalidHandleClass":{"!type":"fn(cssClass: ?) -> !this","!doc":"<p>Unsets an invalid css class</p>\n"},"removeInvalidHandleId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Unsets an invalid handle id</p>\n"},"removeInvalidHandleType":{"!type":"fn(tagName: ?) -> !this","!doc":"<p>Unsets an excluded tag name set by addInvalidHandleType</p>\n"},"resetConstraints":{"!type":"fn(maintainOffset: ?) -> !this","!doc":"<p>Must be called if you manually reposition a dd element.</p>\n"},"setDragElId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Allows you to specify that an element other than the linked element\nwill be moved with the cursor during a drag</p>\n"},"setHandleElId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Allows you to specify a child of the linked element that should be\nused to initiate the drag operation.  An example of this would be if\nyou have a content div with text and links.  Clicking anywhere in the\ncontent area would normally start the drag operation.  Use this method\nto specify that an element inside of the content div is the element\nthat starts the drag operation.</p>\n"},"setInitPosition":{"!type":"fn(diffX: ?, diffY: ?) -> !this","!doc":"<p>Stores the initial placement of the linked element.</p>\n"},"setOuterHandleElId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Allows you to set an element outside of the linked element as a drag\nhandle</p>\n"},"setXConstraint":{"!type":"fn(iLeft: ?, iRight: ?, iTickSize?: ?) -> !this","!doc":"<p>By default, the element can be dragged any place on the screen.  Use\nthis method to limit the horizontal travel of the element.  Pass in\n0,0 for the parameters if you want to lock the drag to the y axis.</p>\n"},"setYConstraint":{"!type":"fn(iUp: ?, iDown: ?, iTickSize?: ?) -> !this","!doc":"<p>By default, the element can be dragged any place on the screen.  Set\nthis to limit the vertical travel of the element.  Pass in 0,0 for the\nparameters if you want to lock the drag to the x axis.</p>\n"},"startDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met.</p>\n"},"unreg":{"!type":"fn() -> !this","!doc":"<p>Removes all drag and drop hooks for this element</p>\n"},"toString":{"!type":"fn() -> string","!doc":"<p>toString method</p>\n"}},"!doc":"<p>Defines the interface and base operation of items that that can be\ndragged or can be drop targets.  It was designed to be extended, overriding\nthe event handlers for startDrag, onDrag, onDragOver and onDragOut.\nUp to three html elements can be associated with a DragDrop instance:</p>\n\n<ul>\n<li><p>linked element: the element that is passed into the constructor.\nThis is the element which defines the boundaries for interaction with\nother DragDrop objects.</p></li>\n<li><p>handle element(s): The drag operation only occurs if the element that\nwas clicked matches a handle element.  By default this is the linked\nelement, but there are times that you will want only a portion of the\nlinked element to initiate the drag operation, and the setHandleElId()\nmethod provides a way to define this.</p></li>\n<li><p>drag element: this represents the element that would be moved along\nwith the cursor during a drag operation.  By default, this is the linked\nelement itself as in <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.  setDragElId() lets you define\na separate element that would be moved, as in <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a>.</p></li>\n</ul>\n\n\n<p>This class should not be instantiated until the onload event to ensure that\nthe associated elements are available.\nThe following would define a DragDrop obj that would interact with any\nother DragDrop obj in the \"group1\" group:</p>\n\n<pre><code>dd = new <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>(\"div1\", \"group1\");\n</code></pre>\n\n<p>Since none of the event handlers have been implemented, nothing would\nactually happen if you were to run the code above.  Normally you would\noverride this class or one of the default implementations, but you can\nalso override the methods you want on an instance of the class...</p>\n\n<pre><code>dd.onDragDrop = function(e, id) {\n    alert(\"dd was dropped on \" + id);\n}\n</code></pre>\n","!type":"fn(id: ?, sGroup: ?, config: ?)"},"DDTarget":{"prototype":{"addInvalidHandleClass":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"addInvalidHandleId":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"addInvalidHandleType":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"clearConstraints":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"clearTicks":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"endDrag":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"getDragEl":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"isValidHandleChild":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onDrag":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onDragDrop":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onDragEnter":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onDragOut":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onDragOver":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onInvalidDrop":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onMouseDown":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"onMouseUp":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"removeInvalidHandleClass":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"removeInvalidHandleId":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"removeInvalidHandleType":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"resetConstraints":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setDragElId":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setHandleElId":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setInitPosition":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setOuterHandleElId":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setXConstraint":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"setYConstraint":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"startDrag":{"!type":"fn() -> !this","!doc":"<p>Overridden and disabled. A DDTarget does not support being dragged.</p>\n"},"toString":{"!type":"fn() -> string","!doc":"<p>toString method</p>\n"}},"!doc":"<p>A DragDrop implementation that does not move, but can be a drop\ntarget.  You would get the same result by simply omitting implementation\nfor the event callbacks, but this way we reduce the processing cost of the\nevent listener and the callbacks.</p>\n","!type":"fn(id: ?, sGroup: ?, config: ?)"},"DD":{"!doc":"<p>A DragDrop implementation where the linked element follows the\nmouse cursor during a drag.</p>\n","!type":"fn(id: ?, sGroup: ?, config: ?)","prototype":{"scroll":{"!type":"bool","!doc":"<p>When set to true, the utility automatically tries to scroll the browser\nwindow when a drag and drop element is dragged near the viewport boundary.</p>\n"},"alignElWithMouse":{"!type":"fn(el: ?, iPageX: ?, iPageY: ?) -> !this","!doc":"<p>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n"},"applyConfig":{"!type":"fn() -> !this","!doc":"<p>Sets up config options specific to this class. Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>, but all versions of this method through the\ninheritance chain are called</p>\n"},"autoOffset":{"!type":"fn(iPageX: ?, iPageY: ?) -> !this","!doc":"<p>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was clicked.</p>\n"},"autoScroll":{"!type":"fn(x: ?, y: ?, h: ?, w: ?) -> !this","!doc":"<p>Auto-scroll the window if the dragged object has been moved beyond the\nvisible window boundary.</p>\n"},"b4Drag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Event that fires prior to the onDrag event.  Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>.</p>\n"},"b4MouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Event that fires prior to the onMouseDown event.  Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>.</p>\n"},"cachePosition":{"!type":"fn(iPageX?: ?, iPageY?: ?) -> !this","!doc":"<p>Saves the most recent position so that we can reset the constraints and\ntick marks on-demand.  We need to know this so that we can calculate the\nnumber of pixels the element is offset from its original position.</p>\n"},"getLocalX":{"!type":"fn(el: ?) -> !this"},"getTargetCoord":{"!type":"fn(iPageX: ?, iPageY: ?) -> ?","!doc":"<p>Finds the location the element should be placed if we want to move\nit to where the mouse location less the click offset would place us.</p>\n"},"setDelta":{"!type":"fn(iDeltaX: ?, iDeltaY: ?) -> !this","!doc":"<p>Sets the pointer offset.  You can call this directly to force the\noffset to be in a particular location (e.g., pass in 0,0 to set it\nto the center of the object)</p>\n"},"setDragElPos":{"!type":"fn(iPageX: ?, iPageY: ?) -> !this","!doc":"<p>Sets the drag element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n"},"setLocalXY":{"!type":"fn(el: ?, x: ?, y: ?) -> !this"},"toString":{"!type":"fn() -> string","!doc":"<p>toString method</p>\n"}}},"DDProxy":{"!doc":"<p>A DragDrop implementation that inserts an empty, bordered div into\nthe document that follows the cursor during drag operations.  At the time of\nthe click, the frame div is resized to the dimensions of the linked html\nelement, and moved to the exact location of the linked element.</p>\n\n<p>References to the \"frame\" element refer to the single proxy element that\nwas created to be dragged in place of all DDProxy elements on the\npage.</p>\n","!type":"fn(id: ?, sGroup: ?, config: ?)","prototype":{"centerFrame":{"!type":"bool","!doc":"<p>By default the frame is positioned exactly where the drag element is, so\nwe use the cursor offset provided by <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.  Another option that works only if\nyou do not have constraints on the obj is to have the drag frame centered\naround the cursor.  Set centerFrame to true for this effect.</p>\n"},"resizeFrame":{"!type":"bool","!doc":"<p>By default we resize the drag frame to be the same size as the element\nwe want to drag (this is to get the frame effect).  We can turn it off\nif we want a different behavior.</p>\n"},"dragElId":{"!type":"string","!doc":"<p>The default drag frame div id</p>\n"},"_resizeProxy":{"!type":"fn() -> !this","!doc":"<p>The proxy is automatically resized to the dimensions of the linked\nelement when a drag is initiated, unless resizeFrame is set to false</p>\n"},"afterDrag":{"!type":"fn() -> !this"},"applyConfig":{"!type":"fn() -> !this","!doc":"<p>Sets up config options specific to this class. Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>, but all versions of this method through the\ninheritance chain are called</p>\n"},"b4EndDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"b4MouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"b4StartDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"beforeMove":{"!type":"fn() -> !this"},"createFrame":{"!type":"fn() -> !this","!doc":"<p>Creates the proxy element if it does not yet exist</p>\n"},"endDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>\nBy default we try to move the element to the last location of the frame.\nThis is so that the default behavior mirrors that of <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.</p>\n"},"initFrame":{"!type":"fn() -> !this","!doc":"<p>Initialization for the drag frame element.  Must be called in the\nconstructor of all subclasses</p>\n"},"showFrame":{"!type":"fn(iPageX: ?, iPageY: ?) -> !this","!doc":"<p>Resizes the drag frame to the dimensions of the clicked object, positions\nit over the object, and finally displays it</p>\n"},"toString":{"!type":"fn() -> string","!doc":"<p>toString method</p>\n"}}},"DragDropElement":{"prototype":{"getPosX":{"!type":"fn(el: ?) -> number","!doc":"<p>Returns the X position of an html element</p>\n"},"getPosY":{"!type":"fn(el: ?) -> number","!doc":"<p>Returns the Y position of an html element</p>\n"},"getScroll":{"!type":"fn() -> !this","!doc":"<p>Returns the current scroll position</p>\n"},"getScrollLeft":{"!type":"fn() -> number","!doc":"<p>Gets the scrollLeft</p>\n"},"getScrollTop":{"!type":"fn() -> number","!doc":"<p>Gets the scrollTop</p>\n"},"getStyle":{"!type":"fn(el: ?, styleProp: ?) -> string","!doc":"<p>Returns the specified element style property</p>\n"},"handleWasClicked":{"!type":"fn(node: ?) -> !this","!doc":"<p>Recursively searches the immediate parent and all child nodes for\nthe handle element in order to determine wheter or not it was\nclicked.</p>\n"},"moveToEl":{"!type":"fn(moveEl: ?, targetEl: ?) -> !this","!doc":"<p>Sets the x/y position of an element to the location of the\ntarget element.</p>\n"},"numericSort":{"!type":"fn(a: ?, b: ?) -> number","!doc":"<p>Numeric array sort function</p>\n"},"swapNode":{"!type":"fn(n1: ?, n2: ?) -> !this","!doc":"<p>Swap two nodes.  In IE, we use the native method, for others we\nemulate the IE behavior</p>\n"}}},"DragDropManager":{"ElementWrapper":{"!doc":"<p>Deprecated inner class for cached elements.</p>\n","prototype":{"css":{"!doc":"<p>A reference to the style property</p>\n"},"el":{"!doc":"<p>The element</p>\n"},"id":{"!doc":"<p>The element id</p>\n"}}},"!doc":"<p>DragDropManager is a singleton that tracks the element interaction for\nall DragDrop items in the window.  Generally, you will not call\nthis class directly, but it does have helper methods that could\nbe useful in your DragDrop implementations.</p>\n","INTERSECT":{"!type":"number","!doc":"<p>In intersect mode, drag and drop interaction is defined by the\noverlap of two or more drag and drop objects.</p>\n"},"POINT":{"!type":"number","!doc":"<p>In point mode, drag and drop interaction is defined by the\nlocation of the cursor during the drag/drop</p>\n"},"clickPixelThresh":{"!type":"number","!doc":"<p>The number of pixels that the mouse needs to move after the\nmousedown before the drag is initiated.  Default=8;\ndefaults to the same value used in the LongPress gesture so that drag cannot be\ninitiated if there is a possible pending longpress</p>\n"},"clickTimeout":{"!doc":"<p>Timeout used for the click time threshold</p>\n"},"deltaX":{"!type":"number","!doc":"<p>the X distance between the cursor and the object being dragged</p>\n"},"deltaY":{"!type":"number","!doc":"<p>the Y distance between the cursor and the object being dragged</p>\n"},"dragCls":{"!type":"string","!doc":"<p>Class to add to the <a href=\"#!/api/Ext.dd.DragDrop-method-getDragEl\" rel=\"Ext.dd.DragDrop-method-getDragEl\" class=\"docClass\">dragged element</a> of a DragDrop instance.</p>\n"},"dragCurrent":{"!doc":"<p>the DragDrop object that is currently being dragged</p>\n"},"dragOvers":{"!doc":"<p>the DragDrop object(s) that are being hovered over</p>\n"},"dragThreshMet":{"!type":"bool","!doc":"<p>Flag that indicates that either the drag pixel threshold or the\nmousdown time threshold has been met</p>\n"},"elementCache":{"!doc":"<p>A cache of DOM elements</p>\n"},"handleIds":{"!doc":"<p>Array of element ids defined as drag handles.  Used to determine\nif the element that generated the mousedown event is actually the\nhandle and not the html element itself.</p>\n"},"ids":{"!doc":"<p>Two dimensional Array of registered DragDrop objects.  The first\ndimension is the DragDrop item group, the second the DragDrop\nobject.</p>\n"},"initialized":{"!type":"bool","!doc":"<p>Internal flag that is set to true when drag and drop has been\nintialized</p>\n"},"locationCache":{"!doc":"<p>Location cache that is set for all drag drop objects when a drag is\ninitiated, cleared when the drag is finished.</p>\n"},"locked":{"!type":"bool","!doc":"<p>All drag and drop can be disabled.</p>\n"},"mode":{"!type":"number","!doc":"<p>The current drag and drop mode.  Default: POINT</p>\n"},"notifyOccluded":{"!type":"bool","!doc":"<p>This config is only provided to provide old, usually unwanted drag/drop behaviour.</p>\n\n<p>From ExtJS 4.1.0 onwards, when drop targets are contained in floating, absolutely positioned elements\nsuch as in <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Windows</a>, which may overlap each other, <code>over</code> and <code>drop</code> events\nare only delivered to the topmost drop target at the mouse position.</p>\n\n<p>If all targets below that in zIndex order should also receive notifications, set\n<code>notifyOccluded</code> to <code>true</code>.</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>Flag to determine if we should prevent the default behavior of the\nevents we define. By default this is true, but this can be set to\nfalse if you need the default behavior (not recommended)</p>\n"},"startX":{"!type":"number","!doc":"<p>The X position of the mousedown event stored for later use when a\ndrag threshold is met.</p>\n"},"startY":{"!type":"number","!doc":"<p>The Y position of the mousedown event stored for later use when a\ndrag threshold is met.</p>\n"},"stopPropagation":{"!type":"bool","!doc":"<p>Flag to determine if we should stop the propagation of the events\nwe generate. This is true by default but you may want to set it to\nfalse if the html element contains other features that require the\nmouse click.</p>\n"},"useCache":{"!type":"bool","!doc":"<p>Set useCache to false if you want to force object the lookup of each\ndrag and drop linked element constantly during a drag.</p>\n"},"_execOnAll":{"!type":"fn(sMethod: ?, args: ?) -> !this","!doc":"<p>Runs method on all drag and drop objects</p>\n"},"_onResize":{"!type":"fn(e: ?) -> !this","!doc":"<p>Reset constraints on all drag and drop objs</p>\n"},"_onUnload":{"!type":"fn(e: ?, me: ?) -> !this","!doc":"<p>unload event handler</p>\n"},"_remove":{"!type":"fn(oDD: ?, clearGroup: ?) -> !this","!doc":"<p>Unregisters a drag and drop item.  This is executed in\nDragDrop.unreg, use that method instead of calling this directly.</p>\n"},"addListeners":{"!type":"fn() -> !this","!doc":"<p>Drag and drop initialization.  Sets up the global event handlers</p>\n"},"byZIndex":{"!type":"fn(d1: ?, d2: ?) -> !this","!doc":"<p>Utility method to pass to Ext.Array.sort when sorting potential drop targets by z-index.</p>\n"},"fireEvents":{"!type":"fn(e: ?, isDrop: ?) -> !this","!doc":"<p>Iterates over all of the DragDrop elements to find ones we are\nhovering over or dropping on</p>\n"},"getBestMatch":{"!type":"fn(dds: ?) -> ?","!doc":"<p>Helper function for getting the best match from the list of drag\nand drop objects returned by the drag and drop events when we are\nin INTERSECT mode.  It returns either the first object that the\ncursor is over, or the object that has the greatest overlap with\nthe dragged element.</p>\n"},"getCss":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns the style property for the DOM element (i.e.,\ndocument.getElById(id).style)</p>\n"},"getDDById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns the DragDrop instance for a given id</p>\n"},"getElWrapper":{"!type":"fn(id: ?) -> ?","!doc":"<p>Get the wrapper for the DOM element specified</p>\n"},"getElement":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns the actual DOM element</p>\n"},"getLocation":{"!type":"fn(oDD: ?) -> ?","!doc":"<p>Returns a Region object containing the drag and drop element's position\nand size, including the padding configured for it</p>\n"},"getRelated":{"!type":"fn(p_oDD: ?, bTargetsOnly: ?) -> ?","!doc":"<p>Returns the drag and drop instances that are in all groups the\npassed in instance belongs to.</p>\n"},"getZIndex":{"!type":"fn(element: ?) -> number","!doc":"<p>Collects the z-index of the passed element, looking up the parentNode axis to find an absolutely positioned ancestor\nwhich is able to yield a z-index. If found to be not absolutely positionedm returns -1.</p>\n\n<p>This is used when sorting potential drop targets into z-index order so that only the topmost receives <code>over</code> and <code>drop</code> events.</p>\n"},"handleMouseDown":{"!type":"fn(e: ?, oDD: ?) -> !this","!doc":"<p>Fired after a registered DragDrop object gets the mousedown event.\nSets up the events required to track the object being dragged</p>\n"},"handleMouseMove":{"!type":"fn(e: ?) -> !this","!doc":"<p>Internal function to handle the mousemove event.  Will be invoked\nfrom the context of the html element.</p>\n\n<p>TODO: figure out what we can do about mouse events lost when the\nuser drags objects beyond the window boundary.  Currently we can\ndetect this in internet explorer by verifying that the mouse is\ndown during the mousemove event.  Firefox doesn't give us the\nbutton state on the mousemove event.</p>\n"},"handleMouseUp":{"!type":"fn(e: ?) -> !this","!doc":"<p>Internal function to handle the mouseup event.  Will be invoked\nfrom the context of the document.</p>\n"},"init":{"!type":"fn() -> !this","!doc":"<p>Called the first time an element is registered.</p>\n"},"isDragDrop":{"!type":"fn(id: ?) -> bool","!doc":"<p>Utility function to determine if a given element has been\nregistered as a drag drop item.</p>\n"},"isHandle":{"!type":"fn(id: ?) -> bool","!doc":"<p>Utility function to determine if a given element has been\nregistered as a drag drop handle for the given Drag Drop object.</p>\n"},"isLegalTarget":{"!type":"fn(oDD: ?, oTargetDD: ?) -> bool","!doc":"<p>Returns true if the specified dd target is a legal target for\nthe specifice drag obj</p>\n"},"isLocked":{"!type":"fn() -> bool","!doc":"<p>Is drag and drop locked?</p>\n"},"isOverTarget":{"!type":"fn(pt: ?, oTarget: ?) -> bool","!doc":"<p>Checks the cursor location to see if it over the target</p>\n"},"isTypeOfDD":{"!type":"fn(the: ?) -> bool","!doc":"<p>My goal is to be able to transparently determine if an object is\ntypeof DragDrop, and the exact subclass of DragDrop.  typeof\nreturns \"object\", oDD.constructor.toString() always returns\n\"DragDrop\" and not the name of the subclass.  So for now it just\nevaluates a well-known variable in DragDrop.</p>\n"},"lock":{"!type":"fn() -> !this","!doc":"<p>Lock all drag and drop functionality</p>\n"},"preventDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>if a drag/drop operation is currently underway, this method stops the dragstart,\ndrag, and dragend events from propagating down to any other listeners, e.g. scrollers</p>\n"},"refreshCache":{"!type":"fn(groups: ?) -> !this","!doc":"<p>Refreshes the cache of the top-left and bottom-right points of the\ndrag and drop objects in the specified group(s).  This is in the\nformat that is stored in the drag and drop instance, so typical\nusage is:</p>\n\n<pre><code><a href=\"#!/api/Ext.dd.DragDropManager-method-refreshCache\" rel=\"Ext.dd.DragDropManager-method-refreshCache\" class=\"docClass\">Ext.dd.DragDropManager.refreshCache</a>(ddinstance.groups);\n</code></pre>\n\n<p>Alternatively:</p>\n\n<pre><code><a href=\"#!/api/Ext.dd.DragDropManager-method-refreshCache\" rel=\"Ext.dd.DragDropManager-method-refreshCache\" class=\"docClass\">Ext.dd.DragDropManager.refreshCache</a>({group1:true, group2:true});\n</code></pre>\n\n<p>TODO: this really should be an indexed array.  Alternatively this\nmethod could accept both.</p>\n"},"regDragDrop":{"!type":"fn(oDD: ?, sGroup: ?) -> !this","!doc":"<p>Each DragDrop instance must be registered with the DragDropManager.\nThis is executed in DragDrop.init()</p>\n"},"regHandle":{"!type":"fn(sDDId: ?, sHandleId: ?) -> !this","!doc":"<p>Each DragDrop handle element must be registered.  This is done\nautomatically when executing DragDrop.setHandleElId()</p>\n"},"removeDDFromGroup":{"!type":"fn(oDD: ?, sGroup: ?) -> !this","!doc":"<p>Removes the supplied dd instance from the supplied group. Executed\nby DragDrop.removeFromGroup, so don't call this function directly.</p>\n"},"startDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Fired when either the drag pixel threshold or the mousedown hold\ntime threshold has been met.</p>\n"},"stopDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Internal function to clean up event handlers after the drag\noperation is complete</p>\n"},"stopEvent":{"!type":"fn(e: ?) -> !this","!doc":"<p>Utility to stop event propagation and event default, if these\nfeatures are turned on.</p>\n"},"unlock":{"!type":"fn() -> !this","!doc":"<p>Unlock all drag and drop functionality</p>\n"},"unregAll":{"!type":"fn() -> !this","!doc":"<p>Cleans up the drag and drop events and objects.</p>\n"},"verifyEl":{"!type":"fn(el: ?) -> bool","!doc":"<p>This checks to make sure an element exists and is in the DOM.  The\nmain purpose is to handle cases where innerHTML is used to remove\ndrag and drop objects from the DOM.  IE provides an 'unspecified\nerror' when trying to access the offsetParent of such an element</p>\n"}},"DragSource":{"!doc":"<p>A simple class that provides the basic implementation needed to make any element draggable.</p>\n","!type":"fn(el: ?, config?: ?)","prototype":{"animRepair":{"!type":"bool","!doc":"<p>If true, animates the proxy element back to the position of the handle element used to trigger the drag.</p>\n"},"ddGroup":{"!type":"string","!doc":"<p>A named drag drop group to which this object belongs.  If a group is specified, then this object will only\ninteract with other drag drop objects in the same group.</p>\n"},"dropAllowed":{"!type":"string","!doc":"<p>The CSS class returned to the drag source when drop is allowed.</p>\n"},"dropNotAllowed":{"!type":"string","!doc":"<p>The CSS class returned to the drag source when drop is not allowed.</p>\n"},"repairHighlightColor":{"!type":"string","!doc":"<p>The color to use when visually highlighting the drag source in the afterRepair\nmethod after a failed drop (defaults to light blue). The color must be a 6 digit hex value, without\na preceding '#'.</p>\n"},"dragData":{"!doc":"<p>This property contains the data representing the dragged object. This data is set up by the implementation of the\n<a href=\"#!/api/Ext.dd.DragSource-method-getDragData\" rel=\"Ext.dd.DragSource-method-getDragData\" class=\"docClass\">getDragData</a> method. It must contain a ddel property, but can contain any other data according to the\napplication's needs.</p>\n"},"afterDragDrop":{"!type":"fn(target: ?, e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nafter a valid drag drop has occurred by providing an implementation.</p>\n"},"afterDragEnter":{"!type":"fn(target: ?, e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nwhen the dragged item enters the drop target by providing an implementation.</p>\n"},"afterDragOut":{"!type":"fn(target: ?, e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nafter the dragged item is dragged out of the target without dropping.</p>\n"},"afterDragOver":{"!type":"fn(target: ?, e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the drop target by providing an implementation.</p>\n"},"afterInvalidDrop":{"!type":"fn(e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nafter an invalid drop has occurred by providing an implementation.</p>\n"},"afterRepair":{"!type":"fn() -> !this"},"afterValidDrop":{"!type":"fn(target: ?, e: ?, id: ?)","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nafter a valid drop has occurred by providing an implementation.</p>\n"},"alignElWithMouse":{"!type":"fn() -> !this","!doc":"<p>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n"},"autoOffset":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was clicked.</p>\n"},"b4EndDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></p>\n"},"beforeDragDrop":{"!type":"fn(target: ?, e: ?, id: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dropped onto the target and optionally cancel the onDragDrop.</p>\n"},"beforeDragEnter":{"!type":"fn(target: ?, e: ?, id: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nbefore the dragged item enters the drop target and optionally cancel the onDragEnter.</p>\n"},"beforeDragOut":{"!type":"fn(target: ?, e: ?, id: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dragged out of the target without dropping, and optionally cancel the onDragOut.</p>\n"},"beforeDragOver":{"!type":"fn(target: ?, e: ?, id: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the drop target and optionally cancel the onDragOver.</p>\n"},"beforeInvalidDrop":{"!type":"fn(target: ?, e: ?, id: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action after an invalid\ndrop has occurred.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy this DragDrop instance</p>\n"},"endDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>overrides <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>\nBy default we try to move the element to the last location of the frame.\nThis is so that the default behavior mirrors that of <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.</p>\n"},"getDragData":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns the data object associated with this drag source</p>\n"},"getProxy":{"!type":"fn() -> ?","!doc":"<p>Returns the drag source's underlying <a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></p>\n"},"getRepairXY":{"!type":"fn(e: ?, data: ?) -> !this"},"handleMouseDown":{"!type":"fn(e: ?, oDD: ?) -> !this","!doc":"<p>Called when this object is clicked</p>\n"},"hideProxy":{"!type":"fn() -> !this","!doc":"<p>Hides the drag source's <a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></p>\n"},"onBeforeDrag":{"!type":"fn(data: ?, e: ?) -> bool","!doc":"<p>An empty function by default, but provided so that you can perform a custom action before the initial\ndrag event begins and optionally cancel it.</p>\n"},"onDragDrop":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this item is dropped on another DragDrop\nobj</p>\n"},"onDragEnter":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this element fist begins hovering over\nanother DragDrop obj</p>\n"},"onDragOut":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when we are no longer hovering over an element</p>\n"},"onDragOver":{"!type":"fn(e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this element is hovering over another\nDragDrop obj</p>\n"},"onEndDrag":{"!type":"fn(data: ?, e: ?) -> !this"},"onInitDrag":{"!type":"fn(x: ?, y: ?) -> !this"},"onInvalidDrop":{"!type":"fn(target: ?, e: ?, id: ?) -> !this","!doc":"<p>Abstract method called when this item is dropped on an area with no\ndrop target</p>\n"},"onStartDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>An empty function by default, but provided so that you can perform a custom action once the initial\ndrag event has begun.  The drag cannot be canceled from this function.</p>\n"},"onValidDrop":{"!type":"fn(target: ?, e: ?, id: ?) -> !this"},"startDrag":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met.</p>\n"},"triggerCacheRefresh":{"!type":"fn() -> !this"}}},"DragTracker":{"!doc":"<p>A DragTracker listens for drag events on an Element and fires events at the start and end of the drag,\nas well as during the drag. This is useful for components such as <a href=\"#!/api/Ext.slider.Multi\" rel=\"Ext.slider.Multi\" class=\"docClass\">Ext.slider.Multi</a>, where there is\nan element that can be dragged around to change the Slider's value.</p>\n\n<p>DragTracker provides a series of template methods that should be overridden to provide functionality\nin response to detected drag operations. These are onBeforeStart, onStart, onDrag and onEnd.\nSee <a href=\"#!/api/Ext.slider.Multi\" rel=\"Ext.slider.Multi\" class=\"docClass\">Ext.slider.Multi</a>'s initEvents function for an example implementation.</p>\n","prototype":{"autoStart":{"!doc":"<p>Specify <code>true</code> to defer trigger start by 1000 ms.\nSpecify a Number for the number of milliseconds to defer trigger start.</p>\n"},"constrainTo":{"!doc":"<p>A Region (Or an element from which a Region measurement will be read)\nwhich is used to constrain the result of the <a href=\"#!/api/Ext.dd.DragTracker-method-getOffset\" rel=\"Ext.dd.DragTracker-method-getOffset\" class=\"docClass\">getOffset</a> call.</p>\n\n<p>This may be set any time during the DragTracker's lifecycle to set a dynamic constraining region.</p>\n"},"delegate":{"!type":"string","!doc":"<p>A CSS selector which identifies child elements within the DragTracker's encapsulating\nElement which are the tracked elements. This limits tracking to only begin when the matching elements are mousedowned.</p>\n\n<p>This may also be a specific child element within the DragTracker's encapsulating element to use as the tracked element.</p>\n"},"overCls":{"!type":"string","!doc":"<p>A CSS class to add to the DragTracker's target element when the element (or, if the <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a>\noption is used, when a delegate element) is mouseovered.</p>\n\n<p>If the <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> option is used, these events fire only when a delegate element is entered of left.</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>Specify <code>false</code> to enable default actions on onMouseDown events.</p>\n"},"stopEvent":{"!type":"bool","!doc":"<p>Specify <code>true</code> to stop the <code>mousedown</code> event from bubbling to outer listeners from the target element (or its delegates).</p>\n"},"tolerance":{"!type":"number","!doc":"<p>Number of pixels the drag target must be moved before dragging is\nconsidered to have started.</p>\n"},"trackOver":{"!type":"bool","!doc":"<p>Set to true to fire mouseover and mouseout events when the mouse enters or leaves the target element.</p>\n\n<p>This is implicitly set when an <a href=\"#!/api/Ext.dd.DragTracker-cfg-overCls\" rel=\"Ext.dd.DragTracker-cfg-overCls\" class=\"docClass\">overCls</a> is specified.</p>\n\n<p>If the <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> option is used, these events fire only when a delegate element is entered of left.</p>\n"},"active":{"!type":"bool","!doc":"<p>Indicates whether the user is currently dragging this tracker.</p>\n"},"constrainModes":{},"dragTarget":{"!doc":"<p>The element being dragged.</p>\n\n<p>Only valid during drag operations.</p>\n\n<p>If the <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> option is used, this will be the delegate element which was mousedowned.</p>\n"},"clearStart":{"!type":"fn() -> !this"},"destroy":{"!type":"fn() -> !this"},"disable":{"!type":"fn() -> !this"},"enable":{"!type":"fn() -> !this"},"endDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Stop the drag operation, and remove active mouse listeners.</p>\n"},"getConstrainRegion":{"!type":"fn() -> !this","!doc":"<p>Return the Region into which the drag operation is constrained.\nEither the XY pointer itself can be constrained, or the dragTarget element\nThe private property _constrainRegion is cached until onMouseUp</p>\n"},"getDragCt":{"!type":"fn() -> ?"},"getDragTarget":{"!type":"fn() -> ?","!doc":"<p>Returns the drag target. This is usually the DragTracker's encapsulating element.</p>\n\n<p>If the <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> option is being used, this may be a child element which matches the\n<a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> selector.</p>\n"},"getOffset":{"!type":"fn(constrainMode?: ?) -> ?","!doc":"<p>Returns the X, Y offset of the current mouse position from the mousedown point.</p>\n\n<p>This method may optionally constrain the real offset values, and returns a point coerced in one\nof two modes:</p>\n\n<ul>\n<li><code>point</code>\nThe current mouse position is coerced into the constrainRegion and the resulting position is returned.</li>\n<li><code>dragTarget</code>\nThe new Region of the <a href=\"#!/api/Ext.dd.DragTracker-method-getDragTarget\" rel=\"Ext.dd.DragTracker-method-getDragTarget\" class=\"docClass\">dragTarget</a> is calculated\nbased upon the current mouse position, and then coerced into the constrainRegion. The returned\nmouse position is then adjusted by the same delta as was used to coerce the region.</li>\n</ul>\n\n"},"getXY":{"!type":"fn(constrain: ?) -> !this"},"initEl":{"!type":"fn(el: ?) -> !this","!doc":"<p>Initializes the DragTracker on a given element.</p>\n"},"onBeforeStart":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when the user first clicks and\nholds the mouse button down. Return false to disallow the drag</p>\n"},"onDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called whenever a drag has been detected.</p>\n"},"onDragStart":{"!type":"fn(e: ?) -> !this"},"onEnd":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation has been completed\n(e.g. the user clicked and held the mouse down, dragged the element and then released the mouse button)</p>\n"},"onMouseDown":{"!type":"fn(e: ?, target: ?) -> !this"},"onMouseMove":{"!type":"fn(e: ?, target: ?) -> !this"},"onMouseOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>When the pointer exits a tracking element, fire a mouseout.\nThis is mouseleave functionality, but we cannot use mouseleave because we are using \"delegate\" to filter mouse targets</p>\n"},"onMouseOver":{"!type":"fn(e: ?, target: ?) -> !this","!doc":"<p>When the pointer enters a tracking element, fire a mouseover if the mouse entered from outside.\nThis is mouseenter functionality, but we cannot use mouseenter because we are using \"delegate\" to filter mouse targets</p>\n"},"onMouseUp":{"!type":"fn(e: ?) -> !this"},"onStart":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation starts\n(e.g. the user has moved the tracked element beyond the specified tolerance)</p>\n"},"stopSelect":{"!type":"fn(e: ?) -> !this"},"triggerStart":{"!type":"fn(e: ?) -> !this"},"beforestart":{"!type":"fn(this: ?, e: ?, eOpts: ?)"},"drag":{"!type":"fn(this: ?, e: ?, eOpts: ?)"},"dragend":{"!type":"fn(this: ?, e: ?, eOpts: ?)"},"dragstart":{"!type":"fn(this: ?, e: ?, eOpts: ?)"},"mousedown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse button is pressed down, but before a drag operation begins. The\ndrag operation begins after either the mouse has been moved by <a href=\"#!/api/Ext.dd.DragTracker-cfg-tolerance\" rel=\"Ext.dd.DragTracker-cfg-tolerance\" class=\"docClass\">tolerance</a> pixels,\nor after the <a href=\"#!/api/Ext.dd.DragTracker-cfg-autoStart\" rel=\"Ext.dd.DragTracker-cfg-autoStart\" class=\"docClass\">autoStart</a> timer fires.</p>\n\n<p>Return <code>false</code> to veto the drag operation.</p>\n"},"mousemove":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fired when the mouse is moved. Returning false cancels the drag operation.</p>\n"},"mouseout":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse exits the DragTracker's target element (or if <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> is\nused, when the mouse exits a delegate element).</p>\n\n<p><strong>Only available when <a href=\"#!/api/Ext.dd.DragTracker-cfg-trackOver\" rel=\"Ext.dd.DragTracker-cfg-trackOver\" class=\"docClass\">trackOver</a> is <code>true</code></strong></p>\n"},"mouseover":{"!type":"fn(this: ?, e: ?, target: ?, eOpts: ?)","!doc":"<p>Fires when the mouse enters the DragTracker's target element (or if <a href=\"#!/api/Ext.dd.DragTracker-cfg-delegate\" rel=\"Ext.dd.DragTracker-cfg-delegate\" class=\"docClass\">delegate</a> is\nused, when the mouse enters a delegate element).</p>\n\n<p><strong>Only available when <a href=\"#!/api/Ext.dd.DragTracker-cfg-trackOver\" rel=\"Ext.dd.DragTracker-cfg-trackOver\" class=\"docClass\">trackOver</a> is <code>true</code></strong></p>\n"},"mouseup":{"!type":"fn(this: ?, e: ?, eOpts: ?)"}}},"DragZone":{"!doc":"<p>This class provides a container DD instance that allows dragging of multiple child source nodes.</p>\n\n<p>This class does not move the drag target nodes, but a proxy element which may contain any DOM structure you wish. The\nDOM element to show in the proxy is provided by either a provided implementation of <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a>, or by\nregistered draggables registered with <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a></p>\n\n<p>If you wish to provide draggability for an arbitrary number of DOM nodes, each of which represent some application\nobject (For example nodes in a <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>) then use of this class is the most efficient way to\n\"activate\" those nodes.</p>\n\n<p>By default, this class requires that draggable child nodes are registered with <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a>. However a\nsimpler way to allow a DragZone to manage any number of draggable elements is to configure the DragZone with an\nimplementation of the <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a> method which interrogates the passed mouse event to see if it has taken\nplace within an element, or class of elements. This is easily done by using the event's getTarget method to identify a node based on a CSS selector. For example,\nto make the nodes of a DataView draggable, use the following technique. Knowledge of the use of the DataView is\nrequired:</p>\n\n<pre><code>myDataView.on('render', function(v) {\n    myDataView.dragZone = new <a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">Ext.dd.DragZone</a>(v.getEl(), {\n\n//      On receipt of a mousedown event, see if it is within a DataView node.\n//      Return a drag data object if so.\n        getDragData: function(e) {\n\n//          Use the DataView's own itemSelector (a mandatory property) to\n//          test if the mousedown is within one of the DataView's nodes.\n            var sourceEl = e.getTarget(v.itemSelector, 10);\n\n//          If the mousedown is within a DataView node, clone the node to produce\n//          a ddel element for use by the drag proxy. Also add application data\n//          to the returned data object.\n            if (sourceEl) {\n                d = sourceEl.cloneNode(true);\n                d.id = Ext.id();\n                return {\n                    ddel: d,\n                    sourceEl: sourceEl,\n                    repairXY: Ext.fly(sourceEl).getXY(),\n                    sourceStore: v.store,\n                    draggedRecord: v.<a href=\"#!/api/Ext.view.View-method-getRecord\" rel=\"Ext.view.View-method-getRecord\" class=\"docClass\">getRecord</a>(sourceEl)\n                }\n            }\n        },\n\n//      Provide coordinates for the proxy to slide back to on failed drag.\n//      This is the original XY coordinates of the draggable element captured\n//      in the getDragData method.\n        getRepairXY: function() {\n            return this.dragData.repairXY;\n        }\n    });\n});\n</code></pre>\n\n<p>See the <a href=\"#!/api/Ext.dd.DropZone\" rel=\"Ext.dd.DropZone\" class=\"docClass\">DropZone</a> documentation for details about building a DropZone which cooperates with\nthis DragZone.</p>\n","!type":"fn(el: ?, config: ?)","prototype":{"containerScroll":{"!doc":"<p>True to register this container with the Scrollmanager for auto scrolling during drag operations.\nA <a href=\"#!/api/Ext.dd.ScrollManager\" rel=\"Ext.dd.ScrollManager\" class=\"docClass\">Ext.dd.ScrollManager</a> configuration may also be passed.</p>\n"},"scrollEl":{"!doc":"<p>An element to register with the ScrollManager if <a href=\"#!/api/Ext.dd.DragZone-cfg-containerScroll\" rel=\"Ext.dd.DragZone-cfg-containerScroll\" class=\"docClass\">containerScroll</a>\nis set. Defaults to the drag element.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy this DragDrop instance</p>\n"},"getDragData":{"!type":"fn(e: ?) -> ?","!doc":"<p>Called when a mousedown occurs in this container. Looks in <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a> for a valid target to drag\nbased on the mouse down. Override this method to provide your own lookup logic (e.g. finding a child by class\nname). Make sure your returned object has a \"ddel\" attribute (with an HTML Element) for other functions to work.</p>\n"},"getRepairXY":{"!type":"fn(e: ?) -> ?","!doc":"<p>Called before a repair of an invalid drop to get the XY to animate to. By default returns the XY of\nthis.dragData.ddel</p>\n"},"onInitDrag":{"!type":"fn(x: ?, y: ?) -> bool","!doc":"<p>Called once drag threshold has been reached to initialize the proxy element. By default, it clones the\nthis.dragData.ddel</p>\n"}}},"DropZone":{"!doc":"<p>This class provides a container DD instance that allows dropping on multiple child target nodes.</p>\n\n<p>By default, this class requires that child nodes accepting drop are registered with <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a>.\nHowever a simpler way to allow a DropZone to manage any number of target elements is to configure the\nDropZone with an implementation of <a href=\"#!/api/Ext.dd.DropZone-method-getTargetFromEvent\" rel=\"Ext.dd.DropZone-method-getTargetFromEvent\" class=\"docClass\">getTargetFromEvent</a> which interrogates the passed\nmouse event to see if it has taken place within an element, or class of elements. This is easily done\nby using the event's getTarget method to identify a node based on a\nCSS selector.</p>\n\n<p>Once the DropZone has detected through calling getTargetFromEvent, that the mouse is over\na drop target, that target is passed as the first parameter to <a href=\"#!/api/Ext.dd.DropZone-method-onNodeEnter\" rel=\"Ext.dd.DropZone-method-onNodeEnter\" class=\"docClass\">onNodeEnter</a>, <a href=\"#!/api/Ext.dd.DropZone-method-onNodeOver\" rel=\"Ext.dd.DropZone-method-onNodeOver\" class=\"docClass\">onNodeOver</a>,\n<a href=\"#!/api/Ext.dd.DropZone-method-onNodeOut\" rel=\"Ext.dd.DropZone-method-onNodeOut\" class=\"docClass\">onNodeOut</a>, <a href=\"#!/api/Ext.dd.DropZone-method-onNodeDrop\" rel=\"Ext.dd.DropZone-method-onNodeDrop\" class=\"docClass\">onNodeDrop</a>. You may configure the instance of DropZone with implementations\nof these methods to provide application-specific behaviour for these events to update both\napplication state, and UI state.</p>\n\n<p>For example to make a GridPanel a cooperating target with the example illustrated in\n<a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a>, the following technique might be used:</p>\n\n<pre><code>myGridPanel.on('render', function() {\n    myGridPanel.dropZone = new <a href=\"#!/api/Ext.dd.DropZone\" rel=\"Ext.dd.DropZone\" class=\"docClass\">Ext.dd.DropZone</a>(myGridPanel.getView().scroller, {\n\n        // If the mouse is over a grid row, return that node. This is\n        // provided as the \"target\" parameter in all \"onNodeXXXX\" node event handling functions\n        getTargetFromEvent: function(e) {\n            return e.getTarget(myGridPanel.getView().rowSelector);\n        },\n\n        // On entry into a target node, highlight that node.\n        onNodeEnter : function(target, dd, e, data){\n            Ext.fly(target).addCls('my-row-highlight-class');\n        },\n\n        // On exit from a target node, unhighlight that node.\n        onNodeOut : function(target, dd, e, data){\n            Ext.fly(target).removeCls('my-row-highlight-class');\n        },\n\n        // While over a target node, return the default drop allowed class which\n        // places a \"tick\" icon into the drag proxy.\n        onNodeOver : function(target, dd, e, data){\n            return Ext.dd.DropZone.prototype.dropAllowed;\n        },\n\n        // On node drop we can interrogate the target to find the underlying\n        // application object that is the real target of the dragged data.\n        // In this case, it is a Record in the GridPanel's Store.\n        // We can use the data set up by the DragZone's getDragData method to read\n        // any data we decided to attach in the DragZone's getDragData method.\n        onNodeDrop : function(target, dd, e, data){\n            var rowIndex = myGridPanel.getView().findRowIndex(target);\n            var r = myGridPanel.getStore().getAt(rowIndex);\n            <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Drop gesture', 'Dropped Record id ' + data.draggedRecord.id +\n                ' on Record id ' + r.id);\n            return true;\n        }\n    });\n}\n</code></pre>\n\n<p>See the <a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">DragZone</a> documentation for details about building a DragZone which\ncooperates with this DropZone.</p>\n","!type":"fn(el: ?, config: ?)","prototype":{"getTargetFromEvent":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns a custom data object associated with the DOM node that is the target of the event.  By default\nthis looks up the event target in the <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a>, although you can override this method to\nprovide your own custom lookup.</p>\n"},"notifyDrop":{"!type":"fn(source: ?, e: ?, data: ?) -> bool","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop zone that the dragged item has\nbeen dropped on it.  The drag zone will look up the target node based on the event passed in, and if there\nis a node registered for that event, it will delegate to <a href=\"#!/api/Ext.dd.DropZone-method-onNodeDrop\" rel=\"Ext.dd.DropZone-method-onNodeDrop\" class=\"docClass\">onNodeDrop</a> for node-specific handling,\notherwise it will call <a href=\"#!/api/Ext.dd.DropZone-method-onContainerDrop\" rel=\"Ext.dd.DropZone-method-onContainerDrop\" class=\"docClass\">onContainerDrop</a>.</p>\n"},"notifyEnter":{"!type":"fn(source: ?, e: ?, data: ?) -> string","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop zone that the source is now over\nthe zone.  The default implementation returns this.dropNotAllowed and expects that only registered drop\nnodes can process drag drop operations, so if you need the drop zone itself to be able to process drops\nyou should override this method and provide a custom implementation.</p>\n"},"notifyOut":{"!type":"fn(source: ?, e: ?, data: ?) -> !this","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls once to notify this drop zone that the source has been dragged\nout of the zone without dropping.  If the drag source is currently over a registered node, the notification\nwill be delegated to <a href=\"#!/api/Ext.dd.DropZone-method-onNodeOut\" rel=\"Ext.dd.DropZone-method-onNodeOut\" class=\"docClass\">onNodeOut</a> for node-specific handling, otherwise it will be ignored.</p>\n"},"notifyOver":{"!type":"fn(source: ?, e: ?, data: ?) -> string","!doc":"<p>The function a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> calls continuously while it is being dragged over the drop zone.\nThis method will be called on every mouse movement while the drag source is over the drop zone.\nIt will call <a href=\"#!/api/Ext.dd.DropZone-method-onNodeOver\" rel=\"Ext.dd.DropZone-method-onNodeOver\" class=\"docClass\">onNodeOver</a> while the drag source is over a registered node, and will also automatically\ndelegate to the appropriate node-specific methods as necessary when the drag source enters and exits\nregistered nodes (<a href=\"#!/api/Ext.dd.DropZone-method-onNodeEnter\" rel=\"Ext.dd.DropZone-method-onNodeEnter\" class=\"docClass\">onNodeEnter</a>, <a href=\"#!/api/Ext.dd.DropZone-method-onNodeOut\" rel=\"Ext.dd.DropZone-method-onNodeOut\" class=\"docClass\">onNodeOut</a>). If the drag source is not currently over a\nregistered node, it will call <a href=\"#!/api/Ext.dd.DropZone-method-onContainerOver\" rel=\"Ext.dd.DropZone-method-onContainerOver\" class=\"docClass\">onContainerOver</a>.</p>\n"},"onContainerDrop":{"!type":"fn(source: ?, e: ?, data: ?) -> bool","!doc":"<p>Called when the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> has been dropped on it,\nbut not on any of its registered drop nodes.  The default implementation returns false, so it should be\noverridden to provide the appropriate processing of the drop event if you need the drop zone itself to\nbe able to accept drops.  It should return true when valid so that the drag source's repair action does not run.</p>\n"},"onContainerOver":{"!type":"fn(source: ?, e: ?, data: ?) -> string","!doc":"<p>Called while the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> is being dragged over it,\nbut not over any of its registered drop nodes.  The default implementation returns this.dropNotAllowed, so\nit should be overridden to provide the proper feedback if necessary.</p>\n"},"onNodeDrop":{"!type":"fn(nodeData: ?, source: ?, e: ?, data: ?) -> bool","!doc":"<p>Called when the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> has been dropped onto\nthe drop node.  The default implementation returns false, so it should be overridden to provide the\nappropriate processing of the drop event and return true so that the drag source's repair action does not run.</p>\n"},"onNodeEnter":{"!type":"fn(nodeData: ?, source: ?, e: ?, data: ?) -> !this","!doc":"<p>Called when the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> has entered a drop node\nthat has either been registered or detected by a configured implementation of <a href=\"#!/api/Ext.dd.DropZone-method-getTargetFromEvent\" rel=\"Ext.dd.DropZone-method-getTargetFromEvent\" class=\"docClass\">getTargetFromEvent</a>.\nThis method has no default implementation and should be overridden to provide\nnode-specific processing if necessary.</p>\n"},"onNodeOut":{"!type":"fn(nodeData: ?, source: ?, e: ?, data: ?) -> !this","!doc":"<p>Called when the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> has been dragged out of\nthe drop node without dropping.  This method has no default implementation and should be overridden to provide\nnode-specific processing if necessary.</p>\n"},"onNodeOver":{"!type":"fn(nodeData: ?, source: ?, e: ?, data: ?) -> string","!doc":"<p>Called while the DropZone determines that a <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> is over a drop node\nthat has either been registered or detected by a configured implementation of <a href=\"#!/api/Ext.dd.DropZone-method-getTargetFromEvent\" rel=\"Ext.dd.DropZone-method-getTargetFromEvent\" class=\"docClass\">getTargetFromEvent</a>.\nThe default implementation returns this.dropAllowed, so it should be\noverridden to provide the proper feedback.</p>\n"},"triggerCacheRefresh":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"}}},"Registry":{"!doc":"<p>Provides easy access to all drag drop components that are registered on a page. Items can be retrieved either\ndirectly by DOM node id, or by passing in the drag drop event that occurred and looking up the event target.</p>\n","!type":"fn()","getHandle":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns the handle registered for a DOM Node by id</p>\n"},"getHandleFromEvent":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns the handle that is registered for the DOM node that is the target of the event</p>\n"},"getId":{"!type":"fn(el: ?, autogen: ?) -> !this"},"getTarget":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns a custom data object that is registered for a DOM node by id</p>\n"},"getTargetFromEvent":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns a custom data object that is registered for the DOM node that is the target of the event</p>\n"},"register":{"!type":"fn(element: ?, data: ?) -> !this","!doc":"<p>Registers a drag drop element.</p>\n"},"unregister":{"!type":"fn(element: ?) -> !this","!doc":"<p>Unregister a drag drop element</p>\n"}},"ScrollManager":{"!doc":"<p>Provides automatic scrolling of overflow regions in the page during drag operations.</p>\n\n<p>The ScrollManager configs will be used as the defaults for any scroll container registered with it, but you can also\noverride most of the configs per scroll container by adding a ddScrollConfig object to the target element that\ncontains these properties: <a href=\"#!/api/Ext.dd.ScrollManager-property-hthresh\" rel=\"Ext.dd.ScrollManager-property-hthresh\" class=\"docClass\">hthresh</a>, <a href=\"#!/api/Ext.dd.ScrollManager-property-vthresh\" rel=\"Ext.dd.ScrollManager-property-vthresh\" class=\"docClass\">vthresh</a>, <a href=\"#!/api/Ext.dd.ScrollManager-property-increment\" rel=\"Ext.dd.ScrollManager-property-increment\" class=\"docClass\">increment</a> and <a href=\"#!/api/Ext.dd.ScrollManager-property-frequency\" rel=\"Ext.dd.ScrollManager-property-frequency\" class=\"docClass\">frequency</a>. Example\nusage:</p>\n\n<pre><code>var el = Ext.get('scroll-ct');\nel.ddScrollConfig = {\n    vthresh: 50,\n    hthresh: -1,\n    frequency: 100,\n    increment: 200\n};\n<a href=\"#!/api/Ext.dd.ScrollManager-method-register\" rel=\"Ext.dd.ScrollManager-method-register\" class=\"docClass\">Ext.dd.ScrollManager.register</a>(el);\n</code></pre>\n\n<p>Note: This class is designed to be used in \"Point Mode</p>\n","!type":"fn()","animDuration":{"!type":"number","!doc":"<p>The animation duration in seconds - MUST BE less than <a href=\"#!/api/Ext.dd.ScrollManager-property-frequency\" rel=\"Ext.dd.ScrollManager-property-frequency\" class=\"docClass\">Ext.dd.ScrollManager.frequency</a>!</p>\n"},"animate":{"!type":"bool","!doc":"<p>True to animate the scroll</p>\n"},"ddGroup":{"!type":"string","!doc":"<p>The named drag drop <a href=\"#!/api/Ext.dd.DragSource-cfg-ddGroup\" rel=\"Ext.dd.DragSource-cfg-ddGroup\" class=\"docClass\">group</a> to which this container belongs. If a ddGroup is\nspecified, then container scrolling will only occur when a dragged object is in the same ddGroup.</p>\n"},"dirTrans":{},"frequency":{"!type":"number","!doc":"<p>The frequency of scrolls in milliseconds</p>\n"},"hthresh":{"!doc":"<p>The number of pixels from the right or left edge of a container the pointer needs to be to trigger scrolling</p>\n"},"increment":{"!type":"number","!doc":"<p>The number of pixels to scroll in each scroll increment</p>\n"},"vthresh":{"!doc":"<p>The number of pixels from the top or bottom edge of a container the pointer needs to be to trigger scrolling</p>\n"},"clearProc":{"!type":"fn() -> !this"},"doScroll":{"!type":"fn() -> !this"},"onFire":{"!type":"fn(e: ?, isDrop: ?) -> !this"},"onStop":{"!type":"fn(e: ?) -> !this"},"refreshCache":{"!type":"fn() -> !this","!doc":"<p>Manually trigger a cache refresh.</p>\n"},"register":{"!type":"fn(el: ?) -> !this","!doc":"<p>Registers new overflow element(s) to auto scroll</p>\n"},"startProc":{"!type":"fn(el: ?, dir: ?) -> !this"},"triggerRefresh":{"!type":"fn() -> !this"},"unregister":{"!type":"fn(el: ?) -> !this","!doc":"<p>Unregisters overflow element(s) so they are no longer scrolled</p>\n"}},"StatusProxy":{"!doc":"<p>A specialized floating Component that supports a drop status icon, <a href=\"#!/api/Ext.dom.Layer\" rel=\"Ext.dom.Layer\" class=\"docClass\">Ext.Layer</a> styles\nand auto-repair.  This is the default drag proxy used by all Ext.dd components.</p>\n","!type":"fn(config?: ?)","prototype":{"childEls":{"!doc":"<p>The canonical form of <code>childEls</code> is an object keyed by child's property name\nwith values that are objects with the following properties.</p>\n\n<ul>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the\nchild element.</li>\n<li><code>id</code> - The id of the child element.</li>\n<li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This\nshould be set on things like the generated content for an <code><a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a></code>.</li>\n<li><code>select</code>: A selector that will be passed to Ext.dom.Element.select.</li>\n<li><code>selectNode</code>: A selector that will be passed to Ext.dom.Element.selectNode.</li>\n</ul>\n\n\n<p>For example:</p>\n\n<pre><code> childEls: {\n     button: true,\n     buttonText: 'text',\n     buttonImage: {\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above is translated into the following complete form:</p>\n\n<pre><code> childEls: {\n     button: {\n         name: 'button',\n         itemId: 'button'\n     },\n     buttonText: {\n         name: 'buttonText',\n         itemId: 'text'\n     },\n     buttonImage: {\n         name: 'buttonImage',\n         itemId: 'image'\n     }\n }\n</code></pre>\n\n<p>The above can be provided as an array like so:</p>\n\n<pre><code> childEls: [\n     'button',\n     { name: 'buttonText', itemId: 'text' },\n     { name: 'buttonImage', itemId: 'image' }\n }\n</code></pre>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: Ext.getBody(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of Ext.CompositeElement.\nIn all other cases, the property will be an Ext.dom.Element or <code>null</code>\nif not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.\nThe following issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be 10x slower than id lookup.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children\nhave been rendered, so selectors can match elements from child components\n(including nested versions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n"},"dropAllowed":{"!type":"string","!doc":"<p>The CSS class to apply to the status element when drop is allowed.</p>\n"},"dropNotAllowed":{"!type":"string","!doc":"<p>The CSS class to apply to the status element when drop is not allowed.</p>\n"},"renderTpl":{"!doc":"<p>An XTemplate used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.dd.StatusProxy-method-getEl\" rel=\"Ext.dd.StatusProxy-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.dd.StatusProxy-method-getEl\" rel=\"Ext.dd.StatusProxy-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.dd.StatusProxy-cfg-renderSelectors\" rel=\"Ext.dd.StatusProxy-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.dd.StatusProxy-cfg-childEls\" rel=\"Ext.dd.StatusProxy-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"animRepair":{"!type":"bool"},"ariaRole":{"!type":"string"},"repairCls":{"!type":"string"},"afterRepair":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"getGhost":{"!type":"fn() -> ?","!doc":"<p>Returns the ghost element</p>\n"},"hide":{"!type":"fn(clear: ?) -> !this","!doc":"<p>Hides the proxy</p>\n"},"repair":{"!type":"fn(xy: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Causes the proxy to return to its position of origin via an animation.\nShould be called after an invalid drop operation by the item being dragged.</p>\n"},"reset":{"!type":"fn(clearGhost: ?) -> !this","!doc":"<p>Resets the status indicator to the default dropNotAllowed value</p>\n"},"setStatus":{"!type":"fn(cssClass: ?) -> !this","!doc":"<p>Updates the proxy's visual element to indicate the status of whether or not drop is allowed\nover the current target element.</p>\n"},"stop":{"!type":"fn() -> !this","!doc":"<p>Stops the repair animation if it's currently running</p>\n"},"sync":{"!type":"fn() -> !this","!doc":"<p>Force the Layer to sync its shadow and shim positions to the element</p>\n"},"update":{"!type":"fn(html: ?) -> !this","!doc":"<p>Updates the contents of the ghost element</p>\n"}}}},"dom":{"ButtonElement":{"!doc":"<p>A special Ext.dom.Element used by Buttons.  Since buttons use <code>display:table</code> elements\nfor their layout, some special adjustments are needed when the width switches from\nauto to fixed width and back.</p>\n\n<p>When the button has a width other than <code>auto</code>, and a right-aligned arrow, long button\ntext will cause the arrow to disappear off the right edge of the button if the btnWrap\nelement has table-layout:auto.  To prevent this, we need to set table-layout:fixed\non the btnWrap when the button has a width, however, when the button is shrinkwrap\nwidth the btnWrap cannot have table-layout:fixed because its width:100% style will\ncause the button to expand outward.</p>\n\n<p>Additionally, in shrinkWrap height mode, the button css sets a height on the btnEl\nelement, but if the height is being stretched, the btnEl's height will cause the contents\nto be incorrectly vertically centered, so we dynamically set the btnEl's height to\n\"auto\" in fixed-height mode.</p>\n","prototype":{"setHeight":{"!type":"fn(height: ?, animate: ?) -> ?"},"setSize":{"!type":"fn(width: ?, height: ?, animate: ?) -> !this"},"setStyle":{"!type":"fn(prop: ?, value: ?) -> !this"},"setWidth":{"!type":"fn(width: ?, animate: ?) -> ?"}}},"Layer":{"!doc":"<p>An extended Ext.dom.Element object that supports a shadow, constrain to viewport\nand automatic maintaining of shadow position.</p>\n","!type":"fn(config?: ?, existingEl?: ?)","prototype":{"cls":{"!type":"string","!doc":"<p>CSS class to add to the element</p>\n"},"constrain":{"!type":"bool","!doc":"<p>False to disable constrain to viewport.</p>\n"},"dh":{"!doc":"<p>DomHelper object config to create element with.</p>\n"},"hideMode":{"!type":"string","!doc":"<p>A String which specifies how this Layer will be hidden.\nValues may be:</p>\n\n<ul>\n<li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>\n<li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>\n<li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the visible area\nof the document. This is useful when a hidden Component must maintain measurable dimensions.\nHiding using <code>display</code> results in a Component having zero dimensions.</li>\n</ul>\n\n"},"shadow":{"!doc":"<p>True to automatically create an <a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the\nshadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. False to disable the shadow.</p>\n"},"shadowOffset":{"!type":"number","!doc":"<p>Number of pixels to offset the shadow</p>\n"},"useDisplay":{"!type":"bool","!doc":"<p>Defaults to use css offsets to hide the Layer. Specify <tt>true</tt>\nto use css style <tt>'display:none;'</tt> to hide the Layer.</p>\n"},"visibilityCls":{"!type":"string","!doc":"<p>The CSS class name to add in order to hide this Layer if this layer\nis configured with <code><a href=\"#!/api/Ext.dom.Layer-cfg-hideMode\" rel=\"Ext.dom.Layer-cfg-hideMode\" class=\"docClass\">hideMode</a>: 'asclass'</code></p>\n"},"zindex":{"!type":"number","!doc":"<p>Starting z-index.</p>\n"},"deprecated":{},"localXYNames":{},"afterFx":{"!type":"fn() -> !this"},"beforeAction":{"!type":"fn() -> !this"},"beforeFx":{"!type":"fn() -> !this"},"beginUpdate":{"!type":"fn() -> !this"},"constrainXY":{"!type":"fn() -> ?"},"createCB":{"!type":"fn(callback: ?) -> !this"},"destroy":{"!type":"fn() -> !this"},"disableShadow":{"!type":"fn() -> !this"},"enableShadow":{"!type":"fn(show: ?) -> !this"},"endUpdate":{"!type":"fn() -> !this"},"getConstrainOffset":{"!type":"fn() -> !this"},"getZIndex":{"!type":"fn() -> !this"},"hideUnders":{"!type":"fn() -> !this"},"onOpacitySet":{"!type":"fn(opacity: ?) -> !this"},"setHeight":{"!type":"fn(h: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> !this","!doc":"<p>overridden Element method</p>\n"},"setLeft":{"!type":"fn(left: ?) -> !this","!doc":"<p>overridden Element method</p>\n"},"setLeftTop":{"!type":"fn(left: ?, top: ?) -> !this"},"setLocalX":{"!type":"fn() -> !this"},"setLocalXY":{"!type":"fn() -> !this"},"setLocalY":{"!type":"fn() -> !this"},"setSize":{"!type":"fn(w: ?, h: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> !this","!doc":"<p>overridden Element method</p>\n"},"setTop":{"!type":"fn(top: ?) -> !this"},"setVisible":{"!type":"fn(visible: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> !this","!doc":"<p>overridden Element method</p>\n"},"setWidth":{"!type":"fn(w: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> !this","!doc":"<p>overridden Element method</p>\n"},"setX":{"!type":"fn(x: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> ?","!doc":"<p>overridden Element method</p>\n"},"setXY":{"!type":"fn(xy: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> !this"},"setY":{"!type":"fn(y: ?, animate: ?, duration: ?, callback: ?, easing: ?) -> ?","!doc":"<p>overridden Element method</p>\n"},"setZIndex":{"!type":"fn(zindex: ?) -> ?","!doc":"<p>Sets the z-index of this layer and adjusts shadow z-index. The layer\nz-index is automatically incremented depending upon the presence of a\nshadow in so that it always shows above the shadow.</p>\n"},"sync":{"!type":"fn(doShow: ?) -> !this","!doc":"<p>Synchronize this Layer's associated elements and shadow.</p>\n\n<p>This code can execute repeatedly in milliseconds,\neg: dragging a Component configured liveDrag: true, or which has no ghost method\nso code size was sacrificed for efficiency (e.g. no getBox/setBox, no XY calls)</p>\n"}}}},"Editor":{"!doc":"<p>The Editor class is used to provide inline editing for elements on the page. The editor\nis backed by a <a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Ext.form.field.Field</a> that will be displayed to edit the underlying content.\nThe editor is a floating Component, when the editor is shown it is automatically aligned to\ndisplay over the top of the bound element it is editing. The Editor contains several options\nfor how to handle key presses:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.Editor-cfg-completeOnEnter\" rel=\"Ext.Editor-cfg-completeOnEnter\" class=\"docClass\">completeOnEnter</a></li>\n<li><a href=\"#!/api/Ext.Editor-cfg-cancelOnEsc\" rel=\"Ext.Editor-cfg-cancelOnEsc\" class=\"docClass\">cancelOnEsc</a></li>\n<li><a href=\"#!/api/Ext.Editor-cfg-swallowKeys\" rel=\"Ext.Editor-cfg-swallowKeys\" class=\"docClass\">swallowKeys</a></li>\n</ul>\n\n\n<p>It also has options for how to use the value once the editor has been activated:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.Editor-cfg-revertInvalid\" rel=\"Ext.Editor-cfg-revertInvalid\" class=\"docClass\">revertInvalid</a></li>\n<li><a href=\"#!/api/Ext.Editor-cfg-ignoreNoChange\" rel=\"Ext.Editor-cfg-ignoreNoChange\" class=\"docClass\">ignoreNoChange</a></li>\n<li><a href=\"#!/api/Ext.Editor-cfg-updateEl\" rel=\"Ext.Editor-cfg-updateEl\" class=\"docClass\">updateEl</a></li>\n</ul>\n\n\n<p>Sample usage:</p>\n\n<pre><code>var editor = new <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a>({\n    updateEl: true, // update the innerHTML of the bound element when editing completes\n    field: {\n        xtype: 'textfield'\n    }\n});\nvar el = Ext.get('my-text'); // The element to 'edit'\neditor.startEdit(el); // The value of the field will be taken as the innerHTML of the element.\n</code></pre>\n\n<p><p><img src=\"\" alt=\"Ext.Editor component\" width=\"\" height=\"\"></p></p>\n","!type":"fn(config: ?)","prototype":{"alignment":{"!type":"string","!doc":"<p>The position to align to (see Ext.util.Positionable.alignTo for more details).</p>\n"},"allowBlur":{"!type":"bool","!doc":"<p>True to <a href=\"#!/api/Ext.Editor-method-completeEdit\" rel=\"Ext.Editor-method-completeEdit\" class=\"docClass\">complete the editing process</a> if in edit mode when the\nfield is blurred.</p>\n"},"autoSize":{"!doc":"<p>True for the editor to automatically adopt the size of the underlying field. Otherwise, an object\ncan be passed to indicate where to get each dimension. The available properties are 'boundEl' and\n'field'. If a dimension is not specified, it will use the underlying height/width specified on\nthe editor object.\nExamples:</p>\n\n<pre><code>autoSize: true // The editor will be sized to the height/width of the field\n\nheight: 21,\nautoSize: {\n    width: 'boundEl' // The width will be determined by the width of the boundEl, the height from the editor (21)\n}\n\nautoSize: {\n    width: 'field', // Width from the field\n    height: 'boundEl' // Height from the boundEl\n}\n</code></pre>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"cancelOnEsc":{"!type":"bool","!doc":"<p>True to cancel the edit when the escape key is pressed.</p>\n"},"completeOnEnter":{"!type":"bool","!doc":"<p>True to complete the edit when the enter key is pressed.</p>\n"},"constrain":{"!type":"bool","!doc":"<p>True to constrain the editor to the viewport</p>\n"},"field":{"!doc":"<p>The Field object (or descendant) or config object for field</p>\n"},"focusOnToFront":{"!type":"bool","!doc":"<p>Do not participate in the ZIndexManager's focus switching operations.\nWhen an editor is hidden, the ZIndexManager will not automatically activate\nthe last visible floater on the stack.</p>\n"},"hidden":{"!type":"bool","!doc":"<p>private overrides</p>\n"},"hideEl":{"!type":"bool","!doc":"<p>False to keep the bound element visible while the editor is displayed</p>\n"},"ignoreNoChange":{"!type":"bool","!doc":"<p>True to skip the edit completion process (no save, no events fired) if the user completes an edit and\nthe value has not changed.  Applies only to string values - edits for other data types\nwill never be ignored.</p>\n"},"layout":{"!doc":"<p><strong>Important</strong>: In order for child items to be correctly sized and\npositioned, typically a layout manager <strong>must</strong> be specified through\nthe <code>layout</code> configuration option.</p>\n\n<p>The sizing and positioning of child <a href=\"#!/api/Ext.Editor-cfg-items\" rel=\"Ext.Editor-cfg-items\" class=\"docClass\">items</a> is the responsibility of\nthe Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p>\n\n<p>If the layout configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).</p>\n\n<p><strong>layout</strong> may be specified as either as an Object or as a String:</p>\n\n<h2>Specify as an Object</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: {\n    type: 'vbox',\n    align: 'left'\n}\n</code></pre>\n\n<ul>\n<li><p><strong>type</strong></p>\n\n<p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a> will be created and used.</p>\n\n<p>Valid layout <code>type</code> values are listed in <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>.</p></li>\n<li><p>Layout specific configuration properties</p>\n\n<p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p></li>\n</ul>\n\n\n<h2>Specify as a String</h2>\n\n<p>Example usage:</p>\n\n<pre><code>layout: 'vbox'\n</code></pre>\n\n<ul>\n<li><p><strong>layout</strong></p>\n\n<p>The layout <code>type</code> to be used for this container (see <a href=\"#!/api/Ext.enums.Layout\" rel=\"Ext.enums.Layout\" class=\"docClass\">Ext.enums.Layout</a>\nfor list of valid values).</p>\n\n<p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p></li>\n</ul>\n\n\n<h2>Configuring the default layout type</h2>\n\n<p>If a certain Container class has a default layout (For example a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>\nwith a default <code>Box</code> layout), then to simply configure the default layout,\nuse an object, but without the <code>type</code> property:</p>\n\n<pre><code>xtype: 'toolbar',\nlayout: {\n    pack: 'center'\n}\n</code></pre>\n\n<p>@cmd-auto-dependency { aliasPrefix : \"layout.\" }</p>\n"},"offsets":{"!doc":"<p>The offsets to use when aligning (see Ext.util.Positionable.alignTo for more details.</p>\n"},"parentEl":{"!doc":"<p>An element to render to.</p>\n"},"revertInvalid":{"!type":"bool","!doc":"<p>True to automatically revert the field value and cancel the edit when the user completes an edit and the field\nvalidation fails</p>\n"},"shadow":{"!doc":"<p>\"sides\" for sides/bottom only, \"frame\" for 4-way shadow, and \"drop\" for bottom-right shadow.</p>\n"},"swallowKeys":{"!type":"bool","!doc":"<p>Handle the keydown/keypress events so they don't propagate</p>\n"},"updateEl":{"!type":"bool","!doc":"<p>True to update the innerHTML of the bound element when the update completes</p>\n"},"value":{"!doc":"<p>The data value of the underlying field</p>\n"},"afterRender":{"!type":"fn(ct: ?, position: ?) -> !this","!doc":"<p>private</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"cancelEdit":{"!type":"fn(remainVisible?: ?) -> !this","!doc":"<p>Cancels the editing process and hides the editor without persisting any changes.  The field value will be\nreverted to the original starting value.</p>\n"},"completeEdit":{"!type":"fn(remainVisible?: ?) -> !this","!doc":"<p>Ends the editing process, persists the changed value to the underlying field, and hides the editor.</p>\n"},"getValue":{"!type":"fn() -> ?","!doc":"<p>Gets the data value of the editor</p>\n"},"onEditComplete":{"!type":"fn(remainVisible: ?) -> !this","!doc":"<p>private</p>\n"},"onFieldAutosize":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"onFieldBlur":{"!type":"fn(field: ?, e: ?) -> !this","!doc":"<p>private</p>\n"},"onHide":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"onShow":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"onSpecialKey":{"!type":"fn(field: ?, event: ?) -> !this","!doc":"<p>private</p>\n"},"realign":{"!type":"fn(autoSize?: ?) -> !this","!doc":"<p>Realigns the editor to the bound field based on the current alignment config value.</p>\n"},"setValue":{"!type":"fn(value: ?) -> !this","!doc":"<p>Sets the data value of the editor</p>\n"},"startEdit":{"!type":"fn(el: ?, value?: ?) -> !this","!doc":"<p>Starts the editing process and shows the editor.</p>\n"},"beforecomplete":{"!type":"fn(this: ?, value: ?, startValue: ?, eOpts: ?)","!doc":"<p>Fires after a change has been made to the field, but before the change is reflected in the underlying\nfield.  Saving the change to the field can be canceled by returning false from the handler of this event.\nNote that if the value has not changed and ignoreNoChange = true, the editing will still end but this\nevent will not fire since no edit actually occurred.</p>\n"},"beforestartedit":{"!type":"fn(this: ?, boundEl: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when editing is initiated, but before the value changes.  Editing can be canceled by returning\nfalse from the handler of this event.</p>\n"},"canceledit":{"!type":"fn(this: ?, value: ?, startValue: ?, eOpts: ?)","!doc":"<p>Fires after editing has been canceled and the editor's value has been reset.</p>\n"},"complete":{"!type":"fn(this: ?, value: ?, startValue: ?, eOpts: ?)","!doc":"<p>Fires after editing is complete and any changed value has been written to the underlying field.</p>\n"},"specialkey":{"!type":"fn(this: ?, field: ?, event: ?, eOpts: ?)","!doc":"<p>Fires when any key related to navigation (arrows, tab, enter, esc, etc.) is pressed.  You can check\nExt.event.Event.getKey to determine which key was pressed.</p>\n"},"startedit":{"!type":"fn(this: ?, boundEl: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when this editor is displayed</p>\n"}}},"enums":{"Feature":{"!doc":"<p>Enumeration of all ftypes.</p>\n","prototype":{"abstractsummary":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.AbstractSummary\" rel=\"Ext.grid.feature.AbstractSummary\" class=\"docClass\">Ext.grid.feature.AbstractSummary</a>.</p>\n"},"feature":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.Feature\" rel=\"Ext.grid.feature.Feature\" class=\"docClass\">Ext.grid.feature.Feature</a>.</p>\n"},"grouping":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.Grouping\" rel=\"Ext.grid.feature.Grouping\" class=\"docClass\">Ext.grid.feature.Grouping</a>.</p>\n"},"groupingsummary":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.GroupingSummary\" rel=\"Ext.grid.feature.GroupingSummary\" class=\"docClass\">Ext.grid.feature.GroupingSummary</a>.</p>\n"},"rowbody":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.RowBody\" rel=\"Ext.grid.feature.RowBody\" class=\"docClass\">Ext.grid.feature.RowBody</a>.</p>\n"},"summary":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.feature.Summary\" rel=\"Ext.grid.feature.Summary\" class=\"docClass\">Ext.grid.feature.Summary</a>.</p>\n"}}},"Layout":{"!doc":"<p>Enumeration of all layout types.</p>\n","prototype":{"absolute":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Absolute\" rel=\"Ext.layout.container.Absolute\" class=\"docClass\">Ext.layout.container.Absolute</a>.</p>\n"},"accordion":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Accordion\" rel=\"Ext.layout.container.Accordion\" class=\"docClass\">Ext.layout.container.Accordion</a>.</p>\n"},"anchor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Anchor\" rel=\"Ext.layout.container.Anchor\" class=\"docClass\">Ext.layout.container.Anchor</a>.</p>\n"},"auto":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a>.</p>\n"},"autocomponent":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.Auto\" rel=\"Ext.layout.component.Auto\" class=\"docClass\">Ext.layout.component.Auto</a>.</p>\n"},"autocontainer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">Ext.layout.container.Auto</a>.</p>\n"},"body":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.Body\" rel=\"Ext.layout.component.Body\" class=\"docClass\">Ext.layout.component.Body</a>.</p>\n"},"border":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a>.</p>\n"},"boundlist":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.BoundList\" rel=\"Ext.layout.component.BoundList\" class=\"docClass\">Ext.layout.component.BoundList</a>.</p>\n"},"box":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Box\" rel=\"Ext.layout.container.Box\" class=\"docClass\">Ext.layout.container.Box</a>.</p>\n"},"card":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Card\" rel=\"Ext.layout.container.Card\" class=\"docClass\">Ext.layout.container.Card</a>.</p>\n"},"center":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Center\" rel=\"Ext.layout.container.Center\" class=\"docClass\">Ext.layout.container.Center</a>.</p>\n"},"checkboxgroup":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.CheckboxGroup\" rel=\"Ext.layout.container.CheckboxGroup\" class=\"docClass\">Ext.layout.container.CheckboxGroup</a>.</p>\n"},"column":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Column\" rel=\"Ext.layout.container.Column\" class=\"docClass\">Ext.layout.container.Column</a>.</p>\n"},"columncomponent":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.ColumnComponentLayout\" rel=\"Ext.grid.ColumnComponentLayout\" class=\"docClass\">Ext.grid.ColumnComponentLayout</a>.</p>\n"},"container":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">Ext.layout.container.Container</a>.</p>\n"},"dock":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>.</p>\n"},"editor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Editor\" rel=\"Ext.layout.container.Editor\" class=\"docClass\">Ext.layout.container.Editor</a>.</p>\n"},"fieldcontainer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.field.FieldContainer\" rel=\"Ext.layout.component.field.FieldContainer\" class=\"docClass\">Ext.layout.component.field.FieldContainer</a>.</p>\n"},"fieldset":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.FieldSet\" rel=\"Ext.layout.component.FieldSet\" class=\"docClass\">Ext.layout.component.FieldSet</a>.</p>\n"},"fit":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Fit\" rel=\"Ext.layout.container.Fit\" class=\"docClass\">Ext.layout.container.Fit</a>.</p>\n"},"form":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Form\" rel=\"Ext.layout.container.Form\" class=\"docClass\">Ext.layout.container.Form</a>.</p>\n"},"gridcolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.ColumnLayout\" rel=\"Ext.grid.ColumnLayout\" class=\"docClass\">Ext.grid.ColumnLayout</a>.</p>\n"},"hbox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>.</p>\n"},"htmleditor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.field.HtmlEditor\" rel=\"Ext.layout.component.field.HtmlEditor\" class=\"docClass\">Ext.layout.component.field.HtmlEditor</a>.</p>\n"},"progressbar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.component.ProgressBar\" rel=\"Ext.layout.component.ProgressBar\" class=\"docClass\">Ext.layout.component.ProgressBar</a>.</p>\n"},"split-column":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.SplitColumn\" rel=\"Ext.layout.container.SplitColumn\" class=\"docClass\">Ext.layout.container.SplitColumn</a>.</p>\n"},"table":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Table\" rel=\"Ext.layout.container.Table\" class=\"docClass\">Ext.layout.container.Table</a>.</p>\n"},"tableview":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.TableLayout\" rel=\"Ext.view.TableLayout\" class=\"docClass\">Ext.view.TableLayout</a>.</p>\n"},"ux.center":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.Center\" rel=\"Ext.layout.container.Center\" class=\"docClass\">Ext.layout.container.Center</a>.</p>\n"},"vbox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>.</p>\n"}}},"Plugin":{"!doc":"<p>Enumeration of all ptypes.</p>\n","prototype":{"bufferedrenderer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer\" rel=\"Ext.grid.plugin.BufferedRenderer\" class=\"docClass\">Ext.grid.plugin.BufferedRenderer</a>.</p>\n"},"cellediting":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.CellEditing\" rel=\"Ext.grid.plugin.CellEditing\" class=\"docClass\">Ext.grid.plugin.CellEditing</a>.</p>\n"},"gridfilters":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.filters.Filters\" rel=\"Ext.grid.filters.Filters\" class=\"docClass\">Ext.grid.filters.Filters</a>.</p>\n"},"gridheaderreorderer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.HeaderReorderer\" rel=\"Ext.grid.plugin.HeaderReorderer\" class=\"docClass\">Ext.grid.plugin.HeaderReorderer</a>.</p>\n"},"gridheaderresizer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.HeaderResizer\" rel=\"Ext.grid.plugin.HeaderResizer\" class=\"docClass\">Ext.grid.plugin.HeaderResizer</a>.</p>\n"},"gridviewdragdrop":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.DragDrop\" rel=\"Ext.grid.plugin.DragDrop\" class=\"docClass\">Ext.grid.plugin.DragDrop</a>.</p>\n"},"responsive":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.plugin.Responsive\" rel=\"Ext.plugin.Responsive\" class=\"docClass\">Ext.plugin.Responsive</a>.</p>\n"},"rowediting":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.RowEditing\" rel=\"Ext.grid.plugin.RowEditing\" class=\"docClass\">Ext.grid.plugin.RowEditing</a>.</p>\n"},"rowexpander":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.plugin.RowExpander\" rel=\"Ext.grid.plugin.RowExpander\" class=\"docClass\">Ext.grid.plugin.RowExpander</a>.</p>\n"},"treeviewdragdrop":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tree.plugin.TreeViewDragDrop\" rel=\"Ext.tree.plugin.TreeViewDragDrop\" class=\"docClass\">Ext.tree.plugin.TreeViewDragDrop</a>.</p>\n"},"viewport":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.plugin.Viewport\" rel=\"Ext.plugin.Viewport\" class=\"docClass\">Ext.plugin.Viewport</a>.</p>\n"}}},"Widget":{"!doc":"<p>Enumeration of all xtypes.</p>\n","prototype":{"actioncolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Action\" rel=\"Ext.grid.column.Action\" class=\"docClass\">Ext.grid.column.Action</a>.</p>\n"},"booleancolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Boolean\" rel=\"Ext.grid.column.Boolean\" class=\"docClass\">Ext.grid.column.Boolean</a>.</p>\n"},"bordersplitter":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.resizer.BorderSplitter\" rel=\"Ext.resizer.BorderSplitter\" class=\"docClass\">Ext.resizer.BorderSplitter</a>.</p>\n"},"boundlist":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">Ext.view.BoundList</a>.</p>\n"},"box":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"breadcrumb":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Breadcrumb\" rel=\"Ext.toolbar.Breadcrumb\" class=\"docClass\">Ext.toolbar.Breadcrumb</a>.</p>\n"},"button":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>.</p>\n"},"buttongroup":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.container.ButtonGroup\" rel=\"Ext.container.ButtonGroup\" class=\"docClass\">Ext.container.ButtonGroup</a>.</p>\n"},"checkbox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">Ext.form.field.Checkbox</a>.</p>\n"},"checkboxfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">Ext.form.field.Checkbox</a>.</p>\n"},"checkboxgroup":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.CheckboxGroup\" rel=\"Ext.form.CheckboxGroup\" class=\"docClass\">Ext.form.CheckboxGroup</a>.</p>\n"},"checkcolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Check\" rel=\"Ext.grid.column.Check\" class=\"docClass\">Ext.grid.column.Check</a>.</p>\n"},"colormenu":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.ColorPicker\" rel=\"Ext.menu.ColorPicker\" class=\"docClass\">Ext.menu.ColorPicker</a>.</p>\n"},"colorpicker":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.picker.Color\" rel=\"Ext.picker.Color\" class=\"docClass\">Ext.picker.Color</a>.</p>\n"},"columnsplitter":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.layout.container.ColumnSplitter\" rel=\"Ext.layout.container.ColumnSplitter\" class=\"docClass\">Ext.layout.container.ColumnSplitter</a>.</p>\n"},"combo":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.ComboBox\" rel=\"Ext.form.field.ComboBox\" class=\"docClass\">Ext.form.field.ComboBox</a>.</p>\n"},"combobox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.ComboBox\" rel=\"Ext.form.field.ComboBox\" class=\"docClass\">Ext.form.field.ComboBox</a>.</p>\n"},"component":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"container":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>.</p>\n"},"cycle":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.button.Cycle\" rel=\"Ext.button.Cycle\" class=\"docClass\">Ext.button.Cycle</a>.</p>\n"},"dashboard":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.dashboard.Dashboard\" rel=\"Ext.dashboard.Dashboard\" class=\"docClass\">Ext.dashboard.Dashboard</a>.</p>\n"},"dashboard-column":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.dashboard.Column\" rel=\"Ext.dashboard.Column\" class=\"docClass\">Ext.dashboard.Column</a>.</p>\n"},"dashboard-panel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.dashboard.Panel\" rel=\"Ext.dashboard.Panel\" class=\"docClass\">Ext.dashboard.Panel</a>.</p>\n"},"dataview":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a>.</p>\n"},"datecolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Date\" rel=\"Ext.grid.column.Date\" class=\"docClass\">Ext.grid.column.Date</a>.</p>\n"},"datefield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Date\" rel=\"Ext.form.field.Date\" class=\"docClass\">Ext.form.field.Date</a>.</p>\n"},"datemenu":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.DatePicker\" rel=\"Ext.menu.DatePicker\" class=\"docClass\">Ext.menu.DatePicker</a>.</p>\n"},"datepicker":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.picker.Date\" rel=\"Ext.picker.Date\" class=\"docClass\">Ext.picker.Date</a>.</p>\n"},"displayfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Display\" rel=\"Ext.form.field.Display\" class=\"docClass\">Ext.form.field.Display</a>.</p>\n"},"editor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.Editor\" rel=\"Ext.Editor\" class=\"docClass\">Ext.Editor</a>.</p>\n"},"field":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>.</p>\n"},"fieldcontainer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.FieldContainer\" rel=\"Ext.form.FieldContainer\" class=\"docClass\">Ext.form.FieldContainer</a>.</p>\n"},"fieldset":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.FieldSet\" rel=\"Ext.form.FieldSet\" class=\"docClass\">Ext.form.FieldSet</a>.</p>\n"},"filebutton":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.FileButton\" rel=\"Ext.form.field.FileButton\" class=\"docClass\">Ext.form.field.FileButton</a>.</p>\n"},"filefield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.File\" rel=\"Ext.form.field.File\" class=\"docClass\">Ext.form.field.File</a>.</p>\n"},"fileuploadfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.File\" rel=\"Ext.form.field.File\" class=\"docClass\">Ext.form.field.File</a>.</p>\n"},"flash":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.flash.Component\" rel=\"Ext.flash.Component\" class=\"docClass\">Ext.flash.Component</a>.</p>\n"},"form":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>.</p>\n"},"grid":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>.</p>\n"},"gridcolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">Ext.grid.column.Column</a>.</p>\n"},"gridpanel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>.</p>\n"},"gridview":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.View\" rel=\"Ext.grid.View\" class=\"docClass\">Ext.grid.View</a>.</p>\n"},"header":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.panel.Header\" rel=\"Ext.panel.Header\" class=\"docClass\">Ext.panel.Header</a>.</p>\n"},"headercontainer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.header.Container\" rel=\"Ext.grid.header.Container\" class=\"docClass\">Ext.grid.header.Container</a>.</p>\n"},"hidden":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Hidden\" rel=\"Ext.form.field.Hidden\" class=\"docClass\">Ext.form.field.Hidden</a>.</p>\n"},"hiddenfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Hidden\" rel=\"Ext.form.field.Hidden\" class=\"docClass\">Ext.form.field.Hidden</a>.</p>\n"},"htmleditor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.HtmlEditor\" rel=\"Ext.form.field.HtmlEditor\" class=\"docClass\">Ext.form.field.HtmlEditor</a>.</p>\n"},"image":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.Img\" rel=\"Ext.Img\" class=\"docClass\">Ext.Img</a>.</p>\n"},"imagecomponent":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.Img\" rel=\"Ext.Img\" class=\"docClass\">Ext.Img</a>.</p>\n"},"label":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.Label\" rel=\"Ext.form.Label\" class=\"docClass\">Ext.form.Label</a>.</p>\n"},"loadmask":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.LoadMask\" rel=\"Ext.LoadMask\" class=\"docClass\">Ext.LoadMask</a>.</p>\n"},"menu":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>.</p>\n"},"menucheckitem":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a>.</p>\n"},"menuitem":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">Ext.menu.Item</a>.</p>\n"},"menuseparator":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.menu.Separator\" rel=\"Ext.menu.Separator\" class=\"docClass\">Ext.menu.Separator</a>.</p>\n"},"messagebox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.window.MessageBox\" rel=\"Ext.window.MessageBox\" class=\"docClass\">Ext.window.MessageBox</a>.</p>\n"},"monthpicker":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.picker.Month\" rel=\"Ext.picker.Month\" class=\"docClass\">Ext.picker.Month</a>.</p>\n"},"multiselector":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.MultiSelector\" rel=\"Ext.view.MultiSelector\" class=\"docClass\">Ext.view.MultiSelector</a>.</p>\n"},"multiselector-search":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.MultiSelectorSearch\" rel=\"Ext.view.MultiSelectorSearch\" class=\"docClass\">Ext.view.MultiSelectorSearch</a>.</p>\n"},"multislider":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.slider.Multi\" rel=\"Ext.slider.Multi\" class=\"docClass\">Ext.slider.Multi</a>.</p>\n"},"numbercolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Number\" rel=\"Ext.grid.column.Number\" class=\"docClass\">Ext.grid.column.Number</a>.</p>\n"},"numberfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>.</p>\n"},"pagingtoolbar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Paging\" rel=\"Ext.toolbar.Paging\" class=\"docClass\">Ext.toolbar.Paging</a>.</p>\n"},"panel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>.</p>\n"},"pickerfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Picker\" rel=\"Ext.form.field.Picker\" class=\"docClass\">Ext.form.field.Picker</a>.</p>\n"},"progressbar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.ProgressBar\" rel=\"Ext.ProgressBar\" class=\"docClass\">Ext.ProgressBar</a>.</p>\n"},"progressbarwidget":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.ProgressBarWidget\" rel=\"Ext.ProgressBarWidget\" class=\"docClass\">Ext.ProgressBarWidget</a>.</p>\n"},"propertygrid":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.property.Grid\" rel=\"Ext.grid.property.Grid\" class=\"docClass\">Ext.grid.property.Grid</a>.</p>\n"},"quicktip":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tip.QuickTip\" rel=\"Ext.tip.QuickTip\" class=\"docClass\">Ext.tip.QuickTip</a>.</p>\n"},"radio":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Radio\" rel=\"Ext.form.field.Radio\" class=\"docClass\">Ext.form.field.Radio</a>.</p>\n"},"radiofield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Radio\" rel=\"Ext.form.field.Radio\" class=\"docClass\">Ext.form.field.Radio</a>.</p>\n"},"radiogroup":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.RadioGroup\" rel=\"Ext.form.RadioGroup\" class=\"docClass\">Ext.form.RadioGroup</a>.</p>\n"},"roweditor":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.RowEditor\" rel=\"Ext.grid.RowEditor\" class=\"docClass\">Ext.grid.RowEditor</a>.</p>\n"},"roweditorbuttons":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.RowEditorButtons\" rel=\"Ext.grid.RowEditorButtons\" class=\"docClass\">Ext.grid.RowEditorButtons</a>.</p>\n"},"rownumberer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.RowNumberer\" rel=\"Ext.grid.column.RowNumberer\" class=\"docClass\">Ext.grid.column.RowNumberer</a>.</p>\n"},"segmentedbutton":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.button.Segmented\" rel=\"Ext.button.Segmented\" class=\"docClass\">Ext.button.Segmented</a>.</p>\n"},"slider":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.slider.Single\" rel=\"Ext.slider.Single\" class=\"docClass\">Ext.slider.Single</a>.</p>\n"},"sliderfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.slider.Single\" rel=\"Ext.slider.Single\" class=\"docClass\">Ext.slider.Single</a>.</p>\n"},"slidertip":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.slider.Tip\" rel=\"Ext.slider.Tip\" class=\"docClass\">Ext.slider.Tip</a>.</p>\n"},"sliderwidget":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.slider.Widget\" rel=\"Ext.slider.Widget\" class=\"docClass\">Ext.slider.Widget</a>.</p>\n"},"sparklinebar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Bar\" rel=\"Ext.sparkline.Bar\" class=\"docClass\">Ext.sparkline.Bar</a>.</p>\n"},"sparklinebox":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Box\" rel=\"Ext.sparkline.Box\" class=\"docClass\">Ext.sparkline.Box</a>.</p>\n"},"sparklinebullet":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Bullet\" rel=\"Ext.sparkline.Bullet\" class=\"docClass\">Ext.sparkline.Bullet</a>.</p>\n"},"sparklinediscrete":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Discrete\" rel=\"Ext.sparkline.Discrete\" class=\"docClass\">Ext.sparkline.Discrete</a>.</p>\n"},"sparklineline":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Line\" rel=\"Ext.sparkline.Line\" class=\"docClass\">Ext.sparkline.Line</a>.</p>\n"},"sparklinepie":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.Pie\" rel=\"Ext.sparkline.Pie\" class=\"docClass\">Ext.sparkline.Pie</a>.</p>\n"},"sparklinetristate":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.sparkline.TriState\" rel=\"Ext.sparkline.TriState\" class=\"docClass\">Ext.sparkline.TriState</a>.</p>\n"},"spinnerfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Spinner\" rel=\"Ext.form.field.Spinner\" class=\"docClass\">Ext.form.field.Spinner</a>.</p>\n"},"splitbutton":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>.</p>\n"},"splitter":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.resizer.Splitter\" rel=\"Ext.resizer.Splitter\" class=\"docClass\">Ext.resizer.Splitter</a>.</p>\n"},"tab":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tab.Tab\" rel=\"Ext.tab.Tab\" class=\"docClass\">Ext.tab.Tab</a>.</p>\n"},"tabbar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tab.Bar\" rel=\"Ext.tab.Bar\" class=\"docClass\">Ext.tab.Bar</a>.</p>\n"},"tablepanel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.panel.Table\" rel=\"Ext.panel.Table\" class=\"docClass\">Ext.panel.Table</a>.</p>\n"},"tableview":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.view.Table\" rel=\"Ext.view.Table\" class=\"docClass\">Ext.view.Table</a>.</p>\n"},"tabpanel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>.</p>\n"},"tagfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Tag\" rel=\"Ext.form.field.Tag\" class=\"docClass\">Ext.form.field.Tag</a>.</p>\n"},"tbfill":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Fill\" rel=\"Ext.toolbar.Fill\" class=\"docClass\">Ext.toolbar.Fill</a>.</p>\n"},"tbitem":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Item\" rel=\"Ext.toolbar.Item\" class=\"docClass\">Ext.toolbar.Item</a>.</p>\n"},"tbseparator":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Separator\" rel=\"Ext.toolbar.Separator\" class=\"docClass\">Ext.toolbar.Separator</a>.</p>\n"},"tbspacer":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Spacer\" rel=\"Ext.toolbar.Spacer\" class=\"docClass\">Ext.toolbar.Spacer</a>.</p>\n"},"tbtext":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.TextItem\" rel=\"Ext.toolbar.TextItem\" class=\"docClass\">Ext.toolbar.TextItem</a>.</p>\n"},"templatecolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Template\" rel=\"Ext.grid.column.Template\" class=\"docClass\">Ext.grid.column.Template</a>.</p>\n"},"textarea":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.TextArea\" rel=\"Ext.form.field.TextArea\" class=\"docClass\">Ext.form.field.TextArea</a>.</p>\n"},"textareafield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.TextArea\" rel=\"Ext.form.field.TextArea\" class=\"docClass\">Ext.form.field.TextArea</a>.</p>\n"},"textfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>.</p>\n"},"timefield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Time\" rel=\"Ext.form.field.Time\" class=\"docClass\">Ext.form.field.Time</a>.</p>\n"},"timepicker":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.picker.Time\" rel=\"Ext.picker.Time\" class=\"docClass\">Ext.picker.Time</a>.</p>\n"},"tip":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tip.Tip\" rel=\"Ext.tip.Tip\" class=\"docClass\">Ext.tip.Tip</a>.</p>\n"},"title":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.panel.Title\" rel=\"Ext.panel.Title\" class=\"docClass\">Ext.panel.Title</a>.</p>\n"},"toast":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.window.Toast\" rel=\"Ext.window.Toast\" class=\"docClass\">Ext.window.Toast</a>.</p>\n"},"tool":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.panel.Tool\" rel=\"Ext.panel.Tool\" class=\"docClass\">Ext.panel.Tool</a>.</p>\n"},"toolbar":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a>.</p>\n"},"tooltip":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tip.ToolTip\" rel=\"Ext.tip.ToolTip\" class=\"docClass\">Ext.tip.ToolTip</a>.</p>\n"},"treecolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tree.Column\" rel=\"Ext.tree.Column\" class=\"docClass\">Ext.tree.Column</a>.</p>\n"},"treepanel":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">Ext.tree.Panel</a>.</p>\n"},"treeview":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.tree.View\" rel=\"Ext.tree.View\" class=\"docClass\">Ext.tree.View</a>.</p>\n"},"trigger":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Trigger\" rel=\"Ext.form.field.Trigger\" class=\"docClass\">Ext.form.field.Trigger</a>.</p>\n"},"triggerfield":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.form.field.Trigger\" rel=\"Ext.form.field.Trigger\" class=\"docClass\">Ext.form.field.Trigger</a>.</p>\n"},"viewport":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>.</p>\n"},"widgetcolumn":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.grid.column.Widget\" rel=\"Ext.grid.column.Widget\" class=\"docClass\">Ext.grid.column.Widget</a>.</p>\n"},"window":{"!type":"string","!doc":"<p>Alias for <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>.</p>\n"}}}},"EventManager":{"!doc":"<p>Registers event handlers on DOM elements.</p>\n\n<p>This class is deprecated.  Please use the Ext.dom.Element api to atach listeners to\nDOM Elements.  For example:</p>\n\n<pre><code>var element = Ext.get('myId');\n\nelement.on('click', function(e) {\n    // event handling logic here\n});\n</code></pre>\n","mouseEnterRe":{},"mouseLeaveRe":{},"addListener":{"!type":"fn(el: ?, eventName: ?, handler?: ?, scope?: ?, options?: ?) -> !this","!doc":"<p>Appends an event handler to an element.  The shorthand version <a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is equivalent.\nTypically you will use Ext.dom.Element.addListener directly on an Element in favor of\ncalling this version.</p>\n\n<p><a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is an alias for <a href=\"#!/api/Ext.EventManager-method-addListener\" rel=\"Ext.EventManager-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"},"getId":{"!type":"fn(element: ?) -> string","!doc":"<p>Get the id of the element. If one has not been assigned, automatically assign it.</p>\n"},"getPageX":{"!type":"fn(event: ?) -> number","!doc":"<p>Gets the x coordinate from the event</p>\n"},"getPageXY":{"!type":"fn(event: ?) -> ?","!doc":"<p>Gets the x &amp; y coordinate from the event</p>\n"},"getPageY":{"!type":"fn(event: ?) -> number","!doc":"<p>Gets the y coordinate from the event</p>\n"},"getRelatedTarget":{"!type":"fn(event: ?) -> ?","!doc":"<p>Gets the related target from the event.</p>\n"},"getTarget":{"!type":"fn(event: ?) -> ?","!doc":"<p>Gets the target of the event.</p>\n"},"on":{"!type":"fn(el: ?, eventName: ?, handler?: ?, scope?: ?, options?: ?) -> !this","!doc":"<p>Appends an event handler to an element.  The shorthand version <a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is equivalent.\nTypically you will use Ext.dom.Element.addListener directly on an Element in favor of\ncalling this version.</p>\n\n<p><a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is an alias for <a href=\"#!/api/Ext.EventManager-method-addListener\" rel=\"Ext.EventManager-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"},"onWindowResize":{"!type":"fn(fn: ?, scope: ?, options?: ?) -> !this","!doc":"<p>Adds a listener to be notified when the browser window is resized and provides resize event buffering (100 milliseconds),\npasses new viewport width and height to handlers.</p>\n"},"onWindowUnload":{"!type":"fn(fn: ?, scope: ?, options: ?) -> !this","!doc":"<p>Adds a listener to be notified when the browser window is unloaded.</p>\n"},"preventDefault":{"!type":"fn(event: ?) -> !this","!doc":"<p>Prevents the browsers default handling of the event.</p>\n"},"purgeElement":{"!type":"fn(el: ?, eventName?: ?) -> !this","!doc":"<p>Recursively removes all previous added listeners from an element and its children.\nTypically you will use Ext.dom.Element.clearListeners directly on an Element\nin favor of calling this method.</p>\n"},"removeAll":{"!type":"fn(el: ?) -> !this","!doc":"<p>Removes all event handers from an element.  Typically you will use Ext.dom.Element.clearListeners directly on an Element in favor of calling this method.</p>\n"},"removeListener":{"!type":"fn(el: ?, eventName: ?, fn: ?, scope: ?) -> !this","!doc":"<p>Removes an event handler from an element.  The shorthand version <a href=\"#!/api/Ext.EventManager-method-un\" rel=\"Ext.EventManager-method-un\" class=\"docClass\">un</a> is equivalent.  Typically\nyou will use Ext.dom.Element.removeListener directly on an Element in favor of calling this version.</p>\n\n<p><a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is an alias for <a href=\"#!/api/Ext.EventManager-method-addListener\" rel=\"Ext.EventManager-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"},"removeResizeListener":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Removes the passed window resize listener.</p>\n"},"removeUnloadListener":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Removes the passed window unload listener.</p>\n"},"resolveTextNode":{"!type":"fn(node: ?) -> ?","!doc":"<p>Resolve any text nodes accounting for browser differences.</p>\n"},"stopEvent":{"!type":"fn(event: ?) -> !this","!doc":"<p>Stop the event (preventDefault and stopPropagation)</p>\n"},"stopPropagation":{"!type":"fn(event: ?) -> !this","!doc":"<p>Cancels bubbling of the event.</p>\n"},"un":{"!type":"fn(el: ?, eventName: ?, fn: ?, scope: ?) -> !this","!doc":"<p>Removes an event handler from an element.  The shorthand version <a href=\"#!/api/Ext.EventManager-method-un\" rel=\"Ext.EventManager-method-un\" class=\"docClass\">un</a> is equivalent.  Typically\nyou will use Ext.dom.Element.removeListener directly on an Element in favor of calling this version.</p>\n\n<p><a href=\"#!/api/Ext.EventManager-method-on\" rel=\"Ext.EventManager-method-on\" class=\"docClass\">on</a> is an alias for <a href=\"#!/api/Ext.EventManager-method-addListener\" rel=\"Ext.EventManager-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"}},"flash":{"Component":{"!doc":"<p>A simple Component for displaying an Adobe Flash SWF movie. The movie will be sized and can participate\nin layout like any other Component.</p>\n\n<p>This component requires the third-party SWFObject library version 2.2 or above. It is not included within\nthe ExtJS distribution, so you will have to include it into your page manually in order to use this component.\nThe SWFObject library can be downloaded from the <a href=\"http://code.google.com/p/swfobject\">SWFObject project page</a>\nand then simply import it into the head of your HTML document:</p>\n\n<pre><code>&lt;script type=\"text/javascript\" src=\"path/to/local/swfobject.js\"&gt;&lt;/script&gt;\n</code></pre>\n\n<h2>Configuration</h2>\n\n<p>This component allows several options for configuring how the target Flash movie is embedded. The most\nimportant is the required <a href=\"#!/api/Ext.flash.Component-cfg-url\" rel=\"Ext.flash.Component-cfg-url\" class=\"docClass\">url</a> which points to the location of the Flash movie to load. Other\nconfigurations include:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.flash.Component-cfg-backgroundColor\" rel=\"Ext.flash.Component-cfg-backgroundColor\" class=\"docClass\">backgroundColor</a></li>\n<li><a href=\"#!/api/Ext.flash.Component-cfg-wmode\" rel=\"Ext.flash.Component-cfg-wmode\" class=\"docClass\">wmode</a></li>\n<li><a href=\"#!/api/Ext.flash.Component-cfg-flashVars\" rel=\"Ext.flash.Component-cfg-flashVars\" class=\"docClass\">flashVars</a></li>\n<li><a href=\"#!/api/Ext.flash.Component-cfg-flashParams\" rel=\"Ext.flash.Component-cfg-flashParams\" class=\"docClass\">flashParams</a></li>\n<li><a href=\"#!/api/Ext.flash.Component-cfg-flashAttributes\" rel=\"Ext.flash.Component-cfg-flashAttributes\" class=\"docClass\">flashAttributes</a></li>\n</ul>\n\n\n<h2>Example usage:</h2>\n\n<pre><code>var win = Ext.widget('window', {\n    title: \"It's a tiger!\",\n    layout: 'fit',\n    width: 300,\n    height: 300,\n    x: 20,\n    y: 20,\n    resizable: true,\n    items: {\n        xtype: 'flash',\n        url: 'tiger.swf'\n    }\n});\nwin.show();\n</code></pre>\n\n<h2>Express Install</h2>\n\n<p>Adobe provides a tool called <a href=\"http://www.adobe.com/devnet/flashplayer/articles/express_install.html\">Express Install</a>\nthat offers users an easy way to upgrade their Flash player. If you wish to make use of this, you should set\nthe static EXPRESS_INSTALL_URL property to the location of your Express Install SWF file:</p>\n\n<pre><code><a href=\"#!/api/Ext.flash.Component-static-property-EXPRESS_INSTALL_URL\" rel=\"Ext.flash.Component-static-property-EXPRESS_INSTALL_URL\" class=\"docClass\">Ext.flash.Component.EXPRESS_INSTALL_URL</a> = 'path/to/local/expressInstall.swf';\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"backgroundColor":{"!type":"string","!doc":"<p>The background color of the SWF movie.</p>\n"},"expressInstall":{"!type":"bool","!doc":"<p>True to prompt the user to install flash if not installed. Note that this uses\n<a href=\"#!/api/Ext.flash.Component-static-property-EXPRESS_INSTALL_URL\" rel=\"Ext.flash.Component-static-property-EXPRESS_INSTALL_URL\" class=\"docClass\">Ext.FlashComponent.EXPRESS_INSTALL_URL</a>, which should be set to the local resource.</p>\n"},"flashAttributes":{"!doc":"<p>A set of key value pairs to be passed to the flash object as attributes.</p>\n"},"flashParams":{"!doc":"<p>A set of key value pairs to be passed to the flash object as parameters. Possible parameters can be found here:\nhttp://kb2.adobe.com/cps/127/tn_12701.html</p>\n"},"flashVars":{"!doc":"<p>A set of key value pairs to be passed to the flash object as flash variables.</p>\n"},"flashVersion":{"!type":"string","!doc":"<p>Indicates the version the flash content was published for.</p>\n"},"renderTpl":{"!doc":"<p>Have to create a placeholder div with the swfId, which SWFObject will replace with the object/embed element.</p>\n"},"swfHeight":{"!doc":"<p>The height of the embedded SWF movie inside the component.</p>\n\n<p>Defaults to \"100%\" so that the movie matches the height of the component.</p>\n"},"swfWidth":{"!doc":"<p>The width of the embedded SWF movie inside the component.</p>\n\n<p>Defaults to \"100%\" so that the movie matches the width of the component.</p>\n"},"url":{"!type":"string","!doc":"<p>The URL of the SWF file to include.</p>\n"},"wmode":{"!type":"string","!doc":"<p>The wmode of the flash object. This can be used to control layering.\nSet to 'transparent' to ignore the <a href=\"#!/api/Ext.flash.Component-cfg-backgroundColor\" rel=\"Ext.flash.Component-cfg-backgroundColor\" class=\"docClass\">backgroundColor</a> and make the background of the Flash\nmovie transparent.</p>\n"},"swf":{"!doc":"<p>A reference to the object or embed element into which the SWF file is loaded. Only\npopulated after the component is rendered and the SWF has been successfully embedded.</p>\n"},"EXPRESS_INSTALL_URL":{"!type":"string","!doc":"<p>The url for installing flash if it doesn't exist. This should be set to a local resource.\nSee <a href=\"http://get.adobe.com/flashplayer/\">http://get.adobe.com/flashplayer/</a> for details.</p>\n"},"afterRender":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior after rendering is complete. At this stage the Component's Element\nwill have been styled according to the configuration, will have had any configured CSS class\nnames added, and will be in the configured visibility and the configured enable state.</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"getSwfId":{"!type":"fn() -> !this","!doc":"<p>Retrieves the id of the SWF object/embed element.</p>\n"},"onFailure":{"!type":"fn() -> !this"},"onSuccess":{"!type":"fn() -> !this"},"swfCallback":{"!type":"fn(e: ?) -> !this","!doc":"<p>The callback method for handling an embedding success or failure by SWFObject</p>\n"},"failure":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fired when the Flash movie embedding fails</p>\n"},"success":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fired when the Flash movie has been successfully embedded</p>\n"}}}},"FocusManager":{"!doc":"<p>The FocusManager is responsible for globally:</p>\n\n<ol>\n<li>Managing component focus</li>\n<li>Providing basic keyboard navigation</li>\n<li>(optional) Provide a visual cue for focused components, in the form of a focus ring/frame.</li>\n</ol>\n\n\n<p>To activate the FocusManager, simply call <code><a href=\"#!/api/Ext.FocusManager-event-enable\" rel=\"Ext.FocusManager-event-enable\" class=\"docClass\">Ext.FocusManager.enable</a>();</code>. In turn, you may\ndeactivate the FocusManager by subsequently calling <code><a href=\"#!/api/Ext.FocusManager-event-disable\" rel=\"Ext.FocusManager-event-disable\" class=\"docClass\">Ext.FocusManager.disable</a>();</code>.  The\nFocusManager is disabled by default.</p>\n\n<p>To enable the optional focus frame, pass <code>true</code> or <code>{focusFrame: true}</code> to <a href=\"#!/api/Ext.FocusManager-method-enable\" rel=\"Ext.FocusManager-method-enable\" class=\"docClass\">enable</a>.</p>\n\n<p>Another feature of the FocusManager is to provide basic keyboard focus navigation scoped to any <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>\nthat would like to have navigation between its child <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>'s.</p>\n","enabled":{"!type":"bool","!doc":"<p>Whether or not the FocusManager is currently enabled</p>\n"},"focusFrameCls":{"!type":"string"},"focusedCmp":{"!doc":"<p>The currently focused component.</p>\n"},"whitelist":{"!doc":"<p>A list of xtypes that should ignore certain navigation input keys and\nallow for the default browser event/behavior. These input keys include:</p>\n\n<ol>\n<li>Backspace</li>\n<li>Delete</li>\n<li>Left</li>\n<li>Right</li>\n<li>Up</li>\n<li>Down</li>\n</ol>\n\n\n<p>The FocusManager will not attempt to navigate when a component is an xtype (or descendents thereof)\nthat belongs to this whitelist. E.g., an <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a> should allow\nthe user to move the input cursor left and right, and to delete characters, etc.</p>\n"},"addXTypeToWhitelist":{"!type":"fn(xtype: ?) -> !this","!doc":"<p>Adds the specified xtype to the <a href=\"#!/api/Ext.FocusManager-property-whitelist\" rel=\"Ext.FocusManager-property-whitelist\" class=\"docClass\">whitelist</a>.</p>\n"},"clearComponent":{"!type":"fn(cmp: ?) -> !this"},"disable":{"!type":"fn(fm: ?, eOpts: ?)","!doc":"<p>Fires when the FocusManager is disabled</p>\n"},"enable":{"!type":"fn(fm: ?, eOpts: ?)","!doc":"<p>Fires when the FocusManager is enabled</p>\n"},"focusLast":{"!type":"fn(e: ?) -> !this"},"getKeyNav":{"!type":"fn() -> !this"},"getRootComponents":{"!type":"fn() -> !this"},"handleComponentFocus":{"!type":"fn(cmp: ?, focusEl: ?) -> !this"},"initDOM":{"!type":"fn(options: ?) -> !this"},"isWhitelisted":{"!type":"fn(cmp: ?) -> !this"},"navigateIn":{"!type":"fn(e: ?) -> !this"},"navigateOut":{"!type":"fn(e: ?) -> !this"},"navigateSiblings":{"!type":"fn(e: ?, source: ?, parent: ?) -> !this"},"onComponentBlur":{"!type":"fn(cmp: ?, e: ?) -> !this"},"onComponentDestroy":{"!type":"fn() -> !this"},"onComponentFocus":{"!type":"fn(cmp: ?, e: ?) -> !this"},"onComponentHide":{"!type":"fn(cmp: ?) -> !this"},"removeDOM":{"!type":"fn() -> !this"},"removeXTypeFromWhitelist":{"!type":"fn(xtype: ?) -> !this","!doc":"<p>Removes the specified xtype from the <a href=\"#!/api/Ext.FocusManager-property-whitelist\" rel=\"Ext.FocusManager-property-whitelist\" class=\"docClass\">whitelist</a>.</p>\n"},"setupSubscriberKeys":{"!type":"fn(container: ?, keys: ?) -> !this"},"shouldShowFocusFrame":{"!type":"fn(cmp: ?) -> !this"},"beforecomponentfocus":{"!type":"fn(fm: ?, cmp: ?, previousCmp: ?, eOpts: ?)","!doc":"<p>Fires before a component becomes focused. Return <code>false</code> to prevent\nthe component from gaining focus.</p>\n"},"componentfocus":{"!type":"fn(fm: ?, cmp: ?, previousCmp: ?, eOpts: ?)","!doc":"<p>Fires after a component becomes focused.</p>\n"}},"form":{"action":{"Action":{"!doc":"<p>The subclasses of this class provide actions to perform upon <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a>s.</p>\n\n<p>Instances of this class are only created by a <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a> when the Form needs to perform an action\nsuch as submit or load. The Configuration options listed for this class are set through the Form's action methods:\n<a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>, <a href=\"#!/api/Ext.form.Basic-method-load\" rel=\"Ext.form.Basic-method-load\" class=\"docClass\">load</a> and <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a></p>\n\n<p>The instance of Action which performed the action is passed to the success and failure callbacks of the Form's action\nmethods (<a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>, <a href=\"#!/api/Ext.form.Basic-method-load\" rel=\"Ext.form.Basic-method-load\" class=\"docClass\">load</a> and\n<a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a>), and to the <a href=\"#!/api/Ext.form.Basic-event-actioncomplete\" rel=\"Ext.form.Basic-event-actioncomplete\" class=\"docClass\">actioncomplete</a> and\n<a href=\"#!/api/Ext.form.Basic-event-actionfailed\" rel=\"Ext.form.Basic-event-actionfailed\" class=\"docClass\">actionfailed</a> event handlers.</p>\n","!type":"fn(config?: ?)","prototype":{"failure":{"!doc":"<p>The function to call when a failure packet was received, or when an error ocurred in the Ajax communication.</p>\n"},"form":{"!doc":"<p>The <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">BasicForm</a> instance that is invoking this Action. Required.</p>\n"},"headers":{"!doc":"<p>Extra headers to be sent in the AJAX request for submit and load actions.\nSee Ext.data.proxy.Ajax.headers.</p>\n\n<p><strong>Note:</strong> Headers are not sent during file upload.</p>\n"},"method":{"!type":"string","!doc":"<p>The HTTP method to use to access the requested URL.\nDefaults to the <a href=\"#!/api/Ext.form.Basic-cfg-method\" rel=\"Ext.form.Basic-cfg-method\" class=\"docClass\">BasicForm's method</a>, or 'POST' if not specified.</p>\n"},"params":{"!doc":"<p>Extra parameter values to pass. These are added to the Form's <a href=\"#!/api/Ext.form.Basic-cfg-baseParams\" rel=\"Ext.form.Basic-cfg-baseParams\" class=\"docClass\">Ext.form.Basic.baseParams</a> and passed to the\nspecified URL along with the Form's input fields.</p>\n\n<p>Parameters are encoded as standard HTTP parameters using Ext.Object.toQueryString.</p>\n"},"reset":{"!type":"bool","!doc":"<p>When set to <strong>true</strong>, causes the Form to be <a href=\"#!/api/Ext.form.Basic-method-reset\" rel=\"Ext.form.Basic-method-reset\" class=\"docClass\">reset</a> on Action success. If specified,\nthis happens before the <a href=\"#!/api/Ext.form.action.Action-cfg-success\" rel=\"Ext.form.action.Action-cfg-success\" class=\"docClass\">success</a> callback is called and before the Form's\n<a href=\"#!/api/Ext.form.Basic-event-actioncomplete\" rel=\"Ext.form.Basic-event-actioncomplete\" class=\"docClass\">actioncomplete</a> event fires.</p>\n"},"scope":{"!doc":"<p>The scope in which to call the configured <a href=\"#!/api/Ext.form.action.Action-cfg-success\" rel=\"Ext.form.action.Action-cfg-success\" class=\"docClass\">success</a> and <a href=\"#!/api/Ext.form.action.Action-cfg-failure\" rel=\"Ext.form.action.Action-cfg-failure\" class=\"docClass\">failure</a> callback functions\n(the <code>this</code> reference for the callback functions).</p>\n"},"submitEmptyText":{"!type":"bool","!doc":"<p>If set to true, the emptyText value will be sent with the form when it is submitted.</p>\n"},"success":{"!doc":"<p>The function to call when a valid success return packet is received.</p>\n"},"timeout":{"!type":"number","!doc":"<p>The number of seconds to wait for a server response before failing with the <a href=\"#!/api/Ext.form.action.Action-property-failureType\" rel=\"Ext.form.action.Action-property-failureType\" class=\"docClass\">failureType</a> as\n<a href=\"#!/api/Ext.form.action.Action-static-property-CONNECT_FAILURE\" rel=\"Ext.form.action.Action-static-property-CONNECT_FAILURE\" class=\"docClass\">CONNECT_FAILURE</a>. If not specified, defaults to the configured\n<a href=\"#!/api/Ext.form.Basic-cfg-timeout\" rel=\"Ext.form.Basic-cfg-timeout\" class=\"docClass\">timeout</a> of the <a href=\"#!/api/Ext.form.action.Action-cfg-form\" rel=\"Ext.form.action.Action-cfg-form\" class=\"docClass\">form</a>.</p>\n"},"url":{"!type":"string","!doc":"<p>The URL that the Action is to invoke. Will default to the <a href=\"#!/api/Ext.form.Basic-cfg-url\" rel=\"Ext.form.Basic-cfg-url\" class=\"docClass\">url</a> configured on the\n<a href=\"#!/api/Ext.form.action.Action-cfg-form\" rel=\"Ext.form.action.Action-cfg-form\" class=\"docClass\">form</a>.</p>\n"},"waitMsg":{"!type":"string","!doc":"<p>The message to be displayed by a call to <a href=\"#!/api/Ext.window.MessageBox-method-wait\" rel=\"Ext.window.MessageBox-method-wait\" class=\"docClass\">Ext.window.MessageBox.wait</a> during the time the action is being\nprocessed.</p>\n"},"waitTitle":{"!type":"string","!doc":"<p>The title to be displayed by a call to <a href=\"#!/api/Ext.window.MessageBox-method-wait\" rel=\"Ext.window.MessageBox-method-wait\" class=\"docClass\">Ext.window.MessageBox.wait</a> during the time the action is being\nprocessed.</p>\n"},"failureType":{"!type":"string","!doc":"<p>The type of failure detected will be one of these:\n<a href=\"#!/api/Ext.form.action.Action-static-property-CLIENT_INVALID\" rel=\"Ext.form.action.Action-static-property-CLIENT_INVALID\" class=\"docClass\">CLIENT_INVALID</a>, <a href=\"#!/api/Ext.form.action.Action-static-property-SERVER_INVALID\" rel=\"Ext.form.action.Action-static-property-SERVER_INVALID\" class=\"docClass\">SERVER_INVALID</a>, <a href=\"#!/api/Ext.form.action.Action-static-property-CONNECT_FAILURE\" rel=\"Ext.form.action.Action-static-property-CONNECT_FAILURE\" class=\"docClass\">CONNECT_FAILURE</a>, or <a href=\"#!/api/Ext.form.action.Action-static-property-LOAD_FAILURE\" rel=\"Ext.form.action.Action-static-property-LOAD_FAILURE\" class=\"docClass\">LOAD_FAILURE</a>.</p>\n\n<p>Usage:</p>\n\n<pre><code>var fp = new <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>({\n...\nbuttons: [{\n    text: 'Save',\n    formBind: true,\n    handler: function(){\n        if(fp.getForm().isValid()){\n            fp.getForm().submit({\n                url: 'form-submit.php',\n                waitMsg: 'Submitting your data...',\n                success: function(form, action){\n                    // server responded with success = true\n                    var result = action.<a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a>;\n                },\n                failure: function(form, action){\n                    if (action.<a href=\"#!/api/Ext.form.action.Action-property-failureType\" rel=\"Ext.form.action.Action-property-failureType\" class=\"docClass\">failureType</a> === <a href=\"#!/api/Ext.form.action.Action-static-property-CONNECT_FAILURE\" rel=\"Ext.form.action.Action-static-property-CONNECT_FAILURE\" class=\"docClass\">Ext.form.action.Action.CONNECT_FAILURE</a>) {\n                        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Error',\n                            'Status:'+action.<a href=\"#!/api/Ext.form.action.Action-property-response\" rel=\"Ext.form.action.Action-property-response\" class=\"docClass\">response</a>.status+': '+\n                            action.<a href=\"#!/api/Ext.form.action.Action-property-response\" rel=\"Ext.form.action.Action-property-response\" class=\"docClass\">response</a>.statusText);\n                    }\n                    if (action.failureType === <a href=\"#!/api/Ext.form.action.Action-static-property-SERVER_INVALID\" rel=\"Ext.form.action.Action-static-property-SERVER_INVALID\" class=\"docClass\">Ext.form.action.Action.SERVER_INVALID</a>){\n                        // server responded with success = false\n                        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Invalid', action.<a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a>.errormsg);\n                    }\n                }\n            });\n        }\n    }\n},{\n    text: 'Reset',\n    handler: function(){\n        fp.getForm().reset();\n    }\n}]\n</code></pre>\n"},"response":{"!doc":"<p>The raw XMLHttpRequest object used to perform the action.</p>\n"},"result":{"!doc":"<p>The decoded response object containing a boolean <code>success</code> property and other, action-specific properties.</p>\n"},"type":{"!type":"string","!doc":"<p>The type of action this Action instance performs. Currently only \"submit\" and \"load\" are supported.</p>\n"},"CLIENT_INVALID":{"!type":"string","!doc":"<p>Failure type returned when client side validation of the Form fails thus aborting a submit action. Client\nside validation is performed unless <a href=\"#!/api/Ext.form.action.Submit-cfg-clientValidation\" rel=\"Ext.form.action.Submit-cfg-clientValidation\" class=\"docClass\">Ext.form.action.Submit.clientValidation</a> is explicitly set to\nfalse.</p>\n"},"CONNECT_FAILURE":{"!type":"string","!doc":"<p>Failure type returned when a communication error happens when attempting to send a request to the remote\nserver. The <a href=\"#!/api/Ext.form.action.Action-property-response\" rel=\"Ext.form.action.Action-property-response\" class=\"docClass\">response</a> may be examined to provide further information.</p>\n"},"LOAD_FAILURE":{"!type":"string","!doc":"<p>Failure type returned when the response's <code>success</code> property is set to false, or no field values are returned\nin the response's data property.</p>\n"},"SERVER_INVALID":{"!type":"string","!doc":"<p>Failure type returned when server side processing fails and the <a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a>'s <code>success</code> property is set to\nfalse.</p>\n\n<p>In the case of a form submission, field-specific error messages may be returned in the <a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a>'s\nerrors property.</p>\n"},"createCallback":{"!type":"fn() -> !this","!doc":"<p>Creates a callback object.</p>\n"},"getMethod":{"!type":"fn() -> string","!doc":"<p>Determine the HTTP method to be used for the request.</p>\n"},"getParams":{"!type":"fn() -> ?","!doc":"<p>Get the set of parameters specified in the BasicForm's baseParams and/or the params option.\nItems in params override items of the same name in baseParams.</p>\n"},"getUrl":{"!type":"fn() -> string","!doc":"<p>Build the URL for the AJAX request. Used by the standard AJAX submit and load actions.</p>\n"},"handleResponse":{"!type":"fn(response: ?)","!doc":"<p>Handles the raw response and builds a result object from it. Must be implemented by subclasses.</p>\n"},"onFailure":{"!type":"fn(response: ?) -> !this","!doc":"<p>Handles a failure response.</p>\n"},"onSuccess":{"!type":"fn(response: ?)","!doc":"<p>Callback method that gets invoked when the action completes successfully. Must be implemented by subclasses.</p>\n"},"processResponse":{"!type":"fn(response: ?) -> ?","!doc":"<p>Validates that a response contains either responseText or responseXML and invokes\n<a href=\"#!/api/Ext.form.action.Action-method-handleResponse\" rel=\"Ext.form.action.Action-method-handleResponse\" class=\"docClass\">handleResponse</a> to build the result object.</p>\n"},"run":{"!type":"fn() -> !this","!doc":"<p>Invokes this action using the current configuration.</p>\n"}}},"DirectLoad":{"!doc":"<p>Provides Ext.direct.Manager support for loading form data.</p>\n\n<p>This example illustrates usage of Ext.direct.Direct to <strong>load</strong> a form through Ext.Direct.</p>\n\n<pre><code>var myFormPanel = new <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>({\n    // configs for FormPanel\n    title: 'Basic Information',\n    renderTo: document.body,\n    width: 300, height: 160,\n    padding: 10,\n\n    // configs apply to child items\n    defaults: {anchor: '100%'},\n    defaultType: 'textfield',\n    items: [{\n        fieldLabel: 'Name',\n        name: 'name'\n    },{\n        fieldLabel: 'Email',\n        name: 'email'\n    },{\n        fieldLabel: 'Company',\n        name: 'company'\n    }],\n\n    // configs for BasicForm\n    api: {\n        // The server-side method to call for load() requests\n        load: Profile.getBasicInfo,\n        // The server-side must mark the submit handler as a 'formHandler'\n        submit: Profile.updateBasicInfo\n    },\n    // specify the order for the passed params\n    paramOrder: ['uid', 'foo']\n});\n\n// load the form\nmyFormPanel.getForm().load({\n    // pass 2 arguments to server side getBasicInfo method (len=2)\n    params: {\n        foo: 'bar',\n        uid: 34\n    }\n});\n</code></pre>\n\n<p>The data packet sent to the server will resemble something like:</p>\n\n<pre><code>[\n    {\n        \"action\":\"Profile\",\"method\":\"getBasicInfo\",\"type\":\"rpc\",\"tid\":2,\n        \"data\":[34,\"bar\"] // note the order of the params\n    }\n]\n</code></pre>\n\n<p>The form will process a data packet returned by the server that is similar to the following format:</p>\n\n<pre><code>[\n    {\n        \"action\":\"Profile\",\"method\":\"getBasicInfo\",\"type\":\"rpc\",\"tid\":2,\n        \"result\":{\n            \"success\":true,\n            \"data\":{\n                \"name\":\"Fred Flintstone\",\n                \"company\":\"Slate Rock and Gravel\",\n                \"email\":\"fred.flintstone@slaterg.com\"\n            }\n        }\n    }\n]\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"type":{"!type":"string","!doc":"<p>The type of action this Action instance performs. Currently only \"submit\" and \"load\" are supported.</p>\n"},"onComplete":{"!type":"fn(data: ?) -> !this"},"processResponse":{"!type":"fn(response: ?) -> ?","!doc":"<p>Direct actions have already been processed and therefore\nwe can directly set the result; Direct Actions do not have\na this.response property.</p>\n"},"run":{"!type":"fn() -> !this"}}},"Load":{"prototype":{"handleResponse":{"!type":"fn(response: ?) -> !this"},"onSuccess":{"!type":"fn(response: ?) -> !this"},"type":{"!type":"string","!doc":"<p>The type of action this Action instance performs. Currently only \"submit\" and \"load\" are supported.</p>\n"},"run":{"!type":"fn() -> !this"}},"!doc":"<p>A class which handles loading of data from a server into the Fields of an <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a>.</p>\n\n<p>Instances of this class are only created by a <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a> when <a href=\"#!/api/Ext.form.Basic-method-load\" rel=\"Ext.form.Basic-method-load\" class=\"docClass\">load</a>ing.</p>\n\n<h2>Response Packet Criteria</h2>\n\n<p>A response packet <strong>must</strong> contain:</p>\n\n<ul>\n<li><strong><code>success</code></strong> property : Boolean</li>\n<li><strong><code>data</code></strong> property : Object</li>\n</ul>\n\n\n<p>The <code>data</code> property contains the values of Fields to load. The individual value object for each Field is passed to\nthe Field's <a href=\"#!/api/Ext.form.field.Field-method-setValue\" rel=\"Ext.form.field.Field-method-setValue\" class=\"docClass\">setValue</a> method.</p>\n\n<h2>JSON Packets</h2>\n\n<p>By default, response packets are assumed to be JSON, so for the following form load call:</p>\n\n<pre><code>var myFormPanel = new <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>({\n    title: 'Client and routing info',\n    renderTo: Ext.getBody(),\n    defaults: {\n        xtype: 'textfield'\n    },\n    items: [{\n        fieldLabel: 'Client',\n        name: 'clientName'\n    }, {\n        fieldLabel: 'Port of loading',\n        name: 'portOfLoading'\n    }, {\n        fieldLabel: 'Port of discharge',\n        name: 'portOfDischarge'\n    }]\n});\nmyFormPanel.<a href=\"#!/api/Ext.form.Panel-method-getForm\" rel=\"Ext.form.Panel-method-getForm\" class=\"docClass\">getForm</a>().<a href=\"#!/api/Ext.form.Basic-method-load\" rel=\"Ext.form.Basic-method-load\" class=\"docClass\">load</a>({\n    url: '/getRoutingInfo.php',\n    params: {\n        consignmentRef: myConsignmentRef\n    },\n    failure: function(form, action) {\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>(\"Load failed\", action.result.errorMessage);\n    }\n});\n</code></pre>\n\n<p>a <strong>success response</strong> packet may look like this:</p>\n\n<pre><code>{\n    success: true,\n    data: {\n        clientName: \"Fred. Olsen Lines\",\n        portOfLoading: \"FXT\",\n        portOfDischarge: \"OSL\"\n    }\n}\n</code></pre>\n\n<p>while a <strong>failure response</strong> packet may look like this:</p>\n\n<pre><code>{\n    success: false,\n    errorMessage: \"Consignment reference not found\"\n}\n</code></pre>\n\n<p>Other data may be placed into the response for processing the <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a>'s callback or event handler\nmethods. The object decoded from this JSON is available in the <a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a> property.</p>\n","!type":"fn(config?: ?)"},"DirectSubmit":{"!doc":"<p>Provides Ext.direct support for submitting form data.</p>\n\n<p>This example illustrates usage of Ext.direct.Direct to <strong>submit</strong> a form through Ext.Direct.</p>\n\n<pre><code>var myFormPanel = new <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>({\n    // configs for FormPanel\n    title: 'Basic Information',\n    renderTo: document.body,\n    width: 300, height: 160,\n    padding: 10,\n    buttons:[{\n        text: 'Submit',\n        handler: function(){\n            myFormPanel.getForm().submit({\n                params: {\n                    foo: 'bar',\n                    uid: 34\n                }\n            });\n        }\n    }],\n\n    // configs apply to child items\n    defaults: {anchor: '100%'},\n    defaultType: 'textfield',\n    items: [{\n        fieldLabel: 'Name',\n        name: 'name'\n    },{\n        fieldLabel: 'Email',\n        name: 'email'\n    },{\n        fieldLabel: 'Company',\n        name: 'company'\n    }],\n\n    // configs for BasicForm\n    api: {\n        // The server-side method to call for load() requests\n        load: Profile.getBasicInfo,\n        // The server-side must mark the submit handler as a 'formHandler'\n        submit: Profile.updateBasicInfo\n    },\n    // specify the order for the passed params\n    paramOrder: ['uid', 'foo']\n});\n</code></pre>\n\n<p>The data packet sent to the server will resemble something like:</p>\n\n<pre><code>{\n    \"action\":\"Profile\",\"method\":\"updateBasicInfo\",\"type\":\"rpc\",\"tid\":\"6\",\n    \"result\":{\n        \"success\":true,\n        \"id\":{\n            \"extAction\":\"Profile\",\"extMethod\":\"updateBasicInfo\",\n            \"extType\":\"rpc\",\"extTID\":\"6\",\"extUpload\":\"false\",\n            \"name\":\"Aaron Conran\",\"email\":\"aaron@sencha.com\",\"company\":\"Sencha Inc.\"\n        }\n    }\n}\n</code></pre>\n\n<p>The form will process a data packet returned by the server that is similar to the following:</p>\n\n<pre><code>// sample success packet (batched requests)\n[\n    {\n        \"action\":\"Profile\",\"method\":\"updateBasicInfo\",\"type\":\"rpc\",\"tid\":3,\n        \"result\":{\n            \"success\":true\n        }\n    }\n]\n\n// sample failure packet (one request)\n{\n        \"action\":\"Profile\",\"method\":\"updateBasicInfo\",\"type\":\"rpc\",\"tid\":\"6\",\n        \"result\":{\n            \"errors\":{\n                \"email\":\"already taken\"\n            },\n            \"success\":false,\n            \"foo\":\"bar\"\n        }\n}\n</code></pre>\n\n<p>Also see the discussion in <a href=\"#!/api/Ext.form.action.DirectLoad\" rel=\"Ext.form.action.DirectLoad\" class=\"docClass\">Ext.form.action.DirectLoad</a>.</p>\n","!type":"fn(config?: ?)","prototype":{"type":{"!type":"string","!doc":"<p>The type of action this Action instance performs. Currently only \"submit\" and \"load\" are supported.</p>\n"},"doSubmit":{"!type":"fn() -> !this","!doc":"<p>Performs the submit of the form data.</p>\n"},"onComplete":{"!type":"fn(data: ?) -> !this"},"processResponse":{"!type":"fn(response: ?) -> ?","!doc":"<p>Direct actions have already been processed and therefore\nwe can directly set the result; Direct Actions do not have\na this.response property.</p>\n"}}},"Submit":{"prototype":{"clientValidation":{"!type":"bool","!doc":"<p>Determines whether a Form's fields are validated in a final call to <a href=\"#!/api/Ext.form.Basic-method-isValid\" rel=\"Ext.form.Basic-method-isValid\" class=\"docClass\">isValid</a> prior\nto submission. Pass false in the Form's submit options to prevent this.</p>\n"},"buildForm":{"!type":"fn() -> ?","!doc":"<p>Builds a form element containing fields corresponding to all the parameters to be\nsubmitted (everything returned by <a href=\"#!/api/Ext.form.action.Submit-method-getParams\" rel=\"Ext.form.action.Submit-method-getParams\" class=\"docClass\">getParams</a>.</p>\n\n<p>NOTE: the form element is automatically added to the DOM, so any code that uses\nit must remove it from the DOM after finishing with it.</p>\n"},"cleanup":{"!type":"fn(formInfo: ?) -> !this"},"getFieldConfig":{"!type":"fn(name: ?, value: ?) -> !this"},"getParams":{"!type":"fn(useModelValues: ?) -> !this","!doc":"<p>Builds the full set of parameters from the field values plus any additional configured params.</p>\n"},"handleResponse":{"!type":"fn(response: ?) -> !this"},"onSuccess":{"!type":"fn(response: ?) -> !this"},"run":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"type":{"!type":"string","!doc":"<p>The type of action this Action instance performs. Currently only \"submit\" and \"load\" are supported.</p>\n"},"doSubmit":{"!type":"fn() -> !this","!doc":"<p>Performs the submit of the form data.</p>\n"}},"!doc":"<p>A class which handles submission of data from <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a>s and processes the returned response.</p>\n\n<p>Instances of this class are only created by a <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a> when\n<a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>ting.</p>\n\n<h1>Response Packet Criteria</h1>\n\n<p>A response packet may contain:</p>\n\n<ul>\n<li><p><strong><code>success</code></strong> property : Boolean - required.</p></li>\n<li><p><strong><code>errors</code></strong> property : Object - optional, contains error messages for invalid fields.</p></li>\n</ul>\n\n\n<h1>JSON Packets</h1>\n\n<p>By default, response packets are assumed to be JSON, so a typical response packet may look like this:</p>\n\n<pre><code>{\n    success: false,\n    errors: {\n        clientCode: \"Client not found\",\n        portOfLoading: \"This field must not be null\"\n    }\n}\n</code></pre>\n\n<p>Other data may be placed into the response for processing by the <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a>'s callback or event handler\nmethods. The object decoded from this JSON is available in the <a href=\"#!/api/Ext.form.action.Action-property-result\" rel=\"Ext.form.action.Action-property-result\" class=\"docClass\">result</a> property.</p>\n\n<p>Alternatively, if an <a href=\"#!/api/Ext.form.Basic-cfg-errorReader\" rel=\"Ext.form.Basic-cfg-errorReader\" class=\"docClass\">errorReader</a> is specified as an\nXmlReader:</p>\n\n<pre><code>errorReader: new Ext.data.reader.Xml({\n        record : 'field',\n        success: '@success'\n    }, [\n        'id', 'msg'\n    ]\n)\n</code></pre>\n\n<p>then the results may be sent back in XML format:</p>\n\n<pre><code>&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n&lt;message success=\"false\"&gt;\n&lt;errors&gt;\n    &lt;field&gt;\n        &lt;id&gt;clientCode&lt;/id&gt;\n        &lt;msg&gt;&lt;![CDATA[Code not found. &lt;br /&gt;&lt;i&gt;This is a test validation message from the server &lt;/i&gt;]]&gt;&lt;/msg&gt;\n    &lt;/field&gt;\n    &lt;field&gt;\n        &lt;id&gt;portOfLoading&lt;/id&gt;\n        &lt;msg&gt;&lt;![CDATA[Port not found. &lt;br /&gt;&lt;i&gt;This is a test validation message from the server &lt;/i&gt;]]&gt;&lt;/msg&gt;\n    &lt;/field&gt;\n&lt;/errors&gt;\n&lt;/message&gt;\n</code></pre>\n\n<p>Other elements may be placed into the response XML for processing by the <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a>'s callback or event\nhandler methods. The XML document is available in the <a href=\"#!/api/Ext.form.Basic-cfg-errorReader\" rel=\"Ext.form.Basic-cfg-errorReader\" class=\"docClass\">errorReader</a>'s\nxmlData property.</p>\n","!type":"fn(config?: ?)"},"StandardSubmit":{"!doc":"<p>A class which handles submission of data from <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a>s using a standard <code>&lt;form&gt;</code> element submit.\nIt does not handle the response from the submit.</p>\n\n<p>If validation of the form fields fails, the Form's afterAction method will be called. Otherwise, afterAction will not\nbe called.</p>\n\n<p>Instances of this class are only created by a <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Form</a> when\n<a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>ting, when the form's <a href=\"#!/api/Ext.form.Basic-cfg-standardSubmit\" rel=\"Ext.form.Basic-cfg-standardSubmit\" class=\"docClass\">Ext.form.Basic.standardSubmit</a> config option is true.</p>\n","!type":"fn(config?: ?)","prototype":{"target":{"!type":"string","!doc":"<p>Optional target attribute to be used for the form when submitting.</p>\n\n<p>Defaults to the current window/frame.</p>\n"},"doSubmit":{"!type":"fn() -> !this","!doc":"<p>Perform the form submit. Creates and submits a temporary form element containing an input element for each\nfield value returned by <a href=\"#!/api/Ext.form.Basic-method-getValues\" rel=\"Ext.form.Basic-method-getValues\" class=\"docClass\">Ext.form.Basic.getValues</a>, plus any configured <a href=\"#!/api/Ext.form.action.StandardSubmit-cfg-params\" rel=\"Ext.form.action.StandardSubmit-cfg-params\" class=\"docClass\">params</a> or\n<a href=\"#!/api/Ext.form.Basic-cfg-baseParams\" rel=\"Ext.form.Basic-cfg-baseParams\" class=\"docClass\">baseParams</a>.</p>\n"}}}},"Basic":{"!doc":"<p>Provides input field management, validation, submission, and form loading services for the collection\nof <a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Field</a> instances within a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>. It is recommended\nthat you use a <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a> as the form container, as that has logic to automatically\nhook up an instance of <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a> (plus other conveniences related to field configuration.)</p>\n\n<h2>Form Actions</h2>\n\n<p>The Basic class delegates the handling of form loads and submits to instances of <a href=\"#!/api/Ext.form.action.Action\" rel=\"Ext.form.action.Action\" class=\"docClass\">Ext.form.action.Action</a>.\nSee the various Action implementations for specific details of each one's functionality, as well as the\ndocumentation for <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a> which details the configuration options that can be specified in\neach action call.</p>\n\n<p>The default submit Action is <a href=\"#!/api/Ext.form.action.Submit\" rel=\"Ext.form.action.Submit\" class=\"docClass\">Ext.form.action.Submit</a>, which uses an Ajax request to submit the\nform's values to a configured URL. To enable normal browser submission of an Ext form, use the\n<a href=\"#!/api/Ext.form.Basic-cfg-standardSubmit\" rel=\"Ext.form.Basic-cfg-standardSubmit\" class=\"docClass\">standardSubmit</a> config option.</p>\n\n<h2>File uploads</h2>\n\n<p>File uploads are not performed using normal 'Ajax' techniques; see the description for\n<a href=\"#!/api/Ext.form.Basic-method-hasUpload\" rel=\"Ext.form.Basic-method-hasUpload\" class=\"docClass\">hasUpload</a> for details. If you're using file uploads you should read the method description.</p>\n\n<h2>Example usage:</h2>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>', {\n    title: 'Basic Form',\n    renderTo: Ext.getBody(),\n    bodyPadding: 5,\n    width: 350,\n\n    // Any configuration items here will be automatically passed along to\n    // the <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a> instance when it gets created.\n\n    // The form will submit an AJAX request to this URL when submitted\n    url: 'save-form.php',\n\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Field',\n        name: 'theField'\n    }],\n\n    buttons: [{\n        text: 'Submit',\n        handler: function() {\n            // The getForm() method returns the <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a> instance:\n            var form = this.up('form').getForm();\n            if (form.isValid()) {\n                // Submit the Ajax request and handle the response\n                form.submit({\n                    success: function(form, action) {\n                       <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Success', action.result.message);\n                    },\n                    failure: function(form, action) {\n                        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Failed', action.result ? action.result.message : 'No response');\n                    }\n                });\n            }\n        }\n    }]\n});\n</code></pre>\n","!type":"fn(owner: ?, config: ?)","prototype":{"api":{"!doc":"<p>If specified, load and submit actions will be handled with <a href=\"#!/api/Ext.form.action.DirectLoad\" rel=\"Ext.form.action.DirectLoad\" class=\"docClass\">DirectLoad</a>\nand <a href=\"#!/api/Ext.form.action.DirectSubmit\" rel=\"Ext.form.action.DirectSubmit\" class=\"docClass\">DirectSubmit</a>.  Methods which have been imported by\nExt.direct.Manager can be specified here to load and submit forms. API methods may also be\nspecified as strings. See Ext.data.proxy.Direct.directFn.  Such as the following:</p>\n\n<pre><code>api: {\n    load: App.ss.MyProfile.load,\n    submit: App.ss.MyProfile.submit\n}\n</code></pre>\n\n<p>Load actions can use <a href=\"#!/api/Ext.form.Basic-cfg-paramOrder\" rel=\"Ext.form.Basic-cfg-paramOrder\" class=\"docClass\">paramOrder</a> or <a href=\"#!/api/Ext.form.Basic-cfg-paramsAsHash\" rel=\"Ext.form.Basic-cfg-paramsAsHash\" class=\"docClass\">paramsAsHash</a> to customize how the load method\nis invoked.  Submit actions will always use a standard form submit. The <code>formHandler</code> configuration\n(see Ext.direct.RemotingProvider#action) must be set on the associated server-side method which has\nbeen imported by Ext.direct.Manager.</p>\n"},"baseParams":{"!doc":"<p>Parameters to pass with all requests. e.g. baseParams: <code>{id: '123', foo: 'bar'}</code>.</p>\n\n<p>Parameters are encoded as standard HTTP parameters using Ext.Object.toQueryString.</p>\n"},"errorReader":{"!doc":"<p>An Ext.data.reader.Reader (e.g. Ext.data.reader.Xml) instance or\nconfiguration to be used to read field error messages returned from 'submit' actions.\nThis is optional as there is built-in support for processing JSON responses.</p>\n\n<p>The Records which provide messages for the invalid Fields must use the\nField name (or id) as the Record ID, and must contain a field called 'msg'\nwhich contains the error message.</p>\n\n<p>The errorReader does not have to be a full-blown implementation of a\nReader. It simply needs to implement a <code>read(xhr)</code> function\nwhich returns an Array of Records in an object with the following\nstructure:</p>\n\n<pre><code>{\n    records: recordArray\n}\n</code></pre>\n"},"jsonSubmit":{"!type":"bool","!doc":"<p>If set to true, the field values are sent as JSON in the request body.\nAll of the field values, plus any additional params configured via <a href=\"#!/api/Ext.form.Basic-cfg-baseParams\" rel=\"Ext.form.Basic-cfg-baseParams\" class=\"docClass\">baseParams</a>\nand/or the <code>options</code> to <a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>, will be included in the values POSTed in the body of the request.</p>\n"},"method":{"!type":"string","!doc":"<p>The request method to use (GET or POST) for form actions if one isn't supplied in the action options.</p>\n"},"paramOrder":{"!doc":"<p>A list of params to be executed server side. Only used for the <a href=\"#!/api/Ext.form.Basic-cfg-api\" rel=\"Ext.form.Basic-cfg-api\" class=\"docClass\">api</a> <code>load</code>\nconfiguration.</p>\n\n<p>Specify the params in the order in which they must be executed on the\nserver-side as either (1) an Array of String values, or (2) a String of params\ndelimited by either whitespace, comma, or pipe. For example,\nany of the following would be acceptable:</p>\n\n<pre><code>paramOrder: ['param1','param2','param3']\nparamOrder: 'param1 param2 param3'\nparamOrder: 'param1,param2,param3'\nparamOrder: 'param1|param2|param'\n</code></pre>\n"},"paramsAsHash":{"!type":"bool","!doc":"<p>Only used for the <a href=\"#!/api/Ext.form.Basic-cfg-api\" rel=\"Ext.form.Basic-cfg-api\" class=\"docClass\">api</a> <code>load</code> configuration. If true, parameters will be sent as a\nsingle hash collection of named arguments. Providing a <a href=\"#!/api/Ext.form.Basic-cfg-paramOrder\" rel=\"Ext.form.Basic-cfg-paramOrder\" class=\"docClass\">paramOrder</a> nullifies this\nconfiguration.</p>\n"},"reader":{"!doc":"<p>An Ext.data.reader.Reader (e.g. Ext.data.reader.Xml) instance or\nconfiguration to be used to read data when executing 'load' actions. This\nis optional as there is built-in support for processing JSON responses.</p>\n"},"standardSubmit":{"!type":"bool","!doc":"<p>If set to true, a standard HTML form submit is used instead of a XHR (Ajax) style form submission.\nAll of the field values, plus any additional params configured via <a href=\"#!/api/Ext.form.Basic-cfg-baseParams\" rel=\"Ext.form.Basic-cfg-baseParams\" class=\"docClass\">baseParams</a>\nand/or the <code>options</code> to <a href=\"#!/api/Ext.form.Basic-method-submit\" rel=\"Ext.form.Basic-method-submit\" class=\"docClass\">submit</a>, will be included in the values submitted in the form.</p>\n"},"timeout":{"!type":"number","!doc":"<p>Timeout for form actions in seconds.</p>\n"},"trackResetOnLoad":{"!type":"bool","!doc":"<p>If set to true, <a href=\"#!/api/Ext.form.Basic-method-reset\" rel=\"Ext.form.Basic-method-reset\" class=\"docClass\">reset</a>() resets to the last loaded or <a href=\"#!/api/Ext.form.Basic-method-setValues\" rel=\"Ext.form.Basic-method-setValues\" class=\"docClass\">setValues</a>() data instead of\nwhen the form was first created.</p>\n"},"url":{"!type":"string","!doc":"<p>The URL to use for form actions if one isn't supplied in the\n<a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a> options.</p>\n"},"waitMsgTarget":{"!doc":"<p>By default wait messages are displayed with <a href=\"#!/api/Ext.MessageBox-method-wait\" rel=\"Ext.MessageBox-method-wait\" class=\"docClass\">Ext.MessageBox.wait</a>. You can target a specific\nelement by passing it or its id or mask the form itself by passing in true.</p>\n"},"waitTitle":{"!type":"string","!doc":"<p>The default title to show for the waiting message box</p>\n"},"owner":{"!doc":"<p>The container component to which this BasicForm is attached.</p>\n"},"taskDelay":{"!type":"number","!doc":"<p>Not a public API config, this is useful when we're unit testing so we can\nturn off the delayed tasks so they fire immediately.</p>\n"},"wasDirty":{"!type":"bool","!doc":"<p>Private</p>\n"},"afterAction":{"!type":"fn(action: ?, success: ?) -> !this","!doc":"<p>Called after an action is performed via <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a>.</p>\n"},"applyIfToFields":{"!type":"fn(obj: ?) -> ?","!doc":"<p>Calls Ext.applyIf for all field in this form with the passed object.</p>\n"},"applyToFields":{"!type":"fn(obj: ?) -> ?","!doc":"<p>Calls Ext.apply for all fields in this form with the passed object.</p>\n"},"beforeAction":{"!type":"fn(action: ?) -> !this","!doc":"<p>Called before an action is performed via <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">doAction</a>.</p>\n"},"checkDirty":{"!type":"fn() -> !this","!doc":"<p>Check whether the dirty state of the entire form has changed since it was last checked, and\nif so fire the <a href=\"#!/api/Ext.form.Basic-event-dirtychange\" rel=\"Ext.form.Basic-event-dirtychange\" class=\"docClass\">dirtychange</a> event. This is automatically invoked\nwhen an individual field's <code>dirty</code> state changes.</p>\n"},"checkDirtyDelay":{"!type":"fn() -> !this"},"checkValidity":{"!type":"fn() -> !this","!doc":"<p>Check whether the validity of the entire form has changed since it was last checked, and\nif so fire the <a href=\"#!/api/Ext.form.Basic-event-validitychange\" rel=\"Ext.form.Basic-event-validitychange\" class=\"docClass\">validitychange</a> event. This is automatically invoked\nwhen an individual field's validity changes.</p>\n"},"checkValidityDelay":{"!type":"fn() -> !this"},"clearInvalid":{"!type":"fn() -> ?","!doc":"<p>Clears all invalid field messages in this form.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this object.</p>\n"},"doAction":{"!type":"fn(action: ?, options?: ?) -> ?","!doc":"<p>Performs a predefined action (an implementation of <a href=\"#!/api/Ext.form.action.Action\" rel=\"Ext.form.action.Action\" class=\"docClass\">Ext.form.action.Action</a>) to perform application-\nspecific processing.</p>\n"},"findField":{"!type":"fn(id: ?) -> ?","!doc":"<p>Find a specific <a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Ext.form.field.Field</a> in this form by id or name.</p>\n"},"getBoundItems":{"!type":"fn() -> ?","!doc":"<p>Finds and returns the set of all items bound to fields inside this form</p>\n"},"getFieldValues":{"!type":"fn(dirtyOnly?: ?) -> ?","!doc":"<p>Retrieves the fields in the form as a set of key/value pairs, using their\n<a href=\"#!/api/Ext.form.field.Field-method-getModelData\" rel=\"Ext.form.field.Field-method-getModelData\" class=\"docClass\">getModelData()</a> method to collect the values.\nIf multiple fields return values under the same name those values will be combined into an Array.\nThis is similar to <a href=\"#!/api/Ext.form.Basic-method-getValues\" rel=\"Ext.form.Basic-method-getValues\" class=\"docClass\">getValues</a> except that this method collects type-specific data values\n(e.g. Date objects for date fields) while getValues returns only String values for submission.</p>\n"},"getFields":{"!type":"fn() -> ?","!doc":"<p>Return all the <a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Ext.form.field.Field</a> components in the owner container.</p>\n"},"getRecord":{"!type":"fn() -> ?","!doc":"<p>Returns the last Ext.data.Model instance that was loaded via <a href=\"#!/api/Ext.form.Basic-method-loadRecord\" rel=\"Ext.form.Basic-method-loadRecord\" class=\"docClass\">loadRecord</a></p>\n"},"getValues":{"!type":"fn(asString?: ?, dirtyOnly?: ?, includeEmptyText?: ?, useDataValues?: ?) -> ?","!doc":"<p>Retrieves the fields in the form as a set of key/value pairs, using their\n<a href=\"#!/api/Ext.form.field.Field-method-getSubmitData\" rel=\"Ext.form.field.Field-method-getSubmitData\" class=\"docClass\">getSubmitData()</a> method to collect the values.\nIf multiple fields return values under the same name those values will be combined into an Array.\nThis is similar to <a href=\"#!/api/Ext.form.Basic-method-getFieldValues\" rel=\"Ext.form.Basic-method-getFieldValues\" class=\"docClass\">getFieldValues</a> except that this method\ncollects only String values for submission, while getFieldValues collects type-specific data\nvalues (e.g. Date objects for date fields.)</p>\n"},"hasInvalidField":{"!type":"fn() -> !this","!doc":"<p>Returns true if the form contains any invalid fields. No fields will be marked as invalid\nas a result of calling this; to trigger marking of fields use <a href=\"#!/api/Ext.form.Basic-method-isValid\" rel=\"Ext.form.Basic-method-isValid\" class=\"docClass\">isValid</a> instead.</p>\n"},"hasUpload":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if the form contains a file upload field. This is used to determine the method for submitting the\nform: File uploads are not performed using normal 'Ajax' techniques, that is they are <strong>not</strong> performed using\nXMLHttpRequests. Instead a hidden <code>&lt;form&gt;</code> element containing all the fields is created temporarily and submitted\nwith its <a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer to a dynamically generated, hidden <code>&lt;iframe&gt;</code> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the server is using JSON\nto send the return object, then the <a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header should be set to \"text/plain\" in order to tell the\nbrowser to insert the text unchanged into a '&lt;pre>' element in the document body from which it can be retrieved.</p>\n\n<p>If the <a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header is sent as the default, \"text/html\", then characters which are significant to an HTML\nparser must be sent as HTML entities, so encode <code>\"&lt;\"</code> as <code>\"&amp;lt;\"</code>, <code>\"&amp;\"</code> as <code>\"&amp;amp;\"</code> etc.</p>\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object is created containing a\nresponseText property in order to conform to the requirements of event handlers and callbacks.</p>\n\n<p>Be aware that file upload packets are sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form</a> and some server technologies\n(notably JEE) may require some custom processing in order to retrieve parameter names and parameter values from\nthe packet content.</p>\n"},"initialize":{"!type":"fn() -> !this","!doc":"<p>Do any post layout initialization</p>\n"},"isDirty":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if any fields in this form have changed from their original values.</p>\n\n<p>Note that if this BasicForm was configured with <a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a> then the Fields' <em>original values</em> are updated when the values are\nloaded by <a href=\"#!/api/Ext.form.Basic-method-setValues\" rel=\"Ext.form.Basic-method-setValues\" class=\"docClass\">setValues</a> or <a href=\"#!/api/Ext.form.Basic-method-loadRecord\" rel=\"Ext.form.Basic-method-loadRecord\" class=\"docClass\">loadRecord</a>. This means\nthat:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>: <code>false</code> -> Will return <code>true</code> after calling this method.</li>\n<li><a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>: <code>true</code> -> Will return <code>false</code> after calling this method.</li>\n</ul>\n\n"},"isValid":{"!type":"fn() -> bool","!doc":"<p>Returns true if client-side validation on the form is successful. Any invalid fields will be\nmarked as invalid. If you only want to determine overall form validity without marking anything,\nuse <a href=\"#!/api/Ext.form.Basic-method-hasInvalidField\" rel=\"Ext.form.Basic-method-hasInvalidField\" class=\"docClass\">hasInvalidField</a> instead.</p>\n"},"load":{"!type":"fn(options: ?) -> ?","!doc":"<p>Shortcut to <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">do</a> a <a href=\"#!/api/Ext.form.action.Load\" rel=\"Ext.form.action.Load\" class=\"docClass\">load action</a>.</p>\n"},"loadRecord":{"!type":"fn(record: ?) -> ?","!doc":"<p>Loads an Ext.data.Model into this form by calling <a href=\"#!/api/Ext.form.Basic-method-setValues\" rel=\"Ext.form.Basic-method-setValues\" class=\"docClass\">setValues</a> with the\nrecord data. The fields in the model are mapped to\nfields in the form by matching either the <a href=\"#!/api/Ext.form.field.Base-cfg-name\" rel=\"Ext.form.field.Base-cfg-name\" class=\"docClass\">Ext.form.field.Base.name</a> or <a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">Ext.Component.itemId</a>.<br/>\nSee also <a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a>.</p>\n"},"markInvalid":{"!type":"fn(errors: ?) -> ?","!doc":"<p>Mark fields in this form invalid in bulk.</p>\n"},"onFieldAdd":{"!type":"fn(field: ?) -> !this"},"onFieldRemove":{"!type":"fn(field: ?) -> !this"},"onMonitorInvalidate":{"!type":"fn() -> !this"},"onValidityChange":{"!type":"fn(valid: ?) -> !this","!doc":"<p>Handle changes in the form's validity. If there are any sub components with\n<code>formBind=true</code> then they are enabled/disabled based on the new validity.</p>\n"},"reset":{"!type":"fn(resetRecord?: ?) -> ?","!doc":"<p>Resets all fields in this form. By default, any record bound by <a href=\"#!/api/Ext.form.Basic-method-loadRecord\" rel=\"Ext.form.Basic-method-loadRecord\" class=\"docClass\">loadRecord</a>\nwill be retained.</p>\n"},"setValues":{"!type":"fn(values: ?) -> ?","!doc":"<p>Set values for fields in this form in bulk.</p>\n"},"submit":{"!type":"fn(options: ?) -> ?","!doc":"<p>Shortcut to <a href=\"#!/api/Ext.form.Basic-method-doAction\" rel=\"Ext.form.Basic-method-doAction\" class=\"docClass\">do</a> a <a href=\"#!/api/Ext.form.action.Submit\" rel=\"Ext.form.action.Submit\" class=\"docClass\">submit action</a>. This will use the\n<a href=\"#!/api/Ext.form.action.Submit\" rel=\"Ext.form.action.Submit\" class=\"docClass\">AJAX submit action</a> by default. If the <a href=\"#!/api/Ext.form.Basic-cfg-standardSubmit\" rel=\"Ext.form.Basic-cfg-standardSubmit\" class=\"docClass\">standardSubmit</a> config\nis enabled it will use a standard form element to submit, or if the <a href=\"#!/api/Ext.form.Basic-cfg-api\" rel=\"Ext.form.Basic-cfg-api\" class=\"docClass\">api</a> config is present\nit will use the <a href=\"#!/api/Ext.form.action.DirectLoad\" rel=\"Ext.form.action.DirectLoad\" class=\"docClass\">Ext.direct.Direct submit action</a>.</p>\n\n<p>The following code:</p>\n\n<pre><code>myFormPanel.getForm().submit({\n    clientValidation: true,\n    url: 'updateConsignment.php',\n    params: {\n        newStatus: 'delivered'\n    },\n    success: function(form, action) {\n       <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Success', action.result.msg);\n    },\n    failure: function(form, action) {\n        switch (action.failureType) {\n            case <a href=\"#!/api/Ext.form.action.Action-static-property-CLIENT_INVALID\" rel=\"Ext.form.action.Action-static-property-CLIENT_INVALID\" class=\"docClass\">Ext.form.action.Action.CLIENT_INVALID</a>:\n                <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Failure', 'Form fields may not be submitted with invalid values');\n                break;\n            case <a href=\"#!/api/Ext.form.action.Action-static-property-CONNECT_FAILURE\" rel=\"Ext.form.action.Action-static-property-CONNECT_FAILURE\" class=\"docClass\">Ext.form.action.Action.CONNECT_FAILURE</a>:\n                <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Failure', 'Ajax communication failed');\n                break;\n            case <a href=\"#!/api/Ext.form.action.Action-static-property-SERVER_INVALID\" rel=\"Ext.form.action.Action-static-property-SERVER_INVALID\" class=\"docClass\">Ext.form.action.Action.SERVER_INVALID</a>:\n               <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Failure', action.result.msg);\n       }\n    }\n});\n</code></pre>\n\n<p>would process the following server response for a successful submission:</p>\n\n<pre><code>{\n    \"success\":true, // note this is Boolean, not string\n    \"msg\":\"Consignment updated\"\n}\n</code></pre>\n\n<p>and the following server response for a failed submission:</p>\n\n<pre><code>{\n    \"success\":false, // note this is Boolean, not string\n    \"msg\":\"You do not have permission to perform this operation\"\n}\n</code></pre>\n"},"updateRecord":{"!type":"fn(record?: ?) -> ?","!doc":"<p>Persists the values in this form into the passed Ext.data.Model object in a beginEdit/endEdit block.\nIf the record is not specified, it will attempt to update (if it exists) the record provided to loadRecord.</p>\n"},"actioncomplete":{"!type":"fn(this: ?, action: ?, eOpts: ?)","!doc":"<p>Fires when an action is completed.</p>\n"},"actionfailed":{"!type":"fn(this: ?, action: ?, eOpts: ?)","!doc":"<p>Fires when an action fails.</p>\n"},"beforeaction":{"!type":"fn(this: ?, action: ?, eOpts: ?)","!doc":"<p>Fires before any action is performed. Return false to cancel the action.</p>\n"},"dirtychange":{"!type":"fn(this: ?, dirty: ?, eOpts: ?)","!doc":"<p>Fires when the dirty state of the entire form changes.</p>\n"},"validitychange":{"!type":"fn(this: ?, valid: ?, eOpts: ?)","!doc":"<p>Fires when the validity of the entire form changes.</p>\n"}}},"CheckboxGroup":{"!doc":"<p>A <a href=\"#!/api/Ext.form.FieldContainer\" rel=\"Ext.form.FieldContainer\" class=\"docClass\">field container</a> which has a specialized layout for arranging\n<a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">Ext.form.field.Checkbox</a> controls into columns, and provides convenience\n<a href=\"#!/api/Ext.form.field.Field\" rel=\"Ext.form.field.Field\" class=\"docClass\">Ext.form.field.Field</a> methods for <a href=\"#!/api/Ext.form.CheckboxGroup-method-getValue\" rel=\"Ext.form.CheckboxGroup-method-getValue\" class=\"docClass\">getting</a>, <a href=\"#!/api/Ext.form.CheckboxGroup-method-setValue\" rel=\"Ext.form.CheckboxGroup-method-setValue\" class=\"docClass\">setting</a>,\nand <a href=\"#!/api/Ext.form.CheckboxGroup-method-validate\" rel=\"Ext.form.CheckboxGroup-method-validate\" class=\"docClass\">validating</a> the group of checkboxes as a whole.</p>\n\n<h1>Validation</h1>\n\n<p>Individual checkbox fields themselves have no default validation behavior, but\nsometimes you want to require a user to select at least one of a group of checkboxes. CheckboxGroup\nallows this by setting the config <code><a href=\"#!/api/Ext.form.CheckboxGroup-cfg-allowBlank\" rel=\"Ext.form.CheckboxGroup-cfg-allowBlank\" class=\"docClass\">allowBlank</a>:false</code>; when the user does not check at\nleast one of the checkboxes, the entire group will be highlighted as invalid and the\n<a href=\"#!/api/Ext.form.CheckboxGroup-cfg-blankText\" rel=\"Ext.form.CheckboxGroup-cfg-blankText\" class=\"docClass\">error message</a> will be displayed according to the <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-msgTarget\" rel=\"Ext.form.CheckboxGroup-cfg-msgTarget\" class=\"docClass\">msgTarget</a> config.</p>\n\n<h1>Layout</h1>\n\n<p>The default layout for CheckboxGroup makes it easy to arrange the checkboxes into\ncolumns; see the <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-columns\" rel=\"Ext.form.CheckboxGroup-cfg-columns\" class=\"docClass\">columns</a> and <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-vertical\" rel=\"Ext.form.CheckboxGroup-cfg-vertical\" class=\"docClass\">vertical</a> config documentation for details. You may also\nuse a completely different layout by setting the <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-layout\" rel=\"Ext.form.CheckboxGroup-cfg-layout\" class=\"docClass\">layout</a> to one of the other supported layout\ntypes; for instance you may wish to use a custom arrangement of hbox and vbox containers. In that case\nthe checkbox components at any depth will still be managed by the CheckboxGroup's validation.</p>\n\n<pre class='inline-example '><code>Ext.create('<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>', {\n    title: 'Checkbox Group',\n    width: 300,\n    height: 125,\n    bodyPadding: 10,\n    renderTo: Ext.getBody(),\n    items:[{\n        xtype: 'checkboxgroup',\n        fieldLabel: 'Two Columns',\n        // Arrange checkboxes into two columns, distributed vertically\n        columns: 2,\n        vertical: true,\n        items: [\n            { boxLabel: 'Item 1', name: 'rb', inputValue: '1' },\n            { boxLabel: 'Item 2', name: 'rb', inputValue: '2', checked: true },\n            { boxLabel: 'Item 3', name: 'rb', inputValue: '3' },\n            { boxLabel: 'Item 4', name: 'rb', inputValue: '4' },\n            { boxLabel: 'Item 5', name: 'rb', inputValue: '5' },\n            { boxLabel: 'Item 6', name: 'rb', inputValue: '6' }\n        ]\n    }]\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"allowBlank":{"!type":"bool","!doc":"<p>False to validate that at least one item in the group is checked. If no items are selected at\nvalidation time, <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-blankText\" rel=\"Ext.form.CheckboxGroup-cfg-blankText\" class=\"docClass\">blankText</a> will be used as the error text.</p>\n"},"blankText":{"!type":"string","!doc":"<p>Error text to display if the <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-allowBlank\" rel=\"Ext.form.CheckboxGroup-cfg-allowBlank\" class=\"docClass\">allowBlank</a> validation fails</p>\n"},"columns":{"!doc":"<p>Specifies the number of columns to use when displaying grouped checkbox/radio controls using automatic layout.\nThis config can take several types of values:</p>\n\n<ul>\n<li>'auto' - The controls will be rendered one per column on one row and the width of each column will be evenly\ndistributed based on the width of the overall field container. This is the default.</li>\n<li>Number - If you specific a number (e.g., 3) that number of columns will be created and the contained controls\nwill be automatically distributed based on the value of <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-vertical\" rel=\"Ext.form.CheckboxGroup-cfg-vertical\" class=\"docClass\">vertical</a>.</li>\n<li>Array - You can also specify an array of column widths, mixing integer (fixed width) and float (percentage\nwidth) values as needed (e.g., [100, .25, .75]). Any integer values will be rendered first, then any float\nvalues will be calculated as a percentage of the remaining space. Float values do not have to add up to 1\n(100%) although if you want the controls to take up the entire field container you should do so.</li>\n</ul>\n\n"},"componentCls":{"!type":"string","!doc":"<p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n"},"defaultType":{"!type":"string","!doc":"<p>private</p>\n"},"items":{"!doc":"<p>An Array of <a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">Checkbox</a>es or Checkbox config objects to arrange in the group.</p>\n"},"layout":{"!doc":"<p>private</p>\n"},"name":{"!type":"string"},"vertical":{"!type":"bool","!doc":"<p>True to distribute contained controls across columns, completely filling each column top to bottom before\nstarting on the next column. The number of controls in each column will be automatically calculated to keep\ncolumns as even as possible. The default value is false, so that controls will be added to columns one at a time,\ncompletely filling each row left to right before starting on the next row.</p>\n"},"ariaRole":{"!type":"string","!doc":"<p><editor-fold desc=\"Properties\"></editor></p>\n\n<hr />\n\n<p> Begin Properties</p>\n\n<hr />\n"},"extraFieldBodyCls":{"!type":"string","!doc":"<p>private</p>\n"},"groupCls":{"!type":"string","!doc":"<p>private</p>\n"},"eachBox":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Convenience function which calls the given function for every checkbox in the group</p>\n"},"getBoxes":{"!type":"fn(query?: ?) -> !this","!doc":"<p>Returns all checkbox components within the container</p>\n"},"getChecked":{"!type":"fn() -> ?","!doc":"<p>Returns an Array of all checkboxes in the container which are currently checked</p>\n"},"getErrors":{"!type":"fn() -> ?","!doc":"<p>Runs CheckboxGroup's validations and returns an array of any errors. The only error by default is if allowBlank\nis set to true and no items are checked.</p>\n"},"getModelData":{"!type":"fn() -> ?","!doc":"<p>Don't return any data for the model; the form will get the info from the individual checkboxes themselves.</p>\n"},"getSubmitData":{"!type":"fn() -> ?","!doc":"<p>Don't return any data for submit; the form will get the info from the individual checkboxes themselves.</p>\n"},"getValue":{"!type":"fn() -> !this","!doc":"<p>Returns an object containing the values of all checked checkboxes within the group. Each key-value pair in the\nobject corresponds to a checkbox <a href=\"#!/api/Ext.form.field.Checkbox-cfg-name\" rel=\"Ext.form.field.Checkbox-cfg-name\" class=\"docClass\">name</a>. If there is only one checked checkbox\nwith a particular name, the value of that pair will be the String <a href=\"#!/api/Ext.form.field.Checkbox-cfg-inputValue\" rel=\"Ext.form.field.Checkbox-cfg-inputValue\" class=\"docClass\">inputValue</a> of that checkbox. If there are multiple checked checkboxes with that name, the value of that pair\nwill be an Array of the selected inputValues.</p>\n\n<p>The object format returned from this method can also be passed directly to the <a href=\"#!/api/Ext.form.CheckboxGroup-method-setValue\" rel=\"Ext.form.CheckboxGroup-method-setValue\" class=\"docClass\">setValue</a> method.</p>\n\n<p>NOTE: In Ext 3, this method returned an array of Checkbox components; this was changed to make it more consistent\nwith other field components and with the <a href=\"#!/api/Ext.form.CheckboxGroup-method-setValue\" rel=\"Ext.form.CheckboxGroup-method-setValue\" class=\"docClass\">setValue</a> argument signature. If you need the old behavior in\nExt 4+, use the <a href=\"#!/api/Ext.form.CheckboxGroup-method-getChecked\" rel=\"Ext.form.CheckboxGroup-method-getChecked\" class=\"docClass\">getChecked</a> method instead.</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to callParent in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code>Ext.define('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = Ext.getBody();\n        this.callParent();\n    }\n});\n\nExt.onReady(function() {\n    Ext.create('DynamicButtonText');\n});\n</code></pre>\n"},"initValue":{"!type":"fn() -> !this","!doc":"<p>Initializes the field's value based on the initial config. If the <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-value\" rel=\"Ext.form.CheckboxGroup-cfg-value\" class=\"docClass\">value</a> config is specified then we use\nthat to set the value; otherwise we initialize the originalValue by querying the values of all sub-checkboxes\nafter they have been initialized.</p>\n"},"isDirty":{"!type":"fn() -> bool","!doc":"<p>private override</p>\n"},"isEqual":{"!type":"fn(value1: ?, value2: ?) -> bool","!doc":"<p>private override - the group value is a complex object, compare using object serialization</p>\n"},"onAdd":{"!type":"fn(field: ?) -> !this","!doc":"<p>When a checkbox is added to the group, monitor it for changes</p>\n"},"onRemove":{"!type":"fn(item: ?) -> !this","!doc":"<p>Called when a <a href=\"#!/api/Ext.form.Labelable\" rel=\"Ext.form.Labelable\" class=\"docClass\">Ext.form.Labelable</a> instance is removed from the container's subtree.</p>\n"},"reset":{"!type":"fn() -> !this","!doc":"<p>Resets the checked state of all <a href=\"#!/api/Ext.form.field.Checkbox\" rel=\"Ext.form.field.Checkbox\" class=\"docClass\">checkboxes</a> in the group to their originally\nloaded values and clears any validation messages.\nSee <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a>.<a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a></p>\n"},"resetOriginalValue":{"!type":"fn() -> !this","!doc":"<p>Resets the field's <a href=\"#!/api/Ext.form.CheckboxGroup-property-originalValue\" rel=\"Ext.form.CheckboxGroup-property-originalValue\" class=\"docClass\">originalValue</a> property so it matches the current <a href=\"#!/api/Ext.form.CheckboxGroup-method-getValue\" rel=\"Ext.form.CheckboxGroup-method-getValue\" class=\"docClass\">value</a>. This is\ncalled by <a href=\"#!/api/Ext.form.Basic\" rel=\"Ext.form.Basic\" class=\"docClass\">Ext.form.Basic</a>.<a href=\"#!/api/Ext.form.Basic-method-setValues\" rel=\"Ext.form.Basic-method-setValues\" class=\"docClass\">setValues</a> if the form's\n<a href=\"#!/api/Ext.form.Basic-cfg-trackResetOnLoad\" rel=\"Ext.form.Basic-cfg-trackResetOnLoad\" class=\"docClass\">trackResetOnLoad</a> property is set to true.</p>\n"},"setReadOnly":{"!type":"fn(readOnly: ?) -> !this","!doc":"<p>private override</p>\n"},"setValue":{"!type":"fn(value: ?) -> ?","!doc":"<p>Sets the value(s) of all checkboxes in the group. The expected format is an Object of name-value pairs\ncorresponding to the names of the checkboxes in the group. Each pair can have either a single or multiple values:</p>\n\n<ul>\n<li>A single Boolean or String value will be passed to the <code>setValue</code> method of the checkbox with that name.\nSee the rules in <a href=\"#!/api/Ext.form.field.Checkbox-method-setValue\" rel=\"Ext.form.field.Checkbox-method-setValue\" class=\"docClass\">Ext.form.field.Checkbox.setValue</a> for accepted values.</li>\n<li>An Array of String values will be matched against the <a href=\"#!/api/Ext.form.field.Checkbox-cfg-inputValue\" rel=\"Ext.form.field.Checkbox-cfg-inputValue\" class=\"docClass\">inputValue</a>\nof checkboxes in the group with that name; those checkboxes whose inputValue exists in the array will be\nchecked and others will be unchecked.</li>\n</ul>\n\n\n<p>If a checkbox's name is not in the mapping at all, it will be unchecked.</p>\n\n<p>An example:</p>\n\n<pre><code>var myCheckboxGroup = new <a href=\"#!/api/Ext.form.CheckboxGroup\" rel=\"Ext.form.CheckboxGroup\" class=\"docClass\">Ext.form.CheckboxGroup</a>({\n    columns: 3,\n    items: [{\n        name: 'cb1',\n        boxLabel: 'Single 1'\n    }, {\n        name: 'cb2',\n        boxLabel: 'Single 2'\n    }, {\n        name: 'cb3',\n        boxLabel: 'Single 3'\n    }, {\n        name: 'cbGroup',\n        boxLabel: 'Grouped 1'\n        inputValue: 'value1'\n    }, {\n        name: 'cbGroup',\n        boxLabel: 'Grouped 2'\n        inputValue: 'value2'\n    }, {\n        name: 'cbGroup',\n        boxLabel: 'Grouped 3'\n        inputValue: 'value3'\n    }]\n});\n\nmyCheckboxGroup.setValue({\n    cb1: true,\n    cb3: false,\n    cbGroup: ['value1', 'value3']\n});\n</code></pre>\n\n<p>The above code will cause the checkbox named 'cb1' to be checked, as well as the first and third checkboxes named\n'cbGroup'. The other three checkboxes will be unchecked.</p>\n"},"validate":{"!type":"fn() -> bool","!doc":"<p>Returns whether or not the field value is currently valid by <a href=\"#!/api/Ext.form.CheckboxGroup-method-getErrors\" rel=\"Ext.form.CheckboxGroup-method-getErrors\" class=\"docClass\">validating</a> the field's current\nvalue, and fires the <a href=\"#!/api/Ext.form.CheckboxGroup-event-validitychange\" rel=\"Ext.form.CheckboxGroup-event-validitychange\" class=\"docClass\">validitychange</a> event if the field's validity has changed since the last validation.\n<strong>Note</strong>: <a href=\"#!/api/Ext.form.CheckboxGroup-cfg-disabled\" rel=\"Ext.form.CheckboxGroup-cfg-disabled\" class=\"docClass\">disabled</a> fields are always treated as valid.</p>\n\n<p>Custom implementations of this method are allowed to have side-effects such as triggering error message display.\nTo validate without side-effects, use <a href=\"#!/api/Ext.form.CheckboxGroup-method-isValid\" rel=\"Ext.form.CheckboxGroup-method-isValid\" class=\"docClass\">isValid</a>.</p>\n"}}},"Labelable":{"prototype":{"activeError":{"!type":"string","!doc":"<p>If specified, then the component will be displayed with this value as its active error when first rendered. Use\n<a href=\"#!/api/Ext.form.Labelable-method-setActiveError\" rel=\"Ext.form.Labelable-method-setActiveError\" class=\"docClass\">setActiveError</a> or <a href=\"#!/api/Ext.form.Labelable-method-unsetActiveError\" rel=\"Ext.form.Labelable-method-unsetActiveError\" class=\"docClass\">unsetActiveError</a> to change it after component creation.</p>\n"},"activeErrorsTpl":{"!doc":"<p>The template used to format the Array of error messages passed to <a href=\"#!/api/Ext.form.Labelable-method-setActiveErrors\" rel=\"Ext.form.Labelable-method-setActiveErrors\" class=\"docClass\">setActiveErrors</a> into a single HTML\nstring. if the <a href=\"#!/api/Ext.form.Labelable-cfg-msgTarget\" rel=\"Ext.form.Labelable-cfg-msgTarget\" class=\"docClass\">msgTarget</a> is title, it defaults to a list separated by new lines. Otherwise, it\nrenders each message as an item in an unordered list.</p>\n"},"afterBodyEl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nat the end of the input containing element. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"afterLabelTextTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nafter the label text. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"afterLabelTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nafter the label element. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"afterSubTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nafter the <a href=\"#!/api/Ext.form.Labelable-method-getSubTplMarkup\" rel=\"Ext.form.Labelable-method-getSubTplMarkup\" class=\"docClass\">subTpl markup</a>. If an <code>XTemplate</code> is used, the\ncomponent's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a> serves as the context.</p>\n"},"autoFitErrors":{"!type":"bool","!doc":"<p>Whether to adjust the component's body width to make room for 'side'\n<a href=\"#!/api/Ext.form.Labelable-cfg-msgTarget\" rel=\"Ext.form.Labelable-cfg-msgTarget\" class=\"docClass\">error messages</a>.</p>\n"},"baseBodyCls":{"!type":"string","!doc":"<p>The CSS class to be applied to the body content element.</p>\n"},"beforeBodyEl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nat the beginning of the input containing element. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"beforeLabelTextTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nbefore the label text. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"beforeLabelTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nbefore the label element. If an <code>XTemplate</code> is used, the component's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a>\nserves as the context.</p>\n"},"beforeSubTpl":{"!doc":"<p>An optional string or <code>XTemplate</code> configuration to insert in the field markup\nbefore the <a href=\"#!/api/Ext.form.Labelable-method-getSubTplMarkup\" rel=\"Ext.form.Labelable-method-getSubTplMarkup\" class=\"docClass\">subTpl markup</a>. If an <code>XTemplate</code> is used, the\ncomponent's <a href=\"#!/api/Ext.Component-cfg-renderData\" rel=\"Ext.Component-cfg-renderData\" class=\"docClass\">render data</a> serves as the context.</p>\n"},"errorMsgCls":{"!type":"string","!doc":"<p>The CSS class to be applied to the error message element.</p>\n"},"fieldBodyCls":{"!type":"string","!doc":"<p>An extra CSS class to be applied to the body content element in addition to <a href=\"#!/api/Ext.form.Labelable-cfg-baseBodyCls\" rel=\"Ext.form.Labelable-cfg-baseBodyCls\" class=\"docClass\">baseBodyCls</a>.</p>\n"},"fieldLabel":{"!type":"string","!doc":"<p>The label for the field. It gets appended with the <a href=\"#!/api/Ext.form.Labelable-cfg-labelSeparator\" rel=\"Ext.form.Labelable-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>, and its position and sizing is\ndetermined by the <a href=\"#!/api/Ext.form.Labelable-cfg-labelAlign\" rel=\"Ext.form.Labelable-cfg-labelAlign\" class=\"docClass\">labelAlign</a> and <a href=\"#!/api/Ext.form.Labelable-cfg-labelWidth\" rel=\"Ext.form.Labelable-cfg-labelWidth\" class=\"docClass\">labelWidth</a> configs.</p>\n"},"formItemCls":{"!type":"string","!doc":"<p>A CSS class to be applied to the outermost element to denote that it is participating in the form field layout.</p>\n"},"hideEmptyLabel":{"!type":"bool","!doc":"<p>When set to true, the label element (<a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> and <a href=\"#!/api/Ext.form.Labelable-cfg-labelSeparator\" rel=\"Ext.form.Labelable-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>) will be automatically\nhidden if the <a href=\"#!/api/Ext.form.Labelable-cfg-fieldLabel\" rel=\"Ext.form.Labelable-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a> is empty. Setting this to false will cause the empty label element to be\nrendered and space to be reserved for it; this is useful if you want a field without a label to line up with\nother labeled fields in the same form.</p>\n\n<p>If you wish to unconditionall hide the label even if a non-empty fieldLabel is configured, then set the\n<a href=\"#!/api/Ext.form.Labelabl