/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.wizard.xpl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.components.TextComboBoxCellEditor;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;

public class MavenProjectWizardArchetypeParametersPage
extends AbstractMavenWizardPage {
    public static final String DEFAULT_VERSION = "0.0.1-SNAPSHOT";
    public static final String DEFAULT_PACKAGE = "foo";
    protected Table propertiesTable;
    protected TableViewer propertiesViewer;
    protected TableViewerColumn valueColumn;
    public static final String KEY_PROPERTY = "key";
    public static final int KEY_INDEX = 0;
    public static final String VALUE_PROPERTY = "value";
    public static final int VALUE_INDEX = 1;
    protected Combo groupIdCombo;
    protected Combo artifactIdCombo;
    protected Combo versionCombo;
    protected Combo packageCombo;
    protected Button removeButton;
    private boolean isUsed = true;
    protected Set<String> requiredProperties;
    protected Set<String> optionalProperties;
    protected Archetype archetype;
    protected boolean archetypeChanged = false;
    protected boolean packageCustomized = false;

    public MavenProjectWizardArchetypeParametersPage(ProjectImportConfiguration projectImportConfiguration) {
        super("Maven2ProjectWizardArchifactPage", projectImportConfiguration);
        this.setTitle(Messages.wizardProjectPageMaven2Title);
        this.setDescription(Messages.wizardProjectPageMaven2ArchetypeParametersDescription);
        this.setPageComplete(false);
        this.requiredProperties = new HashSet<String>();
        this.optionalProperties = new HashSet<String>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createArtifactGroup(composite);
        this.createPropertiesGroup(composite);
        this.validate();
        this.createAdvancedSettings(composite, new GridData(4, 128, false, false, 3, 1));
        this.resolverConfigurationComponent.setModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    private void createArtifactGroup(Composite parent) {
        Label groupIdlabel = new Label(parent, 0);
        groupIdlabel.setText(Messages.artifactComponentGroupId);
        this.groupIdCombo = new Combo(parent, 2048);
        this.groupIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.addFieldWithHistory("groupId", this.groupIdCombo);
        this.groupIdCombo.setData("name", (Object)"groupId");
        this.groupIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.updateJavaPackage();
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
        Label artifactIdLabel = new Label(parent, 0);
        artifactIdLabel.setText(Messages.artifactComponentArtifactId);
        this.artifactIdCombo = new Combo(parent, 2048);
        this.artifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.addFieldWithHistory("artifactId", this.artifactIdCombo);
        this.artifactIdCombo.setData("name", (Object)"artifactId");
        this.artifactIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.updateJavaPackage();
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
        Label versionLabel = new Label(parent, 0);
        versionLabel.setText(Messages.artifactComponentVersion);
        this.versionCombo = new Combo(parent, 2048);
        GridData gd_versionCombo = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_versionCombo.widthHint = 150;
        this.versionCombo.setLayoutData((Object)gd_versionCombo);
        this.versionCombo.setText(DEFAULT_VERSION);
        this.addFieldWithHistory("version", this.versionCombo);
        this.versionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
        Label packageLabel = new Label(parent, 0);
        packageLabel.setText(Messages.artifactComponentPackage);
        this.packageCombo = new Combo(parent, 2048);
        this.packageCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.packageCombo.setData("name", (Object)"package");
        this.addFieldWithHistory("package", this.packageCombo);
        this.packageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MavenProjectWizardArchetypeParametersPage.this.packageCustomized && !MavenProjectWizardArchetypeParametersPage.this.packageCombo.getText().equals(MavenProjectWizardArchetypeParametersPage.this.getDefaultJavaPackage())) {
                    MavenProjectWizardArchetypeParametersPage.this.packageCustomized = true;
                }
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
    }

    private void createPropertiesGroup(Composite composite) {
        Label propertiesLabel = new Label(composite, 0);
        propertiesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        propertiesLabel.setText(Messages.MavenProjectWizardArchetypeParametersPage_lblProps);
        this.propertiesViewer = new TableViewer(composite, 67584);
        this.propertiesTable = this.propertiesViewer.getTable();
        this.propertiesTable.setLinesVisible(true);
        this.propertiesTable.setHeaderVisible(true);
        this.propertiesTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        TableColumn propertiesTableNameColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableNameColumn.setWidth(130);
        propertiesTableNameColumn.setText(Messages.MavenProjectWizardArchetypeParametersPage_columnName);
        TableColumn propertiesTableValueColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableValueColumn.setWidth(230);
        propertiesTableValueColumn.setText(Messages.MavenProjectWizardArchetypeParametersPage_columnValue);
        this.propertiesViewer.setColumnProperties(new String[]{KEY_PROPERTY, VALUE_PROPERTY});
        this.propertiesViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.propertiesTable, 0), new TextCellEditor((Composite)this.propertiesTable, 0)});
        this.propertiesViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    ((TableItem)element).setText(MavenProjectWizardArchetypeParametersPage.this.getTextIndex(property), String.valueOf(value));
                    MavenProjectWizardArchetypeParametersPage.this.validate();
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof TableItem) {
                    return ((TableItem)element).getText(MavenProjectWizardArchetypeParametersPage.this.getTextIndex(property));
                }
                return null;
            }
        });
        Button addButton = new Button(composite, 0);
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.setText(Messages.MavenProjectWizardArchetypeParametersPage_btnAdd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.propertiesViewer.editElement((Object)MavenProjectWizardArchetypeParametersPage.this.addTableItem("?", "?"), 0);
            }
        });
        this.removeButton = new Button(composite, 0);
        this.removeButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.removeButton.setText(Messages.MavenProjectWizardArchetypeParametersPage_btnRemove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MavenProjectWizardArchetypeParametersPage.this.propertiesTable.getSelectionCount() > 0) {
                    MavenProjectWizardArchetypeParametersPage.this.propertiesTable.remove(MavenProjectWizardArchetypeParametersPage.this.propertiesTable.getSelectionIndices());
                    MavenProjectWizardArchetypeParametersPage.this.removeButton.setEnabled(MavenProjectWizardArchetypeParametersPage.this.propertiesTable.getItemCount() > 0);
                    MavenProjectWizardArchetypeParametersPage.this.validate();
                }
            }
        });
    }

    protected void validate() {
        String error = this.validateInput();
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private String validateInput() {
        String error = this.validateGroupIdInput(this.groupIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        error = this.validateArtifactIdInput(this.artifactIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        String versionValue = this.versionCombo.getText().trim();
        if (versionValue.length() == 0) {
            return Messages.wizardProjectPageMaven2ValidatorVersion;
        }
        String packageName = this.packageCombo.getText();
        if (packageName.trim().length() != 0 && !Pattern.matches("[A-Za-z_$][A-Za-z_$\\d]*(?:\\.[A-Za-z_$][A-Za-z_$\\d]*)*", packageName)) {
            return Messages.MavenProjectWizardArchetypeParametersPage_error_package;
        }
        IStatus nameStatus = this.getImportConfiguration().validateProjectName(this.getModel());
        if (!nameStatus.isOK()) {
            return NLS.bind((String)Messages.wizardProjectPageMaven2ValidatorProjectNameInvalid, (Object)nameStatus.getMessage());
        }
        if (this.requiredProperties.size() > 0) {
            Properties properties = this.getProperties();
            for (String key : this.requiredProperties) {
                String value = properties.getProperty(key);
                if (value != null && value.length() != 0) continue;
                return NLS.bind((String)Messages.wizardProjectPageMaven2ValidatorRequiredProperty, (Object)key);
            }
        }
        return null;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setArchetype(Archetype archetype) {
        if (archetype == null) {
            if (this.propertiesTable != null) {
                this.propertiesTable.removeAll();
            }
            this.archetypeChanged = false;
        } else if (!MavenProjectWizardArchetypeParametersPage.areEqual(archetype, this.archetype)) {
            this.archetype = archetype;
            this.requiredProperties.clear();
            this.optionalProperties.clear();
            this.archetypeChanged = true;
            if (this.propertiesTable != null) {
                this.propertiesTable.removeAll();
                Properties properties = archetype.getProperties();
                if (properties != null) {
                    for (Map.Entry<Object, Object> e : properties.entrySet()) {
                        String key = (String)e.getKey();
                        this.addTableItem(key, (String)e.getValue());
                        this.optionalProperties.add(key);
                    }
                }
            }
        }
    }

    void loadArchetypeDescriptor() {
        try {
            RequiredPropertiesLoader propertiesLoader = new RequiredPropertiesLoader(this.archetype);
            this.getContainer().run(true, true, (IRunnableWithProgress)propertiesLoader);
            List<?> properties = propertiesLoader.getProperties();
            if (properties != null) {
                for (Object o : properties) {
                    if (!(o instanceof RequiredProperty)) continue;
                    RequiredProperty rp = (RequiredProperty)o;
                    this.requiredProperties.add(rp.getKey());
                    this.addTableItem(rp.getKey(), rp.getDefaultValue());
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypeParametersPage_error_download, (Object)MavenProjectWizardArchetypeParametersPage.getName(this.archetype));
            MavenProjectExamplesActivator.log(ex, msg);
            this.setErrorMessage(String.valueOf(msg) + "\n" + ex.toString());
        }
    }

    static String getName(Archetype archetype) {
        String groupId = archetype.getGroupId();
        String artifactId = archetype.getArtifactId();
        String version = archetype.getVersion();
        return String.valueOf(groupId) + ":" + artifactId + ":" + version;
    }

    TableItem addTableItem(String key, String value) {
        TableItem item = new TableItem(this.propertiesTable, 0);
        item.setData((Object)item);
        item.setText(0, key);
        item.setText(1, value == null ? "" : value);
        return item;
    }

    public void setProjectName(String projectName) {
        if (this.artifactIdCombo.getText().equals(this.groupIdCombo.getText())) {
            this.groupIdCombo.setText(projectName);
        }
        this.artifactIdCombo.setText(projectName);
        this.packageCombo.setText("org." + projectName.replace('-', '.'));
        this.validate();
    }

    public void setParentProject(String groupId, String artifactId, String version) {
        this.groupIdCombo.setText(groupId);
        this.versionCombo.setText(version);
        this.validate();
    }

    public void setArtifactIdEnabled(boolean b) {
        this.artifactIdCombo.setEnabled(b);
    }

    public String getJavaPackage() {
        if (this.packageCombo.getText().length() > 0) {
            return this.packageCombo.getText();
        }
        return this.getDefaultJavaPackage();
    }

    protected void updateJavaPackage() {
        if (this.packageCustomized) {
            return;
        }
        String defaultPackageName = this.getDefaultJavaPackage();
        this.packageCombo.setText(defaultPackageName);
    }

    protected String getDefaultJavaPackage() {
        return MavenProjectWizardArchetypeParametersPage.getDefaultJavaPackage(this.groupIdCombo.getText().trim(), this.artifactIdCombo.getText().trim());
    }

    public Model getModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupIdCombo.getText());
        model.setArtifactId(this.artifactIdCombo.getText());
        model.setVersion(this.versionCombo.getText());
        return model;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        return !this.isUsed || super.isPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.groupIdCombo.getText().length() == 0 && this.groupIdCombo.getItemCount() > 0) {
                this.groupIdCombo.setText(this.groupIdCombo.getItem(0));
                this.packageCombo.setText(this.getDefaultJavaPackage());
                this.packageCustomized = false;
            }
            if (this.archetypeChanged && this.archetype != null) {
                this.archetypeChanged = false;
                this.loadArchetypeDescriptor();
                this.validate();
            }
            this.updatePropertyEditors();
        }
    }

    public Properties getProperties() {
        if (this.propertiesViewer.isCellEditorActive()) {
            this.propertiesTable.setFocus();
        }
        Properties properties = new Properties();
        int i = 0;
        while (i < this.propertiesTable.getItemCount()) {
            TableItem item = this.propertiesTable.getItem(i);
            properties.put(item.getText(0), item.getText(1));
            ++i;
        }
        return properties;
    }

    public int getTextIndex(String property) {
        return KEY_PROPERTY.equals(property) ? 0 : 1;
    }

    public void updatePropertyEditors() {
        CellEditor[] ce = this.propertiesViewer.getCellEditors();
        int n = this.requiredProperties.size() + this.optionalProperties.size();
        if (n == 0) {
            if (ce[0] instanceof TextComboBoxCellEditor) {
                ce[0].dispose();
                ce[0] = new TextCellEditor((Composite)this.propertiesTable, 0x800000);
            }
        } else {
            TextComboBoxCellEditor comboEditor = null;
            if (ce[0] instanceof TextComboBoxCellEditor) {
                comboEditor = (TextComboBoxCellEditor)ce[0];
            } else {
                ce[0].dispose();
                comboEditor = new TextComboBoxCellEditor((Composite)this.propertiesTable, 0x800000);
                ce[0] = comboEditor;
            }
            ArrayList<String> propertyKeys = new ArrayList<String>(n);
            propertyKeys.addAll(this.requiredProperties);
            propertyKeys.addAll(this.optionalProperties);
            comboEditor.setItems(propertyKeys.toArray(new String[n]));
        }
    }

    public static String getDefaultJavaPackage(String groupId, String artifactId) {
        return org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypeParametersPage.getDefaultJavaPackage((String)groupId, (String)artifactId);
    }

    public static ArtifactRepository getArchetypeRepository(Archetype archetype) throws CoreException {
        String repoUrl = archetype.getRepository();
        if (repoUrl == null || repoUrl.trim().isEmpty()) {
            return null;
        }
        return MavenPlugin.getMaven().createArtifactRepository(String.valueOf(archetype.getArtifactId()) + "-repo", repoUrl);
    }

    public static List<?> getRequiredProperties(Archetype archetype, ArtifactRepository remoteArchetypeRepository, IProgressMonitor monitor) throws UnknownArchetype, CoreException {
        Assert.isNotNull((Object)archetype, (String)"Archetype can not be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String groupId = archetype.getGroupId();
        String artifactId = archetype.getArtifactId();
        String version = archetype.getVersion();
        IMaven maven = MavenPlugin.getMaven();
        ArtifactRepository localRepository = maven.getLocalRepository();
        List<ArtifactRepository> repositories = remoteArchetypeRepository == null ? maven.getArtifactRepositories() : Collections.singletonList(remoteArchetypeRepository);
        MavenSession session = maven.createSession(maven.createExecutionRequest(monitor), null);
        MavenSession oldSession = MavenPluginActivator.getDefault().setSession(session);
        ArchetypeArtifactManager aaMgr = MavenPluginActivator.getDefault().getArchetypeArtifactManager();
        List properties = null;
        try {
            if (aaMgr.isFileSetArchetype(groupId, artifactId, version, null, localRepository, repositories)) {
                ArchetypeDescriptor descriptor = aaMgr.getFileSetArchetypeDescriptor(groupId, artifactId, version, null, localRepository, repositories);
                properties = descriptor.getRequiredProperties();
            }
        }
        finally {
            MavenPluginActivator.getDefault().setSession(oldSession);
        }
        return properties;
    }

    public static boolean areEqual(Archetype one, Archetype another) {
        if (one == another) {
            return true;
        }
        if (another == null) {
            return false;
        }
        return StringUtils.equals((String)one.getGroupId(), (String)another.getGroupId()) && StringUtils.equals((String)one.getArtifactId(), (String)another.getArtifactId()) && StringUtils.equals((String)one.getVersion(), (String)another.getVersion());
    }

    private static class RequiredPropertiesLoader
    implements IRunnableWithProgress {
        private Archetype archetype;
        private List<?> properties;

        RequiredPropertiesLoader(Archetype archetype) {
            this.archetype = archetype;
        }

        List<?> getProperties() {
            return this.properties;
        }

        public void run(IProgressMonitor monitor) {
            String archetypeName = MavenProjectWizardArchetypeParametersPage.getName(this.archetype);
            monitor.beginTask(NLS.bind((String)Messages.MavenProjectWizardArchetypeParametersPage_task, (Object)archetypeName), -1);
            try {
                try {
                    ArtifactRepository remoteArchetypeRepository = MavenProjectWizardArchetypeParametersPage.getArchetypeRepository(this.archetype);
                    this.properties = MavenProjectWizardArchetypeParametersPage.getRequiredProperties(this.archetype, remoteArchetypeRepository, monitor);
                }
                catch (UnknownArchetype e) {
                    String msg = NLS.bind((String)"Error downloading archetype {0}", (Object)archetypeName);
                    MavenProjectExamplesActivator.log(e, msg);
                    monitor.done();
                }
                catch (CoreException ex) {
                    MavenProjectExamplesActivator.log(ex, ex.getMessage());
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

