/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.settings.MavenSettingsChangeListener;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.maven.project.examples.utils.MavenArtifactHelper;
import org.jboss.tools.maven.project.examples.wizard.ArchetypeExamplesWizardFirstPage;
import org.jboss.tools.maven.project.examples.wizard.MissingRepositoryWarningComponent;
import org.jboss.tools.maven.project.examples.wizard.xpl.MavenProjectWizardArchetypeParametersPage;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.WizardContext;

public class ArchetypeExamplesWizardPage
extends MavenProjectWizardArchetypeParametersPage
implements IProjectExamplesWizardPage,
MavenSettingsChangeListener {
    private ProjectExample projectDescription;
    private ProjectExample projectExample;
    private boolean initialized = false;
    private Map<String, Object> propertiesMap = new HashMap<String, Object>();
    private WizardContext context;
    private MissingRepositoryWarningComponent warningComponent;
    private IStatus enterpriseRepoStatus;
    private ArchetypeModel archetypeModel;

    public ArchetypeExamplesWizardPage() {
        super(new ProjectImportConfiguration());
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.packageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArchetypeExamplesWizardPage.this.isCurrentPage()) {
                    ArchetypeExamplesWizardPage.this.context.setProperty("package", (Object)ArchetypeExamplesWizardPage.this.packageCombo.getText());
                }
            }
        });
        this.artifactIdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArchetypeExamplesWizardPage.this.isCurrentPage()) {
                    ArchetypeExamplesWizardPage.this.context.setProperty("projectName", (Object)ArchetypeExamplesWizardPage.this.artifactIdCombo.getText());
                }
                ArchetypeExamplesWizardPage.this.validate();
            }
        });
        if (this.projectExample != null && !this.initialized) {
            this.initializeArchetype();
        }
        MavenCoreActivator.getDefault().registerMavenSettingsChangeListener((MavenSettingsChangeListener)this);
    }

    protected void initializeArchetype() {
        if (this.getContainer() == null || this.archetypeModel == null) {
            return;
        }
        Archetype archetype = new Archetype();
        archetype.setGroupId(this.archetypeModel.getArchetypeGroupId());
        archetype.setArtifactId(this.archetypeModel.getArchetypeArtifactId());
        archetype.setVersion(this.archetypeModel.getArchetypeVersion());
        archetype.setRepository(this.archetypeModel.getArchetypeRepository());
        if (ArchetypeExamplesWizardPage.areEqual(archetype, this.archetype) && this.initialized) {
            return;
        }
        Properties defaultRequiredProperties = this.getRequiredProperties(archetype, this.archetypeModel.getArchetypeRepository());
        Properties properties = new Properties();
        for (Object key : defaultRequiredProperties.keySet()) {
            properties.put(key, defaultRequiredProperties.get(key));
        }
        for (Object key : this.archetypeModel.getArchetypeProperties().keySet()) {
            properties.put(key, this.archetypeModel.getArchetypeProperties().get(key));
        }
        archetype.setProperties(properties);
        this.setArchetype(archetype);
        this.archetypeChanged = false;
        if (this.resolverConfigurationComponent != null) {
            this.resolverConfigurationComponent.setExpanded(!this.resolverConfigurationComponent.getResolverConfiguration().getActiveProfileList().isEmpty());
        }
        if (this.propertiesTable != null) {
            this.initialized = true;
        }
        this.context.setProperty("hasEnterpriseProperty", (Object)defaultRequiredProperties.containsKey("enterprise"));
        Object enterpriseValue = this.context.getProperty("enterprise");
        Boolean enterprise = enterpriseValue instanceof Boolean ? (Boolean)enterpriseValue : Boolean.FALSE;
        this.updateArchetypeProperty("enterprise", enterprise.toString());
    }

    protected void createAdvancedSettings(Composite composite, GridData gridData) {
        super.createAdvancedSettings(composite, gridData);
        this.warningComponent = new MissingRepositoryWarningComponent(composite);
    }

    public Archetype getArchetype() {
        return this.archetype;
    }

    private Properties getRequiredProperties(Archetype archetype, final String archetypeRepositoryUrl) {
        final String groupId = archetype.getGroupId();
        final String artifactId = archetype.getArtifactId();
        final String version = archetype.getVersion();
        final String archetypeName = String.valueOf(groupId) + ":" + artifactId + ":" + version;
        final Properties requiredProperties = new Properties();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(NLS.bind((String)"Downloading Archetype {0}", (Object)archetypeName), -1);
                    try {
                        try {
                            List properties;
                            IMaven maven = MavenPlugin.getMaven();
                            List repositories = maven.getArtifactRepositories();
                            ArtifactRepository archetypeRepository = null;
                            if (StringUtils.isNotEmpty((String)archetypeRepositoryUrl)) {
                                archetypeRepository = maven.createArtifactRepository("archetypeRepo", archetypeRepositoryUrl);
                            }
                            Artifact a = ArchetypeExamplesWizardPage.this.downloadArchetype(groupId, artifactId, version, archetypeRepository, repositories);
                            ArchetypeArtifactManager aaMgr = MavenPluginActivator.getDefault().getArchetypeArtifactManager();
                            ArchetypeDescriptor descriptor = aaMgr.getFileSetArchetypeDescriptor(a.getFile());
                            if (descriptor != null && descriptor.getName() != null && (properties = descriptor.getRequiredProperties()) != null) {
                                for (Object o : properties) {
                                    if (!(o instanceof RequiredProperty)) continue;
                                    RequiredProperty rp = (RequiredProperty)o;
                                    requiredProperties.put(rp.getKey(), rp.getDefaultValue());
                                }
                            }
                        }
                        catch (UnknownArchetype e) {
                            MavenProjectExamplesActivator.log(e);
                            monitor.done();
                        }
                        catch (CoreException ex) {
                            MavenProjectExamplesActivator.log(ex);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String msg = NLS.bind((String)"Error downloading archetype {0}", (Object)archetypeName);
            MavenProjectExamplesActivator.log(ex, msg);
            this.setErrorMessage(String.valueOf(msg) + "\n" + ex.toString());
        }
        return requiredProperties;
    }

    private Artifact downloadArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, List<ArtifactRepository> repositories) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        if (archetypeRepository != null) {
            repos.add(archetypeRepository);
        }
        repos.addAll(maven.getArtifactRepositories());
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        maven.resolve(groupId, artifactId, version, "pom", null, repos, (IProgressMonitor)nullProgressMonitor);
        Artifact a = maven.resolve(groupId, artifactId, version, "jar", null, repos, (IProgressMonitor)nullProgressMonitor);
        return a;
    }

    public void updateArchetypeProperty(String key, String value) {
        if (this.propertiesTable == null) {
            return;
        }
        int i = 0;
        while (i < this.propertiesTable.getItemCount()) {
            TableItem item = this.propertiesTable.getItem(i);
            if (item.getText(0).equals(key) && !item.getText(1).equals(value)) {
                item.setText(1, value);
            }
            ++i;
        }
    }

    public void setArtifactId(String projectName) {
        if (this.artifactIdCombo != null && !this.artifactIdCombo.getText().equals(projectName)) {
            this.artifactIdCombo.setText(projectName);
        }
    }

    public void setPackageName(String packageName) {
        if (this.packageCombo != null) {
            if (!this.packageCombo.getText().equals(packageName)) {
                this.packageCombo.setText(packageName);
            }
            if (!this.isCurrentPage() && !this.groupIdCombo.getText().equals(packageName)) {
                this.groupIdCombo.setText(packageName);
            }
        }
    }

    @Override
    protected void validate() {
        if (this.getControl() != null && this.getControl().isVisible()) {
            this.checkEnterpriseProperty();
        }
        super.validate();
    }

    private void checkEnterpriseProperty() {
        if (this.warningComponent == null || this.warningComponent.isDisposed() || this.propertiesTable.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.propertiesTable.getItemCount()) {
            TableItem item = this.propertiesTable.getItem(i);
            String value = item.getText(1);
            if (item.getText(0).equals("enterprise")) {
                this.warningComponent.setLinkText("");
                if (Boolean.TRUE.toString().equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
                    if (this.enterpriseRepoStatus == null) {
                        this.enterpriseRepoStatus = MavenArtifactHelper.checkRequirementsAvailable(this.projectExample);
                    }
                    if (!this.enterpriseRepoStatus.isOK()) {
                        this.warningComponent.setLinkText(this.enterpriseRepoStatus.getMessage());
                    }
                }
                return;
            }
            ++i;
        }
    }

    private Throwable getRootCause(Throwable ex) {
        if (ex == null) {
            return null;
        }
        Throwable rootCause = this.getRootCause(ex.getCause());
        if (rootCause == null) {
            rootCause = ex;
        }
        return rootCause;
    }

    public boolean finishPage() {
        Model model = this.getModel();
        final String groupId = model.getGroupId();
        final String artifactId = model.getArtifactId();
        final String version = model.getVersion();
        final String javaPackage = this.getJavaPackage();
        final Properties properties = this.getProperties();
        final Archetype archetype = this.getArchetype();
        ArchetypeExamplesWizardFirstPage simplePage = this.getSimplePage();
        if (simplePage == null) {
            MavenProjectExamplesActivator.log("Cannot import maven archetype");
            return false;
        }
        final ProjectImportConfiguration configuration = this.getImportConfiguration();
        String projectName = configuration.getProjectName(model);
        this.propertiesMap.put("projectName", projectName);
        ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        final IPath location = simplePage.getLocationPath();
        this.propertiesMap.put("locationPath", location);
        this.propertiesMap.put("artifactId", artifactId);
        ResourcesPlugin.getWorkspace();
        boolean pomExists = location.append(projectName).append("pom.xml").toFile().exists();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)Messages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MavenPlugin.getMaven().execute((ICallable)new ICallable<Void>(){

                    public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                        this.ensureArchetyperCacheIsLoaded(archetype);
                        MavenPlugin.getProjectConfigurationManager().createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, monitor);
                        return null;
                    }
                }, monitor);
            }

            private void ensureArchetyperCacheIsLoaded(Archetype archetype2) throws CoreException {
                IMaven maven = MavenPlugin.getMaven();
                ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
                repos.addAll(maven.getArtifactRepositories());
                ArtifactRepository archetypeRepository = null;
                if (StringUtils.isNotBlank((String)archetype2.getRepository())) {
                    archetypeRepository = maven.createArtifactRepository(String.valueOf(archetype2.getArtifactId()) + "-repo", archetype2.getRepository().trim());
                    repos.add(0, archetypeRepository);
                }
                ArchetypeArtifactManager aam = MavenPluginActivator.getDefault().getArchetypeArtifactManager();
                aam.exists(archetype2.getGroupId(), archetype2.getArtifactId(), archetype2.getVersion(), archetypeRepository, maven.getLocalRepository(), repos);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            ProjectExamplesActivator.log((Throwable)e);
            return true;
        }
        catch (InvocationTargetException e) {
            ProjectExamplesActivator.log((Throwable)e);
            Throwable ex = e.getTargetException();
            String message = ex.getMessage();
            Throwable rootCause = this.getRootCause(ex);
            if (rootCause != null) {
                message = String.valueOf(message) + "\nRoot cause : " + rootCause.getMessage();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            return true;
        }
        return true;
    }

    private ArchetypeExamplesWizardFirstPage getSimplePage() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getWizard().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof ArchetypeExamplesWizardFirstPage) {
                return (ArchetypeExamplesWizardFirstPage)page;
            }
            ++n2;
        }
        return null;
    }

    public String getProjectExampleType() {
        return "mavenArchetype";
    }

    public void setProjectExample(ProjectExampleWorkingCopy projectExample) {
        this.projectExample = projectExample;
        if (projectExample != null) {
            String profiles;
            ProjectImportConfiguration configuration;
            if (projectExample.getShortDescription() != null) {
                this.setTitle(projectExample.getShortDescription());
            }
            if (projectExample.getHeadLine() != null) {
                this.setDescription(ProjectExamplesActivator.getShortDescription((String)projectExample.getHeadLine()));
            }
            if ((configuration = this.getImportConfiguration()) != null && (profiles = projectExample.getDefaultProfiles()) != null && profiles.trim().length() > 0) {
                configuration.getResolverConfiguration().setActiveProfiles(profiles);
            }
            this.projectDescription = projectExample;
            this.archetypeModel = (ArchetypeModel)this.context.getProperty("archetypeModel");
            if (this.archetypeModel == null) {
                this.archetypeModel = projectExample.getArchetypeModel();
            }
            this.initializeArchetype();
        }
    }

    public Map<String, Object> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void onWizardContextChange(String key, Object value) {
        if ("projectName".equals(key)) {
            String artifactId = value == null ? "" : value.toString();
            this.setArtifactId(artifactId);
        } else if ("package".equals(key)) {
            String packageName = value == null ? "" : value.toString();
            this.setPackageName(packageName);
        } else if ("enterprise".equals(key)) {
            Boolean enterprise = Boolean.FALSE;
            if (value instanceof Boolean) {
                enterprise = (Boolean)value;
            }
            this.updateArchetypeProperty("enterprise", enterprise.toString());
            this.checkEnterpriseProperty();
        } else if ("enterpriseRepoStatus".equals(key)) {
            this.enterpriseRepoStatus = (IStatus)value;
            this.checkEnterpriseProperty();
        } else if ("archetypeModel".equals(key) && value instanceof ArchetypeModel) {
            this.archetypeModel = (ArchetypeModel)value;
            if (this.getControl() != null) {
                this.initializeArchetype();
            }
        }
    }

    public void setWizardContext(WizardContext context) {
        this.context = context;
        context.setProperty("importProjectConfiguration", (Object)this.getImportConfiguration());
        context.setProperty("mavenModel", (Object)this.getDynamicModel());
    }

    private Model getDynamicModel() {
        Model model = new Model(){

            public String getModelVersion() {
                return "4.0.0";
            }

            public String getGroupId() {
                return ArchetypeExamplesWizardPage.this.groupIdCombo.getText();
            }

            public String getArtifactId() {
                return ArchetypeExamplesWizardPage.this.artifactIdCombo.getText();
            }

            public String getVersion() {
                return ArchetypeExamplesWizardPage.this.versionCombo.getText();
            }
        };
        return model;
    }

    public String getPageType() {
        return "extra";
    }

    public void dispose() {
        MavenCoreActivator.getDefault().unregisterMavenSettingsChangeListener((MavenSettingsChangeListener)this);
        super.dispose();
    }

    public void onSettingsChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArchetypeExamplesWizardPage.this.enterpriseRepoStatus = null;
                ArchetypeExamplesWizardPage.this.checkEnterpriseProperty();
            }
        });
    }
}

