/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.maven.project.examples.AbstractImportMavenProjectDelegate;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.project.examples.internal.UnArchiver;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.model.ProjectImportUtil;

public class ImportMavenProjectExampleDelegate
extends AbstractImportMavenProjectDelegate {
    private static final String UNNAMED_PROJECTS = "UnnamedProjects";
    private boolean confirm;

    @Override
    public boolean importProject(ProjectExampleWorkingCopy projectDescription, File file, Map<String, Object> propertiesMap, IProgressMonitor monitor) throws Exception {
        Collection standardProjects;
        ProjectImportUtil importer;
        List<String> projectNames;
        IPath path;
        File destination;
        IPath rootPath;
        IPath mavenProjectsRoot = rootPath = this.getLocation();
        String projectName = projectDescription.getName();
        if (projectName == null || projectName.trim().isEmpty()) {
            projectName = UNNAMED_PROJECTS;
        }
        if ((destination = new File((path = mavenProjectsRoot.append(projectName)).toOSString())).exists()) {
            final List<IProject> existingProjects = this.getExistingProjects(destination);
            if (existingProjects.size() > 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String title = existingProjects.size() > 1 ? "Warning: Projects already exist" : "Warning: Project already exists";
                        String msg = ImportMavenProjectExampleDelegate.this.getMessage(destination, existingProjects);
                        ImportMavenProjectExampleDelegate.this.confirm = MessageDialog.openQuestion((Shell)ImportMavenProjectExampleDelegate.getActiveShell(), (String)title, (String)msg);
                    }
                });
                if (this.confirm) {
                    monitor.setTaskName("Deleting ...");
                    for (IProject project : existingProjects) {
                        monitor.setTaskName("Deleting " + project.getName());
                        project.delete(false, true, monitor);
                    }
                } else {
                    return false;
                }
            }
            boolean deleted = ImportMavenProjectExampleDelegate.deleteDirectory(destination, monitor);
            if (monitor.isCanceled()) {
                return false;
            }
            if (!deleted) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)ImportMavenProjectExampleDelegate.getActiveShell(), (String)"Error", (String)("Cannot delete the '" + destination + "' file."));
                    }
                });
                return false;
            }
        }
        boolean ok = false;
        if (file.isFile()) {
            UnArchiver unarchiver = UnArchiver.create((File)file, (File)destination);
            unarchiver.setFilters(projectDescription.getImportFilter());
            ok = unarchiver.extract(monitor);
        } else if (file.isDirectory()) {
            destination.mkdirs();
            IFileStore descStore = EFS.getLocalFileSystem().fromLocalFile(destination);
            IFileStore srcStore = EFS.getLocalFileSystem().fromLocalFile(file);
            try {
                srcStore.copy(descStore, 2, monitor);
                ok = true;
            }
            catch (Exception e) {
                MavenProjectExamplesActivator.log(e);
            }
        }
        monitor.setTaskName("");
        if (monitor.isCanceled()) {
            return false;
        }
        if (!ok) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)ImportMavenProjectExampleDelegate.getActiveShell(), (String)"Error", (String)"Cannot extract/copy the archive.");
                }
            });
            return false;
        }
        ArrayList originalProjects = projectDescription.getIncludedProjects();
        if (originalProjects == null) {
            originalProjects = new ArrayList();
        }
        ArrayList<String> includedProjects = new ArrayList<String>();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean configureSeam = store.getBoolean("configureSeam");
        boolean configurePortlet = store.getBoolean("configurePortlet");
        boolean configureJSFPortlet = store.getBoolean("configureJSFPortlet");
        boolean configureSeamPortlet = store.getBoolean("configureSeamPortlet");
        boolean configureCDI = store.getBoolean("configureCDI");
        boolean configureHibernate = store.getBoolean("configureHibernate");
        try {
            store.setValue("configureSeam", false);
            store.setValue("configurePortlet", false);
            store.setValue("configureJSFPortlet", false);
            store.setValue("configureSeamPortlet", false);
            store.setValue("configureCDI", false);
            store.setValue("configureHibernate", false);
            projectNames = this.importMavenProjects(destination, (ProjectExample)projectDescription, monitor);
        }
        finally {
            store.setValue("configureSeam", configureSeam);
            store.setValue("configurePortlet", configurePortlet);
            store.setValue("configureJSFPortlet", configureJSFPortlet);
            store.setValue("configureSeamPortlet", configureSeamPortlet);
            store.setValue("configureCDI", configureCDI);
            store.setValue("configureHibernate", configureHibernate);
        }
        new OpenMavenConsoleAction().run();
        if (projectNames != null && !projectNames.isEmpty()) {
            includedProjects.addAll(projectNames);
        }
        ImportMavenProjectExampleDelegate.waitForMavenJobs(monitor);
        MavenProjectExamplesActivator.updateMavenConfiguration(projectName, includedProjects, monitor);
        if (includedProjects.isEmpty() && new File(destination, ".project").exists()) {
            importer = new ProjectImportUtil();
            ArrayList<String> names = new ArrayList<String>();
            names.add(projectName);
            Collection standardProjects2 = importer.importProjects(path, names, monitor);
            if (standardProjects2 != null) {
                for (IProject p : standardProjects2) {
                    includedProjects.add(p.getName());
                }
            }
        }
        if (!originalProjects.isEmpty() && (standardProjects = (importer = new ProjectImportUtil()).importProjects(path, originalProjects, monitor)) != null) {
            for (IProject p : standardProjects) {
                includedProjects.add(p.getName());
            }
        }
        projectDescription.setIncludedProjects(includedProjects);
        return true;
    }

    private static void waitForMavenJobs(IProgressMonitor monitor) throws InterruptedException, CoreException {
        Job[] jobs = Job.getJobManager().find(null);
        if (jobs != null) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job instanceof IBackgroundProcessingQueue) {
                    IStatus status;
                    IBackgroundProcessingQueue queue = (IBackgroundProcessingQueue)job;
                    queue.join();
                    if (!queue.isEmpty() && !(status = queue.run(monitor)).isOK()) {
                        throw new CoreException(status);
                    }
                    if (queue.isEmpty()) {
                        queue.cancel();
                    }
                }
                ++n2;
            }
        }
    }

    private List<String> importMavenProjects(File destination, ProjectExample projectDescription, IProgressMonitor monitor) {
        ArrayList<String> projectNames = new ArrayList<String>();
        try {
            List list;
            AbstractProjectScanner<MavenProjectInfo> projectScanner = this.getProjectScanner(destination);
            projectScanner.run(monitor);
            List mavenProjects = projectScanner.getProjects();
            ArrayList<MavenProjectInfo> infos = new ArrayList<MavenProjectInfo>();
            infos.addAll(mavenProjects);
            this.addMavenProjects(infos, mavenProjects);
            final ArrayList<Object> existingProjects = new ArrayList<Object>();
            ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration();
            String profiles = projectDescription.getDefaultProfiles();
            if (profiles != null && profiles.trim().length() > 0) {
                importConfiguration.getResolverConfiguration().setSelectedProfiles(profiles);
            }
            for (MavenProjectInfo mavenProjectInfo : infos) {
                String projectName = MavenProjectExamplesActivator.getProjectName(mavenProjectInfo, importConfiguration);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null || !project.exists()) continue;
                existingProjects.add(project);
            }
            if (existingProjects.size() > 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = ImportMavenProjectExampleDelegate.this.getWorkspaceMessage(existingProjects);
                        ImportMavenProjectExampleDelegate.this.confirm = MessageDialog.openConfirm((Shell)ImportMavenProjectExampleDelegate.getActiveShell(), (String)"Confirmation", (String)message);
                    }
                });
                if (this.confirm) {
                    for (IProject iProject : existingProjects) {
                        try {
                            iProject.refreshLocal(2, monitor);
                        }
                        catch (Exception exception) {}
                        iProject.delete(true, true, monitor);
                    }
                } else {
                    return projectNames;
                }
            }
            if ((list = projectDescription.getIncludedProjects()) != null && list.size() > 0) {
                ArrayList<MavenProjectInfo> newInfos = new ArrayList<MavenProjectInfo>();
                for (MavenProjectInfo info : infos) {
                    Model model = info.getModel();
                    if (model == null || model.getArtifactId() == null || model.getArtifactId().trim().length() <= 0) continue;
                    for (String includedProject : list) {
                        if (!model.getArtifactId().equals(includedProject)) continue;
                        newInfos.add(info);
                    }
                }
                infos = newInfos;
            }
            MavenPlugin.getProjectConfigurationManager().importProjects(infos, importConfiguration, monitor);
            for (MavenProjectInfo info : infos) {
                IMavenProjectFacade f;
                Model model = info.getModel();
                if (model == null || model.getArtifactId() == null || model.getArtifactId().trim().length() <= 0 || (f = MavenPlugin.getMavenProjectRegistry().getMavenProject(model.getGroupId(), model.getArtifactId(), model.getVersion())) == null || f.getProject() == null) continue;
                projectNames.add(f.getProject().getName());
            }
        }
        catch (CoreException ex) {
            MavenProjectExamplesActivator.log(ex, "Projects imported with errors");
            return projectNames;
        }
        catch (InterruptedException e) {
            MavenProjectExamplesActivator.log(e, "Projects imported with errors");
            return projectNames;
        }
        return projectNames;
    }

    private List<MavenProjectInfo> addMavenProjects(List<MavenProjectInfo> infos, List<MavenProjectInfo> mavenProjects) {
        if (mavenProjects == null || mavenProjects.isEmpty()) {
            return mavenProjects;
        }
        for (MavenProjectInfo projectInfo : mavenProjects) {
            Collection projects = projectInfo.getProjects();
            if (projects == null || projects.isEmpty()) continue;
            for (MavenProjectInfo info : projects) {
                infos.add(info);
            }
            ArrayList<MavenProjectInfo> childProjects = new ArrayList<MavenProjectInfo>();
            childProjects.addAll(projects);
            this.addMavenProjects(infos, childProjects);
        }
        return mavenProjects;
    }

    private AbstractProjectScanner<MavenProjectInfo> getProjectScanner(File folder) {
        File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        MavenPlugin mavenPlugin = MavenPlugin.getDefault();
        MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
        return new LocalProjectScanner(root, folder.getAbsolutePath(), false, modelManager);
    }

    private static Shell getActiveShell() {
        return Display.getDefault().getActiveShell();
    }

    private static boolean deleteDirectory(File path, IProgressMonitor monitor) {
        if (path.exists()) {
            File[] files;
            File[] fileArray = files = path.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.setTaskName("Deleting " + file);
                if (file.isDirectory()) {
                    ImportMavenProjectExampleDelegate.deleteDirectory(file, monitor);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return path.delete();
    }

    private List<IProject> getExistingProjects(File destination) {
        IProject[] projects;
        ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFile;
            File projectParent;
            IProject project = iProjectArray[n2];
            if (project != null && project.exists() && ((projectParent = (projectFile = project.getLocation().toFile()).getParentFile()).equals(destination) || projectFile.equals(destination))) {
                existingProjects.add(project);
            }
            ++n2;
        }
        return existingProjects;
    }

    private String getMessage(File destination, List<IProject> projects) {
        if (projects.size() > 0) {
            StringBuilder builder = new StringBuilder();
            if (projects.size() == 1) {
                builder.append("\nThe '" + projects.get(0).getName() + "' project already exist at '" + destination.getAbsolutePath() + "'.\n\n");
                builder.append("Would you like to overwrite this project?");
            } else {
                builder.append("\nThe following projects already exist at '" + destination.getAbsolutePath() + "'.\n\n");
                for (IProject project : projects) {
                    builder.append(project.getName());
                    builder.append("\n");
                }
                builder.append("\n");
                builder.append("Would you like to overwrite them?");
            }
            builder.append("\n\nThis cannot be undone.");
            return builder.toString();
        }
        return null;
    }

    private String getWorkspaceMessage(List<IProject> existingProjects) {
        StringBuilder builder = new StringBuilder();
        if (existingProjects.size() == 1) {
            builder.append("There is the '" + existingProjects.get(0).getName() + "' project in the workspace.\n\n");
            builder.append("Would you like to delete it?");
        } else {
            builder.append("There are the following projects in the workspace:\n\n");
            for (IProject project : existingProjects) {
                builder.append(project.getName());
                builder.append("\n");
            }
            builder.append("\n");
            builder.append("Would you like to delete them?");
        }
        return builder.toString();
    }
}

