/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.adapters.internal;

import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.adapters.IBodyInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class BodyInfo
implements IBodyInfo {
    private static final BodyInfo _instance = new BodyInfo();

    public boolean isBodyContainer(IDOMNode node) {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return true;
            }
            case 1: {
                return this.isBodyContainerElement((Element)node);
            }
        }
        return false;
    }

    private boolean isBodyContainerElement(Element element) {
        String localname = element.getLocalName();
        return "html".equalsIgnoreCase(localname) || "body".equalsIgnoreCase(localname) || "view".equals(localname) || "subview".equals(localname);
    }

    public boolean isBodyHeader(IDOMNode node, String uri, String localname) {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return this.isDocumentHeader(uri, localname);
            }
            case 1: {
                return this.isElementHeader((Element)node, uri, localname);
            }
        }
        return false;
    }

    private boolean isElementHeader(Element element, String uri, String localname) {
        String elelocalname = element.getLocalName();
        String namespaceURI = CMUtil.getElementNamespaceURI((Element)element);
        if ("html".equals(namespaceURI) && "html".equalsIgnoreCase(elelocalname)) {
            return "head".equalsIgnoreCase(localname);
        }
        if ("http://java.sun.com/jsf/core".equals(namespaceURI) && "view".equalsIgnoreCase(elelocalname)) {
            return "loadBundle".equalsIgnoreCase(localname);
        }
        return false;
    }

    private boolean isDocumentHeader(String uri, String localname) {
        return "directive.page".equals(localname) || "directive.taglib".equals(localname);
    }

    public static IBodyInfo getInstance() {
        return _instance;
    }

    private BodyInfo() {
    }
}

