/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersComparator;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.HideStoppedContainersViewerFilter;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerContainersView
extends ViewPart
implements IDockerContainerListener,
ISelectionListener,
ITabbedPropertySheetPageContributor {
    private static final String TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String SHOW_ALL_CONTAINERS_COMMAND_ID = "org.eclipse.linuxtools.docker.ui.commands.showAllContainers";
    private static final String SHOW_ALL_CONTAINERS_PREFERENCE = "showAllContainers";
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerContainersView";
    private static final String DaemonMissing = "ViewerDaemonMissing.msg";
    private static final String ViewAllTitle = "ContainersViewTitle.all.msg";
    private static final String ViewFilteredTitle = "ContainersViewTitle.filtered.msg";
    private Form form;
    private Text search;
    private TableViewer viewer;
    private IDockerConnection connection;
    private final HideStoppedContainersViewerFilter hideStoppedContainersViewerFilter = new HideStoppedContainersViewerFilter();

    public void setFocus() {
    }

    public void dispose() {
        if (this.connection != null) {
            this.connection.removeContainerListener((IDockerContainerListener)this);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        super.dispose();
    }

    public String getContributorId() {
        return "org.eclipse.linuxtools.docker.ui.dockerExplorerView";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return (T)new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return (T)super.getAdapter(adapter);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.setText(DVMessages.getString(DaemonMissing));
        Composite container = this.form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        this.createTableViewer(container);
        this.getSite().registerContextMenu(new MenuManager(), null);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        this.hookContextMenu();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        boolean showAll = preferences.getBoolean(SHOW_ALL_CONTAINERS_PREFERENCE, true);
        this.showAllContainers(showAll);
        ICommandService service = (ICommandService)this.getViewSite().getWorkbenchWindow().getService(ICommandService.class);
        service.getCommand(SHOW_ALL_CONTAINERS_COMMAND_ID).getState(TOGGLE_STATE).setValue((Object)showAll);
        service.refreshElements(SHOW_ALL_CONTAINERS_COMMAND_ID, null);
    }

    private void createTableViewer(Composite container) {
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        Composite tableArea = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(tableArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableArea);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableArea, 66306);
        this.viewer.setContentProvider((IContentProvider)new DockerContainersContentProvider());
        Table table = this.viewer.getTable();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo((Composite)table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn nameColumn = this.createColumn(DVMessages.getString("NAME"));
        this.setLayout(nameColumn, tableLayout, 150);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).name();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IDockerContainer) {
                    IDockerContainer container = (IDockerContainer)element;
                    EnumDockerStatus containerStatus = EnumDockerStatus.fromStatusMessage((String)container.status());
                    if (containerStatus == EnumDockerStatus.RUNNING) {
                        return SWTImagesFactory.DESC_CONTAINER_STARTED.createImage();
                    }
                    if (containerStatus == EnumDockerStatus.PAUSED) {
                        return SWTImagesFactory.DESC_CONTAINER_PAUSED.createImage();
                    }
                    return SWTImagesFactory.DESC_CONTAINER_STOPPED.createImage();
                }
                return super.getImage(element);
            }
        });
        TableViewerColumn imageColumn = this.createColumn(DVMessages.getString("IMAGE"));
        this.setLayout(imageColumn, tableLayout, 150);
        imageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).image();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn creationDateColumn = this.createColumn(DVMessages.getString("CREATED"));
        this.setLayout(creationDateColumn, tableLayout, 150);
        creationDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return LabelUtils.toCreatedDate(((IDockerContainer)element).created());
                }
                return super.getText(element);
            }
        });
        TableViewerColumn commandColumn = this.createColumn(DVMessages.getString("COMMAND"));
        this.setLayout(commandColumn, tableLayout, 150);
        commandColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).command();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn portsColumn = this.createColumn(DVMessages.getString("PORTS"));
        this.setLayout(portsColumn, tableLayout, 150);
        portsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    StringBuilder ports = new StringBuilder();
                    Iterator iterator = ((IDockerContainer)element).ports().iterator();
                    while (iterator.hasNext()) {
                        IDockerPortMapping portMapping = (IDockerPortMapping)iterator.next();
                        ports.append(LabelUtils.containerPortMappingToString(portMapping));
                        if (!iterator.hasNext()) continue;
                        ports.append(", ");
                    }
                    return ports.toString();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn statusColumn = this.createColumn(DVMessages.getString("STATUS"));
        this.setLayout(statusColumn, tableLayout, 150);
        statusColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).status();
                }
                return super.getText(element);
            }
        });
        DockerContainersComparator comparator = new DockerContainersComparator(this.viewer);
        comparator.setColumn(creationDateColumn.getColumn());
        comparator.setColumn(creationDateColumn.getColumn());
        this.viewer.setComparator((ViewerComparator)comparator);
        this.viewer.addFilter(this.getContainersFilter());
        IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
        if (connections.length > 0) {
            this.setConnection(connections[0]);
            this.connection.addContainerListener((IDockerContainerListener)this);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private TableViewerColumn createColumn(String title) {
        TableViewerColumn propertyColumn = new TableViewerColumn(this.viewer, 2048);
        propertyColumn.getColumn().setText(title);
        propertyColumn.getColumn().addSelectionListener(this.onColumnSelected());
        return propertyColumn;
    }

    private SelectionListener onColumnSelected() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn sortColumn = (TableColumn)e.getSource();
                DockerContainersComparator comparator = (DockerContainersComparator)DockerContainersView.this.viewer.getComparator();
                comparator.setColumn(sortColumn);
                DockerContainersView.this.viewer.refresh();
            }
        };
    }

    private void setLayout(TableViewerColumn viewerColumn, TableColumnLayout tableLayout, int weight) {
        tableLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    private ModifyListener onSearch() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DockerContainersView.this.viewer != null) {
                    DockerContainersView.this.viewer.refresh();
                }
            }
        };
    }

    private ViewerFilter getContainersFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDockerContainer) {
                    return element.toString().contains(DockerContainersView.this.search.getText());
                }
                return false;
            }
        };
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object firstSegment;
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            this.setConnection(null);
            return;
        }
        if (this.connection != null) {
            this.connection.removeContainerListener((IDockerContainerListener)this);
        }
        if ((firstSegment = treeSelection.getPaths()[0].getFirstSegment()) instanceof IDockerConnection) {
            this.setConnection((IDockerConnection)firstSegment);
            this.connection.addContainerListener((IDockerContainerListener)this);
        }
    }

    public void listChanged(IDockerConnection connection, List<IDockerContainer> containers) {
        if (connection.getName().equals(connection.getName())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DockerContainersView.this.viewer != null && !DockerContainersView.this.viewer.getTable().isDisposed()) {
                        DockerContainersView.this.viewer.refresh();
                        DockerContainersView.this.refreshViewTitle();
                    }
                }
            });
        }
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IDockerConnection conn) {
        this.connection = conn;
        if (conn != null && this.viewer != null) {
            this.viewer.setInput((Object)conn);
            this.refreshViewTitle();
        } else if (this.viewer != null) {
            this.viewer.setInput((Object)new IDockerContainer[0]);
            this.form.setText(DVMessages.getString(DaemonMissing));
        }
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return null;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void showAllContainers(boolean enabled) {
        if (this.viewer == null) {
            return;
        }
        if (!enabled) {
            this.viewer.addFilter((ViewerFilter)this.hideStoppedContainersViewerFilter);
        } else {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter viewerFilter = (ViewerFilter)iterator.next();
                if (!viewerFilter.equals((Object)this.hideStoppedContainersViewerFilter)) continue;
                iterator.remove();
            }
            this.viewer.setFilters(filters.toArray(new ViewerFilter[0]));
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        preferences.putBoolean(SHOW_ALL_CONTAINERS_PREFERENCE, enabled);
        this.refreshViewTitle();
    }

    private void refreshViewTitle() {
        if (this.viewer == null || this.viewer.getControl().isDisposed() || this.form == null || this.connection == null) {
            return;
        }
        if (!this.connection.isContainersLoaded()) {
            this.form.setText(this.connection.getName());
        } else {
            List<ViewerFilter> filters = Arrays.asList(this.viewer.getFilters());
            if (filters.contains((Object)this.hideStoppedContainersViewerFilter)) {
                this.form.setText(DVMessages.getFormattedString(ViewFilteredTitle, this.connection.getName(), Integer.toString(this.viewer.getTable().getItemCount()), Integer.toString(this.connection.getContainers().size())));
            } else {
                this.form.setText(DVMessages.getFormattedString(ViewAllTitle, this.connection.getName(), Integer.toString(this.connection.getContainers().size())));
            }
        }
    }
}

