/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisplayContainerLogCommandHandler
extends AbstractHandler {
    private static final String CONTAINER_LOG_TITLE = "ContainerLog.title";
    private static final String ERROR_LOGGING_CONTAINER = "ContainerLogError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1 || connection == null) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        final String id = container.id();
        final String name = container.name();
        if (connection.getContainerInfo(id).config().tty()) {
            RunConsole.attachToTerminal(connection, id);
            return null;
        }
        try {
            final RunConsole rc = RunConsole.findConsole(id);
            if (rc != null) {
                if (!rc.isAttached()) {
                    rc.attachToConsole(connection);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        rc.setTitle(DVMessages.getFormattedString(DisplayContainerLogCommandHandler.CONTAINER_LOG_TITLE, name));
                    }
                });
                OutputStream stream = rc.getOutputStream();
                EnumDockerLoggingStatus status = ((DockerConnection)connection).loggingStatus(id);
                if (status != EnumDockerLoggingStatus.LOGGING_ACTIVE && !((DockerConnection)connection).getContainerInfo(id).config().tty()) {
                    rc.clearConsole();
                    ((DockerConnection)connection).logContainer(id, stream);
                }
                rc.showConsole();
            }
        }
        catch (InterruptedException | DockerException e) {
            Display.getDefault().syncExec(new Runnable((Exception)e){
                private final /* synthetic */ Exception val$e;
                {
                    this.val$e = exception;
                }

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(DisplayContainerLogCommandHandler.ERROR_LOGGING_CONTAINER, id), (String)this.val$e.getMessage());
                }
            });
        }
        return null;
    }
}

