/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryManager;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;

public class DependencyInstallAction
implements IPluginInstallationAction {
    private final HybridProject project;
    private final String dependencyPluginId;
    private final URI uri;
    private final FileOverwriteCallback overwriteCallback;

    public DependencyInstallAction(String dependencyId, URI uri, HybridProject project, FileOverwriteCallback overwrite) {
        this.project = project;
        this.uri = uri;
        this.dependencyPluginId = dependencyId;
        this.overwriteCallback = overwrite;
    }

    @Override
    public void install() throws CoreException {
        CordovaPluginManager pluginManager = this.project.getPluginManager();
        if (!pluginManager.isPluginInstalled(this.dependencyPluginId)) {
            if (this.uri != null) {
                pluginManager.installPlugin(this.uri, this.overwriteCallback, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                CordovaPluginRegistryManager manager = new CordovaPluginRegistryManager();
                CordovaRegistryPlugin plugin = manager.getCordovaPluginInfo(this.dependencyPluginId);
                List<CordovaRegistryPlugin.RegistryPluginVersion> versions = plugin.getVersions();
                for (CordovaRegistryPlugin.RegistryPluginVersion version : versions) {
                    if (!plugin.getLatestVersion().equals(version.getVersionNumber())) continue;
                    pluginManager.installPlugin(version, this.overwriteCallback, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    @Override
    public void unInstall() throws CoreException {
    }

    @Override
    public String[] filesToOverwrite() {
        return new String[0];
    }
}

