/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.repositories;

import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;

public class SettingsRepositoryBuilder {
    private static final String POLICY_NEVER = "never";
    private static final String POLICY_DAILY = "daily";
    private static final String LAYOUT_DEFAULT = "default";
    private Repository repository = SettingsRepositoryBuilder.getDefaultRepository();

    public Repository get() {
        return this.repository;
    }

    public static Repository getDefaultRepository() {
        Repository repository = new Repository();
        repository.setLayout(LAYOUT_DEFAULT);
        RepositoryPolicy releases = new RepositoryPolicy();
        releases.setEnabled(true);
        releases.setUpdatePolicy(POLICY_NEVER);
        repository.setReleases(releases);
        RepositoryPolicy snapshots = new RepositoryPolicy();
        snapshots.setEnabled(false);
        snapshots.setUpdatePolicy(POLICY_DAILY);
        repository.setSnapshots(snapshots);
        return repository;
    }

    public SettingsRepositoryBuilder setId(String id) {
        this.repository.setId(id);
        return this;
    }

    public SettingsRepositoryBuilder setName(String name) {
        this.repository.setName(name);
        return this;
    }

    public SettingsRepositoryBuilder setUrl(String url) {
        this.repository.setUrl(url);
        return this;
    }
}

