/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.wizards.xpl.export;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.jboss.ide.eclipse.as.wtp.core.util.VCFUtil;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;

public class ProjectModuleExportPage
extends DataModelWizardPage {
    private static boolean isWindows = SWT.getPlatform().toLowerCase().startsWith("win");
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    protected static final String STORE_PREFIX = "JBT_EXPORT_";
    protected static final String STORE_OVERWRITE = "OVERWRITE";
    protected IStructuredSelection selection;
    private Combo resourceNameCombo;
    private Combo destinationNameCombo;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;

    public ProjectModuleExportPage(IDataModel model, String pageName, IStructuredSelection selection) {
        super(model, pageName);
        Object o;
        this.setTitle(Messages.Export_PageTitle);
        this.setDescription(Messages.Export_PageDescription);
        this.selection = selection;
        if (selection != null && selection.getFirstElement() != null && (o = selection.getFirstElement()) instanceof IProject) {
            model.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)((IProject)o).getName());
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJ2EEComponentExportDataModelProperties.PROJECT_NAME", "IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createSourceAndDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.setupInfopop((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createSourceAndDestinationGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createExportComponentGroup(composite);
        this.createDestinationGroup(composite);
    }

    protected void createExportComponentGroup(Composite parent) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText(Messages.Export_LabelProject);
        this.resourceNameCombo = new Combo(parent, 2052);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.resourceNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.resourceNameCombo, "IJ2EEComponentExportDataModelProperties.PROJECT_NAME", null);
        new Label(parent, 0);
    }

    protected void createDestinationGroup(Composite parent) {
        Label destinationLabel = new Label(parent, 0);
        destinationLabel.setText(Messages.Export_LabelDestination);
        this.destinationNameCombo = new Combo(parent, 2052);
        this.destinationNameCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.destinationNameCombo, "IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", null);
        this.destinationBrowseButton = new Button(parent, 8);
        this.destinationBrowseButton.setText(Messages.Export_LabelBrowse);
        this.destinationBrowseButton.setLayoutData((Object)new GridData(768));
        this.destinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectModuleExportPage.this.handleDestinationBrowseButtonPressed();
            }
        });
        this.destinationBrowseButton.setEnabled(true);
    }

    protected void handleDestinationBrowseButtonPressed() {
        String filename;
        FileDialog dialog = new FileDialog(this.destinationNameCombo.getShell(), 8192);
        String fileName = this.getDataModel().getStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        String[] filters = this.getFilterExpression();
        if (filters.length != 0 && filters[0] != null && filters[0].indexOf(46) != -1) {
            fileName = String.valueOf(fileName) + filters[0].substring(filters[0].indexOf(46));
        }
        dialog.setFileName(fileName);
        if (isWindows) {
            dialog.setFilterExtensions(filters);
        }
        if ((filename = dialog.open()) != null) {
            this.destinationNameCombo.setText(filename);
        }
    }

    protected String[] getFilterExpression() {
        return new String[0];
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_PREFIX + this.getModuleFacet());
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (sourceNames[i] == null) {
                    sourceNames[i] = "";
                }
                ++i;
            }
            this.destinationNameCombo.setItems(sourceNames);
            boolean overwrite = settings.getBoolean("JBT_EXPORT_OVERWRITE");
            this.model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", overwrite);
        }
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        optionsGroup.setLayout((Layout)layout);
        this.createOverwriteExistingFilesCheckbox(optionsGroup);
    }

    protected void createOverwriteExistingFilesCheckbox(Composite optionsGroup) {
        this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(Messages.Export_OverwriteCheckbox);
        this.overwriteExistingFilesCheckbox.setEnabled(true);
        this.synchHelper.synchCheckbox(this.overwriteExistingFilesCheckbox, "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", null);
    }

    protected String getModuleFacet() {
        Object o = this.selection.getFirstElement();
        if (o instanceof IProject) {
            IProject proj = (IProject)o;
            IProjectFacet facet = VCFUtil.getModuleFacet((IProject)proj);
            return facet == null ? null : facet.getId();
        }
        return null;
    }
}

