/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;

public class ServerWorkingCopyPropertyButtonCommand
extends ServerCommand {
    public static int POST_EXECUTE = 1;
    public static int POST_UNDO = 2;
    public static int POST_REDO = 3;
    protected boolean oldVal;
    protected boolean newVal;
    protected String key;
    protected Button button;
    protected SelectionListener listener;
    protected IServerWorkingCopy wc;

    public ServerWorkingCopyPropertyButtonCommand(IServerWorkingCopy wc, String commandName, Button button, boolean newVal, String attributeKey, SelectionListener listener) {
        this(wc, commandName, button, newVal, attributeKey, listener, false);
    }

    public ServerWorkingCopyPropertyButtonCommand(IServerWorkingCopy wc, String commandName, Button button, boolean newVal, String attributeKey, SelectionListener listener, boolean defaultval) {
        super(wc, commandName);
        this.wc = wc;
        this.button = button;
        this.key = attributeKey;
        this.newVal = newVal;
        this.listener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, defaultval);
        }
    }

    public void execute() {
        if (this.key != null) {
            this.wc.setAttribute(this.key, this.newVal);
        }
        this.postOp(POST_EXECUTE);
    }

    public void undo() {
        if (this.listener != null) {
            this.button.removeSelectionListener(this.listener);
        }
        if (this.key != null) {
            this.wc.setAttribute(this.key, this.oldVal);
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setSelection(this.oldVal);
        }
        if (this.listener != null) {
            this.button.addSelectionListener(this.listener);
        }
        this.postOp(POST_UNDO);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
        if (this.listener != null) {
            this.button.removeSelectionListener(this.listener);
        }
        if (this.key != null) {
            this.wc.setAttribute(this.key, this.newVal);
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setSelection(this.newVal);
        }
        if (this.listener != null) {
            this.button.addSelectionListener(this.listener);
        }
        this.postOp(POST_REDO);
        return Status.OK_STATUS;
    }

    protected void postOp(int type) {
    }
}

