/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.XmlIdClassContainer;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmIdClassReference
extends AbstractOrmXmlContextModel<OrmIdTypeMapping>
implements OrmIdClassReference,
PersistentType.Parent {
    protected String specifiedIdClassName = this.buildSpecifiedIdClassName();
    protected String defaultIdClassName;
    protected String fullyQualifiedIdClassName;
    protected JavaPersistentType idClass;

    public GenericOrmIdClassReference(OrmIdTypeMapping parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedIdClassName_(this.buildSpecifiedIdClassName());
        this.syncIdClass();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultIdClassName(this.buildDefaultIdClassName());
        this.setFullyQualifiedIdClassName(this.buildFullyQualifiedIdClassName());
        this.updateIdClass();
    }

    @Override
    public String getFullyQualifiedIdClassName() {
        return this.fullyQualifiedIdClassName;
    }

    protected void setFullyQualifiedIdClassName(String name) {
        String old = this.fullyQualifiedIdClassName;
        this.fullyQualifiedIdClassName = name;
        if (this.firePropertyChanged("fullyQualifiedIdClass", old, name) && this.idClass != null) {
            this.setIdClass(null);
        }
    }

    protected String buildFullyQualifiedIdClassName() {
        return this.specifiedIdClassName == null ? this.defaultIdClassName : this.getEntityMappings().qualify(this.specifiedIdClassName);
    }

    @Override
    public String getIdClassName() {
        return this.specifiedIdClassName != null ? this.specifiedIdClassName : this.defaultIdClassName;
    }

    @Override
    public String getSpecifiedIdClassName() {
        return this.specifiedIdClassName;
    }

    @Override
    public void setSpecifiedIdClassName(String name) {
        if (ObjectTools.notEquals((Object)this.specifiedIdClassName, (Object)name)) {
            XmlClassReference xmlClassRef = this.getXmlIdClassRefForUpdate();
            this.setSpecifiedIdClassName_(name);
            xmlClassRef.setClassName(name);
            this.removeXmlIdClassRefIfUnset();
        }
    }

    protected void setSpecifiedIdClassName_(String name) {
        String old = this.specifiedIdClassName;
        this.specifiedIdClassName = name;
        this.firePropertyChanged("specifiedIdClassName", old, name);
    }

    protected String buildSpecifiedIdClassName() {
        XmlClassReference xmlIdClassRef = this.getXmlIdClassRef();
        return xmlIdClassRef == null ? null : xmlIdClassRef.getClassName();
    }

    @Override
    public String getDefaultIdClassName() {
        return this.defaultIdClassName;
    }

    protected void setDefaultIdClassName(String name) {
        String old = this.defaultIdClassName;
        this.defaultIdClassName = name;
        this.firePropertyChanged("defaultIdClassName", old, name);
    }

    protected String buildDefaultIdClassName() {
        JavaIdClassReference javaRef = ((OrmIdTypeMapping)this.parent).getJavaIdClassReferenceForDefaults();
        if (javaRef != null && javaRef.isSpecified()) {
            return javaRef.getFullyQualifiedIdClassName();
        }
        IdTypeMapping superType = ((OrmIdTypeMapping)this.getParent()).getSuperTypeMapping();
        return superType == null ? null : superType.getIdClassReference().getFullyQualifiedIdClassName();
    }

    @Override
    public boolean isSpecified() {
        return this.getIdClassName() != null;
    }

    protected XmlClassReference getXmlIdClassRef() {
        return this.getXmlIdClassContainer().getIdClass();
    }

    protected XmlClassReference getXmlIdClassRefForUpdate() {
        XmlClassReference xmlClassRef = this.getXmlIdClassRef();
        return xmlClassRef != null ? xmlClassRef : this.buildXmlIdClassRef();
    }

    protected XmlClassReference buildXmlIdClassRef() {
        XmlClassReference ref = OrmFactory.eINSTANCE.createXmlClassReference();
        this.getXmlIdClassContainer().setIdClass(ref);
        return ref;
    }

    protected void removeXmlIdClassRefIfUnset() {
        if (this.getXmlIdClassRef().isUnset()) {
            this.removeXmlIdClassRef();
        }
    }

    protected void removeXmlIdClassRef() {
        this.getXmlIdClassContainer().setIdClass(null);
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass(JavaPersistentType idClass) {
        JavaPersistentType old = this.idClass;
        this.idClass = idClass;
        this.firePropertyChanged("idClass", old, idClass);
    }

    protected void syncIdClass() {
        if (this.idClass != null) {
            this.idClass.synchronizeWithResourceModel();
        }
    }

    protected void updateIdClass() {
        if (this.fullyQualifiedIdClassName == null) {
            if (this.idClass != null) {
                this.setIdClass(null);
            }
        } else if (this.idClass == null) {
            this.setIdClass(this.buildIdClass());
        } else if (this.idClass.getName().equals(this.fullyQualifiedIdClassName)) {
            this.idClass.update();
        } else {
            this.setIdClass(this.buildIdClass());
        }
    }

    protected JavaResourceType resolveJavaResourceIdClass() {
        if (this.fullyQualifiedIdClassName == null) {
            return null;
        }
        JavaResourceType jrt = (JavaResourceType)this.getJpaProject().getJavaResourceType(this.fullyQualifiedIdClassName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        return jrt == null || jrt.isAnnotatedWithAnyOf(this.getJpaProject().getTypeMappingAnnotationNames()) ? null : jrt;
    }

    protected JavaPersistentType buildIdClass() {
        JavaResourceType jrt = this.resolveJavaResourceIdClass();
        return jrt != null ? this.buildIdClass(jrt) : null;
    }

    protected JavaPersistentType buildIdClass(JavaResourceType resourceIdClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceIdClass);
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '$';
    }

    protected OrmTypeMapping getTypeMapping() {
        return (OrmTypeMapping)this.parent;
    }

    protected OrmPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected XmlIdClassContainer getXmlIdClassContainer() {
        return ((OrmIdTypeMapping)this.parent).getXmlIdClassContainer();
    }

    protected EntityMappings getEntityMappings() {
        return this.getMappingFileRoot();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.getXmlIdClassRef() != null && this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameEdit(IType originalType, String newName) {
        return this.getXmlIdClassRef().createRenameEdit(originalType, newName);
    }

    protected boolean isFor(String typeName) {
        return this.idClass != null && this.idClass.isFor(typeName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.getXmlIdClassRef() != null && this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.getXmlIdClassRef() != null && this.isIn(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.getXmlIdClassRef().createRenamePackageEdit(newName);
    }

    protected boolean isIn(IPackageFragment originalPackage) {
        return this.idClass != null && this.idClass.isIn(originalPackage);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateIdClass(messages, reporter);
    }

    protected void validateIdClass(List<IMessage> messages, IReporter reporter) {
        if (this.isSpecified()) {
            if (StringTools.isBlank((String)this.getIdClassName())) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NAME_EMPTY));
                return;
            }
            IType idClassJdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedIdClassName());
            if (idClassJdtType == null) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NOT_EXIST, this.getFullyQualifiedIdClassName()));
                return;
            }
            JavaResourceType jrt = this.getIdClassJavaResourceType();
            if (jrt != null) {
                if (!jrt.isPublic()) {
                    messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NOT_PUBLIC, jrt.getTypeBinding().getQualifiedName()));
                }
                if (!TypeTools.isSerializable((String)jrt.getTypeBinding().getQualifiedName(), (IJavaProject)this.getJavaProject())) {
                    messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NOT_IMPLEMENT_SERIALIZABLE, jrt.getTypeBinding().getQualifiedName()));
                }
                if (!jrt.hasEqualsMethod()) {
                    messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_MISSING_EQUALS_METHOD, jrt.getTypeBinding().getQualifiedName()));
                }
                if (!jrt.hasHashCodeMethod()) {
                    messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_MISSING_HASHCODE_METHOD, jrt.getTypeBinding().getQualifiedName()));
                }
            }
        }
    }

    protected JavaResourceType getIdClassJavaResourceType() {
        return (JavaResourceType)this.getEntityMappings().resolveJavaResourceType(this.getIdClassName(), JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        XmlClassReference xmlIdClassRef = this.getXmlIdClassRef();
        return xmlIdClassRef == null ? null : xmlIdClassRef.getClassNameTextRange();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.idCLassNameTouches(pos)) {
            return this.getCandidateIdClassNames();
        }
        return null;
    }

    protected Iterable<String> getCandidateIdClassNames() {
        return JavaProjectTools.getJavaClassNames((IJavaProject)this.getJavaProject());
    }

    protected boolean idCLassNameTouches(int pos) {
        return this.getXmlIdClassRef() == null ? false : this.getXmlIdClassRef().classNameTouches(pos);
    }
}

