/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaFile.Reference.class, JpaFile.class, JptXmlResource.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IFile) {
            return this.getAdapter((IFile)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IFile file, Class<?> adapterType) {
        if (adapterType == JpaFile.Reference.class) {
            return this.getJpaFileReference(file);
        }
        if (adapterType == JpaFile.class) {
            return this.getJpaFile(file);
        }
        if (adapterType == JptXmlResource.class) {
            return this.getJpaXmlResource(file);
        }
        return null;
    }

    private JpaFile.Reference getJpaFileReference(IFile file) {
        return new JpaFileReference(file);
    }

    private JpaFile getJpaFile(IFile file) {
        JpaProject jpaProject = this.getJpaProject(file.getProject());
        return jpaProject == null ? null : jpaProject.getJpaFile(file);
    }

    private JptXmlResource getJpaXmlResource(IFile file) {
        JptResourceModel resourceModel;
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile != null && (resourceModel = jpaFile.getResourceModel()) instanceof JptXmlResource) {
            return (JptXmlResource)resourceModel;
        }
        return null;
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    static class JpaFileReference
    implements JpaFile.Reference {
        private final IFile file;

        JpaFileReference(IFile file) {
            this.file = file;
        }

        public JpaFile getValue() throws InterruptedException {
            JpaProject jpaProject = this.getJpaProject();
            return jpaProject == null ? null : jpaProject.getJpaFile(this.file);
        }

        private JpaProject getJpaProject() throws InterruptedException {
            JpaProject.Reference ref = this.getJpaProjectReference();
            return ref == null ? null : ref.getValue();
        }

        private JpaProject.Reference getJpaProjectReference() {
            return (JpaProject.Reference)this.file.getProject().getAdapter(JpaProject.Reference.class);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.file);
        }
    }
}

