/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.JobImages;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactDialog;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.TestableResolutionWithDialog;
import org.jboss.tools.common.util.BeanUtil;

public class CreateBatchArtifactQuickFix
implements IQuickFix,
TestableResolutionWithDialog {
    private IFile file;
    private String artifactName;
    private BatchArtifactType type;
    private String label;

    public CreateBatchArtifactQuickFix(IFile file, String artifactName, BatchArtifactType type, String label) {
        this.file = file;
        this.artifactName = artifactName;
        this.type = type;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        IBatchProject batchProject = BatchCorePlugin.getBatchProject((IProject)this.file.getProject(), (boolean)true);
        if (batchProject == null) {
            return;
        }
        IResource[] resource = EclipseUtil.getJavaSourceRoots((IProject)batchProject.getProject());
        if (resource.length == 0) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewBatchArtifactDialog dialog = new NewBatchArtifactDialog(shell);
        StructuredSelection selection = new StructuredSelection((Object)resource[0]);
        dialog.init(BatchUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)selection);
        dialog.open(batchProject, this.type, false, BeanUtil.getClassName((String)this.artifactName));
    }

    public void runForTest(IMarker marker) {
        this.run(marker);
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return JobImages.getImage("batch_edit.png");
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.run(null);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getLabel();
    }

    public String getDisplayString() {
        return this.getLabel();
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

