/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.ui.widget.editor.BaseListFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;

public class BatchFieldEditorFactory {
    public static final String ARTIFACT_EDITOR = "artifact";
    public static final String DERIVE_FROM_EDITOR = "derive-from";
    public static final String LOADER_OPTIONS_EDITOR = "loader-options";
    public static final String NAME_EDITOR = "name";
    public static final String PROPERTIES_EDITOR = "properties";
    static Map<String, BatchArtifactType> ARTIFACTS = new TreeMap<String, BatchArtifactType>();
    static List<String> ARTIFACT_LIST = new ArrayList<String>();
    public static final String DERIVE_FROM_CLASS = "class";
    public static final String DERIVE_FROM_INTERFACE = "interface";
    static List<String> DERIVE_FROM_OPTIONS;
    static List<String> DERIVE_FROM_OPTION_LABELS;
    public static final String LOADER_OPTION_ANNOTATION = "annotation";
    public static final String LOADER_OPTION_XML = "xml";
    public static final String LOADER_OPTION_QUALIFIED = "qualified";
    static List<String> LOADER_OPTIONS;
    static List<String> LOADER_OPTIONS_LABELS;

    static {
        BatchFieldEditorFactory.bindArtifact(WizardMessages.batchletTypeLabel, BatchArtifactType.BATCHLET);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.deciderTypeLabel, BatchArtifactType.DECIDER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemReaderTypeLabel, BatchArtifactType.ITEM_READER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemWriterTypeLabel, BatchArtifactType.ITEM_WRITER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemProcessorTypeLabel, BatchArtifactType.ITEM_PROCESSOR);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.checkpointAlgorithmTypeLabel, BatchArtifactType.CHECKPOINT_ALGORITHM);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.partitionMapperTypeLabel, BatchArtifactType.PARTITION_MAPPER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.partitionReducerTypeLabel, BatchArtifactType.PARTITION_REDUCER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.partitionCollectorTypeLabel, BatchArtifactType.PARTITION_COLLECTOR);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.partitionAnalyzerTypeLabel, BatchArtifactType.PARTITION_ANALYZER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.jobListenerTypeLabel, BatchArtifactType.JOB_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.stepListenerTypeLabel, BatchArtifactType.STEP_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.chunkListenerTypeLabel, BatchArtifactType.CHUNK_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemReadListenerTypeLabel, BatchArtifactType.ITEM_READ_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemProcessListenerTypeLabel, BatchArtifactType.ITEM_PROCESS_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.itemWriteListenerTypeLabel, BatchArtifactType.ITEM_WRITE_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.skipReadListenerTypeLabel, BatchArtifactType.SKIP_READ_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.skipProcessListenerTypeLabel, BatchArtifactType.SKIP_PROCESS_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.skipWriteListenerTypeLabel, BatchArtifactType.SKIP_WRITE_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.retryReadListenerTypeLabel, BatchArtifactType.RETRY_READ_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.retryProcessListenerTypeLabel, BatchArtifactType.RETRY_PROCESS_LISTENER);
        BatchFieldEditorFactory.bindArtifact(WizardMessages.retryWriteListenerTypeLabel, BatchArtifactType.RETRY_WRITE_LISTENER);
        DERIVE_FROM_OPTIONS = Arrays.asList(DERIVE_FROM_INTERFACE, DERIVE_FROM_CLASS);
        DERIVE_FROM_OPTION_LABELS = Arrays.asList(WizardMessages.artifactImplementInterfaceLabel, WizardMessages.artifactExtendAbstractClassLabel);
        LOADER_OPTIONS = Arrays.asList(LOADER_OPTION_ANNOTATION, LOADER_OPTION_XML, LOADER_OPTION_QUALIFIED);
        LOADER_OPTIONS_LABELS = Arrays.asList(WizardMessages.artifactLoaderAnnotationLabel, WizardMessages.artifactLoaderXMLLabel, WizardMessages.artifactLoaderQualifiedLabel);
    }

    static void bindArtifact(String label, BatchArtifactType type) {
        ARTIFACT_LIST.add(label);
        ARTIFACTS.put(label, type);
    }

    public static String getArtifactLabel(BatchArtifactType type) {
        for (String label : ARTIFACT_LIST) {
            if (!type.equals((Object)ARTIFACTS.get(label))) continue;
            return label;
        }
        return null;
    }

    public static BatchArtifactType getArtifactType(String label) {
        return ARTIFACTS.get(label);
    }

    public static IFieldEditor createArtifactEditor(BatchArtifactType artifact) {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor(ARTIFACT_EDITOR, WizardMessages.artifactLabel, ARTIFACT_LIST, (Object)BatchFieldEditorFactory.getArtifactLabel(artifact));
    }

    public static IFieldEditor createArtifactEditor(BatchArtifactType artifact, List<BatchArtifactType> types) {
        ArrayList<String> list = new ArrayList<String>();
        for (String t : ARTIFACT_LIST) {
            if (!types.contains(ARTIFACTS.get(t))) continue;
            list.add(t);
        }
        return SwtFieldEditorFactory.INSTANCE.createComboEditor(ARTIFACT_EDITOR, WizardMessages.artifactLabel, list, (Object)BatchFieldEditorFactory.getArtifactLabel(artifact));
    }

    public static IFieldEditor createDerivedFromEditor() {
        return SwtFieldEditorFactory.INSTANCE.createRadioEditor(DERIVE_FROM_EDITOR, "", DERIVE_FROM_OPTION_LABELS, DERIVE_FROM_OPTIONS, (Object)DERIVE_FROM_CLASS);
    }

    public static IFieldEditor createNameOptionsEditor() {
        return SwtFieldEditorFactory.INSTANCE.createRadioEditor(LOADER_OPTIONS_EDITOR, WizardMessages.artifactLoaderLabel, LOADER_OPTIONS_LABELS, LOADER_OPTIONS, (Object)LOADER_OPTION_ANNOTATION);
    }

    public static IFieldEditor createArtifactNameEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor(NAME_EDITOR, WizardMessages.artifactNameLabel, "");
    }

    public static IFieldEditor createPropertiesEditor() {
        return new PropertiesListEditor(PROPERTIES_EDITOR, WizardMessages.artifactPropertiesLabel, new ArrayList());
    }

    static class NewPropertyDialog
    extends Dialog {
        private String fName;
        private Label fNameLabel;
        private Text fNameText;
        List<Object> usedValues = new ArrayList<Object>();

        public NewPropertyDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = (Composite)super.createDialogArea(parent);
            ((GridLayout)comp.getLayout()).numColumns = 2;
            this.fNameLabel = new Label(comp, 0);
            this.fNameLabel.setText("Field name:");
            this.fNameLabel.setFont(comp.getFont());
            this.fNameText = new Text(comp, 2052);
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            this.fNameText.setLayoutData((Object)gd);
            this.fNameText.setFont(comp.getFont());
            this.fNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewPropertyDialog.this.updateButtons();
                }
            });
            return comp;
        }

        public String getName() {
            return this.fName;
        }

        protected void buttonPressed(int buttonId) {
            this.fName = buttonId == 0 ? this.fNameText.getText().trim() : null;
            super.buttonPressed(buttonId);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(WizardMessages.addPropertyDialogTitle);
        }

        protected void updateButtons() {
            String name = this.fNameText.getText().trim();
            this.getButton(0).setEnabled(name.length() > 0 && !this.usedValues.contains(name));
        }

        public void create() {
            super.create();
            this.updateButtons();
        }
    }

    static class PropertiesListEditor
    extends BaseListFieldEditor {
        public PropertiesListEditor(String name, String label, Object defaultValue) {
            super(name, label, defaultValue);
        }

        public List<Object> getValues() {
            return (List)this.getValue();
        }

        protected List<Object> runAddAction() {
            ArrayList<Object> added = new ArrayList<Object>();
            NewPropertyDialog dialog = new NewPropertyDialog(this.getLabelControl().getShell());
            dialog.usedValues = this.getValues();
            if (dialog.open() == 0) {
                added.add(dialog.getName());
                this.setValue(new ArrayList());
            }
            return added;
        }
    }
}

