/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.services.diagram.layout.persistence;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FileUtil;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionLabelEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramBendPointLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramConnectionLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramNodeLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.editor.internal.model.Flow;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.JobXMLEditor;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.layout.persistence.FileResourceStore2;

public class BatchDiagramLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    protected StandardDiagramLayout layoutModel;
    protected IEditorInput editorInput;
    private Listener diagramEditorPagePartListener;
    private Listener connectionPartListener;
    private Map<String, DiagramNodeBounds> nodeBounds;
    private Map<ConnectionHashKey, List<Point>> connectionBendPoints;
    private Map<ConnectionHashKey, Point> connectionLabelPositions;
    private boolean dirty;
    private Map<ConnectionHashKey, DiagramConnectionPart> connectionIdMap;
    private Map<String, DiagramNodePart> nodeIdMap;
    private boolean autoLayout = false;
    private static final String WORKSPACE_LAYOUT_FOLDER = ".metadata/.plugins/org.jboss.tools.batch.ui/layouts";

    protected void init() {
        super.init();
        this.editorInput = (IEditorInput)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getLocalModelElement().adapt(IEditorInput.class);
        this.nodeBounds = new HashMap<String, DiagramNodeBounds>();
        this.connectionBendPoints = new HashMap<ConnectionHashKey, List<Point>>();
        this.connectionLabelPositions = new HashMap<ConnectionHashKey, Point>();
        this.dirty = false;
        this.connectionPartListener = new FilteredListener<ConnectionEvent>(){

            protected void handleTypedEvent(ConnectionEvent event) {
                DiagramConnectionPart connPart = event.part();
                if (event instanceof ConnectionLabelEvent) {
                    if (((ConnectionLabelEvent)event).moveLabel()) {
                        BatchDiagramLayoutPersistenceService.this.write(connPart);
                    }
                } else if (event instanceof ConnectionBendpointsEvent) {
                    ConnectionBendpointsEvent bpEvent = (ConnectionBendpointsEvent)event;
                    if (bpEvent.reset()) {
                        if (BatchDiagramLayoutPersistenceService.this.autoLayout) {
                            BatchDiagramLayoutPersistenceService.this.addConnectionToPersistenceCache(event.part());
                            BatchDiagramLayoutPersistenceService.this.refreshDirtyState();
                        } else {
                            BatchDiagramLayoutPersistenceService.this.write(event.part());
                        }
                    } else {
                        BatchDiagramLayoutPersistenceService.this.write(event.part());
                    }
                }
            }
        };
        try {
            this.load();
            this.refreshPersistedPartsCache();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        this.addDiagramPartListener();
    }

    public void dispose() {
        if (this.diagramEditorPagePartListener != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).detach(this.diagramEditorPagePartListener);
        }
    }

    protected StandardDiagramLayout initLayoutModel() {
        StandardDiagramLayout layoutModel = null;
        try {
            IEditorPart editor = BatchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(this.editorInput);
            String flow = null;
            Job job = editor instanceof JobXMLEditor ? ((JobXMLEditor)editor).getSchema() : null;
            flow = editor instanceof JobXMLEditor && ((JobXMLEditor)editor).getCurrentDiagramModel() instanceof Flow ? (String)((Flow)((JobXMLEditor)editor).getCurrentDiagramModel()).getId().content() : "Root";
            File layoutFile = this.getLayoutPersistenceFile();
            if (layoutFile != null) {
                XmlResourceStore resourceStore = new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore2(layoutFile, flow, job));
                layoutModel = (StandardDiagramLayout)StandardDiagramLayout.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
            }
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return layoutModel;
    }

    public File getLayoutPersistenceFile() throws IOException, CoreException {
        String fileName = this.computeLayoutFileName(this.editorInput);
        if (fileName != null) {
            return this.getLayoutPersistenceFile(fileName);
        }
        return null;
    }

    private File getLayoutPersistenceFile(String fileName) throws IOException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File layoutFolder = workspaceRoot.getLocation().toFile();
        if (!(layoutFolder = new File(layoutFolder, WORKSPACE_LAYOUT_FOLDER)).exists()) {
            FileUtil.mkdirs((File)layoutFolder);
        }
        File layoutFile = new File(layoutFolder, fileName);
        return layoutFile;
    }

    protected String computeLayoutFileName(IEditorInput editorInput) throws CoreException, IOException {
        IStorageEditorInput storageEditorInput;
        IPath storagePath;
        String uniquePath = null;
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            IFile ifile = fileEditorInput.getFile();
            uniquePath = ifile.getLocation().toPortableString();
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreInput = (FileStoreEditorInput)editorInput;
            IFileStore store = EFS.getStore((URI)fileStoreInput.getURI());
            File localFile = store.toLocalFile(0, null);
            if (localFile == null) {
                localFile = store.toLocalFile(4096, null);
            }
            if (localFile == null) {
                throw new IllegalArgumentException();
            }
            uniquePath = localFile.getCanonicalPath();
        } else if (editorInput instanceof IStorageEditorInput && (storagePath = (storageEditorInput = (IStorageEditorInput)editorInput).getStorage().getFullPath()) != null) {
            uniquePath = storagePath.toPortableString();
        }
        return uniquePath != null ? MiscUtil.createStringDigest((String)uniquePath) : null;
    }

    public void load() throws ResourceStoreException, CoreException, IOException {
        this.layoutModel = this.initLayoutModel();
        if (this.layoutModel == null) {
            return;
        }
        Boolean gridVisible = (Boolean)this.layoutModel.getGridLayout().isVisible().content();
        Boolean showGuides = (Boolean)this.layoutModel.getGuidesLayout().isVisible().content();
        if (gridVisible != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setGridVisible(gridVisible.booleanValue());
        }
        if (showGuides != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setShowGuides(showGuides.booleanValue());
        }
        ElementList nodes = this.layoutModel.getDiagramNodesLayout();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramNodeLayout node : nodes) {
            String nodeId = (String)node.getNodeId().content();
            DiagramNodePart nodePart = this.getNodePart(nodeId);
            int x = (Integer)node.getX().content();
            int y = (Integer)node.getY().content();
            int width = (Integer)node.getWidth().content();
            int height = (Integer)node.getHeight().content();
            if (nodePart != null) {
                nodePart.setNodeBounds(new DiagramNodeBounds(x, y, width, height, false, false));
            }
            Iterator connList = node.getEmbeddedConnectionsLayout();
            Iterator iterator = connList.iterator();
            while (iterator.hasNext()) {
                DiagramConnectionLayout connLayout = (DiagramConnectionLayout)iterator.next();
                String connId = (String)connLayout.getConnectionId().content();
                ElementList bps = connLayout.getConnectionBendpoints();
                DiagramConnectionPart connPart = this.getConnectionPart(connService, ConnectionHashKey.createKey((String)nodeId, (String)connId));
                if (connPart == null) continue;
                int index = 0;
                for (DiagramBendPointLayout pt : bps) {
                    connPart.addBendpoint(index++, ((Integer)pt.getX().content()).intValue(), ((Integer)pt.getY().content()).intValue());
                }
                if (connLayout.getLabelX().content(false) == null || connLayout.getLabelY().content(false) == null) continue;
                Point labelPos = new Point(((Integer)connLayout.getLabelX().content()).intValue(), ((Integer)connLayout.getLabelY().content()).intValue());
                connPart.setLabelPosition(labelPos);
            }
        }
        ElementList connList = this.layoutModel.getDiagramConnectionsLayout();
        for (DiagramConnectionLayout connLayout : connList) {
            String connId = (String)connLayout.getConnectionId().content();
            DiagramConnectionPart connPart = this.getConnectionPart(connService, ConnectionHashKey.createKey(null, (String)connId));
            ElementList bps = connLayout.getConnectionBendpoints();
            if (connPart == null) continue;
            int index = 0;
            for (DiagramBendPointLayout pt : bps) {
                connPart.addBendpoint(index++, ((Integer)pt.getX().content()).intValue(), ((Integer)pt.getY().content()).intValue());
            }
            ArrayList bendPoints = new ArrayList();
            bendPoints.addAll(connPart.getBendpoints());
            if (connLayout.getLabelX().content(false) == null || connLayout.getLabelY().content(false) == null) continue;
            Point labelPos = new Point(((Integer)connLayout.getLabelX().content()).intValue(), ((Integer)connLayout.getLabelY().content()).intValue());
            connPart.setLabelPosition(labelPos);
        }
        for (DiagramConnectionPart connPart : connService.list()) {
            connPart.attach(this.connectionPartListener);
        }
    }

    public void save() {
        if (this.layoutModel == null) {
            return;
        }
        this.addNodeBoundsToModel();
        this.addConnectionsToModel();
        this.refreshPersistedPartsCache();
        try {
            this.layoutModel.resource().save();
        }
        catch (ResourceStoreException rse) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)rse);
        }
        this.dirty = false;
    }

    private void read(DiagramNodePart nodePart) {
        String id = nodePart.getId();
        if (this.nodeBounds.containsKey(id) && this.nodeBounds.get(id) != null) {
            nodePart.setNodeBounds(this.nodeBounds.get(id));
        }
    }

    private void write(DiagramNodePart nodePart) {
        this.refreshDirtyState();
    }

    public DiagramLayoutPersistenceService.DiagramConnectionInfo read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        if (this.connectionBendPoints.containsKey(key)) {
            DiagramLayoutPersistenceService.DiagramConnectionInfo connectionInfo = new DiagramLayoutPersistenceService.DiagramConnectionInfo(this.connectionBendPoints.get(key), this.connectionLabelPositions.get(key));
            return connectionInfo;
        }
        return null;
    }

    private void write(DiagramConnectionPart connPart) {
        this.refreshDirtyState();
    }

    private void setGridVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGridLayout().setVisible(Boolean.valueOf(visible));
        }
    }

    private void setGuidesVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGuidesLayout().setVisible(Boolean.valueOf(visible));
        }
    }

    private void addNodeBoundsToModel() {
        this.layoutModel.getDiagramNodesLayout().clear();
        for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodeTemplates()) {
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                String nodeId = nodePart.getId();
                DiagramNodeLayout diagramNode = (DiagramNodeLayout)this.layoutModel.getDiagramNodesLayout().insert();
                diagramNode.setNodeId(nodeId);
                DiagramNodeBounds bounds = nodePart.getNodeBounds();
                diagramNode.setX(Integer.valueOf(bounds.getX()));
                diagramNode.setY(Integer.valueOf(bounds.getY()));
                if (nodePart.canResizeShape()) {
                    IDiagramNodeDef nodeDef = (IDiagramNodeDef)nodePart.definition();
                    if (bounds.getHeight() != -1 && (nodeDef.getHeight().content() != null && ((Integer)nodeDef.getHeight().content()).intValue() != bounds.getHeight() || nodeDef.getHeight().content() == null)) {
                        diagramNode.setHeight(Integer.valueOf(bounds.getHeight()));
                    }
                    if (bounds.getWidth() != -1 && (nodeDef.getWidth().content() != null && ((Integer)nodeDef.getWidth().content()).intValue() != bounds.getWidth() || nodeDef.getWidth().content() == null)) {
                        diagramNode.setWidth(Integer.valueOf(bounds.getWidth()));
                    }
                }
                diagramNode.getEmbeddedConnectionsLayout().clear();
                if (nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate() == null) continue;
                List<DiagramConnectionPart> connParts = this.getEmbedded(nodePart);
                for (DiagramConnectionPart connPart : connParts) {
                    String connId = connPart.getId();
                    DiagramConnectionLayout conn = null;
                    List connBendPoints = connPart.getBendpoints();
                    if (connBendPoints.size() > 0) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                        for (Point pt : connBendPoints) {
                            DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                            pt2.setX(Integer.valueOf(pt.getX()));
                            pt2.setY(Integer.valueOf(pt.getY()));
                        }
                    }
                    if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
                    if (conn == null) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                    }
                    conn.setLabelX(Integer.valueOf(connPart.getLabelPosition().getX()));
                    conn.setLabelY(Integer.valueOf(connPart.getLabelPosition().getY()));
                }
            }
        }
    }

    private List<DiagramConnectionPart> getEmbedded(DiagramNodePart nodePart) {
        ArrayList<DiagramConnectionPart> connParts = new ArrayList<DiagramConnectionPart>();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        List list = connService.list();
        for (DiagramConnectionPart c : list) {
            if (c.getEndpoint1() != nodePart.getLocalModelElement() || !this.isEmbedded(c)) continue;
            connParts.add(c);
        }
        return connParts;
    }

    private boolean isEmbedded(DiagramConnectionPart c) {
        return c != null && "org.eclipse.sapphire.ui.diagram.internal.StandardEmbeddedConnectionPart".equals(c.getClass().getName());
    }

    private void addConnectionsToModel() {
        this.layoutModel.getDiagramConnectionsLayout().clear();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            if (!connPart.removable() || this.isEmbedded(connPart)) continue;
            String id = connPart.getId();
            DiagramConnectionLayout conn = null;
            List connBendPoints = connPart.getBendpoints();
            if (connBendPoints.size() > 0) {
                conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                conn.setConnectionId(id);
                for (Point pt : connBendPoints) {
                    DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                    pt2.setX(Integer.valueOf(pt.getX()));
                    pt2.setY(Integer.valueOf(pt.getY()));
                }
            }
            if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
            if (conn == null) {
                conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                conn.setConnectionId(id);
            }
            conn.setLabelX(Integer.valueOf(connPart.getLabelPosition().getX()));
            conn.setLabelY(Integer.valueOf(connPart.getLabelPosition().getY()));
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = nodePart.getId();
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        this.connectionBendPoints.put(connKey, connPart.getBendpoints());
        if (connPart.getLabel() != null && connPart.getLabelPosition() != null) {
            this.connectionLabelPositions.put(connKey, new Point(connPart.getLabelPosition()));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            if (!connPart.removable()) continue;
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }

    private void addDiagramPartListener() {
        this.diagramEditorPagePartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramNodeEvent) {
                    BatchDiagramLayoutPersistenceService.this.handleDiagramNodeEvent((DiagramNodeEvent)event);
                } else if (event instanceof DiagramPageEvent) {
                    BatchDiagramLayoutPersistenceService.this.handleDiagramPageEvent((DiagramPageEvent)event);
                } else if (event instanceof SapphireDiagramEditorPagePart.PreAutoLayoutEvent) {
                    BatchDiagramLayoutPersistenceService.this.autoLayout = true;
                } else if (event instanceof SapphireDiagramEditorPagePart.PostAutoLayoutEvent) {
                    BatchDiagramLayoutPersistenceService.this.autoLayout = false;
                } else if (event instanceof ConnectionAddEvent) {
                    BatchDiagramLayoutPersistenceService.this.handleConnectionAddEvent((ConnectionAddEvent)event);
                } else if (event instanceof ConnectionDeleteEvent) {
                    BatchDiagramLayoutPersistenceService.this.handleConnectionDeleteEvent((ConnectionDeleteEvent)event);
                }
            }
        };
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).attach(this.diagramEditorPagePartListener);
    }

    private void handleDiagramNodeEvent(DiagramNodeEvent event) {
        DiagramNodePart nodePart = event.part();
        if (event instanceof DiagramNodeAddEvent) {
            this.read(nodePart);
        } else if (event instanceof DiagramNodeDeleteEvent) {
            this.refreshDirtyState();
        } else if (event instanceof DiagramNodeMoveEvent) {
            DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
            if (nodeBounds.isAutoLayout()) {
                this.addNodeToPersistenceCache(nodePart);
                this.refreshDirtyState();
            } else if (!nodeBounds.isDefaultPosition()) {
                this.write(event.part());
            }
        }
    }

    protected void handleConnectionAddEvent(ConnectionAddEvent event) {
        DiagramConnectionPart connPart = event.part();
        connPart.attach(this.connectionPartListener);
        DiagramLayoutPersistenceService.DiagramConnectionInfo connInfo = this.read(connPart);
        if (connInfo != null) {
            connPart.resetBendpoints(connInfo.getBendPoints());
            if (connInfo.getLabelPosition() != null) {
                connPart.setLabelPosition(connInfo.getLabelPosition());
            }
        }
    }

    protected void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        this.refreshDirtyState();
    }

    private void handleDiagramPageEvent(DiagramPageEvent event) {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.part();
        switch (event.getDiagramPageEventType()) {
            case GridStateChange: {
                this.setGridVisible(diagramPart.isGridVisible());
                break;
            }
            case GuideStateChange: {
                this.setGuidesVisible(diagramPart.isShowGuides());
                break;
            }
            case DiagramSave: {
                this.save();
                break;
            }
        }
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = nodePart.getId();
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals((Object)oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        List bendpoints = connPart.getBendpoints();
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            List<Point> oldBendpoints = this.connectionBendPoints.get(key);
            if (bendpoints.size() != oldBendpoints.size()) {
                changed = true;
            } else {
                int i = 0;
                while (i < bendpoints.size()) {
                    Point newPt = (Point)bendpoints.get(i);
                    Point oldPt = oldBendpoints.get(i);
                    if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!changed && connPart.getLabel() != null) {
                Point newPos = connPart.getLabelPosition();
                Point oldPos = this.connectionLabelPositions.get(key);
                if (newPos == null && oldPos != null || newPos != null && oldPos == null || newPos != null && oldPos != null && !newPos.equals((Object)oldPos)) {
                    changed = true;
                }
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        if (!((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).disposed()) {
            for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
                if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
                changed = true;
                break;
            }
            ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
            for (DiagramConnectionPart connPart : connService.list()) {
                if (connPart.getLocalModelElement().disposed() || !connPart.removable() || !this.isConnectionLayoutChanged(connPart)) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast((Event)new DiagramLayoutPersistenceService.DirtyStateEvent((Service)this, before, after));
        }
    }

    private DiagramConnectionPart getConnectionPart(ConnectionService connService, ConnectionHashKey connId) {
        if (this.connectionIdMap == null) {
            this.connectionIdMap = new HashMap<ConnectionHashKey, DiagramConnectionPart>();
            for (DiagramConnectionPart connPart : connService.list()) {
                this.connectionIdMap.put(ConnectionHashKey.createKey((DiagramConnectionPart)connPart), connPart);
            }
        }
        return this.connectionIdMap.get(connId);
    }

    private DiagramNodePart getNodePart(String nodeId) {
        if (this.nodeIdMap == null) {
            this.nodeIdMap = new HashMap<String, DiagramNodePart>();
            for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
                this.nodeIdMap.put(nodePart.getId(), nodePart);
            }
        }
        return this.nodeIdMap.get(nodeId);
    }
}

