/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.services.diagram.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.NextAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.BatchDiagramConnectionEventHandler;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.BatchDiagramConnectionService;

public class NextAttributeConnectionPart
extends DiagramConnectionPart {
    private NextAttributeElement srcElement;
    private FlowElement targetElement;
    private List<Point> bendpoints = new ArrayList<Point>();
    private BatchDiagramConnectionEventHandler eventHandler;
    private Listener listener;
    private ReferenceService<?> referenceService;
    private BatchDiagramConnectionService connectionService;

    public NextAttributeConnectionPart(NextAttributeElement srcElement, FlowElement targetElement, BatchDiagramConnectionService service, BatchDiagramConnectionEventHandler eventHandler) {
        this.srcElement = srcElement;
        this.targetElement = targetElement;
        this.connectionService = service;
        this.eventHandler = eventHandler;
    }

    protected void init() {
        this.initializeListeners();
        this.eventHandler.onConnectionAddEvent(new ConnectionAddEvent((DiagramConnectionPart)this));
    }

    private void initializeListeners() {
        ReferenceValue<String, FlowElement> reference = this.srcElement.getNext();
        if (reference.target() != null) {
            ((FlowElement)reference.target()).refresh();
        }
        this.referenceService = (ReferenceService)reference.service(ReferenceService.class);
        this.listener = new Listener(){

            public void handle(Event event) {
                FlowElement newTarget = (FlowElement)NextAttributeConnectionPart.this.srcElement.getNext().target();
                if (newTarget == null) {
                    NextAttributeConnectionPart.this.referenceService.detach((Listener)this);
                    NextAttributeConnectionPart.this.eventHandler.onConnectionDeleteEvent(new ConnectionDeleteEvent((DiagramConnectionPart)NextAttributeConnectionPart.this));
                } else if (newTarget != NextAttributeConnectionPart.this.targetElement) {
                    NextAttributeConnectionPart.this.changeTargetElement(newTarget);
                }
            }
        };
        this.referenceService.attach(this.listener);
    }

    private void changeTargetElement(FlowElement newTarget) {
        this.targetElement = newTarget;
        this.srcElement.setNext((String)this.targetElement.getId().content());
        this.removeAllBendpoints();
        this.eventHandler.onConnectionEndpointsEvent(new ConnectionEndpointsEvent((DiagramConnectionPart)this));
    }

    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Connection");
        contextSet.add("Sapphire.Diagram.Connection.Hidden");
        return contextSet;
    }

    public boolean removable() {
        return true;
    }

    public void remove() {
        this.srcElement.setNext(null);
        this.eventHandler.onConnectionDeleteEvent(new ConnectionDeleteEvent((DiagramConnectionPart)this));
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append("NextAttributeConnection");
        builder.append(this.connectionService.list().indexOf((Object)this));
        return builder.toString();
    }

    public String getConnectionTypeId() {
        return "NextAttributeConnection";
    }

    public IDiagramConnectionDef getConnectionDef() {
        return (IDiagramConnectionDef)this.definition;
    }

    public DiagramConnectionPart reconnect(DiagramNodePart newSrc, DiagramNodePart newTargetNode) {
        this.changeTargetElement((FlowElement)newTargetNode.getLocalModelElement());
        return this;
    }

    public boolean canEditLabel() {
        return false;
    }

    public List<Point> getBendpoints() {
        return new ArrayList<Point>(this.bendpoints);
    }

    public void removeAllBendpoints() {
        this.bendpoints.clear();
        this.broadcast((Event)new ConnectionBendpointsEvent((DiagramConnectionPart)this));
    }

    public void resetBendpoints(List<Point> bendpoints) {
        this.bendpoints = bendpoints;
        this.broadcast((Event)new ConnectionBendpointsEvent((DiagramConnectionPart)this, true));
    }

    public void addBendpoint(int index, int x, int y) {
        this.bendpoints.add(index, new Point(x, y));
        this.broadcast((Event)new ConnectionBendpointsEvent((DiagramConnectionPart)this));
    }

    public void updateBendpoint(int index, int x, int y) {
        this.bendpoints.set(index, new Point(x, y));
        this.broadcast((Event)new ConnectionBendpointsEvent((DiagramConnectionPart)this));
    }

    public void removeBendpoint(int index) {
        this.bendpoints.remove(index);
        this.broadcast((Event)new ConnectionBendpointsEvent((DiagramConnectionPart)this));
    }

    public String getLabel() {
        return null;
    }

    public void setLabel(String newValue) {
    }

    public Point getLabelPosition() {
        return null;
    }

    public void setLabelPosition(Point newPos) {
    }

    public Element getEndpoint1() {
        return this.srcElement;
    }

    public Element getEndpoint2() {
        return this.targetElement;
    }
}

