/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.services.contentproposal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.services.ContentProposal;
import org.eclipse.sapphire.services.ContentProposalService;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.util.ModelToBatchArtifactsMapping;

public class RefProposalService
extends ContentProposalService {
    private IBatchProject batchProject;
    private Class<? extends RefAttributeElement> elementClass;
    private ImageData image;

    protected void init() {
        super.init();
        IProject project = (IProject)((Job)this.context(Job.class)).adapt(IProject.class);
        this.batchProject = BatchCorePlugin.getBatchProject((IProject)project, (boolean)true);
        ElementType type = ((Element)this.context(Element.class)).type();
        this.image = type.image();
        Class c = type.getModelElementClass();
        if (!RefAttributeElement.class.isAssignableFrom(c)) {
            String msg = String.format("Incorrect model element type %s. %s is only applicable to subtypes of %s.", c.getName(), RefProposalService.class.getSimpleName(), RefAttributeElement.class.getName());
            ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
        }
        this.elementClass = c;
    }

    public ContentProposalService.Session session() {
        return new ContentProposalService.Session(this){

            protected List<ContentProposal> compute() {
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                if (RefProposalService.this.batchProject == null) {
                    return proposals;
                }
                for (BatchArtifactType type : ModelToBatchArtifactsMapping.getBatchArtifactTypes(RefProposalService.this.elementClass)) {
                    Collection artifacts = RefProposalService.this.batchProject.getArtifacts(type);
                    for (IBatchArtifact artifact : artifacts) {
                        if (!artifact.getName().contains(this.filter())) continue;
                        proposals.add(new ContentProposal(artifact.getName(), null, null, RefProposalService.this.image));
                    }
                }
                return proposals;
            }
        };
    }
}

