/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.hibernate.xml.model.impl.ComplexAttrUtil;
import org.jboss.tools.hibernate.xml.model.impl.HibConfigComplexPropertyImpl;
import org.w3c.dom.Element;

class HibConfigLoaderUtil
extends XModelObjectLoaderUtil {
    static String[] factoryFolders = new String[]{"Properties", "Mappings", "Caches", "Events", "Listeners"};

    HibConfigLoaderUtil() {
    }

    public boolean save(Element parent, XModelObject o) {
        if (o.getModelEntity().getName().equals("HibConfig3Security") && o.getAttributeValue("context").length() == 0 && o.getChildren().length == 0 && o.getAttributeValue("comment").length() == 0) {
            return true;
        }
        return super.save(parent, o);
    }

    private String[] getFolders(XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (entity.equals("HibConfig3SessionFactory")) {
            return factoryFolders;
        }
        return null;
    }

    public void loadChildren(Element element, XModelObject o) {
        super.loadChildren(element, o);
        String[] fs = this.getFolders(o);
        if (fs != null) {
            this.loadFolders(element, o, fs);
        }
    }

    protected void loadFolders(Element element, XModelObject o, String[] folders) {
        int i = 0;
        while (i < folders.length) {
            XModelObject c = o.getChildByPath(folders[i]);
            if (c != null) {
                super.loadChildren(element, c);
                if (i == 0) {
                    this.assignComplexProperties(c);
                }
            }
            ++i;
        }
    }

    public boolean saveChildren(Element element, XModelObject o) {
        boolean b = super.saveChildren(element, o);
        String[] fs = this.getFolders(o);
        if (fs != null) {
            this.saveFolders(element, o, fs);
        }
        return b;
    }

    protected boolean saveFolders(Element element, XModelObject o, String[] folders) {
        boolean b = true;
        int i = 0;
        while (i < folders.length) {
            XModelObject c = o.getChildByPath(folders[i]);
            if (c != null) {
                b &= super.saveChildren(element, c);
            }
            ++i;
        }
        return b;
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    private void assignComplexProperties(XModelObject folder) {
        XModelObject[] ps = folder.getChildren(HibConfigComplexPropertyImpl.ENT_PROPERTY);
        int i = 0;
        while (i < ps.length) {
            XModelEntity entity;
            XModelObject c;
            String n = ps[i].getAttributeValue("name");
            String v = ps[i].getAttributeValue("value");
            XAttribute attr = ComplexAttrUtil.findComplexAttr(folder, n);
            if (attr != null && (c = folder.getChildByPath((entity = attr.getModelEntity()).getAttribute("name").getDefaultValue())) != null) {
                c.setAttributeValue(attr.getName(), v);
            }
            ++i;
        }
    }
}

