/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;
import org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;

public class WrapExecutor {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final HashMap<WrapInfo, WrapResult> wrapSearchResults = new HashMap();
    private final HashSet<Token.WrapPolicy> usedTopPriorityWraps = new HashSet();
    private final LineAnalyzer lineAnalyzer;
    final TokenManager tm;
    final DefaultCodeFormatterOptions options;
    private final WrapInfo wrapInfoTemp = new WrapInfo();

    public WrapExecutor(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
        this.lineAnalyzer = new LineAnalyzer(tokenManager, options);
    }

    public void executeWraps() {
        int index = 0;
        while (index < this.tm.size()) {
            Token token = this.tm.get(index);
            while (true) {
                try {
                    int currentIndent = this.getWrapIndent(token);
                    this.wrapSearchResults.clear();
                    index = this.applyWraps(index, currentIndent);
                }
                catch (WrapRestartThrowable e) {
                    this.handleTopPriorityWraps(e);
                    continue;
                }
                break;
            }
            this.wrapSearchResults.clear();
            this.usedTopPriorityWraps.clear();
        }
        this.tm.traverse(0, new NLSTagHandler());
    }

    /*
     * Unable to fully structure code
     */
    private int applyWraps(int index, int indent) throws WrapRestartThrowable {
        wrapInfo = this.findWrapsCached((int)index, (int)indent).nextWrap;
        token = this.tm.get(index);
        ++index;
        token.setIndent(indent);
        groupEnd = token.getWrapPolicy() != null ? token.getWrapPolicy().groupEndIndex : -1;
        while (index < this.tm.size()) {
            token = this.tm.get(index);
            if (!token.isNextLineOnWrap() || !this.tm.get(this.tm.findFirstTokenInLine(index)).isWrappable()) ** GOTO lbl12
            token.breakBefore();
            return index;
lbl-1000:
            // 1 sources

            {
                wrapInfo = this.wrapSearchResults.get((Object)wrapInfo).nextWrap;
lbl12:
                // 2 sources

                ** while (wrapInfo != null && wrapInfo.wrapTokenIndex < index)
            }
lbl13:
            // 1 sources

            if (wrapInfo != null && wrapInfo.wrapTokenIndex == index) {
                token.breakBefore();
                this.handleOnColumnIndent(index, token.getWrapPolicy());
                this.checkTopPriorityWraps(index);
                index = this.applyWraps(index, wrapInfo.indent);
                continue;
            }
            v0 = isNewLine = this.tm.get(index - 1).getLineBreaksAfter() > 0 || token.getLineBreaksBefore() > 0;
            if (isNewLine) {
                if (token.getWrapPolicy() != null) {
                    this.handleOnColumnIndent(index, token.getWrapPolicy());
                    this.checkTopPriorityWraps(index);
                    newIndent = this.getWrapIndent(token);
                    if (newIndent < indent) {
                        return index;
                    }
                    wrapInfo = this.findWrapsCached((int)index, (int)newIndent).nextWrap;
                    if (newIndent > indent) {
                        index = this.applyWraps(index, newIndent);
                        continue;
                    }
                } else if (index > groupEnd) {
                    return index;
                }
            } else {
                this.checkForceWrap(token, indent);
            }
            token.setIndent(indent);
            ++index;
        }
        return index;
    }

    private WrapResult findWrapsCached(int startTokenIndex, int indent) throws WrapRestartThrowable {
        this.wrapInfoTemp.wrapTokenIndex = startTokenIndex;
        this.wrapInfoTemp.indent = indent;
        WrapResult wrapResult = this.wrapSearchResults.get(this.wrapInfoTemp);
        if (wrapResult == null && this.wrapSearchResults.containsKey(this.wrapInfoTemp)) {
            return null;
        }
        WrapResult wr = wrapResult;
        while (wr != null && wr.nextWrap != null) {
            WrapInfo wi = wr.nextWrap;
            Token token = this.tm.get(wi.wrapTokenIndex);
            if (token.getWrapPolicy().wrapParentIndex < startTokenIndex && this.getWrapIndent(token) != wi.indent) {
                wrapResult = null;
                break;
            }
            wr = this.wrapSearchResults.get(wi);
        }
        if (wrapResult == null) {
            Token token = this.tm.get(startTokenIndex);
            boolean wasLineBreak = token.getLineBreaksBefore() > 0;
            token.breakBefore();
            try {
                wrapResult = this.findWraps(startTokenIndex, indent);
            }
            finally {
                if (!wasLineBreak) {
                    token.clearLineBreaksBefore();
                }
            }
            WrapInfo wrapInfo = new WrapInfo(startTokenIndex, indent);
            this.wrapSearchResults.put(wrapInfo, wrapResult);
        }
        return wrapResult;
    }

    private WrapResult findWraps(int wrapTokenIndex, int indent) throws WrapRestartThrowable {
        Token nextLineToken;
        int lastIndex = this.lineAnalyzer.analyzeLine(wrapTokenIndex, indent);
        boolean lineExceeded = this.lineAnalyzer.lineExceeded;
        int lastPosition = this.lineAnalyzer.getLastPosition();
        int extraLines = this.lineAnalyzer.extraLines;
        int firstPotentialWrap = this.lineAnalyzer.firstPotentialWrap;
        int[] extraLinesPerComment = this.toArray(this.lineAnalyzer.extraLinesPerComment);
        int commentIndex = extraLinesPerComment.length;
        int[] topPriorityGroupStarts = this.toArray(this.lineAnalyzer.topPriorityGroupStarts);
        int topPriorityIndex = topPriorityGroupStarts.length - 1;
        int nearestGroupEnd = topPriorityIndex == -1 ? 0 : this.tm.get((int)topPriorityGroupStarts[topPriorityIndex]).getWrapPolicy().groupEndIndex;
        double bestTotalPenalty = this.getWrapPenalty(wrapTokenIndex, indent, lastIndex + 1, -1, WrapResult.NO_WRAP_NEEDED);
        int bestExtraLines = lineExceeded ? Integer.MAX_VALUE : extraLines;
        int bestNextWrap = -1;
        int bestIndent = 0;
        if (!(lineExceeded || this.options.join_wrapped_lines && this.options.wrap_outer_expressions_when_nested)) {
            return new WrapResult(bestTotalPenalty, bestExtraLines, null);
        }
        if (!(lineExceeded && firstPotentialWrap >= 0 || lastIndex + 1 >= this.tm.size() || (nextLineToken = this.tm.get(lastIndex + 1)).getWrapPolicy() == null || nextLineToken.getWrapPolicy().wrapMode == Token.WrapMode.FORCED || !this.tm.get(lastIndex).isComment() && !nextLineToken.isComment())) {
            bestIndent = this.getWrapIndent(nextLineToken);
            bestNextWrap = lastIndex + 1;
            WrapResult wrapResult = this.findWrapsCached(bestNextWrap, bestIndent);
            bestTotalPenalty = this.getWrapPenalty(wrapTokenIndex, indent, bestNextWrap, bestIndent, wrapResult);
            bestExtraLines = extraLines + wrapResult.totalExtraLines;
        }
        if (firstPotentialWrap < 0 && lineExceeded) {
            if (topPriorityGroupStarts.length > 0) {
                this.checkTopPriorityWraps(topPriorityGroupStarts[0]);
            }
            bestExtraLines = bestExtraLines == Integer.MAX_VALUE ? extraLines + lastPosition : (bestExtraLines += lastPosition);
        }
        int i = lastIndex;
        while (firstPotentialWrap >= 0 && i >= firstPotentialWrap) {
            block15: {
                Token token;
                block14: {
                    token = this.tm.get(i);
                    if (commentIndex > 0 && (token.tokenType == 1002 || token.tokenType == 1003)) {
                        extraLines -= extraLinesPerComment[--commentIndex];
                    }
                    if (topPriorityIndex < 0 || i > nearestGroupEnd) break block14;
                    if (i > topPriorityGroupStarts[topPriorityIndex]) break block15;
                    assert (i == topPriorityGroupStarts[topPriorityIndex]);
                    int n = nearestGroupEnd = --topPriorityIndex == -1 ? 0 : this.tm.get((int)topPriorityGroupStarts[topPriorityIndex]).getWrapPolicy().groupEndIndex;
                }
                if (token.isWrappable()) {
                    boolean isBetter;
                    int nextWrapIndent = this.getWrapIndent(token);
                    WrapResult nextWrapResult = this.findWrapsCached(i, nextWrapIndent);
                    double totalPenalty = this.getWrapPenalty(wrapTokenIndex, indent, i, nextWrapIndent, nextWrapResult);
                    int totalExtraLines = extraLines + nextWrapResult.totalExtraLines;
                    boolean bl = isBetter = totalExtraLines < bestExtraLines || bestExtraLines == Integer.MAX_VALUE;
                    if (!isBetter && totalExtraLines == bestExtraLines) {
                        boolean bl2 = isBetter = totalPenalty < bestTotalPenalty || bestTotalPenalty == Double.MAX_VALUE;
                    }
                    if (isBetter) {
                        bestTotalPenalty = totalPenalty;
                        bestExtraLines = totalExtraLines;
                        bestNextWrap = i;
                        bestIndent = nextWrapIndent;
                        if (!this.options.wrap_outer_expressions_when_nested) break;
                    }
                }
            }
            --i;
        }
        if (bestNextWrap == -1 && lineExceeded && topPriorityGroupStarts.length > 0) {
            this.checkTopPriorityWraps(topPriorityGroupStarts[0]);
        }
        return new WrapResult(bestTotalPenalty, bestExtraLines, bestNextWrap == -1 ? null : new WrapInfo(bestNextWrap, bestIndent));
    }

    private double getWrapPenalty(int lineStartIndex, int lineIndent, int wrapIndex, int wrapIndent, WrapResult wrapResult) throws WrapRestartThrowable {
        double penalty;
        Token.WrapPolicy wrapPolicy = null;
        Token wrapToken = null;
        if (wrapIndex < this.tm.size()) {
            wrapToken = this.tm.get(wrapIndex);
            wrapPolicy = wrapToken.getWrapPolicy();
            if (wrapIndent < 0) {
                wrapIndent = this.getWrapIndent(this.tm.get(wrapIndex));
            }
        }
        double d = penalty = wrapToken != null && wrapToken.isWrappable() ? this.getPenalty(wrapPolicy) : 0.0;
        if (wrapIndent > lineIndent) {
            penalty *= 1.1875;
        }
        Token lineStartToken = this.tm.get(lineStartIndex);
        Token.WrapPolicy lineStartWrapPolicy = lineStartToken.getWrapPolicy();
        if (wrapToken != null && wrapToken.isWrappable() && lineStartToken.isWrappable()) {
            int i = lineStartIndex + 1;
            while (i < wrapIndex) {
                Token.WrapPolicy intermediatePolicy = this.tm.get(i).getWrapPolicy();
                if (intermediatePolicy != null && intermediatePolicy.structureDepth < lineStartWrapPolicy.structureDepth && intermediatePolicy.structureDepth < wrapPolicy.structureDepth) {
                    penalty += this.getPenalty(intermediatePolicy) * 1.25;
                }
                ++i;
            }
        }
        WrapInfo nextWrap = wrapResult.nextWrap;
        boolean checkDepth = wrapToken != null && wrapToken.isWrappable() && (lineStartWrapPolicy == null || wrapPolicy.structureDepth >= lineStartWrapPolicy.structureDepth);
        double penaltyDiff = 0.0;
        while (checkDepth && nextWrap != null) {
            Token.WrapPolicy nextPolicy = this.tm.get(nextWrap.wrapTokenIndex).getWrapPolicy();
            if (nextPolicy.wrapParentIndex == wrapPolicy.wrapParentIndex || penaltyDiff != 0.0 && !wrapPolicy.isFirstInGroup) {
                penalty -= penaltyDiff * 1.25;
                break;
            }
            if (nextPolicy.structureDepth <= wrapPolicy.structureDepth) break;
            penaltyDiff = Math.max(penaltyDiff, this.getPenalty(nextPolicy));
            nextWrap = this.findWrapsCached((int)nextWrap.wrapTokenIndex, (int)nextWrap.indent).nextWrap;
        }
        return penalty + wrapResult.penalty;
    }

    private double getPenalty(Token.WrapPolicy policy) {
        return Math.exp(policy.structureDepth) * (double)policy.penaltyMultiplier;
    }

    private void checkForceWrap(Token token, int currentIndent) throws WrapRestartThrowable {
        int indent;
        if (token.isWrappable() && this.options.wrap_outer_expressions_when_nested && (indent = this.getWrapIndent(token)) < currentIndent) {
            token.breakBefore();
            throw new WrapRestartThrowable(-1);
        }
    }

    private void checkTopPriorityWraps(int wrapIndex) throws WrapRestartThrowable {
        Token.WrapPolicy wrapPolicy = this.tm.get(wrapIndex).getWrapPolicy();
        if (wrapPolicy != null && wrapPolicy.wrapMode == Token.WrapMode.TOP_PRIORITY && !this.usedTopPriorityWraps.contains(wrapPolicy)) {
            throw new WrapRestartThrowable(wrapIndex);
        }
    }

    private void handleTopPriorityWraps(WrapRestartThrowable restartException) {
        int wrapIndex = restartException.topPriorityWrap;
        if (wrapIndex < 0) {
            return;
        }
        Token.WrapPolicy wrapPolicy = this.tm.get(wrapIndex).getWrapPolicy();
        int parentIndex = wrapPolicy.wrapParentIndex;
        int i = wrapIndex;
        while (i > parentIndex) {
            Token token = this.tm.get(i);
            wrapPolicy = token.getWrapPolicy();
            if (wrapPolicy != null && wrapPolicy.wrapParentIndex == parentIndex) {
                if (wrapPolicy.wrapMode == Token.WrapMode.TOP_PRIORITY) {
                    token.breakBefore();
                    this.usedTopPriorityWraps.add(wrapPolicy);
                }
                if (wrapPolicy.isFirstInGroup) break;
            }
            --i;
        }
        boolean breakAfterPrevious = false;
        int i2 = wrapIndex + 1;
        while (i2 < this.tm.size()) {
            Token token = this.tm.get(i2);
            wrapPolicy = token.getWrapPolicy();
            if (wrapPolicy == null && (token.getLineBreaksBefore() > 0 || breakAfterPrevious)) break;
            if (wrapPolicy != null && wrapPolicy.wrapParentIndex == parentIndex) {
                if (wrapPolicy.isFirstInGroup) break;
                if (wrapPolicy.wrapMode == Token.WrapMode.TOP_PRIORITY) {
                    token.breakBefore();
                    this.usedTopPriorityWraps.add(wrapPolicy);
                }
            }
            breakAfterPrevious = token.getLineBreaksAfter() > 0;
            ++i2;
        }
    }

    private int[] toArray(List<Integer> list) {
        if (list.isEmpty()) {
            return EMPTY_ARRAY;
        }
        int[] result = new int[list.size()];
        int i = 0;
        for (int item : list) {
            result[i++] = item;
        }
        return result;
    }

    private void handleOnColumnIndent(int tokenIndex, Token.WrapPolicy wrapPolicy) {
        if (wrapPolicy != null && wrapPolicy.indentOnColumn && !wrapPolicy.isFirstInGroup && this.options.tab_char == 1 && !this.options.use_tabs_only_for_leading_indentations) {
            int i = tokenIndex - 1;
            while (i >= 0) {
                Token token = this.tm.get(i);
                Token.WrapPolicy wrapPolicy2 = token.getWrapPolicy();
                if (wrapPolicy2 != null && wrapPolicy2.isFirstInGroup && wrapPolicy2.wrapParentIndex == wrapPolicy.wrapParentIndex) {
                    token.setAlign(this.getWrapIndent(token));
                    break;
                }
                --i;
            }
        }
    }

    int getWrapIndent(Token token) {
        Token.WrapPolicy policy = token.getWrapPolicy();
        if (policy == null) {
            return token.getIndent();
        }
        if (this.options.never_indent_line_comments_on_first_column && token.tokenType == 1001 && token.getIndent() == 0) {
            return 0;
        }
        if (this.options.never_indent_block_comments_on_first_column && token.tokenType == 1002 && token.getIndent() == 0) {
            return 0;
        }
        Token wrapParent = this.tm.get(policy.wrapParentIndex);
        int wrapIndent = wrapParent.getIndent();
        if (policy.indentOnColumn) {
            wrapIndent = this.tm.getPositionInLine(policy.wrapParentIndex);
            wrapIndent += this.tm.getLength(wrapParent, wrapIndent);
            if (wrapParent.isSpaceAfter() || this.tm.get(policy.wrapParentIndex + 1).isSpaceBefore()) {
                ++wrapIndent;
            }
        }
        return this.tm.toIndent(wrapIndent += policy.extraIndent, true);
    }

    private class LineAnalyzer
    extends TokenTraverser {
        private final CommentWrapExecutor commentWrapper;
        private int lineIndent;
        int firstPotentialWrap;
        int extraLines;
        boolean lineExceeded;
        final List<Integer> extraLinesPerComment = new ArrayList<Integer>();
        final List<Integer> topPriorityGroupStarts = new ArrayList<Integer>();
        int currentTopPriorityGroupEnd;
        private boolean isNLSTagInLine;

        public LineAnalyzer(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
            this.commentWrapper = new CommentWrapExecutor(tokenManager, options);
        }

        public int analyzeLine(int startIndex, int indent) {
            Token startToken = WrapExecutor.this.tm.get(startIndex);
            this.counter = WrapExecutor.this.tm.toIndent(indent, startToken.isWrappable());
            this.lineIndent = indent;
            this.firstPotentialWrap = -1;
            this.extraLines = 0;
            this.extraLinesPerComment.clear();
            this.topPriorityGroupStarts.clear();
            this.currentTopPriorityGroupEnd = -1;
            this.isNLSTagInLine = false;
            return WrapExecutor.this.tm.traverse(startIndex, this);
        }

        @Override
        protected boolean token(Token token, int index) {
            boolean isLineEnd;
            if (token.tokenType == 1001) {
                return false;
            }
            if (token.hasNLSTag()) {
                this.isNLSTagInLine = true;
            }
            if (token.isWrappable()) {
                Token.WrapPolicy wrapPolicy = token.getWrapPolicy();
                if (wrapPolicy.wrapMode == Token.WrapMode.TOP_PRIORITY && this.getLineBreaksBefore() == 0 && index > this.currentTopPriorityGroupEnd) {
                    this.topPriorityGroupStarts.add(index);
                    this.currentTopPriorityGroupEnd = wrapPolicy.groupEndIndex;
                }
                if (this.firstPotentialWrap < 0 && WrapExecutor.this.getWrapIndent(token) < this.counter) {
                    this.firstPotentialWrap = index;
                }
            }
            if (token.getAlign() > 0) {
                this.counter = token.getAlign();
            } else if (this.isSpaceBefore() && this.getLineBreaksBefore() == 0 && index > 0) {
                ++this.counter;
            }
            if (token.isComment()) {
                this.counter = this.commentWrapper.wrapMultiLineComment(token, this.counter, true, this.isNLSTagInLine);
                this.extraLines += this.commentWrapper.getLinesCount() - 1;
                this.extraLinesPerComment.add(this.commentWrapper.getLinesCount() - 1);
            } else {
                this.counter += WrapExecutor.this.tm.getLength(token, this.counter);
            }
            boolean bl = this.lineExceeded = this.counter > WrapExecutor.this.options.page_width;
            if (this.lineExceeded && this.firstPotentialWrap >= 0) {
                return false;
            }
            if (!token.isNextLineOnWrap()) {
                token.setIndent(this.lineIndent);
            }
            boolean bl2 = isLineEnd = this.getLineBreaksAfter() > 0 || this.getNext() == null;
            assert (!token.isNextLineOnWrap() || isLineEnd);
            return !isLineEnd;
        }

        public int getLastPosition() {
            return this.counter;
        }
    }

    private class NLSTagHandler
    extends TokenTraverser {
        private final ArrayList<Token> nlsTags = new ArrayList();

        @Override
        protected boolean token(Token token, int index) {
            if (token.hasNLSTag()) {
                this.nlsTags.add(token.getNLSTag());
            }
            if (this.getLineBreaksAfter() > 0 || this.getNext() == null) {
                Token lineComment = token;
                if (token.tokenType != 1001) {
                    if (this.nlsTags.isEmpty()) {
                        return true;
                    }
                    lineComment = new Token(token.originalEnd + 1, token.originalEnd + 1, 1001);
                    lineComment.breakAfter();
                    lineComment.spaceBefore();
                    lineComment.setAlign(WrapExecutor.this.tm.getNLSAlign(index));
                    lineComment.setInternalStructure(new ArrayList<Token>());
                    WrapExecutor.this.tm.insert(index + 1, lineComment);
                    this.structureChanged();
                    return true;
                }
                List<Token> structure = lineComment.getInternalStructure();
                if (structure == null) {
                    if (this.nlsTags.isEmpty()) {
                        return true;
                    }
                    structure = new ArrayList<Token>();
                    structure.add(lineComment);
                    lineComment.setInternalStructure(structure);
                }
                boolean isPrefixMissing = false;
                int i = 0;
                while (i < structure.size()) {
                    Token fragment = structure.get(i);
                    if (fragment.hasNLSTag()) {
                        if (!this.nlsTags.remove(fragment)) {
                            if (i == 0) {
                                isPrefixMissing = true;
                            }
                            structure.remove(i--);
                        } else {
                            isPrefixMissing = false;
                        }
                    } else if (isPrefixMissing) {
                        int pos = fragment.originalStart;
                        while (pos <= fragment.originalEnd && ScannerHelper.isWhitespace(WrapExecutor.this.tm.charAt(pos))) {
                            ++pos;
                        }
                        if (pos > fragment.originalEnd) {
                            structure.remove(i--);
                        } else {
                            String fragmentString;
                            if (pos > fragment.originalStart) {
                                fragment = new Token(pos, fragment.originalEnd, 1001);
                                structure.set(i, fragment);
                            }
                            if (!(fragmentString = WrapExecutor.this.tm.toString(fragment)).startsWith("//")) {
                                Token prefix = new Token(lineComment.originalStart, lineComment.originalStart + 1, 1001);
                                prefix.spaceBefore();
                                structure.add(i, prefix);
                            }
                            isPrefixMissing = false;
                        }
                    }
                    ++i;
                }
                structure.addAll(this.nlsTags);
                if (structure.isEmpty()) {
                    WrapExecutor.this.tm.remove(index);
                    this.structureChanged();
                }
                this.nlsTags.clear();
            }
            return true;
        }
    }

    private static class WrapInfo {
        public int wrapTokenIndex;
        public int indent;

        public WrapInfo(int wrapIndex, int indent) {
            this.wrapTokenIndex = wrapIndex;
            this.indent = indent;
        }

        public WrapInfo() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.indent;
            result = 31 * result + this.wrapTokenIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrapInfo other = (WrapInfo)obj;
            if (this.indent != other.indent) {
                return false;
            }
            return this.wrapTokenIndex == other.wrapTokenIndex;
        }
    }

    private static class WrapRestartThrowable
    extends Throwable {
        private static final long serialVersionUID = -2980600077230803443L;
        public final int topPriorityWrap;

        public WrapRestartThrowable(int topPriorityWrap) {
            super(null, null, false, false);
            this.topPriorityWrap = topPriorityWrap;
        }
    }

    private static class WrapResult {
        public static final WrapResult NO_WRAP_NEEDED = new WrapResult(0.0, 0, null);
        public final double penalty;
        public final int totalExtraLines;
        public final WrapInfo nextWrap;

        WrapResult(double penalty, int extraLines, WrapInfo nextWrap) {
            this.penalty = penalty;
            this.totalExtraLines = extraLines;
            this.nextWrap = nextWrap;
        }
    }
}

