/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.egit.ui.util;

import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class EGitUIUtils {
    public static final CloneOperation.PostCloneTask ADD_TO_REPOVIEW_TASK;
    private static final boolean IS_LEGACY_EGIT;
    private static final String DEFAULT_REPOSITORY_PATH;

    static {
        Version version41;
        ADD_TO_REPOVIEW_TASK = new CloneOperation.PostCloneTask(){

            public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
                RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
                repositoryUtil.addConfiguredRepository(repository.getDirectory());
            }
        };
        DEFAULT_REPOSITORY_PATH = String.valueOf(System.getProperty("user.home")) + File.separator + "git";
        Version currentVersion = Platform.getBundle((String)"org.eclipse.egit.ui").getVersion();
        IS_LEGACY_EGIT = currentVersion.compareTo(version41 = new Version(4, 1, 0)) < 0;
    }

    public static String getEGitDefaultRepositoryPath() {
        if (IS_LEGACY_EGIT) {
            return Activator.getDefault().getPreferenceStore().getString("default_repository_dir");
        }
        try {
            Method getDefaultRepositoryDir = RepositoryUtil.class.getMethod("getDefaultRepositoryDir", new Class[0]);
            return (String)getDefaultRepositoryDir.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return DEFAULT_REPOSITORY_PATH;
        }
    }

    public static void ensureEgitUIIsStarted() {
        Activator.getDefault();
    }

    public static void openGitSharingWizard(Shell shell, IProject project) {
        if (project == null) {
            return;
        }
        SharingWizard wizard = new SharingWizard();
        wizard.init(PlatformUI.getWorkbench(), project);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.open();
    }
}

