/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jboss.tools.foundation.security.Messages;

public class DescriptiveStorageLoginDialog
extends FormDialog {
    private static final String HELP_ID = "org.jboss.tools.foundation.security.linux.sec_storage_context";
    private static final String DIGEST_ALGORITHM = "MD5";
    protected Text password;
    protected Text confirm;
    private Label statusLabel;
    protected Button showPassword;
    protected Button okButton;
    protected PBEKeySpec generatedPassword;
    protected final boolean confirmPassword;
    protected final boolean passwordChange;
    protected final String location;

    public DescriptiveStorageLoginDialog(boolean confirmPassword, boolean passwordChange, String location) {
        super(DescriptiveStorageLoginDialog.getWorkbenchShell());
        this.confirmPassword = confirmPassword;
        this.passwordChange = passwordChange;
        this.location = location;
    }

    private static Shell getWorkbenchShell() {
        IWorkbenchWindow window;
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    public PBEKeySpec getGeneratedPassword() {
        return this.generatedPassword;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, Messages.ButtonLogin, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, Messages.ButtonExit, false);
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DialogTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
        shell.setSize(700, 500);
    }

    protected void createFormContent(IManagedForm mform) {
        final ScrolledForm mainForm = mform.getForm();
        FormToolkit toolkit = new FormToolkit(mainForm.getDisplay());
        Composite body = mainForm.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        Section descriptionSection = toolkit.createSection(body, 322);
        descriptionSection.setText(Messages.DescriptionTitle);
        descriptionSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        FormText descriptionText = toolkit.createFormText((Composite)descriptionSection, true);
        descriptionText.setText(Messages.SecureDescription, true, true);
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        descriptionText.setLayoutData((Object)td);
        descriptionSection.setClient((Control)descriptionText);
        String titleMsg = this.confirmPassword ? Messages.PasswordChangeTitle : (this.passwordChange ? Messages.MessageLoginChange : Messages.DialogTitle);
        toolkit.createLabel(body, "");
        Section passwordSection = toolkit.createSection(body, 322);
        passwordSection.setText(titleMsg);
        passwordSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        passwordSection.setLayoutData((Object)td);
        Composite passwordComposite = toolkit.createComposite((Composite)passwordSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(passwordComposite);
        Label passwordLabel = toolkit.createLabel(passwordComposite, Messages.LabelPassword, 16384);
        GridDataFactory.swtDefaults().applyTo((Control)passwordLabel);
        this.password = toolkit.createText(passwordComposite, "", 18432);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.password);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DescriptiveStorageLoginDialog.this.okButton.setEnabled(DescriptiveStorageLoginDialog.this.validatePassword(mainForm));
            }
        });
        this.password.setFocus();
        if (this.confirmPassword) {
            Label passwordConfLabel = toolkit.createLabel(passwordComposite, Messages.LabelConfirm, 16384);
            GridDataFactory.swtDefaults().applyTo((Control)passwordConfLabel);
            this.confirm = toolkit.createText(passwordComposite, "", 18432);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.confirm);
            this.confirm.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    DescriptiveStorageLoginDialog.this.okButton.setEnabled(DescriptiveStorageLoginDialog.this.validatePassword(mainForm));
                }
            });
        } else {
            this.confirm = null;
        }
        Label fillerLabel = toolkit.createLabel(passwordComposite, "", 16384);
        GridDataFactory.swtDefaults().applyTo((Control)fillerLabel);
        this.showPassword = toolkit.createButton(passwordComposite, Messages.ShowPassword, 131104);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.showPassword);
        this.showPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DescriptiveStorageLoginDialog.this.passwordVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DescriptiveStorageLoginDialog.this.passwordVisibility();
            }
        });
        this.showPassword.setSelection(false);
        this.passwordVisibility();
        if (this.location != null) {
            Group locationGroup = new Group(passwordComposite, 0);
            locationGroup.setText(Messages.LocationGroup);
            toolkit.adapt((Composite)locationGroup);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)locationGroup);
            GridLayoutFactory.fillDefaults().applyTo((Composite)locationGroup);
            Label locationLabel = toolkit.createLabel((Composite)locationGroup, new Path(this.location).toOSString(), 64);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)locationLabel);
        }
        passwordSection.setClient((Control)passwordComposite);
        toolkit.createLabel(body, "");
        this.statusLabel = toolkit.createLabel(body, "");
        TableWrapData td2 = new TableWrapData(128);
        td2.colspan = 1;
        td2.grabHorizontal = true;
        this.statusLabel.setLayoutData((Object)td2);
        this.statusLabel.setForeground(mainForm.getDisplay().getSystemColor(3));
    }

    protected void passwordVisibility() {
        boolean selected = this.showPassword.getSelection();
        if (selected) {
            this.password.setEchoChar('\u0000');
            if (this.confirm != null) {
                this.confirm.setEchoChar('\u0000');
            }
        } else {
            this.password.setEchoChar('*');
            if (this.confirm != null) {
                this.confirm.setEchoChar('*');
            }
        }
    }

    protected boolean validatePassword(ScrolledForm mainForm) {
        String password2;
        String password1 = this.password.getText();
        if (password1 == null || password1.length() == 0) {
            this.statusLabel.setText(Messages.MessageEmptyPassword);
            return false;
        }
        if (this.confirm != null && !password1.equals(password2 = this.confirm.getText())) {
            this.statusLabel.setText(Messages.MessageNoMatch);
            return false;
        }
        this.statusLabel.setText("");
        return true;
    }

    protected void okPressed() {
        String internalPassword;
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] digested = digest.digest(new String(this.password.getText()).getBytes());
            internalPassword = EncodingUtils.encodeBase64((byte[])digested);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            internalPassword = this.password.getText();
        }
        this.generatedPassword = new PBEKeySpec(internalPassword.toCharArray());
        super.okPressed();
    }
}

