/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control.many;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class CheckboxTableControlBuilder
extends ControlBuilder<Table> {
    private static final String SELECT_ALL_BUTTON_DATA_KEY = "selectAllButton";
    private static final String SELECT_NONE_BUTTON_DATA_KEY = "selectNoneButton";
    private static final Set<Table> TABLE_STATUS_CHANGE = Sets.getConcurrentSet();

    @Override
    public Table build(final ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite container) {
        Iterable valueChoices;
        Group group = new Group(container, 32);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 3;
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)layoutData);
        group.setText(InputComponents.getLabelFor(input, (boolean)false));
        Composite groupPanel = new Composite((Composite)group, 0);
        groupPanel.setLayoutData((Object)new GridData(768));
        groupPanel.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table(groupPanel, 2848);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.widthHint = 300;
        tableLayoutData.heightHint = 300;
        table.setLayoutData((Object)tableLayoutData);
        table.setToolTipText(input.getDescription());
        UISelectMany selectMany = (UISelectMany)input;
        Converter<Object, String> itemLabelConverter = this.getConverter((UISelectMany<Object>)selectMany);
        final LinkedHashSet<Object> data = new LinkedHashSet<Object>();
        Iterable defaultValues = selectMany.getValue();
        if (defaultValues != null) {
            for (Object object : defaultValues) {
                String item = (String)itemLabelConverter.convert(object);
                if (item == null) continue;
                data.add(item);
            }
        }
        if ((valueChoices = selectMany.getValueChoices()) != null) {
            for (Object next : valueChoices) {
                String value;
                String string = value = next == null ? null : (String)itemLabelConverter.convert(next);
                if (value == null) continue;
                TableItem item = new TableItem(table, 0);
                item.setData((Object)value);
                item.setText(value);
                item.setChecked(data.contains(value));
            }
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem && e.detail == 32) {
                    TableItem source = (TableItem)e.item;
                    if (source != null && source.getData() != null) {
                        if (source.getChecked()) {
                            data.add(source.getData());
                        } else {
                            data.remove(source.getData());
                        }
                    }
                    CommandController controller = page.getController();
                    controller.setValueFor(inputName, (Object)data);
                }
            }
        });
        Composite buttons = new Composite(groupPanel, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(66));
        Button selectAllButton = new Button(buttons, 8);
        table.setData(SELECT_ALL_BUTTON_DATA_KEY, (Object)selectAllButton);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText("Select All");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (!item.getChecked()) {
                        item.setChecked(true);
                        CheckboxTableControlBuilder.this.notifySelectionChange(table, item);
                    }
                    ++n2;
                }
            }
        });
        Button selectNoneButton = new Button(buttons, 8);
        table.setData(SELECT_NONE_BUTTON_DATA_KEY, (Object)selectNoneButton);
        selectNoneButton.setLayoutData((Object)new GridData(768));
        selectNoneButton.setText("Select None");
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        item.setChecked(false);
                        CheckboxTableControlBuilder.this.notifySelectionChange(table, item);
                    }
                    ++n2;
                }
            }
        });
        this.setEnabled(table, input.isEnabled());
        return table;
    }

    @Override
    public Control[] getModifiableControlsFor(Table control) {
        return new Control[]{control};
    }

    private void notifySelectionChange(Table table, TableItem item) {
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        table.notifyListeners(13, event);
    }

    @Override
    protected Class<?> getProducedType() {
        return Object.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.CHECKBOX";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UISelectMany.class};
    }

    @Override
    public void updateState(Table control, InputComponent<?, ?> input) {
        if (!TABLE_STATUS_CHANGE.add(control)) {
            return;
        }
        try {
            super.updateState(control, input);
            this.updateValues(control, input);
        }
        finally {
            TABLE_STATUS_CHANGE.remove(control);
        }
    }

    @Override
    public void setEnabled(Table control, boolean enabled) {
        control.setEnabled(enabled);
        Button selectAllButton = (Button)control.getData(SELECT_ALL_BUTTON_DATA_KEY);
        selectAllButton.setEnabled(enabled);
        Button selectNoneButton = (Button)control.getData(SELECT_NONE_BUTTON_DATA_KEY);
        selectNoneButton.setEnabled(enabled);
    }

    private void updateValues(Table table, InputComponent<?, ?> input) {
        Object[] oldItems;
        UISelectMany selectMany = (UISelectMany)input;
        Iterable valueChoices = selectMany.getValueChoices();
        if (valueChoices == null) {
            return;
        }
        ArrayList<String> newItems = new ArrayList<String>();
        Converter<Object, String> converter = this.getConverter((UISelectMany<Object>)selectMany);
        for (Object choice : valueChoices) {
            String itemLabel = (String)converter.convert(choice);
            if (itemLabel == null) continue;
            newItems.add(itemLabel);
        }
        int newSize = newItems.size();
        Object[] newItemsArray = newItems.toArray(new String[newSize]);
        if (!Arrays.equals(newItemsArray, oldItems = this.extractData(table.getItems()))) {
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    item.setChecked(false);
                    this.notifySelectionChange(table, item);
                }
                ++n2;
            }
            table.removeAll();
            Set<String> data = this.getInputValue((UISelectMany<Object>)selectMany, converter);
            Object[] objectArray = newItemsArray;
            int n3 = newItemsArray.length;
            n = 0;
            while (n < n3) {
                Object newItem = objectArray[n];
                TableItem item = new TableItem(table, 0);
                item.setData(newItem);
                item.setText((String)newItem);
                item.setChecked(data.contains(newItem));
                ++n;
            }
        }
    }

    private Set<String> getInputValue(UISelectMany<Object> selectMany, Converter<Object, String> converter) {
        LinkedHashSet<String> data = new LinkedHashSet<String>();
        Iterable defaultValues = selectMany.getValue();
        if (defaultValues != null) {
            for (Object object : defaultValues) {
                String item = (String)converter.convert(object);
                if (item == null) continue;
                data.add(item);
            }
        }
        return data;
    }

    private String[] extractData(TableItem[] items) {
        int length = items.length;
        String[] data = new String[length];
        int i = 0;
        while (i < length) {
            data[i] = items[i].getText();
            ++i;
        }
        return data;
    }

    private Converter<Object, String> getConverter(UISelectMany<Object> selectMany) {
        return InputComponents.getItemLabelConverter((ConverterFactory)FurnaceService.INSTANCE.getConverterFactory(), selectMany);
    }
}

