/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.context;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.furnace.util.Assert;

public class UISelectionImpl<T>
implements UISelection<T> {
    private final List<T> selection;
    private IResource resource;

    public UISelectionImpl(List<T> selection, IStructuredSelection ss) {
        Assert.notNull(selection, (String)"Selection must not be null.");
        this.selection = Collections.unmodifiableList(selection);
        this.resource = this.extractSelection(ss);
    }

    public T get() {
        return this.selection.isEmpty() ? null : (T)this.selection.get(0);
    }

    public Iterator<T> iterator() {
        return this.selection.iterator();
    }

    public int size() {
        return this.selection.size();
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public IResource getResource() {
        return this.resource;
    }

    private IResource extractSelection(IStructuredSelection ss) {
        if (ss == null) {
            return null;
        }
        Object element = ss.getFirstElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)element;
        Object adapter = adaptable.getAdapter(IResource.class);
        return (IResource)adapter;
    }
}

