/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetPreInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;

public class SeamDSXMLWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.jboss.tools.seam.ui.wizard.SeamDSXMLWizard";
    WizardNewDSXMLFileCreationPage mainPage;
    private boolean fOpenEditorOnFinish;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewDSXMLFileCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle("New DS XML");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        if (this.fOpenEditorOnFinish) {
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
            }
        }
        return true;
    }

    private Object getConnectionProfileDefaultValue() {
        String defaultDs = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.facet.default.conn.profile");
        return SeamDSXMLWizard.getConnectionProfileNameList().contains(defaultDs) ? defaultDs : "";
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    class WizardNewDSXMLFileCreationPage
    extends WizardNewFileCreationPage {
        private IFieldEditor connProfileSelEditor;

        public WizardNewDSXMLFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        protected InputStream getInitialContents() {
            Object connection = this.connProfileSelEditor.getValue();
            IPath containerPath = this.getContainerFullPath();
            IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getFolder(containerPath).getProject();
            SeamProjectsSet set = new SeamProjectsSet(currentProject);
            IProject project = set.getWarProject();
            if (project == null) {
                return null;
            }
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject == null) {
                return null;
            }
            SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamProject.getRuntimeName());
            String seamHomePath = seamRuntime.getHomeDir();
            File dataSourceDsFile = new File(String.valueOf(seamHomePath) + "/seam-gen/resources/datasource-ds.xml");
            FilterSetCollection viewFilterSetCollection = new FilterSetCollection();
            SeamFacetInstallDataModelProvider provider = new SeamFacetInstallDataModelProvider();
            IDataModel model = (IDataModel)provider.create();
            model.setProperty("project.name", (Object)project.getName());
            model.setProperty("seam.project.connection.profile", connection);
            IConnectionProfile connProfile = ProfileManager.getInstance().getProfileByName(connection.toString());
            if (connProfile == null) {
                return null;
            }
            try {
                new SeamFacetPreInstallDelegate().execute(project, null, (Object)model, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                SeamCorePlugin.getDefault().logError((Throwable)e);
                return null;
            }
            FilterSet jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet((IDataModel)model);
            FilterSet projectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet((IDataModel)model);
            viewFilterSetCollection.addFilterSet(jdbcFilterSet);
            viewFilterSetCollection.addFilterSet(projectFilterSet);
            try {
                StringResource sr = new StringResource();
                ResourceUtils.copyResource((Resource)new FileResource(dataSourceDsFile), (Resource)sr, (FilterSetCollection)viewFilterSetCollection, null, (boolean)true, (boolean)false, (boolean)false, null, null, null, (boolean)false);
                return sr.getInputStream();
            }
            catch (IOException e) {
                SeamCorePlugin.getDefault().logError((Throwable)e);
                return null;
            }
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite topLevel = (Composite)this.getControl();
            this.connProfileSelEditor = SeamWizardFactory.createConnectionProfileSelectionFieldEditor(SeamDSXMLWizard.this.getConnectionProfileDefaultValue(), new IValidator(){

                public Map<String, IStatus> validate(Object value, Object context) {
                    WizardNewDSXMLFileCreationPage.this.validatePage();
                    return SeamValidatorFactory.NO_ERRORS;
                }
            });
            Composite q = new Composite(topLevel, 0);
            GridLayout l = new GridLayout(4, false);
            q.setLayout((Layout)l);
            this.connProfileSelEditor.doFillIntoGrid((Object)q);
            this.validatePage();
        }
    }
}

