/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.jboss.tools.seam.ui.search.SeamSearchResult;
import org.jboss.tools.seam.ui.search.SeamSearchResultPage;

public class SeamTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private SeamSearchResultPage fPage;
    private AbstractTextSearchResult fResult;

    public SeamTableContentProvider(SeamSearchResultPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof SeamSearchResult) {
            int elementLimit = this.getElementLimit();
            Object[] elements = ((SeamSearchResult)((Object)inputElement)).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof SeamSearchResult) {
            this.fResult = (SeamSearchResult)((Object)newInput);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = this.getElementLimit();
        boolean tableLimited = elementLimit != -1;
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    public void clear() {
        this.getViewer().refresh();
    }
}

