/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.EditorOpener;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.internal.ui.text.NewTextSearchActionGroup;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.OpenSearchPreferencesAction;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.seam.core.IOpenableElement;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.search.SeamSearchViewLabelProvider;
import org.jboss.tools.seam.ui.search.SeamTableContentProvider;
import org.jboss.tools.seam.ui.search.SeamTreeContentProvider;

public class SeamSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private static final String KEY_LIMIT = "org.eclipse.search.resultpage.limit";
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private EditorOpener fEditorOpener = new EditorOpener();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public SeamSearchResultPage() {
        this.setElementLimit(new Integer(1000));
    }

    public void setElementLimit(Integer elementLimit) {
        super.setElementLimit(elementLimit);
        int limit = elementLimit;
        this.getSettings().put(KEY_LIMIT, limit);
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        SeamSearchViewLabelProvider innerLabelProvider = new SeamSearchViewLabelProvider(this, 2);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new SeamTableContentProvider(this));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        SeamSearchViewLabelProvider innerLabelProvider = new SeamSearchViewLabelProvider(this, 2);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new SeamTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        if (match.getElement() instanceof IJavaSourceReference) {
            IMember javaElement = ((IJavaSourceReference)match.getElement()).getSourceMember();
            try {
                IEditorPart part = JavaUI.openInEditor((IJavaElement)javaElement);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)javaElement);
                }
            }
            catch (JavaModelException e) {
                SeamGuiPlugin.getDefault().logError(e);
            }
        } else if (match.getElement() instanceof IOpenableElement) {
            ((IOpenableElement)match.getElement()).open();
        } else if (match.getElement() instanceof IFile) {
            IFile file = (IFile)match.getElement();
            IEditorPart editor = this.fEditorOpener.open(this.getSite().getPage(), file, activate);
            offset = match.getOffset();
            length = match.getLength();
            if (offset != 0 && length != 0) {
                if (editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    textEditor.selectAndReveal(offset, length);
                } else if (editor != null) {
                    this.showWithMarker(editor, file, offset, length);
                }
            }
        } else if (match.getElement() instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)match.getElement();
            try {
                IEditorPart part = JavaUI.openInEditor((IJavaElement)javaElement);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)javaElement);
                }
            }
            catch (JavaModelException e) {
                SeamGuiPlugin.getDefault().logError(e);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        IMarker marker = null;
        try {
            try {
                marker = file.createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
                attributes.put("charStart", new Integer(offset));
                attributes.put("charEnd", new Integer(offset + length));
                marker.setAttributes(attributes);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
            catch (CoreException e) {
                throw new PartInitException(SearchMessages.FileSearchPage_error_marker, (Throwable)e);
            }
        }
        finally {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    SeamGuiPlugin.getDefault().logError(e);
                }
            }
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {}
        int elementLimit = 1000;
        try {
            elementLimit = this.getSettings().getInt(KEY_LIMIT);
        }
        catch (NumberFormatException numberFormatException) {}
        if (memento != null) {
            Integer value = memento.getInteger(KEY_SORTING);
            if (value != null) {
                this.fCurrentSortOrder = value;
            }
            if ((value = memento.getInteger(KEY_LIMIT)) != null) {
                elementLimit = value;
            }
        }
        this.setElementLimit(new Integer(elementLimit));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        memento.putInteger(KEY_LIMIT, this.getElementLimit().intValue());
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            int fileCount;
            int itemCount;
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null && (itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length) < (fileCount = this.getInput().getElements().length)) {
                String format = SearchMessages.FileSearchPage_limited_format_files;
                return Messages.format((String)format, (Object[])new Object[]{label, new Integer(itemCount), new Integer(fileCount)});
            }
        }
        return label;
    }

    static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }

    public static class ResourceTransferDragAdapter
    extends DragSourceAdapter
    implements TransferDragSourceListener {
        private ISelectionProvider fProvider;

        public ResourceTransferDragAdapter(ISelectionProvider provider) {
            this.fProvider = provider;
            Assert.isNotNull((Object)this.fProvider);
        }

        public Transfer getTransfer() {
            return ResourceTransfer.getInstance();
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = !this.convertSelection().isEmpty();
        }

        public void dragSetData(DragSourceEvent event) {
            List resources = this.convertSelection();
            event.data = resources.toArray(new IResource[resources.size()]);
        }

        public void dragFinished(DragSourceEvent event) {
            if (!event.doit) {
                return;
            }
        }

        private List convertSelection() {
            ISelection s = this.fProvider.getSelection();
            if (!(s instanceof IStructuredSelection)) {
                return Collections.EMPTY_LIST;
            }
            IStructuredSelection selection = (IStructuredSelection)s;
            ArrayList result = new ArrayList(selection.size());
            for (Object element : selection) {
                if (!(element instanceof IResource)) continue;
                result.add(element);
            }
            return result;
        }
    }
}

