/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public class SeamJavaSearchRequestor
extends SearchRequestor {
    private ISearchRequestor fJavaRequestor = null;

    public SeamJavaSearchRequestor() {
    }

    public SeamJavaSearchRequestor(ISearchRequestor javaRequestor) {
        this.fJavaRequestor = javaRequestor;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }

    protected void addSearchMatch(IDocument document, IFile file, int start, int end, String text) {
        if (!file.exists()) {
            return;
        }
        int lineNumber = -1;
        try {
            lineNumber = document.getLineOfOffset(start);
        }
        catch (BadLocationException e) {
            SeamGuiPlugin.getPluginLog().logError("offset: " + Integer.toString(start), (Throwable)e);
        }
        this.createSearchMarker(file, start, end, lineNumber);
        if (this.fJavaRequestor != null) {
            Match match = new Match((Object)file, start, end - start);
            this.fJavaRequestor.reportMatch(match);
        }
    }

    private void createSearchMarker(IFile file, int start, int end, int lineNumber) {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(start));
            attributes.put("charEnd", new Integer(end));
            attributes.put("lineNumber", new Integer(lineNumber));
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

