/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.seam.internal.fixes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.fixes.AbstractRuntimeFix;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;
import org.jboss.tools.project.examples.seam.internal.Messages;
import org.jboss.tools.project.examples.seam.internal.SeamProjectExamplesActivator;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.osgi.service.prefs.BackingStoreException;

public class SeamRuntimeFix
extends AbstractRuntimeFix {
    SeamRuntimeFix(ProjectExample project, RequirementModel requirement) {
        super(project, requirement);
    }

    private SeamRuntime getBestRuntime() {
        Collection<String> allowedVersions = this.getAllowedVersions();
        if (allowedVersions.isEmpty()) {
            SeamProjectExamplesActivator.log(NLS.bind((String)Messages.SeamRuntimeFix_Invalid_seam_runtime_fix, (Object)this.project.getName()));
            return null;
        }
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        if (seamRuntimes == null || seamRuntimes.length == 0) {
            return null;
        }
        if ("any".equals(allowedVersions.iterator().next())) {
            return seamRuntimes[0];
        }
        for (String allowedVersion : allowedVersions) {
            SeamRuntime[] seamRuntimeArray = seamRuntimes;
            int n = seamRuntimes.length;
            int n2 = 0;
            while (n2 < n) {
                SeamRuntime seamRuntime = seamRuntimeArray[n2];
                if (seamRuntime.getVersion().toString().equals(allowedVersion.substring(0, 3))) {
                    return seamRuntime;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean fix(IProgressMonitor monitor) {
        IProject[] offsprings = ProjectExamplesActivator.getEclipseProject((ProjectExample)this.project, (RequirementModel)this.requirement);
        if (offsprings.length == 0) {
            return false;
        }
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        SeamRuntime bestRuntime = this.getBestRuntime();
        boolean ret = true;
        IProject[] iProjectArray = offsprings;
        int n = offsprings.length;
        int n2 = 0;
        while (n2 < n) {
            IProject eclipseProject = iProjectArray[n2];
            if (!this.fix(eclipseProject, seamRuntimes, bestRuntime)) {
                ret = false;
            }
            ++n2;
        }
        return ret;
    }

    private boolean fix(IProject eclipseProject, SeamRuntime[] seamRuntimes, SeamRuntime bestRuntime) {
        IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)eclipseProject);
        String seamRuntimeName = prefs.get("seam.runtime.name", null);
        if (seamRuntimeName != null) {
            SeamRuntime[] seamRuntimeArray = seamRuntimes;
            int n = seamRuntimes.length;
            int n2 = 0;
            while (n2 < n) {
                SeamRuntime seamRuntime = seamRuntimeArray[n2];
                if (seamRuntimeName.equals(seamRuntime.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        if (bestRuntime != null) {
            prefs.put("seam.runtime.name", bestRuntime.getName());
            try {
                prefs.flush();
                return true;
            }
            catch (BackingStoreException e) {
                SeamProjectExamplesActivator.log(e);
            }
        }
        return false;
    }

    public Collection<String> getAllowedVersions() {
        return this.splitProperty("allowed-versions");
    }

    public boolean isSatisfied() {
        return this.getBestRuntime() != null;
    }

    public String getDownloadId() {
        return (String)this.requirement.getProperties().get("downloadId");
    }

    public List<DownloadRuntime> getDownloadRuntimes(IProgressMonitor monitor) {
        DownloadRuntime dr;
        String downloadId = this.getDownloadId();
        if (downloadId != null && !downloadId.trim().isEmpty() && (dr = RuntimeCoreActivator.getDefault().findDownloadRuntime(downloadId, monitor)) != null) {
            return Collections.singletonList(dr);
        }
        return Collections.emptyList();
    }
}

